/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------
  Definitions / Declarations
  --------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#define errorwin 0

#include <stdarg.h>
#include <ctype.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <string.h>
#include <dos.h>
#include <time.h>
#include <fcntl.h>
#include <bios.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <process.h>
#include <direct.h>
#include <signal.h>
#include <setjmp.h>

#define _WDTIME 60
#define _DOSTIME 30*60

#define _MAXTNCPORTS 80
#define _MAXVIDEOPORTS 8
#define _MAXWINDOWS 11

#define OS "(DOS)"
#define version "3.14.70sb"
#define initmsg "DVMS V"version" "OS" (C) 1992-2004 by Deti Fliegl"
#define CTEXT "DVMS V"version" "OS" "

#ifdef __MSDOS__
#define _SMALL 1024
#define _MED   2048
#define _BIG   4096
#endif


#define mainwin   0
#define dvmswin   1
#define timewin   2
#define systwin   3
#define sigwin    4
#define dtmfwin   5
#define dcfwin    6
#define filewin   7
#define irqwin    8
#define userwin   9
#define keybwin   10

typedef int BOOL;

#define defaultwin keybwin

#define SQ_BIT    128
#define CALL_BIT   32
#define DTMF_STB   16

#define	DCF_BIT    64

#ifndef MK_FP
  #define MK_FP(seg,ofs) \
  ((void far *) (((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#endif

#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif

#ifdef __cplusplus
   typedef void (*fptr)(int);
#else
   typedef void (*fptr)();
#endif

#define _DVMSININAME  "dvms.ini"
#define _PWDININAME  "passwd.ini"
#define _ADCININAME  "dvms_adc.ini"
#define _ADCPARNAME  "dvms_adc.par"
#define _CRONTABNAME "crontab.ini"
#define _LISTNAME "list"
#define _STATNAME "fwdstat"

#define _MEM 32768
#define _IRQ_CACHE 8192
#define _AUDIO_MIN 2
#define _CTRLZ 26
#define _IRQ_PRIO 1
#define _MAXFWDPS  30
#define _TIMEOUT   300L
#define _FWDSSID   4
#define _MAXBEACON 4

#define _CFGSIGNAL 4
#define _CFGTIME   8
#define _CFGSIGINV 0x10
#define _CFGMSGOFF 0x20
#define _CFGBBSON  0x40
#define _CFGSUBSQ  0x80
#define _CFGSQDIS  0x100


#define _MSGID_EXPORT    256
#define _MSGID_SYSTEM    128
#define _MSGID_PRIV      64
#define _MSGID_GROUP     32
#define _MSGID_BBS       16
#define _MSGID_USER      8
#define _MSGID_NAME      4
#define _MSGID_DTMF      2
#define _MSGID_DELETE    1

#define _MSGST_COPY      256
#define _MSGST_UNREAD    128
#define _MSGST_READ      64
#define _MSGST_EXTHEADER 32
#define _MSGST_TRANSFER  16
#define _MSGST_DIDAUTO   4
#define _MSGST_AUTOREP   2
#define _MSGST_DELETED   1

#define _USRST_PRMSG     512
#define _USRST_ASKSEND   256
#define _USRST_PROTECT   128
#define _USRST_SPKTIME   64
#define _USRST_SPKDATE   32
#define _USRST_SPKNAME   16
#define _USRST_SPKNUM    8
#define _USRST_PROTAMP   4
#define _USRST_DIALEKT2  3
#define _USRST_DIALEKT1  2
#define _USRST_FEMALE    1
#define _USRST_MALE      0

#define _USRID_SYSOP     128
#define _USRID_USER      8

#define _USER_ONLY 1
#define _BBS_ONLY  2
#define _NO_CTCSS  4

#define TRUE  1
#define FALSE 0

#define _rsc     3
#define _report  2
#define _serious 1
#define _fatal   0

#define idletime() (time(NULL)-delstart)

#define _MAXMYCALLS 4
#define _MAXSYSP 3

typedef struct config {
    unsigned long max_msg_length;
    unsigned long max_msg_fwd_length;

    unsigned iobase;
    unsigned irq;

    unsigned rzz;
    unsigned config;
    unsigned sq_wait;
    unsigned sq_sens;
    unsigned sq_inv;
    unsigned tx_hold;
    unsigned tx_retrig;
    unsigned dtmf_timeout;
    unsigned inp_timeout;
    unsigned repeater;
    unsigned system_state;

    unsigned cmd_wait;
    unsigned sig_min;
    unsigned sig_inv;
    unsigned unum_min;
    unsigned endcut;
    unsigned sysop_num;
    int      sysop_tone;
    unsigned warn;
    unsigned tout;
    unsigned max_pause;
    unsigned max_msg_days;
    unsigned hrd_msg_days;
    unsigned max_usr_days;
    unsigned dcf_used;
    unsigned afswitch;
    unsigned lpt;
    unsigned subwait;
    unsigned ctcss_gain;
    int      ctcss_open;
    unsigned nouser_list;
    unsigned loglevel;
    unsigned beacon;
    unsigned scrsave;
    int      utcoffset;
    //unsigned ssid;
    unsigned mycalls;
    unsigned defuprefs;
    unsigned adc_combase;

    long default_srate;
    long fwd_srate;
    long tone;
    long subout;
    long adcmaxsamples;

    char sysp[_MAXSYSP][_MAX_PATH];
    char usrp[_MAX_PATH];
    char msgp[_MAX_PATH];
    char tmppath[_MAX_PATH];

    char mycall[_MAXMYCALLS][20];
    char boxaddress[81];
    char boxheader[41];
    char statsend[41];
    char statsubj[81];
    char call[81];
    char remote_switch[17];
    char sysop_code[17];

    char sbvol;
    char level_in;
    char level_mic;
    char level_out;
    char level_voc;
    char level_cw;
}config_t;

typedef struct MSG_INFO
{
  char Filename[14];
  unsigned int  Id;
  unsigned int  State;
  time_t         Unixtime;
  unsigned int  Usender;
  unsigned int  Ureceiver;
  unsigned long Length;
  unsigned int  Srate;
  unsigned int  Days;
  unsigned int  Custom1;
  unsigned int  Custom2;
  char Info[16];
  char extend[64];
  unsigned Crc;
} msg_info_t;

#define _FWDPOLL 0x8000000

typedef struct fwdpartner
{
  char p[31];
  char c[51];
  unsigned long f;
}fwdpartner_t;

#include "adc_box.h"
#include "tasking.h"
#include "writelog.h"
#include "dvmsrdwr.h"
#include "dvmsrams.h"
#include "tnclow.h"
#include "window.h"

extern int alt,call_count,call_state,ctcss,
           dcf_enable,dcf_ok,
           mono,ptt_state,ulogin,usr_upd,vmode,
           warn_flag,WD_enable,winok;

extern long timer(void);
extern unsigned maxtones;
extern long location,rem,srate;
extern long ctcss_tone[];
extern unsigned lpt;
extern unsigned long s_meter,sig_count;
extern char cronplay,dcfmon,doreset,err,flex,fx805,ignore,rogersema,
            sema,skiphwcheck,usesb16;
extern char *days[],*indos,*prozname[],*puffer,*screen;
extern char cw[80],dtmf[20],dosscreen[80],exep[80],startpath[80],sysp[80];
extern struct text_info ti[_MAXWINDOWS];
extern adc_cfg_t adc_cfg[8];
extern config_t cfg;
extern fwdpartner_t fwdp[_MAXFWDPS];
extern time_t delstart,dtmfstart,startup;
extern msg_info_t File_Info,User_Info;
extern struct dostime_t  dtime[3];
extern struct dosdate_t  ddate[3];
extern void (far *reset)(void);
