/***************************************************************

  DVMS            Digital Voice Mailbox System
  VTGEN
  SERV

  ------------------------------------------------
  DOS-shell for packet radio usage
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/
#ifdef __MSDOS__
#ifdef DVMS
#include "dvms.h"
#include "dvmsirq.h"
#endif
#ifdef VTGEN
#include "vtgen.h"
#include "vtdcf.h"
#endif

#include "util.h"
#include "window.h"


#define L2STK 500


static char stack[L2STK];
static int chr=0;
static unsigned sps,sss;
static void interrupt(*int10_old)(...);
static void interrupt(*int16_old)(...);
static void interrupt(*int29_old)(...);

/*                    0    1    2    3    4    5    6    7    8    9*/
static
char keytab[256]= {   0,   0,   0,   0,   0,   0,   0,   0,   0,0x0f,
       0x1c,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,0x39,0x02,0x01,0x2B,0x05,0x06,0x07,0x28,
       0x09,0x0A,0x1B,0x1B,0x33,0x35,0x34,0x08,0x0B,0x02,
       0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x34,0x33,
       0x56,0x0B,0x56,0x0C,0x10,0x1E,0x30,0x2E,0x20,0x12,
       0x21,0x22,0x23,0x17,0x24,0x25,0x26,0x32,0x31,0x18,
       0x19,0x10,0x13,0x1F,0x14,0x16,0x2F,0x11,0x2D,0x2c,
       0x15,0x09,0x0C,0x0A,0x07,0x35,0x29,0x1E,0x30,0x2E,

       0x20,0x12,0x21,0x22,0x23,0x17,0x24,0x25,0x26,0x32, /*100*/
       0x31,0x18,0x19,0x10,0x13,0x1F,0x14,0x16,0x2F,0x11,
       0x2D,0x2c,0x15,0x08,0x56,0x0B,   0,   0,   0,0x1a,
          0,   0,0x28,   0,   0,   0,   0,   0,   0,   0,
          0,   0,0x28,   0,   0,   0,   0,   0,0x27,   0,
          0,   0,   0,0x27,0x1a,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,

          0,   0,   0,   0,   0,   0,   0,   0,   0,   0, /*200*/
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,0x0c,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0
  };

static void near get(void)
{ sss=_SS;
  sps=_SP;
  _SS=FP_SEG(stack+L2STK);
  _SP=FP_OFF(stack+L2STK);
  if(chr==EOF)
      chr=tget(0);
  _SS=sss;
  _SP=sps;
}

#pragma argsused
static void interrupt int16_handler(unsigned bp,unsigned di,unsigned si,unsigned ds,
      unsigned es,unsigned dx,unsigned cx,unsigned bx,
      unsigned ax,unsigned ip,unsigned cs,unsigned flags)
{ switch((ax>>8)&15)
  { case 0: while(chr==EOF) get();
      ax=chr|(unsigned)(keytab[chr]<<8);
      chr=EOF;
      break;
    case 1: get();
      if(chr==EOF)
      { flags|=64;
        ax=0;
      }
      else
      { flags&=(0xffff-64);
        ax=chr|(unsigned)(keytab[chr]<<8);
      }
  }
}

static void near put(unsigned char c)
{  static unsigned char cc;
    cc = c;
  sss=_SS;
  sps=_SP;
  _SS=FP_SEG(stack+L2STK);
  _SP=FP_OFF(stack+L2STK);
  enable();
  while(!tnc_putfree());
  if(cc && (cc!=10))
    tnc_put(cc);
  _SS=sss;
  _SP=sps;
}

static char in_29;  // Flag das anzeigt dass Int10 von Int29 benutzt wird,
                    // das ist so wenn kein Zeichentreiber geladen ist

#pragma argsused
static void interrupt int10_handler(unsigned bp,unsigned di,unsigned si,unsigned ds,
      unsigned es,unsigned dx,unsigned cx,unsigned bx,
      unsigned ax,unsigned ip,unsigned cs,unsigned flags)
{  if (!in_29)
    if ((ax>>8)==0xe)
      put(ax & 255);
  _chain_intr(int10_old);
}

#pragma argsused
static void interrupt int29_handler(unsigned bp,unsigned di,unsigned si,unsigned ds,
      unsigned es,unsigned dx,unsigned cx,unsigned bx,
      unsigned ax,unsigned ip,unsigned cs,unsigned flags)
{ ++in_29;
  _AX = ax;
  int29_old();
  in_29 = 0;
  put(ax & 255);
}

void oshell(char *befbuf,int mode)
{ char memlow=0,scr[80];
  tcb_t *tcb=get_tcb(get_firsttask());

  scr[0]=0;
  storescr(scr);
  textmode(vmode);
  _setcursortype(_NORMALCURSOR);
  retrscr(dosscreen);
  remove(dosscreen);
  dosscreen[0]=0;

  do
  { if(tcb->type&_TNCPROC)
      l2_bef(18,tcb->tty);
  }
  while((tcb=tcb->next)!=NULL);

  if(mode)
  {  int29_old=getvect(0x29);
    int16_old=getvect(0x16);
    int10_old=getvect(0x10);
    chr=EOF;
    setvect(0x29,(void interrupt (*)(...))int29_handler);
    setvect(0x16,(void interrupt (*)(...))int16_handler);
    setvect(0x10,(void interrupt (*)(...))int10_handler);
  }

  set_wd(_DOSTIME);

  if(*befbuf)
  {  if(system(befbuf)==-1)
      memlow=1;
  }
  else
  { char *commandcom=getenv("COMSPEC");
    if(commandcom==NULL)
      commandcom="command";
    printf("\nType EXIT to return to "CTEXT);
    if(system(commandcom)==-1)
      memlow=1;
  }

  set_wd(_WDTIME);

  if(mode)
  {  setvect(0x10,int10_old);
    setvect(0x16,int16_old);
    setvect(0x29,int29_old);
  }
  xchdir(startpath);
  storescr(dosscreen);
  if((get_tcb()->type&_CONSOLE)&&*befbuf&&!memlow)
  { printf("\n-- press a key --");
    getch();
  }
  textmode(C80);
  textmode(ti[0].currmode);
  retrscr(scr);
  remove(scr);

  _setcursortype(_NOCURSOR);

  if(memlow)
  if((get_tcb()->type&_CONSOLE)||(get_tcb()->type&_TNCPROC))
    putf("can't execute - low memory!\r");
  else
    write_log(_serious,"dosexit","low memory %s",befbuf);

  _AX=0x0b00;
  _BX=BLUE;
  geninterrupt(0x10);
}

#endif