/***************************************************************

  DVMS            Digital Voice Mailbox System
  INSTALL

  ------------------------------------------------
  critical error handling
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/
#ifdef __MSDOS__

#ifdef DVMS
#include "dvms.h"
#else
#include "vtgen.h"
#endif


#define IGNORE  0
#define RETRY   1
#define ABORT   2


#ifdef INSTALL
  int critical_error=0;
  static char *err_msg[]=
  {   "Write Protect",
    "Unknown Device",
    "Drive not ready",
    "Unknown Command",
    "Data Error (CRC)",
    "Wrong length",
    "Search Error",
    "Medium unknown",
    "Sector not found",
    "Paper out",
    "Write Error",
    "Read Error",
    "General Failure Error",
    "Unknown",
    "Unknown",
    "Disk changed"
  };


  int error_win(char *geraet,char *msg)
  {  int retval;
    sound(500);
    delay(100);
    nosound();

    if(critical_error) return IGNORE;
    win(errorwin,20,9,30,3,"Critical Error",0x4f);
    clrscr();
    cprintf("%s\n\r",geraet);
    cprintf("%s\n\r",msg);
    cprintf("(A)bort, (R)etry, (I)gnore?");

    while(1)
    { retval= getch();
      if (retval=='a' || retval=='A' || retval==0x1b || retval==13)
      { retval = IGNORE;
        critical_error=TRUE;
        break;
      }
      if (retval == 'r' || retval == 'R')
      { retval = RETRY;
        break;
      }
      if (retval == 'i' || retval == 'I')
      { retval = IGNORE;
        break;
      }
    }
    window(1,1,80,25);
    attr(7);
    return(retval);
  }

  #pragma argsused
  int crit_handler(int errval,int ax,int bp,int si)
  {
    char msg[40];
    char geraet[40];
    unsigned di;
    int drive;
    int errorno;

    di= _DI;
    drive = ax & 0x00FF;
    errorno = di & 0x00FF;
    if(ax>0)
      sprintf(geraet,"Error at Drive %c:",'A' + drive);
    else
      strcpy(geraet,"Device Error");
    sprintf(msg,"%s",err_msg[errorno]);
    hardresume(error_win(geraet,msg));
    return ABORT;
  }
#endif
#if defined DVMS || defined VTGEN
  int error_win()
  {
    return IGNORE;
  }
  #pragma argsused
  int crit_handler(int errval,int ax,int bp,int si)
  {
    hardresume(error_win());
    return ABORT;
  }
#endif
#endif