/***************************************************************

  DVMS            Digital Voice Mailbox System
  SERV
  VTGEN

  ------------------------------------------------
  A/D functions for 8 channel 10-bit A/D-converter
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#ifdef DVMS
#include "dvms.h"
#include "dvmscmd.h"
#include "dvmstime.h"
#endif
#ifdef VTGEN
#include "vtgen.h"
#endif

#include "util.h"

#define MAXAD 4095//1023L

void adcsema(unsigned s)
{ static sema=0;
  if(s)
  {  while(sema)
      suspend(1);
    sema=1;
  }
  else
    sema=0;
}

#ifdef __MSDOS__
int ADC::datin(void)
{
  return !((inp(cfg.adc_combase+6)&16)/16);
}
void near ADC::datout (int data)
{
  if (!data)
    outp(cfg.adc_combase+4,inp(cfg.adc_combase+4)&0xfd);
  else
    outp(cfg.adc_combase+4,inp(cfg.adc_combase+4)|2);
}

void near ADC::sclk (int data)
{
  int i;
  for(i=0;i<50;i++);
  if (!data)
    outp(cfg.adc_combase+4,inp(cfg.adc_combase+4)&0xfe);
  else
    outp(cfg.adc_combase+4,inp(cfg.adc_combase+4)|1);
}
#endif

unsigned ADC::getanalog (int channel)
{
  static unsigned sel_chan[8]=
  {  0x0f70 + 1,0x0f70 + 3,0x0f70 + 9,0x0f70 + 11,
     0x0f70 + 5,0x0f70 + 7,0x0f70 + 13,0x0f70 + 15};
  unsigned i,ad=0;


  if((channel<0) || (channel >7))
    channel=0;

   for(i=0;i<12;i++)
   { ADC::sclk(0);
     ADC::datout(sel_chan[channel]&(1<<i));
     ADC::sclk(1);
     //ad|=(ADC::datin()*(512>>i));
     /* liefert natuerlich dann immer 4x so grosse Werte, egal welcher ADC */
     /* Ausgabewert waere aber unabhaeging von ADC-Typ */
     /* alle Sysops muessten ihre ADC ini's aendern */
     ad|=(ADC::datin()*(((MAXAD+1)/2)>>i));
     /* kann auch korrigiert werden, gibt dann aber unterschiedliche Werte */
     /* fuer jeden ADC-Typ */
     //if ((ad & 3) == 0) ad>>=2;
     /* Problem liesse sich mit Gleitkomma-Zahlen besser loesen */
     /* Division durch 4 koennte dann unabhaengig von ADC-Typ ohne */
     /* Genauigkeitsverlust durchgefuehrt werden */

   }
   ADC::datout(0);
   ADC::datout(1);
   //ad=2144;
   //ad=2132;
   //ad=2048;
   //ad=1944;
   return ad;
}
//#ifndef SERVICE
void write_adc(void)
{ adchist_t adchist;
  char *name=_ADCPARNAME;
  long where,maxsize=(cfg.adcmaxsamples*sizeof(adchist_t)+4);
  int port,f;
  adchist.adt=ad_time(NULL);
  ADC adc;

  adcsema(1);

  adc.getanalog(0);
  for(port=1;port<9;port++)
  { suspend(1);
    adchist.adc[port-1]=adc.getanalog(port);
  }

  if(access(name,0))
    f=topen(name,O_CREAT|O_BINARY|O_RDWR,S_IREAD|S_IWRITE);
  else
    f=topen(name,O_BINARY|O_RDWR,S_IREAD|S_IWRITE);

  if(f>0)
  { read(f,&where,(unsigned)sizeof(where));
    if((where>maxsize)||(filelength(f)!=maxsize))
    {  chsize(f,maxsize);
      lseek(f, 0L, SEEK_SET);
      where=0L;
      write(f,&where,(unsigned)sizeof(where));
    }
    else
    { where=(where+sizeof(adchist_t))%(maxsize-4);
      lseek(f,0,SEEK_SET);
      write(f,&where,(unsigned)sizeof(where));
    }

    lseek(f,where+4,SEEK_SET);

    write(f,&adchist,(unsigned)sizeof(adchist_t));
    tclose(f);
  }
  else
    write_log(_serious,"write_adc","topen error %s",name);
  adcsema(0);
}

static int read_adc(adcsample_t &sample,int port,long t,int mode)
{   /* mode min:-1
          max: 1
          med: 2
  */
  if((port>7) || (port<0))
    return 0;

  int f=topen(_ADCPARNAME,O_RDONLY|O_BINARY,S_IREAD|S_IWRITE);
  if(f>0)
  { adchist_t adchist;
    adcsample_t med,min,max;
    long i,hits=0,average,where,length=filelength(f)-4;

    read(f,&where,4);
    for(i=0;i<cfg.adcmaxsamples;i++)
    {  where=(where+sizeof(adchist_t))%length;
      lseek(f,where+4,SEEK_SET);
      read(f,&adchist,sizeof(adchist_t));
//      set_win(defaultwin);
//      cprintf("\r\n%ld %ld",where,adchist.adt);
      if(adchist.adt)
      if(!t||((ad_time(NULL)-adchist.adt)<=t))
      {  if(!hits)
        {  min.adc=max.adc=adchist.adc[port];
          min.adt=max.adt=med.adt=adchist.adt;
          average=adchist.adc[port]*1000L;
        }
        //cprintf("\r\n%u %u %u %u\r\n",min.adc,max.adc,med.adc,adchist.adc[port]);
        average=(hits*average+adchist.adc[port]*1000L)/(hits+1);
        hits++;
        if(adchist.adc[port]<=min.adc)
        {  min.adc=adchist.adc[port];
          if(min.adt<adchist.adt)
            min.adt=adchist.adt;
        }
        if(adchist.adc[port]>=max.adc)
        {  max.adc=adchist.adc[port];
          if(max.adt<adchist.adt)
            max.adt=adchist.adt;
        }
        if(!(hits%10))
          scheduler();
      }
    }
    tclose(f);

    if(!hits)
      return 0;

//    cprintf("\r\nmode%d min%u max%u med%u\r\n",mode,min.adc,max.adc,med.adc);

    switch(mode)
    {
      case -1:   sample=min;break;
      case  1:   sample=max;break;
      case  2:   med.adc=(unsigned)(average/1000L);
                sample=med;break;
    }
    return 1;
  }
  return 0;
}

int convadc(unsigned adc,int port,char *s)
{ long value,ohm,volt,r2ohm;
  s[0]=0;
  if(adc_cfg[port].type)
  {
//    adc=976;
//    cprintf("\r\nadc port %d %d\r\n",port,adc);
//    volt=(long)(((float)(adc_cfg[port].linear/1000.0)*(float)(adc_cfg[port].vref/1000.0)*(float)adc/1023.0+
 //        (float)(adc_cfg[port].constant/1000.0))*1000L);
    volt=(adc*((adc_cfg[port].vref*adc_cfg[port].linear)/MAXAD))/1000+
         adc_cfg[port].constant;//*1000;

//    if(adc!=1023)
//    {
//      ohm =(long)(( (float)(adc_cfg[port].r1teiler/1000.0)*(float)adc/(1023.0-(float)adc))*1000L);
//      r2ohm=(long) (( ((float)(ohm/1000.0)-(float)(adc_cfg[port].constant/1000.0))/(float)(adc_cfg[port].linear/1000.0))*1000L);
//    }
    if(adc!=MAXAD)
    {
      ohm  =((adc_cfg[port].r1teiler/10L)*adc)/(MAXAD-adc);
      r2ohm=((ohm-(adc_cfg[port].constant/10L))*10000L)/adc_cfg[port].linear;
    }
/*
    set_win(defaultwin);
    cprintf("\r\n volt[%ld] r2ohm[%ld] ohm[%ld] vref[%ld] lin[%ld] r1[%ld] const[%ld] %ld ",
    volt,r2ohm,ohm,
    adc_cfg[port].vref,adc_cfg[port].linear,adc_cfg[port].r1teiler,
    adc_cfg[port].constant,adc);
*/
    switch(adc_cfg[port].type)
    {
      case 1: value=volt;break;
      case 2: value=r2ohm;break;
    }

    sprintf(s,"%c%ld.%03ld",value<0?'-':' ',labs(value/1000L),labs(value%1000));

    switch(adc_cfg[port].prec)
    {
      case 0: strchr(s,'.')[0]=0;break;
      case 1: strchr(s,'.')[2]=0;break;
      case 2: strchr(s,'.')[3]=0;break;
    }
    return 1;
  }
  else
    return 0;
}

int get_value(long &when,int port,char *s,int mode)
{ long adc;
  ADC ad;
  adcsample_t sample;

  if((port<0)||(port>7))
    return 0;
  adcsema(1);
  if(!mode)
  {  adc=(long)ad.getanalog(port);
    suspend(1);
    adc=(long)ad.getanalog(port);
  }
  else
  {  if(!read_adc(sample,port,0L,mode))
     { adcsema(0);
       return 0;
     }
    adc=sample.adc;
    when=sample.adt;
  }
  adcsema(0);
  //adc=512;
  return convadc(adc,port,s);
}
//#endif
#ifdef DVMS
static int speak_analog(int port,int mode)
{ long when;
  char s[20],*t;
  long u;

  if(!get_value(when,port,s,mode))
    return 0;

  if(mode)
  { switch(mode)
    { case -1: if(adc_cfg[port].linear>=0)
                 t="MINIMUM.VMS";
               else
                 t="MAXIMUM.VMS";
                break;
      case  1: if(adc_cfg[port].linear<0)
                 t="MINIMUM.VMS";
               else
                 t="MAXIMUM.VMS";
                break;
      default:  t="AVERAGE.VMS";
    }

    rdplay(sysp,t);

  }
  else
    rdplay(sysp,adc_cfg[port].pretext);

  sscanf(s,"%ld.",&u);
  spknum(u);
  if((t=strchr(s,'.'))!=NULL)
    spkstr(t,1);

  rdplay(sysp,adc_cfg[port].postext);

  if(abs(mode)==1)
  { rdplay(sysp,"ADCFROM.VMS");
    location=0L;
    _ddate(when,1);
    playback(0L,location);
    location=0L;
    _ttime(when);
    playback(0L,location);
  }
  return 1;
}

void speak_adc(int port,char mode)
{
  speak_analog(port,0);
  switch(mode)
  {
    case '0': speak_analog(port,2);
              speak_analog(port,-1);
              speak_analog(port,1);break;
    case '1': speak_analog(port,2);break;
    case '2': speak_analog(port,-1);break;
    case '3': speak_analog(port,1);break;
  }
}

#endif

void show_adc(char *fstarg)
{
  int i,j;
  //#ifndef SERVICE
  if(strchr(fstarg,'d')==NULL)
  { putf("%s:\rDate  Time        1       2       3       4       5       6       7       8\r",_ADCPARNAME);
    int f=topen(_ADCPARNAME,O_RDONLY|O_BINARY,S_IREAD|S_IWRITE);
    if(f>0)
    { adchist_t adchist;
      long where,length=filelength(f)-4;
      char s[20],help[31],cmd[20];
      read(f,&where,4);
      for(i=0;i<cfg.adcmaxsamples;i++)
      { where=(where+sizeof(adchist_t))%length;
        lseek(f,where+4,SEEK_SET);
        read(f,&adchist,sizeof(adchist_t));
        if(adchist.adt)
        { strcpy(cmd,datestr(adchist.adt,0));
          if(!fstarg[0]||!strcmp(fstarg,cmd))
          { if(strcmp(help,cmd))
            { for(j=0;j<75;j++)
                putv('-');
              putv('\r');
            }
            strcpy(help,cmd);
            putf("%s %s ",help,timestr(adchist.adt));

            for(j=0;j<8;j++)
            { convadc(adchist.adc[j],j,s);
              putf("% 8.8s",s);
            }
            putv('\r');
          }
          if(tget(0)=='\r')
          { putf("Aborted.\r");
            break;
          }
        }
        if(!(i%10))
          scheduler();
      }
    }
    tclose(f);
  }
  else
  //#endif
  { ADC adc;
    if(!cfg.adc_combase)
    { putf("Sorry, no A/D-converter connected.\r");
      return;
    }
    adcsema(1);
    adc.getanalog(0);
    putf("ADC Status: 0x%X\r",cfg.adc_combase);
    for(i=1;i<9;i++)
    { suspend(1);
      putf("Channel %d: %d\r",i,adc.getanalog (i));
    }
    adcsema(0);
  }
}
