{ ****************************************** }
{ * Programm : 8-KanalMe.pas V1.003       * }
{ * Funktion : U-Messung am Ser.Port       * }
{ * Sprache  : Turbo Pascal V7.0 (Borland) * }
{ * Autor    : DG1XPZ                      * }
{ * (c) 07/1996 dg1xpz                     * }
{ ****************************************** }
uses Dos,Crt,Drivers,graph;
type RealFeld                           = array[1..8] of real;
     StringFeld                         = array[1..8] of String[12];
     WordFeld                           = array[1..8] of word;
var  Datei                              : text;
     Vin                                : RealFeld;
     DIN_M                              : Stringfeld;
     Version                            : String[8]; {Versions-Nr. Programm}
     Var_Real                           : Real;
     Var_Str                            : String;
     Var_Int,Var_Int_alt                : Integer;
     Anf_Oben,Laenge_Y,Laenge_X         : integer;
     Stunde,Mi,sec,zsec,Zeit            : word;       {Zeit}
     St_Stunde,St_Mi,St_sec,St_zsec     : word;       {Start-Zeit}
     S_Zeit,S_St_Zeit                   : String[100]; {fr Grafikausgabe}
     MK_Stunde,Mk_Mi,Mk_sec,MK_zsec,MK_Zeit : word;       {Merk-Zeit}
     Jahr,Monat,Tag,TagNr               : word;       {Datum}
{     Kanal1,Kanal2,Kanal3,Kanal4        : String[12];} {Mess-Wert}
{     Kanal5,Kanal6,Kanal7,Kanal8        : String[12];} {Mess-Wert}
     VOut,Ref,D,B                   : real;
     mess,code,i,i1,j,a,Befehl,qint     : integer;
     Anf_Links,Durchgang                : integer;    {Diagrammbeginn}
     PortAdr                            : String;
     q                                  : char;       {Tastaturabfrage Char}
   {  Vin1,Vin2,Vin3,Vin4,Vin5,Vin6,Vin7,Vin8 :real; }
     DIN                                : String[12];
     ql,Messmerk                        : string;
     qString                            : String;     {Keyabfrage String}
     OptionDateiname                    : string[12]; {zum Optionen sichern}
     Dateiname                          : string[12]; {zum Daten sichern}
     Masz_Kanal                         : string[10]; {Maeinheit fr die Kanle}
     Masz_X,Masz_Y                      : string[10]; {Maeinheit fr X/Y-Achsen}
     Leer,pfad                          : string;
     CodeT,Anz_Kanal                    : byte;
     PortHex                            : integer;    {enthlt PortAdr in Hex}
     Stel_Kan                           : byte;       {Stellen nach Komma - Kanal}
     SaveOption,Mess_Fort,Anzeige       : String[1];  {Ja/Nein Abfrage}
     Mess_Name                          : String[20]; {Bezeichnung Mess-Objekt}
     Warn_Max,Warn_Min,Max_X,Max_Y      : real;
     Mess_je_min,Opt_Ref,qTest          : real;
     SonderT                            : boolean; {fr "procedure Tastatur"}
     Pulldown                           : boolean; {merkt sich Men-runter}
     Pixel_Faktor                       : integer;
     FarbeK                             : wordfeld;


procedure Init;
begin
{ feste Optionen: }
  delay(1);
  Version:=('V1.003');
  Pfad:='c:\tp\bgi';   {Pfad fr Grafik-treiber}
  Anf_Oben:=40;
  Laenge_Y:=410;Laenge_X:=600;
  Anzeige:='A';        {Analog-Anzeige}
  OptionDateiname:='8K_Mesz.opt';
  Leer:='        ';
  Pulldown:=false;
  Mess_Fort:='n';
  SaveOption:='j';
  DIN_M[1]:='111101110001';FarbeK[1]:=9; {Lightblue}
  DIN_M[2]:='111101110011';FarbeK[2]:=10; {Lightgreen}
  DIN_M[3]:='111101111001';FarbeK[3]:=11; {Lightcyan}
  DIN_M[4]:='111101111011';FarbeK[4]:=12; {Lightred}
  DIN_M[5]:='111101110101';FarbeK[5]:=13; {Blue}
  DIN_M[6]:='111101110111';FarbeK[6]:=2; {green}
  DIN_M[7]:='111101111101';FarbeK[7]:=3; {cyan}
  DIN_M[8]:='111101111111';FarbeK[8]:=14; {Yellow}
{ nderbare Optionen: }
  Dateiname:='8K_Mesz.dat';
  Mess_je_min:=1;
  PortAdr:='$2F8';
    Val(Portadr,PortHex,Code);
  Anz_Kanal:=1;
  Masz_Kanal:='Volt';
  Stel_Kan:=10;
  Masz_X:='h';
  Max_X:=10;
  Masz_Y:='U in V';
  Max_Y:=2;
  Warn_Min:=1.00;
  Warn_Max:=1.45;
  Opt_Ref:=5;
  Mess_Name:='Akku 700mAh';

end;

procedure Tastatur(var CodeT:byte; var SonT:boolean);
 var Ch:Char;
  begin
    Ch:=ReadKey;
    if Ch = #0 then
      begin
        Ch:=Readkey;
        SonderT:=True;
      end
    else
      SonderT:=False;
      CodeT:=ord(Ch);
    end;

procedure Bildschirm;
begin
{  initvideo;
  clearscreen; }
  textcolor(lightgreen);textbackground(lightmagenta);
  gotoxy(1,2);write('ͻ');
  gotoxy(1,3);write('           8-Kanal-Mesteuerung ',Version,' (c) 06/96 DG1XPZ                      ');
  gotoxy(1,4);write('͹');
  for i:=5 to 24 do
  begin
    gotoxy(1,i);write('                                                                             ');
  end;
  gotoxy(1,25);write(' Alt-X = ENDE ͼ');
end;

procedure MenuZeile;
begin
  if Anzeige='D' then
  begin
     SetFillStyle(SolidFill,white);bar(0,0,630,12);
     setcolor(lightgray);
     OutTextXY(0,3,'   atei   ption                   nfo');SetColor(lightred);
     OutTextXY(0,3,'  D      O                       I');SetColor(black);
     OutTextXY(0,3,'                  tart  Analog');SetColor(red);
     OutTextXY(0,3,'                 S       n');
     if (Messmerk='START') or (Messmerk='ON') then
     begin
       SetFillStyle(SolidFill,white);bar(0,0,630,12);
       setcolor(lightgray);
       OutTextXY(0,3,'   atei   ption                   nfo');SetColor(lightred);
       OutTextXY(0,3,'  D      O                       I');SetColor(black);
       OutTextXY(0,3,'                 S op   A alog');SetColor(red);
       OutTextXY(0,3,'                  t      n');
       SetFillStyle(SolidFill,black);bar(125,13,190,36);
     end;

  end else begin
    gotoxy(1,1);textbackground(lightgray);
    write('                                                                                ');
    gotoxy(3,1);textcolor(red);write('D');textcolor(black);write('atei  ');
    textcolor(red);write('O');textcolor(black);write('ption  ');
    textcolor(red);write('S');textcolor(black);write('tart  ');
    textcolor(red);write('A');textcolor(black);write('nzeige  ');
    textcolor(red);write('I');textcolor(black);write('nfo  ');
    If MessMerk='START' then
    begin
      textbackground(lightgray);
      gotoxy(18,1);textcolor(black);write('S');textcolor(red);write('t');textcolor(black);write('op  ');
      textcolor(lightgreen);textbackground(lightmagenta);
    end;
    if MessMerk='ON' then
    begin
      textbackground(lightgray);
      gotoxy(18,1);textcolor(black);write('S');textcolor(red);write('t');textcolor(black);write('op  ');
    end;

    textcolor(lightgreen);textbackground(lightmagenta);
  end;
end;

procedure menuDatei;
begin
bildschirm;
textbackground(lightgray);textcolor(black);
gotoxy(2,2);write('Ŀ');
gotoxy(2,3);write('S');textcolor(red);write('p');textcolor(black);write('eichern');
gotoxy(2,4);write('');textcolor(red);write('L');textcolor(black);write('aden    ');
gotoxy(2,5);write('Ĵ');
gotoxy(2,6);write('');textcolor(red);write('B');textcolor(black);write('eenden  ');
gotoxy(2,7);write('');
textcolor(lightgreen);textbackground(lightmagenta);
Pulldown:=true;
end;

procedure SaveOption_go;
begin
  assign(Datei,OptionDateiname);
  rewrite(Datei);
  writeln(Datei,'Optionen 8K-Me ',Version);
  writeln(Datei,Dateiname);
  writeln(Datei,Mess_je_min);
  writeln(Datei,PortAdr);
    Val(Portadr,PortHex,Code);
  writeln(Datei,Anz_Kanal);
  writeln(Datei,Masz_Kanal);
  writeln(Datei,Stel_Kan);
  writeln(Datei,Masz_X);
  writeln(Datei,Max_X);
  writeln(Datei,Masz_Y);
  writeln(Datei,Max_Y);
  writeln(Datei,Warn_Min);
  writeln(Datei,Warn_Max);
  writeln(Datei,Opt_Ref);
  writeln(Datei,Mess_Name);
  close(Datei);
end;

procedure MenuOption;
begin
    Bildschirm;
    gotoxy(3,5);write('Dateiname                             : ');textbackground(black);
      write(copy(Dateiname,1,length(Dateiname)-4));write(Copy(Leer,1,12-Length(Dateiname)));textbackground(lightmagenta);
      gotoxy(51,5);write('.dat');gotoxy(62,5);write('(Save Mess-Daten)');
    gotoxy(3,6);write('Messungen je Minute                   : ');textbackground(black);
      if Mess_je_min >= 1 then write(Mess_je_min:1:0);
      if Mess_je_min < 1 then write(Mess_je_min:1:3);
      textbackground(lightmagenta);gotoxy(62,6);write('(max. 6000)');
    gotoxy(3,7);write('Port (COM1-IRQ4-$3F8, COM2-IRQ3-$2F8] : ');
      textbackground(black);write(PortAdr);
      textbackground(lightmagenta);gotoxy(62,7);write('(3F8,2F8,3E8,2E8)');
    gotoxy(3,8);write('Anzahl Mess-Kanle                    : ');textbackground(black);write(Anz_Kanal);
      textbackground(lightmagenta);gotoxy(62,8);write('(1 - 8 Kanle)');
    gotoxy(3,9);write('Maeinheit Kanal1                     : ');
      textbackground(black);gotoxy(43,9);write('          ');gotoxy(43,9);write(Masz_Kanal);
      textbackground(lightmagenta);gotoxy(62,9);write('(max. 10 Zeichen)');
    gotoxy(3,10);write('Nachkomma-Stellen Ausgabe Kanal-Wert  : ');
      textbackground(black);write(Stel_Kan);
      textbackground(lightmagenta);gotoxy(62,10);write('(0 - 10 Stellen)');
    gotoxy(3,11);write('Maeinheit X-Achse                    : t in ');
      textbackground(black);gotoxy(48,11);write(' ');gotoxy(48,11);write(Masz_X);
      textbackground(lightmagenta);gotoxy(62,11);write('(h=h,m=min,s=sec)');
    gotoxy(3,12);write('Skalierung X-Achse (Max-Wert)         : ');textbackground(black);write(Max_X:1:1);
      textbackground(lightmagenta);gotoxy(62,12);write('(10,14)');
    gotoxy(3,13);write('Maeinheit Y-Achse                    : ');
      textbackground(black);gotoxy(43,13);write('          ');gotoxy(43,13);write(Masz_Y);
      textbackground(lightmagenta);gotoxy(62,13);write('(max. 10 Zeichen)');
    gotoxy(3,14);write('Skalierung Y-Achse (Max-Wert)         : ');textbackground(black);write(Max_Y:1:1);
      textbackground(lightmagenta);gotoxy(62,14);write('(2,5)');
    gotoxy(3,15);write('Warnwert minimum Y-Achse (Markierung) : ');textbackground(black);write(Warn_Min:1:2);
      textbackground(lightmagenta);gotoxy(62,15);write('( < max. Y-Achse)');
    gotoxy(3,16);write('Warnwert maximum Y-Achse (Markierung) : ');textbackground(black);write(Warn_Max:1:2);
      textbackground(lightmagenta);gotoxy(62,16);write('( < max. Y-Achse)');
    gotoxy(3,17);write('Referenzspannung (Eichwert)           : ');
      textbackground(black);gotoxy(43,17);write('            ');gotoxy(43,17);write(Opt_Ref:1:10);
      textbackground(lightmagenta);gotoxy(62,17);write('( > 4 und < 6)');
    gotoxy(3,18);write('Bezeichnung Meobjekt                 : ');
      textbackground(black);gotoxy(43,18);write('                  ');gotoxy(43,18);write(Mess_Name);
      textbackground(lightmagenta);gotoxy(62,18);write('(max. 18 Zeichen)');
    gotoxy(3,19);write('Messung fortlaufend (J/N)             : ');
      gotoxy(43,19);write('  (oder Ende bei Skal. X-Achse: ',Max_x:1:0,')');
      textbackground(black);gotoxy(43,19);write(Mess_Fort);textbackground(lightmagenta);
    gotoxy(15,23);write('Optionen jetzt abspeichern ? (J/N)    : ');textbackground(black);write(SaveOption);
      textbackground(lightmagenta);gotoXY(59,23);write('(',OptionDateiname,')');
    gotoxy(15,24);write('Einstellungen beibehalten ? (J/N)     : ');textbackground(black);write(' ',#8);
      q:=readkey;
      if (q='j') or (q='J') then
      begin
        bildschirm;
        exit;
      end else begin
  {Option Eingabe}
    repeat gotoxy(43,5);textbackground(black);write('        ');textbackground(lightmagenta);
      write('.dat       (Save Mess-Daten)');
      gotoxy(43,5);textbackground(black);write(copy(Dateiname,1,length(Dateiname)-4));
      gotoxy(43,5);readln(qString);
      if (qString<>'') and (Length(qString)<9) and (Length(qString)>0)
      then begin Dateiname:=copy(qstring,1,8)+'.dat';
        gotoxy(43,5);textbackground(black);write('        ');textbackground(lightmagenta);write('.dat           ');
        gotoxy(43,5);textbackground(black);write(copy(Dateiname,1,length(Dateiname)-4));
      end;
      until (Length(qString)<9) and (Length(qString)>0) or (qString='');
    repeat gotoxy(43,6);textbackground(lightmagenta);write('                   ');
      gotoxy(43,6);textbackground(black);
      if Mess_je_min >= 1 then write(Mess_je_min:1:0);
      if Mess_je_min < 1 then write(Mess_je_min:1:3);
      gotoxy(43,6);textbackground(black);readln(qString);val(qString,qTest,code);
      if (qString<>'') and (qTest < 6001) and (qTest > 0)
      then begin val(qString,Mess_je_min,code) end;
      if Mess_je_min >= 1 then begin Mess_je_min:=int(Mess_je_min);
         gotoxy(43,6);textbackground(lightmagenta);write('                   ');
         gotoxy(43,6);textbackground(black);
         if Mess_je_min >= 1 then write(Mess_je_min:1:0);
         if Mess_je_min < 1 then write(Mess_je_min:1:3);
      end;
      until (qTest<6001) and (qTest>0) or (qString='');
    repeat gotoxy(43,7);textbackground(lightmagenta);write('                ');
      gotoxy(43,7);textbackground(black);write(PortAdr);
      gotoXY(43,7);textbackground(black);readln(qString);
      if (qString<>'') and (Length(qstring)=4) and (Copy(qstring,1,1)='$')
      then begin PortAdr:=qString;
        gotoxy(43,7);textbackground(lightmagenta);write('                ');
        gotoxy(43,7);textbackground(black);write(PortAdr);
      end;
      Val(Portadr,PortHex,Code);
      until (Length(qstring)=4) and (Copy(qstring,1,1)='$') or (qString='');
    repeat gotoxy(43,8);textbackground(lightmagenta);write('                   ');
      gotoxy(43,8);textbackground(black);write(Anz_Kanal);
      gotoxy(43,8);textbackground(black);readln(qString);val(qString,qTest,code);
      if (qString<>'') and (qTest > 0) and (qTest < 9)
      then begin val(qString,Anz_Kanal,code) end;
      until (qTest > 0) and (qTest < 9) or (qString='');
    repeat gotoxy(43,9);textbackground(lightmagenta);write('                   ');
      gotoxy(43,9);textbackground(black);write('          ');
      gotoxy(43,9);write(Masz_Kanal);
      gotoxy(43,9);textbackground(black);readln(qString);
      if (qString<>'') and (Length(qString)<11) and (Length(qString)>0)
      then begin Masz_Kanal:=qString;
        gotoxy(43,9);textbackground(lightmagenta);write('                   ');
        gotoxy(43,9);textbackground(black);write('          ');
        gotoxy(43,9);write(Masz_Kanal);
      end;
      until (Length(qString)<11) or (qString='');
    repeat gotoxy(43,10);textbackground(lightmagenta);write('                   ');
      gotoxy(43,10);textbackground(black);write(Stel_Kan);
      gotoxy(43,10);textbackground(black);readln(qString);val(qString,qTest,code);
      if (qString<>'') and (qTest < 11)
      then begin val(qString,Stel_Kan,code);
        gotoxy(43,10);textbackground(lightmagenta);write('                   ');
        gotoxy(43,10);textbackground(black);write(Stel_Kan);
      end;
      until (qTest < 11) and (qTest > 0 ) or (qString='');
    repeat gotoxy(48,11);textbackground(lightmagenta);write('              ');
      gotoxy(48,11);textbackground(black);write(' ');
      gotoxy(48,11);write(Masz_X);
      gotoxy(48,11);textbackground(black);readln(qstring);
      if (qString<>'') and (Length(qString)<11) and (Length(qString)>0) and (qString='h') or (qString='m') or (qString='s')
      then begin Masz_X:=qString;
        gotoxy(48,11);textbackground(lightmagenta);write('              ');
        gotoxy(48,11);textbackground(black);write(' ');
        gotoxy(48,11);write(Masz_X);
      end;
      until (qString='h') or (qString='m') or (qString='s') or (qString='');
    repeat gotoxy(43,12);textbackground(lightmagenta);write('                   ');
      gotoxy(43,12);textbackground(black);write(Max_X:1:1);
      gotoxy(43,12);textbackground(black);readln(qstring);val(qString,qTest,code);
      if (qString<>'') and (qTest < 61) and (qTest > 0)
      then begin val(qString,Max_X,code);
        gotoxy(43,12);textbackground(lightmagenta);write('                   ');
        gotoxy(43,12);textbackground(black);write(Max_X:1:1);
      end;
      until (qTest < 61) and (qTest > 0 ) or (qString='');
    repeat gotoxy(43,13);textbackground(lightmagenta);write('                   ');
      gotoxy(43,13);textbackground(black);write('          ');
      gotoxy(43,13);write(Masz_Y);
      gotoxy(43,13);textbackground(black);readln(qstring);
      if (qString<>'') and (Length(qString)<11) and (Length(qString)>0)
      then begin Masz_Y:=qString;
        gotoxy(43,13);textbackground(lightmagenta);write('                   ');
        gotoxy(43,13);textbackground(black);write('          ');
        gotoxy(43,13);write(Masz_Y);
      end;
      until (Length(qString)<11) or (qString='');
    repeat gotoxy(43,14);textbackground(lightmagenta);write('                   ');
      gotoxy(43,14);textbackground(black);write(Max_Y:1:1);
      gotoxy(43,14);textbackground(black);readln(qstring);val(qString,qTest,code);
      if (qString<>'') and (qTest < 6) and (qTest > 0)
      then begin val(qString,Max_Y,code);
        gotoxy(43,14);textbackground(lightmagenta);write('                   ');
        gotoxy(43,14);textbackground(black);write(Max_Y:1:1);
      end;
      until (qTest < 6) and (qTest > 0 ) or (qString='');
    repeat gotoxy(43,15);textbackground(lightmagenta);write('                   ');
      gotoxy(43,15);textbackground(black);write(Warn_Min:1:2);
      gotoxy(43,15);textbackground(black);readln(qstring);val(qString,qTest,code);
      if (qString<>'') and (qTest <= Max_Y) and (qTest > 0)
      then begin val(qString,Warn_Min,code);
        gotoxy(43,15);textbackground(lightmagenta);write('                   ');
        gotoxy(43,15);textbackground(black);write(Warn_Min:1:2);
      end;
      until (qTest <= Max_Y) and (qTest > 0 ) or (qString='');
    repeat gotoxy(43,16);textbackground(lightmagenta);write('                   ');
      gotoxy(43,16);textbackground(black);write(Warn_Max:1:2);
      gotoxy(43,16);textbackground(black);readln(qstring);val(qString,qTest,code);
      if (qString<>'') and (qTest <= Max_Y) and (qTest > 0)
      then begin val(qString,Warn_Max,code);
        gotoxy(43,16);textbackground(lightmagenta);write('                   ');
        gotoxy(43,16);textbackground(black);write(Warn_Max:1:2);
      end;
      until (qTest <= Max_Y) and (qTest > 0 ) or (qString='');
    repeat gotoxy(43,17);textbackground(lightmagenta);write('                   ');
      gotoxy(43,17);textbackground(black);write(Opt_Ref:1:10);
      gotoxy(43,17);textbackground(black);readln(qstring);val(qString,qTest,code);
      if (qString<>'') and (qTest < 6) and (qTest > 4)
      then begin val(qString,Opt_Ref,code);
        gotoxy(43,17);textbackground(lightmagenta);write('                   ');
        gotoxy(43,17);textbackground(black);write(Opt_Ref:1:10);
      end;
      until (qTest > 4) and (qTest < 6) or (qString='');
    repeat gotoxy(43,18);textbackground(lightmagenta);write('                   ');
      gotoxy(43,18);textbackground(black);write('                  ');
      gotoxy(43,18);write(Mess_Name);
      gotoxy(43,18);textbackground(black);readln(qstring);
      if (qString<>'') and (Length(qString)<19) and (Length(qString)>0)
      then begin Mess_Name:=qString;
        gotoxy(43,18);textbackground(lightmagenta);write('                   ');
        gotoxy(43,18);textbackground(black);write('                  ');
        gotoxy(43,18);write(Mess_Name);
      end;
      until (Length(qString)<19) or (qString='');
    repeat gotoxy(43,19);textbackground(lightmagenta);
      gotoxy(43,19);write('  (oder Ende bei Skal. X-Achse: ',Max_x:1:0,')');
      gotoxy(43,19);textbackground(black);write(Mess_Fort);
      gotoxy(43,19);textbackground(black);readln(qString);
      if (qString<>'') and (qString='j') or (qString='n')
      then begin Mess_Fort:=qString;
        gotoxy(43,19);textbackground(lightmagenta);write('                   ');
        gotoxy(43,19);textbackground(black);write(Mess_Fort);
      end;
      until (qString='j') or (qString='n') or (qString='');
    repeat gotoxy(55,23);textbackground(lightmagenta);gotoXY(55,23);write('    (',OptionDateiname,')       ');
     gotoxy(55,23);textbackground(black);write(SaveOption);
     gotoxy(55,23);textbackground(black);readln(qString);
     if (qString<>'') and (qString='j') or (qString='n')
     then begin SaveOption:=qString;
       gotoxy(55,23);textbackground(lightmagenta);write('                   ');
       gotoxy(55,23);textbackground(black);write(SaveOption);
     end;
     if SaveOption='j' then SaveOption_go
     until (qString='j') or (qString='n') or (qString='');
     textbackground(lightmagenta);
     MenuOption;
    end;
end;

procedure Diagramm_init;
var int_warn, grDriver, grMode, ErrCode, Radius: Integer;
    str_warn : string;
    real_warn :real;
begin
  clrscr;
  grDriver:=Detect;
  InitGraph(grDriver,grMode,pfad);
  ErrCode:=GraphResult;
{  SetLineStyle(1,0,0); }
  SetBKColor(black);  {Hintergrundfarbe}
  SetColor(white);       {Zeichenfarbe}
  Anf_Links:=30;
  Laenge_X:=600;
  SetTextStyle(DefaultFont, HorizDir, 1);   { VertDir,HorizDir }
  SetTextJustify(LeftText, TopText);       { Right,Lefttext   }
  if ErrCode = grOk then
  begin
     Line(Anf_Links, Anf_Oben, Anf_Links, Anf_Oben+Laenge_Y);  {vertikal}
     Line(Anf_Links, Anf_Oben+Laenge_Y, Anf_Links+Laenge_X,Anf_Oben+Laenge_Y);   {horizontal}
     i:=0;

     if max_x=14 then  {alles raus mit 14 weil nicht stimmt}
     begin
       repeat
         I:=I+7; {kl Striche auf X-Achse fr 14h}
         Line(Anf_Links+I,Anf_Oben+Laenge_Y-2,Anf_Links+I,Anf_Oben+Laenge_Y+2); {Strich auf X-Achse}
       until I>=Laenge_X-10;
       I:=0;I1:=0;
       repeat
         I:=I+42;I1:=I1+1; {gr Striche auf X-Achse fr 14h}
         Line(Anf_Links+I,Anf_Oben+Laenge_Y-5,Anf_Links+I,Anf_Oben+Laenge_Y+5); {Strich auf X-Achse}
       until I>=Laenge_X-10;
       OutTextXY(Anf_Links+37,470,'1    2    3     4    5    6     7    8    9    10   11   12    13   14');
       I:=0;
     end;

     if max_x=10 then {X-Achse mit Mezeit 10h}
     begin
       repeat
         I:=I+10; {kl Striche auf X-Achse fr 10h}
         Line(Anf_Links+I,Anf_Oben+Laenge_Y-2,Anf_Links+I,Anf_Oben+Laenge_Y+2); {Strich auf X-Achse}
       until I>=Laenge_X-10;
      I:=0;I1:=0;
       repeat
         I:=I+30;I1:=I1+1; {mittl. Striche auf X-Achse fr 10h}
         Str(I1,Var_Str);
         Line(Anf_Links+I,Anf_Oben+Laenge_Y-4,Anf_Links+I,Anf_Oben+Laenge_Y+4); {Strich auf X-Achse}
       until I>=Laenge_X-10;
       I:=0;I1:=0;
       repeat
         I:=I+60;I1:=I1+1; {gr Striche auf X-Achse fr 10h}
         Str(I1,Var_Str);
         Line(Anf_Links+I,Anf_Oben+Laenge_Y-5,Anf_Links+I,Anf_Oben+Laenge_Y+5); {Strich auf X-Achse}
         OutTextXY(Anf_Links+I-3,Anf_Oben+Laenge_Y+10,Var_Str);{Zahlwert fr X-Achse}
       until I>=Laenge_X-10;
       I:=0;
     end;

     if Max_Y=2 then  {Y-Achse fr Endwert 2 }
     begin
       repeat
         I:=I+20; {kl Striche auf Y-Achse fr 2V}
         Line(Anf_Links-2,Anf_Oben+Laenge_Y-I,Anf_Links+2,Anf_Oben+Laenge_Y-I  ); {Strich auf X-Achse}
       until I>=Laenge_Y-10;
       I:=0;
       repeat
         I:=I+100; {mittl Striche auf Y-Achse fr 2V}
         Line(Anf_Links-4, Anf_Oben+Laenge_Y-I, Anf_Links+4,Anf_Oben+Laenge_Y-I); {Strich auf X-Achse}
       until I>=Laenge_Y-50;
       I:=0;
       Pixel_Faktor:=200; {fr 2V}
       repeat
         I:=I+200; {gr Striche auf Y-Achse fr 2V}
         Line(Anf_Links-5, Anf_Oben+Laenge_Y-I, Anf_Links+5,Anf_Oben+Laenge_Y-I); {Strich auf X-Achse}
       until I>=Laenge_Y-100;
       OutTextXY(0,Anf_Oben+Laenge_Y-202,'1');
       OutTextXY(0,Anf_Oben+Laenge_Y-402,'2');
     end;

     if Max_Y=5 then  {Y-Achse fr Endwert 5 }
     begin
       repeat
         I:=I+7{Pixel_Faktor/10}; {kl Striche auf Y-Achse fr 5V}
         Line(Anf_Links-2,Anf_Oben+Laenge_Y-I,Anf_Links+2,Anf_Oben+Laenge_Y-I  ); {Strich auf X-Achse}
       until I>=Laenge_Y-10;
       I:=0;
       repeat
         I:=I+35; {mittl. Striche auf Y-Achse fr 5V}
         Line(Anf_Links-4, Anf_Oben+Laenge_Y-I, Anf_Links+4,Anf_Oben+Laenge_Y-I); {Strich auf X-Achse}
       until I>=Laenge_Y-70;
       I:=0;
       Pixel_Faktor:=70; {fr 5V}
       repeat
         I:=I+70; {gr Striche auf Y-Achse fr 5V}
         Line(Anf_Links-5, Anf_Oben+Laenge_Y-I, Anf_Links+5,Anf_Oben+Laenge_Y-I); {Strich auf X-Achse}
       until I>=Laenge_Y-100;
       OutTextXY(0,Anf_Oben+Laenge_Y-72,'1');
       OutTextXY(0,Anf_Oben+Laenge_Y-142,'2');
       OutTextXY(0,Anf_Oben+Laenge_Y-212,'3');
       OutTextXY(0,Anf_Oben+Laenge_Y-282,'4');
       OutTextXY(0,Anf_Oben+Laenge_Y-352,'5');
     end;
     real_warn:=int(Warn_min*Pixel_Faktor);str(real_warn:1:4,str_warn);
     str_warn:=copy(str_warn,1,pos('.',str_warn)-1);val(str_warn,int_warn,code);
     SetColor(red);
     Line(Anf_Links+1, Anf_Oben+Laenge_Y-int_warn, Anf_Links+Laenge_X,Anf_Oben+Laenge_Y-int_warn);
     real_warn:=int(Warn_max*Pixel_Faktor);str(real_warn:1:4,str_warn);
     str_warn:=copy(str_warn,1,pos('.',str_warn)-1);val(str_warn,int_warn,code);
     Line(Anf_Links+1, Anf_Oben+Laenge_Y-int_warn, Anf_Links+Laenge_X,Anf_Oben+Laenge_Y-int_warn);
     SetColor(white);OutTextXY(0,20,Masz_Y);{Bezeichnug Y-Achse}
     OutTextXY(569,472,'t in');
     if Masz_X='h' then OutTextXY(614,472,'h');
     if Masz_X='m' then OutTextXY(614,472,'min');
     if Masz_X='s' then OutTextXY(614,472,'sec');{Bezeichnung X-Achse  aller !! letzte Zeile}
       SetTextJustify(LeftText, TopText);
     OutTextXY(200,20,'Meobjekt: ');
     OutTextXY(300,20,Mess_name);{Bezeichnung Meobjekt}
     for I:=1 to Anz_Kanal do
     begin
       setcolor(FarbeK[I]);
       OutTextXY(Anf_Links+(I*15)+468,20,'K');
       Str(I,Var_Str);
       OutTextXY(Anf_Links+(I*15)+473,20,Var_Str);
     end;
   end else begin
    Writeln('Grafikfehler');
  end;
end;

procedure MenuAnzeige;
begin
textbackground(lightgray);textcolor(black);
gotoxy(24,2);write('Ŀ');
gotoxy(24,3);write('Dia');textcolor(red);write('g');textcolor(black);write('ramm');
gotoxy(24,4);write('');textcolor(white);write('A');textcolor(lightred);write('n');textcolor(white);write('alog  ');
textcolor(black);write('');
gotoxy(24,5);write('');
textcolor(lightgreen);textbackground(lightmagenta);
Pulldown:=true;
end;

procedure menuinfo;
begin
bildschirm;
gotoxy(5,5);write('                           Info');
gotoxy(5,7);write('  Folgendes geht noch nicht (in Arbeit):');
gotoxy(5,8);write('* LADEN und SPEICHERN von Daten geht noch nicht');
gotoxy(5,9);write('* Laden der Optionen geht noch nicht');
gotoxy(5,10);write('* Bei MenuOption: Wert X-Achse: H=Stunde M=Minute S=Sekunde');
gotoxy(5,11);write('*   1 Punkt in 90 sec = 15h   ->   wird wohl nichts');
gotoxy(5,12);write('    1 Punkt  je min   = 10h   ->   luft schon ');
gotoxy(5,13);write('    1 Punkt  je sec   = 10min ->   luft schon ');
gotoxy(5,14);write('   10 Punkte je sec   =  1min');
gotoxy(5,15);write('  100 Punkte je sec   =  6sec -> das maximale !!! bei 1? Kanal');
gotoxy(5,16);write('* Bei MenuOption: akustisches Warnsignal fr Warn-Wert min/max');
gotoxy(5,17);write('* Bei MenuOption: Differenzmessung AN/AUS');
gotoxy(5,18);write(' ');
gotoxy(5,19);write('* bei SPEICHERN/LADEN der Daten die Optionen mitspeichern/laden');
end;

procedure MenuStart;
begin
if Anzeige='D' then
begin
  setcolor(red);line(0,0,1,1);
  SetFillStyle(SolidFill, white);bar(125,13,190,36);
  SetColor(black);OutTextXY(0,15,'                 N u');
  OutTextXY(0,27,'                  eiter');
  SetColor(red);OutTextXY(0,15,'                  e');
  OutTextXY(0,27,'                 W');
 end else begin
  textbackground(lightgray);textcolor(black);
  gotoxy(17,2);write('Ŀ');
  gotoxy(17,3);write('N');textcolor(red);write('e');textcolor(black);write('u   ');
  gotoxy(17,4);write('');textcolor(red);write('W');textcolor(black);write('eiter');
  gotoxy(17,5);write('');
  textcolor(lightgreen);textbackground(lightmagenta);
end;
Pulldown:=true;
end;

procedure Analog;
begin
Closegraph;
Anzeige:='A';
MenuZeile;
Bildschirm;
{gotoxy (70,4);write(' Analog ');}
Pulldown:=true;
end;

procedure Diagramm;
begin
Bildschirm;
{gotoxy (70,4);write('Diagramm');}
Anzeige:='D';
Diagramm_init;
menuzeile;
Pulldown:=true;
end;

procedure DateiSpeichern;
begin
Bildschirm;
gotoxy (70,4);write('Speichern');
Pulldown:=true;
  assign(Datei,Dateiname);
  rewrite(Datei);
  writeln(Datei,'Optionen 8K-Me ',Version);
  writeln(Datei,Dateiname);
  writeln(Datei,Mess_je_min);
  writeln(Datei,PortAdr);
    Val(Portadr,PortHex,Code);
  writeln(Datei,Anz_Kanal);
  writeln(Datei,Masz_Kanal);
  writeln(Datei,Stel_Kan);
  writeln(Datei,Masz_X);
  writeln(Datei,Max_X);
  writeln(Datei,Masz_Y);
  writeln(Datei,Max_Y);
  writeln(Datei,Warn_Min);
  writeln(Datei,Warn_Max);
  writeln(Datei,Opt_Ref);
  writeln(Datei,Mess_Name);
  writeln(Datei,'Jetzt wrden die Daten kommen !!!');
  close(Datei);
end;

procedure DateiLaden;
begin
Bildschirm;
gotoxy (70,4);write('  Laden  ');
Pulldown:=true;
{assign(Datei,Dateiname);
reset(Datei);
while not eof(Datei) do
begin
  read(Datei,????);
end;
close(Datei);}
end;

procedure Leseport;
begin
  B:=512;
  VOUT:=0;
  REF:=5;
{  REF:=REF-(Opt_ref-int(Opt_Ref));
}  For I:=1 to 12 do
  begin
    Port[PortHex+4]:=$FE and Port[PortHex+4];
    if copy(DIN,13-i,1)='0' then
    begin
      Port[PortHex+4]:=$FD and Port[PortHex+4];
     end else begin
     Port[PortHex+4]:=$2 or Port[PortHex+4];
    end;
    Port[PortHex+4]:=$1 or Port[PortHex+4];
    if Port[PortHex+6] and 16=16 then
    begin
      D:=0
     end else begin
      D:=1
    end;
    VOut:=VOut+(D*B);
    B:=B/2;
  end;
  Port[PortHex+4]:=$FD and Port[PortHex+4];
  Port[PortHex+4]:=$2 or Port[PortHex+4];
  For J:=1 to 2000 do;
end;

procedure MenuStartMessung_Analog;
var I2:byte;
begin

  gotoxy(35,5);write('Meobjekt: ',Mess_name);
  gotoxy(19,25);write(' Start: ',St_Stunde,':',St_Mi,':',St_sec,',',St_zsec,' ');
  for I2:=1 to Anz_Kanal do
  begin
    DIN:=DIN_M[I2];Leseport;Leseport;vin[I2]:=(VOut/1023)*Ref;gotoxy(5,7+I2);
    writeln('Kanal',I2,': ',Vin[I2]:1:Stel_Kan,' ',Masz_Kanal);
  end;

  gettime(Stunde,Mi,sec,zsec);
  gotoxy(61,25);write(' Nr:',a,' ');gotoxy(41,25);write(' Zeit:',Stunde,':',Mi,':',sec,',',zsec,' ');
  if Mess_Fort='j' then begin gotoxy(71,25);write(' Dg:',Durchgang,' ');end;
  a:=a+1;
end;

procedure Real_Int (var Var_Eing: real; var Faktor : integer; var Var_Int: integer);
var Var_Str :String;
    Var_Real: Real;
begin
  Var_Real:=Var_Eing*Faktor;
  Var_Real:=int(Var_Real);str(Var_Real:1:4,Var_Str);
  Var_Str:=copy(Var_Str,1,pos('.',Var_Str)-1);val(Var_Str,Var_int,code);
end;

procedure MenuStartMessung_Diagramm;
var int_vin1 :integer;
    I2       :byte;
begin
  a:=a+1;
  for I2:=1 to Anz_Kanal do
  begin
    DIN:=DIN_M[I2];Leseport;Leseport;vin[I2]:=(VOut/1023)*Ref;
    Var_Real:=Anf_Oben+Laenge_Y-(Vin[I2]*Pixel_Faktor);
    Var_real:=int(Var_Real);str(Var_real:1:4,Var_str);
    Var_str:=copy(Var_str,1,pos('.',Var_str)-1);val(Var_str,Var_int,code);
    setcolor(FarbeK[I2]);
    if Var_Int_alt=0 then PutPixel(Anf_Links+a,Var_int,FarbeK[I2]);{wichtig fr 1.mewert}
    if Var_int_alt<>0 then line(Anf_Links+a-1,Var_int_alt,Anf_Links+a,Var_Int);{fr alle anderen Mewerte}
    Var_Int_alt:=Var_int;
  end;
  gettime(Stunde,Mi,sec,zsec);
  {Zeit:=(' Start:'+St_Stunde+':'+St_Mi+':'+St_sec+','+St_zsec+'    Zeit:'+Stunde+':'+Mi+':'+sec+','+zsec+'   Nr.'+a);
 }S_Zeit:='';
  Str(Stunde,Var_str);S_Zeit:='  Zeit: '+Var_str;
  Str(Mi,Var_str);S_Zeit:=S_Zeit+':'+Var_str;
  Str(sec,Var_str);S_Zeit:=S_Zeit+':'+Var_str;
  Str(zsec,Var_str);S_Zeit:=S_Zeit+','+Var_str;
  Str(a-1,Var_str);S_Zeit:=S_Zeit+'  Nr: '+Var_str;
  SetFillStyle(SolidFill,black);bar(Anf_Links,472,390,482);{alte Zeit lschen}
  S_Zeit:=S_St_Zeit+S_Zeit;setcolor(white);
  OutTextXY(Anf_Links,472,S_Zeit);
end;

procedure MenuTastatur;
begin
  if SonderT then
  begin
    if CodeT=32 then MenuDatei;         {d}
       if CodeT=25 then DateiSpeichern; {p}
       if CodeT=38 then DateiLaden;     {l}
    if CodeT=24 then MenuOption;        {o}
    If (CodeT=31) and (Messmerk='') then MenuStart; {s}
    if MessMerk='' then
    begin
      if CodeT=18 then
      begin
        MessMerk:='START';           {e} {fr MenuStartMessung}
        Bildschirm;
        Pulldown:=false;
      end;
    end;
    if (MessMerk='') and (a>0) then
    begin
      if CodeT=17 then
      begin
        MessMerk:='WEITER';            {w} {fr Weiter Messung}
        Bildschirm;
        Pulldown:=false;
      end;
    end;
    if CODET=20 then MessMerk:='STOP'; {t} {Stop}
    if CodeT=30 then MenuAnzeige;      {a}
    if CodeT=49 then Analog;           {n}
    if CodeT=34 then Diagramm;         {g}
    if CodeT=23 then MenuInfo;         {i}
    if (CodeT=48) or (CodeT=45) then
    begin
      textcolor(lightgray);textbackground(black);writeln(' ');
      halt;
    end;
   end else begin
    if (CodeT=27) and Pulldown then Bildschirm;
  end;
end;

begin
  clrscr;
  init;
  MenuZeile;
  Bildschirm;
repeat
    gettime(Stunde,Mi,sec,zsec);
    if Keypressed then
    begin
        Tastatur(CodeT, SonderT);
        Menutastatur;
    end;
{if zsec < MK_zsec then MK_zsec:=0;
if sec < MK_sec then MK_sec:=0;
if mi < MK_mi then MK_mi:=0;
if Stunde < MK_Stunde then MK_Stunde:=0;  }
{if zsec > MK_zsec then begin} {entspricht 30sec fr 1 Durchgang}
if Masz_X='s' then
   begin
     {entspricht 30sec fr 1 Durchgang}
     MK_Zeit:=(MK_mi*10000)+(MK_sec*100)+MK_zsec;
     Zeit:=(mi*10000)+(sec*100)+zsec;
   end;
if Masz_X='m' then
   begin
     {entspricht 10 min fr 1 Durchgang}
     MK_Zeit:=(MK_Stunde*10000)+(MK_mi*100)+MK_sec;
     Zeit:=(Stunde*10000)+(mi*100)+sec;
   end;
if Masz_X='h' then
   begin
     {entspricht 10h min fr 1 Durchgang ?}
     MK_Zeit:=(MK_Stunde*10000)+(MK_mi*100);
     Zeit:=(Stunde*10000)+(mi*100);
   end;
if (Zeit > MK_Zeit) then begin {entspricht 10 min fr 1 Durchgang}
{if zsec > MK_sec+5 then begin}
    gettime(MK_Stunde,MK_Mi,MK_sec,MK_zsec);
    if MessMerk='START' then
    begin
      if Anzeige='A' then Bildschirm;
      a:=0;Durchgang:=Durchgang+1;
      MenuZeile;
      gettime(Stunde,Mi,sec,zsec);St_Stunde:=Stunde;St_Mi:=MI;St_Sec:=sec;
        St_zsec:=zsec; {Startzeit fr Analog-Ausgabe}
        Str(Stunde,Var_str);S_St_Zeit:='Start: '+Var_str;Str(Mi,Var_str);
        S_St_Zeit:=S_St_Zeit+':'+Var_str;Str(sec,Var_str);
        S_St_Zeit:=S_St_Zeit+':'+Var_str;Str(zsec,Var_str);
        S_St_Zeit:=S_St_Zeit+','+Var_str;  {Startzeit fr Diagramm-Ausgabe}
      MessMerk:='ON';
      if Anzeige='A' then MenuStartMessung_Analog;
      if Anzeige='D' then MenuStartMessung_Diagramm;
    end;
    if MessMerk='STOP' then
    begin
      MenuZeile;
      gotoxy(42,25);write('Stop:');
      MessMerk:='';
    end;
    if MessMerk='ON' then
    begin
       if Anzeige='A' then MenuStartMessung_Analog;
       if Anzeige='D' then MenuStartMessung_Diagramm;
       if (a > Laenge_X) and (Mess_Fort<>'j') then
       begin MessMerk:='';MessMerk:='STOP';end;
       if (a > Laenge_X) and (Mess_Fort='j') then
       begin a:=0;Durchgang:=a;end;
    end;
    if MessMerk='WEITER' then
    begin
      textbackground(lightgray);
      gotoxy(18,1);textcolor(black);write('S');textcolor(red);write('t');textcolor(black);write('op  ');
      textcolor(lightgreen);textbackground(lightmagenta);
      MessMerk:='ON';
      if Anzeige='D' then SetFillStyle(SolidFill,black);bar(125,13,190,36);
      if Anzeige='A' then MenuStartMessung_Analog;
      if Anzeige='D' then MenuStartMessung_Diagramm;
    end;
end;
  until codeT = 45;
  textcolor(lightgray);textbackground(black);
  write(#13);
end.
