import java.applet.*; //nur fr MSIE + nderung von "extends JApplet" auf "...Applet"
                      //+ getContentPane() vermeiden, siehe unten
import java.awt.*;
import javax.swing.*;
/**
    Ureg-Applet
    Berechnung Widerstandskombination fr Spannungsregler
    Hngt das Panel in das Frame des Applets
*/
public class UregApplet extends Applet{  //extends JApplet fr "normale" JDK's
/** Definiert den Wert der Hintergrundfarbe */
   private int red,green,blue;
   UregPanel uregPanel;
   /** Referenzspannung des Spannungsreglers ber Parameter "uref" der HTML-Datei eingelesen*/
   float uref;
   boolean _debug=false;
/**
   Initialisiert das Frame (Gre,Titel usw.)
   und hngt das Panel in das Frame
*/
   public void init(){
      if (_debug) System.out.println(">call: UregApplet.init()");//Ausgabe auf Konsole
      try{
        String sTmp = getParameter("bgcolor");
        if (_debug) System.out.println("Param bgcolor= "+sTmp);
        String Tmp=sTmp.substring(0,sTmp.indexOf(",",0));
        red=Integer.parseInt(Tmp);
        sTmp=sTmp.substring(sTmp.indexOf(",",0)+1,sTmp.length());
        Tmp=sTmp.substring(0,sTmp.indexOf(",",0));
        green=Integer.parseInt(Tmp);
        sTmp=sTmp.substring(sTmp.indexOf(",",0)+1,sTmp.length());
        blue=Integer.parseInt(sTmp);
      }catch(NumberFormatException nfe){
       red=112;green=184;blue=147; // red=green=blue=180  grau;
      }
      try{
        uref=0;
        if (getParameter("uref")!=null){
          uref=Float.valueOf(getParameter("uref").trim()).floatValue();
        }
      }catch(NumberFormatException nfe){
        System.out.println("Parameter ->uref<- ist fehlerhaft Bsp.: \"1.25\". Setze Default-Wert");
      }
      setBackground(new Color(red,green,blue)); //Hintergrundfarbe
//      Container contentPane = getContentPane(); //fr JApplet -> "normal"
//      uregPanel = new UregPanel(red,green,blue);//fr JApplet -> "normal"
        uregPanel = new UregPanel(this,red,green,blue);//fr Applet -> MSIE
//      contentPane.add(uregPanel);              //fr JApplet -> "normal"
  }//init()

/**
  bergibt den Wert der Referenzspannung des Parameters "uref" aus HTML-Datei
  @param der Wert der Referenzspannung
*/
  public float getUref(){
    return uref;
  }

  /** Ausgabe der Parameterinfo (Applet)
      @return der Parameterinfo-String
  */
  public String[][] getParameterInfo()
  {
    String[][] sInfo= new String[][]{
      { "uref","Float",(getParameter("uref")!=null)?
                             getParameter("uref"):"nicht belegt -> (bsp:)1.25"},
      { "bgcolor","Color",(getParameter("bgcolor")!=null)?
                             getParameter("bgcolor"):"nicht belegt -> (bsp:)112,184,147"},
     };
    return(sInfo);
  }//public String[][] getParameterInfo()

  /** Ausgabe der Appletinfo (Name, Autor, Version)
      @return der Appletinfo-String
  */
  public String getAppletInfo(){
   return("name: Ureg\n"+
          "author: DG1XPZ\n"+
          "version: "+uregPanel.getVersion()+
          "(c)opyright by DG1XPZ");
  }//public String getAppletInfo()
}


