'**********************************************************
'Name                : wx27.bas
'Author              : DG1XPZ
'Purpose             : WX-Receiver
'Version             : V0.27www
'Compiler            : BasCom AVR 1.11.7.7
'Hardware            : - ELV-Wettersensorempfnger an RS232
'                      - LC-Display 24 * 2
'Bytes               : 2618
'Chip type           : 90S4433/Mega8 u.a.
'Bemerkung           : Die Aussen- u. Innensensoren werden, bei Auftreten, immer
'                      in der 1. Zeile angezeigt. Alle anderen Sensoren werden
'                      in der 2. Zeile angezeigt.
'History             : V0.26: Fehler in der Subroutine Punkt (Berechnung negative Temp)
'                             (Dank an Wolfgang DL7WA)
'**********************************************************

$regfile = "m8def.dat"                                      'ATmega8
'$regfile = "4433def.dat"                                    'AT90S4433
$crystal = 4000000                                          'Fuse-Bit0001=1MHz 0010=2MHz 0011=4MHz 0100=8MHz bei M8
Config Lcd = 24 * 2
Config Lcdpin = Pin , Db7 = Portb.2 , Db6 = Portb.4 , Db5 = Portb.5 , Db4 = Portc.2 , E = Portc.3 , Rs = Portb.3

'folgende Zeile nicht fr At90S4433
Config Com1 = Dummy , Databits = 8 , Parity = Odd , Stopbits = 2 , Synchrone = 0 , Clockpol = 0
$baud = 19200                                               'nur bei 0.92/1.23/1.843/4/8MHz sauber mglich

Declare Sub Addbyte(a As Byte , B As Byte)                  'Deklaration Sub-Routine

Dim Wx_frame(6) As Byte                                     'enthlt gesamtes WX-wx_framepaket
Dim I As Byte                                               'Zhlvariable
Dim Wx_count As Byte                                        'wx_framepakete fr WX zhlen (Index)
Dim Wx_in As Byte                                           'Byte von Com bernehmen
Dim Wx_ok As Bit                                            'wx_framepaket komplett und neu =1
Dim Wx_tmp As Word                                          'Temporre Wetter-Variable
Dim Tmp As Word                                             'Temporre Word-Variable
Dim Text As String * 24                                     'Sammelvariable fr LCD-Ausgabe
Dim Stmp As String * 3                                      'Temporre String-Variable

On Urxc Onrxd                                               'wenn wx_frame an RS232 anliegen, gehe zu ONRXD
Enable Urxc                                                 'Interupt Urxc aktiv

Enable Interrupts                                           'Interrupts global erlauben

Cursor Off                                                  'Cursor aus
Cls                                                         'Lsche LCD
Lcd "DG1XPZ-WX-Receiver V0.27"                              'Ausgabe auf LCD
Wait 1                                                      'warte 1 Sekunde

'----------------------
Do                                                          'Beginn der Schleife(Hauptprogramm)
 If Wx_ok = 1 Then                                          'wenn wx_framepaket komplett und neu
  Disable Interrupts                                        'Interupts sperren
  Call Addbyte(wx_frame(2) , Wx_frame(3))                   'High-Byte und Low-Byte zusammenfgen

  Locate 1 , 1                                              'LCD auf Beginn Zeile 1

  If Wx_frame(1) <= 31 And Wx_count > 0 Then                'z.B. 28=AussensensorV1.2(Kanal 4)
   Tmp = Wx_frame(1)
   Text = "A"                                               '"A"=Aussensensor hinzufgen
   Gosub Lcd_sensor_nr                                      'Sensornummer hinzufgen
   Gosub Punkt                                              'Wert + Komma(Punkt) einfgen
   Gosub Grad_c                                             'Maeinheit hinzufgen
   If Wx_frame(1) > 15 Then Text = Text + Str(wx_frame(4)) + "% "       'bei Sensor grer 15, Feuchte hinzufgen
   Gosub Addspace                                           'abschlieende Leerzeichen hinzufgen
   Gosub Print2lcd                                          'auf LCD ausgeben
  End If

  If Wx_frame(1) >= 64 And Wx_frame(1) <= 79 Then           'z.B. 68=Innensensor(Kanal 4)
   Tmp = Wx_frame(1) - 64                                   'Sensornummer berechnen
   Text = "I"                                               '"I" = Innensensor hinzufgen
   Gosub Lcd_sensor_nr                                      'Sensornummer hinzufgen
   Gosub Punkt                                              'Wert + Komma(Punkt) einfgen
   Gosub Grad_c                                             'Maeinheit hinzufgen
   Text = Text + Str(wx_frame(4)) + "% "                    'Luftfeuchte hinzufgen
   Call Addbyte(wx_frame(5) , Wx_frame(6))                  'High-Byte und Low-Byte zusammenfgen
   Gosub Lcd_tmp                                            'Luftdruck hinzufgen
    Text = Text + "hPa"
   Gosub Addspace                                           'abschlieende Leerzeichen hinzufgen
   Gosub Print2lcd                                          'auf LCD ausgeben
  End If

  Locate 2 , 1                                              'LCD auf Beginn Zeile 2

  If Wx_frame(1) >= 32 And Wx_frame(1) <= 47 Then           'Regensensoren
   Tmp = Wx_frame(1) - 32                                   'Sensornummer berechnen
   Text = "R"                                               '"R" = Regensensor hinzufgen
   Gosub Lcd_sensor_nr                                      'Sensornummer hinzufgen
   Wx_tmp = Wx_tmp * 4                                      '1 Impuls = 0.4L/qm
   Gosub Punkt                                              'Wert + Komma(Punkt) einfgen
   Text = Text + " L/qm(mm) "                               'Maeinheit hinzufgen
   Gosub Addspace                                           'abschlieende Leerzeichen hinzufgen
   Gosub Print2lcd                                          'auf LCD ausgeben
  End If

  If Wx_frame(1) >= 48 And Wx_frame(1) <= 63 Then           'z.B. 60=Windsensor V1.2(Kanal 4)
   Tmp = Wx_frame(1) - 48                                   'Sensornummer berechnen
   Text = "W"                                               '"W" = Windsensor hinzufgen
   Gosub Lcd_sensor_nr                                      'Sensornummer hinzufgen
   Gosub Punkt                                              'Wert + Komma(Punkt) einfgen
   Text = Text + "km/h "                                    'Maeinheit hinzufgen
   Call Addbyte(wx_frame(5) , Wx_frame(6))                  'High-Byte und Low-Byte zusammenfgen
   Gosub Lcd_tmp                                            'Windrichtung hinzufgen
   Text = Text + Chr(223)                                   'Grad-Symbol hinzufgen
   Gosub Addspace                                           'abschlieende Leerzeichen hinzufgen
   Gosub Print2lcd                                          'auf LCD ausgeben
  End If

  If Wx_frame(1) >= 88 And Wx_frame(1) <= 95 Then           'Helligkeitsensoren
   Tmp = Wx_frame(1) - 88                                   'Sensornummer berechnen
   Text = "H"                                               '"H" = Helligkeitsensor hinzufgen
   Gosub Lcd_sensor_nr                                      'Sensornummer hinzufgen
   Gosub Lcd_tmp                                            'Helligkeit hinzufgen
   For I = 1 To Wx_frame(4)                                 'Helligkeits-Faktor hinzufgen
     Text = Text + "0"
   Next I
   Text = Text + "Lx "                                      'Maeinheit hinzufgen
   Call Addbyte(wx_frame(5) , Wx_frame(6))                  'High-Byte und Low-Byte zusammenfgen
   Tmp = Wx_tmp / 60                                        'Berechne Sonnen-Stunden (gesamt)
   Text = Text + Str(tmp) + "h"                             'Sonnenscheindauer in h hinzufgen
   Tmp = Wx_tmp Mod 60                                      'Berechne Sonnen-Minuten (gesamt)
   Text = Text + Str(tmp) + "m "                            'Sonnenscheindauer in min hinzufgen
   Gosub Addspace                                           'abschlieende Leerzeichen hinzufgen
   Gosub Print2lcd                                          'auf LCD ausgeben
  End If
  Enable Interrupts                                         'Interrupts erlauben
  Wx_ok = 0                                                 'Wx_framepaket Ist Nicht Mehr Neu
 End If                                                     'Ende von IF wenn wx_framepaket komplett und neu war
 Idle                                                       'gehe in den Idle-Modus (aufwachen durch Urxc od. Interrupt)
Loop                                                        'gehe zum Beginn der Schleife
'-------------------
Onrxd:                                                      'Sprungziel fr Interrupt Urxc
  Disable Interrupts                                        'Interrupts sperren
  Wx_in = Udr                                               'Wert aus UART-Puffer einlesen
  If Wx_in = 2 Then Wx_count = 1                            'wenn Startzeichen(Wert=2) dann Index auf 1 setzen
  If Wx_in = 3 Then Wx_ok = 1                               'wenn Endzeichen(Wert=3) dann wx_framepaket komplett und neu
  If Wx_in > 3 Then                                         'wenn wx_frame dann
    Wx_in = Wx_in - 128                                     'Bit 7 eleminieren (ist immer gesetzt)
    Wx_frame(wx_count) = Wx_in                              'Wert in Array ablegen
    If Wx_count < 6 Then Incr Wx_count                      'Index um 1 erhhen
  End If
  Enable Interrupts                                         'Interrupts erlauben
Return                                                      'Zurck
'-------------------
Addspace:                                                   'Sprungziel um Text mit Leerzeichen aufzufllen
   If Len(text) < 24 Then                                   'ist Text krzer als 24 Zeichen
     Tmp = 24 - Len(text)                                   'Berechne Anzahl Leerzeichen
     Text = Text + Space(tmp)                               'Anzahl Leerzeichen hinzufgen
   End If
Return                                                      'Zurck
'-------------------
Print2lcd:                                                  'Sprungziel um Text auf LCD auszugeben
   Lcd Text                                                 'Text auf LCD ausgeben
Return                                                      'Zurck
'-------------------
Lcd_sensor_nr:                                              'Sprungziel um Sensornummer 2-stellig aufzuarbeiten
  Stmp = Str(tmp)                                           'in String umwandeln
  Stmp = Format(stmp , "00")                                '2-stellig mit fhrender 0
  Text = Text + Stmp + ":"                                  'Sensornummer zu Text hinzufgen
Return                                                      'Zurck
'-------------------
Lcd_tmp:                                                    'Sprungziel um Wert in String zu wandeln
  Text = Text + Str(wx_tmp)                                 'fge Wert zu Text hinzu
Return                                                      'Zurck
'-------------------
Grad_c:                                                     'Sprungziel um Gradsymbol zu Text hinzuzufgen
  Text = Text + Chr(223) + "C "
Return                                                      'Zurck
'-------------------
Punkt:                                                      'Sprungziel um Punkt und Minus in den Wert einzuarbeiten
  If Wx_tmp >= 16085 Then                                   'wenn Temperatur negativ (bis -29.9 Grad C)
    Wx_tmp = 16384 - Wx_tmp                                 'Wert abziehen
    Text = Text + "-"                                       'Minus hinzufgen
  End If
  Tmp = Wx_tmp / 10                                         'Vorkommastelle abtrennen
  Text = Text + Str(tmp) + "."                              'Vorkommastelle + Punkt hinzufgen
  Tmp = Wx_tmp Mod 10                                       'Nachkommastelle abtrennen
  Text = Text + Str(tmp)                                    'Nachkommastelle hinzufgen
Return                                                      'Zurck
'-------------------
Sub Addbyte(a As Byte , B As Byte)                          'Sub-Routine um High-Byte und Low-Byte zusammenzufgen
  Wx_tmp = A                                                'High-Byte bernehmen
  Shift Wx_tmp , Left , 7                                   'um 7 Bit nach links schieben
  Wx_tmp = Wx_tmp + B                                       'Low-Byte hinzufgen
End Sub                                                     'Ende Sub-Routine
'-------------------

End                                                         'Programm-Ende