/*------------------------------------------------------------------*/
/*  yhf_type.h     (data types)                                     */
/*                                                                  */
/*  Used in various parts of DL4YHF's Spectrum Lab .                */
/*                                                                  */
/*  Author:   Wolfgang Buescher,  DL4YHF .                          */
/*  Original: C:\CBproj\YHF_Tools\yhf_type.h (various copies used!) */
/*                                                                  */
/* Revision History:                                                */
/*  June 2002:  first usage in DL4YHF's Spectrum Laboratory .       */
/*  Oct. 2002:  This header also used in various "sound utilities". */
/*  Jan. 2006:  Added DATA_TYPE_BOOL                                */
/*  Mar. 2006:  Added an empty trailing line for GNU-C (Dev-C++) .  */
/*                                                                  */
/*------------------------------------------------------------------*/


#ifndef _DATA_TYPES_H_
 #define _DATA_TYPES_H_ 1 /* revision code!*/

 #define DATA_TYPE_UNKNOWN  0

 #define DATA_TYPE_INT8     1
 #define DATA_TYPE_INT16    2
 #define DATA_TYPE_INT32    3
 #define DATA_TYPE_INT64    4
 #define DATA_TYPE_FLOAT32  5
 #define DATA_TYPE_FLOAT64  6   /* same as "double" .. */
 #define DATA_TYPE_CSTRING  7

 #define DATA_TYPE_BOOL     9   /* "BOOL" (not Borland's "boolean" ! ) */
 #define DATA_TYPE_USER1    10

 // Machine dependent and "compatibility" defs:
 #define DATA_TYPE_INT      DATA_TYPE_INT32
 #define DATA_TYPE_LONG     DATA_TYPE_INT32
 #define DATA_TYPE_DOUBLE   DATA_TYPE_FLOAT64


#endif
/* EOF <yhf_type.h> . Note: GNU C needs an empty line after this ! */
