/****************************************************************************/
/* YHF_Help.cpp: Translates calls to the old lousy WinHelp system           */
/*               into calls of an HTML browser.                             */
/*               NO APPLICATION-SPECIFIC STUFF IN HERE !                    */
/*               This unit is used in a number of projects (see history).   */
/*                                                                          */
/* Author and Copyright by:                                                 */
/*   Wolfgang Buescher (DL4YHF)                                             */
/*                                                                          */
/* Revision History:                                                        */
/*  V1.0, xx.xx.2000:  Created for DL4YHF's "Spectrum Lab".                 */
/*                     Started as a wrapper for WinHelp.                    */
/*  V1.1, 09.09.2001:  Modified the whole thing to get rid of WinHelp       */
/*                     and Microstuff's LOUSY HELP COMPILER.                */
/*                     From now on, an HTML browser is required to view the */
/*                     help pages (does not require the lousy "HTML HELP"-  */
/*                     system propagated by Microstuff as well !)           */
/*      19.09.2001:  Now also used at the QRL - keep it compatible !        */
/*      16.10.2001:  Used for a second project at the QRL, still compatible */
/*  V1.2, 2001-11-30:  Modified to make jumps to ANCHORS possible.          */
/*                     Requires analysis of the REGISTRY to find the full   */
/*                     path name of the standard HTML browser - yucc...     */
/*  V1.3, 2002-05-27:  Multi-Language support added.                        */
/*  V1.4, 2002-08-20:  On some f***** new system the command line for the   */
/*                     HTML browser didn't work.  Added debugging aids...   */
/*        2003-10-09:  Also used for the CAN LOGGER CONFIGURATION           */
/*                                        / FILE CONVERSION UTILITY now  .  */
/*  V1.5, 2003-11 :  Problems with the modified help system (OnHelp-event): */
/*             Turned out to be caused by ANOTHER BORLAND BUG !!            */
/*             The same bug was reported by other users of                  */
/*             DELPHI6 and BCB6 but no official response from Borland yet.  */
/*       Workaround:  No simple fix, see TMainForm::ShowHelpContext() .     */
/*                    There is a crude workaround for DELPHI 6              */
/*                    which also works for CBUILDER 6 : "D6OnHelpFix.pas"   */
/*  V1.6, 2004-01-29: Tried to get rid of the "html browser path"           */
/*             because some users (including the author himself) do not use */
/*             IEXPLORE.EXE as their standard browser, but Mozilla Firebird */
/*             (for example). It is possible to "Open" any document these   */
/*             days, without even knowing "how-to" - ShellExecute()         */
/*             will know how.                                               */
/*          If the application sets YHF_HELP_fUseIexplore=FALSE before      */
/*           calling bool YHF_HELP_ShowHtml() or similar, this may work.    */
/*             Many years later (2007) this didn't work any longer, when    */
/*             the damned windoze shell stripped the anchor from the file,  */
/*             so the shell-"Open" command cannot be used any longer .      */
/*  V1.7, 2007-04-28: Trying to use OPERA or FIREFOX before IE, because IE7 */
/*     doesn't jump to the named anchor passed in the URI via command line. */
/*                                                                          */
/****************************************************************************/

#define L_MAY_USE_OPERA   1  /* set this flag to ZERO if you don't like OPERA */
#define L_MAY_USE_FIREFOX 1  /* set this flag to ZERO if you don't like FIREFOX */
       /* If you set BOTH flags to zero, you will find out how BAD IE7 is ;-) */


// #include "VCL.H"    // 2007-04-26: removed the VCL dependency - hooray !
#include "windows.h"
#include "ShellApi.h"

// #pragma hdrstop   // Borland Stuff. No precompiled headers after this.

#include "YHF_Help.h"   // header file for this module

#pragma warn -8071  /* "conversion may lose significant digits" - thanks */


//---------------- Internal and initialized variables -----------------------
char YHF_sz500HelpHtmlPath[512] = "";
HWND YHF_hwndHelpParentWindow = NULL;
T_YHF_HelpMapEntry *YHF_pHelpMapTable = NULL;
char YHF_HELP_szLastError[256]= "not initialized"; // only valid if last call failed !
BOOL YHF_HELP_fUseIexplore = FALSE;    // published in the header since 2004-01-29
char YHF_HELP_sz511HtmlBrowserPath[512] = "\0"; // path+file+options for html browser
char YHF_HELP_sz1023LastBrowserCommandLine[1024] = "\0";  // used for debugging
int YHF_HELP_iLanguageCode=0/*dunno*/; // 01=english, 49=german, etc (int'l dialing code)

char YHF_HELP_cCurrentBrowser='\0';  // 'O'=Opera, 'F'=Firefox, 'I'=IE
BOOL YHF_HELP_fOperaFailed   = FALSE;
BOOL YHF_HELP_fFirefoxFailed = FALSE;

//---------------- Implementation of routines -------------------------------

/****************************************************************************/
int YHF_HELP_Init(
            HWND hwndParentWindow,  // handle of the application's main window
            char *html_file_path,   // base path to the html files
     T_YHF_HelpMapEntry *pHelpMap,  // pointer to a list (translation table)
            int  iLanguageCode )    // usually the international dialing code
  // Initialises the HTML-based help system.
  //   Requires the window handle of the calling application,
  //   a path to the directory where the help files are located
  //           (WITH or WITHOUT trailing backslash)
  //   and a pointer to a conversion table from WinHelp 'context number'
  //   to an HTML reference (filename and -optionally- anchor name).
  // On Closure, the user should call YHF_HELP_Exit .
{
 int n;

  YHF_HELP_iLanguageCode = iLanguageCode;
  strncpy(YHF_sz500HelpHtmlPath, html_file_path, 500 );
  n = strlen(YHF_sz500HelpHtmlPath);
  if( n>0)
   { // see help on AnsiString : the rotten index starts at "1" for the 1st char
     if( YHF_sz500HelpHtmlPath[n-1] != '\\')
      {  YHF_sz500HelpHtmlPath[n]   = '\\';
         YHF_sz500HelpHtmlPath[n+1] = '\0';
      }
   }
  YHF_hwndHelpParentWindow = hwndParentWindow;
  YHF_pHelpMapTable = pHelpMap;

  return YHF_pHelpMapTable != NULL;
} // end HELP_Init


/****************************************************************************/
BOOL YHF_HELP_QueryRegistryValue(
                 HKEY hKey,   // handle (or identifier) of key to query
           char * pszSubKey,   // address of name of subkey to query
           char * pszResult, int iMaxResultLength )
  // Registry Query to detect the standard HTML browser of this system.
  // Called from YHF_HELP_ShowHtml() because we had to call IEXPLORE.EXE
  //    (or whatever) with a full path, to be able to jump to a certain
  //    ANCHOR in the HTML document !!
  // To query the path+filename of the standard HTML browser, use..
  //    hkey      = HKEY_CLASSES_ROOT
  //    pszSubKey = \htmlfile\shell\open\command
  // The result should be something like..
  //    "c:\Programme\Internet Explorer\iexplore.exe"
  // This routine MAY be called before the "Init"-routine of this module,
  // because we may need the htlm browser path as a default value before
  // loading some kind of 'configuration data' from an INI-file !
{
 LONG lResult;
 LONG lRequiredBufferSize;

  // lResult = RegQueryValue(
  //               HKEY hKey,   // handle of key to query
  //        LPCTSTR lpSubKey,   // address of name of subkey to query
  //          LPTSTR lpValue,   // address of buffer for returned string
  //         PLONG lpcbValue);  // address of buffer for size of returned string
  // Parameters for RegQueryValue()
  //  hKey
  //     Identifies a currently open key or any of the following predefined
  //     reserved handle values:
  //         HKEY_CLASSES_ROOT
  //         HKEY_CURRENT_USER
  //         HKEY_LOCAL_MACHINE
  //         HKEY_USERS
  //  lpSubKey
  //     Points to a null-terminated string containing the name of the subkey
  //     of the hKey parameter for which a value is to be retrieved.
  //     If this parameter is NULL or points to an empty string,
  //     the function retrieves the value set by the RegSetValue function
  //     for the key identified by hKey.
  //
  //  lpValue
  //     Points to a buffer that receives the value associated with the
  //     lpSubKey parameter. The buffer should be big enough to contain
  //     the terminating null character. This parameter can be NULL
  //     if the data is not required.
  //     If lpValue is NULL, and lpcbValue is not NULL, the function places
  //     the size in bytes of the data referenced by the value key, including
  //     the terminating null character, into the variable pointed to
  //     by lpcbValue. This lets an application determine how to best
  //     preallocate a buffer for the value key's data.
  //
  //  lpcbValue
  //     Points to a variable specifying the size, in bytes, of the buffer
  //     pointed to by the lpValue parameter. When the function returns,
  //     this variable contains the size of the data copied to lpValue,
  //     including the terminating null character.
  //
  // If the buffer specified by lpValue parameter is not large enough to
  // hold the data, the function returns the value ERROR_MORE_DATA,
  // and stores the required buffer size, in bytes, into the variable
  // pointed to by lpcbValue.
  // If lpValue is NULL, the function returns ERROR_SUCCESS, and stores
  // the size of the string, in bytes, into the variable pointed to
  // by lpcbValue. This lets an application determine the best way
  // to allocate a buffer for the value key's data.
  //
  //     In all cases the value returned in lpcbValue always includes
  //     the size of the terminating null character in the string.
  //
  // Return Values
  //     If the function succeeds, the return value is ERROR_SUCCESS.
  //     If the function fails, the return value is a nonzero error code
  //     defined in WINERROR.H. You can use the FormatMessage function
  //     with the FORMAT_MESSAGE_FROM_SYSTEM flag to get a generic
  //     description of the error.
  //
  // Remarks
  //     The key identified by the hKey parameter must have been opened
  //     with KEY_QUERY_VALUE access (KEY_READ access includes
  //     KEY_QUERY_VALUE access).
  //     If the ANSI version of this function is used (either by explicitly
  //     calling RegQueryValue or by not defining Unicode before including
  //     the WINDOWS.H file), this function converts the stored Unicode string
  //     to an ANSI string before copying it to the buffer specified by the
  //     lpValue parameter.
  lRequiredBufferSize = iMaxResultLength;
  lResult = RegQueryValue( hKey, pszSubKey,
                  pszResult,   // address of buffer for returned string
       &lRequiredBufferSize);  // address of buffer for size of returned string
  if( (lResult!=ERROR_SUCCESS) || (lRequiredBufferSize>iMaxResultLength) )
     return FALSE;            // Error, the caller's buffer is too small
   else
     return TRUE;             // all ok

} // end YHF_HELP_QueryRegistryValue(


/****************************************************************************/
void YHF_HELP_Exit(void)
  // Closes the HTML-based help system.
  // One fine day, this will be used to close the explorer window
  //  if it has been opened by the help-system.
{
} // end YHF_HELP_Exit


/****************************************************************************/
void YHF_HELP_ExecErrorCodeToString(DWORD dwErrorCode)
  // Converts an error code returned by ShellExecute into a readable string.
{
  switch(dwErrorCode)
   {
     case ERROR_FILE_NOT_FOUND:
  // case SE_ERR_FNF:
          strcpy(YHF_HELP_szLastError,"The specified file was not found");
          break;
     case ERROR_PATH_NOT_FOUND:
  // case SE_ERR_PNF:
          strcpy(YHF_HELP_szLastError,"The specified path was not found.");
          break;
     case ERROR_BAD_FORMAT:
          strcpy(YHF_HELP_szLastError,"The .EXE file is invalid (non-Win32 .EXE or error in .EXE image).");
          break;
     case SE_ERR_ACCESSDENIED:
          strcpy(YHF_HELP_szLastError,"The operating system denied access to the specified file.");
          break;
     case SE_ERR_ASSOCINCOMPLETE:
          strcpy(YHF_HELP_szLastError,"The filename association is incomplete or invalid.");
          break;
     case SE_ERR_DDEBUSY:
          strcpy(YHF_HELP_szLastError,"The DDE transaction could not be completed because other DDE transactions were being processed.");
          break;
     case SE_ERR_DDEFAIL:
          strcpy(YHF_HELP_szLastError,"The DDE transaction failed.");
          break;
     case SE_ERR_DDETIMEOUT:
          strcpy(YHF_HELP_szLastError,"The DDE transaction could not be completed because the request timed out.");
          break;
     case SE_ERR_DLLNOTFOUND:
          strcpy(YHF_HELP_szLastError,"The specified dynamic-link library was not found.");
          break;
     case SE_ERR_NOASSOC:
          strcpy(YHF_HELP_szLastError,"There is no application associated with the given filename extension.");
          break;
     case SE_ERR_OOM:
          strcpy(YHF_HELP_szLastError,"There was not enough memory to complete the operation.");
          break;
     case SE_ERR_SHARE:
          strcpy(YHF_HELP_szLastError,"A sharing violation occurred.");
          break;
     default:
          strcpy(YHF_HELP_szLastError,"Unknown error code from ShellExecute.");
          break;
   }
} // end YHF_HELP_ExecErrorCodeToString()


/****************************************************************************/
BOOL YHF_HELP_MakeLanguageSpecificHelpFileName(
             char *pszTemplateHelpFileName,  // like "index_NN.htm"
             int  iLanguageCode,             // like 49 for germany
             char *psz255LanguageFileName )  // result: "index_49.htm"
{
 char *cp;
 BOOL fResult = FALSE;

  strncpy(psz255LanguageFileName, pszTemplateHelpFileName, 255);
  psz255LanguageFileName[255]='\0';
  // Versuchen, den Suffix "NN" im HTML-Dateinamen durch einen eventuell
  // vorhandenen zweiziffrigen Nationalitaeten-Code zu ersetzen.
  // Als Zahlencode dienen die internationalen Vorwahlcodes, z.B.
  // 01 = English (US),  49=Deutsch,  etc.
  cp=strrchr(psz255LanguageFileName,'.');
  if( (cp!=NULL) && cp>(psz255LanguageFileName+3) )
   { cp-=2;  // Pointer koennte jetzt theoretisch auf "NN" zeigen..
     if(cp[0]=='N' && cp[1]=='N')
      {   // Bingo, der Dateinamen schreit nach Ersatz durch den dial code...
       if(iLanguageCode>0)
        {
         fResult = TRUE;
         cp[0] = '0' + ( (iLanguageCode/10) %10);   // Zehner
         cp[1] = '0' + (  iLanguageCode %10);       // Einer
        }
       else // Der Dateiname schreit nach Einsetzen eines dial codes,
        {   //  wir haben aber leider keinen.....
         cp[0] = '0';
         cp[1] = '1';   // the U.S. guys will like to see this ;-)
        }
      } // end if <placeholder for int'l dialing code in the file name found>
   }
 return fResult;
} // end YHF_HELP_MakeLanguageSpecificHelpFileName()

/****************************************************************************/
BOOL YHF_HELP_IsLetter( char c )
{ return (c>='A' && c<='Z') || (c>='a' && c<='z');
}

/****************************************************************************/
BOOL YHF_HELP_DOSFilePathToURI(  // Only works with DOS paths, not "UNC's" !
        char * pszFilePathAndName, // in:  DOS file path + name
        char * pszFileURI,         // out: file "URI"
        int  iMaxURILength )       // max length of pszFileURI
  // A valid URI of a file on the "local" HD looks like this:
  // file:///C:/Documents%20and%20Settings/davris/FileSchemeURIs.doc
{
  char c;
  char *pszSrc = pszFilePathAndName;
  char *pszDst = pszFileURI;
  int src_len;
  src_len = strlen(pszFilePathAndName);
  if( src_len > 3 )
   {
     strcpy(pszDst, "file://" );
     pszDst += strlen(pszDst);
     // If the source path contains a DRIVE LETTER, add it, with another slash !
     if( YHF_HELP_IsLetter(pszSrc[0]) && (pszSrc[1]==':') )
      { *(pszDst++) = '/';          // add anoter slash, followed by the drive
        strncpy(pszDst, pszSrc, 2); // copy drive letter + ':'
        pszDst += 2; pszSrc += 2;
      }
     else // if the source path does NOT begin with a drive letter...
      { // don't do anything here.
      }
     // copy the rest of the path, replacing a few characters:
     while(    ( (c=*(pszSrc++)) != 0)
            && (pszDst<(pszFileURI+iMaxURILength+4) )
          )
      { // Characters that are important to URI parsing
        // that are also allowed in Windows file paths
        // must be percent-encoded .
        // Based on http://en.wikipedia.org/wiki/Percent-encoding
        switch(c)
         { case '\\':  // replace backslash with forward slash
              *pszDst++ = '/';
              break;
           case ' ': strcpy(pszDst, "%20" );  pszDst += 3;  break;
           case '!': strcpy(pszDst, "%21" );  pszDst += 3;  break;
           case '*': strcpy(pszDst, "%2A" );  pszDst += 3;  break;
           case '\'': strcpy(pszDst,"%27" );  pszDst += 3;  break;
           case '(': strcpy(pszDst, "%28" );  pszDst += 3;  break;
           case ')': strcpy(pszDst, "%29" );  pszDst += 3;  break;
           case ';': strcpy(pszDst, "%3B" );  pszDst += 3;  break;
           case '@': strcpy(pszDst, "%40" );  pszDst += 3;  break;
           case '&': strcpy(pszDst, "%26" );  pszDst += 3;  break;
           case '=': strcpy(pszDst, "%3D" );  pszDst += 3;  break;
           case '+': strcpy(pszDst, "%2B" );  pszDst += 3;  break;
           case '$': strcpy(pszDst, "%24" );  pszDst += 3;  break;
           case ',': strcpy(pszDst, "%2C" );  pszDst += 3;  break;
           case '/': strcpy(pszDst, "%2F" );  pszDst += 3;  break;
           case '?': strcpy(pszDst, "%3F" );  pszDst += 3;  break;
           case '%': strcpy(pszDst, "%25" );  pszDst += 3;  break;
           case '#': strcpy(pszDst, "%23" );  pszDst += 3;  break;
           case '[': strcpy(pszDst, "%5B" );  pszDst += 3;  break;
           case ']': strcpy(pszDst, "%5D" );  pszDst += 3;  break;
           // Note: The characters - and _ shouldn't be percent-encoded,
           //       as stated by the URI standard.
           default: // let everything else pass unmodified .
              *pszDst++ = c;
              break;
         }
      } // end while
     *pszDst = '\0';
     return TRUE;
   }
  else // src_len < 3, copy 1:1
   { strncpy( pszFileURI, pszFilePathAndName, iMaxURILength );
     return FALSE;
   }
} // end YHF_HELP_DOSFilePathToURI()


/****************************************************************************/
bool YHF_HELP_ShowHtml(char * html_file_name, char * anchor_name)
  // Opens a help screen, using an HTML browser.
  // Parameters:
  //     html_file_name = just the file with extension,
  //                      NO PATH (will automatically be added,
  //                      usually depending on the installed LANGUAGE)
  //
  //     anchor_name = Used to jump to a certain position INSIDE the
  //                      HTML document.
  //                      Sometimes called "Marker" by strange programs.
  //                      Its a shame that browsers do not support
  //                      jumping to anchors FROM THE COMMAND LINE yet...
  //
  // Return value:
  //     TRUE  = ok
  //     FALSE = error (look at YHF_HELP_szLastError in this case !)
  //
  // Example:  HELP_ShowHtml("index.htm", NULL)
  //
{
 char sz255LanguageFileName[256];
 char sz1kCmdLine[1024];
 char sz1kDOSFileWithPath[1024];
 char sz1kFileURI[1024];
 char *cp;
 DWORD retcode=0;
 BOOL  ok;

  // Replace the 'NN' in the help file name with the language code :
  YHF_HELP_MakeLanguageSpecificHelpFileName(
            html_file_name,  //   char *pszTemplateFileName
            YHF_HELP_iLanguageCode,
            sz255LanguageFileName ); // char *psz255LanguageFileName
  strcpy(sz1kDOSFileWithPath,YHF_sz500HelpHtmlPath );
  strcat(sz1kDOSFileWithPath, sz255LanguageFileName );
  YHF_HELP_DOSFilePathToURI( // Convert DOS-PATH+FILE  into "file URI" ..
     sz1kDOSFileWithPath,    // in:  DOS file path + name
     sz1kFileURI, 800 );     // out: file "URI"
  // Tell the HTML-Browser to jump to an 'anchor' inside the HTML document.
  // This worked perfectly with IE4, IE5, IE6, but fails with IE7.
  // Shit.  Read the "long, long" story somewhere below.  Or use FIREFOX !
  if(anchor_name != NULL)
   { if(anchor_name[0] > 32)
      { strcat(sz1kFileURI, "#");
        strcat(sz1kFileURI, anchor_name);
      }
   }


  // If not done yet, try to locate the user's standard HTML browser .
  //      For some STRANGE REASON (the "anchor stripping problem")
  //      we need to know the full path to invoke the browser later.
  // There were a few matches for a search for "IEXPLORE.EXE" using RegEdit,
  // including these locations (on a German windoze installation..) :
  //   - HKEY_CLASSES_ROOT\htmlfile\shell\open\command  (sounds good!)
  //   - HKEY_LOCAL_MACHINE\Software\CLASSES\htmlfile\shell\open\command
  // But since IE7 doesn't allow opening a file AND jumping to a certain
  //  named anchor, the author prefers FIREFOX or OPERA for the help system.
#if ( L_MAY_USE_OPERA )
  if( (!YHF_HELP_fOperaFailed) && (YHF_HELP_sz511HtmlBrowserPath[0]=='\0') )  // Try OPERA...
   {  // if the browser path is still known, try to locate OPERA (better than IE7)
     if ( YHF_HELP_QueryRegistryValue(
              HKEY_CLASSES_ROOT, // handle (or identifier) of key to query
         "Opera.HTML\\shell\\open\\command",  // hello Firefox, where are you ?
         YHF_HELP_sz511HtmlBrowserPath, sizeof(YHF_HELP_sz511HtmlBrowserPath) ) )
      { // Bingo, we have found the path to OPERA, and some parameters.
        // The result (read from the registry) is usually something like this:
        //    "C:\Programme\Opera\Opera.exe" "%1"
        // Strip the "%1" thingy, because the URL will be appended
        //  to YHF_HELP_sz511HtmlBrowserPath later .
        cp = strchr( YHF_HELP_sz511HtmlBrowserPath, '%' );
        if( cp!=NULL && cp>(YHF_HELP_sz511HtmlBrowserPath+1)
            && cp[-1]=='"' && cp[-2]==' ' )
         { cp[-2] = '\0';  // truncate the "%1" when found (including the space)
         }
        YHF_HELP_cCurrentBrowser = 'O';  // using OPERA now
      }
     else // Opera doesn't seem to be installed on this system:
      { YHF_HELP_fOperaFailed = TRUE;    // don't try again
      }
   } // end if(YHF_HELP_sz511HtmlBrowserPath[0] == '\0'), try OPERA
#endif // ( L_MAY_USE_OPERA )

  // If OPERA was not found, try to find the full path to FIREFOX
  // ( we'll need it later, because just calling "firefox" without
  ///  path seems to strip the ANCHOR from the URI again ).
  // Initially only used the key
  //   HKEY_CLASSES_ROOT\Applications\FIREFOX.EXE\shell\open\command
  // to find the firefox path; but that registry entry didn't exist
  // on all systems. So try something else, if the first key fails:
  //   HKEY_CLASSES_ROOT\FirefoxHTML\shell\open\command
#if ( L_MAY_USE_FIREFOX )
  if( (!YHF_HELP_fFirefoxFailed) && (YHF_HELP_sz511HtmlBrowserPath[0]=='\0'))  // try FIREFOX ...
   {  // if the internet browser path is unknown, try to locate FIREFOX (better than IE7)
     ok = YHF_HELP_QueryRegistryValue(
         HKEY_CLASSES_ROOT, // handle (or identifier) of key to query
         "FirefoxHTML\\shell\\open\\command",  // hello Firefox, where are you ? ?
         YHF_HELP_sz511HtmlBrowserPath, sizeof(YHF_HELP_sz511HtmlBrowserPath) );
     if( ! ok )
      { ok = YHF_HELP_QueryRegistryValue(
         HKEY_CLASSES_ROOT, // handle (or identifier) of key to query
         "Applications\\FIREFOX.EXE\\shell\\open\\command", // found on some machines
         YHF_HELP_sz511HtmlBrowserPath, sizeof(YHF_HELP_sz511HtmlBrowserPath) );
      }
     if( ok )
      { // Bingo, we have found the path to FIREFOX, and some parameters.
        // The result (read from the registry) is usually something like this:
        //    C:\PROGRA~1\MOZILL~1\FIREFOX.EXE -url "%1"
        // or C:\PROGRA~1\MOZILL~1\FIREFOX.EXE -url "%1" -requestPending
        // Strip the "%1" thingy, because the URL will be appended
        //  to YHF_HELP_sz511HtmlBrowserPath later :
        // ex: cp = strtok(YHF_HELP_sz511HtmlBrowserPath, "\"%1\"");
        // avoid "strtok", it sucks (truncates AFTER the token but doesn't return
        //  a pointer to where the token was found), and it uses hidden statics.
        cp = strchr( YHF_HELP_sz511HtmlBrowserPath, '%' );
        if( cp!=NULL && cp>(YHF_HELP_sz511HtmlBrowserPath+1)
            && cp[-1]=='"' && cp[-2]==' ' )
         { cp[-2] = '\0';  // truncate the "%1" when found (including the space)
         }
        YHF_HELP_cCurrentBrowser = 'F';  // using FIREFOX now
      }
     else // Firefox doesn't seem to be installed on this system:
      { YHF_HELP_fFirefoxFailed = TRUE;
      }
   } // end if(YHF_HELP_sz511HtmlBrowserPath[0] == '\0'), try FIREFOX
#endif  // ( L_MAY_USE_FIREFOX )


  if(YHF_HELP_sz511HtmlBrowserPath[0] == '\0')
   { // if the internet browser path is still unknown, try to locate the "default" browser,
     // which is often IE7 (yucc)  even if a better browser is installed !
     if (! YHF_HELP_QueryRegistryValue(
              HKEY_CLASSES_ROOT, // handle (or identifier) of key to query
      "htmlfile\\shell\\open\\command",   // address of name of subkey to query
      YHF_HELP_sz511HtmlBrowserPath, sizeof(YHF_HELP_sz511HtmlBrowserPath) ) )
      {  // shit, could not find a registry entry for the shell's standard HTML browser
        strcpy(YHF_HELP_szLastError,"Couldn't find the HTML browser");
        strcpy(YHF_HELP_sz511HtmlBrowserPath, "IEXPLORE" );
      }
     else
      { // ok, now we know what to use as HTML browser..
        // the result in YHF_HELP_sz511HtmlBrowserPath could be something like:
        // "C:\Programme\Internet Explorer\IEXPLORE.EXE" -nohome  (no C notation)
        // But unfortunately, even if Firefox is the default browser,
        // we still find that "IEXPLORE" thingy in
        //   HKEY_CLASSES_ROOT "htmlfile\\shell\\open\\command"
        cp = strchr( YHF_HELP_sz511HtmlBrowserPath, '%' );
        if( cp!=NULL && cp>(YHF_HELP_sz511HtmlBrowserPath+1)
            && cp[-1]=='"' && cp[-2]==' ' )
         { cp[-2] = '\0';  // truncate the "%1" when found
                           // (including the space, and the double quotes)
         }
      }
   } // end if(YHF_HELP_sz511HtmlBrowserPath[0] == '\0'), THIRD attempt to find the browser


  //-----   At this point, we should know the browser's complete path --------


  // FIRST ATTEMPT / ERSTER VERSUCH *MIT* komplettem HTML-Browser-Pfad :
  // Kommandozeile fuer irgendein Programm zusammenbasteln,
  //  mit dem HTML-Dokumente auf diesem System angezeigt werden koennen.
  //    Meistens weiss der "Explorer" wie das geht.
  //    Achtung: "Explorer" != "InternetExplorer"
  //              (koennte auch Netscape oder sonstwas sein...)
  // ex: cmdline = "explorer "  // geht das auch irgendwie etwas universeller ?
  // ex:   + HelpHtmlPath + html_file_name;
  // ex: WinExec( cmdline.c_str(), SW_SHOWNORMAL );
  // ex: strcpy( sz1kCmdLine, "\"" );  // NO-NO-NO, because the browser path
  //   found in the registry is already embedded in double quotes if necessary !
  strcpy( sz1kCmdLine, YHF_HELP_sz511HtmlBrowserPath );
  // ex: strcat( sz1kCmdLine, "\" " );
  strcat( sz1kCmdLine, " \"" );       // URI in double quotes - necessary ?!
  strcat( sz1kCmdLine, sz1kFileURI );
  strcat( sz1kCmdLine, "\"" );
  strncpy(YHF_HELP_sz1023LastBrowserCommandLine, sz1kCmdLine, 1023);
#define L_METHOD 0
#if(L_METHOD==0)
  retcode=WinExec(       // Note: This didn't work with IE7 for strange reasons
         sz1kCmdLine,    // address of command line
         SW_SHOWNORMAL); // window style for new application
#endif
#if(L_METHOD==1)
  // Opens firefox = default browser, BUT STRIPS THE ANCHOR NAME !
  retcode = (DWORD)ShellExecute(  // See Win32 Programmer's Reference
        YHF_hwndHelpParentWindow, // HWND hwnd = handle to parent window
        "open",      // LPCTSTR lpOperation = pointer to string that specifies operation to perform
        sz1kFileURI, // LPCTSTR lpFile = pointer to filename or folder name string
        NULL,        // LPCTSTR lpParameters = pointer to string that specifies executable-file parameters
        NULL,        // LPCTSTR lpDirectory = pointer to string that specifies default directory
       SW_SHOWNORMAL); // .. whether file is shown when opened
#endif
#if(L_METHOD==2)
  // Opens firefox = default browser, BUT STRIPS THE ANCHOR NAME !
  retcode = (DWORD)ShellExecute(  // See Win32 Programmer's Reference
        YHF_hwndHelpParentWindow, // HWND hwnd = handle to parent window
        "firefox",   // LPCTSTR lpOperation = pointer to string that specifies operation to perform
        sz1kFileURI, // LPCTSTR lpFile = pointer to filename or folder name string
        NULL,        // LPCTSTR lpParameters = pointer to string that specifies executable-file parameters
        NULL,        // LPCTSTR lpDirectory = pointer to string that specifies default directory
       SW_SHOWNORMAL); // .. whether file is shown when opened
#endif
#if(L_METHOD==3)
  // Opens firefox = default browser, BUT ALSO STRIPS THE ANCHOR NAME !
  strcpy( sz1kCmdLine, "firefox " );
  strcat( sz1kCmdLine, sz1kFileURI );
  strncpy(YHF_HELP_sz1023LastBrowserCommandLine, sz1kCmdLine, 1023);
  retcode=WinExec(       // Note: This didn't work with IE7 for strange reasons
         sz1kCmdLine,    // address of command line
         SW_SHOWNORMAL); // window style for new application
#endif
#if(L_METHOD==4)
  // Opens firefox = default browser, BUT ALSO STRIPS THE ANCHOR NAME !
  // strcpy( sz1kCmdLine, "firefox.exe -url \"" ); // <<< does NOT work with anchor
  // Only when the full path to firefox is specified, it jumps to the anchor.
  // But how to find that full path ? In the registry, the author found:
  // * HKEY_CLASSES_ROOT\Applications\FIREFOX.EXE\shell\open\command
  // with the following value:
  //   C:\PROGRA~1\MOZILL~1\FIREFOX.EXE -url "%1"
  strcpy( sz1kCmdLine, "\"C:\\Programme\\Mozilla Firefox\\firefox.exe\" -url \"" );
  strcat( sz1kCmdLine, sz1kFileURI );
  strcat( sz1kCmdLine, "\" -requestPending" );
  strncpy(YHF_HELP_sz1023LastBrowserCommandLine, sz1kCmdLine, 1023);
  retcode=WinExec(       // Note: This didn't work with IE7 for strange reasons
         sz1kCmdLine,    // address of command line
         SW_SHOWNORMAL); // window style for new application
#endif


  if( retcode > 32)
   {
     return TRUE;  // "WinExec" successful (but no idea if the HTML file
                   //      is already visible on the screen !!!!)
   }
  else  // must try something else !
   {
     switch( YHF_HELP_cCurrentBrowser )
      { case 'O':  // was using OPERA, but failed:
           YHF_HELP_fOperaFailed = TRUE;   // try the next browser !
           break;
       case 'F':  // was using FIREFOX, but failed:
           YHF_HELP_fFirefoxFailed = TRUE; // try the next browser !
           break;
       default:
           break;
      }
   }

  // To make this work with IE7, hold your breath, and read the following
  // long, long story (the author had a lot of fun with it... GRRRRRRRRR)
  // Was frueher mal (mit IE4..IE6) funktionierte :
  //     "iexplore c:\cbproj\cantest\help\win_can1.htm#ErrorMessages"
  //     (Ermoeglicht den Sprung an eine ganz bestimmte Stelle im HTML-Text,
  //     sehr praktisch, geht aber leider nur mit "iexplore"
  //     aber nicht mit "explore"....)
  // Mit IE7 funktionierte das (mit dem Anchor) dann nicht mehr, denn:
  //  (http://blogs.msdn.com/ie/archive/2006/12/06/file-uris-in-windows.aspx)
  // > File URIs in Windows
  // > Invalid file URIs are among the most common illegal URIs
  // > that we were forced to accommodate in IE7...
  // > In order to avoid ambiguity, and for your Windows file paths to be
  // > interpreted correctly, characters that are important to URI parsing
  // > that are also allowed in Windows file paths must be percent-encoded.
  // > This includes '#' and '%'. Characters that aren't allowed in URIs
  // > but are allowed in Windows file paths should also be percent-encoded...
  // (bla, bla)... also kann IE7 wohl keine Dateien, sondern nur noch URIs
  // oeffnen... nagut, dafuer gibt's ja UrlCreateFromPath(), leider nicht
  // in BCB4's "shlwapi.h", obwohl es UrlCreateFromPath() schon seit Win98 gibt.
  // Googling for "shlwapi.h", the author found a large number of warnings
  // about that "shlwapi.h" monster (and its dependences), so he decided
  // to roll a simple function of his own, as replacement for UrlCreateFromPath
  // (which turns a fully-fledged file path + file name into a "file URI").
  // But stop, will this really work with the damned IE7 ?
  // Is it worth the effort, just to find out it still doesn't work ?
  // Tried this (in the task bar, "Ausfueren" alias "Execute"):
  //  "c:\Programme\Internet Explorer\iexplore.exe" "file:///C:/cbproj/SpecLab/html/index.htm#shortdescr"
  // (this didn't work. It opened the html document, but stripped the anchor.
  //  Holy shit. Then, copied the following MANUALLY into the damned browser's
  //  address field, and .. it worked (but not through the command line):
  //    file:///C:/cbproj/SpecLab/html/index.htm#shortdescr
  // Ok, let's leave the double quotes away (in the commandline) :
  // "c:\Programme\Internet Explorer\iexplore.exe" file:///C:/cbproj/SpecLab/html/index.htm#shortdescr
  // Nope, this doesn't work, too. Grrrrrr. What else ? Try this:
  //  iexplore file:///C:/cbproj/SpecLab/html/index.htm#shortdescr
  // You guessed it: It still doesn't work.  Finally, tried that :
  //  firefox file:///C:/cbproj/SpecLab/html/index.htm#shortdescr
  // ..which, unlike iexplore, DID WORK !

  // Arrived here:  All of the above failed.  Very last attempt:
  // Try to execute a program which can display  HTML-files...
  //   See Win32 Programmer's Reference  on "ShellExecute" !
  if(YHF_hwndHelpParentWindow != NULL)
   {
     strncpy(YHF_HELP_sz1023LastBrowserCommandLine, sz1kCmdLine, 1023);
     retcode = (DWORD)ShellExecute(  // See Win32 Programmer's Reference
        YHF_hwndHelpParentWindow ,    // HWND hwnd = handle to parent window
        "open",      // LPCTSTR lpOperation = pointer to string that specifies operation to perform
        sz1kFileURI, // LPCTSTR lpFile = pointer to filename or folder name string
        NULL,        // LPCTSTR lpParameters = pointer to string that specifies executable-file parameters
        NULL,        // LPCTSTR lpDirectory = pointer to string that specifies default directory
       SW_SHOWNORMAL); // .. whether file is shown when opened
    }

  if( retcode > 32)
      return TRUE;  // ShellExecute successful
  YHF_HELP_ExecErrorCodeToString(retcode);
  return FALSE;
} // end HELP_ShowHtml()


/****************************************************************************/
bool YHF_HELP_ShowHelpContext(int iHelpContext)
  // A replacement for HelpContext, using HTML files and an index file
  // which "translates" the help context numbers into the HTML file name
  // and the Anchor name (like "index.htm#overview" for example).
  // Usually called from a redirected TApplication::OnHelp method ("AppHelp").
  //
  // Parameters: iHelpContext = help context number, usually from HelpMap.h,
  //                            also used in a lot of C++Builder forms !!!
  // return: TRUE=ok,  FALSE=error
{
 int i;
 T_YHF_HelpMapEntry *pHelpMap;

  if(YHF_pHelpMapTable == NULL)
     return FALSE;

  // Tabelle mit allen "Hilfe-Contexten" durchsuchen.
  pHelpMap = YHF_pHelpMapTable;
  for(i=0; pHelpMap[i].iHelpContext > 0; ++i)
   {
     if( pHelpMap[i].iHelpContext == iHelpContext)
      {
       return YHF_HELP_ShowHtml( pHelpMap[i].html_file_name,
                                 pHelpMap[i].html_anchor_name );
      }
   }
  return FALSE;  // help topic id not found
} // end HELP_ShowHelpContext()


/****************************************************************************/
bool YHF_HELP_ShowHelpKey(char *pszHelpKey)
  // A replacement for Application->HelpCommand(HELP_KEY, (int)pszHelpKey) .
  // Uses HTML files and an index table which "translates" the help keyword
  // into the HTML file name (like "index.htm#info" for example).
  // Note that the help keywords must be anchor names in the HTML files
  //  **AND** listed in the help keyword table !
  // The keyword search is not case-sensitive.
  //
  // return: TRUE=ok,  FALSE=error
{
 int i;
 T_YHF_HelpMapEntry *pHelpMap;

  if(YHF_pHelpMapTable == NULL)
     return FALSE;

  // Tabelle mit allen "Hilfe-Contexten" durchsuchen.
  pHelpMap = YHF_pHelpMapTable;
  for(i=0; pHelpMap[i].iHelpContext > 0; ++i)
   {
     if( stricmp( pszHelpKey, pHelpMap[i].html_anchor_name) == 0  )
      {
       return YHF_HELP_ShowHtml( pHelpMap[i].html_file_name,
                                 pHelpMap[i].html_anchor_name );
      }
   }
  return FALSE;  // help keyword not found
} // end HELP_ShowHelpKey()

