/****************************************************************************/
/* YHF_Dialogs.h:  File helper routines    by  Wolfgang Buescher (DL4YHF) . */
/*               NO APPLICATION-SPECIFIC STUFF IN HERE !                    */
/*               This unit is used in a number of projects (see history).   */
/*                                                                          */
/* Author and Copyright by:                                                 */
/*   Wolfgang Buescher (DL4YHF)                                             */
/*                                                                          */
/* Revision History:                                                        */
/*  V1.0, 2004-07-13:  Created for DL4YHF's "Spectrum Lab".                 */
/*                     Also used -the same day- for DL4YHF's "WinPic".      */
/*  V1.1, 2005-10-24:  Added "YHF_BrowseForFolder" (for WinPic) .           */
/*                                                                          */
/****************************************************************************/

#ifndef _YHF_DIALOGS_H_
#define _YHF_DIALOGS_H_


//---------------- Constants ------------------------------------------------
#define YHF_DLG_BTN_NONE   0
#define YHF_DLG_BTN_OK     1
#define YHF_DLG_BTN_CANCEL 2
#define YHF_DLG_BTN_HELP   3
#define YHF_DLG_BTN_USER1  11
#define YHF_DLG_BTN_USER2  12


//---------------- Variables ------------------------------------------------



//---------------- Prototypes -----------------------------------------------

//--------------------------------------------------------------------------
BOOL YHF_ChooseColor( HWND hwndOwner, char *pszCaption, DWORD *pdwRGBColor );
  // Color Selection Dialog.
  // Works a bit like Borland's TColorDialog but allows defining the CAPTION.

//--------------------------------------------------------------------------
BOOL YHF_BrowseFolder(HWND hwndOwner, char *pszCaption, char *pszFolder, int iMaxLen );
  // Folder Selection Dialog.
  //  The current folder (pszFolder) will be selected in the dialog,
  //  so it must be VALID (or contain an empty string) before the call .



#endif // _YHF_DIALOGS_H_

// EOF < YHF_Dialogs.h >
