/****************************************************************************/
/* YHF_Dialogs.cpp: Wrapper for some "common dialogs" in the Windows API .  */
/*               by  Wolfgang Buescher (DL4YHF) .                           */
/*               NO APPLICATION-SPECIFIC STUFF IN HERE !                    */
/*               This unit is used in a number of projects (see history).   */
/*                                                                          */
/* Author and Copyright by:                                                 */
/*   Wolfgang Buescher (DL4YHF)                                             */
/*                                                                          */
/* Revision History:                                                        */
/*  V1.0, 2004-07-13:  Created for DL4YHF's "Spectrum Lab".                 */
/*                     Also used -the same day- for DL4YHF's "WinPic".      */
/*  V1.1, 2005-10-24: Added "YHF_BrowseForFolder", since the originally used*/
/*                     WinAPI stuff "SHBrowseForFolder" requires a CALLBACK */
/*               to be able to set the DEFAULT SELECTION .. read more below */
/*                                                                          */
/****************************************************************************/

#include <windows.h>
#include <shlobj.h>


#pragma hdrstop   // Borland Stuff. No precompiled headers after this.

#include "YHF_Dialogs.h"   // header file for this module

char YHFdlg_sz255ColorDlgCaption[256];
UINT APIENTRY YHFdlg_ColorDialogHook(
    HWND hdlg,         // handle to the dialog box window
    UINT uiMsg,        // message identifier
    WPARAM wParam,     // message parameter
    LPARAM lParam )    // message parameter
{
 // See Win32 Programmer's Reference on ChooseColor(),  CCHookProc  .
 // Return Values
 // If the hook procedure returns zero, the default dialog box procedure processes the message.
 // If the hook procedure returns a nonzero value, the default dialog box procedure ignores the message.

 switch( uiMsg )
  {
   case WM_INITDIALOG:
        SendMessage( hdlg, WM_SETTEXT, 0, (LPARAM) YHFdlg_sz255ColorDlgCaption);
        // 2004-05-05 : Bingo, this works. Now the window has a much more "informal" title.
        return 1;
   default:
        break;
  }

 return 0;  // all other messages shall be handled by the default dialog box procedure !

} // end YHFdlg_ColorDialogHook()



//--------------------------------------------------------------------------
BOOL YHF_ChooseColor( HWND hwndOwner, char *pszCaption, DWORD *pdwRGBColor )
  // Color Selection Dialog.
  // Works a bit like Borland's TColorDialog
  //  but (and this is only one BIG PRO) allows to define the
  //  title ("caption") of the colour selection window .
  // Furthermore, it does not depend on Borland's bulky VCL .
{
  // > The ChooseColor function creates a Color common dialog box
  // > that enables the user to select a color.
  // Doesn't sound too complicated, huh ? Let's try:
  // First fill a CHOOSECOLOR structure and then see what happens !
 CHOOSECOLOR ColorDlgInfo;
 static COLORREF MyColours[16];
  memset(&ColorDlgInfo, 0, sizeof(ColorDlgInfo) );
  memset(&MyColours,    0, sizeof(MyColours) );
  ColorDlgInfo.lStructSize = sizeof(CHOOSECOLOR);
  ColorDlgInfo.hwndOwner = hwndOwner; // a WINDOW handle
  ColorDlgInfo.hInstance = NULL;      // ummm... do I need this ?
  ColorDlgInfo.rgbResult = (COLORREF)*pdwRGBColor; // a COLORREF = 32-bit value used to specify an RGB color
  ColorDlgInfo.lpCustColors = MyColours;  // a COLORREF pointer to a user-defined palette
  ColorDlgInfo.Flags     = CC_RGBINIT | CC_ENABLEHOOK;
  ColorDlgInfo.lCustData = (long)YHFdlg_sz255ColorDlgCaption;
  ColorDlgInfo.lpfnHook  = YHFdlg_ColorDialogHook;
  strcpy(YHFdlg_sz255ColorDlgCaption, pszCaption );
  if( ChooseColor( &ColorDlgInfo ) )
   {  // user clicked "Ok" in the colour selection dialog, result in ColorDlgInfo :
     *pdwRGBColor = (DWORD)ColorDlgInfo.rgbResult;
     return TRUE;
   }
  return FALSE;
} // end YHF_ChooseColor()


//--------------------------------------------------------------------------
int CALLBACK YHF_BFFCallback(HWND hwnd,UINT uMsg,LPARAM lp, LPARAM pData)
{
  char szPath[MAX_PATH];

  switch(uMsg)
   {
     case BFFM_INITIALIZED:
        SendMessage(hwnd, BFFM_SETSELECTION, TRUE, pData);
        break;

     case BFFM_SELCHANGED:
        if (SHGetPathFromIDList((LPITEMIDLIST) lp ,szPath))
         {
           SendMessage(hwnd, BFFM_SETSTATUSTEXT,0,(LPARAM)szPath);
         }
        break;
   }
  return 0;
} // end YHF_BFFCallback ( Browse-For-Folder-callback )

//--------------------------------------------------------------------------
BOOL YHF_BrowseFolder(HWND hwndOwner, char *pszCaption,
                      char *pszFolder, int iMaxLen )
  // Folder Selection Dialog.
  //  The current folder (pszFolder) will be selected in the dialog,
  //  so it must be VALID (or contain an empty string) before the call .
{
  // Inspired by www.nirsoft.net/vc/brfolder.html .
  // (would take DAYS to write this, if you only have the M$-documentation ;)
  BROWSEINFO bi;
  char szPath[MAX_PATH + 1];
  LPITEMIDLIST pidl;
  BOOL bResult = FALSE;
  LPMALLOC pMalloc;

  if( SHGetMalloc(&pMalloc) == NOERROR ) 
   {
     bi.hwndOwner = hwndOwner;
     bi.pidlRoot = NULL;
     bi.pszDisplayName = NULL;
     bi.lpszTitle = pszCaption;
     bi.ulFlags = BIF_STATUSTEXT; //BIF_EDITBOX
     bi.lpfn   = YHF_BFFCallback;
     bi.lParam = (LPARAM)pszFolder;

     pidl = SHBrowseForFolder(&bi);
     if (pidl)
      {
        if (SHGetPathFromIDList(pidl,szPath))
         {
           bResult = TRUE;
           strncpy(pszFolder, szPath, iMaxLen );
         }
        pMalloc->Free(pidl);
        pMalloc->Release();

      }
   }

  return bResult;

} // end YHF_BrowseFolder()
