/****************************************************************************/
/* \cbproj\yhf_tools\QFile.c:  "Quick File" helper routines                 */
/*                                                                          */
/*               NO APPLICATION-SPECIFIC STUFF IN HERE !                    */
/*               This unit is used in a number of projects (see history).   */
/*                                                                          */
/* Author and Copyright by:                                                 */
/*   Wolfgang Buescher (DL4YHF)                                             */
/*                                                                          */
/* Revision History:                                                        */
/*    see   *.c                                                             */
/*        2006-03-23:  Added the "QFILE_SEEK_xxx"-macros in QFile.h .       */
/*        2007-04-25:  Modified QFile_ReadLine() to support DOS- and UNIX-  */
/*                     textfiles: DOS uses CR+LF, UNIX only LF as line end. */
/*        2007-07-08:  Fixed a bug in QFile_ReadLine(): CR-LF at buffer     */
/*                     boundaries caused reading an additional empty line.  */
/*                                                                          */
/****************************************************************************/

#ifndef _QFILE_H_
#define _QFILE_H_

#include <windows.h>
#include <io.h>         // some file DEFINITIONS

//---------- Constants ------------------------------------------------------

// Possible values for 'oflags' in QFile_Open .  Must be compatible with fcntl.h !
// Declared here so other modules don't need to include dozens of headers .
#define QFILE_O_RDONLY    0
#define QFILE_O_WRONLY    1
#define QFILE_O_RDWR      2

#define QFILE_SEEK_SET  0  /* Positionierung vom Dateianfang aus */
#define QFILE_SEEK_CUR  1  /* Positionierung von der aktuellen Position aus */
#define QFILE_SEEK_END  2  /* Positionierung vom Dateiende aus */


//ex: #define QFILE_BUFFER_SIZE 2048  // must be a power of two !
#define QFILE_BUFFER_SIZE 65536 // must be a power of two !
                 // 2008-03-17 : increased QFILE_BUFFER_SIZE from 2048 to 65536,
                 // to see if this would speed up the analysis of very large wave files
                 // in Spectrum Lab.  Result:  CRASHED !
                 // Rebuilt the entire project -> works (stupid MAKE ? ),
                 //  but not faster than the original code with 2048-byte-buffer.

//---------- Data types (no C++ classes!) -----------------------------------
typedef struct // T_QFile (for "Quick file access")
{
  int   iHandle;
  char  sz512PathAndName[514];
  BYTE  bBuffer[QFILE_BUFFER_SIZE];
  BYTE  bPrevCharFromReadLine; // added 2007-07-08 to detect end of text lines properly
  BOOL  fBufferModified;
  DWORD dwBufferStartPos,dwPrevBufferStartPos; // important for QFile_Seek()
  DWORD dwBufferIndex;   // buffer index for the next read/write access
  DWORD dwNumUsedBytesInBuffer;   // count of "used" bytes in the buffer
  DWORD dwLastError;     // if there was an error, the error code is here
  BOOL  fOpened;
} T_QFile;


//------------ Prototypes -------------------------------------------------

#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* nicht "cplusplus" */

/***************************************************************************/
CPROT void QFile_LastErrorCodeToString(DWORD dwError, char *dest_str, int maxlen);


/***************************************************************************/
CPROT BOOL QFile_Open( T_QFile *pqFile, const char *filename, int oflags);
  // Opens a file.  Parameters similar to _rtl_open :
  //   QFILE_O_RDONLY , QFILE_O_WRONLY ,  or   QFILE_O_RDWR  .

/***************************************************************************/
CPROT void QFile_Close( T_QFile *pqFile );
  // Closes a file.

/***************************************************************************/
CPROT long QFile_Seek( T_QFile *pqFile, long offset, int fromwhere);
  // Works like lseek on a 'buffered' file.
  // QFile_Seek(  pqFile, 0, SEEK_CUR )  returns the current file position .

/***************************************************************************/
CPROT int QFile_Read( T_QFile *pqFile, void *buf, DWORD len);
  // Reads a few bytes from the file, or -if possible- from a buffer

/***************************************************************************/
CPROT int  QFile_ReadLine( T_QFile *pqFile, char *pszDest, int iMaxLen );
  // Reads a single text line from a file,  up to the CR / NL terminator.
  // The [CR /] NL terminator will be skipped but not entered in pszDest .
  // Return value:  > 0 = Count of characters,
  //                  ZERO if an empty line has been read,
  //               or NEGATIVE if there was an access error or end of file.


/***************************************************************************/
CPROT BOOL QFile_Create( T_QFile *pqFile, const char *filename, int attrib);
  // Creates a new file (or truncates existing). Parameters similar to _rtl_creat:
  // attrib=0 is a "normal" file (neither hidden nor something else)

/***************************************************************************/
CPROT BOOL QFile_Write( T_QFile *pqFile, BYTE *pbSrc, long i32CountOfBytes );


/***************************************************************************/
CPROT BOOL QFile_WriteString( T_QFile *pqFile, char *pszSrc );
   // Writes a zero-terminated string.
   // Counts the characters, but DOES NOT APPEND CR/NL by itself .


//--------------------------------------------------------------------------
//  String handling routines .   Frequently used when reading TEXT FILES .
//--------------------------------------------------------------------------
CPROT BOOL QFile_SkipChar(char **ppcSource, char cCharToSkip );
CPROT BOOL QFile_SkipString(char **ppcSource, char *pszStringToSkip);
CPROT long QFile_ParseInteger(char **ppcSource, int ndigits, int radix, long deflt);



#endif // _QFILE_H_
