/*-------------------------------------------------------------------------*/
/* dsPIC_PRG.h                                                             */
/*                                                                         */
/*  Purpose: Serial PIC Programming algorithms for dsPIC30F .              */
/*  Author : Wolfgang Buescher (DL4YHF)                                    */
/*     Use of this sourcecode for commercial purposes strictly forbidden ! */
/*                                                                         */
/*  Date   : 2005-07-01  (ISO 8601 format, YYYY-MM-DD)                     */
/*                                                                         */
/*  Last changes :                                                         */
/*    2006-11-05:  Handed this file (dsPIC_PRG.cpp) over to Yves Rondeau   */
/*                 who plans to support of the dsPIC33 family in WinPic.   */
/*                 No changes by Wolfgang Buescher for a while .           */
/*                                                                         */
/*-------------------------------------------------------------------------*/

  // Revsion history : see  dsPIC_PRG.cpp !

//------------------------------------------------------------------------
// External references used by the dsPIC programming routines..
//------------------------------------------------------------------------
#ifdef COMPILING_WINPIC
 CPROT  void APPL_ShowProgress( int percent ); // the application's "progress indicator" routine
 extern int  APPL_iUserBreakFlag; // signal for any programming loop to "stop", set via ESCAPE
#endif // COMPILING_WINPIC



//------------------------------------------------------------------------
// Prototypes for "public" functions for dsPIC programming :
//------------------------------------------------------------------------
BOOL dsPIC_EnterSTDPMode( void );
void dsPIC_LeaveSTDPMode( void );
WORD dsPIC_STDP_Read16BitLocation( DWORD dwSourceAddress );
BOOL dsPIC_STDP_ReadCodeMemory(DWORD dwSourceAddress, DWORD *pdwDestBuffer, DWORD dwNrOfCodeWords);
BOOL dsPIC_STDP_WriteCodeMemory( DWORD dwDestAddress, DWORD *pdwSourceData, DWORD dwNrOfCodeWords);
BOOL dsPIC_STDP_WriteConfigRegs( DWORD *pdwSourceData, int iNrOfRegisters);

  // More general routines which may decide themselves which algorithm to use :
  //  If there is a programming executive, use it;  otherwise use the slower STDP method.
BOOL dsPIC_EraseAll(void);

  // Note: All "Read"- and "Write"- routines must have compatible prototypes,
  //  because they may be called via function pointer from the application
  //  (see type definition of T_PicPrgReadWriteFunc in PIC_PRG.H ) .
  // The DATA are always passed as array of DWORDs, one DWORD per "location".
  //  A "location" may be :
  //    - a 12, 14, 16, or 24- bit location in CODE MEMORY
  //    - an 8-bit location in DATA MEMORY (~EEPROM)
  //    - a 16-bit location in CONFIGURATION MEMORY
BOOL dsPIC_ReadCodeMemory(DWORD dwSourceAddress, DWORD *pdwDestBuffer, DWORD dwNrOfCodeWords );
BOOL dsPIC_WriteCodeMemory(DWORD dwDestAddress , DWORD *pdwSourceData, DWORD dwNrOfCodeWords );
BOOL dsPIC_ReadConfigRegs( DWORD dwSourceAddress,DWORD *pdwDestBuffer, DWORD dwNrOfRegisters );
BOOL dsPIC_WriteConfigRegs(DWORD dwDestAddress,  DWORD *pdwSourceData, DWORD dwNrOfRegisters );

  // Note on DATA MEMORY : Though the access may be WORD-wise internally,
  // treat the EEPROM like a BYTE-memory as in old 14-bit PICs !
BOOL dsPIC_ReadDataMemory( DWORD dwSourceAddress,DWORD *pdwDestBuffer, DWORD dwNrOfBytes );
BOOL dsPIC_WriteDataMemory(DWORD dwDestAddress,  DWORD *pdwSourceBuffer,DWORD dwNrOfBytes );

// EOF < dsPIC_PRG.H >