/*-------------------------------------------------------------------------*/
/* WinPicPr.h                                                              */
/*                                                                         */
/*   Header for the main form of the PIC programmer.                       */
/*                                                                         */
/*-------------------------------------------------------------------------*/


//---------------------------------------------------------------------------
#ifndef WinPicPrH
#define WinPicPrH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
#include <Buttons.hpp>
#include <Grids.hpp>
#include <CheckLst.hpp>

#include "Devices.h" // database with programmable (PIC-?) devices

//---------------------------------------------------------------------------
class TPicMain : public TForm
{
__published:	// IDE-managed Components
        TTimer *Timer1;
        TPageControl *PageControl1;
        TTabSheet *TS_Interface;
        TTabSheet *TS_ProgramMemory;
        TTabSheet *TS_EEPromMemory;
        TTabSheet *TS_DeviceConfig;
        TTabSheet *TS_Messages;
        TGroupBox *Grp_IntfTest;
        TCheckBox *Chk_TestVpp;
        TCheckBox *Chk_TestClock;
        TCheckBox *Chk_TestData;
        TLabel *Label1;
        TLabel *Lab_TestDataIn;
        TMainMenu *MainMenu1;
        TMenuItem *File1;
        TMenuItem *Load1;
        TMenuItem *N1;
        TMenuItem *Exit1;
        TMenuItem *Menu_Device;
        TMenuItem *Menu_ProgramDevice;
        TMenuItem *MI_ProgCfgWord;
        TMenuItem *Erase1;
        TMenuItem *Verify1;
        TMenuItem *BlankCheck1;
        TMenuItem *Read1;
        TMenuItem *ResetGo1;
        TMenuItem *Edit1;
        TMenuItem *Clearbuffer1;
        TMenuItem *Help1;
        TMenuItem *Index1;
        TMenuItem *N2;
        TMenuItem *About1;
        TRichEdit *REd_CodeMem;
        TLabel *Label2;
        TMemo *Mem_Messages;
        TMenuItem *Menu_LoadAndProgram;
        TOpenDialog *OpenDialog;
        TRichEdit *REd_DataMem;
        TButton *Btn_ClearMessages;
        TMenuItem *ClearFuses;
        TLabel *Label4;
        TComboBox *Combo_PartName;
        TGroupBox *Grp_InterfaceType;
        TComboBox *Combo_InterfaceType;
        TLabel *Label5;
        TComboBox *Combo_InterfacePort;
        TStaticText *Txt_InterfaceType;
        TButton *Btn_InitInterface;
        TEdit *Ed_ConfigWordHex;
        TLabel *Label7;
        TMenuItem *Menu_SelectDevice;
        TLabel *Lab_PortAddr;
        TCheckBox *Chk_TestVdd;
        TCheckBox *Chk_ClockEnable;
        TCheckBox *Chk_DataEnable;
        TBitBtn *Btn_HelpLptInterface;
        TBitBtn *BitBtn1;
        TPanel *Pnl_Message;
        TProgressBar *ProgressBar1;
        TTabSheet *TS_Options;
        TGroupBox *Grp_ProgOptions;
        TCheckBox *Chk_UseBulkErase;
        TMenuItem *N3;
        TMenuItem *Menu_EnableEdit;
        TMenuItem *Menu_ApplyHexEdits;
        TMenuItem *Menu_DiscardHexEdits;
        TCheckBox *Chk_ConnectICSPTarget;
        TCheckBox *Chk_DisconnectAfterProg;
        TLabel *Label9;
        TEdit *Ed_CustomInterfaceDefFile;
        TButton *Btn_SelectCustomInterface;
        TGroupBox *Grp_OtherOps;
        TGroupBox *Grp_DebugOptions;
        TCheckBox *Chk_SimulateOnly;
        TCheckBox *Chk_VerboseMsgs;
        TCheckBox *Chk_DontCareForOsccal;
        TMenuItem *Menu_Tools;
        TMenuItem *Menu_StartBatchProgramming;
        TShape *Shp_RedLED;
        TShape *Shp_GreenLED;
        TLabel *Lab_RedLED;
        TLabel *Lab_GreenLED;
        TLabel *Lab_OkButton;
        TMenuItem *N4;
        TMenuItem *Menu_SaveBuffers;
        TSaveDialog *SaveDialog;
        TCheckBox *Chk_DontCareForBGCalib;
        TCheckBox *Chk_PullMclrToGnd;
        TEdit *Ed_IoPortAddress;
        TGroupBox *Grp_SelVdd;
        TRadioButton *RB_VddLow;
        TRadioButton *RB_VddNorm;
        TRadioButton *RB_VddHigh;
        TCheckBox *Chk_VerifyDiffVdds;
        TMenuItem *Specials1;
        TMenuItem *M_DumpDevList;
        TTabSheet *TS_CfgMemTab;
        TStringGrid *SG_CfgMem;
        TMenuItem *MI_ProgIDlocs;
        TGroupBox *Grp_DevProps;
        TEdit *Ed_ProgramMemory;
        TLabel *Lab_ProgramMemory;
        TEdit *Ed_DataEepromMemory;
        TLabel *Lab_DataEepromMemory;
        TCheckBox *Chk_ClrBeforeLoad;
        TMenuItem *MI_MRFs;
        TMenuItem *MI_MRF1;
        TMenuItem *MI_MRF2;
        TMenuItem *MI_MRF3;
        TMenuItem *MI_MRF4;
        TMenuItem *MI_MRF5;
        TMenuItem *MI_MRF6;
        TMenuItem *MI_ClearMRFs;
        TCheckBox *Chk_VddBeforeMCLR;   // read a long story in PIC_HW_ProgMode() !
        TMenuItem *MI_ProgOps;
        TMenuItem *MI_FAQs;
        TLabel *Lab_SelLang;
        TComboBox *CB_Language;
        TMenuItem *MI_DumpTranslator;
        TMenuItem *N5;
        TMenuItem *MI_ShowToolWin;
        TMenuItem *MI_ReloadAndProg;
        TMenuItem *N6;
        TMenuItem *MI_SelLanguage;
        TButton *Btn_StartTest;
        TEdit *Ed_TestNr;
        TPanel *Pnl_CodeMemColors;
        TPanel *Pnl_DataMemColors;
        TPanel *Pnl_CfgMem;
        TRadioButton *RB_IdBin;
        TRadioButton *RB_IdHex;
        TLabel *Lab_DevId1;
        TLabel *Lab_DevId;
        TLabel *Lab_DevIdDecoded;
        TBitBtn *Btn_ApplyIdLocs;
        TBitBtn *Btn_HelpOnIdLocs;
        TLabel *Label8;
        TCheckBox *Chk_ShowAllCfgCells;
        TLabel *Label10;
        TMenuItem *MI_ExitDontSave;
        TMenuItem *N7;
        TMenuItem *MI_dsPIC_ReadExecutiveCodeMem;
        TMenuItem *MI_dsPIC_WriteExecutiveCodeMem;
        TCheckBox *Chk_ProgCodeMem;
        TCheckBox *Chk_ProgDataMem;
        TCheckBox *Chk_ProgConfigMem;
        TMenuItem *MI_DumpMemAsRTF;
        TStringGrid *SG_ConfigBits;
        TComboBox *CB_ConfigBits;
        TEdit *Ed_ConfigWord2;
        TLabel *Label6;
        TCheckBox *Chk_HasFlashMemory;
        TLabel *Lab_SavedBeforeErase;
        TLabel *Lab_SavedBeforeErase2;
        TLabel *Label11;
        TCheckBox *Chk_SlowInterface;
        TPanel *Pnl_Tools;
        TSpeedButton *Btn_FileOpen;
        TSpeedButton *Btn_Program;
        TSpeedButton *Btn_CloseToolbar;
        TMenuItem *MI_ShowToolbar;
        TBevel *Bevel1;
        TSpeedButton *Btn_Save;
        TBevel *Bevel2;
        TSpeedButton *Btn_Verify;
        TSpeedButton *Btn_ReadPIC;
        TBevel *Bevel3;
        TSpeedButton *Btn_HelpIndex;
        TLabel *Lab_DevFileDir;
        TEdit *Ed_MplabDevDir;
        TButton *Btn_MplabDevDir;
        TGroupBox *Grp_IOPortAccess;
        TRadioButton *Rb_UseSMPORT;
        TRadioButton *Rb_UsePortTalk;
        TRadioButton *Rb_PortAccessGranted;
        TLabel *Lab_ExtraRdDelay;
        TLabel *Lab_ExtraClkDelay;
        TEdit *Ed_ExtraRdDelay;
        TEdit *Ed_ExtraClkDelay;
        TRadioButton *Rb_UseWinAPIOnly;
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall Chk_TestXXXClick(TObject *Sender);
        void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
        void __fastcall Timer1Timer(TObject *Sender);
        void __fastcall Menu_LoadAndProgramClick(TObject *Sender);
        void __fastcall Exit1Click(TObject *Sender);
        void __fastcall Menu_ProgramDeviceClick(TObject *Sender);
        void __fastcall MI_ProgCfgWordClick(TObject *Sender);
        void __fastcall Erase1Click(TObject *Sender);
        void __fastcall Read1Click(TObject *Sender);
        void __fastcall BlankCheck1Click(TObject *Sender);
        void __fastcall Btn_ClearMessagesClick(TObject *Sender);
        void __fastcall Load1Click(TObject *Sender);
        void __fastcall Clearbuffer1Click(TObject *Sender);
        void __fastcall ClearFusesClick(TObject *Sender);
        void __fastcall Verify1Click(TObject *Sender);
        void __fastcall About1Click(TObject *Sender);
        void __fastcall Index1Click(TObject *Sender);
        void __fastcall Combo_PartNameChange(TObject *Sender);
        void __fastcall Btn_InitInterfaceClick(TObject *Sender);
        void __fastcall Combo_InterfaceTypeChange(TObject *Sender);
        void __fastcall Combo_InterfacePortChange(TObject *Sender);
        void __fastcall Ed_MessageClick(TObject *Sender);
        void __fastcall Ed_ConfigWordHexChange(TObject *Sender);
        void __fastcall Ed_ProgramMemoryChange(TObject *Sender);
        void __fastcall Ed_DataEepromMemoryChange(TObject *Sender);
        void __fastcall Chk_HasFlashMemoryClick(TObject *Sender);
        void __fastcall Menu_SelectDeviceClick(TObject *Sender);
        void __fastcall Chk_TestVddClick(TObject *Sender);
        void __fastcall Chk_ClockEnableClick(TObject *Sender);
        void __fastcall Chk_DataEnableClick(TObject *Sender);
        void __fastcall Btn_HelpLptInterfaceClick(TObject *Sender);
        void __fastcall BitBtn1Click(TObject *Sender);
        void __fastcall Pnl_MessageClick(TObject *Sender);
        void __fastcall FormCloseQuery(TObject *Sender, bool/*not BOOL*/ &CanClose);
        void __fastcall ProgOptionsChanged(TObject *Sender);
        void __fastcall File1Click(TObject *Sender);
        void __fastcall Menu_DeviceClick(TObject *Sender);
        void __fastcall Edit1Click(TObject *Sender);
        void __fastcall Menu_EnableEditClick(TObject *Sender);
        void __fastcall Menu_DiscardHexEditsClick(TObject *Sender);
        void __fastcall Menu_ApplyHexEditsClick(TObject *Sender);
        void __fastcall ResetGo1Click(TObject *Sender);
        void __fastcall Chk_ConnectICSPTargetClick(TObject *Sender);
        void __fastcall Btn_SelectCustomInterfaceClick(TObject *Sender);
        void __fastcall Menu_StartBatchProgrammingClick(TObject *Sender);
        void __fastcall FormKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall Shp_RedLEDMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall Shp_GreenLEDMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall Menu_ToolsClick(TObject *Sender);
        void __fastcall Menu_SaveBuffersClick(TObject *Sender);
        void __fastcall Chk_PullMclrToGndClick(TObject *Sender);
        void __fastcall Ed_IoPortAddressChange(TObject *Sender);
        void __fastcall HexEditKeyDown(TObject *Sender, WORD &Key,
            TShiftState Shift);
        void __fastcall RB_VddLowClick(TObject *Sender);
        void __fastcall RB_VddNormClick(TObject *Sender);
        void __fastcall RB_VddHighClick(TObject *Sender);
        void __fastcall M_DumpDevListClick(TObject *Sender);
        void __fastcall Btn_ApplyIdLocsClick(TObject *Sender);
        void __fastcall SG_CfgMemSetEditText(TObject *Sender, int ACol,
          int ARow, const AnsiString Value);
        void __fastcall Btn_HelpOnIdLocsClick(TObject *Sender);
        void __fastcall MI_ProgIDlocsClick(TObject *Sender);
        void __fastcall RB_IdBinClick(TObject *Sender);
        void __fastcall Ed_ConfigWord2Change(TObject *Sender);
        void __fastcall MI_MRF1Click(TObject *Sender);
        void __fastcall MI_ClearMRFsClick(TObject *Sender);
        void __fastcall MI_MRF2Click(TObject *Sender);
        void __fastcall MI_MRF3Click(TObject *Sender);
        void __fastcall MI_MRF4Click(TObject *Sender);
        void __fastcall MI_MRF5Click(TObject *Sender);
        void __fastcall MI_MRF6Click(TObject *Sender);
        void __fastcall MI_ProgOpsClick(TObject *Sender);
        void __fastcall MI_FAQsClick(TObject *Sender);
        void __fastcall CB_LanguageChange(TObject *Sender);
        void __fastcall MI_DumpTranslatorClick(TObject *Sender);
        void __fastcall MI_ShowToolWinClick(TObject *Sender);
        void __fastcall MI_ReloadAndProgClick(TObject *Sender);
        void __fastcall MI_SelLanguageClick(TObject *Sender);
        void __fastcall Btn_StartTestClick(TObject *Sender);
        void __fastcall Pnl_CodeMemColorsClick(TObject *Sender);
        void __fastcall Pnl_DataMemColorsClick(TObject *Sender);
        void __fastcall Chk_ShowAllCfgCellsClick(TObject *Sender);
        void __fastcall MI_ExitDontSaveClick(TObject *Sender);
        void __fastcall MI_dsPIC_ReadExecutiveCodeMemClick(
          TObject *Sender);
        void __fastcall MI_dsPIC_WriteExecutiveCodeMemClick(
          TObject *Sender);
        void __fastcall MI_DumpMemAsRTFClick(TObject *Sender);
        void __fastcall SG_ConfigBitsClick(TObject *Sender);
        void __fastcall CB_ConfigBitsChange(TObject *Sender);
        void __fastcall SG_ConfigBitsTopLeftChanged(TObject *Sender);
        void __fastcall TS_DeviceConfigResize(TObject *Sender);
        void __fastcall InterfaceTimingChanged(TObject *Sender);
        void __fastcall Btn_CloseToolbarClick(TObject *Sender);
        void __fastcall MI_ShowToolbarClick(TObject *Sender);
        void __fastcall Btn_FileOpenClick(TObject *Sender);
        void __fastcall Btn_ProgramClick(TObject *Sender);
        void __fastcall Btn_SaveClick(TObject *Sender);
        void __fastcall Btn_VerifyClick(TObject *Sender);
        void __fastcall Btn_ReadPICClick(TObject *Sender);
        void __fastcall Btn_HelpIndexClick(TObject *Sender);
        void __fastcall Btn_MplabDevDirClick(TObject *Sender);
        void __fastcall PortAccessDriverChanged(TObject *Sender);
        void __fastcall Ed_IoPortAddressClick(TObject *Sender);
private:	// User declarations
        BOOL m_update_code_mem_display;
        BOOL m_update_data_mem_display;
        BOOL m_update_id_and_config_display;
        int  m_displayed_interface_type;
        WORD m_displayed_config_word[2];  // TWO cfg words since 2003-12 !!
        char m_sz40DisplayedDeviceName[44];
        T_PicConfigBitInfo * m_pConfigBitGridRowNumber_to_ConfigBitInfoPtr[PICDEV_MAX_CONFIG_BIT_INFOS];

        BOOL m_fUseSerialPort;
        int  m_Updating;

        // Use this temporary "memory stream" to build the coloured,
        // RichText-formatted, lines of the code memory window :
        TMemoryStream* pRtfMemStream;  // only exists during update, otherwise NULL !

        AnsiString m_original_title;

        AnsiString __fastcall ProgramWhatInfoString(void);
        void __fastcall StopParsingCmdLine_Internal(void);
        void __fastcall DisconnectTarget(void);
        void __fastcall LoadSmallPort(void);        
        void __fastcall SetInterfaceInternal(int iInterfaceType);
        BOOL __fastcall UnlockEditFieldForIOPortAddress(void);        
        BOOL __fastcall TestTheInterface(void);
        BOOL __fastcall TestDelayRoutine(void);
        BOOL __fastcall InterfaceSpeedTest(void);        
        BOOL __fastcall ProgramPic(void);
        BOOL __fastcall VerifyPic(void);
        BOOL __fastcall DumpEverythingToHexFile(char *fn);
        BOOL __fastcall ReadPicAndDumpToFile(char *fn);
        BOOL __fastcall LoadFileAndProgramPic(char *fn, BOOL program_too);
        AnsiString __fastcall GetMRFname(int iMRFindex);
        void __fastcall SetMRFname(int iMRFindex, AnsiString s);
        void __fastcall AddMRFname(AnsiString s);
        void __fastcall LoadMRF(int iMRFindex);

        BOOL __fastcall RunHexOpenDialog(void);

        void __fastcall UpdateCodeMemRange( int iWhichMemory, long i32NLocations, int iUCMoptions );
              #define UCM_SHOW_USED_LOCATIONS_ONLY 0x0000
              #define UCM_SHOW_ALL_LOCATIONS       0x0001
        void __fastcall UpdateCodeMemDisplay(void);
        void __fastcall UpdateDataMemDisplay(void);
        void __fastcall UpdateIdAndConfMemDisplay(void);
        void __fastcall UpdateConfigBitCombo(void);
        void __fastcall UpdateConfigBitGrid(void);        
        void __fastcall ApplyConfigBitGrid(void);
        void __fastcall ApplyIdLocationDisplay(void);
        BOOL __fastcall EnableHexEditors(void);
        BOOL __fastcall ApplyCodeMemoryEdits(void);
        BOOL __fastcall ApplyDataMemoryEdits(void);
        BOOL __fastcall QueryAndApplyHexEditIfRequired(void);

        void __fastcall UpdateInterfaceType(int interface_type);
        void __fastcall UpdateInterfaceTestDisplay(void);
        void __fastcall UpdateInterfaceInputSignalDisplay(void);
        void __fastcall UpdateDeviceConfigTab(BOOL fUpdateHexWord);
        void __fastcall UpdateOptionsDisplay(void);
        void __fastcall UpdateToolWindow(void);
        void __fastcall UpdateAllSheets(void);

        bool __fastcall AppHelp(Word Command, int Data, bool/*not BOOL!*/ &CallHelp);

public:		// User declarations
        BOOL m_progress_visible;
        int  m_progress_activity_timer;
        int  m_iMessagePanelUsage;
        BOOL m_fPicDeviceConflict;
        char m_sz80DetectedPicDevName[82];
        BOOL m_fMaySaveSettings;

        __fastcall TPicMain(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TPicMain *PicMain;
//---------------------------------------------------------------------------
#endif
