/*-------------------------------------------------------------------------*/
/* WinPicPr.cpp                                                            */
/*   Code for the main form of DL4YHF's PIC programmer.                    */                                
/*   To be compiled with Borland C++ Builder V4  (or later ? ) .           */
/*                                                                         */
/*  Author:   Wolfgang Buescher (DL4YHF)                                   */
/*     Use of this sourcecode for commercial purposes strictly forbidden ! */
/*                                                                         */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* Very Incomplete Revision History ... (date format: YYYY-MM-DD)          */
/*                                                                         */
/* V2.0, 2007-06-03:  A.Kibler added support for PIC12F609/615,16F610/616, */
/*                    which require "End Programming", see PIC_PRG.cpp .   */
/* V1.9, 2005-05-01:  Added support for PIC10F20x ... totally different..  */
/* V1.8, 2005-04-XX:  Support for PIC18Fxxxx added by Martin van de Werff, */
/*                    located in a separate module.                        */
/* V1.7, 2005-02-19:  Added support for the dsPIC30F family, which is      */
/*                    COMPLETELY DIFFERENT compared with other chips .     */
/* V1.6, 2004-08-23:  Lots of new devices, new algorithms to support them. */
/*                  + New look of the 'Config Memory' tab (more locations) */
/*                  + Support for other languages using YHF_MultiLang.cpp  */
/* V1.5, 2003-09-19:  PIC16F818 now supported, tnx SM6LKM for the sample ! */
/*                    New command line options: /device=X /config_word=X   */
/* V1.4, 2002-11-xx: PIC12F675 and others supported, command-line-driven   */
/*                    operation, batch-mode, problems with lost config ?!  */
/*                    Use this command line for testing (copy & paste):    */
/*                          c:\\pic\my_src\keyer1.hex /p /q                */
/* V1.3, 2002-02-xx:  PIC16F87x supported, programmers on LPT supported.   */
/*                    (only SM6LKM's PIP84 tested,                         */
/*                     TAIT nor "AN589" supported but not tested ).        */
/* V1.2, 2001-12-04:  PIC16F628 and PIC16C711 now supported.               */
/*                                                                         */
/* V1.1, 2000-12-12:  First released source code.                          */
/*                                                                         */
/* V1.0, 2000-09-16:  Converted from Pp.c to PIC_PRG.cpp                   */
/*                    for beta-release of DL4YHF's Windows-PIC-Programmer. */
/*                    First ugly version of user interface, using BCB V4 . */
/*                                                                         */
/*-------------------------------------------------------------------------*/


//---------------------------------------------------------------------------
#include <vcl.h>
#include <IniFiles.hpp>  // to load and save position & size of this form
//#include <shlobj.h>   //must be commented in builder 5.5 or face error
#include <stdio.h>       // standard file I/O routines
#include <dos.h>         // uses "gettime" to check the delay routines
#pragma hdrstop

#include "YHF_Help.h"       // a nice HTML replacement for the lousy "*HLP" system
#include "YHF_MultiLang.h"  // non-project-specific header for multi-language support
#include "YHF_Dialogs.h"    // some "common dialogs" from the Windows API

#include "translation.h"    // project specific: how many languages, etc ?


#include "Config.h"

#include "WinPicPr.h"
#include "HelpIDs.h"

#define _I_AM_APPL_MAIN_ 1
#include "APPL.h"    // a few exported prototypes

#include "AboutU.h"  // The inevitable "About"-Box
#include "ToolWin1.h" // Extra window with the "Reload & Program" button
// already included in header: #include "Devices.h" // database with programmable (PIC-?) devices
#define BUILDING_DLL 0 // we are not BUILDING a DLL now (only USING them)
#include "interface_dlls\\PHW_intf_dll.h" // header for all "hardware-interface-plugins"
#include "PIC_HW.h"    // Routines to drive the programmer hardware interface
#include "PIC_PRG.h"   // PIC programming routines
#include "dsPIC_PRG.h" // special dsPIC programming algorithms
#ifdef SUPPORT_PIC18F   // defined under compiler options..conditional defines
  #include "PIC18F_PRG.h" // support for PIC18F devices by Martin van der Werff
#endif
#include "PIC10F_PRG.h"    // special PIC10F20x programming algorithms
#include "PIC16F7x_PRG.h"  // special PIC16F7x programming algorithms (PIC16F73/74/76/77 but not 72)
#include "PIC16F716_PRG.h" // special PIC16F716 programming algorithms (PIC16F716 and nothing else)


#include "PIC_HEX.h" // HEX-File import,export  +  buffers

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TPicMain *PicMain;

/*--------------- outside all classes -------------------------------------*/



//---- variables ------------------------------------------------------------
int  APPL_iUserBreakFlag = 0;  // signal for any programming loop to "stop" ,
                               // set by pressing ESCAPE .


  // Options and parameters from the command line .
  //  Initialized with their "default values" (if not specified)
long APPL_i32CustomizeOptions = 0;
BOOL WinPic_fCommandLineMode           = FALSE;
BOOL WinPic_fCommandLineOption_Erase   = FALSE;
BOOL WinPic_fCommandLineOption_Load    = FALSE;  // load from file w/o program
BOOL WinPic_fCommandLineOption_Program = FALSE;
BOOL WinPic_fCommandLineOption_Read    = FALSE;
BOOL WinPic_fCommandLineOption_Verify  = FALSE;
BOOL WinPic_fCommandLineOption_Quit    = FALSE;
BOOL WinPic_fCommandLineOption_NoDelay = FALSE;
BOOL WinPic_fCommandLineOption_QueryBeforeOverwritingFiles = TRUE;
long WinPic_i32CmdLineOption_OverrideConfigWord  = -1;
int  WinPic_i200msToQuit = 0;

BOOL WinPic_fCloseImmediately = FALSE;


int  WinPic_iTestMode = 0;
  // bitmasks for WinPic_iTestMode :
  #define WP_TEST_MODE_GUI_SPEED 2

BOOL WinPic_fAcceptAllIoAddresses = FALSE;

//---- helper routines ------------------------------------------------------

/***************************************************************************/
void APPL_ShowMsg( int caller, int error_level, char *pszFormat, ... )
  /* The application's "error-display" routine.
   * Also called from the PIC - routines (and other, possibly "C"-modules),
   *      therefore **NOT** a method of any CLASS.
   */
{
 va_list parameter;              /* Parameter-Liste fr VA_... Macros */
 char szText[512];                  /* Puffer fr formatierten String */

  va_start( parameter, pszFormat );             /* Parameter umwandeln */
  wvsprintf( szText, pszFormat, parameter );            /* formatieren */
  va_end(parameter);                            /* Parameter-Ende      */

  (void)caller;
  PicMain->Pnl_Message->Caption = szText;
  PicMain->Mem_Messages->Lines->Add(szText);
  PicMain->Update();
  if(  (error_level>=127/*important*/)  &&  (ToolForm!=NULL)  )
   { ToolForm->ShowMsg(szText, TWMSG_ERROR );
   }

} // end APPL_ShowMsg()


//---------------------------------------------------------------------------
void APPL_LogEvent( char * pszFormat, ... )  // logs an "event" with current timestamp
{
  va_list arglist;
  char sz500[512]; char *cp;
  SYSTEMTIME st;

  // Show the TIME of this event :
  GetLocalTime(&st);
  sprintf(sz500,"%02d:%02d:%02d.%02d ",
                 (int)st.wHour,   (int)st.wMinute,
                 (int)st.wSecond, (int)st.wMilliseconds/10 );
  cp = sz500+strlen(sz500);

  // Print to string and append to edit control
  va_start(arglist, pszFormat);
  vsprintf(cp, pszFormat, arglist);
  va_end(arglist);
  if( PicMain->Mem_Messages->Lines->Count >= 400 )
   { if( PicMain->Mem_Messages->Lines->Count == 400 )
      {
        PicMain->Mem_Messages->Lines->Add( "< Too many messages in list, click \"CLEAR\" >" );
      }
   }
  else
   { PicMain->Mem_Messages->Lines->Add( sz500 );
   }
}


/***************************************************************************/
int APPL_iPreviousProgressPercentage = 0;
void APPL_ShowProgress( int percent )
  /* The application's "progress indicator" routine.
   * Also called from the PIC - routines (and others),
   *      therefore **NOT** a method of any CLASS.
   */
{
  // Avoid unnecessary updates because
  //  we are calling "unknown", possibly slow, Win API routine here .
  if( APPL_iPreviousProgressPercentage != percent )
   {  APPL_iPreviousProgressPercentage = percent;
     if (!PicMain->m_progress_visible)
      {
        PicMain->m_progress_visible    = true;
        PicMain->ProgressBar1->Visible = true;
        if(ToolForm)
           ToolForm->ProgressBar1->Visible = true;
      }
     PicMain->m_progress_activity_timer = 2;
     Appl_CheckUserBreak(); // -> APPL_iUserBreakFlag , here updated in APPL_ShowProgress()
     PicMain->ProgressBar1->Position = percent;
     if(ToolForm)
        ToolForm->ProgressBar1->Position = percent;
     PicHw_LetInterfaceDLLDoGraphicStuff();  // keep the plugin's GUI alive        
     PicMain->Update();
   }
} // end APPL_ShowProgress()


/***************************************************************************/
int Appl_CheckUserBreak(void)
  // returns TRUE if user break detected (here: ESCAPE key pressed),
  //         FALSE otherwise.
{
  if ( GetAsyncKeyState( VK_ESCAPE) )
      APPL_iUserBreakFlag = 1;  // signal for the programming routines to leave all loops
  //  Return Values of GetAsyncKeyState() :
  //     If the function succeeds, the return value specifies whether the
  //     key was pressed since the last call to GetAsyncKeyState,
  //     and whether the key is currently up or down.
  //  If the most significant bit is set, the key is down,
  //  and if the least significant bit is set, the key was pressed
  //  after the previous call to GetAsyncKeyState.
  //  The return value is zero if a window in another thread or process
  //  currently has the keyboard focus.


  return APPL_iUserBreakFlag;
} // end Appl_CheckUserBreak()


long HexStringToLongint(int nMaxDigits, char *pszSource)
{
 long lResult = 0;
 char c;
 int i;
  if(pszSource[0]=='0' && pszSource[1]=='x')
     pszSource += 2;
  else if(pszSource[0]=='$')
     pszSource += 1;

  for(i=0; i<nMaxDigits; ++i)
   {
     c=pszSource[i];
     if(c=='\0' || c==' ' || c==',' )  // "early" end of the HEX string
        return lResult;

     lResult <<= 4;  // shift "older, upper digits" 4 bits left
     if(c>='0' && c<='9')
        lResult += (WORD)(c-'0');
     else
     if(c>='a' && c<='f')
        lResult += (WORD)(c-'a'+10);
     else
     if(c>='A' && c<='F')
        lResult += (WORD)(c-'A'+10);
     else
        return -1;  // not a valid HEX digit
   }
  return lResult;
} // end HexStringToLongint()


//---------------------------------------------------------------------------
static char *WordToSeparatedBinary(WORD w, int iNrBits)
{
  int j,k;
  static char sz80Result[82];

    for(j=k=0;j<iNrBits;++j)
     { sz80Result[k++] = '0' +  ( (w & (1<<(iNrBits-1-j)))!=0);
       if( ((iNrBits-1-j)&3) == 0)
         sz80Result[k++] = ' ';
     }
    sz80Result[k] = '\0';
    return sz80Result;
}

//---------------------------------------------------------------------------
BOOL WinPic_ApplyHexDumpLine( char *pszSource )
{
  DWORD dwAddr, dwData, dwOldData;
  int  i, nBytesPerLine;

  if(! PicHex_GetHexValueFromSource( &pszSource, &dwAddr ) )  // parse the address
       return FALSE;

  if(*pszSource==':')
    ++pszSource;
  else return FALSE;


  // There is a trick to enter data as ASCII characters:
  //    Erase all the hex DATA fields, modify the ASCII chars.
  //    If there are no HEX values, parse the ASCII data later.
  nBytesPerLine = 0;
  while(  (nBytesPerLine<8) &&   // FIRST get the hex values
       PicHex_GetHexValueFromSource( &pszSource, &dwData ) )
   {
     if( PicBuf_GetBufferWord( dwAddr, &dwOldData) > 0 )
      {
       if(dwData != dwOldData)
        { PicBuf_SetMemoryFlags(dwAddr, PicBuf_GetMemoryFlags(dwAddr) | PIC_BUFFER_FLAG_USED);
        }
       PicBuf_SetBufferWord(dwAddr,  (WORD)dwData);
      }
     ++dwAddr;
     ++nBytesPerLine;
   }



  while( (nBytesPerLine<8) &&    // .. parse any remaining chars in ASCII
     *pszSource>=32 )
   { dwData    = (int)(*pszSource++);
     if( PicBuf_GetBufferWord(dwAddr, &dwOldData) > 0 )
      {
       if(dwData != dwOldData)
        { PicBuf_SetMemoryFlags(dwAddr, PicBuf_GetMemoryFlags(dwAddr) | PIC_BUFFER_FLAG_USED);
        }
       PicBuf_SetBufferWord(dwAddr, (WORD)dwData);
      }
     ++dwAddr;
     ++nBytesPerLine;
   }

  return TRUE;

} // end ApplyHexDumpLine( )


//---------------------------------------------------------------------------
void WinPic_RedAndGreenLedOff(void)
{
  PIC_HW_SetRedLed( 0 );
  PIC_HW_SetGreenLed( 0 );
}


//---------------------------------------------------------------------------
void WinPic_UpdateLedsForResult(BOOL fOk)
{
  PIC_HW_SetRedLed( !fOk );
  PIC_HW_SetGreenLed( fOk );
}


//---------------------------------------------------------------------------
BOOL WinPic_OkToCloseDueToErasedCalibration(void)
{
 BOOL fOkToClose = TRUE;

 if(    (PIC_iHaveErasedCalibration)
    && ((PIC_lBandgapCalibrationBits >= 0) || (PIC_lOscillatorCalibrationWord >=0) )
    && ((PIC_DeviceInfo.wCfgmask_bandgap!=0) || (PIC_DeviceInfo.lAddressOscCal >= 0) )
   )
  {
    for(int i=0;i<10;++i)
        MessageBeep(0xFFFFFFFF);
    fOkToClose = (MessageBox( NULL,   // handle of owner window
      TE("Some CALIBRATION BITS have been erased\n but not written back to the PIC yet.\nTerminate anyway and lose these bits forever ?"),
      TE("*** PIC Programmer Warning ***"),
      MB_ICONEXCLAMATION | MB_YESNOCANCEL | MB_DEFBUTTON3 ) == IDYES );
  }

 return fOkToClose;
} // end WinPic_OkToCloseDueToErasedCalibration()


//---------------------------------------------------------------------------
BOOL WinPic_ParseCommandLine(void)
{
  AnsiString s;

  char sz255Command[256];
  char *cp;


  WinPic_fCommandLineMode = FALSE;

  // Parse all arguments from the command line.
  //     Most likely, this will be an instruction to LOAD a file
  //     which will be programmed into the device later, etc.
  // There will DELIBERATELY be a certain delay between executing all args.
  for(int iCmdArgumentIndex = 1;
          iCmdArgumentIndex <= ParamCount();
          iCmdArgumentIndex++)
   {
    strncpy(sz255Command, ParamStr(iCmdArgumentIndex).c_str(), 255 );
    APPL_ShowMsg( APPL_CALLER_MAIN, 0,
       "%s : \"%s\"", TE("Parsing argument from command line"), sz255Command );
    cp = sz255Command;
    if(strncmp(cp,"/nodelay",8)==0)
     {
       WinPic_fCommandLineOption_NoDelay = TRUE;
     }
    else if(strncmp(cp,"/tm=",4)==0)  // "/tm=" = test mode
     { cp+=4;
       WinPic_iTestMode = HexStringToLongint(4, cp);
       if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
         APPL_LogEvent( "ParseCommandLine: GUI-Speed-Test enabled" );
     }
    else if(strncmp(cp,"/overwrite",10)==0)
     { // "/overwrite"  =  "don't ask silly questions if an already existing file
       //                   would be overwritten"
       WinPic_fCommandLineOption_QueryBeforeOverwritingFiles = FALSE;
     }
    else if(strncmp(cp,"/device=",8)==0)
     { cp+=8;
       // The configuration has been loaded EARLIER,
       // so it makes sense to override the PIC DEVICE here :
       if(strcmp( cp, Config.sz40DeviceName)!=0)
        { APPL_ShowMsg( APPL_CALLER_PIC_PRG,0,
            "Info: Device set to \"%s\" via command line .", cp );
        }
       strncpy(Config.sz40DeviceName, cp, 40);
     }
    else if(strncmp(cp,"/config_word=",13)==0)
     { cp+=13;
       WinPic_i32CmdLineOption_OverrideConfigWord = HexStringToLongint(4, cp);
     }
    else if(strncmp(cp,"/e",2)==0)
     { // /e = "erase"
       WinPic_fCommandLineOption_Erase   = TRUE;
       WinPic_fCommandLineMode           = TRUE;
     }
    else if(strncmp(cp,"/p",2)==0)
     { // /p = "program"
       WinPic_fCommandLineOption_Program = TRUE;
       WinPic_fCommandLineMode           = TRUE;
     }
    else if(strncmp(cp,"/q",2)==0)
     { // /q = "quit"
       WinPic_fCommandLineOption_Quit    = TRUE;
       WinPic_fCommandLineMode           = TRUE;
       if( cp[2]=='=' && cp[3]>'0' && cp[4]<='9'  )
        { // "additional number of SECONDS before quitting" ?
          WinPic_i200msToQuit = (cp[3]-'0') * 5;
        }
     }
    else if(strncmp(cp,"/r",2)==0)
     { // /r = "read"
       WinPic_fCommandLineOption_Read    = TRUE;
       WinPic_fCommandLineMode           = TRUE;
     }
    else if(strncmp(cp,"/v",2)==0)
     { // /v = "verify"
       WinPic_fCommandLineOption_Verify  = TRUE;
       WinPic_fCommandLineMode           = TRUE;
     }
    else // none of these commands, guess the string is a FILENAME..
     {
       strcpy( Config.sz255HexFileName, cp );
       // Since 2004-01-09:  If the filename was the *ONLY* parameter,
       //                    automatically set the 'LOAD' flag
       //                    to simplify drag-and-drop on WinPic's icon.
       if( ParamCount()==1 )
        {
         if( FileExists(Config.sz255HexFileName) )
             WinPic_fCommandLineOption_Load = TRUE;
        }
     }
   } // end for <all command line arguments>

  return WinPic_fCommandLineMode;

} // end WinPic_ParseCommandLine()






/*--------------- Implementation of the main form -------------------------*/


 // "usages" of the message panel ( m_iMessagePanelUsage, Pnl_Message->Caption)
#define MP_USAGE_NOTHING       0
#define MP_USAGE_BUSY          1
#define MP_USAGE_INFO          2
#define MP_USAGE_WARNING       3
#define MP_USAGE_ERROR         4
#define MP_USAGE_COMMAND_TIMER 5

//---------------------------------------------------------------------------
__fastcall TPicMain::TPicMain(TComponent* Owner)
        : TForm(Owner)
{  // constructor
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::FormCreate(TObject *Sender)
{  // This OnCreate-method will be executed ONCE BEFORE the window is visible
 int i;
 AnsiString section;
 AnsiString s;
 TIniFile   *pIniFile;
 T_PicDeviceInfo MyDeviceInfo;
 T_PicConfigBitInfo * pConfigBitInfo;
 char sz255Temp[256];

   // Check if "this" program is already running somewhere in another instance.
   // If so, DO NOT start a second instance because the printer port will already
   // be in use !
   ::CreateMutex( NULL, TRUE, "WinPicProg");
   if( GetLastError() == ERROR_ALREADY_EXISTS)
    {
     MessageBox( Handle,
           "Please do not start more than\n"\
           "one instance of this program !",
           "Error - WinPic already running",
          MB_ICONEXCLAMATION | MB_OK );
     // ex: exit(-1);   // TERMINATE ME PLEASE
     // Close();  // does not work here !
     WinPic_fCloseImmediately = TRUE;
     return;
   }


   m_Updating = 1;
   m_original_title = Caption;
   m_iMessagePanelUsage = MP_USAGE_NOTHING;

   // Load the "global" configuration for all modules of this program
   CFG_Init(); CFG_Load();
   m_fMaySaveSettings = TRUE;

   // Parse the command line arguments. This may overwrite something in the config,
   // at least the "current" filename.
   WinPic_ParseCommandLine();



   /* load some windows stuff like old screen position & size : */
   // 2006-10-01: It appeared that WinPic only worked properly under Win98
   //   when the "current working directory" was the path to the executable.
   //   It wasn't clear if that applied to the following ini file, or one of
   //   the "other" files (like the device database).
   // ( this problem could not be reproduced under windows XP yet )
   pIniFile=new TIniFile(ExtractFilePath(Application->ExeName)+CFG_INI_FILE_NAME);
   section = Name;
   Left = pIniFile->ReadInteger(section, "Left", Left);  // no effect if Position=poScreenCenter ?!
   Top  = pIniFile->ReadInteger(section, "Top",  Top );
   Width= pIniFile->ReadInteger(section, "Width",Width);
   Height=pIniFile->ReadInteger(section,"Height",Height);
   ToolWin_iX1 = pIniFile->ReadInteger(section, "ToolWinLeft", ToolWin_iX1);
   ToolWin_iY1 = pIniFile->ReadInteger(section, "ToolWinTop",  ToolWin_iY1);
   ToolWin_iVisible = pIniFile->ReadInteger(section, "ToolWinVisible",  ToolWin_iVisible);
   Pnl_Tools->Visible = pIniFile->ReadInteger(section, "SpeedButtonsVisible", 1 );

   Pnl_CodeMemColors->Color = (TColor)pIniFile->ReadInteger(section,"CodeMemBgColor", (long)clBlack );
   Pnl_CodeMemColors->Font->Color = (TColor)pIniFile->ReadInteger(section,"CodeMemFgColor", (long)clLime );

   Pnl_DataMemColors->Color = (TColor)pIniFile->ReadInteger(section,"DataMemBgColor", (long)clWhite );
   Pnl_DataMemColors->Font->Color = (TColor)pIniFile->ReadInteger(section,"DataMemFgColor", (long)clBlack );

   APPL_i32CustomizeOptions = pIniFile->ReadInteger(section,"Customize", 0 );
   if( APPL_i32CustomizeOptions & APPL_CUST_NO_INTERFACE_SELECTION )
    {  Grp_InterfaceType->Visible = FALSE;
    }
   if( APPL_i32CustomizeOptions &  APPL_CUST_NO_MENU_EDIT )
    {  Edit1->Visible = FALSE;
    }
   if( APPL_i32CustomizeOptions & (APPL_CUST_NO_HEX_EDITOR | APPL_CUST_NO_MENU_EDIT ) )
    {  Menu_EnableEdit->Visible = FALSE;
       Menu_ApplyHexEdits->Visible = FALSE;
       Menu_DiscardHexEdits->Visible = FALSE;
    }
   if( APPL_i32CustomizeOptions & APPL_CUST_NO_CONFIG_EDITOR )
    {
    }
   if( APPL_i32CustomizeOptions & APPL_CUST_NO_MENU_SPECIALS )
    {  Specials1->Visible = FALSE;
    }

   // Find all possible TRANSLATION FILES, here: in the directory of WinPic.exe :
   s = ExtractFilePath(Application->ExeName);
   strcpy( sz255Temp, s.c_str() );   // this already contains a trailing backslash !
   strncat(sz255Temp, "translations\\*.txt", 255);
   YHF_FindTranslationFiles( sz255Temp );

   // Set the default language, and *PREPARE TO* translate all forms :
   YHF_iLanguageTestMode = pIniFile->ReadInteger(section, "LanguageTestMode", 0);
   s = pIniFile->ReadString(section, "Language", "" );
   YHF_SetLanguage( s.c_str(), // ISO-ISO639-1 code of the new language
        NULL ,   // let YHF_MultiLang find the translation file automatically
        FALSE ); // FALSE = may **NOT** translate the application's forms now !


   // The "most recent file" list is only a part of the user interface:
   section = "MostRecentFiles";
   for( i=0; i<=5; ++i)
      SetMRFname( i, "" );
   for(i=0; i<=5; ++i)
      AddMRFname( pIniFile->ReadString(section,"file"+IntToStr(i),"") );
   delete pIniFile;  // actually CLOSES the ini file, so OTHER modules may access it too.


   Update();

   // Since 2008-05, external DLLs ("plugins") may need to know the
   //  handle of the main window, and the "application handle". Voila :
   memset( &PHWInfo, 0, sizeof(PHWInfo) );
   PHWInfo.dwhMainWindow = (DWORD)Handle; // "Handle" is a VCL-property, actually the 'hWindow'
    // ( Why we cannot retrieve this handle-thing in PicHW.cpp ?
    //   Because we don't want to have too much Borland-specific VCL-stuff in there)
   PHWInfo.dwhAppInstance= (DWORD)GetWindowLong(Handle,GWL_HINSTANCE);

   // Initialize the memory buffers and other stuff...
   if( ! PIC_HEX_Init() ) // Initialize buffers for program + data memory  (#1)
    {  Close();     // buffer-init failed ? Almost impossible under windows !
       return;
    }
   PIC_PRG_Init();  // Set default PIC type and type-dependent infos (#2)
   if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
    { APPL_LogEvent( "CreateForm: Setting PIC-Device" );
    }
   if( PicDev_GetDeviceInfoByName( Config.sz40DeviceName, &MyDeviceInfo ) >= 0 )
          PIC_PRG_SetDeviceType( &MyDeviceInfo );  // -> PIC_DeviceInfo
     else PIC_PRG_SetDeviceType( PIC_DEV_TYPE_UNKNOWN );

   PIC_HEX_ClearBuffers(); // contents of some memory buffers depends on PIC_DeviceInfo !
   REd_CodeMem->Modified = FALSE;
   REd_DataMem->Modified = FALSE;

   if( WinPic_i32CmdLineOption_OverrideConfigWord >= 0)
    { PicBuf_SetConfigWord(0, // override config word if specified in command line:
        (WORD)WinPic_i32CmdLineOption_OverrideConfigWord ) ;
    }


   ProgressBar1->Visible = false;
   // No-No: ToolWin->ProgressBar1->Visible = false;

   m_update_code_mem_display = true;
   m_update_data_mem_display = true;
   m_displayed_interface_type= -1;
   for(i=0; i<2; ++i)
     m_displayed_config_word[i] = 0;
   for(i=0; i<PICDEV_MAX_CONFIG_BIT_INFOS; ++i)
     m_pConfigBitGridRowNumber_to_ConfigBitInfoPtr[i] = NULL;
   m_sz40DisplayedDeviceName[0] = 0;
   m_progress_visible        = false;
   m_fUseSerialPort = false;
   m_Updating = 0;

   if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
    { APPL_LogEvent( "CreateForm: Initialising help system" );
    }

  /* some more Windooze stuff: */
  Application->HelpFile = "WinPicPr.hlp";

  // Redirect the Application's OnHelp handler to use HTML instead of the
  //  lousy WinHelp system (which requires the bugged Help Compiler)
  // What a relief: Never edit endless RTF files again !!
  s = ExtractFilePath(Application->ExeName) + "html\\";
  YHF_HELP_Init(  // Initialize a replacement for WinHelp ...
       Handle,    //  handle of the application's main window
       s.c_str(), //  path of html files, independent of the "current directory"
      MyHelpMap,  //  pointer to list (translation table for Help Topic IDs)
             1);  //  iLanguageCode, usually the international dialing code

  Application->OnHelp = AppHelp;  // redirect the help handler

  TS_DeviceConfigResize(Sender);  // adjust table column widths for new window

  PageControl1->ActivePage = TS_ProgramMemory;

   if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
    { APPL_LogEvent( "CreateForm: done" );
    }

} // end FormCreate()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
bool/*not BOOL*/ __fastcall TPicMain::AppHelp(Word Command, int Data, bool/*not BOOL!*/ &CallHelp)
{
  // Redirected handler for TApplication::OnHelp .
  CallHelp = false;  // don't try to call the original WinHelp system !
  // Info about the Command and Data parameters can be found in the
  // Win32 Programmer's Reference on "WinHelp"
  switch( Command )
   {
    case HELP_CONTEXT:
         return YHF_HELP_ShowHelpContext( Data /* iHelpContext*/ );
    default:
         return FALSE;
   }
} // end AppHelp()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::FormClose(TObject *Sender, TCloseAction &Action)
{ // The OnClose-method of the main form should save the config & clean up
 int i;
 AnsiString section;
 AnsiString s;
 TIniFile   *pIniFile;


   if( m_fMaySaveSettings )
    {
     /* Save some windows stuff like old screen position & size.              */
     /* The author prefers saving "local" parameters in an old-style INI file */
     /*  instead of putting every parameter in the ugly registry.             */
     pIniFile=new TIniFile(ExtractFilePath(Application->ExeName)+CFG_INI_FILE_NAME);
     section = Name;
     pIniFile->WriteInteger(section, "Left", Left);
     pIniFile->WriteInteger(section, "Top",  Top );
     pIniFile->WriteInteger(section, "Width",Width);
     pIniFile->WriteInteger(section,"Height",Height);
     if(ToolForm && ToolForm->Visible)
      { ToolWin_iX1 = ToolForm->Left;
        ToolWin_iY1 = ToolForm->Top;
      }
     pIniFile->WriteInteger(section,"CodeMemBgColor", (long)Pnl_CodeMemColors->Color );
     pIniFile->WriteInteger(section,"CodeMemFgColor", (long)Pnl_CodeMemColors->Font->Color );
     pIniFile->WriteInteger(section,"DataMemBgColor", (long)Pnl_DataMemColors->Color );
     pIniFile->WriteInteger(section,"DataMemFgColor", (long)Pnl_DataMemColors->Font->Color );

     pIniFile->WriteInteger(section, "SpeedButtonsVisible", Pnl_Tools->Visible );     
     pIniFile->WriteInteger(section,"ToolWinVisible",ToolWin_iVisible);
     pIniFile->WriteInteger(section,"ToolWinLeft", ToolWin_iX1);
     pIniFile->WriteInteger(section, "ToolWinTop",  ToolWin_iY1);

     pIniFile->WriteString(section, "Language",YHF_GetLanguage() );
     pIniFile->WriteInteger(section,"LanguageTestMode",YHF_iLanguageTestMode );

     // The "most recent file" list is only a part of the user interface:
     section = "MostRecentFiles";
     for(i=0; i<=5; ++i)
        pIniFile->WriteString(section,"file"+IntToStr(i), GetMRFname(i) );
     delete pIniFile;

     strncpy(Config.sz40DeviceName, PIC_DeviceInfo.sz40DeviceName, 40) ;
     CFG_Save();
    } // end if( m_fMaySaveSettings )

   if(ToolForm)
      ToolForm->Close(); // not called automagically ?!
   PIC_HW_Close();
}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
void __fastcall TPicMain::CB_LanguageChange(TObject *Sender)
{
 AnsiString s;
 int i;
 char *cp;
 if( m_Updating )
     return;
 ++m_Updating;
 i = CB_Language->ItemIndex;
 if(i>=0)
  { s = CB_Language->Items->Strings[i];
    cp = strchr( s.c_str(), '(');
    if(cp)
     { YHF_SetLanguage( cp+1/*NewLanguage*/ , NULL/*auto-detect file name*/,
                        TRUE ) ; // TRUE = may translate the application's forms now
       UpdateDeviceConfigTab( TRUE/*update HEX display also*/ );
     }
  }
 --m_Updating;
}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
void __fastcall TPicMain::MI_DumpTranslatorClick(TObject *Sender)
{
   YHF_DumpTranslatorFile( "translation_test.txt" );
   APPL_ShowMsg( APPL_CALLER_MAIN, 0,
       "Dumped translation table into \"translation_test.txt\"" );
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::TestTheInterface(void)
{
 int n_errors = 0;
 BOOL fResult;

   PIC_HW_ConnectToTarget();  // here since 2005-03-29
   PIC_HW_SetDataEnable( TRUE ); // rarely used, but may be necessary

   // A little test to find out if an interface MAY be present:
   if(!PIC_HW_SetVpp(false) )
    { Mem_Messages->Lines->Add(TE("Could not switch off Vpp !") );
      ++n_errors;
    }

   // Only for PICs where an extra Vdd switch exists, which does NOT
   // turn "Vpp" on....  turn Vdd on, otherwise 'read back' may not work,
   // for example in the PIP84 programmer:
   if( PicHw_IsVddOn() >= 0) // '-1' if no extra Vdd switch exists...
      PIC_HW_SetVdd(true);

   UpdateInterfaceTestDisplay();

   if(!PIC_HW_SetClockAndData( false/*clock_high*/, false/*data_high*/ ) )
    { Mem_Messages->Lines->Add(TE("Could not switch Clock or Data !") );
      ++n_errors;
    }
   UpdateInterfaceTestDisplay();

   PIC_HW_Delay_us(500);
   if( PIC_HW_GetDataBit() != 0 )
    { Mem_Messages->Lines->Add(TE("Failed read back of DATA line (LOW) !") );
      ++n_errors;
    }

   if(!PIC_HW_SetClockAndData( false/*clock_high*/, true/*data_high*/ ) )
    { Mem_Messages->Lines->Add(TE("Could not switch Clock or Data !") );
      ++n_errors;
    }

   UpdateInterfaceTestDisplay();

   PIC_HW_Delay_us(20000);  // 10uF-cap may be discharged !
   if( PIC_HW_GetDataBit() != 1 )
    {
      Mem_Messages->Lines->Add( TE("Failed read back of DATA line (HIGH) !") );
      ++n_errors;
    }



   PIC_HW_SetClockAndData( false/*clock_high*/, false/*data_high*/ );
   if( n_errors == 0 )
    {
     APPL_ShowMsg(APPL_CALLER_MAIN,0, TE("Initialising PIC-Programmer: Success.") );
     Txt_InterfaceType->Caption = TE("Interface tested, OK.");
     fResult = true;
    }
   else
    {
     APPL_ShowMsg(APPL_CALLER_MAIN,0, TE("WARNING: Could not initialize programmer !") );
     Txt_InterfaceType->Caption = TE("Error testing the Interface");
     fResult = false;
    }

   UpdateInterfaceTestDisplay();


   if(PIC_HW_interface.type==PIC_INTF_TYPE_JDM2)
    { // for the JDM programmer, things are very different.
      // Here, TXD(Vpp), DTR(DataOut), and RTS(Clock) must be set HIGH
      //       to turn the PIC's supply voltage off :
      PIC_HW_SetClockAndData( TRUE, TRUE );
      PIC_HW_SetVpp( TRUE );   // Yes, indeed TRUE to turn the PIC's supply voltage off !
    }
   else  // Not JDM... for all other interfaces : turn everything OFF by setting it LOW :
    {
     if( PicHw_IsVddOn() >= 0) // '-1' if no extra Vdd switch exists...
         PIC_HW_SetVdd(false);
    }

   PIC_HW_SetDataEnable( FALSE );
   PIC_HW_DisconnectFromTarget();  // here since 2005-03-29

   UpdateInterfaceTestDisplay();


   return fResult;
} // end TestTheInterface()

//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::InterfaceSpeedTest(void)
{
 int  n_errors = 0;
 int  iTestLoops, i50nsLoops, i50nsLoopsUnstable;
 #define N_TEST_LOOPS 10
 double dblDelayTimes_ns[N_TEST_LOOPS];
 BOOL fDataOutState;
 char sz255Msg[256]; char *cp;
 LONGLONG i64PTFreq, i64PTStart, i64PTStop;
 double dblLoopTime_ns;


   QueryPerformanceFrequency( (LARGE_INTEGER *) &i64PTFreq );

  // Check how fast we can set and reset the CLOCK signal .
  //  You may be badly surprised how increadibly slow the access
  //  to such a stupid piece of hardware can be under windoze these days !
  QueryPerformanceCounter( (LARGE_INTEGER*)&i64PTStart );
  for(iTestLoops=0; iTestLoops<1000; ++iTestLoops)
   {
     PIC_HW_SetClockAndData( (iTestLoops&1)!=0/*clock_high*/,
                             (iTestLoops&2)!=0/*data_high*/  );
   }
  QueryPerformanceCounter( (LARGE_INTEGER*)&i64PTStop );
  dblLoopTime_ns = (double)(i64PTStop - i64PTStart);
  if(i64PTFreq>0)
   { dblLoopTime_ns *= (1e9 / ((double)1000/*Loops*/ * (double)i64PTFreq) );
     sprintf( sz255Msg, "SetClockAndData takes %d ns per call .",(long)dblLoopTime_ns);
     if(dblLoopTime_ns > 1e6 )
      { strcat( sz255Msg, " THIS IS INCREDIBLY SLOW ! " );
        // One example: A USB<->RS-232 adapter by "Belkin", which identified
        //  itself as "Prolific USB-Serial Adapter" in the system control,
        //  required almost 5 ms (FIVE MILLISECONDS!!!!) for a Clock-and-Data-Cycle.
      }
     APPL_ShowMsg(APPL_CALLER_MAIN,0, sz255Msg );
   }
  else
   { APPL_ShowMsg(APPL_CALLER_MAIN,0, "Something wrong with QueryPerformanceFrequency !" );
   }


  // The next part of the "interface speed test" just sends
  // ONES and ZEROES to the interface, as fast as possible,
  // and check the time until the wanted levels are read back .
  //  The delay times for the INTERFACE (! - not the chip) should be set
  //  at least THREE TIMES this value, because the PIC's threshold voltage
  //  may be totally different from the serial port's threshold.
  //  Most of the speed-test is described in the manual so we don't
  //  need lengthy explanations here.

  PIC_HW_ConnectToTarget();     // must be connected to the "target" even if no chip inserted
  PIC_HW_SetDataEnable( TRUE ); // rarely used, but may be necessary
  PIC_HW_SetVpp(false);
  PIC_HW_SetVdd(true);     // turn Vdd on, otherwise 'read back' may not work


  for(iTestLoops=0; iTestLoops<N_TEST_LOOPS; ++iTestLoops)
   {
     fDataOutState = (iTestLoops & 1) ? TRUE : FALSE;
     if(!PIC_HW_SetClockAndData( FALSE, fDataOutState ) )
      { ++n_errors;
      }
     PIC_HW_LongDelay_ms( 10/*milliseconds*/ ); // wait until everything is settled
     PIC_HW_ShortDelay(PIC_HW_dwCount50ns);  // make sure this routine is in the CPU cache
     PIC_HW_GetDataBit();                    // .. and this routine too

     // Now swith the DATA line to "the other state" and wait until we read that state back..
     fDataOutState = !fDataOutState;
     i50nsLoops = i50nsLoopsUnstable = 0;
     QueryPerformanceCounter( (LARGE_INTEGER*)&i64PTStart );
     if(!PIC_HW_SetClockAndData( FALSE, fDataOutState ) )  // time-critical section..
      { ++n_errors;
      }
     // wait for 100 microseconds, observing the read-back DATA signal :
     while(i50nsLoops < 10000/* a few milliseconds*/ )
      { ++i50nsLoops;
        if( PIC_HW_GetDataBit() != fDataOutState )
         {  // read-back state is not "stable" yet:
            i50nsLoopsUnstable = i50nsLoops;
         }
      }
     QueryPerformanceCounter( (LARGE_INTEGER*)&i64PTStop );
     dblLoopTime_ns = (double)(i64PTStop - i64PTStart);
     if(i64PTFreq>0)
            dblLoopTime_ns *= (1e9 / ((double)i50nsLoops * (double)i64PTFreq) );
     else   dblLoopTime_ns = 50.0; // guesswork if no "performance timer" available
     // Typical loop time, measured with PortTalk + 1.6 GHz-P4 : 1600 ns
     dblDelayTimes_ns[iTestLoops] = dblLoopTime_ns * (double)i50nsLoopsUnstable;
   } // end for(iTestLoops .. )

   // Finished speed-checking loop, turn interface control lines off...
   PIC_HW_SetDataEnable( FALSE );
   PIC_HW_DisconnectFromTarget();
   UpdateInterfaceTestDisplay();

   // Present the results...
   strcpy( sz255Msg, "Response times L->H : ");
   cp = sz255Msg+strlen(sz255Msg);
   for(iTestLoops=0; iTestLoops<N_TEST_LOOPS; iTestLoops+=2)
    { sprintf( cp, " %dns",(int)dblDelayTimes_ns[iTestLoops] );
      cp += strlen(cp);
    }
   APPL_ShowMsg(APPL_CALLER_MAIN,0, sz255Msg );
   strcpy( sz255Msg, "Response times H->L : ");
   cp = sz255Msg+strlen(sz255Msg);
   for(iTestLoops=1; iTestLoops<N_TEST_LOOPS; iTestLoops+=2)
    { sprintf( cp, " %lgns",dblDelayTimes_ns[iTestLoops] );
      cp += strlen(cp);
    }
   APPL_ShowMsg(APPL_CALLER_MAIN,0, sz255Msg );


   return (n_errors==0);
} // end InterfaceSpeedTest()


//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::TestDelayRoutine(void)
{
 long i32StartTime, i32EndTime;
 struct time dos_time;
 char sz80[82];
 float fltMeasuredDelay;
 LONGLONG i64;

   // Test function of the delay routine :
   gettime( &dos_time );
   i32StartTime = dos_time.ti_hund + 100*dos_time.ti_sec;  /* hundredths of seconds */
   PIC_HW_Delay_us( 500000/*microseconds*/ );
   gettime( &dos_time );
   i32EndTime = dos_time.ti_hund + 100*dos_time.ti_sec;
   if(i32EndTime<i32StartTime) i32EndTime+= 60 * 100;  // minute wrap
   fltMeasuredDelay = (float)(i32EndTime-i32StartTime) / 100.0;
   QueryPerformanceFrequency( (LARGE_INTEGER *) &i64 );
   sprintf(sz80, TE("Testing: delay(500ms) took %.2f seconds, timer_freq=%.4f MHz ..."),
                  (float)fltMeasuredDelay,  (float)i64 * 1E-6 );
   // "gettime()" may have a resolution of only 0.1 seconds, so be tolerant :
   if(fltMeasuredDelay>=0.40 && fltMeasuredDelay<=0.60)
    {
      Mem_Messages->Lines->Add( AnsiString(sz80) + " ok" );
      return TRUE;
    }
   else
    { Mem_Messages->Lines->Add( AnsiString(sz80) + " " + AnsiString(TE("ERROR !")) );
      return FALSE;
    }
} // end TestDelayRoutine()



//---------------------------------------------------------------------------
void __fastcall TPicMain::DisconnectTarget(void)
{
  PIC_HW_DisconnectFromTarget(); // since 2002-09-09 . From Johan Bodin:
  // > This signal is used to *totally* disconnect the programmer
  // > from the target system (using relay(s) and/or CMOS analog switches
  // > or whatever).
  // > This eliminates the need to plug/unplug the programming connector
  // > for code test runs.
  // For parallel port interfaces, D7 is used to do the job. HIGH=disconnect(!)
  UpdateInterfaceTestDisplay();
} // end TPicMain::DisconnectTarget()



//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::ReadPicAndDumpToFile(char *fn)
{
  BOOL ok;
  BOOL not_blank;

  WinPic_RedAndGreenLedOff();

  m_iMessagePanelUsage = MP_USAGE_BUSY;
  m_fPicDeviceConflict = FALSE;
  APPL_iUserBreakFlag = 0;
  ok = PIC_PRG_ReadAll(false, &not_blank); // ..(false) = not "blank check only"

  UpdateAllSheets(); // make the changes visible on the screen

  if( !ok )
   { // reading not ok, for any strange reason it was "aborted" ...
     APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE( "Action aborted") );
     m_iMessagePanelUsage = MP_USAGE_ERROR;
     return false;
   }
  if(not_blank)
   {
     return DumpEverythingToHexFile(fn);
   }
  else
   {
     APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("PIC is erased - nothing to dump") );
     m_iMessagePanelUsage = MP_USAGE_INFO;
     WinPic_RedAndGreenLedOff();
     return false;
   }
} // end TPicMain::ReadPicAndDumpToFile()
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
int PicPrg_GetNrOfConfigMemLocationsToWrite(void)
{
  int iNrWordsWriteable = PicDev_GetConfMemSize();
  if( iNrWordsWriteable != (PicBuf[PIC_BUF_CONFIG].i32LastUsedArrayIndex+1) )
   {
     // If there are LESS config memory words in the device info
     //  than loaded from the hex file, show a warning (file may be fishy).
     // If there are MORE config memory words in the device info
     //  than loaded, it's ok, those at the end are often "not so important" .
     if( iNrWordsWriteable > (PicBuf[PIC_BUF_CONFIG].i32LastUsedArrayIndex+1)  )
      { // Only program as many config mem words as "loaded", ignore the rest.
        // AT LEAST THE dsPIC DOES NOT ERASE THESE BITS, SO ITS 100% SAFE
        // TO LEAVE THEM "AS THEY ARE" !   ( ToDo: Check this for other devices)
        iNrWordsWriteable = PicBuf[PIC_BUF_CONFIG].i32LastUsedArrayIndex+1;
      }
     else // iNrWordsWriteable < (PicBuf[PIC_BUF_CONFIG].i32LastUsedArrayIndex+1) :
      {   // There are more config mem words "loaded" than exist in the device ?!
          // ( a smart HEX load routine may already have signalled this, but ... )
        APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
           TE("Problem: Buffer contains more CONFIG MEMORY WORDS (%d) than exist in device (%d) ."),
            (int)PicBuf[PIC_BUF_CONFIG].i32LastUsedArrayIndex+1, (int)iNrWordsWriteable );
      }
   }
  return iNrWordsWriteable;
}


//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::ProgramPic(void)
{  // programs the buffer contents into the PIC, and verifies (if possible)
 int error_count = 0;
 DWORD dw;
 long i32FirstAddress, i32LastAddress;
 BOOL fProgramAll;
 BOOL fOkToGo = TRUE;
 BOOL fResult = TRUE;
 BOOL fDidSomething = FALSE;
 char sz80Temp[100];
 char sz255Temp[256];
 char *pszMsg;
 DWORD dwTemp4[4];


  APPL_iUserBreakFlag = 0;

  sprintf( sz80Temp, "%s...",  TE("Programming") );
  m_iMessagePanelUsage = MP_USAGE_BUSY;
  APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp  );
  if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );


  PicPrg_iCodeMemErased   = 0;
  PicPrg_iCodeMemVerified = 0;  // 0 = not yet, 1=verified "ok", -1=error(s)
  PicPrg_iDataMemErased   = 0;
  PicPrg_iDataMemVerified = 0;
  PicPrg_iConfMemErased   = 0;
  PicPrg_iConfMemProgrammed=0;
  PicPrg_iConfMemVerified = 0;
  PicPrg_iConfWordProgrammed=0; // .. means the "classic" config word with readout protection.
  PicPrg_iConfWordVerified = 0;

  WinPic_RedAndGreenLedOff();

  PIC_HW_ConnectToTarget();  // also HERE in TPicMain::ProgramPic() since 2003-12-28
  if( PIC_HW_CanSelectVdd() )        // since 2005-09-29 :
   { PIC_HW_SelectVdd( 1/*norm*/ );  // use the "normal" voltage (=5V) for programming
   }

  fProgramAll = FALSE;      // what are we going to do, "program EVERYTHING" or just a part ?
  if(  (Config.iProgramWhat==PIC_PROGRAM_ALL)
     ||( Config.iProgramWhat==(PIC_PROGRAM_CODE+PIC_PROGRAM_CONFIG)
         && (PIC_DeviceInfo.lDataEEPROMSizeInByte <= 0) )  // PICs w/o EEPROM ?
    ) 
   {
    fProgramAll = TRUE;
   }

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // First optional step: bulk erase (all but CALIBRATION BITS where applicable)
  if( fProgramAll
      && (Config.iUseCompleteChipErase)
      && (PIC_DeviceInfo.iCodeMemType==PIC_MT_FLASH)
      && (PIC_DeviceInfo.wCodeProgAlgo!=PIC_ALGO_PIC10F) // for PIC10F20x, erase is part of "ProgramAll" !
      && (PIC_DeviceInfo.wCodeProgAlgo!=PIC_ALGO_PIC16F7X) // ... similar "special case" for PIC16F74 etc
    )
   {   fDidSomething = TRUE;
       strcpy(sz80Temp, TE("Erasing (\"bulk\" or \"chip\") ...") );
       APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
       if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );
       Update();
       if( PIC_PRG_Erase( PIC_ERASE_ALL | PIC_SAVE_CALIBRATION ) )  // here in ProgramPic()
         { Pnl_Message->Caption = TE("Erased");
           PicPrg_iCodeMemErased   = 1;    // have erased CODE memory now
           PicPrg_iDataMemErased   = 1;    // have erased EEPROM DATA (if exists) too
           PicPrg_iConfMemErased   = 1;    // ..but not *necessarily* the config bits
         }
        else
         { pszMsg = TE("Erasing FAILED !");
           APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, pszMsg );
           if(ToolForm) ToolForm->ShowMsg( pszMsg, TWMSG_ERROR );
         }
       Update();
   } // end if <ok to erase the PIC ?>
  else
   { // no ERASE before PROGRAMMING ?!?
     // Impossible with many devices, except if the location ARE ALREADY CLEAR.
     // Most new chips do NOT support erasing individial cells
     // (which is one of the major differences between FLASH and EEPROM)
     // so trying to "program the chip" without prior erase
     // generally doesn't make sense .
     // Some PIC programming routines will always erase the chip (PIC16F7x for example).
   }


  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // Second, optional, but usually the most important step: program CODE
  if(Config.iProgramWhat&PIC_PROGRAM_CODE)
   {
    i32FirstAddress = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_CODE, 0 );
    i32LastAddress  = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_CODE, PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex);
    if ( PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex >= 0 )
     {
      fOkToGo = TRUE;
      if(PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex >= PIC_DeviceInfo.lCodeMemSize)
       {
         sprintf(sz80Temp,
             TE("Warning: Last program addr (0x%06lX) exceeds device memory size (0x%06lX) !"),
                                 (long)PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex,
                                 (long)PIC_DeviceInfo.lCodeMemSize );
         APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
         sprintf(sz255Temp,"%s\n%s",
                           sz80Temp,
             TE("Select YES to ignore this problem and truncate the buffer contents.") );
         if(MessageBox(  Handle, sz255Temp,
                 TE("Problem encountered before CODE MEMORY programming") ,
           MB_ICONQUESTION | MB_YESNOCANCEL | MB_DEFBUTTON2 ) == IDYES )
          {
           PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex = PIC_DeviceInfo.lCodeMemSize;
           fOkToGo = TRUE;
          }
         else
          {
           APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("Skipped CODE MEMORY programming.") );
           fOkToGo = TRUE;
          }
       } // end if <problem with CODE MEMORY size>

      if (fOkToGo)
       {
        // Erase code memory  only  if not already "erased ALL" :
        if( (Config.iProgramWhat!=PIC_PROGRAM_ALL) && (PIC_DeviceInfo.iCodeMemType==PIC_MT_FLASH)
           && (PIC_DeviceInfo.wCodeProgAlgo!=PIC_ALGO_PIC10F) // for PIC10F20x, there is only "ProgramAll" !
           && (PIC_DeviceInfo.wCodeProgAlgo!=PIC_ALGO_PIC16F7X) // ... similar for PIC16F74 ("ProgramAll")
          )
         {  // If the option "program all" is NOT selected, must erase program memory here
            // before programming it !
            // However, there is the option NOT TO ERASE before programming, so :
            sprintf( sz80Temp, "%s: %s ..", TE("Erasing"), TE("CODE") );
            APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
            if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );
            Update();
            if( ! PIC_PRG_Erase( PIC_ERASE_CODE | PIC_SAVE_CALIBRATION ) )  // here in ProgramPic(), "CODE" only
             { APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("Erasing FAILED !") );
               ++error_count;
             }
         } // end if < not "program all" >
        if (PIC_DeviceInfo.wCanRead)
        { sprintf( sz80Temp, "%s %s, 0x%06lX..0x%06lX",
                              (char*)TE("Programming and Verifying"), (char*)TE("CODE"),
                            (long)i32FirstAddress, (long)i32LastAddress );
        }
        else
        { sprintf( sz80Temp, "%s %s, 0x%06lX..0x%06lX",
                              (char*)TE("Programming"), (char*)TE("CODE"),
                            (long)i32FirstAddress, (long)i32LastAddress );
        }
        APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
        if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );

        if( PIC_DeviceInfo.iBitsPerInstruction==24 )
         {  // most likely a dsPIC30F (24 bits per instruction)
          if(!PIC_PRG_iSimulateOnly )
           { if(! dsPIC_WriteCodeMemory( 0x000000L, // dwDestAddress,
                     PicBuf[PIC_BUF_CODE].pdwData , // DWORD *pdwSourceData,
                     PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex+1)) // dwNrOfLocations
              { ++error_count;
              }
           }
          fDidSomething = TRUE;
         }
        else
        if( PIC_DeviceInfo.iBitsPerInstruction==16 )
         {  // may be a PIC18Fxxxx ...
#ifdef SUPPORT_PIC18F   // defined under compiler options..conditional defines
          if(!PIC_PRG_iSimulateOnly )
           { if(! PIC18F_WriteCodeMemory( 0x000000L, // dwDestAddress,
                     PicBuf[PIC_BUF_CODE].pdwData ,  // DWORD *pdwSourceData,
                     PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex+1)) // dwNrOfLocations
              { ++error_count;
              }
           }
#else
           APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, "Sorry, PIC18F not supported .") );
           ++error_count;
#endif // SUPPORT_PIC18F
          fDidSomething = TRUE;
         }
        else  // neither 24 nor 16 bits per instruction in CODE MEMORY ...
        if( PIC_DeviceInfo.iBitsPerInstruction==14 )
         {
           if( PIC_DeviceInfo.wCodeProgAlgo == PIC_ALGO_PIC16F7X )
            { // PIC16F7x (PIC16F74): Totally different prog spec, see PIC16F7x_PRG.C !
              if( !PIC16F7x_ProgramAll( PIC_ACTION_ERASE | PIC_ACTION_WRITE ) )
               { ++error_count;
               }
              PicPrg_iCodeMemVerified = 1;  // PIC16F7x_ProgramAll verifies while writing !
              fDidSomething = TRUE;
            } // end if < PIC16F73, PIC16F74, PIC16F76, PIC16F77 >
           else // everything else is HOPEFULLY not a "special case" / "extra module" :
            {
              // If there is a valid OSCILLATOR CALIBRATION WORD
              //   (which in fact is a RETLW at the end of the program memory)
              // smuggle it into the code memory buffer now:
              if(    (PIC_DeviceInfo.lAddressOscCal >= 0)
                 && (!Config.iDontCareForOsccal)  )
               { // there SHOULD BE an oscillator calib word:
                 if( PicBuf_GetBufferWord(PIC_DeviceInfo.lAddressOscCal, &dw ) > 0)
                  {
                   if( (PIC_lOscillatorCalibrationWord & 0xFF00) == 0x3400/*RETLW*/ )
                    { // have read a valid oscillator config word earlier, usually before bulk erase.
                      PicBuf_SetBufferWord(PIC_DeviceInfo.lAddressOscCal, PIC_lOscillatorCalibrationWord );
                      if(dw != (DWORD)PIC_lOscillatorCalibrationWord)
                       { APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
                          TE("Replaced OSCCAL word in buffer: old=0x%06lX, new=0x%06lX ."),
                          (long)dw, (long)PIC_lOscillatorCalibrationWord );
                       }
                    }
                   else // there should be an oscillator calib word,
                    {   // but PIC_lOscillatorCalibrationWord does not look like a RETLW instruction:
                      if( (dw & 0xFF00) == 0x3400)
                       { // The osc calib word in the program buffer is a RETLW instruction.. use it.
                         APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
                           TE("Using old OSCCAL word from buffer (0x%06lX) .") , (long)dw );
                       }
                      else // there is still no valid osc calib word in the buffer ...
                       {
                        if(PIC_iHaveErasedCalibration)
                         {
                          PicBuf_SetBufferWord(PIC_DeviceInfo.lAddressOscCal, 0x3480/*RETLW 0x80*/ );
                          APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
                            TE("Warning: using default OSC CALIB word instead of 0x%06lX .") ,
                            (long)dw );
                         }
                       }
                    }
                  } // end if < successfully read a "config word" >
                 // If a BULK ERASE has been done before, make sure CODE PROGRAMMING
                 // goes as far as the config word.
                 // Without BULK ERASE, this is not required.
                 if(PIC_iHaveErasedCalibration)
                  {
                   if(PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex < PIC_DeviceInfo.lAddressOscCal)
                      PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex = PIC_DeviceInfo.lAddressOscCal;
                  }
               } // end if <need to care for the PIC's oscillator calib word ?>

              if (!PIC_PRG_Program(   // only for 14-bit core !
                  PicBuf[PIC_BUF_CODE].pdwData, // pointer to source data
                  PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex+1, // number of words to be programmed
                  0x3FFF, // mask for programming and verification
                  PIC_DeviceInfo.iCmd_LoadProg, // 'load' command pattern
                  PIC_DeviceInfo.iCmd_ReadProg, // 'read' command pattern (for verifying)
                                           0) ) // target start address
               { ++error_count;
               }
              fDidSomething = TRUE;
            } // end else < no "special case" >
         }
        else // neither 14, 16, nor 24 bits per instruction in CODE MEMORY
        if( PIC_DeviceInfo.iBitsPerInstruction==12 )
         { // 12-bit-core : ONLY PIC10F20x supported by this version of WinPic ! ! !
           if( !PIC10F_ProgramAll( PIC_ACTION_ERASE | PIC_ACTION_WRITE ) )
            { ++error_count;
            }
           PicPrg_iCodeMemVerified = 1;  // PIC10F_ProgramAll verifies while writing !
           fDidSomething = TRUE;
         } // end else  -> neither 12, 14, 16, nor 24 bits per instruction in CODE MEMORY

        // If the CODE MEMORY hasn't been verified yet, do that now ...
        if( PicPrg_iCodeMemVerified == 0 )
         { // code memory not verified yet -> do that now :
           sprintf(sz80Temp, "%s %s, 0x%06lX..0x%06lX",
                       (char*)TE("Verifying"), (char*)TE("CODE"),
                       (long)i32FirstAddress, (long)i32LastAddress );
           APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
           if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );

           if( ! PicPrg_Verify( 0, // dwDeviceAddress
                  PicBuf[PIC_BUF_CODE].pdwData, // DWORD *pdwSourceData
                  PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex+1, // number of words to be programmed
                  0x3FFF, // mask for programming and verification (ignored for non-14-bit-core)
                  PIC_DeviceInfo.iCmd_ReadProg)) // 'read' command pattern (for verifying)
            { ++error_count;
            }
         } // end if < code memory not verified yet >
       } // end if (fOkToGo)
     }   // end if ( PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex >= 0 )
    else // no program in memory !
     {
        APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("Cannot Program CODE MEMORY, nothing in buffer.") );
        m_iMessagePanelUsage = MP_USAGE_WARNING;
     } // end else < no program in memory >
   } // end if(Config.iProgramWhat&PIC_PROGRAM_CODE)

  if(APPL_iUserBreakFlag)
   {
     APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("USER BREAK while programming.") );
     m_iMessagePanelUsage = MP_USAGE_WARNING;
     APPL_iUserBreakFlag = 0;
     if(ToolForm) ToolForm->ShowMsg( TE("USER BREAK"), TWMSG_NO_ERROR );
     return FALSE;
   }


  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // Third, optional step: program DATA EEPROM
  if( ( Config.iProgramWhat&PIC_PROGRAM_DATA )
    &&(PIC_DeviceInfo.wCodeProgAlgo!=PIC_ALGO_PIC10F) // PIC10F20x has no data EEPROM !
    )
   {
    i32FirstAddress = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_DATA, 0 );
    i32LastAddress  = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_DATA, PicBuf[PIC_BUF_DATA].i32LastUsedArrayIndex );
    if( PicBuf[PIC_BUF_DATA].i32LastUsedArrayIndex >= 0 )
     { fDidSomething = TRUE;

        if( (Config.iProgramWhat!=PIC_PROGRAM_ALL) && (PIC_DeviceInfo.iCodeMemType==PIC_MT_FLASH) )
         { // If the option "program all" is NOT selected, must erase program memory here
           // before programming it !
           // However, there is the option NOT TO ERASE before programming, so :
           sprintf(sz80Temp, "%s: %s ..", TE("Erasing"), TE("DATA") );
           APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
           if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );

           Update();
           if( PIC_PRG_Erase( PIC_ERASE_DATA ) )  // here in ProgramPic(), "DATA" only
             { APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("Erasing FAILED !") );
               ++error_count;
             }
         } // end if < not "program all" >

        sprintf(sz80Temp, "%s %s, 0x%06lX..0x%06lX",
                  (char*)TE("Programming"), (char*)TE("DATA"),
                  (long)i32FirstAddress, (long)i32LastAddress );
        APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
        if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );

        if( ! PicPrg_WriteDataMemory() ) // Note: doesn't necessarily verify !
         { ++error_count;
           m_iMessagePanelUsage = MP_USAGE_WARNING;
         }

        // If the DATA MEMORY (EEPROM) hasn't been verified yet, do that now ...
        if( PicPrg_iDataMemVerified == 0 ) // (some algo's verify while writing)
         { // code memory not verified yet -> do that now :
           sprintf(sz80Temp, "%s %s, 0x%06lX..0x%06lX",
                   (char*)TE("Verifying"), (char*)TE("DATA"),
                   (long)i32FirstAddress, (long)i32LastAddress );
           APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
           if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );

           if( ! PicPrg_Verify( i32FirstAddress, // dwDeviceAddress
                  PicBuf[PIC_BUF_DATA].pdwData,  // pointer to source data
                  PicBuf[PIC_BUF_DATA].i32LastUsedArrayIndex+1, // number of words to be verified
                  0x3FFF, // mask for programming and verification (only for 14-bit-core)
                  PIC_DeviceInfo.iCmd_ReadProg)) // 'read' command pattern (only for 14-bit-core)
            { ++error_count;
            }
         } // end if < code memory not verified yet >

     }
   } // end   if(  (Config.iProgramWhat&PIC_PROGRAM_DATA)

  if(APPL_iUserBreakFlag)
   {
     APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("USER BREAK while programming.") );
     m_iMessagePanelUsage = MP_USAGE_WARNING;
     APPL_iUserBreakFlag = 0;
     if(ToolForm) ToolForm->ShowMsg( TE("USER BREAK"), TWMSG_NO_ERROR );
     return FALSE;
   }

  // Intermediate step (moved here 2006-07): - - - - - - - - - - - - - - - - >
  //  Restore the original BANDGAP calibration bits for some 14-bit devices
  //  in the config-memory-buffer, before writing the config memory / config word:
  if( (Config.iDontCareForBGCalib==0)
   && (PIC_iHaveErasedCalibration )
   && (PIC_lBandgapCalibrationBits>=0)
   && (PIC_DeviceInfo.wCfgmask_bandgap!=0) )
   { // restore the bandgap calibration bits which have been read before bulk-erase ?
     APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("Restoring BANDGAP calibration bits for CONFIG-WORD") );
     if(Config.iVerboseMessages)
      { sprintf(sz80Temp, TE("Cfg word before restoring BG calib: 0x%06lX"),
                  (long)PicBuf_GetConfigWord(0) );
        APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
      }
     PicBuf_SetConfigWord( 0,
             (PicBuf_GetConfigWord(0) & ~PIC_DeviceInfo.wCfgmask_bandgap)
            |(PIC_lBandgapCalibrationBits & PIC_DeviceInfo.wCfgmask_bandgap) );
     if(Config.iVerboseMessages)
      { sprintf(sz80Temp, TE("Cfg word after restoring BG calib: 0x%06lX"),
                   (long)PicBuf_GetConfigWord(0) );
        APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
      }
   } // end if < must restore BANDGAP calibration bits ? >


  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // Fourth, optional step: program CONFIGURATION REGISTERS, and possibly "ID-Locations".
  //  ( after CODE + DATA, since this may already set the CP bits in PIC18F + dsPIC30F.
  //    For 14-bit core, this does NOT include the "classic config word", see below )
  // Note: For most(?) chips, the CONFIGURATION memory can be programmed without prior erase.
  if(  (PIC_DeviceInfo.wCodeProgAlgo!=PIC_ALGO_PIC10F) // for PIC10F20x, everything is in "ProgramAll" !
    && (PIC_DeviceInfo.wCodeProgAlgo!=PIC_ALGO_PIC16F7X) // ... similar for PIC16F74 ("ProgramAll")
    )
   {
     if(  (Config.iProgramWhat & PIC_PROGRAM_CONFIG)
       && (PicBuf[PIC_BUF_CONFIG].i32LastUsedArrayIndex >= 0 )
       )
      {
        int iNrWordsWriteable = PicPrg_GetNrOfConfigMemLocationsToWrite();
        fDidSomething |= (iNrWordsWriteable>0);
        i32FirstAddress = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_CONFIG, 0 );
        i32LastAddress  = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_CONFIG, iNrWordsWriteable-1 );
        sprintf( sz80Temp, "%s %s, 0x%06lX..0x%06lX",
                (char*)TE("Programming"), (char*)TE("CONFIG"),
                (long)i32FirstAddress, (long)i32LastAddress );
        APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
        if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );
        if( ! PicPrg_WriteConfigRegs( // Note: doesn't necessarily verify !
                       PIC_DeviceInfo.lConfMemBase, // DWORD dwDestAddress
                    PicBuf[PIC_BUF_CONFIG].pdwData, // DWORD *pdwSourceData
                               iNrWordsWriteable) ) // DWORD dwNrOfRegisters
         { ++error_count;
           m_iMessagePanelUsage = MP_USAGE_WARNING;
         }

        if( !PicPrg_iConfMemVerified )  // WriteConfigRegs() didn't verify yet:
         { // config memory not verified yet -> do that now :
           sprintf( sz80Temp, "%s %s, 0x%06lX..0x%06lX",
                    (char*)TE("Verifying"), (char*)TE("CONFIG"),
                    (long)i32FirstAddress, (long)i32LastAddress );
           APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
           if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );

           if( ! PicPrg_Verify(   // Verify CONFIG MEMORY (including config word)
                 PIC_DeviceInfo.lConfMemBase,    // dwDeviceAddress
                 PicBuf[PIC_BUF_CONFIG].pdwData, // DWORD *pdwSourceData
                 iNrWordsWriteable , // number of registers be verified
                             0x3FFF, // bitmask for verification (14-bit-core only)
                 PIC_DeviceInfo.iCmd_ReadProg)) // 'read' command pattern (only for 14-bit-core)
            { ++error_count;
            }
         } // end if < config memory not verified yet >

      } // end if <option to program CODE memory> and <CONFIG memory present>
     else  // why not program configuration memory ?
      {
        if(  (Config.iProgramWhat & PIC_PROGRAM_CONFIG)
          && (PicBuf[PIC_BUF_CONFIG].i32LastUsedArrayIndex < 0 ) )
         {  // Suspicious: shall programm CONFIG memory (as usual),
            // but there is no entry in the CONFIG memory buffer  ?
            // Too bad for older chips where we have already "erased everything".
            // No problem for newer chips which do NOT erase configuration memory,
            //   not even when performing "bulk erase" (for example dsPIC30F) .
            APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
              TE("Suspicious: Buffer contains no data for the CONFIGURATION BITS.") );
         }
      }
   } // end if < not PIC10F20x >


  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // Fifth, VERY optional step, for 14-bit core only(*): program the CLASSIC CONFIG-WORD
  //    (code protection, watchdog, oscillator, bandgap calibration bits)
  if(  ( PIC_DeviceInfo.iBitsPerInstruction==14 )
    && ( ! PicPrg_iConfWordProgrammed )
    && (PIC_DeviceInfo.wCodeProgAlgo!=PIC_ALGO_PIC10F) // for PIC10F20x, already done in "ProgramAll"
    && (PIC_DeviceInfo.wCodeProgAlgo!=PIC_ALGO_PIC16F7X) // ... similar for PIC16F74 (all in "ProgramAll")
    )
   {
     // This must be done AFTER programming CODE and/or DATA because otherwise
     // verification during programming would be impossible with the CP bits set.
     //
     // For some 14-bit devices without "bandgap calibration", this may be
     // unnecessary if the "config word" has already been programmed as part
     // of step 4 ( "CONFIGURATION REGISTERS" ) .
     //
     // (*) 14-bit core only, because for PIC18F and dsPIC30F there is no
     //     "classic config word" with the code protection bits.
     //     Instead, these bits are spread all over the configuration MEMORY,
     //     so this fifth step is unnecessary.
     //     For some 14-bit devices, the "configuration memory"
     //     ( programmed in the previous step ) did NOT include the CP bits yet,
     //     because that way the "code memory" could not be verified !
     //
     if(  (PicPrg_iConfWordProgrammed==0)
       && ( Config.iProgramWhat & PIC_PROGRAM_CONFIG)!=0 )   // May I ... ?
      {
          sprintf( sz80Temp, "%s %s", TE("Programming"), TE("CONFIG-WORD") );
          APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
          if(ToolForm) ToolForm->ShowMsg( sz80Temp, TWMSG_NO_ERROR );

          if(Config.iVerboseMessages)
           { sprintf(sz80Temp, TE("Config word = 0x%06lX; Config mask = 0x%06lX"),
                              (long)PicBuf_GetConfigWord(0) ,
                              (long)PicPrg_GetConfigWordMask() );
             APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz80Temp );
           }
          dwTemp4[0] = PicBuf_GetConfigWord(0);
          dwTemp4[1] = PicBuf_GetConfigWord(1);
          fDidSomething = TRUE;
          if(!PIC_PRG_Program( dwTemp4, // program config word(s) :
                 1 + // number of words to be programmed ...
                 ((PIC_DeviceInfo.wCfgmask2_used==0x0000)?0:1),  // 2nd cfg word ?
               PicPrg_GetConfigWordMask(),   // mask for programming and verification (ex:0x3FFF) :
               PIC_DeviceInfo.iCmd_LoadProg, // 'load' command pattern
               PIC_DeviceInfo.iCmd_ReadProg, // 'read' command pattern (for verifying)
               PIC_DeviceInfo.lConfWordAdr)) // target start address
            { ++error_count;
            }

      } // end if (Config.iProgramWhat&PIC_PROGRAM_CONFIG) ..
   } // end if < "classic config word" for 12- or 14- bit PIC devices only >


  if(APPL_iUserBreakFlag)
   {
     APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("USER BREAK while programming.") );
     m_iMessagePanelUsage = MP_USAGE_WARNING;
     if(ToolForm) ToolForm->ShowMsg( TE("USER BREAK"), TWMSG_NO_ERROR );
     APPL_iUserBreakFlag = 0;
     fResult = FALSE;
   }
  else // no 'user break' during PROGRAM
   {
    if(error_count==0)
     {
      PIC_iHaveErasedCalibration = 0;   // some calibration value are back where they belong
      if(fDidSomething)
       { pszMsg = TE("Programming finished, no errors.");
         if(ToolForm) ToolForm->ShowMsg( TE("Programming OK"), TWMSG_SUCCESS );
       }
      else
       { pszMsg = TE("Programming finished, nothing to do.");
         if(ToolForm) ToolForm->ShowMsg( pszMsg, TWMSG_NO_ERROR );
       }
      APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, pszMsg );
      m_iMessagePanelUsage = MP_USAGE_INFO;
     }
    else
     { pszMsg = TE("ERROR: Programming FAILED !");
      APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, pszMsg  );
      if(ToolForm) ToolForm->ShowMsg( TE("Programming error !") , TWMSG_ERROR   );
      Update();
      m_iMessagePanelUsage = MP_USAGE_ERROR;
                        // highlight good or bad CODE LOCATIONS ?
     }
    fResult = (error_count==0);
   }


  if(Config.iDisconnectAfterProg)
     DisconnectTarget();  // since 2002-09-26 . Suggested by Johan Bodin.

  UpdateAllSheets(); // and make the changes visible on the screen

  WinPic_UpdateLedsForResult( fResult );

  return fResult;
} // end TPicMain::ProgramPic()
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::VerifyPic(void)
{  // compares the buffer contents against the PIC's different memories.
 int error_count = 0;
 BOOL fVerifyAtDifferentVoltages;
 BOOL fVoltageSwitchSupported;
 int iSupplyVoltageLoop;
 int iSupplyVoltageLevel; // 0=low supply voltage, 1=normal, 2=high voltage
 BOOL fDidSomething = FALSE;
 char *pszMsg;
 DWORD dwTemp4[4];
 long i32FirstAddress, i32LastAddress;


   APPL_iUserBreakFlag = 0;
   PicPrg_iCodeMemVerified = PicPrg_iDataMemVerified = 0;  // force verify
   PicPrg_iConfMemVerified = PicPrg_iConfWordVerified= 0;  // force verify

   fVerifyAtDifferentVoltages = FALSE;
   if(Config.iVerifyAtDifferentVoltages)
    { if(PIC_HW_CanSelectVdd() )
        fVerifyAtDifferentVoltages = TRUE;
      else
        APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
            TE("Cannot verify at different voltages with this hardware.") );
    }

   WinPic_RedAndGreenLedOff();
   if( ! PicHw_iConnectedToTarget )
    { PIC_HW_ConnectToTarget();    // here (in TPicMain::VerifyPic) since 2005-12-17
    }

   if(ToolForm) ToolForm->ShowMsg( TE("Verifying..."), TWMSG_NO_ERROR );

   for(iSupplyVoltageLoop = 0;
       iSupplyVoltageLoop < ( fVerifyAtDifferentVoltages ? 3 : 1 );
     ++iSupplyVoltageLoop)
    {

      switch(iSupplyVoltageLoop)
       {
         default:
         case 0: iSupplyVoltageLevel = 1; // first check at NOMINAL voltage ...
                 if(fVerifyAtDifferentVoltages)
                    pszMsg = "Verifying at nominal supply voltage...";
                 else
                    pszMsg = "Verifying...";
                 break;
         case 1: iSupplyVoltageLevel = 0; // ... then check at LOW voltage ...
                 pszMsg = "Verifying at low supply voltage...";
                 break;
         case 2: iSupplyVoltageLevel = 2; // ... and finally check at HIGH voltage
                 pszMsg = "Verifying at high supply voltage...";
                 break;
       }
      // Select supply voltage for verify mode .
      // Since 2005-09-25, this routine is also used to check if the interface
      //       supports verify at a certain supply voltage at all.
      //       If PIC_HW_SelectVdd() returns FALSE, the function may have failed
      //             or the interface may not support this voltage-switch at all.
      fVoltageSwitchSupported = PIC_HW_SelectVdd(iSupplyVoltageLevel);
      if( iSupplyVoltageLoop==0 || fVoltageSwitchSupported )
       {  // verify at this voltage if "nominal" voltage of "switching supported" :

         APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE(pszMsg) );

         UpdateInterfaceTestDisplay();  // show the "should-be" state of the control lines

         if( PIC_DeviceInfo.iBitsPerInstruction==12 )
          { fDidSomething = TRUE;       // 12-bit core must be PIC10F20x (nothing else)
            if( ! PIC10F_ReadAll( PIC_ACTION_VERIFY ) )
             {  ++error_count;
             }
          }
         else // not 12-bit core ...
          {
            // verify CODE ?
            if( Config.iProgramWhat & PIC_PROGRAM_CODE )
             {
              if( PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex >= 0 )
               { fDidSomething = TRUE;
                 i32FirstAddress = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_CODE, 0 );
                 i32LastAddress  = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_CODE, PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex);
                 APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, "%s %s, 0x%06lX..0x%06lX",
                          (char*)TE("Verifying"), (char*)TE("CODE"),
                           (long)i32FirstAddress, (long)i32LastAddress );
                 if (! PicPrg_Verify( 0 ,  // // dwDeviceAddress
                     PicBuf[PIC_BUF_CODE].pdwData, // DWORD *pdwSourceData
                     PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex+1, // number of words to be verified
                     0x3FFF,
                     PIC_DeviceInfo.iCmd_ReadProg) )
                  { ++error_count;
                  }
               }
              else // no program in memory !
               {
                APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("No PROGRAM CODE in buffer to verify.") );
                m_iMessagePanelUsage = MP_USAGE_WARNING;
               }
             } // end if < shall verify CODE >


            // verify DATA EEPROM ?
            if( Config.iProgramWhat & PIC_PROGRAM_DATA )
             {
              if ( PicBuf[PIC_BUF_DATA].i32LastUsedArrayIndex >= 0 )
               { fDidSomething = TRUE;
                 i32FirstAddress = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_DATA, 0 );
                 i32LastAddress  = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_DATA, PicBuf[PIC_BUF_DATA].i32LastUsedArrayIndex );
                 APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, "%s %s, 0x%06lX..0x%06lX",
                          (char*)TE("Verifying"), (char*)TE("DATA"),
                           (long)i32FirstAddress, (long)i32LastAddress );
                 if(!PicPrg_Verify( PIC_DeviceInfo.lDataMemBase,
                       PicBuf[PIC_BUF_DATA].pdwData,
                       PicBuf[PIC_BUF_DATA].i32LastUsedArrayIndex+1,
                       0xFF,PIC_DeviceInfo.iCmd_ReadDataDM ) )
                    ++error_count;
               }
              else // no DATA in memory...
               {
                APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("No DATA MEMORY in buffer to verify.") );
                m_iMessagePanelUsage = MP_USAGE_WARNING;
               } // end if ( PicBuf[PIC_BUF_DATA].i32LastUsedArrayIndex >= 0 )
             } // end if < shall verify DATA >


            // Verify CONFIGURATION MEMORY and/or "ID locations" ?
            if( Config.iProgramWhat & PIC_PROGRAM_CONFIG )
             {
              if ( PicBuf[PIC_BUF_CONFIG].i32LastUsedArrayIndex >= 0 )
               { fDidSomething = TRUE;
                 int iNrWordsWritten = PicPrg_GetNrOfConfigMemLocationsToWrite();
                 i32FirstAddress = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_CONFIG, 0 );
                 i32LastAddress  = PicBuf_ArrayIndexToTargetAddress(PIC_BUF_CONFIG, iNrWordsWritten-1 );
                 APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, "%s %s, 0x%06lX..0x%06lX",
                       (char*)TE("Verifying"), (char*)TE("CONFIG"),
                       (long)i32FirstAddress, (long)i32LastAddress );
                 if(!PicPrg_Verify( PIC_DeviceInfo.lConfMemBase,
                     PicBuf[PIC_BUF_CONFIG].pdwData, // source buffer
                     iNrWordsWritten,                // count of WORDs to be verified
                     0x3FFF,  // mask for a 14-bit word (ignored for dsPIC etc)
                     PIC_DeviceInfo.iCmd_ReadProg))  // command pattern to READ (usually 0x04)
                   { ++error_count;
                   }
                 else // verification of config memory "ok":
                   {
                     PicPrg_iConfMemVerified = 1;  // "classic" config word has been VERIFIED OK now
                   }
               } // end if < verify configuration memory ? >


              // Verify "classic" CONFIG-WORD (code protection, watchdog, oscillator) ?
              if(   ( PIC_DeviceInfo.iBitsPerInstruction==14 )  // only for PIC16Fxxx..
                 && ( ! PicPrg_iConfWordVerified ) // often included in 'Verify Config/ID-Memory" (above)
                 && ( PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex >= 0 ) )
               { fDidSomething = TRUE;
                 APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, " %s CONFIG-WORD%c",
                   TE("Verifying"), (char)((PIC_DeviceInfo.wCfgmask2_used!=0) ? 's' : ' ') );
                 dwTemp4[0] = PicBuf_GetConfigWord(0);
                 dwTemp4[1] = PicBuf_GetConfigWord(1);
                 if(!PicPrg_Verify( PIC_DeviceInfo.lConfWordAdr,
                     dwTemp4, // DWORD *buf
                     1 + // number of words to be verified ...
                   ((PIC_DeviceInfo.wCfgmask2_used==0x0000)?0:1),  // 2nd cfg word ?
                   PicPrg_GetConfigWordMask(), // mask to be verified for FIRST (!) config word
                   PIC_DeviceInfo.iCmd_ReadProg))  // command pattern to READ
                  { ++error_count;
                  }
               } // end if ( PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex >= 0 )
             } // end if < shall verify CONFIG and/or "ID locations" >
          } // end else < no 12-bit core >
       } // end if < nominal supply voltage, or  switch to "special" voltage supported >

      // No other verify-attempts at other voltages if this one failed:
      if( error_count > 1/*!*/ )
         break;
      if(!fDidSomething)
         break;
    } // end    for(iSupplyVoltageLoop = 0; ...

  if( PIC_HW_CanSelectVdd() )
   { PIC_HW_SelectVdd( Config.iIdleSupplyVoltage );  // back to the "normal" voltage
   }

  if(APPL_iUserBreakFlag)
   {
     APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE("USER BREAK while verifying.") );
     m_iMessagePanelUsage = MP_USAGE_WARNING;
     APPL_iUserBreakFlag = 0;
     error_count = 1;
   }
  else // no 'user break' during PROGRAM
   {
    if(error_count==0)
     { if(fDidSomething)
            pszMsg = TE("Verify finished, no errors.");
       else pszMsg = TE("Nothing to verify in buffer.");
       APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, pszMsg );
       if(ToolForm) ToolForm->ShowMsg( pszMsg, TWMSG_SUCCESS );
       m_iMessagePanelUsage = MP_USAGE_INFO;
     }
    else
     { pszMsg = TE("ERROR: Verifying FAILED !");
       APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, pszMsg );
       if(ToolForm) ToolForm->ShowMsg( pszMsg, TWMSG_ERROR );
       m_iMessagePanelUsage = MP_USAGE_ERROR;
     }
   }
  UpdateAllSheets(); // highlight good or bad CODE LOCATIONS
  UpdateInterfaceTestDisplay();

  WinPic_UpdateLedsForResult( error_count==0 );
  return error_count==0;
} // end TPicMain::VerifyPic()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::RunHexOpenDialog(void)
{
  /* see help on TOpenDialog - beware: Win XP saves a history in the registry (HOLY SHIT) */
  OpenDialog->Title      = TE("Load Hex File");
  OpenDialog->DefaultExt = "hex";
  OpenDialog->Filter     = "HEX files (INHX8M, *.hex)|*.hex";
  OpenDialog->FileName   = ExtractFileName(Config.sz255HexFileName);
  if( FileExists(Config.sz255HexFileName) )
        OpenDialog->InitialDir = ExtractFilePath(Config.sz255HexFileName);
   else OpenDialog->InitialDir = "";
  OpenDialog->HistoryList->Clear();
  OpenDialog->Options.Clear();
  // don't use the option "ofFileMustExist" - the open dialog won't open sometimes !!
  OpenDialog->Options // << ofFileMustExist
                      // << ofOldStyleDialog
                         << ofHideReadOnly
                         << ofNoChangeDir;
  if( OpenDialog->Execute() )
   {
    strcpy( Config.sz255HexFileName, OpenDialog->FileName.c_str() );
    UpdateToolWindow();
    Config_changed |= APPL_CALLER_SAVE_CFG;
    return TRUE;
   }
  return FALSE;
} // end RunHexOpenDialog()


//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::LoadFileAndProgramPic(char *fn, BOOL program_too)
{
 FILE *fp;
 BOOL ok;
 char sz255Temp[256];
 char *cp;

  WinPic_RedAndGreenLedOff();
  if(ToolForm) ToolForm->ShowMsg( TE("Loading..."),  TWMSG_NO_ERROR );

  if ( (fp = fopen(fn,"r")) == NULL )
   {
       sprintf(sz255Temp, TE("Can't open hexfile \"%s\"") , fn);
       APPL_ShowMsg(APPL_CALLER_MAIN,0, sz255Temp );
       if(ToolForm) ToolForm->ShowMsg( sz255Temp, TWMSG_ERROR );
       return false;
   }
  else
   {
       fclose(fp);
   }

  AddMRFname( AnsiString(fn) );  // add this file to the list of 'recent files'

  /* Initialize buffers to remove old junk from program & data eeprom ? */
  if(Config.iClearBufBeforeLoad)
   { PIC_HEX_ClearBuffers();
   }

  ok  = ( PIC_HEX_LoadFile(fn)==0);  // 0 here means "NO error"
  REd_CodeMem->Modified = FALSE;
  REd_DataMem->Modified = FALSE;

  if(Config.iVerboseMessages)
   { sprintf(sz255Temp,
      TE("Results from LoadHex: LastProgAdr=0x%06lX LastDataAdr=0x%06lX"),
          (long)PicBuf_ArrayIndexToTargetAddress(PIC_BUF_CODE, PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex),
          (long)PicBuf_ArrayIndexToTargetAddress(PIC_BUF_DATA, PicBuf[PIC_BUF_DATA].i32LastUsedArrayIndex)
            );
     cp = sz255Temp + strlen(sz255Temp);
     sprintf( cp, " (%s)", fn );    // added 2006-03-26
     APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz255Temp );
   }
  if(WinPic_i32CmdLineOption_OverrideConfigWord>=0)
   { // replace the CONFIGURATION WORD which should have been in the config file ?
     if( (WORD)PicBuf_GetConfigWord(0) != (WORD)WinPic_i32CmdLineOption_OverrideConfigWord)
      {
       APPL_ShowMsg( APPL_CALLER_PIC_PRG,0,
         TE("Info: Config word set to 0x%06lX from command line .") ,
          (long)WinPic_i32CmdLineOption_OverrideConfigWord);
      }
     PicBuf_SetConfigWord( 0, WinPic_i32CmdLineOption_OverrideConfigWord );
   } // end if < override configuration word > ?

  UpdateAllSheets(); // make the changes visible on the screen

  if (!ok)
   {
    if(program_too)
     {
       strcpy(sz255Temp, TE("Aborting LoadAndProgram because of error(s)") );
       APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, sz255Temp );
       if(ToolForm) ToolForm->ShowMsg( sz255Temp, TWMSG_ERROR );
     }
    return false;
   }

  if ( ! program_too )
   { if(ToolForm) UpdateToolWindow(); // show current filename again
     return true;    // ready at this step (do not program)
   }

  // now try to program all loaded elements into the PIC:
  return ProgramPic();
} // end LoadFileAndProgramPic()
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::DumpEverythingToHexFile(char *fn)
{

    if( WinPic_fCommandLineOption_QueryBeforeOverwritingFiles )
     {
      if( FileExists(fn) )
       {
         if(MessageBox(  Handle, // handle of owner window
           TE("Dump would overwrite existing file.\n  Erase old file ?"),
           TE("Confirm overwrite"),
           MB_ICONQUESTION | MB_YESNOCANCEL | MB_DEFBUTTON2 ) != IDYES )
          {
            WinPic_UpdateLedsForResult( false );
            return false;
          }
       }
     }

    if( PIC_HEX_DumpHexFile(fn) <= 0 )  // dump all buffers which contain "something"
     {
       APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
          TE("Can't create hexfile") );
       m_iMessagePanelUsage = MP_USAGE_WARNING;
       WinPic_UpdateLedsForResult( false );
       return false;
     }

    WinPic_UpdateLedsForResult( true );
    return true;

} // end DumpEverythingToHexFile( :o)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::StopParsingCmdLine_Internal(void)
{
   WinPic_fCommandLineMode = FALSE;  // error, stop parsing command line
   AnsiString s = PicMain->Pnl_Message->Caption +
                  TE(".. stopped parsing cmd-line") ;
   PicMain->Pnl_Message->Caption = s;
   m_iMessagePanelUsage = MP_USAGE_ERROR;
} // end StopParsingCmdLine_Internal()

//---------------------------------------------------------------------------
void __fastcall TPicMain::LoadSmallPort(void)
{
  AnsiString s;

  Pnl_Message->Caption = TE("Loading port driver");
  Update();

  s = Application->ExeName; // Contains the file name of the applications executable file including path information.
  s = ExtractFilePath(s);  // with some luck, we now have the DIRECTORY of the executable file
                           // (this is not NECESSARILY the "current" directory !)
                           // The "smport.sys" driver may be in this directory..
  if(! SmallPort.OpenDriver( Config.iWhichPortAccessDriver, s.c_str()/*szOneMorePathToDriver*/   ) )
   { // Could not open the SMPORT.VXD / SMPORT.SYS driver ...
     Mem_Messages->Lines->Add("Port Access Error: "
              + AnsiString(SmallPort.GetLastErrorString() )
              + ", code "+IntToStr(SmallPort.GetLastError() )
                              );
     MessageBox( Handle,
           SmallPort.GetLastErrorString() ,
           "Error - WinPic could not open the port access driver",
          MB_ICONEXCLAMATION | MB_OK );
   }
  else
   {
     if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      { APPL_LogEvent( "Port access driver opened" );
      }
   }

} // end LoadSmallPort()



//---------------------------------------------------------------------------
void __fastcall TPicMain::Timer1Timer(TObject *Sender)
{ // OnTimer - method of the main form. Called every 50ms.
  static int siCmdTickCount = 0;  // unit: TIMER TICKS a 50ms
  static int siAlreadyHere = 0;
  static int siLptFooledCount = 0;
  static int siFirstCall=1;
  static int siPrescalerFor200ms = 0;
  char sz255Temp[256];
  char sz255Msg[256];
  AnsiString s;
  T_PicDeviceInfo MyDeviceInfo;
  int i;

  ++siCmdTickCount;

  if(siAlreadyHere)
     return;

  if( WinPic_fCloseImmediately )
   { Close();
     return;
   }

  ++siAlreadyHere;

  if( (!siFirstCall) && PicHw_fTogglingTxD )
   {  PicHw_FeedChargePump();  // required to produce Vpp with a charge pump (JDM)
   }


  ++siPrescalerFor200ms;
  if(siPrescalerFor200ms>=3)
   { siPrescalerFor200ms=0;    // gets here every 200 milliseconds ...

    if(siFirstCall)
     { siFirstCall = 0;


      // Initialize the port access driver (SmallPort) if it shall be used:
      PicHw_fUseSmallPort = (Config.iWhichPortAccessDriver!=CFG_PORTACCESS_USE_API_ONLY);
      if( PicHw_fUseSmallPort )
       { LoadSmallPort();
       }

      if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
       { APPL_LogEvent( "Initialising programmer hardware" );
       }

      // Initialize the PIC-programming routines (after setting the user's language!)
      PicHw_sz255LastError[0] = 0;
      if(!PIC_HW_Init() )  // Initialize PIC programmer interface (HW = HardWare)
       { Mem_Messages->Lines->Add("Error in PIC_HW_Init: "
                      +AnsiString(PicHw_sz255LastError) );
       }
      else
      if(PicHw_sz255LastError[0])
       { Mem_Messages->Lines->Add("Warning in PIC_HW_Init: "
                      +AnsiString(PicHw_sz255LastError) );
       }

      // Check interface + delay routine ONCE (after setting the user's language!)
      if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
       { APPL_LogEvent( "Init: Testing the interface" );
       }

      TestTheInterface();  // try to find out if the interface is there
      TestDelayRoutine();  // check the programmer's DELAY routine
      if( SmallPort.AccessFailed() ) // tell the application if an access failed
       { APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
          TE("I/O-port access failed. Try a different access driver (SMPORT or PortTalk) !") );
         Grp_IOPortAccess->Color  = clRed;
         PageControl1->ActivePage = TS_Options;
       }

      YHF_UpdateLanguageCombo( CB_Language );  // searches for all translation files, and fills language list
      YHF_TranslateAllForms();   // originally tried this in FormCreate() but didn't work properly
      if( YHF_iLanguageTestMode )
       { TE("end of table");  // must be found at the end of the translation table, otherwise corrupted
       }
      if(ToolForm)
       { ToolForm->Left = ToolWin_iX1;
         ToolForm->Top  = ToolWin_iY1;
         if(ToolWin_iVisible)
          { ToolForm->Show();
            SetFocus();  // focus back to main window !
          }
         UpdateToolWindow(); // must not call this in the main form's FormCreate method, so call it here !
       }
      // Fill the "Part"-combo list. This was formerly done
      //  in UpdateDeviceConfigTab(), but as the device list grew the routine
      //  got very slow (most likely due to the usage of an INI file ).
      Combo_PartName->Items->Clear();
      Combo_PartName->ItemIndex = i = 0;
      while( PicDev_GetDeviceInfoByIndex( i, &MyDeviceInfo ) >= 0 )
       { Combo_PartName->Items->Append(MyDeviceInfo.sz40DeviceName);
         ++i;
       }

      // Now update CODE + DATA memory display, and all the rest..
      UpdateAllSheets();
     } // end if <first call>

    // Parse the next arguments from the command line, if not finished yet.
    //     Most likely, this will be an instruction to LOAD a file
    //     which will be programmed into the device later, etc.
    // There will DELIBERATELY be a certain delay between executing all args.
    if( WinPic_fCommandLineMode || WinPic_fCommandLineOption_Load )
     {
      int iSecToGo = WinPic_fCommandLineMode ? 20 : 5; // Unit: "timer ticks" a 50 ms
      iSecToGo = (long)(iSecToGo - siCmdTickCount) * 200L / 1000L;
      if( !(WinPic_fCommandLineOption_NoDelay) && (iSecToGo>0) )
       { char sz80Actions[81];
         sz80Actions[0]=0;
         if( WinPic_fCommandLineOption_Read )
             strcat(sz80Actions,"READ+");
         if( WinPic_fCommandLineOption_Erase )
             strcat(sz80Actions,"ERASE+");
         if( WinPic_fCommandLineOption_Load )
             strcat(sz80Actions,"LOAD+");
         if( WinPic_fCommandLineOption_Program )
             strcat(sz80Actions,"PROGRAM+");
         if( WinPic_fCommandLineOption_Verify)
             strcat(sz80Actions,"VERIFY+");
         if( WinPic_fCommandLineOption_Quit )
             strcat(sz80Actions,"QUIT");
         i = strlen(sz80Actions);
         if(i>1 && sz80Actions[i-1]=='+')
           sz80Actions[i-1] = '\0';
         sprintf(sz255Msg,
             TE("Command execution (%s) continues in %d seconds ... ESC to stop") ,
             (char*)sz80Actions, (int)iSecToGo );
         PicMain->Pnl_Message->Caption = sz255Msg;
         m_iMessagePanelUsage = MP_USAGE_COMMAND_TIMER;
       }
      else // Time to start the EXECUTION of all actions specified in the command line.
       {   // Arrived here, the command line has been PARSED but not EXECUTED yet.
           // All actions must be performed in a quite senseful sequence ...
         if( WinPic_fCommandLineOption_Read )
          { // read the PIC device and dump the result into a HEX file.
            // This is done BEFORE the device is (optionally) erased !
            if(! ReadPicAndDumpToFile( Config.sz255HexFileName ) )
             { siCmdTickCount = 0;
               WinPic_fCommandLineOption_NoDelay = FALSE;  // slow down !
             }
            WinPic_fCommandLineOption_Read = FALSE; // done.
          } // end if( WinPic_fCommandLineOption_Read )
         else
         if( WinPic_fCommandLineOption_Erase )
          { // (bulk-)Erase the PIC device :
            Pnl_Message->Caption = TE("Erasing ..."); // used in various places
            Update();
            if( PIC_PRG_Erase( PIC_ERASE_ALL | PIC_SAVE_CALIBRATION) )  // here in command-line mode
             {
              if( PIC_iHaveErasedCalibration
                  && ((PIC_DeviceInfo.wCfgmask_bandgap != 0) || (PIC_DeviceInfo.lAddressOscCal >= 0)) )
               {
               APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
                  TE("Device has been erased. PROGRAM TO RESTORE CALIB BITS !!") ); // used more than once !
               m_iMessagePanelUsage = MP_USAGE_WARNING;
               }
              else
               {
                 APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
                  TE("Device has been erased.") );  // used more than once !
                 m_iMessagePanelUsage = MP_USAGE_INFO;
               }
             }
            else
              APPL_ShowMsg( APPL_CALLER_MAIN, 0,
                  TE("Erasing FAILED !") );

            WinPic_fCommandLineOption_Erase = FALSE; // done.
          } // end if( WinPic_fCommandLineOption_Erase )
         else
         if( WinPic_fCommandLineOption_Load )
          { // Load a HEX file into memory  but do NOT program it yet :
           if(! LoadFileAndProgramPic( Config.sz255HexFileName, false/*load+prog*/ ) )
            { StopParsingCmdLine_Internal();
            }
           else
            {
              APPL_ShowMsg( APPL_CALLER_PIC_PRG,0,
               TE("Loaded file \"%s\" through command line ."), Config.sz255HexFileName );
            }
           WinPic_fCommandLineOption_Load = FALSE; // done.
          } // end if( WinPic_fCommandLineOption_Load )
         else
         if( WinPic_fCommandLineOption_Program )
          { // Load a HEX file into memory  *AND*  program the PIC device :
           if(! LoadFileAndProgramPic( Config.sz255HexFileName, true/*load+prog*/ ) )
            { StopParsingCmdLine_Internal();
            }
           WinPic_fCommandLineOption_Program = FALSE; // done.
          } // end if( WinPic_fCommandLineOption_Program )
         else
         if( WinPic_fCommandLineOption_Verify )
          { // extra VERIFY after programming
           if(! VerifyPic() )
            { StopParsingCmdLine_Internal(); // error -> stop parsing command line
            }
           WinPic_fCommandLineOption_Verify = FALSE; // done.
          } // end if( WinPic_fCommandLineOption_Verify )
         else
         if( WinPic_fCommandLineOption_Quit )
          { // Quit after execution of command line :
            if( WinPic_i200msToQuit>0 ) // wait a little longer before "quitting" ?
             { --WinPic_i200msToQuit;
               sprintf(sz255Msg, TE("Quitting in %d seconds ... ESC to stop"),
                                    (int)WinPic_i200msToQuit / 5 );
               PicMain->Pnl_Message->Caption = sz255Msg;
               m_iMessagePanelUsage = MP_USAGE_COMMAND_TIMER;
             }
            else
             { if( WinPic_OkToCloseDueToErasedCalibration() ) // possibly ask the user!
                {
                  PIC_iHaveErasedCalibration = FALSE;  // don't ask again if "ok to close"..
                  Close();
                }
               WinPic_fCommandLineOption_Quit = FALSE; // done (??)
             }
          } // end if( WinPic_fCommandLineOption_Quit )
         else
          { // seems all command line options are through.
            // If not "quit", return to normal operation (not command-line driven)

          }
       } // end if <time to parse the next command line argument>
     } // end if <more command line arguments to parse>
    else  // all command line arguments are through (if any)
     {
      if( m_iMessagePanelUsage == MP_USAGE_COMMAND_TIMER)
        {
          PicMain->Pnl_Message->Caption = TE("Command line finished");
          m_iMessagePanelUsage = MP_USAGE_NOTHING;
        }
     }

    // Perform a few "tests" (launched from the "Debugging" panel)
    switch(WinPic_iTestMode)
     {
      case 1 :    // endlessly send a "programming cycle" to the PIC
        PIC_HW_SetClockAndData(FALSE,FALSE);  // taken from ProgMode() ...
        PIC_HW_SetVpp( TRUE  );
        PIC_HW_Delay_us(100  );
        PIC_HW_SetVpp( FALSE );
        PIC_HW_Delay_us(100);
        PIC_HW_SetVpp(TRUE   );              // ... end of ProgMode(), fast rise on Vpp !
        PIC_HW_Delay_us(100);

        PIC_PRG_Flash14ProgCycle( 0x02, // send "load command" to PIC, and data:
                   0x2AAA);  // SerialOut(w) + Begin Programming + Wait Tprog
        break;

      case WP_TEST_MODE_GUI_SPEED:      // extended debug display for the USER INTERFACE
        break;

      default:
        WinPic_iTestMode = 0;   // cancel all unknown "test modes"
        break;

     } // end switch(WinPic_iTestMode)

    // Turn the progress bar off if there is no more activity.
    // (ugly but easy, don't have to care for turning it off elsewhere !)
    if (m_progress_visible)
     {
      if (m_progress_activity_timer>0)
        --m_progress_activity_timer;
      if (m_progress_activity_timer<=0)
       {
        ProgressBar1->Visible = false;
        if(ToolForm)
           ToolForm->ProgressBar1->Visible = false;
        m_progress_visible    = false;
       }
     }

    UpdateInterfaceInputSignalDisplay();

    if( m_update_code_mem_display )
     {
       m_update_code_mem_display = false;
       UpdateCodeMemDisplay();
     }

    if( m_update_data_mem_display )
     {
       m_update_data_mem_display = false;
       UpdateDataMemDisplay();
     }

    if( m_update_id_and_config_display && (PageControl1->ActivePage==TS_CfgMemTab) )
     { m_update_id_and_config_display = false;
       UpdateIdAndConfMemDisplay();
     }

    /* if Interface type or port number has been changed: */
    if (m_displayed_interface_type != PIC_HW_interface.type)
     {
      m_displayed_interface_type = PIC_HW_interface.type;
      UpdateInterfaceType(m_displayed_interface_type);
      UpdateInterfaceTestDisplay();
      UpdateOptionsDisplay();
     }

    /* if code protectiong, watchdog, oscillator configuration has changed: */
    if(   ( m_displayed_config_word[0]  != PicBuf_GetConfigWord(0) )
        ||( m_displayed_config_word[1]  != PicBuf_GetConfigWord(1) )
        ||( strncmp(m_sz40DisplayedDeviceName, PIC_DeviceInfo.sz40DeviceName,40)!=0 )
       )
     {
       strncpy(m_sz40DisplayedDeviceName, PIC_DeviceInfo.sz40DeviceName, 40);
       m_displayed_config_word[0] = PicBuf_GetConfigWord(0);
       m_displayed_config_word[1] = PicBuf_GetConfigWord(1);
       UpdateDeviceConfigTab( TRUE/*update HEX display also*/ );   // << here in TIMER METHOD !
       UpdateInterfaceTestDisplay();
     }

    // If used, let the DLL-based hardware-interface-plugin update its own GUI:
    PicHw_LetInterfaceDLLDoGraphicStuff();

    // State machine for BATCH PROGRAMMING...
    switch( PIC_PRG_iBatchProgState )
     {
       case BATCH_PROG_OFF:  // nothing to do FOR THE PROGRAMMING BATCH, but ...
          // Maybe a button in the 'tool window' has been clicked :
          if( ToolWin_fReloadAndProgClicked )
           {  ToolWin_fReloadAndProgClicked = FALSE;
            LoadFileAndProgramPic( Config.sz255HexFileName, true );
            UpdateInterfaceTestDisplay();
           }
          break; // end case < no BATCH PROGRAMMING mode >

       case BATCH_PROG_PREP_START:
          APPL_ShowMsg(APPL_CALLER_MAIN,0,
           TE("BATCH PROG: Insert device or connect ICSP, then press Enter or OK !") );
          PIC_PRG_iBatchProgState = BATCH_PROG_WAIT_START;
          break;

       case BATCH_PROG_WAIT_START:
          // Waiting for user to release "OK"-button on programmer
          //   or press "ENTER" on PC keyboard.
          // Transition to "BATCH_PROG_STARTED" on ENTER key is somewhere else.
          i = PicHw_GetOkButtonState();
          if(i==0)
             PIC_PRG_iBatchProgState = BATCH_PROG_WAIT_START2;
          break;

       case BATCH_PROG_WAIT_START2:
          // Waiting for user to press "OK"-button on programmer
          //   or press "ENTER" on PC keyboard.
          // Transition to "BATCH_PROG_STARTED" on ENTER key is somewhere else.
          i = PicHw_GetOkButtonState();
          if(i==1)
             PIC_PRG_iBatchProgState = BATCH_PROG_STARTED;
          break;

       case BATCH_PROG_STARTED:
          APPL_ShowMsg(APPL_CALLER_MAIN,0,
            TE("BATCH PROG: please wait..") );
          ProgramPic();  // try to program all data which have been loaded before.
          UpdateInterfaceTestDisplay();
          PIC_PRG_iBatchProgState = BATCH_PROG_PREP_START;
          break;

       case BATCH_PROG_TERMINATE:
          PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
          APPL_ShowMsg(APPL_CALLER_MAIN,0,
            TE("BATCH PROG: terminated batch mode.") );
          break;

       default:
          PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
          break;
     } // end switch( PIC_PRG_iBatchProgState )




   } // end if < every 200 milliseconds >

  // Because Windows fools around with the parallel port all the time,
  // try to update the centronics data register.
  //   ( This is VERY VERY CRUDE, but better than nothing ... see FAQ list ! )
  // Note that this "OnTimer" event handler will not be called
  // while the programming algorithm works, because this is NO SEPARATE THREAD !
  if(PicHw_fLptPortOpened)
   {
    if(! PicHw_CheckLptDataBits() )  // debugging stuff ..
     {
      if(siLptFooledCount<10)
       {
        APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
             TE("WARNING ! Windows fooled around with the LPT port bits !") );
        ++siLptFooledCount;
       }
     }
    PicHw_UpdateLptDataBits();  // copy the 'latch' value to the port again
   }



  --siAlreadyHere;

} // end Timer1Timer()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::Load1Click(TObject *Sender)
{
 if(RunHexOpenDialog())
    LoadFileAndProgramPic( Config.sz255HexFileName, false );
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::Menu_LoadAndProgramClick(TObject *Sender)
{
 if(RunHexOpenDialog())
    LoadFileAndProgramPic( Config.sz255HexFileName, true );
 UpdateInterfaceTestDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::MI_ReloadAndProgClick(TObject *Sender)
{
  ToolWin_fReloadAndProgClicked = TRUE;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
AnsiString __fastcall TPicMain::GetMRFname(int iMRFindex)
{
 switch(iMRFindex)
  { case 0: return MI_MRF1->Caption;
    case 1: return MI_MRF2->Caption;
    case 2: return MI_MRF3->Caption;
    case 3: return MI_MRF4->Caption;
    case 4: return MI_MRF5->Caption;
    case 5: return MI_MRF6->Caption;
    default: return "";
  }
} // end GetMRFname()
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::SetMRFname(int iMRFindex, AnsiString s)
{
 switch(iMRFindex)
  { case 0: MI_MRF1->Caption = s;
            MI_MRF1->Visible = (s!="");
            break;
    case 1: MI_MRF2->Caption = s;
            MI_MRF2->Visible = (s!="");
            break;
    case 2: MI_MRF3->Caption = s;
            MI_MRF3->Visible = (s!="");
            break;
    case 3: MI_MRF4->Caption = s;
            MI_MRF4->Visible = (s!="");
            break;
    case 4: MI_MRF5->Caption = s;
            MI_MRF5->Visible = (s!="");
            break;
    case 5: MI_MRF6->Caption = s;
            MI_MRF6->Visible = (s!="");
            break;
    default: break;
  }
} // end SetMRFname()
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::AddMRFname(AnsiString s)
{
  int i;
  for(i=0; i<=5; ++i)
   { if( s == GetMRFname(i) )
       return;    // name is already in the list; no need to add it
   }
  for(i=0; i<=5; ++i)
   { if( GetMRFname(i) == "" )
      { // found a free entry ..
         SetMRFname(i, s);
         return;
      }
   }
  // Arrived here: the list of most recent files is full, and it's a NEW name.
  // Scroll the list, so the oldest file disappears BELOW THE BOTTOM,
  //                  and the new file will be entered AT THE TOP.
  for( i=4; i>=0; --i)
   { SetMRFname(i+1, GetMRFname(i) );
   }
  SetMRFname(0, s);

} // end AddMRFname()
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::LoadMRF(int iMRFindex)
{
 AnsiString s = GetMRFname(iMRFindex);
 if(s != "")
  { strcpy( Config.sz255HexFileName, s.c_str() );
    Config_changed |= APPL_CALLER_SAVE_CFG;
    if( LoadFileAndProgramPic( s.c_str(), false/*load only, don't program*/ ) )
     { // only if there was no "load"-error, show the normal tool-window again
       UpdateToolWindow();
     }
  }
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::MI_MRF1Click(TObject *Sender)
{
  LoadMRF( 0/*index*/ );
}
void __fastcall TPicMain::MI_MRF2Click(TObject *Sender)
{
  LoadMRF( 1/*index*/ );
}
void __fastcall TPicMain::MI_MRF3Click(TObject *Sender)
{
  LoadMRF( 2/*index*/ );
}
void __fastcall TPicMain::MI_MRF4Click(TObject *Sender)
{
  LoadMRF( 3/*index*/ );
}
void __fastcall TPicMain::MI_MRF5Click(TObject *Sender)
{
  LoadMRF( 4/*index*/ );
}
void __fastcall TPicMain::MI_MRF6Click(TObject *Sender)
{
  LoadMRF( 5/*index*/ );
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::MI_ClearMRFsClick(TObject *Sender)
{
  for(int i=0; i<=5; ++i)
    SetMRFname( i, "" );
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::Exit1Click(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::MI_ExitDontSaveClick(TObject *Sender)
{
  m_fMaySaveSettings = FALSE;
  Close();
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateAllSheets(void)
{
  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "Update all tabs: CODE memory .." );
  UpdateCodeMemDisplay();     // show CODE in the hex display
  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "Update all tabs: DATA memory .." );
  UpdateDataMemDisplay();     // show EEPROM DATA  "  "  "
  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "Update all tabs: ID and Config memory dump .." );
  UpdateIdAndConfMemDisplay();  // show ID and CONFIG MEMORY as hex- or bin- dump
  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "Update all tabs: Device/Config tab .." );
  UpdateDeviceConfigTab(TRUE/*fUpdateHexWord*/ );
  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "Update all tabs: Interface display .." );
  UpdateInterfaceTestDisplay(); // show current state of control lines
  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "Update all tabs: Options display .." );
  UpdateOptionsDisplay();
 // No-No:  UpdateToolWindow();   // not possible here, must not call 'too early' !
  Update();  // make the changes visible on the screen
             // 2005-03-05: .. and turned the contents of the TRichEdit into a mess ?!
  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "Update all tabs: DONE ." );
} // end UpdateAllSheets()


//---------------------------------------------------------------------------
void RTF_WriteStringToStream( TMemoryStream * pms, char *pszSrc )
{
  pms->Write( pszSrc, strlen(pszSrc) );
}

//---------------------------------------------------------------------------
void RTF_SkipToEnd( char **cpp )
{
  char *cp=*cpp;
  while(*cp) ++cp;
  *cpp = cp;
}

//---------------------------------------------------------------------------
void RTF_SetColorForMemFlags( char **ppszDest, WORD wMemFlags )
{
  // Bring some colour into the Code Display, using RTF tags :
  //  \\cf16 = "weak" colour for unused locations,
  //  \\cf17 = "strong" colour for used locations,
  //  \\cf18 = "error" colour for bad locations,
  //  \\cf19 = "special" colour to mark the OSCILLATOR CALIBRATION WORD (etc).
  if( wMemFlags & (PIC_BUFFER_FLAG_PRG_ERROR | PIC_BUFFER_FLAG_VFY_ERROR | PIC_BUFFER_FLAG_DEAD ) )
    strcpy( *ppszDest, "\\cf18 " ); // note the important SPACE at the end !
  else if( wMemFlags & (PIC_BUFFER_FLAG_SPECIAL) )
    strcpy( *ppszDest, "\\cf19 " );
  else if( wMemFlags & (PIC_BUFFER_FLAG_USED) )
    strcpy( *ppszDest, "\\cf17 " );
  else
    strcpy( *ppszDest, "\\cf16 " );
  RTF_SkipToEnd( ppszDest );
}

//---------------------------------------------------------------------------
void RTF_GenerateHeader( char *cp/*destination*/,
                          DWORD dwRGBTextColor,
                          DWORD dwRGBBackgndColor  )
   // Generates a Rich Text File header IN MEMORY .
{
 int  i, iRed, iGreen, iBlue;

  // Create a default font table in the RTF header :
  strcpy( cp, "{\\rtf1\\ansi\\deff0\\deftab720"\
    "{\\fonttbl{\\f0\\fswiss MS SansSerif;}"\
              "{\\f1\\froman\\fcharset2 Symbol;}"\
              "{\\f2\\fmodern Courier New;}}\r\n" );
  RTF_SkipToEnd( &cp );
  // Create "simple" colour table in the RTF header (DOS-text-compatible!) :
  //    0=BLACK      1=BLUE           2=GREEN       3=CYAN
  //    4=RED        5=MAGENTA        6=BROWN       7=LIGHTGRAY
  //    8=DARKGRAY   9=LIGHTBLUE     10=LIGHTGREEN 11=LIGHTCYAN
  //    12=LIGHTRED 13=LIGHTMAGENTA  14=YELLOW     15=WHITE
  strcpy( cp, "{\\colortbl"\
      "\\red0\\green0\\blue0;\\red0\\green0\\blue192;\\red0\\green127\\blue0;\\red0\\green192\\blue192;"\
      "\\red192\\green0\\blue0;\\red192\\green0\\blue192;\\red192\\green128\\blue0;\\red192\\green192\\blue192;"\
      "\\red63\\green63\\blue63;\\red63\\green63\\blue255;\\red0\\green255\\blue0;\\red0\\green255\\blue255;"\
      "\\red255\\green0\\blue0;\\red255\\green0\\blue255;\\red255\\green255\\blue0;\\red127\\green127\\blue127;" );
  RTF_SkipToEnd( &cp );
  // Append some "custom" colours for the HEX DUMP :
  //    16 = "weak" colour for unused location,
  //    17 = "strong" colour for used locations
  //    18 = "error" colour for bad locations
  //    18 = "special" colour to mark the OSCILLATOR CALIBRATION WORD (etc)
  // Get the RGB-mix for the "weak" colour in the memory dump :
  iRed  = (  (dwRGBTextColor & 0x000FF) + ( dwRGBBackgndColor & 0x000FF) ) / 2;
  iGreen= ((((dwRGBTextColor >> 8) & 0x000FF) + ((dwRGBBackgndColor >> 8) & 0x000FF) ) / 2);
  iBlue = ((((dwRGBTextColor >> 16) & 0x000FF)+ ((dwRGBBackgndColor >> 16) & 0x000FF) ) / 2);
  sprintf(cp, "\\red%d\\green%d\\blue%d;", iRed, iGreen, iBlue );  // colour #16
  RTF_SkipToEnd( &cp );
  // Get the RGB-mix for the "strong" colour in the memory dump :
  iRed  =  dwRGBTextColor & 0x000FF;
  iGreen= (dwRGBTextColor >> 8) & 0x000FF;
  iBlue = (dwRGBTextColor >> 16) & 0x000FF;
  sprintf(cp, "\\red%d\\green%d\\blue%d;", iRed, iGreen, iBlue );  // colour #17
  RTF_SkipToEnd( &cp );
  strcpy(cp, "\\red255\\green0\\blue0;" );  // colour #18
  RTF_SkipToEnd( &cp );
  strcpy(cp, "\\red255\\green0\\blue255;"); // colour #19
  RTF_SkipToEnd( &cp );
  strcpy(cp, "}\r\n" );                     // end of the "colortbl" list
  RTF_SkipToEnd( &cp );
  strcpy( cp, "\\deflang1033\\pard\\plain\\cf8\\f2\\fs20 "); // important trailing space !

} // end RTF_GenerateHeader()



//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateCodeMemRange( int iWhichMemory, long i32NLocations, int iUCMoptions )
{
 int line, total_lines, used_locations, i,j;
 int words_per_line;
 long i32ArrayIndex;
 int  text_index;
 char szTemp[1024]; char *cp;    // buffer and pointer to assemble RTF string
 AnsiString s;
 WORD wFlags, wOldFlags=0xFFFF;
 DWORD dw, dwData, dwDisplayedAddress;


  // Reject invalid arguments:
  if(iWhichMemory<0 || iWhichMemory>PIC_BUFFERS || i32NLocations<1)
     return;
  if(PicBuf[iWhichMemory].dwMaxSize == 0)
     return;  // memory buffer has not been allocated properly, don't access it
  if(i32NLocations > (long)PicBuf[iWhichMemory].dwMaxSize)
     i32NLocations = (long)PicBuf[iWhichMemory].dwMaxSize; // obey buffer size limit


  words_per_line = 8;
  total_lines    = 0;

  // Individual colors in a rich text edit control can be achieved
  //    by the property SelAttributes. See Borland's help on TRichEdit....
  //    but individual colors are not too simple :-(
  try{
    for(i32ArrayIndex=0, line=0; (line<=8192) && (i32ArrayIndex<i32NLocations); ++line )
     {  // 2005-02: increased number of lines, for up to 64k instructions
      // no longer needed, fast enough : APPL_ShowProgress( (100*i32ArrayIndex) / i32NLocations );

      // Only add the line if it contains USED locations, or if "all" locations shall be displayed:
      used_locations = 0;
      wFlags = PIC_BUFFER_FLAG_UNUSED;
      for(i=0; (i<words_per_line) && (i32ArrayIndex<i32NLocations ) ; ++i)
       { if( PicBuf[iWhichMemory].pwFlags[i32ArrayIndex+i] & PIC_BUFFER_FLAG_USED)
           { ++used_locations; wFlags |= PIC_BUFFER_FLAG_USED; }
       }
      if( (used_locations>0) || (iUCMoptions & UCM_SHOW_ALL_LOCATIONS) )
       {
        dwDisplayedAddress = PicBuf_ArrayIndexToTargetAddress( iWhichMemory, i32ArrayIndex );
        cp = szTemp;   // pointer for "assembling" an RTF string

        // Change the text colour for the address already, depending on the flags ?
        if( wOldFlags != wFlags )
         {  wOldFlags  = wFlags;
            RTF_SetColorForMemFlags( &cp, wFlags );
         }
        sprintf(cp,"%06lX:",(long)dwDisplayedAddress);
        RTF_SkipToEnd( &cp );

        // Now add the hex data words to the RTF structure :
        for(i=0; (i<words_per_line) && (i32ArrayIndex<i32NLocations ) ; ++i)
         {
          dwData = PicBuf[iWhichMemory].pdwData[i32ArrayIndex+i];
          wFlags = PicBuf[iWhichMemory].pwFlags[i32ArrayIndex+i];
          if( (i32ArrayIndex+i) == PIC_DeviceInfo.lAddressOscCal)
             wFlags |= PIC_BUFFER_FLAG_SPECIAL;

          // Change the text colour for the output, depending on the flags ?
          if( wOldFlags != wFlags )
           {  wOldFlags  = wFlags;
              RTF_SetColorForMemFlags( &cp, wFlags );
           }

          if( PIC_DeviceInfo.iBitsPerInstruction>16 )
           { // 24 bits per "instruction word", means 6 hex digits per value :
             sprintf(cp," %06lX",(long)dwData );
           }
          else if( PIC_DeviceInfo.iBitsPerInstruction>12 )
           { // 14..16 bits per "instruction word" :
             sprintf(cp," %04lX",(long)dwData );
           }
          else
           { // 12 or less bits per "instruction word" :
             sprintf(cp," %03lX",(long)dwData );
           }
          RTF_SkipToEnd( &cp );
         } // end for < N locations per line >

        strcpy(cp, "\\par " );   // Note: \par = END OF PARAGRAPH, important !
        RTF_WriteStringToStream( pRtfMemStream, szTemp );  // append string to code memory dump

        ++total_lines;
       } // end if( (iUCMoptions & UCM_SHOW_ALL_LOCATIONS) || used_locations>0 )
      i32ArrayIndex += words_per_line;
     } // end for (line..)

  }
  catch(...){
    throw;
  }

} // end UpdateCodeMemRange()

//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateCodeMemDisplay(void)
{
 AnsiString old_msg;
 int  i;
 char szTemp[1024]; char *cp;
 DWORD dw;
 BOOLEAN fOldModifyFlag;

  fOldModifyFlag = REd_CodeMem->Modified;
  old_msg = Pnl_Message->Caption;
  Pnl_Message->Caption= "Updating CODE display.." ;  Update();
  m_update_code_mem_display = false;


  // Prepare a temporary "memory stream" in which we will build
  // the coloured, RichText-formatted, lines of the code memory window :
  //   Note: Forget TRichEdit.Lines->Add() - it's UTTERLY slow !
  //   Instead use a TMemoryStream to build an RTF-file-compatible structure
  //   which can then be "loaded" into the TRichEdit in a single over.
  //   This is significantly faster than appending lines "one-by-one" !
  pRtfMemStream = new TMemoryStream();

  // Update the hex dump in Borland's sluggish TRichEdit control :
  // Dont update visible control during update (too slow for my 266MHz-P2).
  // Note: Setting up the TEXT of the hex-"monitor" via "Lines->Add" seems
  //       to be a little faster than the "Text"-property of a TRichEdit.
  //       But still way too slow for large code memories.
  //       *possibly* faster: Use the TRichEdit's "LoadFromStream" method.
  //       Some interesting websites on this subject:
  //         - "Automatic Syntax Highlighting Using a RichEdit Control"
  //             http://www.undu.com/Articles/981027d.html
  //         - "YourPasEdit" (better info on TRichEdit than in the Borland help system)
  //             locally saved as c:\downloads\WindowsKnowHow\yrpasedit.zip
  pRtfMemStream->Seek(0, soFromBeginning );        // warp to the begin of the stream

  cp = szTemp;  // assemble next section in a good old C-string ...

  // Prepare an RTF header in the memory stream ...
  RTF_GenerateHeader( cp/*destination*/,
      (DWORD)Pnl_CodeMemColors->Font->Color, // "text" colour
      (DWORD)Pnl_CodeMemColors->Color );     // "background" colour
  RTF_SkipToEnd( &cp );
  RTF_WriteStringToStream( pRtfMemStream, szTemp );  // et voila, RTF header is complete

#if(1)
  //  Speciality for PICs with so-called EXECUTIVE MEMORY (kind of 'bootloader'):
  //  - If the executive code buffer is loaded, only show the 'ordinary' memory
  //    locations which really contain 'something' .
  //  - If the executive code buffer is not loaded, don't show the executive memory
  //    at all, but instead show ALL locations in the 'ordinary' code buffer .
  if( PicBuf[PIC_BUF_EXEC].dwMaxSize>0 && PicBuf[PIC_BUF_EXEC].i32LastUsedArrayIndex>0 )
   { // there seems to be "loaded" EXECUTIVE CODE MEMORY -> show multiple sections !
     if( PicBuf[PIC_BUF_CODE].i32LastUsedArrayIndex >=/*!*/ 0 )
      { RTF_WriteStringToStream( pRtfMemStream, "; User Code Memory\\par " );
        UpdateCodeMemRange( PIC_BUF_CODE, PIC_DeviceInfo.lCodeMemSize, UCM_SHOW_USED_LOCATIONS_ONLY );
      }
     RTF_WriteStringToStream( pRtfMemStream, "; Executive Code Memory\\par " );
     UpdateCodeMemRange( PIC_BUF_EXEC, PicBuf[PIC_BUF_EXEC].i32LastUsedArrayIndex+1, UCM_SHOW_ALL_LOCATIONS );
   }
  else // no EXECUTIVE MEMORY, only 'ordinary' code memory : No need to show what it is !
   { UpdateCodeMemRange( PIC_BUF_CODE, PIC_DeviceInfo.lCodeMemSize, UCM_SHOW_ALL_LOCATIONS );
   }
#else
  for(i=1; i<=15; ++i)
   {
     sprintf( szTemp, "\\cf%dThis should be line %d in colour #%d .\\par ",(int)i,(int)i,(int)i );
     RTF_WriteStringToStream( pRtfMemStream, szTemp );
   }
#endif // (0,1)

  // Finish RTF file structure (in memory of course ! ) :
  RTF_WriteStringToStream( pRtfMemStream, "\\par }" );

#if(0)   // For debugging purposes: Save the RTF structure as file, too :
  pRtfMemStream->SaveToFile("code_mem.rtf");
#endif

  // Copy the RTF character stream into the visible TRichEdit control ....
  // For strange reasons, the TRichEdit control seems to be too stupid
  //  to adjust it's own buffer automatically to the required size.
  // If the transfer of the memory stream into the TRichEdit control fails,
  //  and the RTF tags are displayed as plain text, the "MaxLength" parameter
  //  may be too low, causing misinterpretation of the RTF structure  !
  // ( yes, it's windoze, don't try to understand this)...  TRY THIS:
  Pnl_Message->Caption= "Streaming CODE display.." ; Update();  
  REd_CodeMem->Lines->BeginUpdate(); // should be faster with this, but no visible effect ?!
  REd_CodeMem->PlainText = FALSE;    // let the Rich Edit control accept RTF
  REd_CodeMem->Color = Pnl_CodeMemColors->Color; // background colour (impossible via RTF code ?)
  dw = pRtfMemStream->Size;          // get the length of the RTF in bytes
  dw += dw/4;                        // add some safety margin
  if(dw<65536) dw=65536;             // don't use less than 64 kByte for the text buffer
  REd_CodeMem->MaxLength = dw;       // adjust the Rich Edit's text buffer size
  pRtfMemStream->Seek(0, soFromBeginning );
  REd_CodeMem->Lines->LoadFromStream(pRtfMemStream); // copy the stream into the Rich Edit control
  REd_CodeMem->Lines->EndUpdate();
  delete pRtfMemStream;
  pRtfMemStream = NULL;    // forget this pointer, it's no longer valid !

  // After restoring the TRichEdit's cursor position ,
  //   the scroll position is at the end and the cursor('caret') is invisible.
  // Borland won't tell you how to scroll the cursor in a TRichEdit in View.
  // But the Win32 programmer's help says in the Rich Edit Control Reference:
  //   > An application sends an EM_SCROLLCARET message
  //   > to scroll the caret into view in an edit control.
  SendMessage(  // hooray, this works...
     REd_CodeMem->Handle, // handle of destination window
     EM_SCROLLCARET,      // message to send
     0,                   // wParam, first message parameter
     0 );                 // lParam, second message parameter

  REd_CodeMem->Modified = fOldModifyFlag;


  Pnl_Message->Caption=old_msg; Update();

} // end UpdateCodeMemDisplay()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::MI_DumpMemAsRTFClick(TObject *Sender)
{
  REd_CodeMem->Lines->SaveToFile("CodeMemDump.rtf");
  REd_DataMem->Lines->SaveToFile("DataMemDump.rtf");
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateDataMemDisplay(void)
{
 long i32NLocations;
 int line,i,j,used_locations;
 int words_per_line;
 long i32ArrayIndex;
 int  text_index;
 int  line_length;
 char szTemp[1024]; char *cp;    // buffer and pointer to assemble RTF string
 BYTE b;
 DWORD dwData, dwDisplayedAddress;
 WORD  wFlags, wOldFlags=0xFFFF;
 DWORD dw;
 AnsiString old_msg;
 BOOLEAN fOldModifyFlag;

  fOldModifyFlag = REd_DataMem->Modified;
  i32NLocations = PIC_DeviceInfo.lDataEEPROMSizeInByte;
  if( i32NLocations > 2*65536 )
      i32NLocations = 2*65536;
  if( i32NLocations <= 0 )
   {  TS_EEPromMemory->TabVisible=FALSE;
      return;
   }
  TS_EEPromMemory->TabVisible=TRUE;
  old_msg = Pnl_Message->Caption;
  Pnl_Message->Caption= "Updating DATA display.." ; Update();

  // Same as for the CODE MEMORY display:
  //   Instead of the utterly slow "TRichEdit.Lines->Add()" - method,
  //   use a TMemoryStream to build an RTF-file-compatible structure ..
  pRtfMemStream = new TMemoryStream();
  pRtfMemStream->Seek(0, soFromBeginning );
  cp = szTemp;  // assemble next section in a good old C-string ...
  RTF_GenerateHeader( cp/*destination*/,
      (DWORD)Pnl_DataMemColors->Font->Color, // "text" colour
      (DWORD)Pnl_DataMemColors->Color );     // "background" colour
  RTF_SkipToEnd( &cp );
  RTF_WriteStringToStream( pRtfMemStream, szTemp );  // et voila, RTF header is complete

  m_update_data_mem_display = false;
  words_per_line = 8;
  try{
    for(i32ArrayIndex=0, line=0; i32ArrayIndex<i32NLocations ; ++line )
     {
        dwDisplayedAddress = PicBuf_ArrayIndexToTargetAddress( PIC_BUF_DATA, i32ArrayIndex);
        wFlags = PIC_BUFFER_FLAG_UNUSED;
        for(i=0; (i<words_per_line) && (i32ArrayIndex<i32NLocations ) ; ++i)
         { if( PicBuf[PIC_BUF_DATA].pwFlags[i32ArrayIndex+i] & PIC_BUFFER_FLAG_USED)
             { ++used_locations; wFlags |= PIC_BUFFER_FLAG_USED; }
         }
        cp = szTemp;   // pointer for "assembling" an RTF string

        // Change the text colour for the address already, depending on the flags ?
        if( wOldFlags != wFlags )
         {  wOldFlags  = wFlags;
            RTF_SetColorForMemFlags( &cp, wFlags );
         }
        sprintf(cp,"%06lX:",(long)dwDisplayedAddress);
        RTF_SkipToEnd( &cp );

        for(i=0; (i<words_per_line)
              && (i32ArrayIndex<PIC_BUF_DATA_SIZE)
              && (i32ArrayIndex<PIC_DeviceInfo.lDataEEPROMSizeInByte) ; ++i)
         {
           dwData = PicBuf[PIC_BUF_DATA].pdwData[i32ArrayIndex+i];
           wFlags = PicBuf[PIC_BUF_DATA].pwFlags[i32ArrayIndex+i];

           // Change the text colour for the output, depending on the flags ?
           if( wOldFlags != wFlags )
            {  wOldFlags  = wFlags;
               RTF_SetColorForMemFlags( &cp, wFlags );
            }
           sprintf(cp," %02X",(int)dwData & 0x00FF );
           RTF_SkipToEnd( &cp );
         }

        strcpy(cp, "    " );  // separator between HEX- and ASCII display
        RTF_SkipToEnd( &cp );
        for(i=0; (i<words_per_line)
              && (i32ArrayIndex<PIC_BUF_DATA_SIZE)
              && (i32ArrayIndex<PIC_DeviceInfo.lDataEEPROMSizeInByte) ; ++i)
         {
           b = PicBuf[PIC_BUF_DATA].pdwData[i32ArrayIndex+i];
           if( (BYTE)b==(BYTE)'{' )// RTF treat's curly braces something special, so ESCAPE it
            { strcpy(cp,"\\{"); cp+=2;
            }
           else if( (BYTE)b==(BYTE)'}' )
            { strcpy(cp,"\\}"); cp+=2;
            }
           else if( b=='\\' )       // a SINGLE(!) backslash begins an RTF token, so escape it
            { strcpy(cp,"\\\\"); cp+=2;  // caution, these are TWO backslashes
            }
           else if( b>=0x20 && b<=0x7F )
                  *cp++ = (char)b;   // "printable"
             else *cp++ = '.';       // "non-printable" (really ?)
         }
        strcpy(cp, "\\par " );   // Note: \par = END OF PARAGRAPH, important !
        RTF_WriteStringToStream( pRtfMemStream, szTemp );  // append string to code memory dump

        i32ArrayIndex += words_per_line;
     } // end for (line..)
  }
  catch(...){
    throw;
  }

  // Finish RTF file structure, and copy the stream into the Rich Edit control:
  RTF_WriteStringToStream( pRtfMemStream, "\\par }" );
  Pnl_Message->Caption= "Streaming DATA display.." ; Update();
  REd_DataMem->PlainText = FALSE;    // let the Rich Edit control accept RTF
  REd_DataMem->Color = Pnl_DataMemColors->Color; // background colour (impossible via RTF code ?)
  dw = pRtfMemStream->Size;          // get the length of the RTF in bytes
  dw += dw/4;                        // add some safety margin
  if(dw<65536) dw=65536;             // don't use less than 64 kByte for the text buffer
  REd_DataMem->MaxLength = dw;       // adjust the Rich Edit's text buffer size
  pRtfMemStream->Seek(0, soFromBeginning );
  REd_DataMem->Lines->LoadFromStream(pRtfMemStream); // copy the stream into the Rich Edit control
  delete pRtfMemStream;
  pRtfMemStream = NULL;    // forget this pointer, it's no longer valid !

  // Send an EM_SCROLLCARET message to scroll the caret into view:
  SendMessage( REd_DataMem->Handle, // handle of destination window
               EM_SCROLLCARET,      // message to send
               0,                   // wParam, first message parameter
               0 );                 // lParam, second message parameter
  REd_DataMem->Modified = fOldModifyFlag;
  Pnl_Message->Caption=old_msg; Update();
} // end UpdateDataMemDisplay()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateIdAndConfMemDisplay(void)
{
 int i,j,k;
 int iGridLine;
 char sz80Temp[82];
 DWORD dw, dwAddress;
 WORD wBitsPerIdLocation = PicDev_GetNrOfBitsPerIdLocation();
 AnsiString old_msg;

  ++m_Updating;


   old_msg = Pnl_Message->Caption;
   Pnl_Message->Caption= "Updating config-MEMORY-grid" ;  Update();


  // Update the CONFIG MEMORY TABLE (binary or hexadecimal dump, NO BIT-DECODERS)
  SG_CfgMem->RowCount = 1+PIC_BUF_CONFIG_SIZE; // usually 1 + 64
  SG_CfgMem->ColCount = 3;
  // 2005-06-30: Why was this routine so UTTERLY slow - just because it's VCL stuff ? ?
  //  ( took 3 seconds to fill this ridiculously small TStringGrid ! )
  SG_CfgMem->Cols[0]->BeginUpdate();    // does this help to speed things up ?
  SG_CfgMem->Cols[1]->BeginUpdate();
  SG_CfgMem->Cols[2]->BeginUpdate();

  SG_CfgMem->Cells[0][0] = TE("Address");   //  [ACol][ARow] ..
  SG_CfgMem->Cells[1][0] = TE("Info");
  SG_CfgMem->Cells[2][0] = TE("Value");

  for( i=0,iGridLine=1 ; i<PIC_BUF_CONFIG_SIZE; ++i)
   {
    if( PIC_DeviceInfo.iBitsPerInstruction == 24 )
     {  // 24 bit per instruction in code memory .. looks like a dsPIC : only EVEN addresses useable
        dwAddress = PIC_DeviceInfo.lConfMemBase + 2*i;
     }
    else if( PIC_DeviceInfo.iBitsPerInstruction == 16 )
     {  // 16 bit per instruction in code memory .. may be 18Fxxxx, supported "one fine day" ?
        dwAddress = PIC_DeviceInfo.lConfMemBase + 2*i;
     }
    else // everything else is either PIC12F... or PIC16F... ?
     {  dwAddress = PIC_DeviceInfo.lConfMemBase + i;
     }
    if( (Chk_ShowAllCfgCells->Checked) || (PicDev_IsConfigMemLocationValid(dwAddress)) )
     {
      sprintf(sz80Temp,"0x%4.4X",(int)dwAddress); // sprintf is smart enough to use 6 digits if necessary !
      if( !PicDev_IsConfigMemLocationValid(dwAddress) )
        strcat( sz80Temp, " *" );
      SG_CfgMem->Cells[0][iGridLine] = sz80Temp;
      SG_CfgMem->Cells[1][iGridLine] = PicDev_GetInfoOnConfigMemory( dwAddress );
      if( PicBuf_GetBufferWord( dwAddress, &dw ) > 0 )
       {
        memset(sz80Temp,0,80);
        if(RB_IdBin->Checked)
          SG_CfgMem->Cells[2][iGridLine] = WordToSeparatedBinary(dw, wBitsPerIdLocation);
        else
         {
          sprintf(sz80Temp,"0x%4.4X",(int)dw );
          SG_CfgMem->Cells[2][iGridLine] = sz80Temp;
         }
        iGridLine++;
        if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
            APPL_LogEvent( "UpdateIdAndConfMemDisplay: line %d ", (int)iGridLine );
       } // end if < successfully retrieved data from a buffer for this location >
     }
   } // end for

  // Since 2005-05, for PIC10F20x: Here the USER ID LOCATIONS are located
  //  in a totally different memory area, which *MAY* be appended to the config bits:
  if(  (PIC_DeviceInfo.lIdMemBase > (PIC_DeviceInfo.lConfMemBase+PIC_BUF_CONFIG_SIZE) )
     ||(PIC_DeviceInfo.lIdMemBase < PIC_DeviceInfo.lConfMemBase )
    )
   {
     for( i=0; i<PIC_DeviceInfo.lIdMemSize; ++i)
      {
        dwAddress = PIC_DeviceInfo.lIdMemBase + i;
        sprintf(sz80Temp,"0x%4.4X",(int)dwAddress); // sprintf is smart enough to use 6 digits if necessary !
        SG_CfgMem->Cells[0][iGridLine] = sz80Temp;
        SG_CfgMem->Cells[1][iGridLine] = PicDev_GetInfoOnConfigMemory( dwAddress );
        if( PicBuf_GetBufferWord( dwAddress, &dw ) > 0 )
         { memset(sz80Temp,0,80);
           if(RB_IdBin->Checked)
              SG_CfgMem->Cells[2][iGridLine] = WordToSeparatedBinary(dw, wBitsPerIdLocation);
           else
            { sprintf(sz80Temp,"0x%4.4X",(int)dw );
              SG_CfgMem->Cells[2][iGridLine] = sz80Temp;
            }
           iGridLine++;
           if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
               APPL_LogEvent( "UpdateIdAndConfMemDisplay: line %d ", (int)iGridLine );
         } // end if < successfully retrieved data from a buffer for this location >
      }
   } // end if < "ID memory" separated from "Config memory" >

  if(iGridLine>1)
        SG_CfgMem->RowCount = iGridLine;
  else  SG_CfgMem->RowCount = 2;
  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "UpdateIdAndConfMemDisplay: Calling EndUpdate()" );
  SG_CfgMem->Cols[0]->EndUpdate();    // does this help to speed things up ?
  SG_CfgMem->Cols[1]->EndUpdate();
  SG_CfgMem->Cols[2]->EndUpdate();
  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "UpdateIdAndConfMemDisplay: EndUpdate() finished" );

  if( PicBuf_GetBufferWord( PIC_DeviceInfo.lDeviceIdAddr, &dw ) > 0 )
   {
    if(RB_IdBin->Checked)
      Lab_DevId->Caption = WordToSeparatedBinary(dw, wBitsPerIdLocation);
    else
     {
      sprintf(sz80Temp,"0x%4.4X",(int)dw );
      Lab_DevId->Caption = sz80Temp;
     }
   }
  else
   { dw=0;
     Lab_DevId->Caption = "<error>";
   }

  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "UpdateIdAndConfMemDisplay: Searching Device Name by ID WORD..." );

  // Note 1: PicDev_GetDeviceNameByIdWord() can be TERRIBLY SLOW
  //         when called for the first time, due to the sluggish reading
  //         of the INI-file "devices.ini" .  But too late to change that now.
  // Note 2: Because of a device ID collosion between certain PIC16F's and PIC18F's
  //         (like PIC16F630 and PIC18F4220), PicDev_GetDeviceNameByIdWord()
  //         needs to know the number of bits per instruction word"; 14,16,24,..
  strcpy( m_sz80DetectedPicDevName, PicDev_GetDeviceNameByIdWord(dw, PIC_DeviceInfo.iBitsPerInstruction) );
  if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "UpdateIdAndConfMemDisplay: Finished searching Device Name" );


  m_fPicDeviceConflict = FALSE;
  if( m_sz80DetectedPicDevName[0]!=0 )
   { // successfully ''decoded' the Device ID Word. Selected the right device ?
     if( strcmp(m_sz80DetectedPicDevName,PIC_DeviceInfo.sz40DeviceName) != 0)
      { if (dw!=0 && dw!=0xFFFF)
          m_fPicDeviceConflict = TRUE;
      }
   }
  else // unknown Device ID Word.  Not an error, because some PICs don't support this.
   {
     sprintf(m_sz80DetectedPicDevName,
        TE("<unknown ID>") );
   }
  Lab_DevIdDecoded->Caption = " = " + AnsiString(m_sz80DetectedPicDevName);
  if( m_fPicDeviceConflict )
   { Lab_DevId1->Color = clRed;
     Lab_DevId->Color  = clRed;
     Lab_DevIdDecoded->Color = clRed;
     PageControl1->ActivePage = TS_CfgMemTab;
   }
  else
   { Lab_DevId1->Color = clBtnFace;
     Lab_DevId->Color  = clBtnFace;
     Lab_DevIdDecoded->Color = clBtnFace;
   }

   m_update_id_and_config_display = FALSE;  // "done"


   Pnl_Message->Caption=old_msg; Update();

   if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
      APPL_LogEvent( "UpdateIdAndConfMemDisplay: finished" );

   --m_Updating;

} // end UpdateIdAndConfMemDisplay()

//---------------------------------------------------------------------------
void __fastcall TPicMain::ApplyIdLocationDisplay(void)
{
 int i,j;
 char sz80Temp[82];
 char *cp;
 WORD w;
 DWORD dwAddress;
 BOOL ok;
 WORD wBitsPerIdLocation = PicDev_GetNrOfBitsPerIdLocation();  // 14 or 16 ?


  for(i=0; (i+1)<SG_CfgMem->RowCount; ++i)
   {
     strncpy(sz80Temp, SG_CfgMem->Cells[0][i+1].c_str(), 80);
     dwAddress = HexStringToLongint(6,sz80Temp);
     strncpy(sz80Temp, SG_CfgMem->Cells[2][i+1].c_str(), 80);
     w=0; ok=TRUE; cp=sz80Temp;
     if( (cp[0]=='$') || (cp[0]=='0' && cp[1]=='x') )
      {
        w = HexStringToLongint(6,cp);
      }
     else // not HEX but BIN:
      {
       for(j=0;j<wBitsPerIdLocation;++j)
        { while(*cp==' ') ++cp;  // skip spaces, they are no syntax element here
          if(*cp=='1')
           { w |= (1<<(wBitsPerIdLocation-1-j)); ++cp; }
          else if(*cp=='0')
           { ++cp; }
          else ok=FALSE;
        }
      }
     if(ok)
       PicBuf_SetBufferWord( dwAddress, w );
   } // end for < all GRID LINES >

} // end ApplyIdLocationDisplay()
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::SG_CfgMemSetEditText(TObject *Sender, int ACol,
      int ARow, const AnsiString Value)
{
  if(!m_Updating)
    Btn_ApplyIdLocs->Enabled = TRUE;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::Btn_ApplyIdLocsClick(TObject *Sender)
{
 ApplyIdLocationDisplay();
 UpdateIdAndConfMemDisplay();  // ... in "normalized" form
 Btn_ApplyIdLocs->Enabled = FALSE;
}
//---------------------------------------------------------------------------


void __fastcall TPicMain::Btn_HelpOnIdLocsClick(TObject *Sender)
{
  Application->HelpContext(HELPID_ID_LOCATIONS);
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Poor man's "TStringGrid with Combos" ... without any 3rd-party's controls :
// Based on an idea from http://www.functionx.com/bcb/howto/cboxinstringgrid.htm
//  This is clumsy but it works: "a TComboBox plastered over a TStringGrid" !
//---------------------------------------------------------------------------
 #define SG_CONFIGBITS_COL_NAME  0
 #define SG_CONFIGBITS_COL_ADDR  1
 #define SG_CONFIGBITS_COL_MASK  2
 #define SG_CONFIGBITS_COL_VALUE 3
void __fastcall TPicMain::UpdateConfigBitCombo(void)
{
  int iGridRow = SG_ConfigBits->Row;
  int iComboItemIndex, iComboItemCount;
  char str60[64];
  T_PicConfigBitInfo *pConfigBitInfo;
  T_PicConfigBitSetting *pBitCombinations;
  BOOL fShowCombo = FALSE;

  ++m_Updating;

  if( SG_ConfigBits->Col == SG_CONFIGBITS_COL_VALUE )
   {
     // Fill the COMBO for this line with new data,
     //  using the device-specific info table (in Devices.cpp) .
     // Get a pointer to the device-specific info about this "CONFIG-BIT":
     pConfigBitInfo = m_pConfigBitGridRowNumber_to_ConfigBitInfoPtr[iGridRow];
     if( pConfigBitInfo )  // can only "handle" this grid line with this device-specific config-bit info...
      { strncpy(str60, SG_ConfigBits->Cells[SG_CONFIGBITS_COL_VALUE][iGridRow].c_str(), 60 ); // string to select in combo
        str60[60] = '\0';  // important for string compare, if strings too long
        pBitCombinations = pConfigBitInfo->pBitCombinations;
        iComboItemIndex = -1; // "item index" for the new combo list still unknown
        iComboItemCount = 0;  // no entry in the combo list (yet)
        CB_ConfigBits->Clear();
        if( pBitCombinations )  // only if there is a chained list of "bit combinations"...
         {
           while(pBitCombinations!=NULL && iComboItemCount<100 && pBitCombinations->sz60ComboText[0]!=0 )
            { CB_ConfigBits->Items->Add( pBitCombinations->sz60ComboText );
              if( strncmp( str60, pBitCombinations->sz60ComboText, 60 ) == 0 )
               { iComboItemIndex = iComboItemCount;  // select this item in the combo !
               }
              pBitCombinations = pBitCombinations->pNext;
              ++iComboItemCount;
            }
           CB_ConfigBits->ItemIndex = iComboItemIndex;
           fShowCombo = TRUE;
         } // end if( pBitCombinations )
      }
     else // there is no "pointer to info about this configuration bit" ->
      {
         // leave fShowCombo=FALSE to turn the combo box "off" for this line !
      }
   }  // end if( SG_ConfigBits->Col == SG_CONFIGBITS_COL_VALUE )

  if( fShowCombo )   // Ok to show the COMBO BOX for this line of the config-bit-grid ?
   { // This "TStringGrid with COMBOS" is actually an ordinary standard String Grid control,
     // with a TComboBox "plastered" over it. To let the combo look like a part of the grid,
     // get the screen coordinates of a cell in the grid (CellRect)
     // and place the TComboBox there .
     TRect CellRect = SG_ConfigBits->CellRect( SG_ConfigBits->Col, SG_ConfigBits->Row);
 //  CB_ConfigBits->Top  = SG_ConfigBits->Top;   // why ?
 //  CB_ConfigBits->Left = SG_ConfigBits->Left;
 //  CB_ConfigBits->Top  = CB_ConfigBits->Top + CellRect.Top + SG_ConfigBits->GridLineWidth;
 //  CB_ConfigBits->Left = CB_ConfigBits->Left + CellRect.Left + SG_ConfigBits->GridLineWidth + 1;
     CB_ConfigBits->Top  = SG_ConfigBits->Top  + CellRect.Top  + SG_ConfigBits->GridLineWidth + 1;
     CB_ConfigBits->Left = SG_ConfigBits->Left + CellRect.Left + SG_ConfigBits->GridLineWidth + 1;
     CB_ConfigBits->Height = (CellRect.Bottom - CellRect.Top) + 1;    // not accepted by ComboBox ?!
     CB_ConfigBits->Width  = CellRect.Right - CellRect.Left;
     CB_ConfigBits->Visible = True;
   }
  else // fShowCombo=FALSE..
   { CB_ConfigBits->Visible = False;
   }

  --m_Updating;

} // end TPicMain::UpdateConfigBitCombo()

//---------------------------------------------------------------------------
void __fastcall TPicMain::SG_ConfigBitsClick(TObject *Sender)
{ // Called when user selected a cell (row or column) in the "configuration bit grid" .
  if( m_Updating )
    return;
  UpdateConfigBitCombo(); // adjust the TComboBox in this "Poor Man's TStringGrid with COMBOs" ;-)
} // SG_ConfigBitsClick()
//---------------------------------------------------------------------------

void __fastcall TPicMain::SG_ConfigBitsTopLeftChanged(TObject *Sender)
{ // > Use OnTopLeftChanged to perform special processing
  // > when the non-fixed cells in the grid are scrolled.
  // Here: Make sure the TComboBox is scrolled along with the grid cell:
  if( m_Updating )
    return;
  UpdateConfigBitCombo();
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::TS_DeviceConfigResize(TObject *Sender)
{
 int iNewTableWidth = TS_DeviceConfig->Width - 20;
 int iWidth0;
  // ... similar as above after RESIZING the tabsheet with the config bits:
  if( m_Updating )
    return;
  if( iNewTableWidth>200 )
   {
    iWidth0 = (iNewTableWidth-90)/2;
    if( iWidth0 > 250 )
        iWidth0 = 250;
    SG_ConfigBits->ColWidths[0] = iWidth0;
    SG_ConfigBits->ColWidths[1] = 45;
    SG_ConfigBits->ColWidths[2] = 45;
    SG_ConfigBits->ColWidths[3] = iNewTableWidth-100-iWidth0;
   }
  UpdateConfigBitCombo();
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::CB_ConfigBitsChange(TObject *Sender)
{ // Called when the user(?) selected an item from the "plastered" configuration bit COMBO.
  int   iGridRow = SG_ConfigBits->Row;
  DWORD dwAddr;
  char  *cp, str80[84];

  if( m_Updating )
     return;   // it was not the user ("clicking"), but a programmed access to the COMBO

  ++m_Updating;

  // Here: Copy the "new" selected item as text into the string grid ..
  SG_ConfigBits->Cells[SG_ConfigBits->Col][iGridRow] =
        CB_ConfigBits->Items->Strings[CB_ConfigBits->ItemIndex];

  // .. and check the ADDRESS of this config bit, to mark this buffer entry as "used" :
  strncpy(str80, SG_ConfigBits->Cells[SG_CONFIGBITS_COL_ADDR][iGridRow].c_str(), 80 );
  cp = str80;
  if( PicHex_GetHexValueFromSource( &cp, &dwAddr ) )  // parsed a valid address ?
   { PicBuf_SetMemoryFlags(dwAddr, PicBuf_GetMemoryFlags(dwAddr) | PIC_BUFFER_FLAG_USED );
   }

  // .. and, since the grid has been modified, it must be "applied"
  //  because other visible controls shall reflect the new setting too :
  ApplyConfigBitGrid();  // "apply" the values in the grid and write them to the config memory buffer
            // Note: If this has an effect on the 1st and 2nd "Config Word",
            //     the TIMER METHOD(!) will detect the change a bit later
            //     and update the display accordingly .

  --m_Updating;

} // end CB_ConfigBitsChange()
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateConfigBitGrid(void)
   // Shows the state of  "all important config bits" in string grid .
   // These bits were once part of a single "CONFIG WORD" (for PIC16Fxx),
   // but these bits may now be spread all over the CONFIGURATION REGISTERS .
   // Most items in this table are single-bit locations, while others
   // may be 2,3 or more bits, like the oscillator selection .
   // Since 2005-03, the WinPic GUI(!) contains no "special treatment"
   //  for these bit groups, because all def's may be loaded from files .
   //  See DEVICES.CPP,  PicDev_FillConfigBitInfoTable() for details .
{
  int i,n;
  char str80[84];
  AnsiString s, old_msg;  // VCL-stuff !
  T_PicConfigBitInfo *pConfigBitInfo;
  DWORD dwConfigWord, dwConfigWordAddress, dwConfigMask;

  ++m_Updating;

   old_msg = Pnl_Message->Caption;
   Pnl_Message->Caption= "Updating config-BIT-grid" ;  Update();


   SG_ConfigBits->RowCount=PICDEV_MAX_CONFIG_BIT_INFOS;
   SG_ConfigBits->Cells[SG_CONFIGBITS_COL_NAME][0] = "Configuration Bit Group (Name)";
   SG_ConfigBits->Cells[SG_CONFIGBITS_COL_ADDR][0] = "Addr";
   SG_ConfigBits->Cells[SG_CONFIGBITS_COL_MASK][0] = "Mask";  // important debugging aid, also to add support for new devices
   SG_ConfigBits->Cells[SG_CONFIGBITS_COL_VALUE][0]= "Setting";
   for(i=0; i<SG_ConfigBits->ColCount; ++i)  // clear line 1, we MAY not be able to fill it
    { SG_ConfigBits->Cells[i][1] = "";
    }

   pConfigBitInfo = PicDev_ConfigBitInfo;
   i=n=0; while( pConfigBitInfo->sz60Text[0] ) // Fill the String Grid ("TStringGrid with Combos")..
    {
     dwConfigWordAddress = pConfigBitInfo->dwAddress; // target address (like 0x002007 for PIC16Fxxx)
     dwConfigMask =   pConfigBitInfo->dwBitmask;    // bitmask (usually only ONE bit set in this value)
     // Only if the bitmask for this "config bit group" is NON-ZERO, it may be listed in the string grid..
     if(  dwConfigMask != 0 )
      { SG_ConfigBits->Cells[SG_CONFIGBITS_COL_NAME][n+1] = pConfigBitInfo->sz60Text;
        sprintf(str80,"%06lX",(long)dwConfigWordAddress);
        SG_ConfigBits->Cells[SG_CONFIGBITS_COL_ADDR][n+1] = str80;
        sprintf(str80,"%06lX",(long)dwConfigMask);
        SG_ConfigBits->Cells[SG_CONFIGBITS_COL_MASK][n+1] = str80;
        m_pConfigBitGridRowNumber_to_ConfigBitInfoPtr[n+1]= pConfigBitInfo;
        if( dwConfigWordAddress == 0x300005 )
            dwConfigWordAddress =  dwConfigWordAddress;
        if( PicBuf_GetBufferWord(dwConfigWordAddress, &dwConfigWord) > 0 )
         { s = PicDev_ConfigBitValueToString( pConfigBitInfo, dwConfigWord );
         }
        else // couldn't read this word from the config memory buffer -> disable checkmark
         { s = "-inaccessible-";
         }
        SG_ConfigBits->Cells[SG_CONFIGBITS_COL_VALUE][n+1] = s;
        ++n;
       } // end if < exactly ONE bit set in the bitmask, or a bunch of CP bits >
     ++i; ++pConfigBitInfo;
     if(i>PICDEV_MAX_CONFIG_BIT_INFOS)
        break;  // emergency break, should never happen
    } // end while( pConfigBitInfo->sz60Text[0] )
   if( n>=1 )
      SG_ConfigBits->RowCount = n+1;   // remove unused lines (rows) at end of grid
   else
    {
      SG_ConfigBits->RowCount = 2;  // not one (looks too ugly)
    }

  Pnl_Message->Caption=old_msg; Update();

  --m_Updating;

} // end UpdateConfigBitGrid()

//---------------------------------------------------------------------------
void __fastcall TPicMain::ApplyConfigBitGrid(void)
   // Parses the "values" in the string grid of "important config bits" .
   // This is -more or less- inverse to UpdateConfigBitGrid(), see above.
{
  int iGridRow;
  T_PicConfigBitInfo *pConfigBitInfo;
  DWORD dwConfigWord, dwConfigWordAddress, dwConfigMask, dwNewValue;
  char str80[84];

  if( APPL_i32CustomizeOptions & APPL_CUST_NO_CONFIG_EDITOR )
    return;

   for(iGridRow=1/*!*/; iGridRow<=SG_ConfigBits->RowCount && iGridRow<=PICDEV_MAX_CONFIG_BIT_INFOS; ++iGridRow)
    {
     // Get a pointer to the device-specific info about this "Group of CONFIG-BITS":
     //  Note: Due to Microchip's strange way to do things, these bits may bot even be ADJACENT,
     //        but -for WinPic- all bits of one group must reside in ONE CONFIG WORD (a 16 bit).
     //        An example for a non-adjacent group of bits is the osc selection
     //        in the PIC16F628 with dwConfigMask=0x0013 .
     pConfigBitInfo = m_pConfigBitGridRowNumber_to_ConfigBitInfoPtr[iGridRow];
     if( pConfigBitInfo )  // can only "handle" this grid line with this device-specific config-bit info...
      { strncpy(str80, SG_ConfigBits->Cells[SG_CONFIGBITS_COL_VALUE][iGridRow].c_str(), 80 );
        dwConfigWordAddress = pConfigBitInfo->dwAddress;  // target address (example: 0x002007 for PIC16Fxx)
        dwConfigMask   = pConfigBitInfo->dwBitmask;    // bitmask (usually only ONE bit set in this value)
        // Try to convert the text from the COMBO BOX of this config bit group
        // into a numeric value, which can then be combined with the present content
        // of this configuration register. Use the "bitmask" to change only those bits
        // which belong to this bit group !
        if( PicDev_ConfigBitStringToValue( pConfigBitInfo, str80, &dwNewValue ) )
         {  // only if the string value could be "interpreted" :
           if( PicBuf_GetBufferWord(dwConfigWordAddress, &dwConfigWord) > 0 )
            { // Note: even if the config memory is buffered as 16-bit WORDs,
              //       dwConfigWordAddress may be an ODD value ! In that case,
              //       PicBuf_GetBufferWord() + PicBuf_SetBufferWord() only access
              //       the HIGH BYTE (bits 15..8) of the 16-bit buffer entry .
              dwConfigWord = (dwConfigWord & ~dwConfigMask) | ( dwNewValue & dwConfigMask);
              PicBuf_SetBufferWord(dwConfigWordAddress, dwConfigWord);
              m_update_id_and_config_display = TRUE;  // must update "the other tab" too (later)
            } // end if < successfully READ this configuration word >
         }
      } // end if < state of checkmark CHECKED or UNCHECKED, but not GRAYED >
    } // for < all elements of the CONFIG BIT CHECK LIST >

   // Note: If the above edits had an effect on the 1st and 2nd "Config Word",
   //     the TIMER METHOD(!) will detect the change a bit later
   //     and update "everything which is needed" to make things a bit simpler.
   //     So no reason to call UpdateDeviceConfigTab() or UpdateConfigBitGrid() here !

} // end ApplyConfigBitGrid()

//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateDeviceConfigTab(BOOL fUpdateHexWord)
{
  int i,n;
  char str80[81];
  BOOL fFoundDevName;
  T_PicDeviceInfo MyDeviceInfo;
  T_PicConfigBitInfo *pConfigBitInfo;
  DWORD dwConfigWord, dwConfigWordAddress, dwConfigMask;
  AnsiString s;

   ++m_Updating;
   m_displayed_config_word[0]  = PicBuf_GetConfigWord(0);
   m_displayed_config_word[1]  = PicBuf_GetConfigWord(1); // since 2003-12

   strncpy(m_sz40DisplayedDeviceName, PIC_DeviceInfo.sz40DeviceName, 40);

   // Show the currently selected PIC type in the "Part"-combo list.
   // ex: Be sure that the item index matches the definition of
   //     PIC_DEV_TYPE_xxxx in PIC_PRG.h !!
   // Now all types in the list are filled during run-time from a table..
   if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
       APPL_LogEvent( "UpdateDeviceConfigTab: Listing devices.." );
   fFoundDevName = FALSE;
   i=0;
   while( i < Combo_PartName->Items->Count )
     {
       if( Combo_PartName->Items->Strings[i] == m_sz40DisplayedDeviceName )
        {
          Combo_PartName->ItemIndex = i;
          fFoundDevName = TRUE;
        }
       ++i;
     }

   Chk_HasFlashMemory->Checked = (PIC_DeviceInfo.iCodeMemType==PIC_MT_FLASH) ;
   if(fFoundDevName && (m_sz40DisplayedDeviceName[0]!='u') )
      {
        Caption = AnsiString(TE(m_original_title.c_str())) + " - " + Combo_PartName->Text;
        Ed_ProgramMemory->ReadOnly    = TRUE;
        Ed_ProgramMemory->Color       = clBtnFace;
        Ed_DataEepromMemory->ReadOnly = TRUE;
        Ed_DataEepromMemory->Color    = clBtnFace;
        Ed_ConfigWordHex->Color       = clBtnFace;
        Chk_HasFlashMemory->Enabled   = FALSE;    // we know if it's possible
      }
    else // unknown PIC device type.
      {  // No Config word decoding, but "everything goes"...
        Caption = AnsiString(TE(m_original_title.c_str())) + " - " + TE("unknown PIC type") + " !";
        Ed_ProgramMemory->ReadOnly    = FALSE;
        Ed_ProgramMemory->Color       = clWindow;
        Ed_DataEepromMemory->ReadOnly = FALSE;
        Ed_DataEepromMemory->Color    = clWindow;
        Ed_ConfigWordHex->Color       = clWindow;
        Chk_HasFlashMemory->Enabled   = TRUE;    // dunno, let the user decide
      }  // end if <unknown PIC device type

   if(fUpdateHexWord)
    { // only if the user is not editing the hex config word(s) at the moment...
      // Show the currently used config-word and some of its elements:
      sprintf(str80,"%04X",(int)m_displayed_config_word[0]);
      Ed_ConfigWordHex->Text = str80;

      // Since 2003-12, the PIC16F88 is supported, it was the first midrange-PIC
      //                with TWO configuration words !
      if( PIC_DeviceInfo.wCfgmask2_used == 0x0000)  // looks like there is no 2nd cfg word:
         Ed_ConfigWord2->Color = clBtnShadow;
      else // 2nd config word seems to exist:
         Ed_ConfigWord2->Color = clWindow;
      sprintf(str80,"%04X",(int)PicBuf_GetConfigWord(1) );
      Ed_ConfigWord2->Text = str80;
    }

   // Since 2005-03-11 : Fill the string grid ("table") with special configuration bits (or bit groups):
   if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
       APPL_LogEvent( "UpdateDeviceConfigTab: Updating config BIT GRID.." );
   UpdateConfigBitGrid();
   if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
       APPL_LogEvent( "UpdateDeviceConfigTab: Updating config BIT COMBO.." );
   UpdateConfigBitCombo();

#if(0) // old stuff, only suited for PIC16Fxxx where all config bits were located in ONE config word..
   Chk_CodeProtect->Enabled = (PIC_DeviceInfo.wCfgmask_cpbits != 0);
   Chk_CodeProtect->Checked = // just one of the cp bits=ZERO means protected (*)
     (m_displayed_config_word[0] & PIC_DeviceInfo.wCfgmask_cpbits) != PIC_DeviceInfo.wCfgmask_cpbits;
   // (*) not always true ! Some PIC support code protection in several ranges.
   //     Since the author strongly recommends *NOT* to code-protect any device,
   //     it is not fully supported here. Please leave all code protection bits
   //     for any PIC device SET (1) to disable code protection.
   //  For a "production grade" programmer you must use something else anyway...
   Chk_PWRTE->Enabled = (PIC_DeviceInfo.wCfgmask_pwrte != 0);
   Chk_PWRTE->Checked = ((m_displayed_config_word[0] & PIC_DeviceInfo.wCfgmask_pwrte)
        ^PIC_DeviceInfo.wCfgmask_inv_pwrte) != 0; // inversion: 0x0008 for 16F84
   Chk_WDTE->Enabled = (PIC_DeviceInfo.wCfgmask_wdte != 0);
   Chk_WDTE->Checked = (m_displayed_config_word[0] & PIC_DeviceInfo.wCfgmask_wdte) != 0;
   Chk_DataProtection->Enabled = ( PIC_DeviceInfo.wCfgmask_cpd != 0);
   Chk_DataProtection->Checked =
     (m_displayed_config_word[0] & PIC_DeviceInfo.wCfgmask_cpd) != PIC_DeviceInfo.wCfgmask_cpd;
     // Data memory code protection should be disabled (cpd=1 means NOT protected)
     // otherwise it is impossible to verify the Data memory contents !
   Chk_LowVoltageProg->Enabled = ( PIC_DeviceInfo.wCfgmask_lvp != 0);
   Chk_LowVoltageProg->Checked = (m_displayed_config_word[0] & PIC_DeviceInfo.wCfgmask_lvp) != 0;
   Chk_BrownOutReset->Enabled  = ( PIC_DeviceInfo.wCfgmask_boden != 0);
   Chk_BrownOutReset->Checked  = (m_displayed_config_word[0] & PIC_DeviceInfo.wCfgmask_boden) != 0;
   Chk_MCLRenable->Enabled     = ( PIC_DeviceInfo.wCfgmask_mclre != 0);
   Chk_MCLRenable->Checked     = (m_displayed_config_word[0] & PIC_DeviceInfo.wCfgmask_mclre) != 0;
   Chk_DebugEnable->Enabled    = ( PIC_DeviceInfo.wCfgmask_ddebug != 0);
   Chk_DebugEnable->Checked    = ( PIC_DeviceInfo.wCfgmask_ddebug != 0)
     && ((m_displayed_config_word[0] & PIC_DeviceInfo.wCfgmask_ddebug) == 0);
   Chk_CodeWriteEnable->Enabled = ( PIC_DeviceInfo.wCfgmask_wrcode != 0);
   Chk_CodeWriteEnable->Checked =
        ((m_displayed_config_word[0] & PIC_DeviceInfo.wCfgmask_wrcode) != 0);
   Chk_ccpmx->Checked = ((m_displayed_config_word[0] & PIC_DeviceInfo.wCfgmask_ccpmx)!=0);
   Chk_ccpmx->Enabled = (PIC_DeviceInfo.wCfgmask_ccpmx!=0);
#endif

   Ed_ProgramMemory->Text = IntToStr((int)PIC_DeviceInfo.lCodeMemSize);
   Ed_DataEepromMemory->Text=IntToStr((int)PIC_DeviceInfo.lDataEEPROMSizeInByte);


   // Some new PIC devices need to preserve Bandgap Calibration bits
   //      and oscillator calibration words. Show info about this:
   Lab_SavedBeforeErase->Caption = "";
   Lab_SavedBeforeErase->Color   = clBtnFace;
   Lab_SavedBeforeErase2->Enabled = FALSE;
   if( PIC_DeviceInfo.wCfgmask_bandgap!=0 ) // bandgap calibration bits, 0x3000 for 12F675
    { Lab_SavedBeforeErase2->Enabled = TRUE;
      if(PIC_lBandgapCalibrationBits>=0)
        { sprintf(str80,"bandgap_cal=0x%06lX",(long)PIC_lBandgapCalibrationBits);
          Lab_SavedBeforeErase->Caption = str80;
        } else Lab_SavedBeforeErase->Caption = "bandgap_cal:n/a";
    }
   if( PIC_DeviceInfo.lAddressOscCal>0 ) // oscillator calibration word, at 0x03FF for 12F675
    {                                   // (usually the very last word in the CODE memory)
      Lab_SavedBeforeErase2->Enabled = TRUE;
      if(PIC_lOscillatorCalibrationWord>=0)
        { sprintf(str80,"  oscillator_cal=0x%06lX",(long)PIC_lOscillatorCalibrationWord);
          Lab_SavedBeforeErase->Caption = Lab_SavedBeforeErase->Caption + AnsiString(str80);
          if( (PIC_lOscillatorCalibrationWord & 0xFF00) != 0x3400/*RETLW*/ )
              Lab_SavedBeforeErase->Color = clRed;

        } else Lab_SavedBeforeErase->Caption = Lab_SavedBeforeErase->Caption
           + "  oscillator_cal:n/a";
    }

   if( WinPic_iTestMode & WP_TEST_MODE_GUI_SPEED )
       APPL_LogEvent( "UpdateDeviceConfigTab: DONE ." );

   if(m_Updating>0) --m_Updating;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateToolWindow(void)  // Caution, don't call in FormCreate !
{
  if(ToolForm)
     ToolForm->ShowMsg("",TWMSG_NO_CHANGE);  // show FILENAME again
} // end TPicMain::UpdateToolWindow()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateOptionsDisplay(void)
{
   ++m_Updating;

   Chk_ProgCodeMem->Checked = (Config.iProgramWhat & PIC_PROGRAM_CODE) != 0;
   Chk_ProgDataMem->Checked = (Config.iProgramWhat & PIC_PROGRAM_DATA) != 0;
   Chk_ProgConfigMem->Checked=(Config.iProgramWhat & PIC_PROGRAM_CONFIG)!=0;
   Chk_UseBulkErase->Checked = Config.iUseCompleteChipErase;  // may be disabled !
   Chk_DisconnectAfterProg->Checked=Config.iDisconnectAfterProg;
   Chk_VerifyDiffVdds->Checked    = Config.iVerifyAtDifferentVoltages;
   if(PIC_HW_CanSelectVdd() )  // don't DISABLE this checkmark but..
        Chk_VerifyDiffVdds->Font->Color = clBlack;
    else // .. make it gray if it has no meaningfull function
        Chk_VerifyDiffVdds->Font->Color = clGray;

   Chk_DontCareForOsccal->Checked = Config.iDontCareForOsccal;
   Chk_DontCareForBGCalib->Checked= Config.iDontCareForBGCalib;
   Chk_ClrBeforeLoad->Checked     = Config.iClearBufBeforeLoad;
   Chk_VddBeforeMCLR->Checked     = Config.iNeedPowerBeforeRaisingMCLR; // read a long story in PIC_HW_ProgMode() !
         // Note: this MAY be contrary to PIC_DeviceInfo.wVppVddSequence,
         //  but the user may decide to change the Vpp/Vdd sequence
         //  depending on his programmer hardware, and to experiment
         //  with 'future' devices (which may cause problems similar to
         //  early chip revisions of the 16F628) .
   // Since 2005-10-25, the path into MBLAB's "device"-folder
   // can be specified here - so we don't have to copy those *.DEV-files :
   Ed_MplabDevDir->Text = Config.sz255MplabDevDir;

   // Since 2005-11-05, the port access driver can be selected :
   // possible values for T_CONFIG.iWhichPortAccessDriver :
   Rb_UseSMPORT->Checked = (Config.iWhichPortAccessDriver==CFG_PORTACCESS_SMPORT);
   Rb_UsePortTalk->Checked=(Config.iWhichPortAccessDriver==CFG_PORTACCESS_PORTTALK);
#ifndef USE_PORTTALK  /* AllowIoWrapper.cpp not included for copyright reasons ? */
   Rb_UsePortTalk->Enabled= FALSE; /* added 2005-11-05, see TSmPort.cpp for details */
#endif // ! USE_PORTTALK
   Rb_PortAccessGranted->Checked=(Config.iWhichPortAccessDriver==CFG_PORTACCESS_ALREADY_GRANTED);
   Rb_UseWinAPIOnly->Checked=(Config.iWhichPortAccessDriver==CFG_PORTACCESS_USE_API_ONLY);

   // group "Debugging"...
   Chk_SimulateOnly->Checked = PIC_PRG_iSimulateOnly;
   Chk_VerboseMsgs->Checked  = Config.iVerboseMessages;


   if(m_Updating>0) --m_Updating;
} // end TPicMain::UpdateOptionsDisplay()


//---------------------------------------------------------------------------
void __fastcall TPicMain::ProgOptionsChanged(TObject *Sender)
{
  if(m_Updating) return;

  if( Chk_ProgCodeMem->Checked   )
       Config.iProgramWhat |= PIC_PROGRAM_CODE;
  else Config.iProgramWhat &=~PIC_PROGRAM_CODE;
  if( Chk_ProgDataMem->Checked   )
       Config.iProgramWhat |= PIC_PROGRAM_DATA;
  else Config.iProgramWhat &=~PIC_PROGRAM_DATA;
  if( Chk_ProgConfigMem->Checked )
       Config.iProgramWhat |= PIC_PROGRAM_CONFIG;
  else Config.iProgramWhat &=~PIC_PROGRAM_CONFIG;
  Config.iUseCompleteChipErase = Chk_UseBulkErase->Checked; // may be passive, anyway
  Config.iDisconnectAfterProg= Chk_DisconnectAfterProg->Checked;
  Config.iVerifyAtDifferentVoltages= Chk_VerifyDiffVdds->Checked;
  Config.iDontCareForOsccal  = Chk_DontCareForOsccal->Checked;
  Config.iDontCareForBGCalib = Chk_DontCareForBGCalib->Checked;
  Config.iClearBufBeforeLoad = Chk_ClrBeforeLoad->Checked;
  Config.iNeedPowerBeforeRaisingMCLR = Chk_VddBeforeMCLR->Checked;  // read a long story in PIC_HW_ProgMode() !

  strncpy( Config.sz255MplabDevDir, Ed_MplabDevDir->Text.c_str(), 255 );

  // Since 2005-11-05, the port access driver can be selected ...
  //  but changing this will become effective after restarting WinPic only !
  if( Rb_UseWinAPIOnly->Checked )
     Config.iWhichPortAccessDriver=CFG_PORTACCESS_USE_API_ONLY;
  else if(Rb_UseSMPORT->Checked)
     Config.iWhichPortAccessDriver=CFG_PORTACCESS_SMPORT;
  else if(Rb_UsePortTalk->Checked)
     Config.iWhichPortAccessDriver=CFG_PORTACCESS_PORTTALK;
  else if(Rb_PortAccessGranted->Checked)
     Config.iWhichPortAccessDriver=CFG_PORTACCESS_ALREADY_GRANTED;

  // From group "Debugging" ...
  PIC_PRG_iSimulateOnly= Chk_SimulateOnly->Checked;
  Config.iVerboseMessages=Chk_VerboseMsgs->Checked;

  // From group "Algorithm" ... (removed as it became empty)


} // end TPicMain::ProgOptionsChanged()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateInterfaceTestDisplay(void)
{
 int i;
  ++m_Updating;
  i = PicHw_IsVppOn();
  Chk_TestVpp->Enabled     = (i>=0);
  Chk_TestVpp->Checked     = (i==1);
  i = PicHw_IsVddOn();
  Chk_TestVdd->Enabled     = (i>=0);
  Chk_TestVdd->Checked     = (i==1);
  i = PicHw_IsClockHigh();
  Chk_TestClock->Enabled   = (i>=0);
  Chk_TestClock->Checked   = (i==1);
  i = PicHw_IsDataOutHigh();
  Chk_TestData->Enabled    = (i>=0);
  Chk_TestData->Checked    = (i==1);
  i = PicHw_IsClockEnabled();
  Chk_ClockEnable->Enabled = (i>=0);
  Chk_ClockEnable->Checked = (i==1);
  i = PicHw_IsDataEnabled();
  Chk_DataEnable->Enabled  = (i>=0);
  Chk_DataEnable->Checked  = (i==1);
  i = PicHw_IsMclrPulledToGnd();
  Chk_PullMclrToGnd->Enabled = (i>=0);
  Chk_PullMclrToGnd->Checked = (i==1);
  i = PicHw_IsTargetConnected();
  Chk_ConnectICSPTarget->Enabled = (i>=0);
  Chk_ConnectICSPTarget->Checked = (i==1);


  if(PicHw_FuncPtr)
   { // Only if the currently used "hardware I/O functions" are valid,
     // (and only if the installed hardware is a "production grade" programmer):
     RB_VddLow->Enabled = (PicHw_FuncPtr->SelectVddLow.pFunc[0] != NULL);
     RB_VddLow->Checked = (PHWInfo.iPresentVddSelection == 0);
     RB_VddNorm->Enabled = (PicHw_FuncPtr->SelectVddNorm.pFunc[0] != NULL);
     RB_VddNorm->Checked = (PHWInfo.iPresentVddSelection == 1);
     RB_VddHigh->Enabled = (PicHw_FuncPtr->SelectVddHigh.pFunc[0] != NULL);
     RB_VddHigh->Checked = (PHWInfo.iPresentVddSelection == 2);
   }

  UpdateInterfaceInputSignalDisplay();  // "data" input, "OK"-button, and indicator LEDs

  if(m_Updating>0)
   --m_Updating;
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::UpdateInterfaceInputSignalDisplay(void)
{
 int i;
  ++m_Updating;


  i = PIC_HW_GetDataBit();
  if(i>=0) Lab_TestDataIn->Caption = IntToStr( i );
      else Lab_TestDataIn->Caption = "n/a";

  i = PIC_HW_SetRedLed( -1/*don't change, just get state*/ );
  if(i>=0)
    { Lab_RedLED->Enabled = TRUE;
      Shp_RedLED->Brush->Color = (i==0)?clGray:clRed;
    }
   else
    { Lab_RedLED->Enabled = FALSE;
      Shp_RedLED->Brush->Color = clLtGray;
    }

  i = PIC_HW_SetGreenLed( -1/*don't change, just get state*/ );
  if(i>=0)
    { Lab_GreenLED->Enabled = TRUE;
      Shp_GreenLED->Brush->Color = (i==0)?clGray:clLime;
    }
   else
    { Lab_GreenLED->Enabled = FALSE;
      Shp_GreenLED->Brush->Color = clLtGray;
    }

  i = PicHw_GetOkButtonState();
  if(i>=0)
    { Lab_OkButton->Enabled = TRUE;
      if(i==0) Lab_OkButton->Caption = TE("button up") ;
         else  Lab_OkButton->Caption = TE("button DOWN") ;
    }
  else
    { Lab_OkButton->Enabled = FALSE;
      Lab_OkButton->Caption = TE("(no button)") ;
    }


  if(m_Updating>0)
   --m_Updating;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::Chk_TestXXXClick(TObject *Sender)
{
  if(m_Updating>0) return;

  if (! PIC_HW_SetClockAndData(
                           Chk_TestClock->Checked,  /* PIC - clock */
                           Chk_TestData->Checked)) /* PIC - data  */
   {
    Mem_Messages->Lines->Add( TE("PIC- Clock/Data failed") );
   }
  if (! PIC_HW_SetVpp(     Chk_TestVpp->Checked ) )
   {
    Mem_Messages->Lines->Add( TE("PIC- Vpp failed") );
   }
}
//---------------------------------------------------------------------------


void __fastcall TPicMain::Chk_TestVddClick(TObject *Sender)
{
  if(m_Updating>0) return;

  if (! PIC_HW_SetVdd( Chk_TestVdd->Checked ) )
   {
    Mem_Messages->Lines->Add( TE("PIC- Vdd failed") );
   }
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Chk_ClockEnableClick(TObject *Sender)
{
  if(m_Updating>0) return;

  if (! PIC_HW_SetClockEnable( Chk_ClockEnable->Checked ) )
   {
    Mem_Messages->Lines->Add( TE("PIC- ClockEnable failed") );
   }
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Chk_DataEnableClick(TObject *Sender)
{
  if(m_Updating>0) return;

  if (! PIC_HW_SetDataEnable( Chk_DataEnable->Checked ) )
   {
    Mem_Messages->Lines->Add( TE("PIC- DataEnable failed") );
   }
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Chk_PullMclrToGndClick(TObject *Sender)
{  // since 2003-01-22 ...  for "AN589" where D4=HIGH pulls MCLR active LOW
  if(m_Updating>0) return;
  PIC_HW_PullMclrToGnd( Chk_PullMclrToGnd->Checked );
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Chk_ConnectICSPTargetClick(TObject *Sender)
{
  if(m_Updating>0) return;
  if( Chk_ConnectICSPTarget->Checked )
        PIC_HW_ConnectToTarget(); // since 2002-09-09 .
   else PIC_HW_DisconnectFromTarget(); // nothing "else" in this special case !

   UpdateInterfaceTestDisplay();  // since 2004-01-27, because VPP(!) may be affected
}


void __fastcall TPicMain::RB_VddLowClick(TObject *Sender)
{
  if(m_Updating>0) return;
  Config.iIdleSupplyVoltage = 0; /* low supply voltage (typically 2.X volts) */
  if (! PIC_HW_SelectVdd( Config.iIdleSupplyVoltage ) )
    Mem_Messages->Lines->Add( TE("PIC- SelectVddLow failed") );
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::RB_VddNormClick(TObject *Sender)
{
  if(m_Updating>0) return;
  Config.iIdleSupplyVoltage = 1; /* normal supply voltage */
  if (! PIC_HW_SelectVdd( Config.iIdleSupplyVoltage ) )
    Mem_Messages->Lines->Add( TE("PIC- SelectVddNorm failed") );
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::RB_VddHighClick(TObject *Sender)
{
  if(m_Updating>0) return;
  Config.iIdleSupplyVoltage = 2; /* high supply voltage */
  if (! PIC_HW_SelectVdd( Config.iIdleSupplyVoltage ) )
    Mem_Messages->Lines->Add( TE("PIC- SelectVddHigh failed") );
}
//---------------------------------------------------------------------------


static int WinPicMain_iIntfItemIndex2InterfaceType[100];

//---------------------------------------------------------------------------
void __fastcall TPicMain::UpdateInterfaceType(int interface_type)
{
 int i;
 char str80[81];
  ++m_Updating;

  // Set the Items in the interface selection combo (TComboBox.Items = TStrings)
  // Note: This is only the bloody user interface !
  Combo_InterfaceType->Items->Clear();
  Combo_InterfaceType->Items->Add( TE("(unknown)") );
  WinPicMain_iIntfItemIndex2InterfaceType[0]=0;
  Combo_InterfaceType->Items->Add( TE("COM84 programmer for serial port") );
  WinPicMain_iIntfItemIndex2InterfaceType[1]=PIC_INTF_TYPE_COM84;
  Combo_InterfaceType->Items->Add( TE("JDM (2) for serial port") );
  WinPicMain_iIntfItemIndex2InterfaceType[2]=PIC_INTF_TYPE_JDM2;
  Combo_InterfaceType->Items->Add( TE("PIP84 by SM6LKM, Data->PAPER (Pin12)") );
  WinPicMain_iIntfItemIndex2InterfaceType[3]= PIC_INTF_TYPE_PIP84_V1;
  Combo_InterfaceType->Items->Add( TE("PIP84 by SM6LKM, Data->ACK (Pin10)") );
  WinPicMain_iIntfItemIndex2InterfaceType[4]= PIC_INTF_TYPE_PIP84_V2;
  Combo_InterfaceType->Items->Add( TE("PIC Flash prog by SM6LKM (2002-10)" ));
  WinPicMain_iIntfItemIndex2InterfaceType[5]= PIC_INTF_TYPE_LKM_FLASHPR_V1;
  Combo_InterfaceType->Items->Add( TE("Tait, 7406(inverter)+4066(switch)" ));
  WinPicMain_iIntfItemIndex2InterfaceType[6]= PIC_INTF_TYPE_TAIT_7406_4066;
  Combo_InterfaceType->Items->Add( TE("Tait, 7407(driver) + 4066(switch)") );
  WinPicMain_iIntfItemIndex2InterfaceType[7]= PIC_INTF_TYPE_TAIT_7407_4066;
  Combo_InterfaceType->Items->Add( TE("Tait, 7406(inverter)+PNP transistor") );
  WinPicMain_iIntfItemIndex2InterfaceType[8]= PIC_INTF_TYPE_TAIT_7406_PNP;
  Combo_InterfaceType->Items->Add( TE("Tait, 7407(driver) + PNP transistor") );
  WinPicMain_iIntfItemIndex2InterfaceType[9]= PIC_INTF_TYPE_TAIT_7407_PNP;
  Combo_InterfaceType->Items->Add( TE("Microchip AN589") );
  WinPicMain_iIntfItemIndex2InterfaceType[10]= PIC_INTF_TYPE_LPT_AN589;
  Combo_InterfaceType->Items->Add( TE("Custom, on LPT port, defined by FILE") );
  WinPicMain_iIntfItemIndex2InterfaceType[11]= PIC_INTF_TYPE_CUSTOM_LPT;
  Combo_InterfaceType->Items->Add( TE("Custom, on COM port, defined by FILE") );
  WinPicMain_iIntfItemIndex2InterfaceType[12]= PIC_INTF_TYPE_CUSTOM_COM;
  Combo_InterfaceType->Items->Add( TE("Custom, on any port, from plugin-DLL") );
  WinPicMain_iIntfItemIndex2InterfaceType[13]= PIC_INTF_TYPE_PLUGIN_DLL;

  m_fUseSerialPort = FALSE;
  switch(interface_type)  // a PIC_INTF_TYPE_xxx - constant
   {
    case PIC_INTF_TYPE_COM84:     // serial, clock=RTS, data=DTR+CTS, Vpp=TXD
         Combo_InterfaceType->ItemIndex = 1;
         m_fUseSerialPort = TRUE;
         break;
    case PIC_INTF_TYPE_JDM2:      // serial, clock=RTS, data=DTR+CTS, Vpp=TXD,
               // plus some precautions to charge / discharge two capacitors
         Combo_InterfaceType->ItemIndex = 2;
         m_fUseSerialPort = TRUE;
         break;
    case PIC_INTF_TYPE_PIP84_V1:         // parallel, used by SM6LKM, RB7->PAPER
         Combo_InterfaceType->ItemIndex = 3;
         m_fUseSerialPort = FALSE;
         break;
    case PIC_INTF_TYPE_PIP84_V2:         // parallel, used by SM6LKM, RB7->ACKN
         Combo_InterfaceType->ItemIndex = 4;
         m_fUseSerialPort = FALSE;
         break;
    case PIC_INTF_TYPE_LKM_FLASHPR_V1:
         Combo_InterfaceType->ItemIndex = 5;
         m_fUseSerialPort = FALSE;
         break;
    case PIC_INTF_TYPE_TAIT_7406_4066:   // parallel, by David Tait, 1st way
         Combo_InterfaceType->ItemIndex = 6;
         m_fUseSerialPort = FALSE;
         break;
    case PIC_INTF_TYPE_TAIT_7407_4066:   // parallel, by David Tait, 2nd way
         Combo_InterfaceType->ItemIndex = 7;
         m_fUseSerialPort = FALSE;
         break;
    case PIC_INTF_TYPE_TAIT_7406_PNP :   // parallel, by David Tait, 3rd way
         Combo_InterfaceType->ItemIndex = 8;
         m_fUseSerialPort = FALSE;
         break;
    case PIC_INTF_TYPE_TAIT_7407_PNP :   // parallel, by David Tait, 4th way
         Combo_InterfaceType->ItemIndex = 9;
         m_fUseSerialPort = FALSE;
         break;
    case PIC_INTF_TYPE_LPT_AN589:  // parallel, Microchip's Application Note "AN589"
         Combo_InterfaceType->ItemIndex = 10;
         m_fUseSerialPort = FALSE;
         break;
    case PIC_INTF_TYPE_CUSTOM_LPT:  // "custom" interface on LPT, I/O lines defined by file
         Combo_InterfaceType->ItemIndex = 11;
         m_fUseSerialPort = FALSE;
         break;
    case PIC_INTF_TYPE_CUSTOM_COM:  // "custom" interface on COM, I/O lines defined by file
         Combo_InterfaceType->ItemIndex = 12;
         m_fUseSerialPort = TRUE;
         break;
    case PIC_INTF_TYPE_PLUGIN_DLL:  // "custom" interface on any port, using a plugin-DLL
         Combo_InterfaceType->ItemIndex = 13;
         m_fUseSerialPort = FALSE;
         break;

    default:
         Combo_InterfaceType->ItemIndex = 0;
         Txt_InterfaceType->Caption = TE("Illegal interface code number");
         break;
   } // end switch(m_displayed_interface_type)

  Ed_CustomInterfaceDefFile->Text = Config.sz80InterfaceSupportFile;
  if(  (interface_type==PIC_INTF_TYPE_CUSTOM_LPT)
     ||(interface_type==PIC_INTF_TYPE_CUSTOM_COM) )
   {
     Ed_CustomInterfaceDefFile->Enabled = TRUE;
     Ed_CustomInterfaceDefFile->Color = clWindow;
   }
  else if( interface_type==PIC_INTF_TYPE_PLUGIN_DLL )
   { Ed_CustomInterfaceDefFile->Text = Config.sz80InterfacePluginDLL;
     Ed_CustomInterfaceDefFile->Enabled = TRUE;
     Ed_CustomInterfaceDefFile->Color = clWindow;
   }
  else
   {
     Ed_CustomInterfaceDefFile->Enabled = FALSE;
     Ed_CustomInterfaceDefFile->Color = clBtnFace;
   }

  Combo_InterfacePort->Color = clWindow;
  Rb_UseWinAPIOnly->Color = clBtnFace;
  if(m_fUseSerialPort)
   {
    Combo_InterfacePort->Enabled = TRUE;
    Combo_InterfacePort->Items->Clear();
    Combo_InterfacePort->Items->Add("(unknown)");
    for(i=1;i<=16;++i)
     { Combo_InterfacePort->Items->Add("COM"+IntToStr(i));
     }
    if(Config.iComPortNr>=0 && Config.iComPortNr<=16)
          Combo_InterfacePort->ItemIndex = Config.iComPortNr;
     else Combo_InterfacePort->ItemIndex = 0;
    if( Config.iComIoAddress != 0 )
     {  // use a "non-standard" I/O-address for the COM-port, entered manually:
        sprintf(str80,"%04X",(int)Config.iComIoAddress);
        Ed_IoPortAddress->ReadOnly = FALSE;
        Ed_IoPortAddress->Color = clWindow;
     }
    else
     {  // use a "standard" COM-port with the default I/O address :
        switch( Config.iComPortNr )
         { case 1:  strcpy(str80, "03F8");  break;
           case 2:  strcpy(str80, "02F8");  break;
           case 3:  strcpy(str80, "03E8");  break;
           case 4:  strcpy(str80, "02E8");  break;
           default: strcpy(str80, "-std-"); break;
         }
        Ed_IoPortAddress->ReadOnly = TRUE;
        Ed_IoPortAddress->Color = clBtnFace;
     }
    Ed_IoPortAddress->Text = str80;

    if( Config.iComPortNr>4 && !Rb_UseWinAPIOnly->Checked )
     { APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE(
         "COM ports above 4 can be accessed via windows API only (on Options tab) !") );
       m_iMessagePanelUsage = MP_USAGE_ERROR;
       Combo_InterfacePort->Color = clRed;
       Rb_UseWinAPIOnly->Color = clRed;
     }
   }
  else  // not serial but parallel port ?
  if( interface_type != PIC_INTF_TYPE_PLUGIN_DLL )
   {
    Combo_InterfacePort->Enabled = TRUE;
    Combo_InterfacePort->Items->Clear();
    Combo_InterfacePort->Items->Add( TE("(unknown)") );
    Combo_InterfacePort->Items->Add("LPT1");
    Combo_InterfacePort->Items->Add("LPT2");
    Combo_InterfacePort->ItemIndex = Config.iLptPortNr;

    if(Config.iLptIoAddress == 0)
        strcpy(str80, "-std-");
    else
        sprintf(str80,"%04X",(int)Config.iLptIoAddress);
    Ed_IoPortAddress->Text = str80;
    Ed_IoPortAddress->ReadOnly = FALSE;
    Ed_IoPortAddress->Color = clWindow;

    // To drive an interface on the LPT port, WinPic must use
    // SMPORT or PORTTALK. So the option "use windows API only"
    // doesn't work here. Inform the user about this problem :
    if( Rb_UseWinAPIOnly->Checked )
     { APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE(
          "LPT port interface requires SMPORT or PortTalk (on Options tab) !") );
       m_iMessagePanelUsage = MP_USAGE_ERROR;
       Combo_InterfacePort->Color = clRed;
     }
   } // end if < interface on LPT port >
  else
   { // neither SERIAL nor PARALLEL port (but a hardware-access driver in a DLL)
    Combo_InterfacePort->Items->Clear();
    Combo_InterfacePort->Enabled = FALSE;
    Ed_IoPortAddress->Text = "";
    Ed_IoPortAddress->ReadOnly = TRUE;
    Ed_IoPortAddress->Color = clBtnFace;
   } // end else < neither serial nor parallel port >

  Ed_ExtraRdDelay->Text = IntToStr(Config.iExtraRdDelay_us);
  Ed_ExtraClkDelay->Text= IntToStr(Config.iExtraClkDelay_us);
  Chk_SlowInterface->Checked = Config.iSlowInterface;


  UpdateInterfaceTestDisplay();

  if(m_Updating>0) --m_Updating;

} // end UpdateInterfaceType()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::Menu_ProgramDeviceClick(TObject *Sender)
{
  PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
  QueryAndApplyHexEditIfRequired();
  ProgramPic();  // try to program all data which have been loaded before.
  UpdateInterfaceTestDisplay();
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::MI_ProgCfgWordClick(TObject *Sender)
{
  DWORD dwTemp4[4];

   APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
        TE("Programming CONFIG-WORD") );
   dwTemp4[0] = PicBuf_GetConfigWord(0);
   dwTemp4[1] = PicBuf_GetConfigWord(1);
   if(PIC_PRG_Program( dwTemp4,  // program config word(s) :
                       1 + // number of words to be programmed ...
                        ((PIC_DeviceInfo.wCfgmask2_used==0x0000)?0:1),  // 2nd cfg word ?
                       PicPrg_GetConfigWordMask(),   // mask to be verified
                       PIC_DeviceInfo.iCmd_LoadProg,
                       PIC_DeviceInfo.iCmd_ReadProg,
                       PIC_DeviceInfo.lConfWordAdr))
    {
      APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
           TE("Programming CONFIG-WORD done.") );
    }
   else
    {
      APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
           TE("Programming CONFIG-WORD FAILED.") );
    }

  if(Config.iDisconnectAfterProg)
     DisconnectTarget();  // since 2002-09-26 . Suggested by Johan Bodin.

  UpdateInterfaceTestDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::MI_ProgIDlocsClick(TObject *Sender)
{
   APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
        TE("Programming ID-locations") );
   if(PIC_PRG_Program(PicBuf[PIC_BUF_CONFIG].pdwData,
                              4, // number of words to be programmed
                         0x3FFF, // mask for programming and verification
              PIC_DeviceInfo.iCmd_LoadProg, // 'load' command pattern
              PIC_DeviceInfo.iCmd_ReadProg, // 'read' command pattern (for verifying)
              PIC_DeviceInfo.lConfMemBase)) // target start address
    {
      APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
           TE("Programming ID-LOCATIONS done.") );
    }
   else
    {
      APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
           TE("Programming ID-LOCATIONS FAILED.") );
    }

  if(Config.iDisconnectAfterProg)
     DisconnectTarget();  // since 2002-09-26 . Suggested by Johan Bodin.

  UpdateInterfaceTestDisplay();
}
//---------------------------------------------------------------------------


void __fastcall TPicMain::Erase1Click(TObject *Sender)
{
 char *pszMsg;

  PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
  if(PIC_DeviceInfo.iCodeMemType==PIC_MT_FLASH )
   {
    if(! Config.iUseCompleteChipErase )
     {
      if(MessageBox(  Handle, // handle of owner window
        TE("The BULK ERASE option is disabled\n   in the programmer options.\n Erase EVERYTHING anyway ?"),
        TE("Confirm ERASE ALL"),
          MB_ICONQUESTION | MB_YESNOCANCEL | MB_DEFBUTTON2 ) != IDYES )
        return;
     } // end if(! Config.iUseCompleteChipErase )
    pszMsg = TE("Erasing ..."); // translated message used in various places..
    Pnl_Message->Caption = pszMsg;
    if(ToolForm) ToolForm->ShowMsg(pszMsg,TWMSG_NO_ERROR);
    Update();
    if( PIC_PRG_Erase( PIC_ERASE_ALL | PIC_SAVE_CALIBRATION) )  // here in 'manual erase' mode
      {
        pszMsg = TE("Device has been erased."); // translation used more than once !
        if(ToolForm) ToolForm->ShowMsg( pszMsg, TWMSG_SUCCESS );
        if( PIC_iHaveErasedCalibration
            && ((PIC_DeviceInfo.wCfgmask_bandgap != 0) || (PIC_DeviceInfo.lAddressOscCal >= 0)) )
         {
           APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
             TE("Device has been erased. PROGRAM TO RESTORE CALIB BITS !!") );
           m_iMessagePanelUsage = MP_USAGE_WARNING;
         }
        else
         {
           APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, pszMsg );
           m_iMessagePanelUsage = MP_USAGE_INFO;
         }
      }
     else
      {
        pszMsg = TE( "Erasing FAILED !" );
        APPL_ShowMsg( APPL_CALLER_MAIN, 0, pszMsg );
        if(ToolForm) ToolForm->ShowMsg( pszMsg, TWMSG_ERROR );
      }
   }
  else
   {
     Pnl_Message->Caption = TE( "Must not erase non-FLASH device, check \"Device, Config\" !") ;
     m_iMessagePanelUsage = MP_USAGE_WARNING;
   }
  // Some rare devices have some CALIBRATION BITS which are read before erase.
  // Show the state of these bits on the "Device/Config" tab:
  UpdateDeviceConfigTab( TRUE/*fUpdateHexWord*/ );
  UpdateInterfaceTestDisplay();
} // end Erase1Click()
//---------------------------------------------------------------------------

void __fastcall TPicMain::Read1Click(TObject *Sender)
{
 BOOL ok;
 BOOL not_blank;
  PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
  m_iMessagePanelUsage = MP_USAGE_BUSY;
  m_fPicDeviceConflict = FALSE;
  Update();

  APPL_iUserBreakFlag = 0;
  ok = PIC_PRG_ReadAll(false, &not_blank);  // READ, not only blank check

  if(Config.iDisconnectAfterProg)
     DisconnectTarget();  // since 2002-09-26 . Suggested by Johan Bodin.

  UpdateAllSheets();  // incl  UpdateInterfaceTestDisplay()
  Btn_ApplyIdLocs->Enabled = FALSE;

  if( !ok )
   { // reading not ok, for any strange reason it was "aborted" ...
     APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, TE( "Action aborted") );
     m_iMessagePanelUsage = MP_USAGE_ERROR;
     return;
   }

  if( !not_blank ) // not not blank means "blank", aka "completely empty"..
   {
     APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
                   TE( "Reading PIC FAILED (maybe blank)." ) );
     m_iMessagePanelUsage = MP_USAGE_WARNING;
   }
  else  // reading ok, AND the PIC is *not* blank ...
   {
       if( m_fPicDeviceConflict )
        { APPL_ShowMsg(APPL_CALLER_PIC_PRG,0,
             TE( "Reading done, Conflict: selected device = %s,  read = %s" ),
                     PIC_DeviceInfo.sz40DeviceName, m_sz80DetectedPicDevName );
        }
       else
        { APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
             TE( "Reading PIC ok.") );
        }
       m_iMessagePanelUsage = MP_USAGE_INFO;
    }
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::BlankCheck1Click(TObject *Sender)
{
 BOOL read_ok, not_blank;
 char *pszMsg;
 int  iErrorState;
  PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
  pszMsg = TE( "Blank Checking ..." );
  Pnl_Message->Caption = pszMsg;
  if(ToolForm) ToolForm->ShowMsg( pszMsg, TWMSG_NO_ERROR );
  m_iMessagePanelUsage = MP_USAGE_BUSY;
  Update();
  APPL_iUserBreakFlag = 0;  
  read_ok = PIC_PRG_ReadAll(true, &not_blank); //  blank check only,  do NOT READ to buffer
  UpdateInterfaceTestDisplay();
  if(read_ok)
   {
    if(not_blank)
     { pszMsg = TE( "Device is NOT blank.");
       iErrorState = TWMSG_ERROR;
     }
    else
     { pszMsg = TE( "Device is blank.");
       iErrorState = TWMSG_SUCCESS;
     }
   }
  else  // reading not ok, for any strange reason it was "aborted" ...
   { pszMsg = TE( "Action aborted");
     iErrorState = TWMSG_ERROR;
   }
  APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0, pszMsg );
  if(ToolForm) ToolForm->ShowMsg( pszMsg, iErrorState );
  m_iMessagePanelUsage = MP_USAGE_INFO;
}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
void __fastcall TPicMain::Btn_ClearMessagesClick(TObject *Sender)
{
  Mem_Messages->Clear();
  Pnl_Message->Caption = "";
  m_iMessagePanelUsage = MP_USAGE_NOTHING;
}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
void __fastcall TPicMain::Clearbuffer1Click(TObject *Sender)
{
  /* Initialize buffers to imitate the erased state. */
  PIC_HEX_ClearBuffers();
  REd_CodeMem->Modified = FALSE;
  REd_DataMem->Modified = FALSE;
  UpdateAllSheets(); // make the changes visible on the screen
  Btn_ApplyIdLocs->Enabled = FALSE;
}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
void __fastcall TPicMain::ClearFusesClick(TObject *Sender)
{
  /* Set the "default" configuration word : */
  if( WinPic_i32CmdLineOption_OverrideConfigWord >= 0)
    PicBuf_SetConfigWord( 0, (WORD)WinPic_i32CmdLineOption_OverrideConfigWord );
  else
    PicBuf_SetConfigWord( 0,
             PIC_DeviceInfo.wCfgmask_unused  // all unused bits HIGH="ERASED"
          |  PIC_DeviceInfo.wCfgmask_unknown // all UNKNOWN bits also HIGH
          |  PIC_DeviceInfo.wCfgmask_cpbits  //  Code memory protection OFF
          | (PIC_DeviceInfo.wCfgmask_pwrte^PIC_DeviceInfo.wCfgmask_inv_pwrte)
          |  PIC_DeviceInfo.wCfgmask_osc_rc  // select RC oscillator configuration
          |  PIC_DeviceInfo.wCfgmask_cpd     //  Data EEPROM Protection off
          |  PIC_DeviceInfo.wCfgmask_lvp     //  Low Voltage Prog. Enabled
          |  PIC_DeviceInfo.wCfgmask_boden); //  Brown-out Detect & Reset Enabled
  UpdateAllSheets(); // make the changes visible on the screen
  Btn_ApplyIdLocs->Enabled = FALSE;
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Verify1Click(TObject *Sender)
{
  PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
  QueryAndApplyHexEditIfRequired();
  if( VerifyPic() )
   {
    if(Config.iDisconnectAfterProg)
       DisconnectTarget();  // since 2002-09-26 . Suggested by Johan Bodin.
   }
  else  // VerifyPic failed :
   {
    // If 'verify' failed, don't disconnect from target. Won't run anyway !
   }

  UpdateInterfaceTestDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::About1Click(TObject *Sender)
{
  AbtForm->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Index1Click(TObject *Sender)
{
  Application->HelpContext( HELPID_MAIN_INDEX );
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::MI_FAQsClick(TObject *Sender)
{
  Application->HelpContext( HELPID_FAQ_LISTS );
}
//---------------------------------------------------------------------------


void __fastcall TPicMain::M_DumpDevListClick(TObject *Sender)
{
   PicDev_DumpDeviceListToFile("DevListDump.txt");
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Combo_PartNameChange(TObject *Sender)
{
 T_PicDeviceInfo MyDeviceInfo;

  if (m_Updating) return;
  if( PicDev_GetDeviceInfoByName( Combo_PartName->Text.c_str(), &MyDeviceInfo ) >= 0 )
         PIC_PRG_SetDeviceType( &MyDeviceInfo );
    else PIC_PRG_SetDeviceType( PIC_DEV_TYPE_UNKNOWN );
  UpdateDeviceConfigTab( TRUE/*fUpdateHexWord*/ );
  UpdateOptionsDisplay();    // a lot may have changed, depending on chip type
  UpdateIdAndConfMemDisplay(); // number of 'valid locations' may have changed
  UpdateCodeMemDisplay();    // addresses and instruction width may have changed
  UpdateDataMemDisplay();    // address range for DATA(~EEPROM) memory may have changed

  // Now, ONLY HERE AFTER THE USER SELECTED A NEW DEVICE, check the 'Vdd/Vpp'
  // sequence. If it is defined in the device settings, and is incompatible
  // to the current state on the "Other Options" panel, show a warning .
  // Why not simply switch without asking ? Because for many devices,
  //   the proper Vdd/Vpp switching sequence is UNKNOWN or NOWHERE SPECIFIED !
  if( ( (PIC_DeviceInfo.wVppVddSequence==PROGMODE_VPP_THEN_VDD/*0*/) && (Config.iNeedPowerBeforeRaisingMCLR) )
    ||( (PIC_DeviceInfo.wVppVddSequence==PROGMODE_VDD_THEN_VPP/*1*/) && (!Config.iNeedPowerBeforeRaisingMCLR) )
    )
   { // this message should occurr after switching from 16F628 to F818 (for example)
    PageControl1->ActivePage = TS_Options;
    Chk_VddBeforeMCLR->Color = clRed;
    if(MessageBox(  Handle, // handle of owner window
       TE("Conflicting Vpp/Vdd switching sequence on the Options tab.\n Change the sequence to match the new device info ?"),
       TE("Vpp/Vdd switching sequence possibly wrong"),
       MB_ICONQUESTION | MB_YESNOCANCEL | MB_DEFBUTTON1 ) == IDYES )
        { // user agrees to let the program select the 'proper'(??) setting...
          if(PIC_DeviceInfo.wVppVddSequence==PROGMODE_VDD_THEN_VPP)
             Config.iNeedPowerBeforeRaisingMCLR = 1;
          else
             Config.iNeedPowerBeforeRaisingMCLR = 0;
        }
    UpdateDeviceConfigTab( TRUE/*fUpdateHexWord*/ );
    UpdateOptionsDisplay();
    Chk_VddBeforeMCLR->Color = clBtnFace;
    Update(); Sleep(500);
    PageControl1->ActivePage = TS_DeviceConfig;
   } // end if < Vpp/Vdd switching sequence POSSIBLY wrong >
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::SetInterfaceInternal(int iInterfaceType)
{
  if(PIC_HW_SetInterfaceType( iInterfaceType ) )
         Txt_InterfaceType->Caption = TE( "SetInterfaceType ok."  );
    else Txt_InterfaceType->Caption = TE( "Error in SetIntf() : " )
                     + AnsiString(PicHw_sz255LastError);
  Config.pic_interface_type = PIC_HW_interface.type; // after checking..
  UpdateInterfaceType(iInterfaceType);
  UpdateOptionsDisplay();
} // end SetInterfaceInternal()

//---------------------------------------------------------------------------
void __fastcall TPicMain::Btn_InitInterfaceClick(TObject *Sender)
{
 int iInterfaceType;

  iInterfaceType = Combo_InterfaceType->ItemIndex;
  if(iInterfaceType<0) iInterfaceType=0;
  iInterfaceType = WinPicMain_iIntfItemIndex2InterfaceType[ iInterfaceType ];

  if( iInterfaceType == PIC_INTF_TYPE_PLUGIN_DLL )
       strncpy( Config.sz80InterfacePluginDLL,   Ed_CustomInterfaceDefFile->Text.c_str(), 80 );
  else strncpy( Config.sz80InterfaceSupportFile, Ed_CustomInterfaceDefFile->Text.c_str(), 80 );
  PIC_HW_SetInterfaceType( iInterfaceType );
  UpdateInterfaceType(PIC_HW_interface.type);
  TestTheInterface();
  UpdateOptionsDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Combo_InterfaceTypeChange(TObject *Sender)
{
 int iInterfaceType;

  if (m_Updating) return;
  if( APPL_i32CustomizeOptions & APPL_CUST_NO_INTERFACE_SELECTION )
     return;

  iInterfaceType = Combo_InterfaceType->ItemIndex;
  if(iInterfaceType<0) iInterfaceType=0;
  iInterfaceType = WinPicMain_iIntfItemIndex2InterfaceType[ iInterfaceType ];
  if( iInterfaceType == PIC_INTF_TYPE_PLUGIN_DLL )
       strncpy( Config.sz80InterfacePluginDLL,   Ed_CustomInterfaceDefFile->Text.c_str(), 80 );
  else strncpy( Config.sz80InterfaceSupportFile, Ed_CustomInterfaceDefFile->Text.c_str(), 80 );
  SetInterfaceInternal( iInterfaceType );
  Config_changed |= APPL_CALLER_SAVE_CFG ;  // save on exit
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Btn_SelectCustomInterfaceClick(TObject *Sender)
{
 AnsiString sFname;
  int interface_type;

  if (m_Updating) return;
  if( APPL_i32CustomizeOptions & APPL_CUST_NO_INTERFACE_SELECTION )
     return;


  ++m_Updating;

  interface_type = Combo_InterfaceType->ItemIndex;
  if(interface_type<0)
     interface_type=0;
  interface_type = WinPicMain_iIntfItemIndex2InterfaceType[interface_type];


  // see help on TOpenDialog .
  OpenDialog->Title = TE( "Load custom interface definition file (don't change dir)" );
  if( interface_type == PIC_INTF_TYPE_PLUGIN_DLL )
   { OpenDialog->DefaultExt = "dll";
     OpenDialog->InitialDir = ExtractFilePath(Application->ExeName) + "interface_dlls";
     OpenDialog->Filter = "Plugin DLLs (*.dll)|*.dll";
   }
  else
   { OpenDialog->DefaultExt = "ini";
     OpenDialog->InitialDir = ExtractFilePath(Application->ExeName) + "interfaces";
     OpenDialog->Filter = "INI files (*.ini)|*.ini";
   }
  // Warning: TOpenDialog is buggy ! Sometimes, if there is something fishy with 'FileName',
  //          it simply won't open ?  Cured ONE of these situations as follows:
  // ex:  OpenDialog->FileName = OpenDialog->InitialDir + "\\" + Ed_CustomInterfaceDefFile->Text;
  sFname = OpenDialog->InitialDir + "\\" + Ed_CustomInterfaceDefFile->Text;
  if( FileExists(sFname) )
    { OpenDialog->FileName = sFname;  // rotten dialog ... didn't open when filename was empty !
    }
  else
    { if( interface_type == PIC_INTF_TYPE_PLUGIN_DLL )
          OpenDialog->FileName = OpenDialog->InitialDir + "\\*.dll";
      else
          OpenDialog->FileName = OpenDialog->InitialDir + "\\*.ini";  // dig this, TOpenDialog ?!
    }
  OpenDialog->HelpContext = HELPID_CUSTOM_INTERFACES;
  OpenDialog->Options.Clear();
  OpenDialog->Options << ofFileMustExist << ofHideReadOnly << ofNoChangeDir << ofShowHelp;
  if (OpenDialog->Execute())
  {
    Ed_CustomInterfaceDefFile->Text = ExtractFileName(OpenDialog->FileName);
    if( interface_type == PIC_INTF_TYPE_PLUGIN_DLL )
         strncpy( Config.sz80InterfacePluginDLL,   Ed_CustomInterfaceDefFile->Text.c_str(), 80 );
    else strncpy( Config.sz80InterfaceSupportFile, Ed_CustomInterfaceDefFile->Text.c_str(), 80 );
    SetInterfaceInternal(Config.pic_interface_type);
    Config_changed |= APPL_CALLER_SAVE_CFG ;  // save on exit
  }

  if( m_Updating )
    --m_Updating;
}
//---------------------------------------------------------------------------



void __fastcall TPicMain::Combo_InterfacePortChange(TObject *Sender)
{
 char str80[81];
 int iInterfaceType;

  if( m_Updating) return;
  if( APPL_i32CustomizeOptions & APPL_CUST_NO_INTERFACE_SELECTION )
     return;

  iInterfaceType = Combo_InterfaceType->ItemIndex;
  if(iInterfaceType<0) iInterfaceType=0;
  iInterfaceType = WinPicMain_iIntfItemIndex2InterfaceType[ iInterfaceType ];

  // ex: strncpy(Config.sz80InterfaceSupportFile, Ed_CustomInterfaceDefFile->Text.c_str(), 80);
  if( m_fUseSerialPort )
   {
     if( Config.iComPortNr != Combo_InterfacePort->ItemIndex )
      { // forget "unusual" I/O-address when changing port number :
        Config.iComIoAddress = 0;
      }
     Config.iComPortNr = Combo_InterfacePort->ItemIndex;
     Ed_IoPortAddress->Text = "";
     Ed_IoPortAddress->ReadOnly = TRUE;
   }
  else // not SERIAL but PARALLEL interface... please don't ask for USB ;-)
   {
     Config.iLptPortNr = Combo_InterfacePort->ItemIndex;
   }
  SetInterfaceInternal( iInterfaceType );
  Config_changed |= APPL_CALLER_SAVE_CFG ;  // save changes on exit
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Ed_IoPortAddressChange(TObject *Sender)
{
 char str8[9];
 long l;

  if(m_Updating)
    return;

  strncpy(str8,Ed_IoPortAddress->Text.c_str(), 8);
  l = HexStringToLongint(4, str8);  // PC's "I/O"-adresses have no more than 16 bit !
  if(l<0) return; // someone entered an invalid hex word .. ignore

  if(m_fUseSerialPort)
   {
    if( (l<PIC_HW_COM_ADDR_MIN) || (l>PIC_HW_COM_ADDR_MAX)
       || ( (l & 0x007) != 0) )  // lower 3 bits of address should be zero ( addr = n * 8 )
     { // VERY unusual address for a COM port.. paint it red
       Ed_IoPortAddress->Color = clRed;
     }
    else
     {
       Ed_IoPortAddress->Color = clWindow;
       Config.iComIoAddress = l;
     }
   }
  else // not SERIAL ("COM") , but PARALLEL port ("LPT") :
   {
    if(l!=0 && l!=0x0278 && l!=0x0378 && l!= 0x02BC && l!=0x03BC && l!=0xB800)
     { // VERY unusual address for an LPT port..
       if( WinPic_fAcceptAllIoAddresses )
        { // Accept the address "under protest"
          Ed_IoPortAddress->Color = (TColor)0x00007FFF; // orange
          if( l!=0 )
           { Config.iLptIoAddress = l;
           }
        }
       else // do NOT accept the address (leave it unchanged)
        { Ed_IoPortAddress->Color = clRed;
        }
     }
    else
     {
       Ed_IoPortAddress->Color = clWindow;
       Config.iLptIoAddress = l;
     }
   } // end else < COM or LPT ? >
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::UnlockEditFieldForIOPortAddress(void)
{
  // Inform the user about the potentially disastrous effects
  // of entering the wrong I/O-address in the "I/O-port address" field !
  if(MessageBox(  Handle, // handle of owner window
        TE( "Caution: Entering the wrong I/O-address here CAN KILL YOUR PC !\nDo you really want to continue ?" ) ,
        TE( "WinPic WARNING" ),
        MB_ICONEXCLAMATION | MB_YESNOCANCEL | MB_DEFBUTTON2 ) != IDYES )
   {
     Config.iComIoAddress = 0;    // disable this dangerous input field again
     WinPic_fAcceptAllIoAddresses = FALSE;
     UpdateInterfaceType(m_displayed_interface_type);
     return FALSE;
   }
  if(MessageBox(  Handle, // handle of owner window
        TE( "Ok, but don't say we didn't warn you !" ) ,
        TE( "WinPic WARNING" ),
        MB_ICONEXCLAMATION | MB_OKCANCEL | MB_DEFBUTTON2 ) != IDOK )
   {
     Config.iComIoAddress = 0;    // disable this dangerous input field again
     WinPic_fAcceptAllIoAddresses = FALSE;
     UpdateInterfaceType(m_displayed_interface_type);
     return FALSE;
   }
  WinPic_fAcceptAllIoAddresses = TRUE;
  Ed_IoPortAddress->ReadOnly = FALSE;
  Ed_IoPortAddress->Color = clWindow;
  if( Ed_IoPortAddress->Text == "-std-" )
   {  Ed_IoPortAddress->Text = "";
   }
  return TRUE;

} // end UnlockEditFieldForIOPortAddress()

//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
void __fastcall TPicMain::InterfaceTimingChanged(TObject *Sender)
{
  if(m_Updating)
    return;

  Config.iExtraRdDelay_us = StrToIntDef(Ed_ExtraRdDelay->Text, Config.iExtraRdDelay_us);
  if( Config.iExtraRdDelay_us<0 )     Config.iExtraRdDelay_us = 0;
  if( Config.iExtraRdDelay_us>10000 ) Config.iExtraRdDelay_us = 10000;
  Config.iExtraClkDelay_us= StrToIntDef(Ed_ExtraClkDelay->Text,Config.iExtraClkDelay_us);
  if( Config.iExtraClkDelay_us<0 )    Config.iExtraClkDelay_us = 0;
  if( Config.iExtraClkDelay_us>10000) Config.iExtraClkDelay_us = 10000;
  Config.iSlowInterface = Chk_SlowInterface->Checked;
  PHWInfo.iSlowInterface = Config.iSlowInterface;
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::MI_ProgOpsClick(TObject *Sender)
{
  PageControl1->ActivePage = TS_Options;
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Ed_MessageClick(TObject *Sender)
{
  PageControl1->ActivePage = TS_Messages;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::Ed_ConfigWordHexChange(TObject *Sender)
{
 char str8[9];
 long l;

  if(m_Updating)
    return;
  if( APPL_i32CustomizeOptions & APPL_CUST_NO_CONFIG_EDITOR )
    return;

  strncpy(str8,Ed_ConfigWordHex->Text.c_str(), 8);
  l = HexStringToLongint(6, str8);  // usually the "config word" has 4 digits only
  if(l<0) return; // someone entered an invalid hex config word .. ignore it !

  // Immediately 'decode' the new configuration word..
  ++m_Updating;
  PicBuf_SetConfigWord( 0 , (WORD)l );
  UpdateDeviceConfigTab( FALSE/*fUpdateHexWord*/ ); // don't disturb editing !
  if(m_Updating>0)
   --m_Updating;
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::Ed_ConfigWord2Change(TObject *Sender)
{
 char str8[9];
 long l;

  if(m_Updating) return;

  strncpy(str8,Ed_ConfigWord2->Text.c_str(), 8);
  l = HexStringToLongint(6, str8);
  if(l<0) return; // someone entered an invalid 4-digit hex config word .. ignore

  // Immediately 'decode' the new configuration word..
  ++m_Updating;
  PicBuf_SetConfigWord( 1/*!*/, (WORD) l ) ;
  UpdateDeviceConfigTab( FALSE );
  if(m_Updating>0)
   --m_Updating;

}
//---------------------------------------------------------------------------


void __fastcall TPicMain::Ed_ProgramMemoryChange(TObject *Sender)
{
 BOOL fCorrected = FALSE;
  if(m_Updating) return;

  Ed_ProgramMemory->Color = clWhite;
  if( tolower(PIC_DeviceInfo.sz40DeviceName[0])=='u') // "unknown" ?
   {
    Config.dwUnknownCodeMemorySize = StrToIntDef(Ed_ProgramMemory->Text,
       Config.dwUnknownCodeMemorySize );
    if(Config.dwUnknownCodeMemorySize > PIC_BUF_CODE_SIZE)
     {
       Config.dwUnknownCodeMemorySize = PIC_BUF_CODE_SIZE;
       fCorrected = TRUE;
     }
    if(Config.dwUnknownCodeMemorySize < 1)
     {
       Config.dwUnknownCodeMemorySize = 1;
       fCorrected = TRUE;
     }
    PIC_DeviceInfo.lCodeMemSize = Config.dwUnknownCodeMemorySize;
   }
  if(fCorrected)
   {
     ++m_Updating;
     Ed_ProgramMemory->Color = clRed;
     Ed_ProgramMemory->Text  = IntToStr(Config.dwUnknownCodeMemorySize);
     --m_Updating;
   }
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Ed_DataEepromMemoryChange(TObject *Sender)
{
  if(m_Updating) return;
  if( tolower(PIC_DeviceInfo.sz40DeviceName[0])=='u') // "unknown" ?
   {
    PIC_DeviceInfo.lDataEEPROMSizeInByte = Config.dwUnknownDataMemorySize =
      StrToIntDef(Ed_DataEepromMemory->Text, Config.dwUnknownDataMemorySize);
   }
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Chk_HasFlashMemoryClick(TObject *Sender)
{
  if(m_Updating) return;
  if(Chk_HasFlashMemory->Checked)
   { // which kind of FLASH memory, 12..14 bit per location, or more ?
     PIC_DeviceInfo.iCodeMemType=PIC_MT_FLASH;   // 12Fxxx, 16Fxxx -> 14 bit per word
     Config.iUnknownDevHasFlashMemory=1;
   }
  else
   { PIC_DeviceInfo.iCodeMemType=PIC_MT_EPROM;
     Config.iUnknownDevHasFlashMemory=0;
   }
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Menu_SelectDeviceClick(TObject *Sender)
{
   PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
   PageControl1->ActivePage = TS_DeviceConfig;
   Combo_PartName->DroppedDown = TRUE;  // TComboBox
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Btn_HelpLptInterfaceClick(TObject *Sender)
{
  Application->HelpContext(HELPID_LPT_INTERFACES);
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::BitBtn1Click(TObject *Sender)
{
  Application->HelpContext(HELPID_COM_INTERFACE);
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Pnl_MessageClick(TObject *Sender)
{
  PageControl1->ActivePage = TS_Messages;
  m_iMessagePanelUsage = MP_USAGE_NOTHING;  // may overwrite this msg now
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::FormCloseQuery(TObject *Sender, bool/*not BOOL!*/&CanClose)
{
  CanClose = WinPic_OkToCloseDueToErasedCalibration();
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
AnsiString __fastcall TPicMain::ProgramWhatInfoString(void)
{
 AnsiString sResult;
 int iNeedSeparator=0;
  if(Config.iProgramWhat & PIC_PROGRAM_CODE)
   {
     sResult = TE("CODE");  iNeedSeparator=1;
   }
  if(Config.iProgramWhat & PIC_PROGRAM_DATA)
   { if( iNeedSeparator ) sResult=sResult+"+";
     sResult = sResult + TE("DATA");  iNeedSeparator=1;
   }
  if(Config.iProgramWhat & PIC_PROGRAM_CONFIG)
   { if( iNeedSeparator ) sResult=sResult+"+";
     sResult = sResult + TE("CONFIG");  iNeedSeparator=1;
   }
  return sResult;
} // end TPicMain::ProgramWhatInfoString()


//---------------------------------------------------------------------------
void __fastcall TPicMain::File1Click(TObject *Sender)
{
 int i,j;
  PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
  // Rename some menu items according to programmer options
  Menu_LoadAndProgram->Caption = AnsiString(TE("Load && &Program Device"))
        + (" (") + ProgramWhatInfoString() + ")";
  MI_ReloadAndProg->Caption = AnsiString(TE("&Reload && program"))
        + " \"" + ExtractFileName(Config.sz255HexFileName) + "\"";
  for(i=j=0; i<=5; ++i)
   { if( GetMRFname(i) != "" ) ++j;
   }
  MI_MRFs->Enabled = (j>0);
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Menu_DeviceClick(TObject *Sender)
{
  PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
  // Rename some menu items according to programmer options
  Menu_ProgramDevice->Caption =
             TE( "&Program (" )
           + ProgramWhatInfoString() + ")";
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::Menu_ToolsClick(TObject *Sender)
{
  Menu_StartBatchProgramming->Checked = (PIC_PRG_iBatchProgState != BATCH_PROG_OFF);

  MI_dsPIC_ReadExecutiveCodeMem->Enabled  = (PIC_DeviceInfo.iBitsPerInstruction==24);
  MI_dsPIC_WriteExecutiveCodeMem->Enabled = (PIC_DeviceInfo.iBitsPerInstruction==24);

  MI_ShowToolWin->Checked = (ToolForm!=NULL && ToolForm->Visible); 
  MI_ShowToolbar->Checked = Pnl_Tools->Visible;
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Menu_StartBatchProgrammingClick(TObject *Sender)
{
  PageControl1->ActivePage = TS_Messages;
  if(PIC_PRG_iBatchProgState == BATCH_PROG_OFF)
   { Mem_Messages->Clear();
     Pnl_Message->Caption = "";
     PIC_PRG_iBatchProgState = BATCH_PROG_PREP_START;
   }
  else
   { PIC_PRG_iBatchProgState = BATCH_PROG_TERMINATE;
   }
}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
void __fastcall TPicMain::Edit1Click(TObject *Sender)
{
  PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
  Menu_EnableEdit->Checked = !REd_CodeMem->ReadOnly;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::ApplyCodeMemoryEdits(void)
{
 int i;
 AnsiString s;
 char sz80Msg[81];
 BOOL fOk = TRUE;

  // Convert CODE MEMORY hex dump into buffer data
  for(i=0; (i<REd_CodeMem->Lines->Count) && fOk; ++i) // see TRichEdit
   { s = REd_CodeMem->Lines->Strings[i];
     if( ! WinPic_ApplyHexDumpLine( s.c_str() ) )
      {
        sprintf(sz80Msg,
             TE( "Cannot parse line %d in CODE MEMORY dump." ),
             (int)i+1);
        APPL_ShowMsg(APPL_CALLER_MAIN,0,sz80Msg);
        fOk = FALSE;
        break;
      }
   }


  if(fOk)
   {
     if(REd_CodeMem->Modified)
        APPL_ShowMsg(APPL_CALLER_MAIN,0,
             TE( "Applied edits in CODE-MEMORY-dump." ) );
     m_update_code_mem_display = TRUE;
   }

  REd_CodeMem->Modified = FALSE;

  return fOk;
}


//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::ApplyDataMemoryEdits(void)
{
 int i;
 AnsiString s;
 char sz80Msg[81];
 BOOL fOk = TRUE;


  // Convert DATA MEMORY hex dump into buffer data
  for(i=0; (i<REd_DataMem->Lines->Count) && fOk; ++i) // see TRichEdit
   { s = REd_DataMem->Lines->Strings[i];
     if( ! WinPic_ApplyHexDumpLine( s.c_str() ) )
      {
        sprintf(sz80Msg,
             TE( "Cannot parse line %d in DATA MEMORY dump." ) ,(int)i+1);
        APPL_ShowMsg(APPL_CALLER_MAIN,0,sz80Msg);
        fOk = FALSE;
        break;
      }
   }

  if(fOk)
   {
     if(REd_DataMem->Modified)
        APPL_ShowMsg(APPL_CALLER_MAIN,0,
             TE( "Applied edits in DATA-MEMORY-dump." ) );
     m_update_data_mem_display = TRUE;
   }

  REd_DataMem->Modified = FALSE;

  return fOk;
}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::EnableHexEditors(void)
{
     REd_CodeMem->ReadOnly = FALSE;
     REd_CodeMem->Enabled  = TRUE;
     REd_DataMem->ReadOnly = FALSE;
     REd_DataMem->Enabled  = TRUE;

     return TRUE;
} // end TPicMain::EnableHexEditors()


//---------------------------------------------------------------------------
BOOL __fastcall TPicMain::QueryAndApplyHexEditIfRequired(void)
{
  if(  !REd_CodeMem->ReadOnly
    && (REd_CodeMem->Modified || REd_DataMem->Modified )  )
   {
     if(MessageBox(  Handle, // handle of owner window
        TE( "Apply changes in the HEX EDITOR ?" ) ,
        "WinPic",
        MB_ICONQUESTION | MB_YESNOCANCEL | MB_DEFBUTTON2 ) == IDYES )
      {
        ApplyCodeMemoryEdits();
        ApplyDataMemoryEdits();
      }
     else
      {
        return FALSE;
      }
   }
  return TRUE;
} // end TPicMain::QueryAndApplyHexEditIfRequired()


//---------------------------------------------------------------------------
void __fastcall TPicMain::Menu_EnableEditClick(TObject *Sender)
{
  // see help on TRichEdit !
  if( !REd_CodeMem->ReadOnly  &&  REd_CodeMem->Modified )
   {
    if(MessageBox(  Handle, // handle of owner window
        TE( "Do you want to APPLY the edits\n in the code memory buffer ?" ),
        TE( "WinPic: turning CODE MEMORY editor off.." ),
        MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON1 ) == IDYES )
     {
       ApplyCodeMemoryEdits();
     }
   }

  if( !REd_DataMem->ReadOnly  &&  REd_DataMem->Modified )
   {
    if(MessageBox(  Handle, // handle of owner window
        TE( "Do you want to APPLY the edits\n in the data memory buffer ?" ),
        TE( "WinPic: turning DATA MEMORY editor off.." ),
        MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON1 ) == IDYES )
     {
       ApplyDataMemoryEdits();
     }
   }

  // Toggle the "edit mode" for both hex dumps (which are in fact TRichEdits)
  if(REd_CodeMem->ReadOnly)
   { EnableHexEditors();
   }
 else
   { REd_CodeMem->ReadOnly = TRUE;
    // REd_CodeMem->Enabled  = FALSE;    // shit, also disables the SCROLLER(!)
     REd_DataMem->ReadOnly = TRUE;
    // REd_DataMem->Enabled  = FALSE;   // shit, also disables the SCROLLER(!)
   }
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Menu_DiscardHexEditsClick(TObject *Sender)
{
  m_update_code_mem_display = m_update_data_mem_display = TRUE;
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Menu_ApplyHexEditsClick(TObject *Sender)
{
  ApplyCodeMemoryEdits();
  ApplyDataMemoryEdits();
}
//---------------------------------------------------------------------------


void __fastcall TPicMain::ResetGo1Click(TObject *Sender)
{
  PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
  PIC_HW_ResetAndGo();
  UpdateInterfaceTestDisplay();
}
//---------------------------------------------------------------------------


void __fastcall TPicMain::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   // See help on OnKeyDown : "KeyPreview" must be set !
   if(Key==13)
    {
      if(  (PIC_PRG_iBatchProgState == BATCH_PROG_WAIT_START)
        || (PIC_PRG_iBatchProgState == BATCH_PROG_WAIT_START2) )
       { PIC_PRG_iBatchProgState =  BATCH_PROG_STARTED;
         Key=0; // handled
       }
    }
   if(Key==27)
    {
      APPL_iUserBreakFlag = 1;  // signal for the programming routines to leave all loops
      if( WinPic_fCommandLineMode )
       { WinPic_fCommandLineMode = FALSE;
         PicMain->Pnl_Message->Caption =
             TE( "ESC: Command-line driven operation cancelled !") ;
         m_iMessagePanelUsage = MP_USAGE_INFO;
         Key=0; // handled
       }
      if(PIC_PRG_iBatchProgState != BATCH_PROG_OFF)
       { PIC_PRG_iBatchProgState =  BATCH_PROG_TERMINATE;
         Key=0; // handled
       }
    }

}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Shp_RedLEDMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   PIC_HW_SetRedLed( 1-PIC_HW_SetRedLed(-1) );
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Shp_GreenLEDMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   PIC_HW_SetGreenLed( 1-PIC_HW_SetGreenLed(-1) );
}
//---------------------------------------------------------------------------


void __fastcall TPicMain::Menu_SaveBuffersClick(TObject *Sender)
{
  /* beware: Win XP saves a history in the registry (grrrrrr) */
  SaveDialog->Title      = TE( "Save Hex File" );
  SaveDialog->DefaultExt = "hex";
  SaveDialog->Filter     = "HEX files (INHX8M, *.hex)|*.hex";
  SaveDialog->FileName   = "dumped.hex";
  SaveDialog->InitialDir = "";
  SaveDialog->HistoryList->Clear();
  if( SaveDialog->Execute() )
   {
     DumpEverythingToHexFile( SaveDialog->FileName.c_str() );
   }
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::HexEditKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  if( (!Shift.Contains(ssAlt)) && (!Shift.Contains(ssAlt)) )   // whats a Set ? grumble..
   {
    if( (Key>='0' && Key<='9') || (Key>='a' && Key<='f') || (Key>='a' && Key<='f')
     || (Key==' ') )
    {
     if(REd_CodeMem->ReadOnly)
      {
        if(MessageBox(  Handle, // handle of owner window
         TE( "Turn HEX-EDITOR on ?" ),
         "WinPic",
         MB_ICONQUESTION | MB_YESNOCANCEL | MB_DEFBUTTON1 ) == IDYES )
          {
            EnableHexEditors();
          }
       }
     }
   }
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TPicMain::RB_IdBinClick(TObject *Sender)
{
 ApplyIdLocationDisplay();
 UpdateIdAndConfMemDisplay();  // ... in "normalized" form
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Chk_ShowAllCfgCellsClick(TObject *Sender)
{
 // ApplyIdLocationDisplay();
 UpdateIdAndConfMemDisplay();  // ... with the new settings
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TPicMain::MI_ShowToolWinClick(TObject *Sender)
{
  if(ToolForm)
   { ToolForm->Show();
     UpdateToolWindow();
   }  
}
//---------------------------------------------------------------------------


void __fastcall TPicMain::MI_SelLanguageClick(TObject *Sender)
{
  PageControl1->ActivePage = TS_Options;
  CB_Language->DroppedDown = TRUE;          
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Btn_StartTestClick(TObject *Sender)
{
  if( WinPic_iTestMode )
      WinPic_iTestMode = 0;
  else
      WinPic_iTestMode = StrToIntDef( Ed_TestNr->Text, 0 );
  switch( WinPic_iTestMode )  // any special "one-shot"-test ?
   { case 3:
       WinPic_iTestMode = 0;
       if( MessageBox( NULL,
          "Remove the PIC from the socket,\n connect interface and power supply.\nDo you want to continue ?",
          "Interface Speed Test",
          MB_ICONQUESTION | MB_YESNOCANCEL | MB_DEFBUTTON3 ) == IDYES )
         {
           InterfaceSpeedTest();
         }
        break; // end case "test #3"
     default:
        break;
    }

  if( WinPic_iTestMode )
    { Btn_StartTest->Caption = "Stop test";
    }
  else
    { Btn_StartTest->Caption = "Start test";
    }
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Pnl_CodeMemColorsClick(TObject *Sender)
{
 DWORD dwRGBcolor;
  dwRGBcolor = (DWORD)Pnl_CodeMemColors->Font->Color;
  if( YHF_ChooseColor(Handle, "Code Memory Text", &dwRGBcolor ) )
   { Pnl_CodeMemColors->Font->Color = (TColor)dwRGBcolor;
   }
  dwRGBcolor = (DWORD)Pnl_CodeMemColors->Color;
  if( YHF_ChooseColor(Handle, "Code Memory Background", &dwRGBcolor ) )
   { Pnl_CodeMemColors->Color = (TColor)dwRGBcolor;
   }
  UpdateCodeMemDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Pnl_DataMemColorsClick(TObject *Sender)
{
 DWORD dwRGBcolor;
  dwRGBcolor = (DWORD)Pnl_DataMemColors->Font->Color;
  if( YHF_ChooseColor(Handle, "Data Memory Text", &dwRGBcolor ) )
   { Pnl_DataMemColors->Font->Color = (TColor)dwRGBcolor;
   }
  dwRGBcolor = (DWORD)Pnl_DataMemColors->Color;
  if( YHF_ChooseColor(Handle, "Data Memory Background", &dwRGBcolor ) )
   { Pnl_DataMemColors->Color = (TColor)dwRGBcolor;
   }
  UpdateDataMemDisplay();
}
//---------------------------------------------------------------------------


void __fastcall TPicMain::MI_dsPIC_ReadExecutiveCodeMemClick(
      TObject *Sender)
{
 BOOL ok;

   if( PIC_DeviceInfo.iBitsPerInstruction==24 )
    {
      PIC_PRG_iBatchProgState = BATCH_PROG_OFF;
      Pnl_Message->Caption = TE( "Reading Executive Code Memory ..." );
      m_iMessagePanelUsage = MP_USAGE_BUSY;
      m_fPicDeviceConflict = FALSE;
      Update();

      ok = PicPrg_ReadExecutiveCodeMemory();  // for dsPIC30F only ! !
      UpdateAllSheets();  // incl  UpdateInterfaceTestDisplay()

      if(ok)
       {
        APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
             TE( "Reading Executive Code Memory ok.") );
        m_iMessagePanelUsage = MP_USAGE_INFO;
       }
      else
       {  APPL_ShowMsg( APPL_CALLER_PIC_PRG, 0,
              TE( "Reading Executive Code Memory failed." ) );
          m_iMessagePanelUsage = MP_USAGE_WARNING;
       }
      UpdateCodeMemDisplay();
    } // end if < 24 bit per instruction, most likely dsPIC30Fxxxx >

}
//---------------------------------------------------------------------------

void __fastcall TPicMain::MI_dsPIC_WriteExecutiveCodeMemClick(
      TObject *Sender)
{
   if( PIC_DeviceInfo.iBitsPerInstruction==24 )
    {
    } // end if < 24 bit per instruction, most likely dsPIC30Fxxxx >
}


//---------------------------------------------------------------------------
//  "Speed Buttons" - unnecessary gimmicks for some folks,
//                    may be turned off through the good old main menu .
//---------------------------------------------------------------------------

void __fastcall TPicMain::Btn_CloseToolbarClick(TObject *Sender)
{
   Pnl_Tools->Visible = FALSE;
}
//---------------------------------------------------------------------------
void __fastcall TPicMain::MI_ShowToolbarClick(TObject *Sender)
{
   Pnl_Tools->Visible = !Pnl_Tools->Visible;
}
//---------------------------------------------------------------------------
void __fastcall TPicMain::Btn_FileOpenClick(TObject *Sender)
{
   Load1Click(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TPicMain::Btn_ProgramClick(TObject *Sender)
{
   Menu_ProgramDeviceClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TPicMain::Btn_SaveClick(TObject *Sender)
{
   Menu_SaveBuffersClick( Sender );
}
//---------------------------------------------------------------------------
void __fastcall TPicMain::Btn_VerifyClick(TObject *Sender)
{
   Verify1Click( Sender );
}
//---------------------------------------------------------------------------
void __fastcall TPicMain::Btn_ReadPICClick(TObject *Sender)
{
   Read1Click( Sender );
}
//---------------------------------------------------------------------------
void __fastcall TPicMain::Btn_HelpIndexClick(TObject *Sender)
{
   Index1Click( Sender );
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::Btn_MplabDevDirClick(TObject *Sender)
{
  char folderName[MAX_PATH+1];
  strncpy( folderName, Ed_MplabDevDir->Text.c_str(), MAX_PATH );
  folderName[sizeof(folderName)-1] = '\0';

  if( YHF_BrowseFolder( Handle, TE("Select MPLAB 'Device' folder"),
                        folderName, MAX_PATH ) )
   { Ed_MplabDevDir->Text = folderName;
     strncpy( Config.sz255MplabDevDir, folderName, 255 );
   }
}
//---------------------------------------------------------------------------

void __fastcall TPicMain::PortAccessDriverChanged(TObject *Sender)
{
  if( !m_Updating )
   {
     ProgOptionsChanged(Sender);
     Pnl_Message->Caption = TE("Must restart WinPic to make changes effective");
     UpdateInterfaceType(m_displayed_interface_type);     
   }
}
//---------------------------------------------------------------------------



void __fastcall TPicMain::Ed_IoPortAddressClick(TObject *Sender)
{
  if( !m_Updating )
   {
     // When clicking into this field, the user must be informed
     // about the potentially disastrous effect
     // of entering the wrong I/O-address in this field !
     if( ! WinPic_fAcceptAllIoAddresses )
        UnlockEditFieldForIOPortAddress();
   }
}
//---------------------------------------------------------------------------

