/*========================================================================*/
/*                                                                        */
/*   Translation of all visible strings of the  PIC Programming Tool .    */
/*                                                                        */
/*   CAUTION: The usage of tabulator characters in this file is           */
/*            *STRICTLY FORBIDDEN* - use an appropriate text editor,      */
/*            or tell your text editor NEVER to use tab characters .      */
/*                                                                        */
/* Revision history (YYYY-MM-DD) :                                        */
/* 2003-04-29: Started by Wolfgang Buescher for another project .         */
/* 2004-03-24: Used in DL4YHF's PIC programmer for windows now .          */
/*          Though it's quite unlikely that this will ever be realized:   */
/*          SIX Languages were planned - but only TWO actually used now.  */
/*========================================================================*/

#include <stddef.h>      // NULL must be defined somewhere
#include "translation.h"

const char *TranslationTable[] =
{ // Format of the translation table
  // -----------------------------------
  // It is planned to load these string from an ASCII file one day,
  //       to be compatible with future extensions, EVERY LINE contains
  //       its own language, using ISO 639-1(!) 2-letter language codes .
  //  Some examples of ISO 639-1 language codes :
  //   en:  english   (may be abbreviated as e: here)
  //   de:  german    (may be abbreviated as d: here)
  //   fr:  french    (may be abbreviated as f: here)
  //   it:  italian   (may be abbreviated as i: here)
  //   es:  spanish   (may be abbreviated as s: here)
  //   da:  danish
  //   nl:  dutch; flemish
  //   pt:  portuguese
  //   sv:  swedish
  //
  //  If a line begins with ':' , it contains the reference string
  //  which is used to find the right table entry. It MUST NOT
  //  be modified by the translator. The language used for the reference
  //  is usually ENGLISH (e:) so it's not necessary to have an english
  //  translation coded in lines beginning with "e:" or "en:" !
  //
  // Note: the english "master" MUST NOT BE MODIFIED by the translator,
  //       because EXACTLY the same string is somewhere in the C-code
  //       or one of the windows (called "forms" in Borland-C++Builder).
  //       If you modify the english string, the program won't find it anymore.
  //
  // The strings contain special characters, which must be handled
  // carefully to avoid malfunction of the program. Some characters are:
  //  '&'  as PREFIX mark the shortcut (letter) in menus, like "E&xit".
  //       If possible, use the same hotkey letters in your translation
  //       to avoid dupes in a menu !
  //  '%'  often indicates a format string, which is a placeholder for
  //       a number or a text. Be careful not to change the sequence after this.
  //       If there is more than one percent character in a string,
  //       be careful to keep the same parameter sequence ! Eample:
  //        ":Problem Nr. %d : found=%s,  read=%s",
  //        "d:Problem Nr. %d: gefunden=%s gelesen=%s",
  //          ( %d is a decimal number, %s is a string parameter )

  // The very first group in the table should contain
  // a list of all supported languages, along with their native names.
  // These entries will be copied into the language selection "combo".
  // It's up to you to write the language name in its own language or English.
  ":<languages>",
   "en:English",    // don't use abbreviated language codes here !
   "de:Deutsch",
 //"fr:Franais", // French translation is in an extra file - thanks Alain Pierre
 //"it:Italiano",
 //"es:Espaol",


  // Standard "captions" for buttons and common menus..
  ":Delete",
    "d:Lschen",
  ":Cut",
    "d:Ausschneiden",
  ":Insert",
    "d:Einfgen",
  ":Insert..",
    "d:Einfgen..",
  ":Copy",
    "d:Kopieren",
  ":Paste",
    "d:Einfgen",
  ":More",
    "d:Mehr",
  ":More..",
    "d:Mehr..",
  ":Help",
    "d:Hilfe",
  ":&Help",
    "d:&Hilfe",
  ":Undo",
    "d:Rckgg.",
  ":Apply",
    "d:Anwenden",
  ":Menu",
    "d:Men",
  ":Width",
    "d:Breite",
  ":Height",
    "d:Hhe",
  ":Style",
    "d:Stil",
  ":Invert",
    "d:Invers",
  ":Import",
    "d:Importieren",
  ":Export",
    "d:Exportieren",
  ":Stop",
    "d:Stoppen",
  ":Yes",
    "d:Ja",
  ":No",
    "d:Nein",
  ":Cancel",
    "d:Abbrechen",
  ":unknown",
    "d:unbekannt",
  ":please wait",
    "d:bitte warten",
  ":Language",
    "d:Sprache",
  ":Select language",
    "d:Sprache whlen",
  ":English",
    "d:Englisch",
  ":German",
    "d:Deutsch",
  ":French",
    "d:Franzsisch",
    "f:Francais",


  // Application-specific MENUS ...
  //  Note: the shortcut character *must* be specified, otherwise the form
  //        will produce it automatically and the string cannot be translated
  //        (because the string-find-function will fail).

  // Main menu in ToolMain :
  ":&File",
    "d:&Datei",
  ":&Load Program",
    "d:&Lade Programm",
  ":&Save Program",
    "d:&Speichere Programm",
  ":Save Program &As..",
    "d:Programm speichern &Als",
  ":E&xit",
    "d:&Beenden",
  ":Exit without saving the settings",   // in PicMain.MI_ExitDontSave
    "d:Beenden ohne die Einstellungen zu sichern",    
  ":&Assistant",
    "d:&Assistent",
  ":&Edit",                              // don't change this shortcut !
    "d:B&earbeiten",
  ":&Transfer",                          // don't change this shortcut !
    "d:&Transfer",

  // WiPic-specific stuff in the main form...
  ":WIN PIC Programmer",                 // in PicMain
   "d:WIN PIC Programmierer",
  ":Code",                               // in PicMain.TS_ProgramMemory
   "d:Code",
  ":Data",                               // in PicMain.TS_EEPromMemory
   "d:Daten",
  ":Device, Config",                     // in PicMain.TS_ConfigMem
   "d:Chip, Konfiguration",
  ":Part:",                              // in PicMain.Label2
   "d:Chip:",
  ":Oscillator:",                        // in PicMain.Label3
   "d:Oszillator:",
  ":Config word #1:",                    // in PicMain.Label4
   "d:Config-Wort #1:",
  ":Config word #2:",                    // in PicMain.Label11
   "d:Config-Wort #2:",
  ":(hex)",                              // in PicMain.Label7
   "d:(hex)",
  ":Saved before erase:",                // in PicMain.Lab_SavedBeforeErase2
   "d:Vor Lschen gerettet:",
  ":Code Protection",                    // in PicMain.Chk_CodeProtect
   "d:Code-Leseschutz",
  ":Power-Up timer",                     // in PicMain.Chk_PWRTE
   "d:Power-Up-Timer",
  ":Watchdog Enable",                    // in PicMain.Chk_WDTE
   "d:Watchdog aktivieren",
  ":Data Protection",                    // in PicMain.Chk_DataProtection
   "d:Daten-Leseschutz",
  ":Brown-out Reset",                    // in PicMain.Chk_BrownOutReset
   "d:Brown-out Reset",
  ":Low Voltage Prog",                   // in PicMain.Chk_LowVoltageProg
   "d:Low Voltage Prog",
  ":MCLR Enable",                        // in PicMain.Chk_MCLRenable
   "d:MCLR-Enable",
  ":FLASH",                              // in PicMain.Chk_HasFlashMemory
   "d:FLASH",                            //  (ex: "has FLASH memory", too long)
  ":In-Circuit Debug",                   // in PicMain.Chk_DebugEnable
   "d:In-Circuit Debug",
  ":Code w.enable",                      // in PicMain.Chk_CodeWriteEnable
   "d:Code w.enable",
  ":CCP1 pin select",                    // in PicMain.Chk_ccpmx
   "d:CCP1 Pin Select",
  ":Device Properties",                  // in PicMain.Grp_DevProps
   "d:Chip-Eigenschaften",
  ":words code memory",                  // in PicMain.Lab_ProgramMemory
   "d:words Programmspeicher",
  ":byte data EEPROM",                   // in PicMain.Lab_DataEepromMemory
   "d:bytes im EEPROM",
  ":Config Word #2",                     // in PicMain.Grp_CfgWord2
   "d:Config-Wort #2",
  ":(hex)",                              // in PicMain.Label6
   "d:(hex)",
  ":Config Memory",                      // in PicMain.TS_IdLocs
   "d:Config-Speicher",
  ":Device ID WORD :",                   // in PicMain.Lab_DevId1
   "d:Device ID WORD :",
  ":Apply edits",                        // in PicMain.Btn_ApplyIdLocs
   "d:bernehmen",
  ":Binary",                             // in PicMain.RB_IdBin
   "d:Binr",
  ":Hexadecimal",                        // in PicMain.RB_IdHex
   "d:Hexadezimal",
  ":Options",                            // in PicMain.TS_Options
   "d:Optionen",
  ":Programmer options",                 // in PicMain.Grp_ProgOptions
   "d:Programmer-Optionen",
  ":(use it like ordinary code memory)",  // in PicMain.Label12
   "d:(wie normalen Speicher behandeln)",
  ":program CODE memory",  // in PicMain.Chk_ProgCodeMem
   "d:programmiere CODE-Speicher",
  ":program DATA memory",  // in PicMain.Chk_ProgDataMem
   "d:programmiere DATA (EEPROM)",
  ":program CONFIG memory",  // in PicMain.Chk_ProgConfigMem
   "d:programmiere CONFIG-Speicher",
 // ex:  ":program all  (code AND data)",       // in PicMain.Btn_ProgCodeAndData
 //   "d:Alles programmieren (Code+Daten)",
 // ":program code memory ONLY",           // in PicMain.Btn_ProgCodeOnly
 //   "d:nur den Programmspeicher programmieren",
 // ":program data EEPROM ONLY",           // in PicMain.Btn_ProgDataOnly
 //   "d:nur das Daten-EEPROM programmieren",
  ":use BULK ERASE  (to unprotect)",     // in PicMain.Chk_UseBulkErase
   "d:BULK-ERASE verwenden (wg. Schutz)",
  ":automatic disconnect from target",  // in PicMain.Chk_DisconnectAfterProg
   "d:automatisch vom Target trennen",
  ":no special treatment for OSCCAL",  // in PicMain.Chk_DontCareForOsccal
   "d:keine Sonderbehandlung fr OSCCAL",
  ":no special treatment for BG calib",  // in PicMain.Chk_DontCareForBGCalib
   "d:keine Sonderbehandlung fr BG-Bits",
  ":verify at different supply voltages",  // in PicMain.Chk_VerifyDiffVdds
   "d:Verify bei verschiedenen Spannungen",
  ":Other options",                      // in PicMain.Grp_OtherOps
   "d:Andere Optionen",
  ":Clear buffers before loading HEX file",  // in PicMain.Chk_ClrBeforeLoad
   "d:Puffer vor dem Laden von Dateien lschen",
  ":raise Vdd before  MCLR=Vpp",         // in PicMain.Chk_VddBeforeMCLR 
   "d:Vdd anheben, bevor MCLR=Vpp (50us)",
  ":Code memory colors",               // in PicMain.Pnl_CodeMemColors
   "d:Codespeicher-Farben",
  ":Data memory colors",               // in PicMain.Pnl_DataMemColors
   "d:Datenspeicher-Farben",
  ":Debugging",                        // in PicMain.Grp_DebugOptions
   "d:Debugging",     // bitte nicht mit "Entwanzen" bersetzen - nngrrr !  ;-)
  ":simulate only (ignore hardware)",  // in PicMain.Chk_SimulateOnly
   "d:nur Simulieren (ohne Hardware)",
  ":generate verbose messages",        // in PicMain.Chk_VerboseMsgs
   "d:erweiterte Meldungs-Anzeige",

  ":MPLAB DEV-file directory",               // in PicMain.Lab_DevFileDir
   "d:MPLAB DEV-Datei-Verzeichnis",
  ":I/O Port Access Driver",                 // in PicMain.Grp_IOPortAccess
   "d:Treiber fr I/O-Port-Zugriffe",
  ":no direct access at all, only use win API",
   "d:kein direkter Portzugriff, nur API-Routinen",
  ":use SMPORT",  // in PicMain.Rb_UseSMPORT
   "d:verwende SMPORT",
  ":use PortTalk",  // in PicMain.Rb_UsePortTalk
   "d:verwende PortTalk",
  ":search web for PortTalk by Craig Peacock",  // in PicMain.Rb_UsePortTalk.Hint
   "d:siehe WWW, suche nach PortTalk von Craig Peacock",
  ":port access already granted before start",  // in PicMain.Rb_NoPortDriver
   "d:Zugriff auf I/O-Ports bereits freigeschaltet",
  ":for example, use AllowIo.exe in batch file", // in PicMain.Rb_NoPortDriver.Hint
   "d:z.B. durch AllowIo.exe in einem Batchfile",

  ":Interface",                        // in PicMain.TS_Interface
   "d:Interface", // nein, dies ist kein "Zwischengesicht"  !
  ":Interface Test",                   // in PicMain.Grp_IntfTest
   "d:Interface-Test",
  ":Data In = ",                       // in PicMain.Label1
   "d:Data In = ",
  ":Red LED",                          // in PicMain.Lab_RedLED
   "d:Rote LED",
  ":Green LED",                        // in PicMain.Lab_GreenLED
   "d:Grne LED",
  ":(no button)",                      // in PicMain.Lab_OkButton
   "d:(kein Button)",
  ":Vpp (+13V)",                 // in PicMain.Chk_TestVpp
   "d:Vpp (+13V)",
  ":Clock",                      // in PicMain.Chk_TestClock
   "d:Takt",
  ":Data (to PIC)",              // in PicMain.Chk_TestData
   "d:Daten (zum PIC)",
  ":Vdd on/off",                 // in PicMain.Chk_TestVdd
   "d:Vdd an/aus",
  ":Clock Enable",               // in PicMain.Chk_ClockEnable
   "d:Takt-Enable",
  ":Data Enable",                // in PicMain.Chk_DataEnable
   "d:Data-Enable",
  ":Connect target",             // in PicMain.Chk_ConnectICSPTarget
   "d:Target verbinden",
  ":Pull MCLR low",              // in PicMain.Chk_PullMclrToGnd
   "d:MCLR=low setzen",
  ":Vdd Select",                 // in PicMain.Grp_SelVdd
   "d:Vdd-Auswahl",
  ":low",                        // in PicMain.RB_VddLow
   "d:niedrig",
  ":norm (5V)",                  // in PicMain.RB_VddNorm
   "d:normal (5V)",
  ":high",                       // in PicMain.RB_VddHigh
   "d:hoch",
  ":Interface Type",             // in PicMain.Grp_InterfaceType
   "d:Interface-Typ",
  ":on port :",                  // in PicMain.Label5
   "d:an Port :",
  ":addr:",                      // in PicMain.Lab_PortAddr
   "d:Adr.:",
  ":Custom interface definition file :",  // in PicMain.Label9
   "d:Interface-Definitions-Datei :",
  ":extra delay before reading data line [s]",  // in PicMain.Lab_ExtraRdDelay
   "d:Zustzliche Verzgerung fr data-in [s]",
  ":extra lenghtening for clock pulses [s]",    // in PicMain.Lab_ExtraClkDelay
   "d:Zustzliche Dehnung fr Taktsignal [s]",
  ":slow mode (to check for timing problems)",   // in PicMain.Chk_SlowInterface
   "d:Super-Slow-Mode (bei Timing-Problemen)",
  ":Select",                     // in PicMain.Btn_SelectCustomInterface
   "d:Auswhlen",
  ":Initialize !",               // in PicMain.Btn_InitInterface
   "d:Initialisieren !",
  ":Help on &LPT interfaces",    // in PicMain.Btn_HelpLptInterface
   "d:Hilfe zum &LPT-Interface",
  ":Help on &COM84",             // in PicMain.BitBtn1
   "d:Hilfe zu &COM84",
  ":Messages",                   // in PicMain.TS_Messages
   "d:Meldungen",
  ":Clear",                      // in PicMain.Btn_ClearMessages
   "d:Lschen",
  ":&Load",                      // in PicMain.Load1
   "d:&Laden",
  ":Load && &Program Device",    // in PicMain.Menu_LoadAndProgram
   "d:Laden && Chip &programmieren",
  ":&Most recent files",         // in PicMain.MI_MRFs
   "d:&Zuletzt verwendete Dateien",
  ":&Clear file list",           // in PicMain.MI_ClearMRFs
   "d:Datei-Historie &lschen",
  ":&Dump buffers to hex file",  // in PicMain.Menu_SaveBuffers
   "d:Puffer in &Hex-Datei speichern",
  ":Clear &buffer",              // in PicMain.Clearbuffer1
   "d:&Pufferinhalt lschen",
  ":Clear &fuses",               // in PicMain.ClearFuses
   "d:&Config-Puffer lschen ('fuses')",
  ":&Enable HEX editor",         // in PicMain.Menu_EnableEdit
   "d:Hex-&Editor aktivieren",
  ":&Apply edits",               // in PicMain.Menu_ApplyHexEdits
   "d:nderungen &bernehmen",
  ":&Discard edits",             // in PicMain.Menu_DiscardHexEdits
   "d:nderungen &verwerfen",
  ":Show &Tool window",          // in PicMain.MI_ShowToolWin
   "d:Zeige &Tool-Fenster",
  ":Show Tool&bar",              // in PicMain.MI_ShowToolbar
   "d:Zeige Tool&bar (speed buttons)",
  ":&Device",                    // in PicMain.Menu_Device
   "d:&Chip",
  ":&Select",                    // in PicMain.Menu_SelectDevice
   "d:&Auswhlen",
  ":&Program",                   // in PicMain.Menu_ProgramDevice
   "d:&Programmieren",
  ":&Program (",                 // changes Menu_ProgramDevice during runtime
   "d:&Programmiere (", // (followed by WHAT to program + closing parenthesis, hard-coded)
  ":Program &Config word (only)",   // in PicMain.MI_ProgCfgWord
   "d:Nur &CONFIG-Wort programmieren",
  ":Program &ID locations (only)",  // in PicMain.MI_ProgIDlocs
   "d:Nur &ID-Zellen programmieren",
  ":&Erase",                     // in PicMain.Erase1
   "d:Lsch&en",
  ":&Verify",                    // in PicMain.Verify1
   "d:&Vergleichen",
  ":&Blank Check",               // in PicMain.BlankCheck1
   "d:L&eertest",
  ":&Read",                      // in PicMain.Read1
   "d:&Lesen",
  ":Reset / Disconnect ICSP / &Go",  // in PicMain.ResetGo1
   "d:Reset / ICSP abkoppeln / &Go",
  ":&Tools",                     // in PicMain.Menu_Tools
   "d:&Tools",
  ":&Start Batch Programming",  // in PicMain.Menu_StartBatchProgramming
   "d:Batch-Programmierung &starten",
  ":S&pecials",                  // in PicMain.Specials1
   "d:S&pezialitten",
  ":Dump built-in device list to file",  // in PicMain.M_DumpDevList
   "d:Eingebaute Device-Liste als Datei exportieren",
  ":Dump translation table to file",     // in PicMain.MI_DumpTranslator
   "d:bersetzungs-Tabelle als Datei exportieren",
  ":Dump memory windows as RTF files",  // in PicMain.MI_DumpMemAsRTF
   "d:Speicherauszge als RTF-Dateien exportieren",   
  ":Read dsPIC \"executive code memory\" (~bootloader)",  // in PicMain.MI_dsPIC_ReadExecutiveCodeMem
   "d:Lese \"executive code memory\" (~Bootloader) aus dsPIC",
  ":Program dsPIC \"executive code memory\"",  // in PicMain.MI_dsPIC_WriteExecutiveCodeMem
   "d:Programmiere \"executive code memory\" im dsPIC",
  ":Programmer &Options",        // in PicMain.MI_ProgOps
   "d:Programmer &Options",
  ":&Index",                     // in PicMain.Index1
   "d:&Inhaltsbersicht",
  ":&Frequently asked questions",  // in PicMain.MI_FAQs
   "d:Oft gestellte &Fragen (FAQs)",
  ":&About..",                   // in PicMain.About1
   "d:&ber dieses Programm",

  // Hints (tooltips), translatable since 2005-09-11 :
  ":Open HEX file",  // in PicMain.Btn_FileOpen.Hint
   "d:HEX-Datei ffnen",
  ":Program device",  // in PicMain.Btn_Program.Hint
   "d:Chip programmieren",
  ":Hide toolbar",  // in PicMain.Btn_CloseToolbar.Hint
   "d:Symbolleiste verbergen",
  ":Dump buffers to file",  // in PicMain.Btn_Save.Hint
   "d:Pufferinhalt als HEX-Datei speichern",
  ":Verify device",  // in PicMain.Btn_Verify.Hint
   "d:Chip vergleichen",
  ":Read device",  // in PicMain.Btn_ReadPIC.Hint
   "d:Chip auslesen",
  ":Help Index",  // in PicMain.Btn_HelpIndex.Hint
   "d:Hilfe-Index",
  ":Open WinPic's main window",  // in ToolForm.Btn_ToMain.Hint
   "d:WinPic's Hauptfenster ffnen",

  // end of translatable strings in the Borland-"forms"


  //------------------ String Literals in the C program -------------------
  ":WinPic WARNING",
   "d:WinPic WARNUNG",
  ":Caution: Entering the wrong I/O-address here CAN KILL YOUR PC !\nDo you really want to continue ?",
   "d:Vorsicht: Die Eingabe einer falschen I/O-Adresse kann den PC schdigen !\nWollen Sie trotzdem fortfahren ?",     
  ":Ok, but don't say we didn't warn you !",
   "d:Ok, aber sagen Sie nicht wir htten Sie nicht gewarnt !",
  ":Loading port driver",
   "d:Lade Port-Treiber",
  ":I/O-port access failed. Try a different access driver (SMPORT or PortTalk) !",
   "d:Zugriff auf I/O-Port ging schief. Anderen Treiber probieren (SMPORT oder PortTalk) !",
  ":Could not switch off Vpp !",
   "d:Konnte Vpp nicht abschalten !",
  ":Could not switch Clock or Data !",
   "d:Konnte TAKT oder DATEN nicht schalten !",
  ":Failed read back of DATA line (LOW) !",
   "d:Fehler beim Rcklesen der DATA-Leitung (L) !",
  ":Failed read back of DATA line (HIGH) !",
   "d:Fehler beim Rcklesen der DATA-Leitung (L) !",
  ":Initialising PIC-Programmer: Success.",
   "d:Initialisierung PIC-Programmer erfolgreich.",
  ":Interface tested, OK.",
   "d:Interface getestet, OK.",
  ":WARNING: Could not initialize programmer !",
   "d:WARNUNG: Kann den Programmer nicht initialisieren !",
  ":Error testing the Interface",
    "d:Fehler beim Testen des Interfaces",
  ":Testing: delay(500ms) took %.2f seconds, timer_freq=%.4f MHz ...",
    "d:Test: Verzgerung(500ms) dauerte %.2f Sekunden, Timerfreq=%.4f MHz ...",
  ":ERROR !",
    "d:FEHLER !",
  ":Conflicting Vpp/Vdd switching sequence on the Options tab.\n Change the sequence to match the new device info ?",
    "d:Widerspruch in der Vpp/Vdd-Schaltfolge fr das neue Device (unter Optionen).\n Soll dies anhand der Device-Info-Tabelle umgeschaltet werden ?",
  ":Vpp/Vdd switching sequence possibly wrong",
    "d:Vpp/Vdd-Schaltsequenz ist mglicherweise falsch",
  ":Reading 0x%06lX - 0x%06lX ...",    // used in many places !
    "d:Lese 0x%06lX - 0x%06lX ...",
  ":Reading done, Conflict: selected device = %s,  read = %s",
    "d:Lesen fertig, Problem mit Chip-ID: eingestellt=%s, gelesen=%s",
  ":Reading PIC ok.",
    "d:Auslesen des PICs ok.",
  ":Reading PIC FAILED (maybe blank).",
    "d:Auslesen FEHLERHAFT (evtl. LEER).",
  ":Blank Checking ...",
    "d:Leertest luft ...",
  ":Device is NOT blank.",
    "d:Chip ist NICHT leer.",
  ":Device is blank.",
    "d:Chip ist leer (nicht programmiert).",
  ":Must restart WinPic to make changes effective",
    "d:nderungen werden erst beim Neustart von WinPic wirksam",  


  // in TPicMain::ProgramPic() ......................................
  ":Programming",
    "d:Programmiere",
  ":PIC is erased - nothing to dump",
    "d:PIC ist gelscht - nichts zu speichern",
  ":Erasing",      // used in various places !
    "d:Lschen",
  ":Erasing (\"bulk\" or \"chip\") ...",
    "d:Lsche (\"bulk\" oder \"chip\") ...",
  ":Erasing FAILED !",
    "d:Fehler beim Lschen !",
  ":Erased",
    "d:Gelscht",
  ":Must not erase non-FLASH device, check \"Device, Config\" !",
    "d:Lschen von Chip ohne FLASH-Speicher unmglich, prfe \"Device, Config\" !",
  ":Warning: Last program addr (0x%06lX) exceeds device memory size (0x%06lX) !",
    "d:Warnung: Die letzte Adresse (0x%06lX) berschreitet die Speichergre (0x%06lX) !",
  ":Select YES to ignore this problem and truncate the buffer contents.",
    "d:Klicken Sie JA um dieses Problem zu ignorieren und den Rest abzuschneiden.",
  ":Problem encountered before CODE MEMORY programming",
    "d:Vor dem Programmieren des Codespeichers trat ein Problem auf",
  ":CODE",
    "d:CODE",
  ":DATA",
    "d:DATA",
  ":CONFIG",
    "d:CONFIG",
  ":CONFIG-WORD",
    "d:CONFIG-WORD",
  ":Programming %s, 0x%06lX..0x%06lX",
    "d:Programmiere %s, 0x%06lX..0x%06lX",
  ":Skipped CODE MEMORY programming.",
    "d:Programmierung des Codespeichers wurde bersprungen.",
  ":Replaced OSCCAL word in buffer: old=0x%06lX, new=0x%06lX .",
    "d:OSCCAL-Word wurde im Puffer ersetzt: alt=0x%06lX, neu=0x%06lX .",
  ":Using old OSCCAL word from buffer (0x%06lX) .",
    "d:Verwende altes OSCCAL-Wort aus dem Puffer (0x%06lX) .",
  ":Warning: using default OSC CALIB word instead of 0x%06lX .",
    "d:Warnung: verwende Default-OSCCAL-Wort statt 0x%06lX .",
  ":Cannot Program CODE MEMORY, nothing in buffer.",
    "d:Kann CODE-Speicher nicht programmieren, nichts im Puffer.",
  ":USER BREAK while programming.",
    "d:Programmierung durch Benutzer abgebrochen.",
  ":USER BREAK while verifying.",
    "d:Vergleichsprfung durch Benutzer abgebrochen.",
  ":USER BREAK",
    "d:ABBRUCH",
  ":Programming OK",
    "d:Programmierung OK",
  ":Programming error !",
    "d:Programmierung: Fehler !",
  ":Programming DATA EEPROM, 0x%06lX..0x%06lX",
    "d:Programmiere Daten-EEPROM, 0x%06lX..0x%06lX",
  ":Cannot program DATA MEMORY, nothing in buffer.",
    "d:Kann Daten-EEPROM nicht programmieren, nichts im Puffer.",
  ":Programming CONFIG-MEMORY, 0x%06lX..0x%06lX",
    "d:Programmiere Config.-Speicher, 0x%06lX..0x%06lX",
   ":Suspicious: Buffer contains no data for the CONFIGURATION BITS.",
    "d:Verdchtig: Puffer enthlt keine Daten fr die KONFIGURATIONS-BITS.",
  ":Restoring BANDGAP calibration bits for CONFIG-WORD",
    "d:Restauriere BANDGAP-Kalibrier-Bits im Config-Wort",
  ":Cfg word before restoring BG calib: 0x%06lX",
    "d:Cfg-Wort vor Restauration der BG-Bits: 0x%06lX",
  ":Cfg word after restoring BG calib: 0x%06lX",
    "d:Cfg-Wort nach Restauration der BG-Bits: 0x%06lX",
  ":Programming CONFIG-WORD",
    "d:Programmiere CONFIG-WORT",
  ":Config word = 0x%06lX; Config mask = 0x%06lX",
    "d:Config-Wort = 0x%06lX; Config-Maske = 0x%06lX",
  ":Programming finished, no errors.",
    "d:Programmierung beendet, keine Fehler.",
  ":Programming finished, nothing to do.",
    "d:Programmierung beendet, nichts zu tun.",
  ":ERROR: Programming FAILED !",
    "d:FEHLER: Programmierung ging schief !",


  // in TPicMain::VerifyPic() ......................................
  ":Verifying...",
    "d:Vergleiche...",
  ":Verifying",
    "d:Vergleiche",
  ":Cannot verify at different voltages with this hardware.",
    "d:Kann den PIC nicht bei verschiedenen Spannungen vergleichen.",
  ":Verifying at nominal supply voltage...",
    "d:Vergleiche bei normaler Versorgungsspannung...",
  ":Verifying at low supply voltage...",
    "d:Vergleiche bei niedriger Versorgungsspannung...",
  ":Verifying at high supply voltage...",
    "d:Vergleiche bei hoher Versorgungsspannung...",
  ":Verifying CODE",
    "d:Vergleiche CODE",
  ":No PROGRAM CODE in buffer to verify.",
    "d:Kein PROGRAMMCODE zum Vergleichen im Puffer.",
  ":Verifying DATA",
    "d:Vergleiche DATEN",
  ":No DATA MEMORY in buffer to verify.",
    "d:Keine DATEN zum Vergleichen im Puffer.",
  ":Verifying CONFIG-MEMORY",
    "d:Vergleiche Config-Speicher",
  ":Verify finished, no errors.",
    "d:Vergleich beendet, keine Fehler.",
  ":Nothing to verify in buffer.",
    "d:Nichts zum Vergleichen im Puffer.",
  ":ERROR: Verifying FAILED !",
    "d:FEHLER: Vergleichen ging schief !",


  // in TPicMain::UpdateIdAndConfMemDisplay() .....................
  ":ID- and Config-Memory",  // in PicMain.Label8
    "d:ID- und Konfig-Speicher",
  ":show ALL locations",  // in PicMain.Chk_ShowAllCfgCells
    "d:Zeige ALLE Zellen",
  ":Info",
    "d:Info",  
  ":Address",
    "d:Adresse",
  ":Value",
    "d:Wert",
  ":<unknown ID>",
    "d:<ID unbekannt>",
  ":( * = reserved )",      // in PicMain.Label10
    "d:( * = reserviert )",    



  // in TPicMain::UpdateDeviceConfigTab() ..................................
  ":unknown PIC type",
    "d:unbekannter PIC-Typ",
  ":<not applicable>",
    "d:<nicht anwendbar>",


  // in TPicMain::UpdateInterfaceInputSignalDisplay() .......................
  ":button up",  // use short text. This "button" is an optional pressbutton on the programmer
    "d:nicht gedrckt",
  ":button DOWN",  // use short text. This "button" is an optional pressbutton on the programmer
    "d:Taste GEDRCKT",
  ":(no button)",
    "d:(keine Taste)",


  // in TPicMain::Chk_TestXXXClick() ........................................
  ":PIC- Clock/Data failed",
    "d:Fehler beim Testen von PIC-Takt/Daten",
  ":PIC- Vpp failed",
    "d:Fehler beim Testen von PIC- Vpp",
  ":PIC- Vdd failed",
    "d:Fehler beim Testen von PIC- Vdd",
  ":PIC- ClockEnable failed",
    "d:Fehler beim Testen von PIC- ClockEnable",
  ":PIC- DataEnable failed",
    "d:Fehler beim Testen von PIC- DataEnable",
  ":PIC- SelectVddLow failed",
    "d:Fehler beim Testen von SelectVddLow",
  ":PIC- SelectVddNorm failed",
    "d:Fehler beim Testen von SelectVddNorm",
  ":PIC- SelectVddHigh failed",
    "d:Fehler beim Testen von SelectVddHigh",


  // in TPicMain::UpdateInterfaceType() .....................................
  ":(unknown)",
    "d:(unbekannt)",
  ":COM84 programmer for serial port",
    "d:COM84-Programmer am seriellen Port",
  ":JDM (2) for serial port",
    "d:JDM (2) am seriellen Port",    
  ":PIP84 by SM6LKM, Data->PAPER (Pin12)",
    "d:PIP84 von SM6LKM, Data->PAPER (Pin12)",
  ":PIP84 by SM6LKM, Data->ACK (Pin10)",
    "d:PIP84 von SM6LKM, Data->ACK (Pin10)",
  ":PIC Flash prog by SM6LKM (2002-10)",
    "d:PIC Flash Prog von SM6LKM (2002-10)",
  ":Tait, 7406(inverter)+4066(switch)",
    "d:Tait, 7406(Inverter)+4066(Schalter)",
  ":Tait, 7407(driver) + 4066(switch)",
    "d:Tait, 7407(Treiber) + 4066(Schalter)",
  ":Tait, 7406(inverter)+PNP transistor",
    "d:Tait, 7406(Inverter)+PNP-Transistor",
  ":Tait, 7407(driver) + PNP transistor",
    "d:Tait, 7406(Treiber) + PNP-Transistor",
  ":Microchip AN589",
    "d:Microchip AN589",
  ":Custom, on LPT port, defined by FILE",
    "d:Selbstdefiniert (per Datei), an LPT",
  ":Custom, on COM port, defined by FILE",
    "d:Selbstdefiniert (per Datei), an COM",
  ":Custom, on any port, from plugin-DLL",
    "d:Selbstdefiniert, aus Plugin-DLL",
  ":Illegal interface code number",
    "d:Illegale Interface-Code-Nummer",
  ":(unknown)",
    "d:(unbekannt)",

  // in TPicMain::SetInterfaceInternal ......................................
  ":SetInterfaceType ok.",
    "d:Setzen des Interfaces ok.",
  ":Error in SetIntf() : ",     // ... followed by an error message from the system
    "d:Fehler bei SetIntf() : ",

  // in TPicMain::Btn_SelectCustomInterfaceClick() ..........................
  ":Load custom interface definition file (don't change dir)",
    "d:Lade Interface-Definitions-Datei (Pfad nicht ndern !)",


  // in TPicMain::Timer1Timer() .............................................
  ":WARNING ! Windows fooled around with the LPT port bits !",
    "d:WARNUNG ! Windows hat Signale am LPT-Port umgeschaltet !",
  ":Parsing argument from command line",
    "d:Bearbeite Argument aus Kommandozeile",
  ":Command execution (%s) continues in %d seconds ... ESC to stop",
    "d:Batch-Bearbeitung (%s) geht in %d Sekunden weiter ... Stop mit ESC",
  ":Dump would overwrite existing file.\n  Erase old file ?",
    "d:Abspeichern wrde eine existierende Datei berschreiben.\n  Alte Datei berschreiben ?",
  ":Confirm overwrite",
    "d:berschreiben einer Datei besttigen",
  ":Device has been erased.",
    "d:Chip wurde gelscht.",
  ":Device has been erased. PROGRAM TO RESTORE CALIB BITS !!",
    "d:Chip wurde gelscht. NEU PROGRAMMIEREN UM DIE CALIB-BITS ZU RETTEN !!",
  ":Erasing FAILED !",
    "d:Lschen ging schief !",
  ":.. stopped parsing cmd-line",
    "d:.. Abarbeiten der Kommandozeile abgebrochen",
  ":Loaded file \"%s\" through command line .",
    "d:Datei \"%s\" per Kommandozeile geladen .",
  ":Command line finished",
    "d:Kommandozeile beendet",
  ":BATCH PROG: Insert device or connect ICSP, then press Enter or OK !",
    "d:Batchbetrieb: Chip einsetzen oder anschlieen, dann ENTER oder OK drcken !",
  ":BATCH PROG: please wait..",
    "d:Batchbetrieb: Bitte warten..",
  ":BATCH PROG: terminated batch mode.",
    "d:Batchbetrieb: Batch-Modus beendet.",
  ":ESC: Command-line driven operation cancelled !",
    "d:ESC: Abarbeiten der Kommandozeile abgebrochen !",


  // Other subroutines in WinPicPr.cpp ......................................
  ":Load Hex File",
    "d:Lade Daten aus Hex-File",
  ":Loading...",
    "d:Lade...",    
  ":Can't open hexfile \"%s\"",
    "d:Kann Hex-File nicht ffnen : \"%s\"",
  ":Save Hex File",
    "d:Speichern als Hex-File",
  ":Can't create hexfile",
    "d:Kann Hex-File nicht erzeugen",
  ":Results from LoadHex: LastProgAdr=0x%06lX LastDataAdr=0x%06lX",
    "d:Resultat von LoadHex: LastProgAdr=0x%06lX LastDataAdr=0x%06lX",
  ":Info: Config word set to 0x%06lX from command line .",
    "d:Info: Config-Wort per Kommandozeile auf 0x%06lX gesetzt .",
  ":Aborting LoadAndProgram because of error(s)",
    "d:Abbruch von 'LoadAndProgram' wegen Fehler(n)",
  ":Updating..",
    "d:Aktualisieren..",
  ":Programming CONFIG-WORD",
    "d:Programmiere CONFIG-Wort",
  ":Programming CONFIG-WORD done.",
    "d:Programmierung CONFIG-WORT fertig.",
  ":Programming CONFIG-WORD FAILED.",
    "d:Programmierung CONFIG-WORT FEHLERHAFT.",
  ":Programming ID-locations",
    "d:Programmiere ID-Speicherzellen",
  ":Programming ID-LOCATIONS done.",
    "d:Programmierung der ID-Zellen fertig.",
  ":Programming ID-LOCATIONS FAILED.",
    "d:Programmierung der ID-Zellen FEHLERHAFT.",
  ":The BULK ERASE option is disabled\n   in the programmer options.\n Erase EVERYTHING anyway ?",
    "d:Die Option 'BULK ERASE' ist in den\n   Programmer-Optionen abgeschaltet.\n Trotzdem ALLES lschen ?",
  ":Confirm ERASE ALL",
    "d:Besttige 'ALLES LSCHEN'",
  ":Turn HEX-EDITOR on ?",
    "d:Den HEX-EDITOR einschalten ?",
  ":Apply changes in the HEX EDITOR ?",
    "d:nderungen im HEX-EDITOR bernehmen ?",
  ":WinPic: turning CODE MEMORY editor off..",
    "d:WinPic: Schalte den CODE-Speicher-Editor ab..",
  ":Do you want to APPLY the edits\n in the code memory buffer ?",
    "d:Wollen Sie die nderungen\n im CODESPEICHER bernehmen ?",
  ":WinPic: turning DATA MEMORY editor off..",
    "d:WinPic: Schalte den DATEN-Speicher-Editor ab..",
  ":Do you want to APPLY the edits\n in the data memory buffer ?",
    "d:Wollen Sie die nderungen\n im DATENSPEICHER bernehmen ?",
  ":Cannot parse line %d in CODE MEMORY dump.",
    "d:Kann Hex-Zeile %d im CODE-Fenster nicht analysieren",
  ":Applied edits in CODE-MEMORY-dump.",
    "d:nderungen im CODE-Fenster wurden bernommen.",
  ":Cannot parse line %d in DATA MEMORY dump.",
    "d:Kann Hex-Zeile %d im DATEN-Fenster nicht analysieren",
  ":Applied edits in DATA-MEMORY-dump.",
    "d:nderungen im DATEN-Fenster wurden bernommen.",
   ":Some CALIBRATION BITS have been erased\n but not written back to the PIC yet.\nTerminate anyway and lose these bits forever ?",
    "d:Einige KALIBRIERUNGS-Bits wurden gelscht\n aber noch nicht in den PIC zurckgeschrieben.\nTrotzdem beenden und diese Bits verlieren ?",
   ":*** PIC Programmer Warning ***",
    "d:*** Warnung vom PIC-Programmer ***",


  // Other "forms" (outside the main form)  .................................
  ":About...",   // in AbtForm
    "d:Programm-Info...",
  ":Compiled:",  // in AbtForm.Label1
    "d:Compilierung:",

  ":&Reload && program",  // in ToolForm.Btn_ReloadAndProg   AND  main menu
    "d:&Neuladen && Prog.",

  // Messages from subroutines in module  PIC_PRG.CPP ......................
  ":Programming 0x%06lX..0x%06lX, algo=\"%s\", CanRead=%d .",
    "d:Programmiere 0x%06lX..0x%06lX, Algo=\"%s\", CanRead=%d .",
  ":Erase: Read osccal, result 0x%06lX",
    "d:Erase: Lese osccal, Ergebnis=0x%06lX",
  ":Erase: Read cfg with bandgap ref, result 0x%06lX",
    "d:Erase: Lese Cfg mit Bandgap-Referenz, Ergebnis=0x%06lX",
  ":Oscillator calibration word looks bad (0x%06lX) !",
    "d:Oszillator-Kalibrier-Wort sieht schlecht aus (0x%06lX) !",
  ":Erasing chip using algorithm \"%s\" .",
    "d:Lsche Chip mit Algorithmus \"%s\" .",
  ":EraseAll: Read config word 0x%06lX",
    "d:EraseAll: Gelesenes Config-Wort=0x%06lX",
  ":EraseAll: Device is protected, using CHIP erase",
    "d:EraseAll: Chip schreibgeschtzt, verwende CHIP-Erase",
  ":EraseAll: Device is not protected, using BULK erase",
    "d:EraseAll: Nicht schreibgeschtzt, verwende BULK-Erase",
  ":EraseAll: missing bulk erase algorithm !",
    "d:EraseAll: Bulk-Erase-Algorithmus fehlt !",
  ":Verify Error: %06lX: read %06lX, wanted %06lX",
    "d:Fehler beim Vergleichen: %06lX: gelesen=%06lX, erwartet=%06lX",
  ":Programming aborted after %d errors.",
    "d:Programmierung nach %d Fehlern abgebrochen.",
  ":Verifying 0x%06lX..0x%06lX",
    "d:Vergleiche 0x%06lX..0x%06lX",
  ":More Verify Errors, unable to list all (total=%d)",
    "d:Weitere Vergleichsfehler, kann nicht alle auflisten (Gesamt=%d)",
  ":Action aborted",         // caution, used in various places ! DONT CHANGE !
    "d:Aktion abgebrochen",

  // Messages from subroutines in module  DEVICES.CPP ......................
  ":Info: Loading definitions for \"%s\" from %s .",
    "d:Info: Lade Definitionen fr \"%s\" aus %s .",
  ":Couldn't find \"%s\", please borrow/copy from MPLAB !",
    "d:Konnte \"%s\" nicht finden, bitte von MPLAB kopieren !",

  // Large but rarely used strings should be added at the end of the table.
  // Note that some old text editors cannot handle more than 255 chars per line!

  ":end of table", "d:Ende", "f:Fin", "i:finito",

  "\0\0\0\0", NULL   // end of table (zero-string and NULL-pointer)
}; // end TranslationTable[]



