/*-------------------------------------------------------------------------*/
/* ToolWin1.H                                                              */
/*                                                                         */
/*   Small "tool windows" for DL4YHF's PIC programmer.                     */
/*                                                                         */
/*  Contains the button "Reload & Program"                                 */
/*    which can be used to reload the last used hex file and program it.   */
/*    Can be set in front of all other windows,                            */
/*    for example in front of MPLAB and other development systems .        */
/*-------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
#ifndef ToolWin1H
#define ToolWin1H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>

//---------------------------------------------------------------------------
// Not very clever, but the author is no windows freak:
//   Some flags for communication between 'tool window' and 'main window' .
//   Polled(!) in the main window's TIMER method (yes, it's UGLY ! ;-)
//---------------------------------------------------------------------------

extern BOOL ToolWin_fReloadAndProgClicked;
extern int  ToolWin_iX1, ToolWin_iY1;
extern int  ToolWin_iVisible;


#define TWMSG_NO_CHANGE -1
#define TWMSG_NO_ERROR  0
#define TWMSG_SUCCESS   1
#define TWMSG_ERROR     2


//---------------------------------------------------------------------------
class TToolForm : public TForm
{
__published:	// IDE-managed Components
        TButton *Btn_ReloadAndProg;
        TLabel *Lab_Info;
        TProgressBar *ProgressBar1;
        TButton *Btn_ToMain;
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall Btn_ReloadAndProgClick(TObject *Sender);
        void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
        void __fastcall FormShow(TObject *Sender);
        void __fastcall Btn_ToMainClick(TObject *Sender);

protected:
        virtual void __fastcall CreateParams(TCreateParams &Params);         

private:	// User declarations
public:		// User declarations
        __fastcall TToolForm(TComponent* Owner);
        void __fastcall ShowMsg(char *pszMsg, int iErrorStatus);
        int m_iCurrentErrorStatus;

};
//---------------------------------------------------------------------------
extern PACKAGE TToolForm *ToolForm;
//---------------------------------------------------------------------------
#endif
