/*-------------------------------------------------------------------------*/
/* ToolWin1.cpp                                                            */
/*                                                                         */
/*   Small "tool window" for DL4YHF's PIC programmer.                      */
/*                                                                         */
/*  Contains the button "Reload & Program"                                 */
/*    which can be used to reload the last used hex file and program it.   */
/*    Can be set in front of all other windows,                            */
/*    for example in front of MPLAB and other development systems .        */
/*-------------------------------------------------------------------------*/


//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "WinPicPr.h"  // declaration of the MAIN FORM
#include "Config.h"

#include "ToolWin1.h"


//---------------------------------------------------------------------------
// Not very clever, but the author is no windows freak:
//   Some flags for communication between 'tool window' and 'main window' .
//   Polled(!) in the main window's TIMER method (yes, it's UGLY ! ;-)
//---------------------------------------------------------------------------

BOOL ToolWin_fReloadAndProgClicked = FALSE;
int  ToolWin_iX1 = 30, ToolWin_iY1 = 30;
int  ToolWin_iVisible = 0;   // used as default if no config file was found !



//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TToolForm *ToolForm;
//---------------------------------------------------------------------------
__fastcall TToolForm::TToolForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TToolForm::CreateParams(TCreateParams &Params)
{
 // Based on the "transparent forms" and several other articles found on the net.
 // With Borland's insufficient help on "CreateParams" I'd never get this working !

  // Get the inherited functionality first
  TForm::CreateParams(Params);

  // Now modify the settings...
  Params.ExStyle |= WS_EX_TOPMOST;
   // Params.Style   &= !WS_CAPTION;   // not really necessary, seems to turn the "close-[X]" off !

  // Do not minimize this window when its parent (=WinPic) is minimized :
  Params.WndParent = GetDesktopWindow();
} // end TToolForm::CreateParams()  [ manually inserted, not managed by IDE ]
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TToolForm::FormCreate(TObject *Sender)
{
  m_iCurrentErrorStatus = TWMSG_NO_ERROR;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TToolForm::ShowMsg(char *pszMsg, int iErrorStatus)
{
 AnsiString sPath, sName;


  if(pszMsg==NULL || pszMsg[0]==0)
   {
    sPath = ExtractFilePath( Config.sz255HexFileName );
    sName = ExtractFileName( Config.sz255HexFileName );

    if(sPath!="")
            Lab_Info->Caption = sPath + sName;
       else Lab_Info->Caption = sName;
   }
  else
   {        Lab_Info->Caption = pszMsg;
   }
  Lab_Info->Hint = Lab_Info->Caption;  // suggestion from Brian Edge, 2006-03-25
  m_iCurrentErrorStatus = iErrorStatus;
  switch(iErrorStatus)
    {
       case TWMSG_NO_CHANGE:   // leave error status unchanged
            break;
       case TWMSG_NO_ERROR :   // set indicator colour to "normal"  (i.e. gray)
            Color=clBtnFace;
            break;
       case TWMSG_SUCCESS  :   // set indicator colour to "successful" (green)
            Color=clGreen;
            break;
       case TWMSG_ERROR    :   // set indicator colour to "error"   (red)
            Color=clRed;
            break;
    } // end switch(iErrorStatus)
   Update();
} // end TToolForm::ShowMsg()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TToolForm::Btn_ReloadAndProgClick(TObject *Sender)
{
  ToolWin_fReloadAndProgClicked = TRUE;  // this flag is polled(!) by the main window
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TToolForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  ToolWin_iVisible = FALSE;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TToolForm::FormShow(TObject *Sender)
{
  ToolWin_iVisible = TRUE;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
void __fastcall TToolForm::Btn_ToMainClick(TObject *Sender)
{
  PicMain->Show();         // doesn't work if main form minimized ? ?
  Application->Restore();  // A-ha: the APPLICATION(!) must also be restored !
  PicMain->SetFocus();     // now set the focus to the visible main form
  if(m_iCurrentErrorStatus==TWMSG_ERROR)
   { // if there was an error, switch to the tabsheet "messages"
     PicMain->PageControl1->ActivePage = PicMain->TS_Messages;
   }  
}
//---------------------------------------------------------------------------

