/**********************************************************************/
/*  LoadHex.H  =  Modul zum Importieren von Intel-Hex-Dateien         */
/*                 in W.B.'s HEX-Editor                               */
/*  Ermoeglicht das Einlesen von Dateien im 8-bit-Intel-Hex-Format.   */
/*  Die maximale Dateigroesse ist nur durch den von HEX_ED bereit-    */
/*  gestellten Puffer begrenzt.                                       */
/*                                                                    */
/*  Versions-Historie:                                                */
/*  2005-03-07: Einsatz im "CAN-Tester fr Windows" / FW-Update (QRL) */
/*  2005-02-23: Einsatz in DL4YHF's WinPic, mit Erweiterungen fuer    */
/*              die etwas merkwuerdigen HEX-Dateien von Microchip,    */
/*              speziell fuer dsPIC's mit "24-Bit-Instruktionen" .    */
/*  2000-03-29: Laderoutine fuer "Simple HEX Format" aus dem          */
/*               privaten Fundus von DL4YHF uebernommen.              */
/*                                                                    */
/**********************************************************************/

#ifndef BYTE
  #define BYTE unsigned char
#endif

#ifndef WORD
  #define WORD unsigned int
#endif

#ifndef DWORD
  #define DWORD unsigned long
#endif

#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* nicht "cplusplus" */



//--------------- Typen ---------------------------------------------
typedef void(* T_HexLoadCallback)(DWORD dwHexSourceLine,DWORD dwLinearByteAddress, BYTE bData); // callback for 'load file'

//--------------- Prototypen ----------------------------------------
CPROT long LoadHexFile( char *fname, T_HexLoadCallback pvLoadCallback, char *sz80ErrorMessage );
      // loads data from an INTEL-HEX-file


// EOF <LoadHex.h>