/*-------------------------------------------------------------------------*/
/*     CONFIG - module for DL4YHF's simple PIC-Programmer under Windows    */
/*-------------------------------------------------------------------------*/

#include <vcl.h>
#include <IniFiles.hpp>
#include <string.h>
#pragma hdrstop

#include "appl.h"     // CALLER definitions
#include "pic_hw.h"   // interface types etc for default values
#include "pic_prg.h"

#define _I_AM_CONFIG_  /* for single-source-variables in CONFIG.H */
#include "Config.h"


/*---------------- Implementation -----------------------------------------*/
void CFG_Init(void)
{
  memset( &Config, 0, sizeof(Config) );
  Config.pic_interface_type = PIC_INTF_TYPE_COM84;
  Config.iComPortNr = 1;    // enter your favorite COM port number here ;-)
  Config.iComIoAddress = 0; // do NOT use a non-standard I/O address for the COM port
  strcpy(Config.sz40DeviceName,"unknown");
  Config.dwUnknownCodeMemorySize = 4096;  // used for PIC_DEV_TYPE_UNKNOWN..
  Config.dwUnknownDataMemorySize = 256;   // ..for a trial to program exotic types

  strcpy( Config.sz255HexFileName, "test.hex" );
  strcpy( Config.sz80InterfaceSupportFile, "MyProg.ini" );
  Config.sz80InterfacePluginDLL[0] = '\0';
  Config.sz255MplabDevDir[0] = '\0';      // don't read DEV-files from MPLAB directly
  Config.iExtraRdDelay_us  = 3; // seemed to be important for the JDM2, when using PortTalk access
  Config.iExtraClkDelay_us = 2; // "       "   " ...  (2005-11-07)
     // Note: the author's "JDM 2" required at least 2 microseconds before READ,
     //       and 1 microseconds for every clock-L and clock-H-period;
     //    so setting Config.iExtraRdDelay_us=3
     //       and Config.iExtraClkDelay_us=2 by default sounds reasonable.

  Config.iSlowInterface = 0;    // hardly required any longer since the above "fine-tuning" delays
  Config.iIdleSupplyVoltage = 1/*norm*/ ;
  Config_changed = 0x0000;
}

void CFG_Load(void) /* Loads configuration data from a file */
{
 AnsiString section;
 AnsiString s;

  TIniFile *pIniFile = new TIniFile(
          ExtractFilePath(Application->ExeName) + CFG_INI_FILE_NAME );

  section = "INTERFACE";
  Config.pic_interface_type = pIniFile->ReadInteger(section, "InterfaceType",Config.pic_interface_type);
  strncpy(Config.sz80InterfaceSupportFile, pIniFile->ReadString(section, "SupportFile","" ).c_str(), 80);
  strncpy(Config.sz80InterfacePluginDLL  , pIniFile->ReadString(section, "PluginDLL","" ).c_str(), 80);
  Config.iExtraRdDelay_us  = pIniFile->ReadInteger(section, "ExtraRdDelay_us",Config.iExtraRdDelay_us);
  Config.iExtraClkDelay_us = pIniFile->ReadInteger(section, "ExtraClkDelay_us",Config.iExtraClkDelay_us);
  Config.iSlowInterface = pIniFile->ReadInteger(section, "SlowClockPulses", 0 ); // since 2005-06
  Config.iIdleSupplyVoltage = pIniFile->ReadInteger(section, "IdleSupplyVoltage", 1/*norm*/ );
  Config.iWhichPortAccessDriver = pIniFile->ReadInteger(section, "PortAccessDriver", CFG_PORTACCESS_SMPORT );

  section = "PROGRAMMING_ALGORITHM";
 // PIC_dev_param.iProgModeSequence =  // usually 0=PROGMODE_VDD_THEN_VPP (except for DS41173b)
 //        pIniFile->ReadInteger(section, "ProgModeSequence", 0 );

  section = "COM84_INTERFACE";
  Config.iComPortNr = pIniFile->ReadInteger(section, "ComPortNumber", Config.iComPortNr );
  Config.iComIoAddress = pIniFile->ReadInteger(section, "UnusualIoAddress", 0 );

  section = "LPT_INTERFACE";
  Config.iLptPortNr = pIniFile->ReadInteger(section, "LptPortNumber",    Config.iLptPortNr );
  Config.iLptIoAddress=pIniFile->ReadInteger(section, "UnusualIoAddress", 0 );

  section = "SESSION";
  strncpy(Config.sz255HexFileName, pIniFile->ReadString(section, "HexFileName", Config.sz255HexFileName ).c_str(), 255 ) ;
  Config.sz255HexFileName[255]='\0';  // keep strings terminated !

  section = "PROGRAMMER";
  Config.iProgramWhat = pIniFile->ReadInteger(section, "ProgramWhat", PIC_PROGRAM_ALL );
  Config.iUseCompleteChipErase= pIniFile->ReadInteger(section, "UseBulkErase", 1 );
  Config.iDisconnectAfterProg= pIniFile->ReadInteger(section, "Disconnect", 1 );
  Config.iVerifyAtDifferentVoltages= pIniFile->ReadInteger(section, "VerifyDifferentVoltages", 1 );
  Config.iDontCareForOsccal  = pIniFile->ReadInteger(section, "DontCareForOsccal", 0 );
  Config.iDontCareForBGCalib = pIniFile->ReadInteger(section, "DontCareForBGCalib",0 );
  Config.iClearBufBeforeLoad = pIniFile->ReadInteger(section, "ClearBufferBeforeLoading",0 );
  Config.iNeedPowerBeforeRaisingMCLR = pIniFile->ReadInteger(section, "NeedVddBeforeRaisingMCLR",1 );

  Config.iVerboseMessages  = pIniFile->ReadInteger(section, "VerboseMessages",0 );

  section = "PIC";   // PIC-specific stuff ...
  s = pIniFile->ReadString(section, "PathToDevFiles", "" );
  strncpy(Config.sz255MplabDevDir, s.c_str(), 255); // path to MPLAB's 'DEVICE'-folder

  // old:  Config.pic_device_type = pIniFile->ReadInteger(section, "DeviceType",Config.pic_device_type );
  // Since the device TYPE NUMBERS keep changing and never had a useful meaning,
  //       a full PIC DEVICE NAME is saved as a STRING in the ini file since Nov. 2002 .
  s = pIniFile->ReadString(section, "DeviceType", "" );
  strncpy(Config.sz40DeviceName, s.c_str(), 40);
  Config.iUnknownDevHasFlashMemory = pIniFile->ReadInteger(section, "HasFlashMemory",
         Config.iUnknownDevHasFlashMemory);
  Config.dwUnknownCodeMemorySize = pIniFile->ReadInteger(section, "UnknownCodeSize",
         Config.dwUnknownCodeMemorySize );
  Config.dwUnknownDataMemorySize = pIniFile->ReadInteger(section, "UnknownDataSize",
         Config.dwUnknownDataMemorySize );

  delete pIniFile;
  Config_changed = 0x0000;
}

void CFG_Save(void) /* Saves the APPLICATION'S configuration in a file */
{
 AnsiString section;

  TIniFile *pIniFile = new TIniFile(
          ExtractFilePath(Application->ExeName) + CFG_INI_FILE_NAME );

  section = "INTERFACE";
  pIniFile->WriteInteger(section, "InterfaceType", Config.pic_interface_type);
  pIniFile->WriteString( section, "SupportFile",   Config.sz80InterfaceSupportFile);
  pIniFile->WriteString( section, "PluginDLL",     Config.sz80InterfacePluginDLL );
  pIniFile->WriteInteger(section, "ExtraRdDelay_us",Config.iExtraRdDelay_us);
  pIniFile->WriteInteger(section, "ExtraClkDelay_us",Config.iExtraClkDelay_us);
  pIniFile->WriteInteger(section, "SlowClockPulses", Config.iSlowInterface );
  pIniFile->WriteInteger(section, "IdleSupplyVoltage",Config.iIdleSupplyVoltage );
  pIniFile->WriteInteger(section, "PortAccessDriver", Config.iWhichPortAccessDriver );

  // section = "PROGRAMMING_ALGORITHM";
  // pIniFile->WriteInteger(section, "ProgModeSequence", PIC_dev_param.iProgModeSequence );

  section = "COM84_INTERFACE";
  pIniFile->WriteInteger(section, "ComPortNumber", Config.iComPortNr );
  pIniFile->WriteInteger(section, "UnusualIoAddress", Config.iComIoAddress );  

  section = "LPT_INTERFACE";
  pIniFile->WriteInteger(section, "LptPortNumber",    Config.iLptPortNr );
  pIniFile->WriteInteger(section, "UnusualIoAddress", Config.iLptIoAddress );

  section = "SESSION";
  pIniFile->WriteString(section, "HexFileName", Config.sz255HexFileName );

  section = "PROGRAMMER";
  pIniFile->WriteInteger(section, "ProgramWhat", Config.iProgramWhat );
  pIniFile->WriteInteger(section, "UseBulkErase",Config.iUseCompleteChipErase );
  pIniFile->WriteInteger(section, "Disconnect",  Config.iDisconnectAfterProg);
  pIniFile->WriteInteger(section, "VerifyDifferentVoltages",Config.iVerifyAtDifferentVoltages);  
  pIniFile->WriteInteger(section, "DontCareForOsccal",Config.iDontCareForOsccal);
  pIniFile->WriteInteger(section, "DontCareForBGCalib",Config.iDontCareForBGCalib);
  pIniFile->WriteInteger(section, "ClearBufferBeforeLoading", Config.iClearBufBeforeLoad);
  pIniFile->WriteInteger(section, "NeedVddBeforeRaisingMCLR", Config.iNeedPowerBeforeRaisingMCLR );
  pIniFile->WriteInteger(section, "VerboseMessages", Config.iVerboseMessages );

  section = "PIC";
  pIniFile->WriteString(section, "PathToDevFiles", Config.sz255MplabDevDir );
  pIniFile->WriteString(section, "DeviceType", Config.sz40DeviceName );
  pIniFile->WriteInteger(section, "HasFlashMemory", Config.iUnknownDevHasFlashMemory);
  pIniFile->WriteInteger(section, "UnknownCodeSize",Config.dwUnknownCodeMemorySize);
  pIniFile->WriteInteger(section, "UnknownDataSize",Config.dwUnknownDataMemorySize);

  delete pIniFile;

  Config_changed &= ~APPL_CALLER_SAVE_CFG;
}



/* EOF <config.c> */