//---------------------------------------------------------------------------
// File  :  PHW_framework1.c
// Date  :  2008-05-06   (YYYY-MM-DD)
// Author:  Wolfgang Buescher  (DL4YHF)
// Location: <DL4YHF>C:\cbproj\WinPicPr\interface_dll_sources\PHW_framework1.c
//
// Description:
//   Some *OPTIONAL* framework for PIC-Programmer-Interfaces with a simple GUI .
//   Creates a small control window without a message loop (non-blocking !).
//   The plugin may later draw something into that window using plain old
//   windows GDI functions; see PHW_demo_jdm2.c for an example .   
//
// Compile with Dev-Cpp or Borland C++ Builder V4;
//         MS-C may work but never tested.
//

#include <windows.h>

#include "PHW_intf_dll.h"   /* header for all PIC-Hardware-Interface-DLLs */
#include "PHW_framework.h"  /* some optional framework for the " " "  "   */
#include "icon_identifiers.h" /* IDI_PHW_MAIN_ICON, etc [from resource]   */

//---------------------------------------------------------------------
// Compilation switches .
//  MAY be defined under compiler options, or in a header like SWITCHES.H
//---------------------------------------------------------------------

#ifndef  SWI_PLUGIN_WINDOW_WIDTH
 #define SWI_PLUGIN_WINDOW_WIDTH 200
#endif

#ifndef  SWI_PLUGIN_WINDOW_HEIGHT
 #define SWI_PLUGIN_WINDOW_HEIGHT 130
#endif


//---------------------------------------------------------------------
// Internal prototypes and variable ..
//---------------------------------------------------------------------

/*  Declare Windows procedure  */
LRESULT CALLBACK PHW_WindowProc(HWND, UINT, WPARAM, LPARAM);

// Because the 'Window procedure' callback doesn't contain a pointer
// to the PIC-hardware-plugin info, we need this ugly variable :
static T_PHWInfo *FPHW_pInfo = NULL;
static BOOL FPHW_fWinClassRegistered = FALSE;
int    FPHW_iDllInstanceCount = 0; // instance counter of the DLL

BOOL     g_fPaused = FALSE;

/*  Make the class name into a global variable  */
char szClassName[ ] = "PIC-HW-Plugin";


/***************************************************************************/
BOOL PHW_OpenControlPanel(
       T_PHWInfo *pInfo,       // plugin info
       char *pszWindowTitle)   // text which appears in the window title
  // Use this function as a template for your own control window !
{
  WNDCLASSEX wincl;        /* Data structure for the windowclass */
  int i;

  if( pInfo->dwhPluginWindow == 0 )
   { // Create the window only if it hasn't been created yet !

     // If it's the FIRST window opened by this plugin,
     //  then register the window class,
     //    and if it fails don't try to create a window.
     if( ! FPHW_fWinClassRegistered )
      {
        // Fill the "window class" structure, similar to a windows application
        memset( &wincl, 0, sizeof(wincl) );
        wincl.cbSize = sizeof (WNDCLASSEX);
        wincl.hInstance = (HINSTANCE)pInfo->dwhAppInstance;
        wincl.lpszClassName = szClassName;
        wincl.lpfnWndProc = PHW_WindowProc;  /* This function is called by windows */
        wincl.style = CS_DBLCLKS;            /* Catch double-clicks */

        // About hIconSm:
        //  >  Handle to a small icon that is associated with the window class.
        //  > If this member is NULL, the system searches the icon resource
        //  > specified by the hIcon member for an icon of the appropriate
        //  > size to use as the small icon.
        // Here, we cannot access the application's main icon. Instead,
        // try to load the icon from the resource embedded in the plugin DLL.
        // This is tricky... often the plugin's window title bar had an EMPTY
        // icon. For example, none of the following attempts worked :
        // ; wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
        // ; wincl.hIcon = LoadIcon (NULL, MAKEINTRESOURCE(IDI_PHW_MAIN_ICON) );
        // ; wincl.hIconSm = LoadIcon (NULL, MAKEINTRESOURCE(IDI_PHW_MAIN_ICON) );
        // ; wincl.hIcon = LoadIcon( (HINSTANCE)pInfo->dwhAppInstance, IDI_APPLICATION);
        // ; wincl.hIcon = LoadIcon( GetModuleHandle( NULL ), IDI_APPLICATION );
        // Finally gave up ... "and now for something completely different" :
        // Try to load the icon from the PLUGIN DLL which is a bit tricky .
        // Caution: pInfo->dwhPluginDll was returned by LoadLibrary, when
        //  the HOST loaded the plugin, so it's a HMODULE.
        //  But LoadImage expects a HINSTANCE, so we use a strange cast here:
        wincl.hIcon = LoadImage(
          (HINSTANCE)pInfo->dwhPluginDll, // HINSTANCE hinst, same as a HMODULE ?
           // "Handle to the module of either a DLL or executable" .
           // note the mircosoft slang: this is NOT the handle of a DLL !
           MAKEINTRESOURCE(IDI_PHW_MAIN_ICON)/*LPCTSTR lpszName*/ ,
           IMAGE_ICON/*uType*/ ,
           32/*cxDesired*/,  32/*cyDesired*/,  LR_DEFAULTCOLOR/*"fuLoad"*/ );
        wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
        wincl.lpszMenuName = NULL;  /* No menu */
        wincl.cbClsExtra = 0;       /* No extra bytes after the window class */
        wincl.cbWndExtra = 0;       /* structure or the window instance */
        wincl.hbrBackground = (HBRUSH)GetStockObject( WHITE_BRUSH ); // ex: COLOR_BACKGROUND

        if (!RegisterClassEx(&wincl) )
         { // If the window class has been registered before,
           // RegisterClassEx will fail.
           // It is important AND MUST NOT BE IGNORED,
           // because the 'window procedure' (callback address)
           // is part of the window class (not the window instance !!).
           // If RegisterClassEx fails, the previous plugin -which used
           // the same class name- has not unregistered the class
           // when the DLL was unloaded from memory. THIS IS A DANGEROUS
           // CONDITION, so we bail out here, and do NOT create a window :
           strcpy( pInfo->sz255ErrorText,"Error: Couldn't register window class !");
           return FALSE;
         }
        FPHW_fWinClassRegistered = TRUE;
      } // end if( ! FFPFW_fWinClassRegistered )

     // Because the 'Window procedure' callback doesn't contain a pointer
     // to the FFT-filter-plugin info, save the pointer to the info struct
     // so we can access it in the event handlers (see PHW_WindowProc) .
     // This is relatively safe, because WinPic will always pass
     // a pointer to the SAME T_FftFilterInfo to the plugin (the address
     // won't change between two calls), so for the moment, we can live
     // with this kludge. Anyway, it should be avoided somehow.. any idea ?
     FPHW_pInfo = pInfo;  // just a POINTER; not a STRUCTURE !

     // Now create main window, using size+position from the info struct
     if(  pInfo->iPluginWindowWidth<20 || pInfo->iPluginWindowWidth>1024
      || pInfo->iPluginWindowHeight<20 || pInfo->iPluginWindowHeight>789 )
      { // if window size and position looks invalid, restore defaults:
        pInfo->iPluginWindowWidth = SWI_PLUGIN_WINDOW_WIDTH;
        pInfo->iPluginWindowHeight= SWI_PLUGIN_WINDOW_HEIGHT;
      }
     if( pInfo->iPluginWindowX<-(pInfo->iPluginWindowWidth-10)
      || pInfo->iPluginWindowY<-(pInfo->iPluginWindowHeight-10) )
      { pInfo->iPluginWindowX = 10;
        pInfo->iPluginWindowY = 10;
      }
     pInfo->dwhPluginWindow = (DWORD)CreateWindow(
       szClassName,    // lpClassName,  pointer to registered class name
       pszWindowTitle, // "lpWindowName", pointer to window name, effectively the TITLE
       // DWORD dwStyle,        window style. Tried a lot ...
       // WS_POPUPWINDOW | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_OVERLAPPED,  // normal window
       // WS_POPUP | WS_DLGFRAME ,   // window with no title, quite unusual as main window
       WS_POPUPWINDOW | WS_CAPTION | WS_SYSMENU , // sizeable
       // WS_CAPTION,   // with title, but no icon and no system menu nor close symbol
       pInfo->iPluginWindowX,     // int x
       pInfo->iPluginWindowY,     // int y
       pInfo->iPluginWindowWidth, // int nWidth , window width
       pInfo->iPluginWindowHeight, // int nHeight, window height
       (HWND)pInfo->dwhMainWindow, // HWND hWndParent, handle to parent window:
                // if hWndParent is set, the window is minimized together with its parent
       NULL,    // HMENU hMenu,     handle to menu or child-window identifier
       (HINSTANCE)pInfo->dwhAppInstance, // HANDLE hInstance, handle to application instance
       NULL);   // LPVOID lpParam,  pointer to window-creation data

     /* Make the window visible on the screen */
     ShowWindow( (HWND)pInfo->dwhPluginWindow, SW_SHOW );

     return TRUE;

     // Note: there is NO MESSAGE LOOP in the plugin, because
     //       an application shall have only ONE such thing !
     //      (Having an message loop in the plugin would block
     //       PHW_Init() until the window was closed )
#if(0)
     /* Run the message loop. It will run until GetMessage() returns 0 */
     while (GetMessage (&messages, NULL, 0, 0))
      {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
      }
     /* The program return-value is 0 - The value that PostQuitMessage() gave */
     return messages.wParam;
#endif // no MESSAGE LOOP, instead we just return the handle to the new window:
   }
  else // window already created, just make it VISIBLE again:
   {
     ShowWindow( (HWND)pInfo->dwhPluginWindow, SW_SHOW );
   }
  return TRUE;
} // end PHW_OpenControlPanel()

/***************************************************************************/
void PHW_CloseControlPanel(T_PHWInfo *pInfo)
  // Closes the plugin's own control panel (window) without destroying it.
{
  int i;

  if( pInfo->dwhPluginWindow != 0 )
   { CloseWindow( (HWND)pInfo->dwhPluginWindow );
     // No-No: DestroyWindow( (HWND)pInfo->dwhPluginWindow );
     // Note: we do NOT destroy the window here,
     // but windows usually sends a WM_DESTROY message anyway. Why ?
   }

   FPHW_pInfo = NULL; // don't need this info any longer

} // end PHW_CloseControlPanel()

/***************************************************************************/
void PHW_UnregisterWndClassIfLastDllInstance(T_PHWInfo *pInfo)
{
  if( (pInfo!=NULL) && FPHW_fWinClassRegistered && (FPHW_iDllInstanceCount<=1) )
   { FPHW_fWinClassRegistered = FALSE;  // avoid calling twice
     UnregisterClass( szClassName, (HINSTANCE)pInfo->dwhAppInstance );
     // Note: if there are more than one instances of this DLL "loaded",
     // it's illegal to unregister the window class, because such a window
     // MAY STILL BE OPEN !
   }
} // end PHW_UnregisterWndClassIfLastDllInstance()

/***************************************************************************/
void PHW_DestroyControlPanel(T_PHWInfo *pInfo)
  // Destroys the plugin's own control panel (window) .
  // Should be called from PHW_Exit() .
  // No problem when called even though no own window was created .
{
 int i;

  if( pInfo->dwhPluginWindow != 0 )
   { DestroyWindow( (HWND)pInfo->dwhPluginWindow );
     pInfo->dwhPluginWindow = 0;   // window handle invalid now, forget it !
   }
  FPHW_pInfo = NULL; // don't need this info any longer

  // If this is the last instance of the DLL, unregister the window class:
  PHW_UnregisterWndClassIfLastDllInstance(pInfo);

} // end PHW_DestroyControlPanel()


/***************************************************************************/
LRESULT CALLBACK PHW_WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
 /* This function is called by the Windows function DispatchMessage() .
  *      Prototype dictated by windows API !
  *
  * 'Hidden' function input (in an ugly global variable):
  *    T_FftFilterInfo *FFPFW_pFilterInfo[?] = pointer to the filter plugin info.
  *    Many event handlers (which will be called from here) need that info,
  *    for example to exchange information with the worker thread.
  *    Any idea/suggestions how to get rid of this  ?
  */
{
  T_PHWInfo *pInfo = FPHW_pInfo;
  int i;

  if( (pInfo==NULL) || ((DWORD)hwnd != pInfo->dwhPluginWindow ) )
   { return DefWindowProc (hwnd, message, wParam, lParam);
   }

  switch(message)  /* handle some of the messages here ... */
   {
     case WM_WINDOWPOSCHANGED:  // user change size and/or position of the window
        // Get the new window position+size, so SpecLab can save them later:
        pInfo->iPluginWindowX = ((WINDOWPOS*)lParam)->x;
        pInfo->iPluginWindowY = ((WINDOWPOS*)lParam)->y;
        pInfo->iPluginWindowWidth = ((WINDOWPOS*)lParam)->cx;
        pInfo->iPluginWindowHeight= ((WINDOWPOS*)lParam)->cy;
        return DefWindowProc(hwnd, message, wParam, lParam);

     case WM_DESTROY: // the plugin's window is being destroyed .. sniff ;)
        // About WM_DESTROY:
        // > sent to the window procedure of the window being destroyed
        // > *after* the window is removed from the screen.
        // No-No-No: PostQuitMessage(0);  /* send a WM_QUIT to the message queue */
        // It's not clear why WM_DESTROY is sent when the user clicks the
        // 'close' symbol. So, in fact the window seems to be DESTROYED when
        // closed. We must cope with with situation here by setting the
        // window handle invalid (the handle of a DESTROYED window is invalid!).
        pInfo->dwhPluginWindow = 0; // window handle invalid now, forget it !
        // Note: don't try to call UnregisterClass here, because
        // we cannot unregister a window in its own window procedure .
        break;  // -> return 0 to indicate we have processed the message .

     case WM_KEYDOWN:
        return PHW_OnKeyDown( pInfo, wParam/*nVirtKey*/, lParam/*lKeyData*/ );
        // "An application should return zero if it processes this message"

  /* case WM_COPYDATA:
        return OnWmCopydata( hWnd,  // handle of THIS window
                     (HWND)wParam,  // handle of SENDING window
         (PCOPYDATASTRUCT)lParam);  // pointer to a COPYDATASTRUCT (read-only!)
   */

     default:                      /* for messages that we don't deal with */
        return DefWindowProc (hwnd, message, wParam, lParam);
   }

  return 0;
} // end PHW_WindowProc()

/* EOF <PHW_framework1.c > */




