//---------------------------------------------------------------------------
// File  :  PHW_framework.h
// Date  :  2008-05-06   (YYYY-MM-DD)
// Author:  Wolfgang Buescher  (DL4YHF)
// Location: <DL4YHF>C:\cbproj\WinPicPr\interface_dll_sources\PHW_framework.h
//
// Description:
//   Some framework for PIC-Hardware-Interface-plugins with their own GUI .
//   Creates a small control window without a message loop (non-blocking !).
//   Compile with Dev-Cpp or Borland C++ Builder V4;
//           MS-C may work but never tested.
//

#ifndef CPROT   /* kludge for mixed C / C++ usage */
// Note on "extern": One of Borland's examples is wrong..
//   >extern "c" = nonsense (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif


//---------------------------------------------------------------------------
// Defines
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Variables
//---------------------------------------------------------------------------
extern int FPHW_iDllInstanceCount; // instance counter of the DLL .
    // Incremented in the DLL main entry point on 'DLL_PROCESS_ATTACH',
    // decremented on 'DLL_PROCESS_DETACH'. Required to unregister window.


//---------------------------------------------------------------------------
// Functions which must be implemented in the plugin,
//   called by the event handler (in FFP_frameworkX.c)
//---------------------------------------------------------------------------
CPROT int PHW_OnKeyDown( T_PHWInfo *pInfo, int nVirtKey, long lKeyData );
  // Called from PHW_frameworkX on reception of the WM_KEYDOWN message .
  // nVirtKey : Specifies the virtual-key code of the nonsystem key.
  //            In many cases, this is simply the key's ASCII code,
  //            or one of the VK_....-values defined in WINUSER.H .
  // lKeyData : Specifies the repeat count, scan code, extended-key flag,
  //            context code, previous key-state flag, and transition-state flag,
  //            as shown in the Win32 programmer's reference on "WM_KEYDOWN" .
  // The application should return zero if it processes this message .


//---------------------------------------------------------------------------
// Functions implemented in the framework" module (FFP_frameworkX.c)
//---------------------------------------------------------------------------
CPROT BOOL PHW_OpenControlPanel( // opens an own "control window" for the plugin
       T_PHWInfo *pInfo, // plugin into, contains handle to application instance
   char *pszWindowTitle);  // text which appears in the window title
CPROT void PHW_CloseControlPanel(T_PHWInfo *pInfo);
CPROT void PHW_DestroyControlPanel(T_PHWInfo *pInfo);
CPROT void PHW_UnregisterWndClassIfLastDllInstance(T_PHWInfo *pInfo);

/* EOF <PHW_framework.h> */
