/*--------------------------------------------------------------------------*/
/*   File:   \cbproj\WSQ2\Borland_Project\switches.h                        */
/*   Contains the project specific compilation switches.                    */
/*   Copied from Spectrum Lab, but greatly stripped down for WSQ .          */
/*--------------------------------------------------------------------------*/

#ifndef  _SWITCHES_H_
 #define _SWITCHES_H_

#define IMPORTING_A_DLL   /* defined when IMPORTING a DLL (if any). */
#undef  BUILDING_THE_DLL  /* defined when BUILDING a DLL.           */

#define SWI_ALLOW_TESTING 1  /* not defined under "Project Options" anymore */

#define SWI_PAINTLIB_INCLUDED 0   /* JPEG support ? Not for WSQ !   */

#define SWI_IMAGE_VIEWER_INCLUDED 0 /* Image Viewer ? No, thanks.   */

#define SWI_DEBUG_FORM_INCLUDED 0 /* Debugging display included ?  No. */

#define SWI_SECOND_GRAM_INCLUDED 0 /* Second Spectrogram Form included ?   */

#define SWI_UTILITY1_INCLUDED 1   /* DL4YHF's "utility"-package #1 included ? */

#define SWI_CMD_WIN_INCLUDED  0   /* Interpreter Command Window included ? */

#define SWI_TERMINAL_INCLUDED 0   /* Digimode Terminal included ?          */

#define SWI_HTTP_SRV_INCLUDED 0   /* miniature HTTP Server included ?      */

#define SWI_ASIO_SUPPORTED    0   /* Support ASIO audio drivers ?          */

#define SWI_AUDIO_IO_SUPPORTED 1  /* Support the "AUDIO-IO" DLLs ?         */

#define SWI_WINAMP_PLUGINS_SUPPORTED 0  /* Use winamp plugins "directly" ? */

#define SWI_STEREO_SUPPORTED  0   /* Stereophonic input and processing ?   */

#define SWI_SDR_IQ_SUPPORTED  0   /* Support SDR-IQ (and SDR-14) by RFSPACE ? */

#define SWI_PERSEUS_SUPPORTED 0   /* Support PERSEUS (by microtelecom) ?  */

#define SWI_SUPPORT_EXTIO_DLL 1   /* support Winrad's ExtIO-DLLs (here: HOST) ? */

#define SWI_CHOPPER_SUPPORTED 0   /* chopping hardware for DC-coupled input?*/

#define SWI_CORRELATOR_INCLUDED 0 /* (cross-) correlator included ?        */

#define SWI_SOUND_TAB_INCLUDED 0  /* Module SoundTab.cpp included ?        */

#define SWI_SMPORT_INCLUDED   0   /* TSmPort.cpp included ? (removed forever!) */

#define SWI_FFT_RESULT_FLOAT  1   /* 0=INT16 result,   1=FLOAT result      */

#define SWI_USE_OOURAS_FFT 0 /* 1=use Ooura's FFT,  0=use something else   */

#define SWI_USE_KISS_FFT   0 /* use Mark Borgerding's radix-N 'KISS' FFT ? */
   // See benchmark result in WSQ_DecodeAudio() .
   // Compared with [SGDSP] and KISS FFT, Ooura's FFT was the fastest by far .

#define SWI_RA_SPECTRUM_INCLUDED 0 /* Support 'reassigned spectrograms' ?  */

#define SWI_ZERO_PADDED_FFT_FOR_DISPLAY 0 /* no more zero-padding since 2013-04 (not worth the effort to put it back to work) */

#define SWI_USE_GPSD_FOR_RTCM 0  /* use fragments from GPSD for RTCM ? 0=no */

#define SWI_CLI_FLOAT_SPECTRUM_ARRAY 0 /* see comments in CLI_ROUT.H       */

#define SWI_CHECK_SYSTEM_INTEGRITY   0 /* see comments in CONFIG.H         */

#ifndef  SWI_FLOAT_PRECISION   // should be defined under Project..Options..Conditionals
 #define SWI_FLOAT_PRECISION 1 /* 1=single precision, 2=double precision */
#endif

  // Limits for various "amplitude controls",  usually in decibel :
#define SWI_AMPL_MIN_DB -200 /* ex: -150 dB, not enough to test 24-bit ADC resolution */
#define SWI_AMPL_MAX_DB  200 /* Caution, for some applications much GAIN is required  */

#endif /* _SWITCHES_H_ */

