//---------------------------------------------------------------------------
// File  :  WinStuff.h
// Date  :  2014-02-22   (YYYY-MM-DD)
// Author:  Wolfgang Buescher  (DL4YHF)
//
// Description:
//   "Windows Stuff" for API-level access for a NON-VCL application.
// Revision history and more details in WinStuff.c .
//
//---------------------------------------------------------------------------



#ifdef STRICT
 #define WND_PROC WNDPROC
#else
 #define WND_PROC FARPROC
#endif

//---------------- Data Types -----------------------------------------------
typedef struct // tWinEditor
{ HWND    hWnd;
  HFONT   hFont;
  LOGFONT LogFont;
  PARAFORMAT ParaFormat;
  CHARFORMAT CharFormat;

  // boring internal windoze-related stuff ..
  char     sz16ClassName[17];
  DWORD    dwCreationStyle;
  WND_PROC wpNewEditSubclassProc;
  WND_PROC wpOldEditSubclassProc;

  // Scap required by the FIND / REPLACE dialogs..
  char sz255FindWhat[256];
  char sz255ReplaceWith[256];

  UINT        uFindReplaceMsg;
  FINDREPLACE FindReplace;
  HWND        hWndFindReplaceDlg;

} T_WinEditor;


//---------------- Constants ------------------------------------------------
// Dialog button codes (not button IDs, but return codes for the modal dialogs)
#define WS_DLG_BTN_NONE   0
#define WS_DLG_BTN_OK     1
#define WS_DLG_BTN_CANCEL 2
#define WS_DLG_BTN_HELP   3
#define WS_DLG_BTN_USER1  11
#define WS_DLG_BTN_USER2  12

#define WS_DLG_ID_EDIT1   21 /* control ID for the edit field in the dialog */

// Edit field options (used in some simple dialogs)
#define  WS_EDIT_NORMAL       0
#define  WS_EDIT_DECIMAL_ONLY 0x0010
#define  WS_EDIT_HEXADECIMAL  0x0020
#define  WS_NO_HELP_CONTEXT   -1


//---------------- Variables ------------------------------------------------
extern HINSTANCE WS_hInstance; // must be set by the application,
                // so we don't have to pass this in all those subroutines .
                // Unlike other stuff, this "HINSTANCE"-thingy won't change
                // while a "normal, small windoze app" is running .

//---------------- Prototypes -----------------------------------------------

// For peaceful coexistence between "C" and "C++" :
#ifndef CPROT
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif

//**************************************************************************
// Miscellaneous Windows-related Stuff...
//**************************************************************************


CPROT int  GetWindowHeight( HWND hWnd );
CPROT int  GetWindowWidth( HWND hWnd );
CPROT void GetTextExtent( HDC hdc, char *pszString, int *piWidth, int *piHeight);
CPROT void LeftAlignedTextOut( HDC dc, int x, int y, char *pszText );
CPROT void DrawLine(HDC hdc, int x1, int y1, int x2, int y2);
CPROT void SetWindowTitle(HWND hWnd, char *pszCaption );

CPROT BOOL WS_EnableMenuItem( // an easier-to-use wrapper for EnableMenuItem()
                HMENU hmenu,   // [in] handle to menu
                UINT  uIDItem, // [in] menu item to modify
                BOOL fEnabled);// [in] FALSE->disbled+grayed (i.e. N/A), TRUE->ENABLED

CPROT BOOL WS_CheckMenuItem( // an easier-to-use wrapper for CheckMenuItem()
                HMENU hmenu,   // [in] handle to menu
                UINT  uIDItem, // [in] menu item to modify
                BOOL  fCheck); // [in] TRUE to check, FALSE to uncheck (boolean condition, not MF_CHECKED/UNCKECKED!)

CPROT BOOL WS_PrintMenuItem(
                HMENU hmenu,   // [in] handle to menu
                UINT  uIDItem, // [in] menu item to modify
                char *pszFormat, ... ); // format string for wsprintf (no floats!)

CPROT BOOL WS_GetMenuText(
                HMENU hmenu,   // [in] handle to menu
                UINT  uIDItem, // [in] menu item to modify
                char *pszText, int iMaxLen ); // [out] string with a size limitation

CPROT void InitLogFont(LOGFONT *pLogFont, char *pszFaceName, int iHeight);
CPROT void SetFont(HWND hWnd, HFONT hFont);
CPROT void LogfontToCharformat( LOGFONT *pLf, CHARFORMAT *pCf );
CPROT void CharformatToLogfont( CHARFORMAT *pCf, LOGFONT *pLf );

CPROT double GetSecondsSinceMidnightUTC( void ); // wth had this been used for ?


//--------------------------------------------------------------------------
CPROT BOOL WS_ChooseColor( HWND hwndOwner, char *pszCaption, DWORD *pdwRGBColor );
  // Color Selection Dialog.
  // Works a bit like Borland's TColorDialog but allows defining the CAPTION.

//--------------------------------------------------------------------------
CPROT BOOL WS_BrowseFolder(HWND hwndOwner, char *pszCaption, char *pszFolder, int iMaxLen );
  // Folder Selection Dialog.
  //  The current folder (pszFolder) will be selected in the dialog,
  //  so it must be VALID (or contain an empty string) before the call .

//--------------------------------------------------------------------------
CPROT int WS_RunIntegerInputDialog( // MODAL dialog; returns WS_DLG_BTN_...
  HWND hwndOwner,  // handle to the window which will be blocked by the dialog
  char *pszTitle, char *pszLabel1,  char *pszLabel2,
  int  *piValue,  int iEditOptions, int  iHelpContext );

CPROT int WS_RunStringEditDialog(  // MODAL dialog; returns WS_DLG_BTN_...
  HWND hwndOwner,  // handle to the window which will be blocked by the dialog
  char *pszTitle, char *pszLabel1, char *pszLabel2,
  char *pszDefaultValue, int iEditOptions,
  char *pszDestination,  int iMaxLength, int  iHelpContext );

CPROT int WS_RunFloatInputDialog(  // MODAL dialog; returns WS_DLG_BTN_...
  HWND hwndOwner,  // handle to the window which will be blocked by the dialog
  char *pszTitle, char *pszLabel1, char *pszLabel2,
  float *pfltValue,  int iEditOptions, int  iHelpContext );


//--------------------------------------------------------------------------
CPROT BOOL WS_GetMouseCursorPos( int *piScreenX, int *piScreenY );
  // Not really "dialog-related", but see WS_Dialogs.cpp .....







//**************************************************************************
// Multiline Text Edit controls...
//**************************************************************************
CPROT BOOL IsRichEditControl( HWND hWndEditor ); // tells 'rich' edit controls from normal edit controls
CPROT void GetTextSelection( HWND hWndEditor, DWORD *pdwStartPos, DWORD *pdwEndPos );
CPROT void SetTextSelection( HWND hWndEditor, DWORD dwStartPos, DWORD dwEndPos );
CPROT int  GetSelectedText( HWND hWndEditor, char *pszDest, int iMaxLength );
CPROT void ReplaceSelectedText( HWND hWndEditor, char *pszText, BOOL fCanUndo );
CPROT void SetCaretToEndOfText( HWND hWndEditor );
CPROT DWORD GetTextLineCount( HWND hWndEditor );
CPROT DWORD GetTextLineIndexFromCharIndex( HWND hWndEditor, DWORD dwCharacterIndex );
CPROT DWORD GetTextCharIndexFromLineIndex( HWND hWndEditor, int iLineIndex );
CPROT int GetTextLineAsCString( HWND hWndEditor, int iLineIndex, char *pszDest, int iMaxLength);
CPROT BOOLEAN ReplaceTextLine( HWND hWndEditor, int iLineIndex, char *pszSource, BOOL fCanUndo);
CPROT void GetTextCaretLineAndColumn( HWND hWndEditor, DWORD *pdwLine, DWORD *pdwColumn);
CPROT void SetTextCaretLineAndColumn( HWND hWndEditor, DWORD dwLine, DWORD dwColumn);
CPROT BOOLEAN GetModifiedFlag( HWND hWndEditor );
CPROT void    SetModifiedFlag( HWND hWndEditor, BOOL fModified );


//**************************************************************************
// "Editor" routines ...
//  Wrapper for a "Rich Text" control, may be turned into a C++ class easily.
//**************************************************************************

CPROT void Editor_InitStruct(    T_WinEditor *pEd );
CPROT void Editor_Create( T_WinEditor *pEd, HWND hWndParent,
                  int left, int top, int width, int height );
CPROT void Editor_SetSubclassProc(T_WinEditor *pEd, WND_PROC EditSubclassProc );
CPROT BOOL Editor_LoadFromFile(  T_WinEditor *pEd, char *pszFileName );
CPROT BOOL Editor_SaveAsFile(    T_WinEditor *pEd, char *pszFileName );
CPROT BOOL Editor_IsSomethingSelected( T_WinEditor *pEd );
CPROT void Editor_SetWordWrap(   T_WinEditor *pEd, BOOL fEnableWordWrap );
CPROT BOOL Editor_GetWordWrap(   T_WinEditor *pEd );
CPROT void Editor_GetParaFormat( T_WinEditor *pEd );
CPROT void Editor_SetParaFormat( T_WinEditor *pEd );
CPROT void Editor_GetCharFormat( T_WinEditor *pEd, BOOL fFromSelection );
CPROT void Editor_SetCharFormat( T_WinEditor *pEd, BOOL fForSelection  );
CPROT void Editor_OpenFindReplaceWindow( T_WinEditor *pEd, HWND hWndOwner, BOOL fReplaceToo );
CPROT void Editor_HandleFindReplaceDlgMsg( T_WinEditor *pEd, FINDREPLACE *pfr);
CPROT void Editor_DestroyWindow( T_WinEditor *pEd );


//**************************************************************************
// General routines to play with Status Windows ...
//**************************************************************************
CPROT HWND DoCreateStatusWindow(HWND hwndParent, int nStatusID,  HINSTANCE hinst, int nParts,int *piPartWidths);
CPROT void SetStatusWindowText(HWND hWndStatusWindow, int iPart, int iType, char *szText);


//**************************************************************************
// Common Dialog Boxes ...
//**************************************************************************

CPROT BOOL WS_SelectFileToOpen( HWND hwndOwner,
                HINSTANCE hInstance,
                char *pszTitle,
                char *pszFileAndPath, // default filename + buffer for result
                int iMaxLength, // the buffer should be at least 256 characters long.
                char *pszFilter,
                   // Pointer to a buffer containing pairs of null-terminated filter strings.
                   // The last string in the buffer must be terminated by two NULL characters.
                   //    Example: "Text files\0*.TXT;*.DOC;*.BAK\0\0"
                char *pszDefaultExtension ); // only needed if user fails to ENTER an extension

CPROT BOOL WS_SelectFileToSave( HWND hwndOwner, HINSTANCE hInstance,
                char *pszTitle,  char *pszFileAndPath, int iMaxLength,
                char *pszFilter, char *pszDefaultExtension );

// ex: CPROT BOOL SelectFont( HWND hwndOwner, DWORD *pdwTextColorRGB, LOGFONT *pLogFont );



//**************************************************************************
// INI-files
//**************************************************************************
CPROT const char *IntToStr(long l);

CPROT long   ReadIntFromIniFile(const char *pszIniFileName, const char *pszSection, const char *pszKeyName, long lDefault);
CPROT void   WriteIntToIniFile( const char *pszIniFileName, const char *pszSection, const char *pszKeyName, long lValue);
CPROT double ReadDoubleFromIniFile(const char *pszIniFileName, const char *pszSection, const char *pszKeyName, double dblDefault);
CPROT void   WriteDoubleToIniFile( const char *pszIniFileName, const char *pszSection, const char *pszKeyName, double dblValue);
CPROT void   ReadStringFromIniFile(const char *pszIniFileName, const char *pszSection, const char *pszKeyName, char *pszDefault, char *pszResult, int iMaxLen );
CPROT void   WriteStringToIniFile( const char *pszIniFileName, const char *pszSection, const char *pszKeyName, char *pszValue );

// end WinStuff.h

