/*  WSQ Varicode Tables .
 *   Included LIKE A HEADER FILE from the decoder,
 *   thus this project must not be added to the project file !
 *
 * (YHF, trying to dig this) :
 *   1st index [ch=0..8*16] = ASCII, or maybe ANSI character .
 *   2nd index [0] = Varicode 'Initial Symbol' (always exists; 0..28, not 26);
 *             [1] = optional 'Continuation Symbol' (0=none, else 29..31),
 *     as explained in www.qsl.net/zl1bpu/SOFT/WSQ.htm .
 * )
 */
unsigned char wsq_varicode[128][2] = {
    /* Primary alphabet */
    { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, // [0..7]
    {27,31}, { 0, 0}, {28, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, // [8..15]
    { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, // [16..23]
    { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, // [24..31]
    { 0, 0}, {11,30}, {12,30}, {13,30}, {14,30}, {15,30}, {16,30}, {17,30}, // [32..39] -> SPACE, etc
    {18,30}, {19,30}, {20,30}, {21,30}, {27,29}, {22,30}, {27, 0}, {23,30}, // [40..47]
    {10,30}, { 1,30}, { 2,30}, { 3,30}, { 4,30}, { 5,30}, { 6,30}, { 7,30}, // [48..55]  digits...
    { 8,30}, { 9,30}, {24,30}, {25,30}, {26,30}, { 0,31}, {27,30}, {28,29}, // [56..63]
    { 0,29}, { 1,29}, { 2,29}, { 3,29}, { 4,29}, { 5,29}, { 6,29}, { 7,29}, // [64..71]  upper case letters (two symbols)
    { 8,29}, { 9,29}, {10,29}, {11,29}, {12,29}, {13,29}, {14,29}, {15,29}, // [72..79]
    {16,29}, {17,29}, {18,29}, {19,29}, {20,29}, {21,29}, {22,29}, {23,29}, // [80..87]
    {24,29}, {25,29}, {26,29}, { 1,31}, { 2,31}, { 3,31}, { 4,31}, { 5,31}, // [88..95]
    { 9,31}, { 1, 0}, { 2, 0}, { 3, 0}, { 4, 0}, { 5, 0}, { 6, 0}, { 7, 0}, // [96..103]  lower case letters (single symbol)
    { 8, 0}, { 9, 0}, {10, 0}, {11, 0}, {12, 0}, {13, 0}, {14, 0}, {15, 0}, // [104..111]
    {16, 0}, {17, 0}, {18, 0}, {19, 0}, {20, 0}, {21, 0}, {22, 0}, {23, 0}, // [112..119]
    {24, 0}, {25, 0}, {26, 0}, { 6,31}, { 7,31}, { 8,31}, { 0,31}, {28,31}  // [120..127] 'x'...'DEL'
  // Note: The IDLE character, {28,30} according to 'WSQ Varicode V3.png',
  //       is NOT contained in the above table.
};

/*
 * The same in a format more suitable for decoding.
 * The index is the varicode symbol, being 1-2 nibbles. The value is the
 * ASCII character.
 * NB. Do NOT use CR as a line feed, as you will get an extra space and the new line will be indented. Use LF = ascii 10 instead.
 *
 * (YHF, trying to dig this) :
 *    Varicode table, the following is used for transmission.
 *    Usage: wsq_varidecode[prev_nibble * 32  + curr_nibble];
 *    where prev_nibble := 'Initial Symbol' (from www.qsl.net/zl1bpu/SOFT/WSQ.htm)
 *     and  curr_nibble := 'Continuation Symbol' .
 *    So which ASCII character would be returned for the 'IDLE' character, {28,30} ?
 *    28 * 32 + 30 = 926 . Should be the last-but-one entry in the table below.
 *    At that index, there was a ZERO . Thus the decoder returns a ZERO (char)
 *    for the 'IDLE' character. Should be non-printing, or .. ?
 *    -> Special treatment for that in WSQ_Codec.c .
 * )
 */
signed int wsq_varidecode[928] = {
 //i:0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  19  20  21  22  23  24  25  26  27  28  29  30  31
    32, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122, 46, 10, 64,126, 61,  // i+0
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65, 49, 91,  //  32
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 66, 50, 92,  //  64
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 67, 51, 93,  //  96
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 68, 52, 94,  // 128
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 69, 53, 95,  // 160
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 70, 54,123,  // 192
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 71, 55,124,  // 224
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 72, 56,125,  // 256
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 73, 57, 96,  // 288
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 74, 48,241,  // 320
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 75, 33,246,  // 352
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 76, 34,248,  // 384
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 77, 35,158,  // 416
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 78, 36,156,  // 448
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 79, 37, -1,  // 480
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80, 38, -1,  // 512
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 81, 39, -1,  // 544
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 82, 40, -1,  // 576
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 83, 41, -1,  // 608
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 84, 42, -1,  // 640
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 85, 43, -1,  // 672
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 86, 45, -1,  // 704
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 87, 47, -1,  // 736
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 88, 58, -1,  // 768
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 89, 59, -1,  // 800
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 90, 60, -1,  // 832
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 44, 62,  8,  // 864
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 63,  0,127   // 896

};
