/*
 *  File:    ?\WSQ2\WSQ_Interactive.h
 *  Date:    2014-03-27
 *  Author:  Wolf, DL4YHF .
 *  Purpose: See WSQ_Interactive.c !
 *
 *
 *      #####################################################################
 *
 *
 *        This software is provided 'as is', without warranty of any kind,
 *        express or implied. In no event shall the author be held liable
 *        for any damages arising from the use of this software.
 *
 *        Permission to use, copy, modify, and distribute this software and
 *        its documentation for non-commercial purposes is hereby granted,
 *        provided that the above copyright notice and this disclaimer appear
 *        in all copies and supporting documentation.
 *
 *        The software must NOT be sold or used as part of any commercial
 *        or "non-free" product.
 *
 *      #####################################################################
 */

/*------------------------------------------------------------------------------
 *
 *
 *
 */

#ifdef __BORLANDC__
# pragma hdrstop
#endif

#include "switches.h" /* SWITCHES.H must be included before anything else! */
         /* Contains stuff like SWI_USE_OOURAS_FFT, SWI_USE_KISS_FFT, etc. */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "WSQ_Codec.h"   // WSQ_DecodeAudio(), WSQ_GenerateAudio(), ..

typedef struct tWSQI_Point
{
  long  i32SpectrumIndex; // unique index to identify the clicked spectrum (~FFT counter).
# define SPECTRUM_INDEX_UNUSED 0x7FFFFFFF // marks an unused entry.
         // The array WSQI_Points[] is sorted by increasing 'i32SpectrumIndex',
         // thus UNUSED entries will move to the end of the array .
  float freq_Hz; // baseband frequency of the symbol, automatically preset, manually corrected
  float delta_f; // frequency difference, measured as multiple of the WSQ tone spacing,
                 // between current minus PREVIOUS frequency .
  int   decoded_char;

} T_WSQI_Point;


extern BOOL WSQI_fRedrawMarkers;    // set in WSQ_Interactive.c, polled/cleared in WSQ_MainWin.c
extern BOOL WSQI_fGotNewCharacter;  // also " " ", polled/cleared in WSQ_MainWin.c

HCURSOR WSQI_CreateFrameCursor( HINSTANCE hInst );
void    WSQI_BeginReception(void);
void    WSQI_OnMouseDown( float fltClickedFreq, long  iSpectrumIndex );
void    WSQI_OnMouseUp(   float fltClickedFreq, long  iSpectrumIndex );
void    WSQI_EnterSymbol( float fltClickedFreq, long  iSpectrumIndex );
T_WSQI_Point *WSQI_GetMarkerForWFall( long iSpectrumIndex );
void    WSQI_OnNewSpectrum( T_WSQDecoder *pDecoder, int iChannel,
          void (*pRxCharWriter)(T_WSQDecoder *pDecoder, int iChannel, int iFlags, char *pszText) );
void    WSQI_GetTextForTicker( T_WSQDecoder *pDecoder, int iChannel, char *psz255Dest );



