/*********************************************************************/
/* File:    c:\cbproj\SpecLab\QuickSrt.h                             */
/* Copies:  c:\cbproj\WSQ2\QuickSrt.h                                */
/*                                                                   */
/* Purpose:  Quicksort Algorithm      for  Spectrum Lab.             */
/*           Later also used in WSQ2 to estimate the noise level     */
/*           by statistical means (G4JNT 'lower quartile' method)    */
/*********************************************************************/


#ifndef CPROT /* for peaceful co-existence between C and C++ ... */
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif


#ifndef  TRUE  /* types which used to be defined in windef.h : */
# define TRUE  1
# define FALSE 0
  typedef unsigned long  DWORD;
  typedef int            BOOL;
  typedef unsigned char  BYTE;
  typedef unsigned short WORD;
#endif


  // Options passed to the QuickSort function:
#define QUICKSORT_INCREASING 1
#define QUICKSORT_DECREASING 0



typedef struct
{ // used for sorting and analysing noise & peak values
  double amplitude;
  int    bin_index;
} T_QSORT_SAMPLE_PAIR;



/***************************************************************************/
CPROT void QuickSort( T_QSORT_SAMPLE_PAIR *array, int n_elements,
                       int by_increasing_values );
  /* Quick Sort Algorithm for increasing OR decreasing order.
   * 'by_increasing_values' : QUICKSORT_INCREASING or QUICKSORT_DECREASING .
   * Modified to sort arrays of STRUCTURES not just INTEGERS by DL4YHF.
   */



// EOF <QuickSrt.h>
