/*********************************************************************/
/* File:    c:\cbproj\SpecLab\QuickSrt.c                             */
/* Copies:  c:\cbproj\WSQ2\QuickSrt.c                                */
/*                                                                   */
/* Purpose:  Quicksort Algorithm      for  Spectrum Lab.             */
/*           Later also used in WSQ2 to estimate the noise level     */
/*           by statistical means (G4JNT 'lower quartile' method)    */
/*********************************************************************/

#include "QuickSrt.h"  // header for THIS module

//---------------------------------------------------------------------
void RecursiveIncreasingQuickSort(
         T_QSORT_SAMPLE_PAIR *A,
         int AHigh, int iLo, int iHi )
{
  // Quick Sort Algorithm for increasing order.
  int    lo, hi;
  double Mid;
  T_QSORT_SAMPLE_PAIR t_swap;

  lo = iLo;
  hi = iHi;
  Mid = A[(lo+hi)/2].amplitude;

  do
   {
    while (A[lo].amplitude < Mid)     // 2014-03-16 : Access violation when called from
     { lo++;
       // WSQ_CalcNoiseInRange() -> QuickSort(n_elements=340) -> ...
       //   -> RecursiveIncreasingQuickSort( AHigh=339, iLo=0, iHi=1)
       //      -> lo (when crashing) was 3414 ? !
       //         Mid    =   +NAN  ! !
       //         A[0]   = { +NAN,  339 } ? ?
       //         A[1]   = { 1.6e-6, 10 }
       //         A[339] = { 5.2e-5,  0 }
       if( lo>=iHi )
        { break;   // 'emergency break', added 2014-03-16
        }
       // Besides the above 'emergency break', added similar stuff below..
     }
    while (A[hi].amplitude > Mid)
     { hi--;
       if( hi<=iLo )
        { break;   // 'emergency break', added 2014-03-16
        }
     }
    if (lo <= hi)
    {
      t_swap = A[lo];
      A[lo] = A[hi];
      A[hi] = t_swap;
      lo++;
      hi--;
    }
   }
  while (lo <= hi);

  if (hi > iLo)
    RecursiveIncreasingQuickSort(A, AHigh, iLo, hi);
  if (lo < iHi)
    RecursiveIncreasingQuickSort(A, AHigh, lo, iHi);
}

void RecursiveDecreasingQuickSort(
         T_QSORT_SAMPLE_PAIR *A,
         int AHigh, int iLo, int iHi )
{ // Quick Sort Algorithm for decreasing order.
  int    lo, hi;
  double Mid;
  T_QSORT_SAMPLE_PAIR t_swap;

  lo = iLo;
  hi = iHi;
  Mid = A[(lo+hi)/2].amplitude;

  do
   {
    while (A[lo].amplitude > Mid)
        lo++;
    while (A[hi].amplitude < Mid)
        hi--;
    if (lo >= hi)
    {
      t_swap = A[lo];
      A[lo] = A[hi];
      A[hi] = t_swap;
      lo++;
      hi--;
    }
   }
  while (lo >= hi);

  if (hi < iLo)
    RecursiveDecreasingQuickSort(A, AHigh, iLo, hi);
  if (lo > iHi)
    RecursiveDecreasingQuickSort(A, AHigh, lo, iHi);
}

/***************************************************************************/
void QuickSort( T_QSORT_SAMPLE_PAIR *array, int n_elements,
                int by_increasing_values )
  /* Quick Sort Algorithm for increasing OR decreasing order.
   * 'by_increasing_values' : QUICKSORT_INCREASING or QUICKSORT_DECREASING .
   * Modified to sort arrays of STRUCTURES not just INTEGERS by DL4YHF.
   */
{
  if (by_increasing_values)
     RecursiveIncreasingQuickSort( array, n_elements-1, 0, n_elements-1);
   else
     RecursiveDecreasingQuickSort( array, n_elements-1, 0, n_elements-1);
}
//---------------------------------------------------------------------

// EOF <QuickSrt.c>
