/***************************************************************************/
/*  File:   c:\cbproj\SoundUtl\ChunkInfo.c                                 */
/*  Copies: c:\cbproj\WSQ2\ChunkInfo.c (DL4YHF's adaption of ZL2AFP's WSQ) */
/*   A few simple helpers for the "AUDIO CHUNK" info ( T_ChunkInfo ) .     */
/*   - by DL4YHF 2014-02-22                                                */
/*  Since 2011-06, the T_ChunkInfo structure is ALSO used in the           */
/*     Audio-I/O-DLLs, so be EXTREMELY CAREFUL when modifying it !         */
/*  Since 2014-02, to remove some dependencies in ChunkInfo.c, rarely used */
/*     functions like ChunkInfo_AdjustInfoForSampleIndexDiff(),            */
/*                    ChunkInfo_Interpolate(),                             */
/*                    ChunkInfo_GetInterpolatedEntryFromArray(),           */
/*                    ChunkInfoToString() and StringToChunkInfo()          */
/*     are not in ChunkInfo.c anymore, but in ChunkInfo2.c  !              */
/***************************************************************************/

#include "stdio.h"  // no STANDARD I/O but sprintf ..
#include "math.h" 
#pragma hdrstop     // precompiled headers don't work here

#include "Utility1.h"     // DEBUGGER_BREAK(), etc                    
#include "ChunkInfo.h"    // header for THIS module (also used by "ChunkInfo2.c")
#include "string.h"       // memset() defined here, for whatever strange reason

//---------------------------------------------------------------------------
void ChunkInfo_Init( T_ChunkInfo *pChunkInfo )  // initializes a structure (completely)
{ // Must only be used to initialize 'our' instance data !
  // For everything else (which may cross a DLL/Host-border) use ChunkInfo_CopyFromTo() .
  if( pChunkInfo != NULL )
   { memset( pChunkInfo, 0, sizeof( T_ChunkInfo ) );
     pChunkInfo->dwSizeOfStruct = sizeof( T_ChunkInfo );
     pChunkInfo->dblPrecSamplingRate = 0.0;
     pChunkInfo->dblSamplingRateDrift= 0.0;
     pChunkInfo->dblRadioFrequency   = 0.0;
     pChunkInfo->dblSampleValueRange = 1.0;
       // Originally the range was +/- 32767.0 (for historic reasons; 16-bit input),
       // later (2011-02) this was changed to 1.0, i.e. the sample blocks
       // now use floating point values normalized to -1.0 ... +1.0 .
       // Caution, some older modules may still use +/- 32k value range !
     pChunkInfo->nChannelsPerSample   = 1;    // use MEANINGFUL DEFAULTS ..
     pChunkInfo->dwInfoFlags = CHUNK_INFO_FLAG_NONE;

     pChunkInfo->rtRecTime = 0.0;
     pChunkInfo->ldblUnixDateAndTime  = 0.0;
     pChunkInfo->dblCurrentLocalUnixDateAndTime = 0.0;
     pChunkInfo->dblOutputLatency_sec = 0.0;
     // pChunkInfo->dblHRTime_sec     = 0.0;
     pChunkInfo->dblTotalGroupDelay  = 0.0;  // .. "from the INPUT to the current processing stage"
     pChunkInfo->gps.dblLat_deg = C_CHUNK_INFO_LAT_INVALID;
     pChunkInfo->gps.dblLon_deg = C_CHUNK_INFO_LON_INVALID;
     pChunkInfo->gps.dbl_mASL   = 0.0;  // meters above sea level (from GPS receiver)
     pChunkInfo->gps.dblVel_kmh = 0.0;  // GPS velocity in km/h
     pChunkInfo->gps.dblDateAndTime = 0.0; // time for which the above GPS position is valid (also UNIX format)
   }
} // end ChunkInfo_Init()


//---------------------------------------------------------------------------
void ChunkInfo_CopyFromTo(  // Copies a T_ChunkInfo structure, version-safe (added 2011-06-2011)
     T_ChunkInfo *pSrcChunkInfo,   // [in] source chunk, MUST BE INITIALIZED
     T_ChunkInfo *pDstChunkInfo,   // [out] destination chunk info, with the following 'expected' size:
     int iDstSizeInBytes )         // [in] expected size of pDstChunkInfo, measured in BYTES
  // This function mainly exists to convert 'older' into 'newer' struct versions, or vice versa.
  // If the structure (and size) of T_ChunkInfo would never change,
  // ChunkInfo_CopyFromTo() would merely do this: *pDstChunkInfo = *pSrcChunkInfo .
{
  int iSizeofChunkInfoInBytes = sizeof( T_ChunkInfo );
  if( iSizeofChunkInfoInBytes != CHUNK_INFO_STRUCT_SIZE_V1 )
   { iSizeofChunkInfoInBytes = iSizeofChunkInfoInBytes; // << Set a breakpoint here...
     // to find the CORRECT value of CHUNK_INFO_STRUCT_SIZE_Vx in ChunkInfo.h !
   }
  if( iDstSizeInBytes > iSizeofChunkInfoInBytes )
   { iDstSizeInBytes = iSizeofChunkInfoInBytes;  // don't try to copy 'unknown new members' here !
   }

  if( (pSrcChunkInfo!=NULL) && (pDstChunkInfo!=NULL) && (pSrcChunkInfo!=pDstChunkInfo) )
   { // If both the size of source-chunk-info, and the dest-chunk-info are equal,
     // it's not necessary to convert here:
     if( pSrcChunkInfo->dwSizeOfStruct == (DWORD)iDstSizeInBytes )
      { memcpy( (void*)pDstChunkInfo, (void*)pSrcChunkInfo, (size_t)iDstSizeInBytes );
      }
     else // The size of the SOURCE- and DESTINATION chunk-info are NOT equal,
      {   // which means we either have a problem with different alignment
          // of structs (in different C compilers, which would be a BUG),
          // or there is a VERSION INCOMPATIBILITY (which we can handle in the code below).
        if( (DWORD)iDstSizeInBytes > pSrcChunkInfo->dwSizeOfStruct )
         { // The caller expects a larger 'T_ChunkInfo' structure than the existing source:
           // Only copy as many bytes as we have in the SOURCE T_ChunkInfo,
           // and set the rest (in the caller's DESTINATION buffer) to 'zero' :
           memcpy( (void*)pDstChunkInfo, (void*)pSrcChunkInfo, (size_t)pSrcChunkInfo->dwSizeOfStruct );
           memset( (BYTE*)pDstChunkInfo + pSrcChunkInfo->dwSizeOfStruct,
                   0, // [in] filling byte pattern
                   iDstSizeInBytes - pSrcChunkInfo->dwSizeOfStruct); // [in] number of bytes to fill
           // Despite the above zero-padding, let the caller know that
           // the 'new' fields in the T_ChunkInfo structure are invalid:
           if( (DWORD)iSizeofChunkInfoInBytes > pSrcChunkInfo->dwSizeOfStruct )
            {  iSizeofChunkInfoInBytes = pSrcChunkInfo->dwSizeOfStruct;
            }
           pDstChunkInfo->dwSizeOfStruct = iSizeofChunkInfoInBytes;
         }
        else // ( iDstSizeInBytes < pSrcChunkInfo->dwSizeOfStruct )
         { // The CALLER (possibly an old version of SL, using a NEW DLL)
           // can accept less bytes than present in the source:
           memcpy( (void*)pDstChunkInfo, (void*)pSrcChunkInfo, (size_t)iDstSizeInBytes );
           pDstChunkInfo->dwSizeOfStruct = iDstSizeInBytes;
         } // end else ( iDstSizeInBytes < pSrcChunkInfo->dwSizeOfStruct )
      } // end else ( pSrcChunkInfo->dwSizeOfStruct != iDstSizeInBytes )
   }
} // end ChunkInfo_CopyFromTo()

/* EOF < ChunkInfo.c > */
