/*
 *  File:    ?\WSQ2\CW_Generator.c
 *  Date:    2014-03-15
 *  Author:  DL4YHF (recycled from Spectrum Lab).
 *  Purpose: CW (Morse Code) generator .
 *   Used to send a station identifier (or other) in Morse code,
 *   as required / recommended in some countries .
 *
 *
 *      #####################################################################
 *
 *        This software is provided 'as is', without warranty of any kind,
 *        express or implied. In no event shall the author be held liable
 *        for any damages arising from the use of this software.
 *
 *        Permission to use, copy, modify, and distribute this software and
 *        its documentation for non-commercial purposes is hereby granted,
 *        provided that the above copyright notice and this disclaimer appear
 *        in all copies and supporting documentation.
 *
 *        The software must NOT be sold or used as part of any commercial
 *        or "non-free" product.
 *
 *      #####################################################################
 */

#ifndef _CW_GENERATOR_H_
#define _CW_GENERATOR_H_


#ifndef  TRUE  /* types which used to be defined in windef.h : */
# define TRUE  1
# define FALSE 0
  typedef unsigned long  DWORD;
  typedef int            BOOL;
  typedef unsigned char  BYTE;
  typedef unsigned short WORD;
#endif

typedef struct tCWGenerator
{
  // Configuration (parameters) :
  float fltCenterFrequency;
  float fltSecondsPerDot;

  // Instance data (to avoid dreadfuly statics inside CW_GenerateAudio) :
  int   iSampleOfSymbolCounter;
  int   nSamplesPerSymbol;
  WORD  wTxShiftReg;
  float ramp,phase,ramp_inc;
  BOOL  sending_dot_gap;

} T_CWGenerator;

//---------------- Prototypes -----------------------------------------------

// For peaceful coexistence between "C" and "C++" :
#ifndef CPROT
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif

CPROT void CW_InitGenerator( T_CWGenerator *pGenerator,
        float fltCenterFrequency, float fltSecondsPerDot );

CPROT BOOL CW_GenerateAudio( T_CWGenerator *pGenerator,
        float *pfltSamples, int nSamples, int nChannelsPerSample, float sampleRate,
        char (*pTxCharReader)(void) );

CPROT void SendToSynthesizer( int iTone/*0..32*/ ); // called from WSQ2_Codec() during transmit, when SynthesizerActive==TRUE.
        // Since 2014-03-26, also called from CW_Generator.c to send the optional CW ID.
        // Implemented in the main module, not in any of the 'generators'.



#endif // ndef _CW_GENERATOR_H_
