/*--------------------------------------------------------------------------*/
/*   File:   \cbproj\WSQ2\AudioIO\SWITCHES.H                                */
/*   Contains the project specific compilation switches                     */
/*            to compile DL4YHF's modified variant of ZL2AFP's WSQ .        */
/*      THIS (modified) variant has DL4YHF's "Audio-I/O-DLL-Host" inside,   */
/*            which can also host Audio-I/O and 'ExtIO'-compatible DLLs .   */
/*     Matching project file for Borland C++ : ..\Borland_Project\*.bpr     */
/*--------------------------------------------------------------------------*/

#ifndef  _SWITCHES_H_
 #define _SWITCHES_H_

#ifndef  SWI_ALLOW_TESTING
 #define SWI_ALLOW_TESTING 0  /* should be defined under "Project Options" */
#endif

#define SWI_UTILITY1_INCLUDED 1   /* DL4YHF's "utility"-package #1 included ? */

#define SWI_HTTP_SRV_INCLUDED 0   /* miniature HTTP Server included ?      */

#define SWI_ASIO_SUPPORTED    0   /* Support ASIO audio drivers ?          */

#define SWI_STEREO_SUPPORTED  1   /* Stereophonic input and processing ?   */

#define SWI_SDR_IQ_SUPPORTED  0   /* Support SDR-IQ (and SDR-14) by RFSPACE ? */

#define SWI_PERSEUS_SUPPORTED 0   /* Support PERSEUS (by microtelecom) ?  */

#define SWI_SUPPORT_EXTIO_DLL 1   /* support (or "be a") Winrad's ExtIO-DLL? */

#define SWI_SOUND_TAB_INCLUDED 1  /* Module SoundTab.cpp included ?        */

#define SWI_FFT_RESULT_FLOAT  1   /* 0=INT16 result,   1=FLOAT result      */

#ifndef  SWI_FLOAT_PRECISION   // should be defined under Project..Options..Conditionals
 #define SWI_FLOAT_PRECISION 1 /* 1=single precision, 2=double precision */
#endif

  // Limits for various "amplitude controls",  usually in decibel :
#define SWI_AMPL_MIN_DB -190 /* ex: -150 dB, not enough to test 24-bit ADC resolution */
#define SWI_AMPL_MAX_DB  150 /* Caution, for some applications much GAIN is required  */

#endif /* _SWITCHES_H_ */
