# Radare2 script to disassemble the "D13.020" firmware.
#   Based on the md380tool's "flash.r" + "cpu.r", but modfied
#   by DL4YHF to produce a listing with only the "interesting" parts.
#   Callers + Callees will be 'linked' in a post-processing step
#   using script 'disasm2htm.py' (converts listing.txt to listing.htm).
#
# 'f' name length @ address .  The '@' seems to be optional, e.g. radare2book.pdf page 129 of 216
f VectorTable 0x188 @ 0x0800C000

af+ 0x800c188 1446 md380_create_main_menu_entry

af+ 0x800c72e (0x784-0x72e) md380_create_menu_entry
CCa 0x800c72e in: R0=menuId, R1=label, R2=OnConfirm, R3=OnCancel, more args on stack
CCa 0x800c730 arg4 = 'e', listed in a table in menu.c
CCa 0x800c732 arg5 = 'f' 0=stable, 2=remove after timeout
CCa 0x800c734 arg6 = item_count or 'enable' ? 0=not visible
CCa 0x800c736 'menuId' = index into md380_menu_mem_base[] 

Cd 4 @ 0x0800c784
Cd 4 @ 0x0800c788
Cd 4 @ 0x0800c7ac

af+ 0x800c7e8 (0xd64a-0xc7e8) func_0c7e8

af+ 0x800dda6 (0xda8-0xda6) func_0dda6_dummy
af+ 0x80101b8 (0x394-0x1b8) func_101b8_yet_another_menu
af+ 0x8010606 (0x664-0x606) func_10606
af+ 0x8010674 (0x718-0x674) func_10674
af+ 0x801072c (0x790-0x72c) func_1072c
af+ 0x8010798 (0x830-0x798) func_10798
af+ 0x8010844 (0x8f6-0x844) func_10844
af+ 0x801091c (0x9bc-0x91c) func_1091c
af+ 0x80109ca (0xa5e-0x9ca) func_109ca
af+ 0x8010a5e (0xad8-0xa5e) func_10a5e
af+ 0x8010ae0 (0xb86-0xae0) func_10ae0
af+ 0x8010ba0 (0xbcc-0xba0) func_10ba0
af+ 0x8010c08 (0x10f4-0x0c08) func_10c08_sms_menu_maybe
af+ 0x8011108 (0x1aa-0x108) func_11108

f HandlerForDMA2_Stream3 98 @ 0x8094270
f NextAfterHandlers 1 @ 0x080942d2
af+ (HandlerForDMA2_Stream3) 98 HandlerForDMA2_Stream3 # required to see the SYMBOL as operand for 'bl'
# The stuff beginning at NextAfterHandlers looks like 'non-code' so declare it as data .
#  (the question was HOW. "Add Metadata" (C?), turn this into a section (S?), ..)
# > The C command allows to change type for a byte range. Three basic types are:
# > code (disassembly is done using asm.arch), data (a byte array) or string.
s NextAfterHandlers # wind back to the address of WHAT WB THOUGHT were 'data' (const)
CC const data in the interrupt handler section
Cd 98 # show these N bytes (at the current address) as hexdump, when listing them with 'pd' (!) later

s VectorTable # wind back to the VT and annotate it for the listing..
CC STM32F405 exception- and interrupt vector table
Cd 0x188 # RM0090 page 372 shows last vector of STM32F405 at VT-offset 0x0184, thus 0x0188 bytes


# Read the addresses of certain interrupt handlers
#      directly from the vector table, to annotate them below.
# From radare2-explorations.pdf :
#  > One nifty way to seek to that address is to use the output of the previous command.
# Below, '(s VectorTable+4)' winds to the address of the RESET VECTOR in the VT .
# 'pxw 4' would then dump the address followed by the value (result: 0x0800c004  0x080f9245).
# The tilde is a kind of grep to process the previous output,
# and the output can be accessed like an array (whitespace delimited).
#  > If we then surround the expression with backticks (`), then it
#  > will be expanded to its value when executed, similar to bash.
s (VectorTable+0x04) # seek_addr = VectorTable+4 = address of the RESET HANDLER
s `pxw 4~[1]`      # seek_addr = *(DWORD*)(seek_addr)
# ex: f Reset_Handler # Reset_Handler = seek_addr
# if all went well, and you found out how to type a backtick on your keyboard,
# the result (value of Reset_Handler) will now be 0x080F9245 (in the "D13.020" firmware) .
# Radare2 doesn't know that the LSBit in 0x080F9245 indicates 'Thumb' code,
# but the real interrupt service handler begins at an EVEN ADDRESS. Help him out:
s- 1 # seek_addr -= 1,  should be the 'real' (EVEN) handler address now,
# example (Reset_Handler): $$ = 0x080f9244 . Let Radare2 treat this like a function
# "af+ addr size name [type] [diff]" :  hand craft a function (***requires afb+ ***)
#      ... but wtf is "afb+", and why does "af+" REQUIRE it ?
# "afb+ fa a sz [j] [f] ([t]( [d]))" :  add bb to function @ fcnaddr
#   (finding out what the parameters mean is a nightmare. Solution may be hidden in radare2book.)
f Reset_Handler 8 @ $$ # Reset_Handler = seek_addr (as a "flag")
af+ $$ 8 Reset_Handler # put the SIZE IN BYTES after the '$$' if you know it
# The reset-handler in Tytera's firmware looks very much the same
#     as the startup used for an LPC1788 in Keil's "MDK-ARM",
#     where a Reset_Handler for almost any Cortex-M looks like this:
# Reset_Handler PROC         ; stolen from the startup for an LPC1788
#               IMPORT  SystemInit
#               IMPORT __main
#   LDR     R0, =SystemInit  ; good place for an 'early' breakpoint
#   BLX     R0
#   LDR     R0, =__main      ; this is NOT the "real main" but Keil's scatterload-thingy
#   BX      R0               ; size of this minimalistic 'Reset_Handler' = 8 bytes
# Address offsets of these handlers from RM0090 Rev 7 pages 369 to 372,
# but names (when implemented at all) are compatible with startup_stm32f4xx.s !
s (VectorTable+0x08) # seek_addr = VectorTable + offs(NMI_Handler)
s `pxw 4~[1]`
s- 1
f NMI_Handler
#af+ $$ 4 NMI_Handler

s (VectorTable+0x0C) # HardFault..
s `pxw 4~[1]`
s- 1
f HardFault_Handler
#af+ $$ 4 HardFault_Handler

s (VectorTable+0x10) # MemManage..
s `pxw 4~[1]`
s- 1
f MemManage
#af+ $$ 4 MemManage

s (VectorTable+0x14) # BusFault..
s `pxw 4~[1]`
s- 1
f BusFault_Handler
#af+ $$ 4 BusFault_Handler

s (VectorTable+0x18) # UsageFault..
s `pxw 4~[1]`
s- 1
f UsageFault_Handler
#af+ $$ 8 UsageFault_Handler

s (VectorTable+0x2C) # SVC_Handler.. (syscall via 'SWI' = Soft Ware Interrupt)
s `pxw 4~[1]`
s- 1
f SVC_Handler
#af+ $$ 8 SVC_Handler

s (VectorTable+0x30) # DebugMon_Handler..
s `pxw 4~[1]`
s- 1
f DebugMon_Handler
#af+ $$ 8 DebugMon_Handler

s (VectorTable+0x38) # PendSV_Handler..
s `pxw 4~[1]`
s- 1
#f PendSV_Handler # had an invalid address in the VT so don't try to disassemble
#af+ $$ 8 PendSV_Handler

s (VectorTable+0x3C) # seek_addr = VectorTable+4*15 = address of SysTick_Handler
s `pxw 4~[1]`      # seek_addr = *(DWORD*)(seek_addr);
s- 1               # seek_addr -= 1;  should be the 'real' handler address now
f SysTick_Handler  # SysTick_Handler = seek_addr (as a "flag")
#af+ $$ 0x20 SysTick_Handler

s (VectorTable+0x40) # WWDG_Handler.. (gefensterter Wachhund)
s `pxw 4~[1]`
s- 1
#f WWDG_IRQHandler
af+ $$ 4 WWDG_IRQHandler

s (VectorTable+0x44) # PVD_Handler..
s `pxw 4~[1]`
s- 1
#f PVD_IRQHandler
af+ $$ 4 PVD_IRQHandler

s (VectorTable+0x48) # TAMP_STAMP_Handler.. (tampern und stampfen, sehr schön)
s `pxw 4~[1]`
s- 1
#f TAMP_STAMP_IRQHandler
af+ $$ 4 TAMP_STAMP_IRQHandler

s (VectorTable+0x4C) # RTC_WKUP_Handler..
s `pxw 4~[1]`
s- 1
f RTC_WKUP_IRQHandler
#af+ $$ 56 RTC_WKUP_IRQHandler

s (VectorTable+0x50) # FLASH_IRQHandler..
s `pxw 4~[1]`
s- 1
#f FLASH_IRQHandler
af+ $$ 4 FLASH_IRQHandler

s (VectorTable+0x54) # RCC_IRQHandler..
s `pxw 4~[1]`
s- 1
#f RCC_IRQHandler
af+ $$ 4 RCC_IRQHandler

s (VectorTable+0x58) # EXTI0_IRQHandler..
s `pxw 4~[1]`
s- 1
f EXTI0_IRQHandler
#af+ $$ 4 EXTI0_IRQHandler

s (VectorTable+0x5C) # EXTI1_IRQHandler..
s `pxw 4~[1]`
s- 1
f EXTI1_IRQHandler
#af+ $$ 4 EXTI1_IRQHandler

s (VectorTable+0x60) # EXTI2_IRQHandler..
s `pxw 4~[1]`
s- 1
f EXTI2_IRQHandler
#af+ $$ 4 EXTI2_IRQHandler

s (VectorTable+0x64) # EXTI3_IRQHandler..
s `pxw 4~[1]`
s- 1
f EXTI3_IRQHandler
#af+ $$ 4 EXTI3_IRQHandler

s (VectorTable+0x68) # EXTI4_IRQHandler..
s `pxw 4~[1]`
s- 1
#f EXTI4_IRQHandler
af+ $$ 4 EXTI4_IRQHandler

s (VectorTable+0x6C) # DMA1_Stream0_IRQHandler..
s `pxw 4~[1]`
s- 1
#f DMA1_Stream0_IRQHandler
af+ $$ 4 DMA1_Stream0_IRQHandler

s (VectorTable+0x70) # DMA1_Stream1_IRQHandler..
s `pxw 4~[1]`
s- 1
#f DMA1_Stream1_IRQHandler
af+ $$ 4 DMA1_Stream1_IRQHandler # just a dummy

s (VectorTable+0x74) # DMA1_Stream2_IRQHandler..
s `pxw 4~[1]`
s- 1
#f DMA1_Stream2_IRQHandler
af+ $$ 8 DMA1_Stream2_IRQHandler # NO DUMMY !

s (VectorTable+0x78) # DMA1_Stream3_IRQHandler..
s `pxw 4~[1]`
s- 1
#f DMA1_Stream3_IRQHandler
af+ $$ 4 DMA1_Stream3_IRQHandler

s (VectorTable+0x7C) # DMA1_Stream4_IRQHandler..
s `pxw 4~[1]`
s- 1
#f DMA1_Stream4_IRQHandler
af+ $$ 4 DMA1_Stream4_IRQHandler

s (VectorTable+0x80) # DMA1_Stream5_IRQHandler..
s `pxw 4~[1]`
s- 1
#f DMA1_Stream5_IRQHandler
af+ $$ 8 DMA1_Stream5_IRQHandler # NO DUMMY !

s (VectorTable+0x84) # DMA1_Stream6_IRQHandler..
s `pxw 4~[1]`
s- 1
#f DMA1_Stream6_IRQHandler
af+ $$ 4 DMA1_Stream6_IRQHandler

s (VectorTable+0x88) # ADC_IRQHandler..
s `pxw 4~[1]`
s- 1
#f ADC_IRQHandler # had an invalid address so don't try to disassemble
#af+ $$ 4 ADC_IRQHandler

s (VectorTable+0x8C) # CAN1_TX_IRQHandler..
s `pxw 4~[1]`
s- 1
f CAN1_TX_IRQHandler
#af+ $$ 4 CAN1_TX_IRQHandler

s (VectorTable+0x90) # CAN1_RX0_IRQHandler..
s `pxw 4~[1]`
s- 1
f CAN1_RX0_IRQHandler
#af+ $$ 4 CAN1_RX0_IRQHandler

s (VectorTable+0x94) # CAN1_RX1_IRQHandler..
s `pxw 4~[1]`
s- 1
f CAN1_RX1_IRQHandler
#af+ $$ 4 CAN1_RX1_IRQHandler

s (VectorTable+0x98) # CAN1_SCE_IRQHandler..
s `pxw 4~[1]`
s- 1
f CAN1_SCE_IRQHandler
#af+ $$ 4 CAN1_SCE_IRQHandler

s (VectorTable+0x9C) # EXTI9_5_IRQHandler..
s `pxw 4~[1]`
s- 1
#f EXTI9_5_IRQHandler
af+ $$ 4 EXTI9_5_IRQHandler

s (VectorTable+0xA0) # TIM1_BRK_TIM9_IRQHandler..
s `pxw 4~[1]`
s- 1
#f TIM1_BRK_TIM9_IRQHandler
af+ $$ 4 TIM1_BRK_TIM9_IRQHandler

s (VectorTable+0xA4) # TIM1_UP_TIM10_IRQHandler..
s `pxw 4~[1]`
s- 1
#f TIM1_UP_TIM10_IRQHandler
af+ $$ 4 TIM1_UP_TIM10_IRQHandler

s (VectorTable+0xA8) # TIM1_TRG_COM_TIM11_IRQHandler..
s `pxw 4~[1]`
s- 1
#f TIM1_TRG_COM_TIM11_IRQHandler
af+ $$ 4 TIM1_TRG_COM_TIM11_IRQHandler

s (VectorTable+0xAC) # TIM1_CC_IRQHandler..
s `pxw 4~[1]`
s- 1
#f TIM1_CC_IRQHandler
af+ $$ 4 TIM1_CC_IRQHandler

s (VectorTable+0xB0) # TIM2_IRQHandler..
s `pxw 4~[1]`
s- 1
af+ $$ (0xDDE-0xD5E) TIM2_IRQHandler # NOT a dummy !

s (VectorTable+0xB4) # TIM3_IRQHandler..
s `pxw 4~[1]`
s- 1
f TIM3_IRQHandler
#af+ $$ 8 TIM3_IRQHandler

s (VectorTable+0xB8) # TIM4_IRQHandler..
s `pxw 4~[1]`
s- 1
f TIM4_IRQHandler
#af+ $$ 8 TIM4_IRQHandler

s (VectorTable+0xBC) # I2C1_EV_IRQHandler..
s `pxw 4~[1]`
s- 1
#f I2C1_EV_IRQHandler
af+ $$ 4 I2C1_EV_IRQHandler

s (VectorTable+0xC0) # I2C1_ER_IRQHandler..
s `pxw 4~[1]`
s- 1
#f I2C1_ER_IRQHandler
af+ $$ 4 I2C1_ER_IRQHandler

s (VectorTable+0xC4) # I2C2_EV_IRQHandler..
s `pxw 4~[1]`
s- 1
#f I2C2_EV_IRQHandler
af+ $$ 4 I2C2_EV_IRQHandler

s (VectorTable+0xC8) # I2C2_ER_IRQHandler..
s `pxw 4~[1]`
s- 1
#f I2C2_ER_IRQHandler
af+ $$ 4 I2C2_ER_IRQHandler

s (VectorTable+0xCC) # SPI1_IRQHandler..
s `pxw 4~[1]`
s- 1
#f SPI1_IRQHandler
af+ $$ 4 SPI1_IRQHandler

s (VectorTable+0xD0) # SPI2_IRQHandler..
s `pxw 4~[1]`
s- 1
#f SPI2_IRQHandler
af+ $$ 4 SPI2_IRQHandler

s (VectorTable+0xD4) # USART1_IRQHandler..
s `pxw 4~[1]`
s- 1
#f USART1_IRQHandler
af+ $$ 4 USART1_IRQHandler

s (VectorTable+0xD8) # USART2_IRQHandler..
s `pxw 4~[1]`
s- 1
#f USART2_IRQHandler
af+ $$ 4 USART2_IRQHandler

s (VectorTable+0xDC) # USART3_IRQHandler..
s `pxw 4~[1]`
s- 1
#f USART3_IRQHandler
af+ $$ 4 USART3_IRQHandler

s (VectorTable+0xE0) # EXTI15_10_IRQHandler..
s `pxw 4~[1]`
s- 1
#f EXTI15_10_IRQHandler
af+ $$ 4 EXTI15_10_IRQHandler

s (VectorTable+0xE4) # RTC_Alarm_IRQHandler..
s `pxw 4~[1]`
s- 1
#f RTC_Alarm_IRQHandler
af+ $$ 4 RTC_Alarm_IRQHandler

s (VectorTable+0xE8) # OTG_FS_WKUP_IRQHandler..
s `pxw 4~[1]`
s- 1
f OTG_FS_WKUP_IRQHandler
#af+ $$ 4 OTG_FS_WKUP_IRQHandler

s (VectorTable+0xEC) # TIM8_BRK_TIM12_IRQHandler..
s `pxw 4~[1]`
s- 1
#f TIM8_BRK_TIM12_IRQHandler
af+ $$ 4 TIM8_BRK_TIM12_IRQHandler

s (VectorTable+0xF0) # TIM8_UP_TIM13_IRQHandler..
s `pxw 4~[1]`
s- 1
f TIM8_UP_TIM13_IRQHandler
#af+ $$ 4 TIM8_UP_TIM13_IRQHandler

s (VectorTable+0xF4) # TIM8_TRG_COM_TIM14_IRQHandler..
s `pxw 4~[1]`
s- 1
#f TIM8_TRG_COM_TIM14_IRQHandler
af+ $$ 4 TIM8_TRG_COM_TIM14_IRQHandler

s (VectorTable+0xF8) # TIM8_CC_IRQHandler..
s `pxw 4~[1]`
s- 1
#f TIM8_CC_IRQHandler
af+ $$ 4 TIM8_CC_IRQHandler

s (VectorTable+0xFC) # DMA1_Stream7_IRQHandler..
s `pxw 4~[1]`
s- 1
#f DMA1_Stream7_IRQHandler
af+ $$ 4 DMA1_Stream7_IRQHandler

s (VectorTable+0x0100) # FSMC_IRQHandler..
s `pxw 4~[1]`
s- 1
#f FSMC_IRQHandler
af+ $$ 4 FSMC_IRQHandler

s (VectorTable+0x104) # SDIO_IRQHandler..
s `pxw 4~[1]`
s- 1
#f SDIO_IRQHandler
af+ $$ 4 SDIO_IRQHandler

s (VectorTable+0x108) # TIM5_IRQHandler..
s `pxw 4~[1]`
s- 1
f TIM5_IRQHandler
#af+ $$ 4 TIM5_IRQHandler

s (VectorTable+0x10C) # SPI3_IRQHandler..
s `pxw 4~[1]`
s- 1
#f SPI3_IRQHandler
af+ $$ 8 SPI3_IRQHandler # NOT a dummy !

s (VectorTable+0x110) # USART4_IRQHandler..
s `pxw 4~[1]`
s- 1
#f USART4_IRQHandler
af+ $$ 4 USART4_IRQHandler

s (VectorTable+0x114) # USART5_IRQHandler..
s `pxw 4~[1]`
s- 1
#f USART5_IRQHandler
af+ $$ 4 USART5_IRQHandler

s (VectorTable+0x118) # TIM6_DAC_IRQHandler..
s `pxw 4~[1]`
s- 1
f TIM6_DAC_IRQHandler
#af+ $$ 4 TIM6_DAC_IRQHandler

s (VectorTable+0x11C) # TIM7_DAC_IRQHandler..
s `pxw 4~[1]`
s- 1
f TIM7_DAC_IRQHandler
#af+ $$ 4 TIM7_DAC_IRQHandler

s (VectorTable+0x120) # DMA2_Stream0_IRQHandler..
s `pxw 4~[1]`
s- 1
af+ $$ 4 DMA2_Stream0_IRQHandler
CCa 0x80FC68C endless loop, handler not in use

s (VectorTable+0x124) # DMA2_Stream1_IRQHandler..
s `pxw 4~[1]`
s- 1
af+ $$ 4 DMA2_Stream1_IRQHandler # just a dummy

s (VectorTable+0x128) # DMA2_Stream2_IRQHandler..
s `pxw 4~[1]`
s- 1
af+ $$ 4 DMA2_Stream2_IRQHandler

s (VectorTable+0x12C) # DMA2_Stream3_IRQHandler..
s `pxw 4~[1]`
s- 1
af+ $$ (0x2d2-0x270) DMA2_Stream3_IRQHandler # NO dummy !

s (VectorTable+0x130) # DMA2_Stream4_IRQHandler..
s `pxw 4~[1]`
s- 1
af+ $$ 4 DMA2_Stream4_IRQHandler

#omitted : ETH, CAN,

s (VectorTable+0x14C) # OTG_FS_IRQHandler..
s `pxw 4~[1]`
s- 1
#f OTG_FS_IRQHandler
af+ $$ (0x8093F88-0x8093F70) OTG_FS_IRQHandler

s (VectorTable+0x150) # DMA2_Stream5_IRQHandler..
s `pxw 4~[1]`
s- 1
af+ $$ 4 DMA2_Stream5_IRQHandler

s (VectorTable+0x154) # DMA2_Stream6_IRQHandler..
s `pxw 4~[1]`
s- 1
af+ $$ 4 DMA2_Stream6_IRQHandler

s (VectorTable+0x158) # DMA2_Stream7_IRQHandler..
s `pxw 4~[1]`
s- 1
af+ $$ 4 DMA2_Stream7_IRQHandler


s (VectorTable+0x15C) # USART6_IRQHandler.. not used by Tytera, abused for backlight-PWM by DL4YHF
s `pxw 4~[1]`
s- 1
#f USART6_IRQHandler
af+ $$ 4 USART6_IRQHandler

s (VectorTable+0x160) # I2C3_EV_IRQHandler..
s `pxw 4~[1]`
s- 1
#f I2C3_EV_IRQHandler
af+ $$ 4 I2C3_EV_IRQHandler

s (VectorTable+0x164) # I2C3_ER_IRQHandler..
s `pxw 4~[1]`
s- 1
#f I2C3_ER_IRQHandler
af+ $$ 4 I2C3_ER_IRQHandler

s (VectorTable+0x168) # OTG_HS_EP1_OUT_IRQHandler..
s `pxw 4~[1]`
s- 1
#f OTG_HS_EP1_OUT_IRQHandler
af+ $$ 4 OTG_HS_EP1_OUT_IRQHandler

s (VectorTable+0x16C) # OTG_HS_EP1_IN_IRQHandler..
s `pxw 4~[1]`
s- 1
#f OTG_HS_EP1_IN_IRQHandler
af+ $$ 4 OTG_HS_EP1_IN_IRQHandler

s (VectorTable+0x170) # OTG_HS_WKUP_IRQHandler..
s `pxw 4~[1]`
s- 1
#f OTG_HS_WKUP_IRQHandler
af+ $$ 4 OTG_HS_WKUP_IRQHandler

s (VectorTable+0x174) # OTG_HS_IRQHandler..
s `pxw 4~[1]`
s- 1
#f OTG_HS_IRQHandler
af+ $$ 4 OTG_HS_IRQHandler

s (VectorTable+0x178) # DCMI_IRQHandler..
s `pxw 4~[1]`
s- 1
#f DCMI_IRQHandler
af+ $$ 4 DCMI_IRQHandler

s (VectorTable+0x17C) # CRYP_IRQHandler..
s `pxw 4~[1]`
s- 1
#f CRYP_IRQHandler
af+ $$ 4 CRYP_IRQHandler

s (VectorTable+0x180) # HASH_RNG_IRQHandler..
s `pxw 4~[1]`
s- 1
#f HASH_RNG_IRQHandler
af+ $$ 4 HASH_RNG_IRQHandler

s (VectorTable+0x184) # FPU_IRQHandler..
s `pxw 4~[1]`
s- 1
#f FPU_IRQHandler
af+ $$ 4 FPU_IRQHandler
# Phew. And those weren't even ALL interrupts yet !



# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# BELOW: Mostly from md380tools/applet/src/symbols_d13.020 .
af+ 0x080417e0 (0xC66-0x7e0) dmr_CSBK_handler

af+ 0x800d69c (0x90c-0x69c) disp_something
af+ 0x800db88 (0xcde-0xb88) func_0db88
af+ 0x800dcec (0xda6-0xcec) func_0dcec
af+ 0x800dda8 (0xe64-0xda8) func_0dda8
af+ 0x800de64 (0xed4-0xe64) func_0de64
af+ 0x800ded8 (0xef6-0xed8) gfx_drawtext10
af+ 0x800def6 (0xf1a-0xef6) gfx_drawtext
af+ 0x800df1a 250 draw_datetime_row
af+ 0x800e02a (0x0a6-0x02a) F_4220
af+ 0x800e0ac (0x128-0x0ac) F_786
af+ 0x800e128 (0x286-0x128) F_4154
af+ 0x800e298 (0x382-0x298) F_4284
af+ 0x800e398 (0x4b4-0x398) convert_freq_to_str
af+ 0x800e4b4 (0x516-0x4b4) something_with_radio_config_and_channel_info
af+ 0x800e538 (0x6e4-0x538) draw_zone_channel
f draw_channel_label 0 0x0800e5a6
f draw_zone_label 0 0x0800e682
af+ 0x800e6e8 (0x6f6-0x6e8) func_0e6e8
af+ 0x800e6f6 (0x704-0x6f6) menu_RX_QRG_to_str
af+ 0x800e728 (0xb36-0x728) Volume_Menu
f menu_6_15_1 0 0x0800e7a8
f menu_6_1_1 0 0x0800e7cc
af+ 0x0800eb98 (0xf2aa-0xeb98) menu_dispatcher
f menu.dispatcher.unkn1 0 0x0800eba2
f menu.dispatch.greenkey 0 0x0800ed3a
f menu.dispatch.redkey_maybe 0 0x0800f2a0
af+ 0x800f2f8 (0x492-0x2f8) menu_F_4144
af+ 0x800f4ac (0x68c-0x4ac) menu_func_0f4ac
af+ 0x800f6a8 (0xc54-0x6a8) menu_func_0f6a8 
af+ 0x800fc54 (0xc84-0xc54) menu_add_number_of_menuentries_counts
af+ 0x800fc84 18 md380_menu_entry_back
af+ 0x800fc96 32 return_to_mode_1_from10
af+ 0x800fcbc (0xde2-0xcbc) menugreen.Contacts.800fcbc
af+ 0x800fde8 (0xe62-0xde8) menu_func_0fde8
af+ 0x800fe74 (0xf62-0xe74) menu_func_0fe74
af+ 0x800ff62 (0x10062-0x0ff62) menu_func_0ff62
af+ 0x801002c (0x120-0x02c) menu_func_1002c
af+ 0x8010120 (0x1aa-0x120) menu_func_10120

af+ 0x801044e (0x470-0x44e) func_1044e
af+ 0x801047c (0x546-0x44e) func_1047c
af+ 0x8010550 (0x606-0x550) func_10550
af+ 0x80115ec (0x6f0-0x5ec) func_115ec
af+ 0x80116f4 (0x770-0x6f4) func_116f4
af+ 0x8011790 (0x826-0x790) func_11790
af+ 0x801182c (0x8b4-0x82c) func_1182c
af+ 0x80118bc (0x92c-0x8bc) func_118bc
af+ 0x8011938 (0x998-0x938) func_11938
af+ 0x80119a0 (0x9fa-0x9a0) func_119a0

af+ 0x8012670 (0x8fa-0x670) md380_menu_12670
af+ 0x8012900 (0x95a-0x900) md380_menu_12900
af+ 0x8012964 (0xa00-0x964) md380_menu_12964_uses_event5_buffer
af+ 0x8012a08 (0xada-0xa08) md380_menu_12a08
af+ 0x8012ada (0xb74-0xada) md380_menu_12ada
af+ 0x8012b78 (0xc48-0xb78) md380_menu_12b78
af+ 0x8012c4c (0xce2-0xc4c) md380_menu_12c4c
af+ 0x8012d08 (0xdd2-0xd08) md380_menu_12d08
af+ 0x8012ddc (0xe6c-0xddc) md380_menu_12ddc
af+ 0x8012e70 (0xf28-0xe70) md380_menu_12e70
af+ 0x8012f30 (0xfc2-0xf30) md380_menu_12f30
af+ 0x8012fcc (0x3082-0x2fcc) md380_menu_12fcc
af+ 0x8013082 (0x100-0x082) md380_menu_13082
af+ 0x8013114 (0x1a6-0x114) md380_menu_13114
af+ 0x80131ac (0x26c-0x1ac) md380_menu_zone
CCa 0x8013234 md380_menu_apply_new_zone_maybe
af+ 0x8013270 (0x308-0x270) md380_menu_13270
af+ 0x8013314 (0x3a8-0x314) md380_menu_channel_related_13314
af+ 0x80133b0 (0x412-0x3b0) md380_menu_curr_chn_related_133b0
af+ 0x8013418 (0x49c-0x418) md380_menu_apply_new_zone_maybe
af+ 0x80134a0 408 Create_Menu_Utilities
af+ 0x80136c0 930 md380_menu_entry_programradio

CCa 0x801351e R.a.d.i.o...S.e
CCa 0x801354e R.a.d.i.o...I.n.
CCa 0x801359a P.r.o.g.r.a.m..
CCa 0x80135ce G.P.S./.B.e.i.D
CCa 0x8013602 R.X...G.P.S.I.n.
CCa 0x8013710 E.d.i.t...C.h.a.
CCa 0x8013762 R.x...F.r.e.q.u
CCa 0x80137ba C.h.a.n.n.e.l.
CCa 0x80137e8 T.i.m.e...O.u.t
CCa 0x8013824 C.T.C./.D.C.S
CCa 0x8013890 C.o.l.o.r...C.o
CCa 0x80138be R.e.p.e.a.t.e.r.
CCa 0x80138ec T.x.C.o.n.t.a.
CCa 0x801391a G.r.o.u.p.L.i.s
CCa 0x801394a C.o.l.o.r...C.o
CCa 0x8013978 R.e.p.e.a.t.e.r

CCa 0x8013a1e E.n.t.e.r...P.

af+ 0x80154a4 152 menu_timeslot
af+ 0x80156a4 104 Create_Menu_Entry_RX_QRG_shown
af+ 0x8015720 220 Create_Menu_Entry_RX_QRG_1
CCa 0x80157e2 _Create_Menu_Entry_RX_QRG_2
#CCa 0x80157e6 _Create_Menu_Entry_RX_QRG_3
af+ 0x80157fc 126 Create_Menu_Entry_RX_QRG_2
af+ 0x801587a 102 Create_Menu_Entry_RX_QRG_3
CCa 0x80158c4 _Create_Menu_Entry_RX_QRG_4
af+ 0x8015900 628 Create_Menu_Entry_RX_QRG_4

af+ 0x8016a96 (0xad0-0xa96) func_16a96_copy_version_nr_to_print_buffer
af+ 0x8016ad4 (0xb2a-0xad4) func_16ad4
af+ 0x8016b34 (0xbf2-0xb34) func_16b34
af+ 0x8016c00 (0xc7e-0xc00) func_16c00
af+ 0x8016ca4 (0xfe0-0xca4) func_16ca4
af+ 0x8016fe4 (0x709a-0x6fe4) func_16fe4
af+ 0x80170c4 (0x284-0x0c4) func_170c4

af+ 0x8017cbc 1404 Create_Menu_Entry_RadioSettings

af+ 0x801f0f0 (0xe40-0x0f0) func_1f0f0_menu_something


CCa 0x8017f48 I.n.t.r.o...S.c.
CCa 0x8017f94 K.e.y.p.a.d...L.
CCa 0x8017fcc L.a.n.g.u.a.g.e
CCa 0x8018018 L.E.D...I.n.d.i.

af+ 0x8018a40 (0xa9a-0xa40) func_18a40
af+ 0x8018aa4 (0xb0a-0xaa4) func_18aa4_GetDateAndConv2String
af+ 0x8018b28 236 md380_itow
af+ 0x801aa60 (0xb76-0xa60) menu_func_1aa60
af+ 0x801ad56 246 Create_Menu_Entry_LEDIndicator
af+ 0x801b042 26 md380_menu_numerical_input
CCa 0x801b8e8 md380_menu_0x2001d3f1
af+ 0x801bb9c (0xcb8-0xb9c) menu_cursor_related_1bb9c
af+ 0x801be2c (0xeee-0xe2c) menu_using_sms_and_edit_buf_1be2c
af+ 0x801bef4 (0xf56-0xef4) menu_1bef4
af+ 0x801bf56 (0xff2-0xf56) func_1bf56
af+ 0x801bffc (0xc084-0xbffc) func_1bffc

af+ 0x801c1c8 (0x1e6-0x1c8) gfx_1c1c8
af+ 0x801c1e6 (0x1fe-0x1e6) gfx_1c1e6
af+ 0x801c1fe (0x274-0x1fe) gfx_1c1fe
af+ 0x801c274 (0x27e-0x274) gfx_1c274
af+ 0x801c27e (0x2a0-0x27e) gfx_1c27e
af+ 0x801c2a0 (0x2e4-0x2a0) gfx_1c2a0
af+ 0x801c2e4 (0x328-0x2e4) gfx_bmp_s1_5
af+ 0x801c328 (0x378-0x328) gfx_bmp_s1_1
af+ 0x801c378 (0x406-0x378) gfx_1c378
af+ 0x801c406 (0x45e-0x406) gfx_1c406
af+ 0x801c45e (0x48a-0x45e) gfx_1c45e
af+ 0x801c48a (0x4ae-0x48a) gfx_1c48a
af+ 0x801c4ae (0x4c2-0x4ae) gfx_bmp_s1_4
af+ 0x801c4c2 (0x4f0-0x4c2) gfx_1c4c2
af+ 0x801c4f0 (0x4fa-0x4f0) gfx_1c4f0
af+ 0x801c4fa (0x530-0x4fa) gfx_1c4fa
af+ 0x801c530 (0x566-0x530) gfx_1c530
af+ 0x801c566 (0x58a-0x566) gfx_1c566
af+ 0x801c58a (0x63c-0x58a) gfx_1c58a
af+ 0x801c63c (0x6d4-0x63c) gfx_1c63c
af+ 0x801c6d4 (0x758-0x6d4) gfx_1c6d4
af+ 0x801c758 (0x77e-0x758) gfx_1c758
af+ 0x801c77e (0x792-0x77e) gfx_1c77e
af+ 0x801c792 (0x7aa-0x792) gfx_1c792
af+ 0x801c7aa (0x7bc-0x7aa) gfx_copy_8byte_thing
af+ 0x801c7bc (0x834-0x7bc) gfx_1c7bc
af+ 0x801c834 (0x840-0x834) gfx_1c834
af+ 0x801c840 (0x86c-0x840) gfx_1c840
af+ 0x801c86c (0x9b8-0x86c) gfx_1c86c
af+ 0x801c9b8 (0x9d4-0x9b8) gfx_1c9b8
af+ 0x801c9d4 (0xaa4-0x9d4) gfx_1c9d4
af+ 0x801caa4 (0xae8-0xaa4) gfx_1caa4
af+ 0x801cae8 (0xaf2-0xae8) gfx_1cae8
af+ 0x801caf2 (0xc94-0xaf2) gfx_1caf2
CCa 0x801caf4 local sp0, sp1, sp2

af+ 0x801cc94 (0xCF0-0xC94) gfx_bmp_sub3
CCa 0x801ccee returns ZERO when nothing more to draw ?

af+ 0x801ccf0 (0xE10-0xCF0) gfx_bmp_sub1
CCa 0x801ccf4 [in] R0 = address of a small struct (?) - see gfx_drawbmp
CCa 0x801cd1e [r0+0x3C] = also something colour-related ?
CCa 0x801cd36 some 'LCD_COLORINDEX_UNION' ?
CCa 0x801cd48 R1 = address of a small struct passed on from gfx_drawbmp ?
CCa 0x801cd4a R0 = address of a similar 'small struct' (on the stack) ?

af+ 0x801d174 (0x1c2-0x174) func_1d174 
af+ 0x801d1c2 (0x1d6-0x1c2) gfx_1d1c2
af+ 0x801d1d6 (0x21c-0x1d6) gfx_1d1d6
af+ 0x801d21c (0x224-0x21c) gfx_1d21c
af+ 0x801d224 (0x232-0x224) gfx_1d224
af+ 0x801d238 (0x296-0x238) gfx_1d238
CCa 0x801d272 return but not end of function
af+ 0x801d296 (0x30e-0x296) gfx_1d296
af+ 0x801d368 (0x370-0x368) gfx_set_bg_color
af+ 0x801d370 (0x378-0x370) gfx_set_fg_color
af+ 0x801d378 (0x44e-0x378) gfx_1d378 # calls put_pixel multiple times
af+ 0x801d44e (0x598-0x44e) gfx_1d44e # also calls put_pixel multiple times
af+ 0x801d598 (0x6e0-0x598) gfx_1d598 # guess what... also calls put_pixel multiple times
af+ 0x801d6e0 (0x784-0x6e0) gfx_1d6e0 # also calls put_pixel multiple times .. sigh
af+ 0x801d784 (0x7ca-0x784) gfx_1d784 # yet another function that draws something PIXEL BY PIXEL
af+ 0x801d7ca (0x7EE-0x7CA) gfx_put_pixel
af+ 0x801d7ee (0x7FA-0x7EE) gfx_read_pixel_wrapper
af+ 0x801d7fa (0x81A-0x7FA) gfx_linefill_sub
af+ 0x801d81a (0x84E-0x81A) gfx_linefill
af+ 0x801d84e (0x882-0x84E) gfx_linefill2
af+ 0x801d88c (0x8aa-0x88c) gfx_blockfill
af+ 0x801d8aa (0x952-0x8aa) gfx_jmptbl_entry3
af+ 0x801d952 2 gfx_1d952_does_nothing
af+ 0x801d954 (0x95e-0x954) InitLCD_wrapper
af+ 0x801d95e 2 gfx_1d95e_does_nothing
af+ 0x801d960 (0x988-0x960) gfx_drawchar_unk
af+ 0x801d988 (0xCC0-0x988) gfx_1d988
af+ 0x801dcc0 (0xCE8-0xCC0) gfx_clear3
CCa 0x801dcc2 [in] R0= number of CHARS or PIXELS to clear ?
CCa 0x801dce2 [in] R0=x1, R1=y1, R2=x2, R3=y2 ?
af+ 0x801dd08 (0xD1A-0xD08) gfx_drawtext2
af+ 0x801dd1a (0xD2C-0xD1A) gfx_drawtext4
af+ 0x801dd2c (0xD3C-0xD2C) gfx_drawtext5
af+ 0x801dd3c (0xD5C-0xd3c) gfx_1dd3c # questionable

# above: last function that belong to the 'graphic' function.
# below: stuff that also 'paints' but seems to be keyboard-related
af+ 0x801dd5c (0xE5E4-0xDD5C) often_called_something_keycode_menu
af+ 0x801e5f4 (0xABC-0x5f4) paint_a_lot


af+ 0x801fe5c 5454 f_4225

af+ 0x8021694 294 draw_statusline_more

af+ 0x8021874 16 gfx_select_font
f gfx_select_font 0 0x8021874
CCa 0x8021876 [r0+0x18] = gfx_info.font_pointer
CCa 0x8021878 [in] R0=font addr, e.g. 0x0809a4c0 = gfx_font_small
CCa 0x802187e set NEW font address
CCa 0x8021880 return OLD font address
af+ 0x8021888 8 gfx_get_xpos
af+ 0x8021890 8 gfx_get_ypos

f gfx_drawchar @ 0x0802189c
af+ 0x802189c 154 gfx_drawchar    # uc_GUI/emWin: CL_DispChar(U16 c) ?
CCa 0x802189e local var: GUI_RECT r ?
CCa 0x80218a0 [in] R0 = character code (8 bit, maybe 16 for Chinese)
CCa 0x80218a4 get [r0+34] = gfx_info.xpos (16 bit)
CCa 0x80218a8 [r1+64] = gfx_info.bmp_w alias 'CharDistX' (??)
CCa 0x80218ae set [r0+34] = gfx_info.xpos (for next char?)
CCa 0x80218b2 get [r1+36] = gfx_info.ypos
CCa 0x80218b6 [r1+68] = gfx_info.bmp_h alias 'FontSizeY' (??)
CCa 0x80218bc set [r1+36] = gfx_info.ypos
CCa 0x80218c4 temp0 = incremented xpos
CCa 0x80218c8 R0 = character code again
CCa 0x80218ca zero-extend 16- to 32-bit
CCa 0x80218d2 r.y1 = DispPosY + FontSizeY - 1 (?)
CCa 0x80218e8 only vague similarities with CL_DispChar() ...

af+ 0x8021940 18 gfx_drawchar_pos # emWin: GUI_DispCharAt(U16 c, I16 x, I16 y) ?



af+ 0x802256a 324 aes_startup_check
af+ 0x80226c0 18 Get_Welcome_Line1_from_spi_flash
af+ 0x80226d2 18 Get_Welcome_Line2_from_spi_flash

af+ 0x80226f6 18 rc_write_radio_config_to_flash # 0x80226f6

f init_radioconfig_2_from_spi @ 0x08022714
f read_40_from_2100_spi @ 0x08022716

af+ 0x80229b6 (0x9fe-0x9b6) func_229b6
af+ 0x802297c (0x992-0x97c) load_contact_spiflash
af+ 0x8022992 (0x9b6-0x992) load_contact
af+ 0x80229b6 (0x9da-0x9b6) func_229b6
af+ 0x80229da (0x9fe-0x9da) func_229da
af+ 0x80229fe (0xa72-0x9fe) func_229fe
af+ 0x8022a72 (0xa8c-0xa72) func_22a72
af+ 0x8022a8c (0xaa6-0xa8c) func_22a8c
af+ 0x8022aa6 156 channel_info_read_spi_init
af+ 0x8022b42 (0xcac-0xb42) func_22b42
f load_contact_call @ 0x08022bda

af+ 0x8022cac 26 write_current_channel_info_to_spi
af+ 0x8022e88 26 spiflash_read_3ff30_288
af+ 0x8022ea2 26 spiflash_write_3ff30_288
af+ 0x8022ebc 18 md380_spiflash_read_zone_struct_with_number_in_byte3_maybe
# Here's another "literal-decoding error" from Radare2:
# 0x08022ec4   dff8f807     ldr.w r0, [0x080236c4] ; [0x80236c4:4]=0x416d0 <- BUG ! ldr.w r0, #0x2001e57c 
#  Correct disassembly from objdump : 
#    8022ec4:  f8df 07f8    ldr.w r0, [pc, #2040]  ; 0x80236c0
#    80236c0:  e57c (lower 16 bits of the CORRECT literal value)
#    80236c2:  2001 (upper 16 bits of the CORRECT literal value)
CCa 0x8022ec4 BUG in Radare2 ! LDR R0, lit=0x2001e57c

f msg_flash_write @ 0x08022fe8

af+ 0x802318e (0x1A0-0x18e) func_2318e
af+ 0x80231a8 26 write_current_channel_info_to_spi_long

# mostly gfx (graphic functions) but some edit/menu stuff crept in
af+ 0x8023760 (0x7FE-0x760) gfx_bmp_sub2
CCa 0x8023766 [in] R0 =
CCa 0x8023768 [in] R1 =
CCa 0x802376A [in] R2 =

af+ 0x80237fe 86 gfx_drawbmp
CCa 0x8023800 [in] R0 = bitmap ptr
CCa 0x8023802 [in] R1 = xpos
CCa 0x8023804 [in] R2 = ypos
CCa 0x8023808 [r0+64] = gfx_info.bmp_w
CCa 0x802380a xpos += gfx_info.bmp_w
CCa 0x802380e [r0+68] = gfx_info.bmp_h
CCa 0x8023810 ypos += gfx_info.bmp_h
CCa 0x8023814 [SP+0] = xpos + gfx_info.bmp_w
CCa 0x8023818 bitmap hdr offset 0 = gfx_bitmap.width
CCa 0x8023820 [SP+4] = x_end = xpos + width - 1
CCa 0x8023826 [SP+2] = ypos + bitmap_height
CCa 0x802382a bitmap hdr offset 2 = gfx_bitmap.height
CCa 0x8023832 [SP+6] = y_end = ypos + height - 1
CCa 0x8023836 R0 = address of a small struct (local var) ?
CCa 0x8023838 returns NULL when 'not drawable' ?
CCa 0x8023840 [in] R2 = unknown for gfx_bmp_sub2
CCa 0x8023842 [in] R1 = unknown for gfx_bmp_sub2
CCa 0x8023844 [in] R0 = bitmap ptr
af+ 0x8023ee4 394 Edit_Message_Menu_Entry

af+ 0x8025ae4 888 F_4315

af+ 0x801cff2 (0xd02a-0xcff2) func_1cff2
af+ 0x801d074 (0x118-0x074) func_1d074
af+ 0x801d118 (0x174-0x118) func_1d118
af+ 0x801fe54 (0xe5c-0xe54) func_1fe54
af+ 0x80213d0 (0x4ea-0x3d0) func_213d0
af+ 0x80214ea (0x4fe-0x4ea) func_214ea
af+ 0x80214fe (0x596-0x4fe) func_214fe
af+ 0x8021596 (0x5c2-0x596) func_21596_draw_something
af+ 0x80215c2 (0x5fc-0x5c2) func_215c2
af+ 0x80215fc (0x646-0x5fc) func_215fc
af+ 0x8021646 (0x680-0x646) func_21646
af+ 0x8021936 (0x940-0x936) func_21936
af+ 0x8021958 (0x2502-0x1958) func_21958_spiflash_something
af+ 0x8022502 (0x532-0x502) func_22502_spiflash_security
af+ 0x8022532 (0x550-0x532) func_22532_spiflash_security_2
af+ 0x8022550 (0x56a-0x550) func_22550_spiflash_security_3
af+ 0x80226ae (0x6c0-0x6ae) func_226ae_spiflash_rd_2
af+ 0x80226e4 (0x6f6-0x6e4) func_226e4_spiflash_rd_3
af+ 0x8022714 (0x93e-0x714) init_radioconfig_2_from_spi
af+ 0x802293e (0x950-0x93e) func_2293e_spiflash_wr_2
af+ 0x8022950 (0x962-0x950) func_22950_spiflash_rd_4
af+ 0x8022962 (0x97c-0x962) func_22962_spiflash_rd_5
         # 0x802297c load_contact_spiflash, etc..
af+ 0x8022cc6 (0xd5e-0xcc6) func_22cc6_spiflash_rd_6
af+ 0x8022d5e (0xd74-0xd5e) func_22d5e_spiflash_wr_3

af+ 0x8022d74 (0xd8e-0xd74) spiflash_rd_zone_name_2__64byte
CCa 0x8022d82 read zone name (32 byte) plus 32 other bytes. Purpose ?
af+ 0x8022d8e (0xe1a-0xd8e) spiflash_rd_something_zone_depending
CCa 0x8022d96 zone_name[0] := 0x00
CCa 0x8022da0 R1 = SPI_addr = 64 * R0 + R2
CCa 0x8022daa R0=dst, R1=SPI-addr, R2=length
f rd_zone_name.loop 0 0x08022db0
CCa 0x8022dd2 zone_name[0] := zone_name[0] + 1

af+ 0x8022e1a (0xe32-0xe1a) func_22e1a_spiflash_rd_8
af+ 0x8022e32 (0xe4a-0xe32) func_22e32_spiflash_rd_9
af+ 0x8022e4a (0xe64-0xe4a) func_22e4a_spiflash_rd_10
         # 0x8022e64 flash_read_...
af+ 0x8022ece (0xee0-0xece) md380_spiflash_write_zone_struct_with_number_in_byte3_maybe
         # "lit=" should be a recognized token for disasm2htm.py .
         # We use it intensively to show those bugged addresses (or literal values)
         # where Radare2 made a mistake when decoding the literal (constant)
         # in a PC-relative 'ldr' instruction like the one at 0x8022ed6 :
         # > 0x08022ed6 dff8e807 ldr.w r0, [0x080236c6] ; [0x80236c4:4]=0x416d0 ; BUG in Radare2 ! LDR R0, lit=0x2001e57c
         #                                      /|\             /|\         /|\      
         #                                       |               |           |
         #                                      wrong     aligned but wrong  nonsense !
         # The same file disassembled with good old arm-none-eabi-objdump:
         # > 8022ed6:   f8df 07e8 ldr.w r0, [pc, #2024] ; 0x80236c0
         #                  (H)(L) 0x07E8 = #2024 = offset added to PC *of the next instruction*.
         # When a Cortex-M (!) reads the PC in the above PC-relative expression,
         # the value of PC has already been incremented BY FOUR BYTES (details in ST's PM0056),
         # but that's not the whole story about the effective address of the string literal:
         # > ST PM0056 ("DocID15491 Rev 5"), chapter 3.3.6 PC-relative expressions:
         # >  (..) the value of the PC is the address of the current instruction plus four bytes, 
         # >  with bit[1] of the result cleared to 0 to make it word-aligned (..)
         # ("bit[0] of the result is always zero because any instruction (here: Thumb)
         #  is on an even address anyway. )
         # Try to digest this (it's important to understand what MAY go wrong in Radare2): 
         # PC when adding "#2024" : 0x08022ed6 + 4 + 0x07E8 = 0x080236C2 (note: "bit[1]" is SET here).
         # Thus the final ADDRESS OF THE 32-BIT LITERAL is    0x080236C0 ,
         # which confirms the good old gcc_arm\bin\arm-none-eabi-objdump is CORRECT,
         # and the stuff generated by Radare 2 (in this tricky case)     is WRONG !!
         # (wonder how many false assumptions about the Tytera firmware have been drawn from these
         #  wrong 'decodes', especially wrong addresses of variables in RAM. Aaaaaaaaaargh !!!!!)
         # So *arm-none-eabi-objdump* (NOT Radare2) gave the correct ADDRESS OF THE LITERAL,
         # but what's the LITERAL VALUE (loaded into R0 at 0x08022ed6) ?
         # From the 17-MByte-monster generated by arm-none-eabi-objdump:
         # >  80236c0:  e57c  (lower 16 bit)
         # >  80236c2:  2001  (upper 16 bit)  -> the literal (constant loaded into R0) is 0x2001e57C, 
         #                                       not the nonsense (0x416d0) shown by R2.
         # Guesswork: Radare2 is not (or at least WAS not) aware that this is THUMB, not ARM code.
         #   In ("32-bit") ARM instructions, the PC-relative effective address is indeed EIGHT BYTES
         #   larger, not just FOUR as in "16-bit" Thumb mode. 
         # Back to the MD380 firmware (D13.020 at 0x8022ed6) : R0 is loaded with #0x2001e57,
         # which seems to be the address of a FOUR- or FIVE-byte structure that contains
         # the current ZONE-NUMBER (starts counting at ONE for the first zone) 
         # in the THIRD byte. The other bytes appeared to be 0xFF when viewed in HexMon:
         # > 2001E57C : FF FF FF 01 FF  (when the FIRST zone was active, here: "OWL")
         # If the *assumption* that md380_spiflash_write_zone_struct_with_number_in_byte3_maybe
         # really stores that 'zone_struct' in SPI-flash at offset 0x02F000 (objdump and Radare2 agreed on this..),
         # DL4YHF's HexMon (integrated in the experimental MD380-*firmware*) should show:
         # > C002F000 : FF FF FF 01 FF  (which confirms the non-volatile storage address for the ZONE NUMBER)
         # ( |_ (address bits 31..28 = "C" informed HexMon to read from SPI-Flash, not the CPU's address space)
         # Phew. Enough of that. The above 'findings' made their way into md380tools/applet/src/amenu_codeplug.c .  
CCa 0x8022ed6 BUG in Radare2 ! LDR R0, lit=0x2001e57c
CCa 0x8022eda write flash, R0=SrcAddr(RAM), R1=FlashOffset, R2=NumBytes
af+ 0x8022ee0 (0xef2-0xee0) func_22ee0_spiflash_rd_12
af+ 0x8022ef2 (0xf04-0xef2) func_22ef2_spiflash_wr_12
af+ 0x8022f04 (0xf24-0xf04) func_22f04_spiflash_rd_sms_hdr
af+ 0x8022f24 (0xf50-0xf24) func_22f24_spiflash_wr_sms_hdr
af+ 0x8022f50 (0xfa4-0xf50) func_22f50_spiflash_rd_13
af+ 0x8022fa4 (0xfb6-0xfa4) func_22fa4_spiflash_rd_14
af+ 0x8022fb6 (0xfc8-0xfb6) func_22fb6_spiflash_wr_14
af+ 0x8022fc8 (0xfe8-0xfc8) func_22fc8_spiflash_rd_sms_bdy
af+ 0x8022fe8 (0x3014-0x2fe8) msg_flash_write
af+ 0x8023018 (0x096-0x018) func_23018_spiflash_rd_15
af+ 0x8023096 (0x0b0-0x096) func_23096_spiflash_rd_16
af+ 0x80230b0 (0x0ca-0x0b0) func_230b0_spiflash_rd_17
af+ 0x80230ca (0x0e2-0x0ca) func_230ca_spiflash_rd_18
af+ 0x80230e8 (0x102-0x0e8) func_230e8_spiflash_rd_19
af+ 0x8023102 (0x116-0x102) func_23102
af+ 0x8023116 (0x132-0x126) func_23126_spiflash_rd_curr_chnl
af+ 0x802314c (0x162-0x14c) func_2314c
af+ 0x8023162 (0x178-0x162) func_23162_spiflash_wr_20
af+ 0x8023178 (0x1c2-0x178) func_23178_spiflash_wr_21
af+ 0x80231c2 (0x212-0x1c2) func_231c2_spiflash_rd_22
af+ 0x8023220 (0x290-0x220) func_23220
af+ 0x8023294 (0x2e4-0x294) func_23294
af+ 0x80232e4 (0x354-0x2e4) func_232e4
af+ 0x8023358 (0x36a-0x358) func_23358_spiflash_rd_d11c
af+ 0x802336a (0x37c-0x36a) func_2336a
af+ 0x8023380 (0x398-0x380) func_23380
af+ 0x802339c (0x3ae-0x39c) func_2339c
af+ 0x80233b4 (0x3c6-0x3b4) func_233b4
af+ 0x80233cc (0x3e4-0x3cc) func_233cc
af+ 0x80233e8 (0x40c-0x3e7) func_233e8
af+ 0x8023414 (0x464-0x414) func_23414
af+ 0x8023464 (0x4d4-0x464) func_23464
af+ 0x80234d4 (0x4e6-0x4d4) func_234d4
af+ 0x80234e6 (0x4f8-0x4e6) func_234e6
af+ 0x80234f8 (0x510-0x4f8) func_234f8
af+ 0x8023514 (0x526-0x514) func_23514
af+ 0x8023526 (0x538-0x526) func_23526
af+ 0x802354c (0x5c2-0x54c) func_2354c
af+ 0x802361c (0x628-0x61c) func_2361c
af+ 0x8023634 (0x644-0x634) func_23634
af+ 0x8023644 (0x656-0x644) func_23644
af+ 0x8023656 (0x668-0x656) func_23656
af+ 0x802366c (0x67e-0x66c) func_2366c
af+ 0x802367e (0x690-0x67e) func_2367e
af+ 0x8023690 (0x6a6-0x690) func_23690
  # end of the boring spiflash-read/write stuff, next: gfx_bmp_sub2

af+ 0x8025790 (0x93a-0x790) func_25790_menu_create_something
af+ 0x8025e60 (0xe7a-0xe60) func_25e60
af+ 0x8025e8e (0xf78-0xe8e) func_25e8e
af+ 0x8025ff4 (0x60ac-0x5ff4) func_25ff4
af+ 0x8026230 (0x28c-0x230) func_26230
af+ 0x8026298 (0x2ce-0x298) func_26298
af+ 0x8027270 (0x31c-0x270) func_27270
af+ 0x80273b0 (0x3f6-0x3b0) func_273b0

af+ 0x80275dc (0x656-0x5dc) func_275dc
af+ 0x8027e3e (0xe56-0xe3e) func_27e3e
af+ 0x8027e6c (0xec0-0xe6c) func_27e6c
af+ 0x8027ec0 (0xed0-0xec0) func_27ec0
af+ 0x8027ed0 (0xef0-0xed0) func_27ed0
af+ 0x8027ef0 (0xf46-0xef0) func_27ef0
af+ 0x8027f46 (0xf5e-0xf46) func_26f46
af+ 0x8027f64 (0xf8e-0xf64) func_26f64

af+ 0x8027656 112 msg_convert
af+ 0x8027728 154 gfx_drawtext6
af+ 0x80277c2 16 gfx_drawtext7
# void gfx_drawtext7(const char *str, int x, int y) was used for the
# 'console' / netmon in the patched FW, see applet/src/gfx.h (etc).
CCa 0x80277c2 [in] R0=string, R1=x, R2=y
CCa 0x80277c6 [r3+0x22] = gfx_info.xpos (uint16)
CCa 0x80277ca [r1+0x24] = gfx_info.ypos (uint16)
CCa 0x80277cc x and y now passed via gfx_info

af+ 0x8027f90 54 menu_set_something
af+ 0x8027fcc 36 menu_draw_something3
af+ 0x8027ff0 (0xffa-0xff0) menu_draw_sub_27ff0
af+ 0x8027ffa (0x8010-0x7ffa) menu_draw_sub_27ffa
af+ 0x8028010 (0x02a-0x010) menu_28010

af+ 0x802872c (0xB96-0x72C) menu_draw_something
af+ 0x8028be8 (0xD80-0xBE8) menu_draw_something2
af+ 0x802802a 84 menu_draw_something4
af+ 0x80280d2 62 menu_draw_something5

af+ 0x802aac0 (0xb6e-0xac0) func_2aac0
af+ 0x802ab8c (0xba8-0xb8c) func_2ab8c
af+ 0x802aba8 (0xbba-0xba8) func_2aba8
af+ 0x802abba (0xbce-0xbba) func_2abba
af+ 0x802abce (0xc0c-0xbce) func_2abce
af+ 0x802ac0c (0xc2e-0xc0c) func_2ac0c
af+ 0x802ac2e (0xc5c-0xc2e) func_2ac2e

af+ 0x802b088 (0x0D4-0x088) gfx_2b088
af+ 0x802b1d6 (0x1E2-0x1D6) gfx_drawtext_sub4
af+ 0x802b3f6 80 md380_RTC_GetTime
af+ 0x802b50c 76 md380_RTC_GetDate
af+ 0x802b6c0 (0x6DE-0x6C0) RTCWakeupIRQ_Sub1
af+ 0x802b70e (0x726-0x70E) rtc_sub1

af+ 0x802b726 (0x748-0x726) func_2b726

# GPIO (most likely they used stm32f4xx_gpio.c, quite bloated)
af+ 0x802B748 (0x7ee-0x0x748) GPIO_Init
CCa 0x802B748 in: R0=base address of a GPIO block
CCa 0x802B75A in: R1=address of a GPIO_InitStruct
CCa 0x802B75C if same as in stm32f4xx_gpio.c, R4='GPIO_Pin'
# beware, many characters cannot be used in 'CCa'..
CCa 0x802B770 [R0+0] = GPIOx Mode Register
CCa 0x802B774 [R1+4] = GPIO_InitStruct.GPIO_Mode
CCa 0x802B78E [R0+8] = GPIOx Output Speed Register
CCa 0x802B7A0 [R1+5] = GPIO_InitStruct.GPIO_Speed
CCa 0x802B7AE [R0+4] = GPIOx Output Type Register
CCa 0x802B7BA [R1+6] = GPIO_InitStruct.GPIO_OType
CCa 0x802B7C4 [R0+0xC] = GPIOx PullUp/PullDown Reg
CCa 0x802B7BA [R1+7] = GPIO_InitStruct.GPIO_PuPd
CCa 0x802B7E8 loop for multiple pins of the same port
af+ 0x802B7EE (0x804-0x7ee) GPIO_ReadInputDataBit
CCa 0x802B7F0 in: R0=base address of a GPIO block, +0x10 = 'IDR'
CCa 0x802B7F2 zero-extend to 32 bits (2nd arg, R1, is UINT16)
CCa 0x802B7F4 R0=value read from GPIO InputDataRegister
CCa 0x802B800 return value in R0 looks like BOOLEAN
af+ 0x802b804 (0x80A-0x804) GPIO_ReadInputData
CCa 0x802b804 in: R0=GPIOx base address (or something completely different?)
CCa 0x802b806 out: R0=value from InputDataRegister (?)
af+ 0x802b80a 4 GPIO_SetBits
af+ 0x802b80e 4 GPIO_ResetBits
af+ 0x802b812 (0x20-0x12) GPIO_WriteBit
CCa 0x802b812 in: R2='BitVal', 0=RESET, 1=SET
CCa 0x802b816 in: R1='GPIO_Pin', 0..15
CCa 0x802b818 in: R0=GPIOx base address
af+ 0x802b820 (0x72-0x20) GPIO_PinAFConfig
CCa 0x802b826 in: R2=Alternate Function number
CCa 0x802b828 in: R1=GPIO_PinSource, see stm32f4xx_gpio.c
CCa 0x802b828 (GPIO_PinSource & 0x07) * 4 ..
CCa 0x802b840 in: R0=GPIOx base address

af+ 0x802b874 (0x878-0x874) func_2b874
af+ 0x802bad0 (0xad4-0xad0) func_2bad0
af+ 0x802bfcc (0xfd0-0xfcc) func_2bfcc
af+ 0x802c4e0 (0x4e4-0x4e0) func_2c4e0
af+ 0x802c6fc (0x7a6-0x6fc) func_2c6fc
af+ 0x802c7a6 (0x7e8-0x7a6) func_2c7a6

af+ 0x802d368 (0x516-0x368) some_init
af+ 0x802d57c (0x7dc-0x57c) display_unprog_screen
af+ 0x802d7f8 (0xadc-0x7f8) display_idle_screen
af+ 0x802daf8 (0xd12-0xaf8) func_2daf8
af+ 0x802dd12 (0xd2e-0xd12) func_2dd12
af+ 0x802dd34 (0xd36-0xd34) func_2dd34
af+ 0x802dd36 (0xe3c-0xd36) func_2dd36_beeps_and_sets_kb_keycode
af+ 0x802e73c (0x7ac-0x73c) func_2e73c_uses_menu_cursor_pos_1
af+ 0x802e7bc (0x858-0x7bc) func_2e7bc
af+ 0x802e860 (0x90a-0x860) func_2e860
af+ 0x802e918 (0x980-0x918) func_2e918
af+ 0x802e984 (0xa00-0x984) func_2e984_beeps_and_uses_msg_timer_500
af+ 0x802ea0c (0xa9e-0xa0c) func_2ea0c_beeps_and_uses_struct_channel_info2
af+ 0x802ea9e (0xb1c-0xa9e) func_2ea9e
af+ 0x802de84 (0xeee-0xe84) func_2de84
af+ 0x802dfbc 1908 md380_f_4137
af+ 0x802f118 (0x25a-0x118) func_2f118
af+ 0x802f268 (0x2dc-0x268) func_2f268
af+ 0x802f302 (0x374-0x302) func_2f302
af+ 0x802f378 (0x39c-0x378) func_2f378
af+ 0x802f418 (0x478-0x418) func_2f418
af+ 0x802f478 (0x520-0x478) func_2f478
af+ 0x802f520 (0x58e-0x520) func_2f520
af+ 0x802f58e (0x706-0x58e) func_2f58e
af+ 0x802f706 (0x876-0x706) func_2f706
af+ 0x802f8a0 (0x8f8-0x8a0) func_2f8a0_erases_and_writes_flash
af+ 0x802f8f8 (0x910-0x8f8) func_2f8f8

af+ 0x802f994 36 bp_sempost
af+ 0x802f9b8 24 bp_sempost2
af+ 0x802f9dc 4056 Beep_Process
CCa 0x802fa36 re issue 227
CCa 0x802fc1e beep 9
CCa 0x802fa54 no dmr sync tone
CCa 0x802fa66 dmr sync
CCa 0x802fad8 0x24 end of rx (Roger beep)
CCa 0x802fbe4 begin roger beep
CCa 0x802fd54 begin dmr sync

af+ 0x80309b8 236 Timer8ToneGenerator
CCa 0x80309d4 [R1+2] = reserved bits in TIM8_CR1 ?
CCa 0x8030a0e write to TIM8_CR1

af+ 0x8030aa4 52 F_293
af+ 0x8030ad8 16 bp_set_freq
af+ 0x8030ae8 32 bp_glisando
af+ 0x8030b58 72 bp_tone_off
af+ 0x8030b08 80 bp_tone_on
af+ 0x8030e74 (0xe78-0xe74) func_30e74
af+ 0x8030fde 2 do_nothing_30fde

af+ 0x8031038 (0x084-0x038) func_31038
af+ 0x8031084 258 md380_OSMboxPend
af+ 0x803119c 86 md380_OSMboxPost
af+ 0x80311f4 (0x1f8-0x1f4) func_311f4
af+ 0x8031276 52 md380_spiflash_sektor_erase4k
af+ 0x80312aa 52 md380_spiflash_block_erase64k
af+ 0x80312de 76 spiflash_program_page
af+ 0x803132a 332 F_1069_spiflash_multiple_spiflash_program_page
af+ 0x8031476 70 md380_spiflash_read
af+ 0x80314bc 58 md380_spi_sendrecv
af+ 0x80314f6 18 spiflash_write_enable
af+ 0x8031508 34 md380_spiflash_wait
af+ 0x803152a 28 md380_spiflash_enable
af+ 0x8031546 24 md380_spiflash_disable
af+ 0x803155e 704 md380_spiflash_write
af+ 0x8031830 52 spiflash_Erase_Security_Registers_44h
af+ 0x8031864 76 spiflash_Program_Security_Registers_42h
af+ 0x80318b0 78 md380_spiflash_security_registers_read
af+ 0x8031900 (0x904-0x900) func_31900
af+ 0x8031da6 (0xdaa-0xda6) func_31da6
af+ 0x8031e10 (0xe60-0xe10) func_31e10
af+ 0x8031e68 (0xe8e-0xe68) func_31e68
af+ 0x8031e8e (0xf1c-0xe8e) func_31e8e
af+ 0x8031f1c (0xf2e-0xf1c) func_31f1c
af+ 0x8031fe2 (0x20fc-0x1fe2) func_31fe2

af+ 0x8032416 (0x41a-0x416) func_32416
af+ 0x8032536 (0x53a-0x536) func_32536
af+ 0x8032712 (0x716-0x712) func_32712
af+ 0x8032722 (0x726-0x722) func_32722
af+ 0x8032a10 (0xa14-0xa10) func_32a10
af+ 0x8032a4e (0xa52-0xa4e) func_32a4e
af+ 0x8032c4c (0xc50-0xc4c) func_32c4c

af+ 0x80320fe (0x130-0x0fe) func_320fe
af+ 0x8032130 (0x1f8-0x130) func_32130
af+ 0x80321f8 (0x23e-0x1f8) func_321f8
af+ 0x803223e (0x28e-0x23e) func_3223e
af+ 0x803228e (0x2d2-0x28e) func_3228e
af+ 0x80322d2 (0x3e6-0x2d2) func_322d2

af+ 0x8032cc8 (0xd0a-0xcc8) gfx_IntersectRect # possibly uc/GUI : GUI__IntersectRect
CCa 0x8032cc8 [in,out] R0 = address of rectangle coords (GUI_RECT* pDest ?)
CCa 0x8032ccc [in] R1 = address of another rectangle (GUI_RECT* pSrc ?)
CCa 0x8032cd0 if( pDest.x0 _GT_ pSrc.x0) .. (speculative)
CCa 0x8032cd2 branch if 1st cmp operand GREATER OR EQUAL than 2nd
CCa 0x8032cd4 .. then pDest.x0 = pSrc.x0 (x0,y0 = FIRST coord in a GUI_RECT)
CCa 0x8032ce0 if( pDest.y0 _GT_ pSrc.y0) .. (speculative)
CCa 0x8032ce6 .. then pDest.y0 = pSrc.y0
CCa 0x8032cf0 if( pDest.x1 _LT_ pSrc.x1) .. (speculative)
CCa 0x8032cf6 .. then pDest.x1 = pSrc.x1 (x1,y1 = SECOND coord)
CCa 0x8032d00 if( pDest.y1 _LT_ pSrc.y1) .. (speculative)
CCa 0x8032d06 .. then pDest.x1 = pSrc.x1
CCa 0x8032d08 on return, pDest has grown to 'include' pSrc (speculative)
# we'll possibly find other functions from STemWin or uC/GUI here...

af+ 0x80328ec (0x8fc-0x8ec) menu_328ec
af+ 0x80328fc (0xa10-0x8fc) menu_328fc
af+ 0x8032a64 (0xa7c-0xa64) gfx_draw_sub_32a64
CCa 0x8032a72 ARM brain teaser. some table access ?
af+ 0x8032a7c (0xade-0xa7c) menu_32a7c

# 0x8032ade .. 0x8032aef looks like a module's literal pool.
# The following address range may be related to uc/GUI or STemWin :
af+ 0x8032af0 (0xb04-0xaf0) gfx_32af0
af+ 0x8032b04 (0xb14-0xb04) gfx_32b04
af+ 0x8032b14 (0xb26-0xb14) gfx_32b14
af+ 0x8032b26 (0xbae-0xb26) gfx_ThreeRectSomething
CCa 0x8032b28 [in] R2 = src struct, GUI_RECT ?
CCa 0x8032b2c [in] R1 = src struct, GUI_RECT ?
CCa 0x8032b3e [in] R0 = dest struct, GUI_RECT ?
af+ 0x8032bae (0xC2c-0xbae) gfx_32bae

af+ 0x8032c2c (0xca2-0xc2c) gfx_memcpy # possibly GUI_MEMCPY (but that's just a macro)
CCa 0x8032c2c [in] R2 = number of bytes to copy
CCa 0x8032c2e [in] R1 = src address
CCa 0x8032c38 [in] R0 = dst address (here byte-wise copy)
CCa 0x8032c4a if more than 16 bytes, use fastest loop
CCa 0x8032c4e if lower then skip and copy the rest
CCa 0x8032c52 fastcopy 16-byte-wise (ip = r12)
CCa 0x8032c62 sometimes I hate ARM for this.. 'if then then higher or same'
CCa 0x8032c64 not even Radare2 understood how many instructions 'itt' may skip
CCa 0x8032c6c This code looks better than much of the compiled stuff.
CCa 0x8032c6e Quite likely this is hand-crafted asm by S....r (?)

af+ 0x8032ca4 (0xcbe-0xca4) gfx_32ca4
CCa 0x8032cac [r1+0x48] = gfx_info.jmptable, 0x8098280 = gfx_jmptbl
CCa 0x8032cae [r1+0x20] = gfx_info.jmptable[8] = 0x08048a15 = gfx_48a14
af+ 0x8032d0a (0xd28-0xd0a) some_long_adding
af+ 0x8032d28 (0xd60-0xd28) func_32d28
af+ 0x8032d60 (0xd8c-0xd60) gfx_32d60
af+ 0x8032d8c (0xdda-0xd8c) gfx_32d8c
af+ 0x8032dda (0xdec-0xdda) gfx_32dda
af+ 0x8032dec (0xdfc-0xdec) gfx_setcolor_sub4
af+ 0x8032dfc (0xE10-0xDFC) gfx_setcolor_sub2
af+ 0x8032e10 (0xE24-0xE10) gfx_setcolor_sub3
af+ 0x8032E24 (0xE5C-0xE24) gfx_32e24
af+ 0x8032E5C (0xEB6-0xE5C) gfx_32e5c
af+ 0x8032EB6 (0xEFC-0xEB6) gfx_32eb6
af+ 0x8032EFC (0xF50-0xEFC) gfx_clipped_blockfill_maybe
CCa 0x8032EFC [in] R0=x1, R1=y1, R2=x2, R3=y2 ?
CCa 0x8032f00 [R4+4] = gfx_info.clip.left ?
CCa 0x8032f10 [R4+8] = gfx_info.clip.right ?
CCa 0x8032f20 nothing visible (horz) ?
CCa 0x8032f24 [R4+6] = gfx_info.clip.top ?
CCa 0x8032f34 [R4+10] = gfx_info.clip.bottom ?
CCa 0x8032f44 nothing visible (vert) ?
CCa 0x8032f48 [R4+0x48] = gfx_info.jmptable, 0x8098280 = gfx_jmptbl
CCa 0x8032f48 [R4+0x18] = gfx_jmptbl[6] = 0x0801d88d = gfx_blockfill
CCa 0x8032f4c gfx_blockfill(R0=x_from,R1=y_from,R2=x_to,R3=y_to)
af+ 0x8032F50 (0x316C-0x2F50) gfx_32f50

af+ 0x8033244 (0x248-0x244) func_33244
af+ 0x8033388 (0x38c-0x388) func_33388
af+ 0x8033f30 (0xf34-0xf30) func_33f30

CCa 0x803308C return but not the end of this function
af+ 0x803316C (0x17A-0x16C) gfx_3316c
af+ 0x803317A (0x1B0-0x17A) gfx_init_lcd
af+ 0x80331B0 (0x1BC-0x1B0) gfx_setcolor_sub1
af+ 0x80331BC (0x1C8-0x1BC) gfx_331bc
CCa 0x80331c4 omg - this branch may go anywhere. VMT ?
af+ 0x8033204 (0x23A-0x204) gfx_33204
af+ 0x803323A (0x24C-0x23A) gfx_3323a
af+ 0x803324C (0x368-0x24C) gfx_3324c
af+ 0x8033244 (0x24c-0x244) gfx_33244
af+ 0x8033368 (0x374-0x368) gfx_33368
af+ 0x8033374 (0x382-0x374) gfx_33374
af+ 0x8033382 (0x396-0x382) gfx_33382
af+ 0x8033396 (0x3CC-0x396) gfx_33396

af+ 0x80333D8 (0x428-0x3D8) gfx_before_lcd_init
CCa 0x80333DA in: R0 = addr(gfx_info)

af+ 0x8033428 (0x496-0x428) gfx_33428
CCa 0x803342C [in] R0 = x1 ?
CCa 0x803342E [in] R1 = y1 ?
CCa 0x8033430 [in] R2 = x2 ?
CCa 0x8033432 [in] R3 = y2 ?

af+ 0x8033496 (0x4B2-0x496) gfx_33496
af+ 0x80334B2 (0x4D2-0x4B2) gfx_init_lcd_and_others
af+ 0x80334F8 (0x51C-0x4F8) gfx_334f8
af+ 0x803351C (0x528-0x51C) gfx_3351c

af+ 0x803352C (0x534-0x52C) WriteLCDCommand # called from what MAY BE 'put_pixel'
af+ 0x8033534 (0x53A-0x534) WriteLCDData # called from what MAY BE 'put_pixel'
# stores R0 in 0x6004000, which may have been something like the following:
#define Bank1_LCD_D 0x60040000 // disp Data ADDR (FSMC bank 1, A18 set to select DATA ?)
#define Bank1_LCD_C 0x60000000 // disp Reg ADDR  (FSMC bank 1, A18 cleared to select CONTROL REGISTER ?)
#define write_command(LCD_DATA) *(BYTE*)Bank1_LCD_C = (BYTE)LCD_DATA;
#define write_data(LCD_COMM)    *(BYTE*)Bank1_LCD_D = (BYTE)LCD_COMM;
#define write_com(LCD_DATA,LCD_COMM)  write_command(LCD_DATA);write_data(LCD_COMM)
af+ 0x803353A (0x546-0x53A) ReadLCDData
af+ 0x8033546 (0x55A-0x546) DeAssertLCDReset
CCa 0x8033548 set PD13 = LCD_RST (de-assert reset)

af+ 0x803355A (0x56E-0x55A) Delay_R0
CCa 0x803355a [in] R0 = delay loop counter
CCa 0x803355e while( nLoops--) .. do nothing

af+ 0x803356E (0x716-0x56E) InitLCDisplay
CCa 0x8033576 ST7735: 0x3A = Interface Pixel Format
CCa 0x803357A ST7735: 0b101= 16 bit/pixel
CCa 0x8033582 ST7335: 0x36 =  Memory ADress ConTroL...
CCa 0x8033590 ST7335: MADCTL bit 3 = RGB/BGR Color Select
CCa 0x8033598 ST7335: MADCTL bit 6 = Column Address Order
CCa 0x803359e '(FEh)' not found in ST7335 datasheet
CCa 0x80335a4 '(EFh)' not found in ST7335 datasheet
CCa 0x80335aa ST7735: 0xB4 = Display Inversion Control
CCa 0x80336fe ST7335: 0x11 = 'Sleep Out' (wake up..)
CCa 0x803370a many LCDs: cmd 0x29 = 'Display ON'
CCa 0x8033710 many LCDs: cmd 0x2C = 'Memory Write'

af+ 0x8033728 (0x770-0x728) gfx_write_pixel_to_framebuffer
CCa 0x8033732 ST7735: cmd 0x2A = 'Column Address Set'
CCa 0x8033738 ST7335: X-Start, H byte ?? (should be zero)
CCa 0x803373e ST7335: X-Start, L byte
CCa 0x8033744 ST7735: cmd 0x2B = 'Row Address Set'
CCa 0x8033748 Ym = 159 - Y (0..159), rotated by 90deg
CCa 0x803374c ST7335: Y-Start, H byte ??
CCa 0x8033754 ST7335: Y-Start, L byte
CCa 0x803375a ST7735: cmd 0x2C = 'Memory Write'
CCa 0x8033764 write pixel data, 1st byte
CCa 0x803376a write pixel data, 2nd byte

af+ 0x8033770 (0x7B4-0x770) gfx_read_pixel_from_framebuffer
CCa 0x8033778 ST7735: cmd 0x2A = 'Column Address Set'
CCa 0x8033780 ST7335: X-Start, H byte ??
CCa 0x8033788 ST7335: X-Start, L byte
CCa 0x803378e ST7735: cmd 0x2B = 'Row Address Set'
CCa 0x8033794 see gfx_write_pixel_to_framebuffer
CCa 0x8033798 ST7335: Y-Start, H byte ??
CCa 0x80337A2 ST7335: Y-Start, L byte
CCa 0x80337a8 ST7735: cmd 0x2E = 'Memory Read' (!)
CCa 0x80337ac only reads 8 bits, not 16

af+ 0x80337B4 (0x88E-0x7B4) gfx_drawtext_sub2
af+ 0x803388E (0x966-0x88E) gfx_drawtext_sub3
af+ 0x8033966 (0xA68-0x966) gfx_33966
af+ 0x8033BFC (0xC02-0xBFC) gfx_drawtext_sub1 # wild branch, no usual function

af+ 0x8033c54 (0xC96-0xC54) gfx_get_current_font_height # important for understanding gfx_drawtext7,8
CCa 0x8033c54 some font-related preparation # see call at 0x08036fdc
CCa 0x8033c58 [r1+0x2C] = gfx_info.what ?
CCa 0x8033c72 [r0+0x18] = gfx_info.font_pointer
CCa 0x8033c74 [r0+0x14] = matrix height in pixels ? (gfx_font_small:12, norm:16)
CCa 0x8033c94 returns R0 = some height in pixels, subtracted from gfx_info.ypos at 0x08036fe6

af+ 0x8033dac 244 draw_statusline

af+ 0x8033c1e (0xc54-0xc1e) gfx_drawchar_sub3
CCa 0x8033c3a [r1+0x18] = gfx_info.font_pointer
CCa 0x8033c3c 0x08033A8B (Thumb code), see gfx_font_norm
CCa 0x8033c3e calls font_method_called_via_hdr_offset0

af+ 0x8033a8a (0xb80-0xa8a) font_method_called_via_hdr_offset0
CCa 0x8033a8a called via BLX R1 from gfx_drawchar_sub3
CCa 0x8033a9e [r0+0x18] = gfx_info.font_pointer
CCa 0x8033aa0 [r0+0x18] begin of the font table ?

af+ 0x8033B80 (0xBB0-0xB80) font_method_called_via_hdr_offset4
CCa 0x8033B80 called via BLX R1 from gfx_call_font_method_via_hdr_offset4
CCa 0x8033b8a [r0+0x18] = gfx_info.font_pointer
CCa 0x8033b8c [r0+0x18] begin of the font table ?

af+ 0x8033a70 (0xa8a-0xa70) find_char_in_font_table
CCa 0x8033a70 [in] R0 = linked list with char-codes and font bitmaps ?
CCa 0x8033a76 Zero = end of a linked list ?
CCa 0x8033a7a [in] R1 = character code ?
CCa 0x8033a7e still lower, keep on searching
CCa 0x8033a88 returns non-NULL when successfull ?

af+ 0x8033bb0 (0xbd8-0xbb0) gfx_drawchar_sub4
CCa 0x8033bb2 [in] R0=character code (really?)
CCa 0x8033bba [r0+0x18] = gfx_info.font_pointer
CCa 0x8033bbc [r0+0x18] begin of the font table ?
CCa 0x8033bbe [in] R1=char, R0= font table

f gfx_rc @ 0x080249be

f gfx_set_fg_color2 0 0x080331e0
af+ 0x80331e0 24 gfx_set_fg_color2
CCa 0x80331e4 [R1+48] = gfx_info.fg_color, 24-bit RGB
CCa 0x80331e8 RGB value not modified, no need to convert to TFT-format
CCa 0x80331ee convert colour model via fx ptr / class method ?

f gfx_set_bg_color2 @ 0x080331c8
af+ 0x80331c8 24 gfx_set_bg_color2
CCa 0x80331cc [R1+52] = gfx_info.bg_color, 24-bit RGB
CCa 0x80331d0 RGB value not modified, no need to convert to TFT-format
CCa 0x80331d6 convert colour model via fx ptr / class method ?

af+ 0x8033c04 26 gfx_newline
CCa 0x8033c06 return R0 = height of current font in pixels
CCa 0x8033c0c [r1+36] = gfx_info.ypos (16 bit)
CCa 0x8033c0e y_pos += font_height
CCa 0x8033c18 [r1+32] = gfx_info.xpos2 ("left text margin" ?)
CCa 0x8033c1a [r0+34] = gfx_info.xpos (16 bit)

af+ 0x8033eb4 104 OSTimeDly

af+ 0x8033ca6 (0xB4-0xA6) gfx_call_font_method_via_hdr_offset4
CCa 0x8033ca6 [in] R0 = character code (16 bit)
CCa 0x8033cac [r1+0x18] = gfx_info.font_pointer
CCa 0x8033cae 0x08033B81 (Thumb code), see gfx_font_norm
CCa 0x8033cb0 calls font_method_called_via_hdr_offset4

af+ 0x8033cbc (0xC4-0xBC) gfx_set_ypos
af+ 0x8033cc4 (0xCC-0xC4) gfx_set_xpos
af+ 0x8033cd0 (0xCE8-0xCD0) func_33cd0
af+ 0x8033ce8 (0xD42-0xCE8) func_33ce8
af+ 0x8033d42 (0xD76-0xD42) func_33d42
af+ 0x8033d78 (0xDAC-0xD78) gfx_write_pixel_2

af+ 0x803409a (0x09e-0x09a) func_3409a
af+ 0x80340ec (0x0f0-0x0ec) func_340ec
af+ 0x8034164 (0x168-0x164) func_34164
af+ 0x80341a2 (0x1a6-0x1a2) func_341a2
af+ 0x8034208 (0x20c-0x208) func_34208
af+ 0x803423a (0x23e-0x23a) func_3423a
af+ 0x8035524 (0x528-0x524) func_35524
af+ 0x8035a12 (0xa16-0xa12) func_35a12
af+ 0x8035be4 (0xbe8-0xbe4) func_35be4
af+ 0x8036574 (0x578-0x574) func_36574
af+ 0x80369b2 (0x9b6-0x9b2) func_369b2
af+ 0x8036aa8 (0xaac-0xaa8) func_36aa8
af+ 0x8036ad6 (0xada-0xad6) func_36ad6
af+ 0x8036c14 (0xc18-0xc14) func_36c14
af+ 0x8036cc0 (0xcc4-0xcc0) func_36cc0

af+ 0x8036672 (0x6f8-0x672) func_36672
af+ 0x80366f8 (0x736-0x6f8) func_366f8
af+ 0x8036736 (0x808-0x736) func_36736
af+ 0x8036884 (0x916-0x884) func_36884
af+ 0x8036978 (0x980-0x978) gfx_GetFontSizeY
af+ 0x8036980 (0x9b2-0x980) gfx_36980
af+ 0x80369bc (0x9c6-0x9bc) func_369bc
af+ 0x80369c6 (0xaa8-0x9c6) func_369c6
af+ 0x8036ade (0xae6-0xade) func_36ade
af+ 0x8036ae6 (0xb06-0xae6) func_36ae6
af+ 0x8036b06 (0xb26-0xb06) func_36b06
af+ 0x8036b26 (0xb46-0xb26) func_36b26
af+ 0x8036b46 (0xb66-0xb46) func_36b46
af+ 0x8036b66 (0xb86-0xb66) func_36b66
af+ 0x8036b86 (0xbca-0xb86) func_36b86
af+ 0x8036c1c (0xc26-0xc1c) func_36c1c
af+ 0x8036c30 (0xc38-0xc30) aes_36c30
af+ 0x8036c38 (0xcc0-0xc37) aes_cipher
af+ 0x8036cc0 (0xdac-0xcc0) aes_loadkey
af+ 0x8036dac (0xe08-0xdac) func_36dac
af+ 0x8036e08 (0xe32-0xe08) func_36e08
af+ 0x8036e32 (0xe76-0xe32) func_36e32
af+ 0x8036e76 (0xf0a-0xe76) func_36e76
af+ 0x8036f0a (0xf38-0xf0a) func_36f0a
af+ 0x8036f44 (0xF4C-0xF44) func_36f44
af+ 0x8036f4c (0xf8c-0xf4c) func_36f4c
af+ 0x8036f90 (0xf98-0xf90) func_36f90
af+ 0x8036f98 (0xf9a-0xf98) func_36f98
af+ 0x8036f9a (0xfba-0xf9a) func_36f9a
af+ 0x8036fba 2 do_nothing_1
af+ 0x8036fbc 2 do_nothing_2

af+ 0x8036fc0 378 gfx_drawtext8
CCa 0x8036fc4 [in] R0=string (char ptr)
CCa 0x8036fcc bail out if string ptr is NULL
CCa 0x8036fd0 returns R0 = height in pixels
CCa 0x8036fd8 [r0+0x22] = gfx_info.xpos (uint16)
CCa 0x8036fdc retrieves some kind of height (12 or 16 pixels)
CCa 0x8036fe4 [r0+0x24] = gfx_info.ypos (uint16)
CCa 0x8036fe6 SUBTRACT something from current ypos ?
f drawtext8.loop_for_all_chars 0 0x08036fee
CCa 0x8036fee increment char ptr (not in 1st loop)
CCa 0x8036ff4 check_for_0_term
CCa 0x8037002 [in] R0=char, [out] R0='something counted'
CCa 0x8037006 'sb' is simply R9, nothing special about this
CCa 0x8037010 'sl' is simply R10, nothing special about that
CCa 0x8037014 [r0+0x2C] = gfx_info.what ?
CCa 0x803705c temp2 += font_height_in_pixels ?

af+ 0x8037144 (0x148-0x144) func_37144
af+ 0x80376b0 (0x6b4-0x6b0) func_376b0
af+ 0x80376ca (0x6ce-0x6ca) func_376ca
af+ 0x8037736 (0x73a-0x736) func_37736
af+ 0x8037a6a (0xa6e-0xa6a) func_37a6a

# this 'address gap' may be occupied by stuff from uc_GUI or EmWin, 
#  e.g. uc_GUI/GUI/Widget/RADIO.c (multi-element 'radio button' widget),
# but no obvious simularities with the old sources by Segger/Micrium yet.

af+ 0x8037792 (0x7AE-0x792) func_37792
af+ 0x80377ae (0x7CA-0x7AE) func_377ae

af+ 0x803780e (0x82e-0x80e) func_3780e
af+ 0x803782e (0x85a-0x82e) func_3782e
af+ 0x803785a (0x886-0x85a) func_3785a
af+ 0x8037886 (0x892-0x886) func_37886
af+ 0x8037892 (0x90c-0x892) func_37892
af+ 0x8037982 (0x9b0-0x982) func_37982
af+ 0x80379b0 (0x9d2-0x9b0) func_379b0
af+ 0x80379d2 (0x9f0-0x9d2) func_379d2
af+ 0x80379f0 (0xa2e-0x9f0) func_379f0
af+ 0x8037a2e (0xa38-0xa2e) func_37a2e
af+ 0x8037a38 (0xa6a-0xa38) func_37a38
af+ 0x8037a74 (0xa8a-0xa74) func_37a74
af+ 0x8037a8a (0xa94-0xa8a) func_37a8a
af+ 0x8037a94 (0xa9e-0xa94) MultiplySomethingFromStruct
af+ 0x8037a9e (0xab8-0xa9e) func_37a9e
af+ 0x8037ab8 (0xb00-0xab8) func_37ab8
af+ 0x8037b00 (0xb0a-0xb00) func_37b00
af+ 0x8037b0a (0xb6c-0xb0a) func_37b0a
af+ 0x8037b6c (0xb74-0xb6c) func_37b6c
af+ 0x8037b74 (0xbb8-0xb74) func_37b74
af+ 0x8037bb8 (0xc50-0xbb8) func_37bb8
af+ 0x8037c60 (0xc64-0xc60) func_37c60
af+ 0x8037c64 (0xccc-0xc64) func_37c64
af+ 0x8037ccc (0xd02-0xccc) func_37ccc
af+ 0x8037d02 (0xd2a-0xd02) menu_draw_sub_37d02
af+ 0x8037d2a (0xd44-0xd2a) menu_draw_sub_37d2a
af+ 0x8037d44 (0xe0a-0xd44) menu_37d44
af+ 0x8037e0a (0xe34-0xe0a) menu_37e0a

af+ 0x8037e34 (0x80a8-0x7e34) menugreen.Scan.8037e34
af+ 0x80380a8 (0x120-0x0a8) menu_380a8_create_some_entry
af+ 0x8038120 (0x198-0x120) menu_38120_create_something
af+ 0x8038198 (0x216-0x198) menu_38198_create_something
af+ 0x8038218 (0x2ca-0x218) func_38218
af+ 0x80382ca (0x3b8-0x2ca) func_382ca
af+ 0x80383b8 (0x3f8-0x3b8) func_383b8
af+ 0x80383f8 (0x484-0x3f8) func_383f8
af+ 0x80384d4 (0xfce-0x4d4) func_384d4

af+ 0x8039000 (0x004-0x000) func_39000
af+ 0x80391e4 (0x1e8-0x1e4) func_391e4
af+ 0x8039d3c (0xd40-0xd3c) func_39d3c

af+ 0x80393dc (0x51c-0x3dc) func_393dc
af+ 0x803951c (0x55c-0x51c) func_3951c
af+ 0x803955c (0x60c-0x55c) func_3955c
af+ 0x803960c (0x64c-0x60c) func_3960c
af+ 0x8039654 (0x6e4-0x654) menu_39654_create_some_entry
af+ 0x80396e4 (0x7d0-0x6e4) menu_396e4
af+ 0x80397d0 (0x832-0x7d0) func_397d0
af+ 0x8039832 (0x896-0x832) func_39832
af+ 0x8039896 (0x91a-0x896) func_39896_reads_spi_flash
af+ 0x8039930 (0xcce-0x930) menu_39930_creates_many_entries


af+ 0x8039de2 (0xe3e-0xde2) menu_39de2
af+ 0x8039e3e (0xf10-0xe3e) menu_39e3e
af+ 0x8039f10 (0xf50-0xf10) menu_39f10
af+ 0x8039f50 (0xa024-0x9f50) func_39f50
af+ 0x803a024 (0x1de-0x024) menugreen.msg.Sent_Item.803a024 
af+ 0x803a1e0 (0x264-0x1e0) menu_3a1e0
af+ 0x803a264 (0x358-0x264) menu_3a264
af+ 0x803a358 (0x468-0x358) menu_3a358

af+ 0x803aba8 (0xbbc-0xba8) menu_draw_sub_3aba8
af+ 0x803abbc (0xbce-0xbbc) menu_draw_sub_3abbc
af+ 0x803abce (0xbde-0xbce) menu_draw_sub_3abce
af+ 0x803abe4 (0xbf2-0xbe4) menu_draw_sub_3abe4
af+ 0x803abf8 (0xc46-0xbf8) menu_draw_sub_3abf8
af+ 0x803ac46 (0xca6-0xc46) menu_draw_sub_3ac46
af+ 0x803acec (0xcee-0xcec) func_3acec
af+ 0x803ad3c (0xd56-0xD3C) func_3ad3c
af+ 0x803ad54 (0xda2-0xd54) func_3ad54
af+ 0x803ada2 (0xdb0-0xda2) func_3ada2
af+ 0x803adb0 (0xdbe-0xdb0) func_3adb0
af+ 0x803adbe (0xdc8-0xdbe) func_3adbe
af+ 0x803adc8 (0xdd2-0xdc8) func_3adc8
af+ 0x803add4 (0xde6-0xDD4) gfx_3add4
af+ 0x803adec (0xe04-0xdec) gfx_3adec
af+ 0x803ae04 (0xe10-0xe04) gfx_3ae04
af+ 0x803ae10 (0xe1c-0xe10) gfx_3ae10
af+ 0x803ae1c (0xe2e-0xe1c) gfx_3ae1c
af+ 0x803ae30 (0xe66-0xe30) gfx_3ae30
af+ 0x803ae68 (0xeac-0xe68) func_3ae68
af+ 0x803aeac (0xeda-0xeac) func_3aeac
af+ 0x803aeda (0xef8-0xeda) func_3aeda
af+ 0x803aef8 (0xf18-0xef8) func_3aef8
af+ 0x803af18 (0xf50-0xf18) func_3af18
af+ 0x803af50 (0xb076-0xaf50) func_3af50
af+ 0x803b076 (0x0b0-0x076) func_3b076
af+ 0x803b0b0 (0x212-0x0b0) func_3b0b0
af+ 0x803b212 (0x236-0x212) func_3b212
af+ 0x803b236 (0x25a-0x236) func_3b236
af+ 0x803b25a (0x31e-0x25a) func_3b25a
af+ 0x803b31e (0x348-0x31e) func_3b31e
CCa 0x803b33c return but not end of function
af+ 0x803b348 (0x376-0x348) func_3b348
af+ 0x803b376 (0x39a-0x376) func_3b376
af+ 0x803b39a (0x42a-0x39a) main_menu
af+ 0x803b42a (0x50c-0x42a) func_3b42a
af+ 0x803b51c (0x52a-0x51c) func_3b51c
af+ 0x803b52a (0x536-0x52a) func_3b52a
af+ 0x803b536 (0x558-0x536) func_3b536
af+ 0x803b558 (0x5a0-0x558) func_3b558
af+ 0x803b5a0 (0x5d6-0x5a0) func_3b5a0
af+ 0x803b5d6 (0x5ec-0x5d6) func_3b5d6
af+ 0x803b5ec (0x5f8-0x5ec) func_3b5ec
af+ 0x803b5f8 (0x616-0x5f8) func_3b5f8
af+ 0x803b618 (0x67c-0x618) func_3b618

af+ 0x803b67c (0x6BE-0x67C) gfx_font_count_something
CCa 0x803b67c [in] R0 = character code
CCa 0x803b67e [in] R1 = 0x7FFF (some kind of maximum?)
CCa 0x803b680 later return value: counted something
CCa 0x803b68a [r0+0x18] = gfx_info.font_pointer
CCa 0x803b68c [r0+0x10] = font_pointer.xyz ?
CCa 0x803b6ba returns 'something counted' in the font

af+ 0x803b6be (0x6FC-0x6BE) gfx_drawtext_sub7
CCa 0x803b6be [in] R0 = address of something
CCa 0x803b6c0 [in] R1 =
CCa 0x803b6c8 bail out on NULL pointer ?
CCa 0x803b6ce 'method table' with 3 Thumb functions, see three_font_methods
CCa 0x803b6d4 2nd argument for function called via BLX R2
CCa 0x803b6de first method is font_method_1_of_3

af+ 0x803b6fc (0x7B6-0x6FC) gfx_drawtext_sub8

af+ 0x803b7C4 (0x828-0x7C4) gfx_3b7c4
CCa 0x803b7C4 [in] R0 = address of something
CCa 0x803b7d4 [r1+0x1C] = 0x80F8744, set in gfx_before_lcd_init
CCa 0x803b7d6 [0x80F8744] = 0x080F7EB5 = read_byte_ptr_R0

af+ 0x803b828 (0x84C-0x828) gfx_drawtext_sub9
af+ 0x803B850 (0x86C-0x850) gfx_3b850
af+ 0x803B86C (0x8D8-0x86C) gfx_3b86c

af+ 0x803ccd8 (0xcdc-0xcd8) func_3ccd8

af+ 0x803e372 (0x3F6-0x372) func_3e372
af+ 0x803e45e (0x47E-0x45E) TimerIRQ_Sub11

af+ 0x803d924 (0x926-0x924) func_3d924
af+ 0x803d99a (0x99c-0x99a) func_3d99a
af+ 0x803da3c (0xa3e-0xa3c) func_3da3c
af+ 0x803da68 (0xBDE-0xA68) func_3da68
af+ 0x803dbf0 (0xC82-0xBF0) func_3dbf0
af+ 0x803dc90 (0xCF2-0xC90) func_3dc90


af+ 0x803f2c8 (0x314-0x2C8) TimerIRQ_Sub9
af+ 0x803f314 (0x32E-0x314) func_3f314
af+ 0x803f32e (0x34E-0x32E) func_3f32e
af+ 0x803f34e (0x4A0-0x34E) SomethingWithRadioStatus1
af+ 0x803f4a0 (0x4FA-0x4A0) SomeBitFiddling
af+ 0x803f4fa (0x55E-0x4FA) SomethingWithGPIOC_TIM8_TIM7
af+ 0x803f55e (0x5A8-0x55E) SomethingWithTIM7_RadioStatus1
af+ 0x803f5a8 (0x5CC-0x5A8) SomethingWithTIM7_ChannelInfo2
af+ 0x803f5cc (0x5E0-0x5CC) func_3f5cc
af+ 0x803f5e0 (0x626-0x5E0) Something2_TIM7_RadioStatus1
af+ 0x803f626 (0x682-0x626) SomethingWithGPIOC_TIM7_Status
af+ 0x803f682 (0x6c8-0x682) no_code_3f682
af+ 0x803f6c8 (0x6d6-0x6c8) func_3f6c8
af+ 0x803f6dc (0x708-0x6dc) func_3f6dc
af+ 0x803f6dc (0x6e0-0x6dc) func_3f6dc
af+ 0x803f8f2 (0xda8-0x8f2) func_3f8f2_init_PLL_and_C5000
af+ 0x803fda8 (0xf84-0xda8) func_3fda8

af+ 0x804855c (0x562-0x55c) func_4855c
af+ 0x8048e40 (0xe44-0xe40) func_48e40


af+ 0x803de1c (0xe1e-0xe1c) func_3de1c
af+ 0x803df70 (0xf72-0xf70) func_3df70
af+ 0x803e058 (0x05a-0x058) func_3e058
af+ 0x803e1d6 (0x1d8-0x1d6) func_3e1d6
af+ 0x803e318 (0x31a-0x318) func_3e318
af+ 0x803e3f6 (0x3f8-0x3f6) func_3e3f6
af+ 0x803e47e (0x480-0x47e) func_3e47e
af+ 0x803eb2a (0xb2c-0xb2a) func_3eb2a
af+ 0x803f128 (0x12a-0x128) func_3f128
af+ 0x803f190 (0x192-0x190) func_3f190
af+ 0x803f1fc (0x1fe-0x1fc) func_3f1fc
af+ 0x803f6c8 (0x6ca-0x6c8) func_3f6c8
af+ 0x803f6dc (0x6de-0x6dc) func_3f6dc

af+ 0x803f708 76 OSSemCreate
af+ 0x803f754 218 OSSemPend
af+ 0x803f844 92 OSSemPost

af+ 0x804005c (0x05e-0x05c) func_4005c
af+ 0x80401dc (0x1de-0x1dc) func_401dc
af+ 0x8040224 (0x226-0x224) func_40224
af+ 0x80403dc (0x3de-0x3dc) func_403dc
af+ 0x80404dc (0x4de-0x4dc) func_404dc

af+ 0x8040670 880 F_414
af+ 0x8040a02 740 dmr_call_start
af+ 0x8040ce6 92 dmr_before_squelch
af+ 0x8040d44 94 F_858


af+ 0x8040de0 1540 dmr_sms_arrive
af+ 0x8041430 864 dmr_call_end

af+ 0x8043490 (0x4d4-0x490) func_43490_wr_C5000
af+ 0x80434e4 (0x770-0x4e4) func_434e4_wr_C5000
af+ 0x8043824 (0x858-0x824) func_43824_wr_C5000
af+ 0x8043858 (0x97c-0x858) func_43858_wr_C5000
af+ 0x8043a18 (0xa82-0xa18) func_43a18
af+ 0x8043a82 (0xa9a-0xa82) func_43a82
af+ 0x8043a9a (0xaa0-0xa9a) func_43a9a
# Hardware timers ... maybe compiled from stm32f4xx_tim.c
af+ 0x8043aa0 4 TIM_SetCounter
af+ 0x8043aa4 4 TIM_SetAutoreload
af+ 0x8043aa8 4 TIM_GetCounter
af+ 0x8043aac (0xac8-0xaac) func_43aac

af+ 0x8043ac8 (0xAE4-0xAC8) TIM_EnableOrDisableCounter # stupid original name = TIM_Cmd
CCa 0x8043ac8 in: R1: 0=DISABLE, 1=ENABLE counting
CCa 0x8043ace in: R0= TIMx base address, ControlReg1
CCa 0x8043ade what an effort to clear a stupid bit !
af+ 0x8043ae4 (0xB62-0xAE4) TIM_43ae4
af+ 0x8043e70 (0xe74-0xe70) _enable_irq
af+ 0x8043b62 (0xbee-0xb62) func_43b62
af+ 0x8043bee (0xC78-0xBEE) SomethingTestingTIM1_TIM8
af+ 0x8043c78 (0xCE0-0xC78) SomethingElseWithTIM1_TIM8
Cd (0xD00-0xCE0) @0x8043ce0 # looks like data, not executable
af+ 0x8043d00 (0xd22-0xd00) func_43d00
af+ 0x8043d22 (0xd26-0xd22) func_43d22
af+ 0x8043d26 (0xd2a-0xd26) StoreR1_in_PtrR0plus0x3C
af+ 0x8043d2a (0xd3c-0xd2a) func_43d2a
af+ 0x8043d3c (0xd50-0xd3c) func_43d3c
af+ 0x8043d50 (0xd62-0xd50) func_43d50
af+ 0x8043d62 (0xD84-0xD62) func_43d62
af+ 0x8043d84 (0xD9C-0xD84) TIM_ITConfig
CCa 0x8043d84 in: R0= TIMx base address
CCa 0x8043d86 in: R2= 'NewState' (enable,disable)
CCa 0x8043d8a [R0+0xC] = TIMx DMA/Interrupt enable register
CCa 0x8043d8c in: R1= timer interrupt sources, 1=UIE, etc
af+ 0x8043d9c (0xDCA-0xD9C) TimerIRQ_Sub5
af+ 0x8043dca (0xDD2-0xDCA) TIM_ClearFlag
CCa 0x8043dca [in] R1=bit to clear, R0= TIMx base addr
CCa 0x8043dcc Move Negative (complement)
CCa 0x8043dce 'clear pending' in TIMx StatusReg
af+ 0x8043dd2 (0xDE4-0xDD2) func_43dd2 # followed by OS_ENTER_CRITICAL with a strange opcode @ 0x8043de4 !
af+ 0x8043de4 8 OS_ENTER_CRITICAL
CCa 0x8043de4 Not 'invalid' but 'mrs r0, PRIMASK'
af+ 0x8043dec 6 OS_EXIT_CRITICAL
CCa 0x8043dec Not 'invalid' but 'msr PRIMASK, r0'


af+ 0x80442ce (0x2FA-0x2CE) ClearSomeVariables # called from InitGlobalsAndStartRealTimeKernel
af+ 0x80442fa (0x32E-0x2FA) ClearSomeBlocksInRAM # called from InitGlobalsAndStartRealTimeKernel
af+ 0x8044368 (0x3C6-0x368) Func4_of_10 # called from InitGlobalsAndStartRealTimeKernel
af+ 0x804426e (0x2CE-0x26E) Func5_of_10 # called from InitGlobalsAndStartRealTimeKernel
af+ 0x804432e (0x368-0x32E) Create_uCOS_Idle_Task # called from InitGlobalsAndStartRealTimeKernel
CCa 0x804433A Task stack size (static array)
CCa 0x8044350 R0 = pTaskFunc = next PC + 0x101 = OS_IdleTask
CCa 0x8044354 OSTaskCreateExt(pTaskFunc,pvData,pTopOfStack,u8Prio,u16ID,pBotOfStack,u32StackSize,pvExt,u16Options)

# task function, passed to OsTaskCreateExt somewhere. Names inspired by uC/OSII-demo:
af+ 0x8044452 (0x472-0x452) OS_IdleTask # name inspired by uCOS2/EX1.C
CCa 0x8044452 pData=pData, unused argument in R0
CCa 0x8044456 endless 'Idle' task loop
CCa 0x8044460 OSIdleTaskCtr++ # inspired by Micrium, for uC_OS3
CCa 0x8044470 must never return
af+ 0x8044618 (0x658-0x618) func_44618
af+ 0x8044658 (0x758-0x658) SomethingWith_RCC_and_PLL_I2C
af+ 0x804476c (0x788-0x76c) func_4476c
af+ 0x8044788 (0x7A4-0x788) SPI_I2S_EnableOrDisable
CCa 0x8044788 in: R0='SPIx' (SPI or I2S base addr)
CCa 0x804478a in: R1: 0=disable I2S, 1=enable I2S
CCa 0x804478e [R0+0x1C] = SPI_I2SCFGR
CCa 0x8044790 'SPIx.I2SCFGR OR= SPI_I2SCFGR_I2SE'
CCa 0x804479e 'SPIx.I2SCFGR AND= BITNOT SPI_I2SCFGR_I2SE'
# how to convince R2 from misinterpreting many characters in a CCa-text-string ?
# ugly stuff like 'SHL', 'OR=', BITNOT etc had to be used instead of C pseudocode .
af+ 0x80447a4 (0x7FA-0x7A4) func_447a4
af+ 0x80447fa (0x7fe-0x7fa) func_447fa
af+ 0x80447fe (0x802-0x7fe) func_447fe
af+ 0x8044802 (0x81a-0x802) func_44802
af+ 0x804481a (0x846-0x81a) func_4481a
af+ 0x8044846 (0x912-0x846) func_44846 
af+ 0x804485a (0x89E-0x85A) SPI_I2S_GetITStatus
CCa 0x804485a in: R0='SPIx' (SPI or I2S base addr)
CCa 0x804485c in: R1='SPI_I2S_IT' (0x58 from SPI3_IRQHandler)
CCa 0x8044868 'itpos = 0x01 SHL (SPI_I2S_IT & 0x0F)'
CCa 0x8044872 'itmask = SPI_I2S_IT SHR 4'
CCa 0x804487a 'itmask = 0x01 SHL itmask'
CCa 0x804487e [R0+4] = SPI Control Register 2
CCa 0x8044880 'enablestatus = (SPIx.CR2 & itmask)'
CCa 0x8044884 [R0+8] = SPI Status Register
CCa 0x804489C return: R0: 0=interrupt flag RESET, 1=SET
af+ 0x804489e (0x8B4-0x89E) SPI_I2S_ClearITPendingBit
CCa 0x804489e in: R0='SPIx' (SPI or I2S base addr)
CCa 0x804489e in: R1=SPI_I2S_IT, which bit to clear
CCa 0x80448a6 'itpos = 0x01 SHL (SPI_I2S_IT & 0x0F)'
CCa 0x80448ae 'SPIx.SR = BITNOT itpos'
CCa 0x80448b0 [R0+8] = SPI Status Register
af+ 0x80448d4 (0x8d8-0x8d4) func_448d4
af+ 0x8044912 (0x920-0x912) func_44912
af+ 0x8044930 (0x950-0x930) func_44930
af+ 0x8044950 (0xb68-0x950) adc1_adc2_and_dma2s3_init
af+ 0x8044b68 (0xcb4-0xb68) func_44b68
af+ 0x8044cb4 (0xE00-0xCB4) func_44cb4
af+ 0x8044e00 (0x50C8-0x4E00) LongSwitchWithRadioStatus1
af+ 0x80450c8 (0x156-0x0C8) SomethingWithGuiOpmode2
af+ 0x8045156 (0x1CE-0x156) func_45156
af+ 0x80451ce (0x20C-0x1CE) func_451ce
af+ 0x804520c (0x398-0x20C) func_4520c
af+ 0x8045398 (0x414-0x398) func_45398
af+ 0x8045414 (0x44A-0x414) func_45414
af+ 0x8045484 (0x82A-0x484) SomethingWithChannelsRadioConfigAndBeeps
af+ 0x8045830 (0x8EC-0x830) func_45830
af+ 0x80458f8 (0x5922-0x58F8) func_458f8 # called via 'bl' !
af+ 0x8045954 (0xC96-0x954) FuncWithAwfulLongSwitch
af+ 0x8045d18 (0xd62-0xd18) func_45d18
af+ 0x8045d94 (0x604A-0x5D94) SomethingWithLongpressSettingRadioStatus1
af+ 0x8045C9C (0xD0A-0xC9C) CalledFromLongpressThing
#f CalledFromLongpressThing .. removed to supress unhelpful 'LEA'-decodes

af+ 0x8046050 (0x0A0-0x050) func_46050
CCa 0x804607a adc1_result[5] = bat voltage, raw value from DMA-transfer
af+ 0x80460a8 (0x0e8-0x0a8) func_460a8
af+ 0x80460f0 (0x0F8-0x0F0) Calls_46050
af+ 0x80460f8 (0x204-0x0F8) DrawSomethingThenBitBangIO
CCa 0x804612C return but not end of function
af+ 0x8046280 (0xBC-0x80) Create_Start_Task
# Details, and EVEN THE SOURCECODE of OSTaskCreateEx()
# is in the uC/OS-II User's Manual, page 156 .
# For the ARM-ABI's calling convention,
#  registers R0 - R3 are used for the first four arguments
#   ("NCRN" begins with the RIGHTMOST argument, u16Options, in R0),
#  other arguments are pushed to the stack by the caller ("NSAA" begins with *SP), thus:
CCa 0x8046282 reserve stack space for arguments #5 to #9
CCa 0x8046284 3 = OS_TASK_OPT_STK_CHK + OS_TASK_OPT_STK_CLR
CCa 0x8046286 SP[4] = u16Options, 9th and last arg for OSTaskCreateExt
CCa 0x804628a SP[3] = pvExt = user supplied data, 8th arg for OSTaskCreateExt
CCa 0x804628c task stack size (static array)
CCa 0x8046290 SP[2] = u32StackSize, 7th arg for OSTaskCreateExt
CCa 0x8046296 SP[1] = pBotOfStack, 6th arg for OSTaskCreateExt
CCa 0x804629a SP[0] = u16ID, 5th arg for OSTaskCreateExt
CCa 0x804629c R3 = u8Prio, 4th arg for OSTaskCreateExt
CCa 0x804629e R2 once was pTopOfStack, but what is this ?
CCa 0x80462a2 R1 = pvData, 2nd arg for OSTaskCreateExt
CCa 0x80462a4 R0 = pTaskFunc = PC+0x15 = Start(), ca 0x80462bc
CCa 0x80462a8 OSTaskCreateExt(pTaskFunc,pvData,pTOS,u8Prio,u16ID,pBOS,u32StkSize,pvExt,u16Options)
CCa 0x80462b4 OSTaskNameSet(R0=INT8U prio, R1=char *pname, R2=INT8U *err)
CCa 0x80462b8 clear local vars (arguments) from stack

af+ 0x80462bc 314 Start
CCa 0x80463f4 end task 'Start()', never returns
af+ 0x80463f6 (0x520-0x3F6) create_many_semas
af+ 0x8046520 684 Start_multiple_tasks
f create_Sys_Inter @ 0x08046548
f string_RTC_Timer @ 0x80f9f20
CCa 0x8046676 Thumb-addr LED_Process
f string_LED_Process @ 0x80f9f2C
f string_Set_Vocoder @ 0x80f9f38
f string_ChAccess_Pr @ 0x80f9f44
f string_Tone_fft @ 0x80f9f50
f string_DFU_Config @ 0x80f9f5C


f create_RTC_Timer @ 0x0804657c
f create_State_Change @ 0x080467b8
f create_ChAccess_Pr @ 0x0804678a

af+ 0x80467cc (0x8f8-0x7cc) task_rtc_timer
f draw_topline_text_maybe 0 0x080467fa
f draw_botline_text 0 0x08046810
f call_F_4225_2 0 0x080468e6
f mainloop_entry 0 0x080468ae
f jmp_to_mainloop 0 0x080468f6

af+ 0x80468f8 (0xc04-0x8f8) task_468f8 # calls c5000_spi0_writereg and MANY others
af+ 0x8046c04 (0xC24-0xc04) init_a_lot_gfx_and_lcd
af+ 0x8046c24 (0xD0A-0xc24) init_more_and_start_watchdog
af+ 0x8046dc0 (0xf48-0xdc0) func_46dc0
af+ 0x8046f48 (0xf8e-0xf48) func_46f48
af+ 0x8046f8e (0x7234-0x6f8e) func_46f8e

af+ 0x804729c (0x312-0x29c) func_4729c
af+ 0x8047312 (0x47c-0x312) func_47312
af+ 0x80474a0 (0x50c-0x4a0) func_474a0_heavy_bitbanging
CCa 0x80474fe clear PE13, PE5, PE4, PE1, PE0 ?
CCa 0x8047506 set PE2 and PE6, DMR/C5000 control ?
af+ 0x8047518 (0x578-0x518) adc3_init
af+ 0x80475b8 (0x75a-0x5b8) func_475b8
af+ 0x80477a4 (0x802-0x7a4) func_477a4
CCa 0x80477fc set PE11 =  'PTT_KEY' ??

af+ 0x8047802 (0x88a-0x802) func_47802
CCa 0x8047824 clear PE11 =  'PTT_KEY' ??
CCa 0x8047884 set PE11 =  'PTT_KEY' ??
af+ 0x804788a (0x8d0-0x88a) func_4788a
af+ 0x80478d0 (0x96a-0x8d0) func_478d0
af+ 0x804796a (0x9e6-0x96a) func_4796a
af+ 0x80479e6 (0xa52-0x9e6) func_479e6_channel_related
af+ 0x8047a52 (0xa84-0xa52) func_47a52
af+ 0x8047a84 (0xab6-0xa84) func_47a84
af+ 0x8047ab6 (0xbac-0xab6) func_47ab6
af+ 0x8047bac (0xC06-0xBAC) TimerIRQ_Sub1
af+ 0x8047c06 (0xC2E-0xC06) TimerIRQ_Sub4
af+ 0x8047c2e (0xC56-0xC2E) TimerIRQ_Sub8
af+ 0x8047c56 (0xC8E-0xC56) WaitAndDoSomethingWithGPIOC
af+ 0x8047c8e (0xCEC-0xC8E) SomethingWithChannelInfo2
af+ 0x8047cec (0xD00-0xCEC) func_47cec
af+ 0x8047d5c (0xe54-0xd5c) func_47d5c
af+ 0x8047e54 (0xeae-0xe54) func_47e54
af+ 0x8047eb4 (0x811a-0x7eb4) func_47eb4 
af+ 0x804811a (0x23A-0x11A) RTCAndTimerIRQ_Sub2
af+ 0x804823a (0x2C4-0x23A) func_4823a
af+ 0x80482c4 (0x312-0x2C4) func_482c4
af+ 0x8048312 (0x36a-0x312) func_48312
af+ 0x804838c (0x3c0-0x38c) func_4838c
af+ 0x80483c0 (0x41e-0x3c0) func_483c0
af+ 0x804841e (0x45c-0x41e) func_4841e
af+ 0x804845c (0x470-0x45c) func_4845c
af+ 0x8048470 (0x47E-0x470) gfx_set_i16_in_GfxInfoPlus0x2C
af+ 0x8048484 (0x492-0x484) gfx_set_u8_in_GfxInfoPlus0x16
af+ 0x8048498 (0x49c-0x498) func_48498
af+ 0x804849c (0x4a0-0x49c) return_0x80
af+ 0x80484a0 (0x4a6-0x4a0) return_0x10000
af+ 0x80484a8 (0x4d6-0x4a8) func_484a8
af+ 0x80484d6 (0x4f0-0x4d6) func_484d6
af+ 0x80484f0 (0x50a-0x4f0) func_484f0
af+ 0x804850a (0x51e-0x50a) func_4850a
af+ 0x804851e (0x55e-0x51e) func_4851e
af+ 0x804855c (0x654-0x55c) func_4855c
af+ 0x8048654 (0x6be-0x654) func_48654
af+ 0x80486be (0x70c-0x6be) func_486be
af+ 0x804870c (0x832-0x70c) func_4870c
af+ 0x8048832 (0x8b6-0x832) func_48832
af+ 0x80488b6 (0x8c4-0x8b6) func_488b6
af+ 0x80488dc (0x902-0x8dc) func_488dc
af+ 0x8048908 (0x930-0x908) func_48908
af+ 0x8048934 (0x98C-0x934) func_48934
af+ 0x8048990 (0x9c4-0x990) func_48990
af+ 0x80489c8 (0x9fc-0x9c8) func_489c8

af+ 0x80489fc (0xa04-0x9fc) gfx_jmptbl_entry0
af+ 0x8048a04 (0xa0c-0xa04) gfx_jmptbl_entry1
af+ 0x8048a0c (0xa14-0xa0c) gfx_jmptbl_entry2
af+ 0x8048a14 (0xA26-0xA14) gfx_48a14
CCa 0x8048a14 also called via BLX R1 from gfx_32ca4
CCa 0x8048a16 [in] R0 = gfx_info+4 ?
af+ 0x8048a28 (0xA30-0xA28) gfx_48a28
af+ 0x8048a34 (0xa36-0xa34) gfx_48a34_nop
af+ 0x8048a36 (0xa42-0xa36) gfx_48a36
af+ 0x8048a42 (0xa4e-0xa36) gfx_48a42

af+ 0x8048a84 (0xa92-0xa84) func_48a84
af+ 0x8048a92 (0xab8-0xa92) func_48a92
af+ 0x8048ab8 (0xade-0xab8) func_48ab8
af+ 0x8048ade (0xb98-0xade) func_48ade
af+ 0x8048b98 (0xcca-0xb98) func_48b98
af+ 0x8048cca (0xdb6-0xcca) func_48cca
af+ 0x8048e08 (0xe10-0xe08) func_48e08
af+ 0x8048e10 (0xe26-0xe10) func_48e10
af+ 0x8048e26 (0xe34-0xe26) func_48e26_uses_io_PWR
af+ 0x8048f28 (0xf32-0xf28) func_48f28
af+ 0x8048f32 (0xf70-0xf32) func_48f32_uses_io_RTC
af+ 0x8048f70 (0xf92-0xf70) func_48f70
af+ 0x8048f92 (0x9008-0x8f92) func_48f92
af+ 0x8049048 (0x050-0x048) func_49048
af+ 0x8049050 (0x058-0x050) func_49050
af+ 0x8049058 (0x060-0x058) func_49058
af+ 0x8049060 (0x074-0x060) func_49060
af+ 0x8049074 (0x09a-0x074) func_49074
af+ 0x804909a (0x0c0-0x09a) func_4909a
af+ 0x80490c0 (0x0e6-0x0c0) func_490c0
af+ 0x80490e6 (0x10c-0x0e6) func_490e6
af+ 0x804910c (0x114-0x10c) func_4910c
af+ 0x8049114 (0x122-0x114) func_49114
af+ 0x8049122 (0x130-0x122) func_49122
af+ 0x8049130 (0x138-0x130) func_49130
af+ 0x8049138 (0x140-0x138) func_49138
af+ 0x8049140 (0x14e-0x140) func_49140
af+ 0x804914e (0x15c-0x14e) func_4914e
af+ 0x804915c (0x428-0x15c) func_4915c
af+ 0x8049428 (0x66A-0x428) DMA1_Stream5_Sub
af+ 0x804966a (0x756-0x66A) DMA1_Stream2_Sub
af+ 0x8049756 (0x7D2-0x756) SPI3_Handler
CCa 0x804975C [0x20004A48] = 0x40003C00 = SPI3/I2S3
CCa 0x8049772 [0x20004ABC] = 0x04008000 = bitmask
CCa 0x8049776 [0x20004a54] = 0x40020000 = GPIOA
CCa 0x804977e 'WAITING in an interrupt handler ?'
CCa 0x8049798 [0x20004a4c] = 0x40004000 = I2S3ext
CCa 0x80497b2 [0x20004a54] = 0x40020000 = GPIOA
af+ 0x80497d2 (0x810-0x7d2) func_497d2
af+ 0x8049810 (0x970-0x810) func_49810
af+ 0x8049970 (0x97a-0x970) func_49970
af+ 0x804997a (0x988-0x97a) func_4997a
af+ 0x8049988 (0x9a4-0x988) func_49988
af+ 0x80499a4 (0x9c0-0x9a4) func_499a4
af+ 0x80499c0 (0x9dc-0x9c0) func_499c0
af+ 0x80499dc (0x9e2-0x9dc) func_499dc
af+ 0x80499e2 (0xb30-0x9e2) func_499e2
af+ 0x8049b30 (0xb40-0xb30) func_49b30
af+ 0x8049b40 (0xb50-0xb40) func_49b40
af+ 0x8049b50 (0xb68-0xb50) func_49b50
af+ 0x8049b68 (0xb82-0xb68) func_49b68
af+ 0x8049b82 (0xba8-0xb82) func_49b82
af+ 0x8049ba8 (0xbbe-0xba8) func_49ba8_Creates_Sema
af+ 0x8049bbe (0xc04-0xbbe) func_49bbe_Uses_Sema
af+ 0x8049c04 (0xc4a-0xc04) func_49c04_Uses_Sema
CCa 0x8049c4a not code
af+ 0x8049ca8 (0xd5e-0xca8) func_49ca8 # directly before TIM2_IRQ
af+ 0x8049e00 (0xe10-0xe00) func_49e00 # directly after TIM2_IRQ
af+ 0x8049e14 798 Start_2_more_tasks__init_vocoder_tasks__Q
af+ 0x8049134 (0xA88E-0x9134) long_AMBE_something
af+ 0x804a88e (0x9c8-0x88e) ambe_4a88e_calls_encode
af+ 0x804a9f8 (0xa5e-0x9f8) ambe_4a9f8
af+ 0x804aa78 (0xb34-0xa78) ambe_4aa78


CCa 0x804c74c md380_menu_edit_buf
CCa 0x804c76e md380_menu_edit_buf

af+ 0x804ec66 298 md380_f_4102
CCa 0x804ee2c md380_menu_0x200011e4

af+ 0x804ed90 (0xdd0-0xd90) something_polling_kb_keypressed
af+ 0x804edd0 2 dummy_4edd0
af+ 0x804edd2 (0xe20-0xdd2) keypress_time_related_1

af+ 0x804bab8 (0xab8-0xab8) func_4bab8
af+ 0x804bd0c (0xd0c-0xd0c) func_4bd0c
af+ 0x804c384 (0x384-0x384) func_4c384
af+ 0x804cd82 (0xd82-0xd82) func_4cd82
af+ 0x804d698 (0x698-0x698) func_4d698
af+ 0x804d6b2 (0x6b2-0x6b2) func_4d6b2
af+ 0x804ee20 (0xe20-0xe20) func_4ee20

af+ 0x804f026 (0x070-0x026) something_setting_keypress_lower_button

af+ 0x804f070 (0x074-0x070) func_4f070
af+ 0x804f24e (0x29c-0x24e) more_setting_keypress_lower_button
af+ 0x804f29c (0x2A0-0x29c) func_4f29c
af+ 0x804f482 (0x4d0-0x482) something_using_menu_depth
af+ 0x804f4d0 (0x686-0x4d0) func_4f4d0
af+ 0x804f686 (0x688-0x686) dummy_4f686
af+ 0x804f688 (0x68a-0x688) dummy_4f688
af+ 0x804f68a (0x6de-0x68a) func_4f68a_polls_EXT_PTT
CCa 0x804f692 poll PE12 = 'EXT_PTT' ..
CCa 0x804f69e .. 3 times for debouncing ?
af+ 0x804f6de (0x7ce-0x6de) func_4f6de
af+ 0x804F7DC (0x8DE-0x7DC) kb_handler_sub1
CCa 0x804F7DE bitmask for PD6 = LCD_ChipSelect ?!
CCa 0x804F7E0 R2 bug, literal = 0x40020C00 = io_GPIOD
CCa 0x804F7E8 bail out if LCD_CS is LOW (don't poll KB during LCD access) ?
CCa 0x804F7EA return ONE
CCa 0x804F804 R2 bug, literal = 0x40020000 = io_GPIOA
CCa 0x804F80E R2 bug, literal = 0x40020C00 = io_GPIOD
CCa 0x804F81C elende Bitfummelei, vermutlich Tastaturspalte oder -Zeile
CCa 0x804F836 R2 bug ? literal = [804fbf4] = 0x2001e7ba = kb_row_col_pressed
CCa 0x804F840 R2 bug ? literal = [804fbf8] = 0x2001e7c0 = kbscan_matrix_temp
CCa 0x804f844 modify MODER (switch in/output) ? 
CCa 0x804F846 R2 bug ? literal = [804fbec] = 0x2001e88a = kb_poll_temp
CCa 0x804F84E R2 bug ? literal = [804fbec] = 0x2001e88a = kb_poll_temp
CCa 0x804F856 return ZERO
CCa 0x804F860 R2 bug ? literal = [804fbe8] = 0x40020C00 = io_GPIOD
CCa 0x804F86A R2 bug ? literal = [804fbfc] = 0x40021000 = io_GPIOE
CCa 0x804f892 R2 bug ? literal = [804fbf4] = 0x2001e7ba = kb_row_col_pressed 
CCa 0x804f89c R2 bug ? literal = [804fbf8] = 0x2001e7c0 = kbscan_matrix_temp
CCa 0x804f8a4 R2 bug ? literal = [804fbf8] = 0x2001e7c0 = kbscan_matrix_temp
CCa 0x804f8aa R2 bug ? literal = [804fbf8] = 0x2001e7c0 = kbscan_matrix_temp
CCa 0x804f8b6 R2 bug ? literal = [804fbf8] = 0x2001e7c0 = kbscan_matrix_temp
CCa 0x804f8bc R2 bug ? literal = [804fbf4] = 0x2001e7ba = kb_row_col_pressed 
CCa 0x804f8c0 R2 bug ? literal = [804fbf8] = 0x2001e7c0 = kbscan_matrix_temp
CCa 0x804f8c8 R2 bug ? literal = [804fbec] = 0x2001e88a = kb_poll_temp
af+ 0x804f8e4 (0x914-0x8e4) func_4f8e4
af+ 0x804f94c (0xfbb2-0xf94c) kb_handler
CCa 0x804fa34 definite keydown
CCa 0x804fa1e jump if b0 not set, reset debounce
CCa 0x804fa30 not debounced yet, jump
CCa 0x804fa80 return from kb_handler but not end of function
CCa 0x804fa4e jump if long keypress count is reached
af+ 0x804fc24 (0xc26-0xc24) func_4fc24_dummy
af+ 0x804fc30 (0xc32-0xc30) func_4fc30_dummy
af+ 0x804fc34 (0xd04-0xc34) Read_Channel_Switch_maybe
CCa 0x804fc3e poll PE14 = encoder bit 0 ..
CCa 0x804fc4a .. 3 times for debouncing ?
CCa 0x804fc6e poll PE15 = encoder bit 1 ..
CCa 0x804fc9e poll PB10 = encoder bit 2 ..
CCa 0x804fc9e poll PB11 = encoder bit 3 ..
af+ 0x804fc32 2 dummy_4fc32
af+ 0x804fc2e 2 dummy_4fc2e
af+ 0x804fc2e 2 dummy_4fc2e
af+ 0x804fc26 2 dummy_4fc26
af+ 0x804fc28 2 dummy_4fc28
af+ 0x804fc2a 2 dummy_4fc2a
af+ 0x804fc2c 2 dummy_4fc2c
af+ 0x804fd04 (0xd8c-0xd04) CallsReadChannelSwitch
af+ 0x804fd8c (0xdb0-0xd8c) Something_using_Channel_Number
af+ 0x804fddc (0xdE0-0xddc) func_4fddc
af+ 0x804fde4 (0xde8-0xde4) func_4fde4
af+ 0x804fdec (0xdf4-0xdec) func_4fdec
af+ 0x804fdf4 (0xdfe-0xdf4) FeedTheWatchdog
af+ 0x804fdfe (0xe08-0xdfe) StartTheWatchdog
af+ 0x804fe14 (0x51b88-0x4fe14) func_4fe14_monster_accessing_C5000

af+ 0x8051b8c (0xc08-0xb8c) func_51b8c
af+ 0x8051c58 (0xc6a-0xc58) func_51c58
af+ 0x8051c6a (0xd00-0xc6a) func_51c6a
af+ 0x8051d08 (0xd0a-0xd08) dummy_51d08 # called from init_more_and_start_watchdog
af+ 0x8051d0c (0xd16-0xd0c) func_51d0c
af+ 0x8051d16 (0xd7e-0xd16) func_51d16
af+ 0x8051d7e (0xd8A-0xd7E) func_51d7e
af+ 0x8051da8 (0xe30-0xda8) func_51da8_uses_EXTI_RTSR
af+ 0x8051e30 (0xe42-0xe30) func_51e30
af+ 0x8051e42 36 CalledFromPinChangeIRQ # called from EXTI3 + EXTI2 (pin-change) interrupt handler
af+ 0x8051e66 6 ClearEXTIPendingBits_R0
af+ 0x8051e80 (0xed0-0xe80) func_51e80
af+ 0x8051ed4 (0xf22-0xed4) kbscan_set_LCD_data_LOW
CCa 0x8051ed6 fill out a GPIO_InitTypeDef for GPIO_Init..
CCa 0x8051ed8 see stm32f4xx_gpio.c
CCa 0x8051eda [sp+5] GPIO_Speed: 2 = high speed
CCa 0x8051ee0 [sp+6] GPIO_OType: 0 = push/pull
CCa 0x8051ee6 [sp+4] GPIO_Mode : 1 = general purpose OUTPUT
CCa 0x8051eec [sp+7] GPIO_PuPd : 0 = no pull-up/down
CCa 0x8051ef4 [sp+0] pins to be configured: PD15,PD14,PD1,PD0
CCa 0x8051f02 [sp+0] pins to be configured: PE10,PE9,PE8,PE7
CCa 0x8051f08 the above pins are "keyboard matrix drivers" now

af+ 0x8051f22 (0x1fac-0x1f22) ConfigureLCDPort
CCa 0x8051f24 fill out a GPIO_InitTypeDef for GPIO_Init..
CCa 0x8051f28 GPIO_Speed: 3 = very high speed
CCa 0x8051f2e GPIO_Mode : 2 = Alternate Function (no GPIO)
CCa 0x8051f34 GPIO_OType: 0 = push/pull
CCa 0x8051f3A GPIO_PuPd : 0 = No pull-up, no pull-down
CCa 0x8051f3e pins to be configured: PD15,14,1,0
CCa 0x8051f42 GPIO_Pins (1st struct member)
CCa 0x8051f50 similar for PE10,PE9,PE8,PE7 (LCD_Data:FSMC)
CCa 0x8051f5a R2=AF number, use PD14 as FSMC_D0 (LCD_D0)
CCa 0x8051f5c R1=pin number for GPIO_PinAFConfig
CCa 0x8051f66 configure PD15 as FSMC_D1 (LCD_D1)
CCa 0x8051f70 configure PD0 as FSMC_D2 (LCD_D2)
CCa 0x8051f7a configure PD1 as FSMC_D3 (LCD_D3)
CCa 0x8051f84 configure PE7 as FSMC_D4 (LCD_D4)
CCa 0x8051f8e configure PE8 as FSMC_D5 (LCD_D5)
CCa 0x8051f98 configure PE9 as FSMC_D6 (LCD_D6)
CCa 0x8051fa2 configure PE10 as FSMC_D7 (LCD_D7)

af+ 0x8051fac (0xfe6-0xfac) kb_scan_matrix_3
CCa 0x8051fae fill out a GPIO_InitTypeDef for GPIO_Init..
CCa 0x8051fb2 [sp+5] GPIO_Speed: 2 = high speed
CCa 0x8051fb8 [sp+6] GPIO_OType: 0 (irrelevant for inputs)
CCa 0x8051fbe [sp+4] GPIO_Mode : 0 = general purpose INPUT
CCa 0x8051fc4 [sp+7] GPIO_PuPd : 1 = pull-up resistor
CCa 0x8051fcc [sp+0] pins to be configured: PD15,PD14,PD1,PD0
CCa 0x8051fda [sp+0] pins to be configured: PE10,PE9,PE8,PE7
CCa 0x8051fe4 the above pins are "keyboard inputs" now

af+ 0x8051fe6 (0x201c-0x1fe6) kbscan_cfg_K1K2K3_as_inputs_with_pull_up
CCa 0x8051fe8 fill out a GPIO_InitTypeDef for GPIO_Init..
CCa 0x8051fec [sp+5] GPIO_Speed: 2 = high speed
CCa 0x8051ff2 [sp+6] GPIO_OType: 0 (irrelevant for inputs)
CCa 0x8051ff8 [sp+4] GPIO_Mode : 0 = general purpose input
CCa 0x8051ffe [sp+7] GPIO_PuPd : 1 = pull-up resistor
CCa 0x8052004 [sp+0] pins to be configured: PD3="K3", PD2="K2"
CCa 0x8052010 [sp+0] pins to be configured: PA6="K1"
CCa 0x805201a the above pins are "keyboard inputs" now

af+ 0x805201c (0x206a-0x201c) kb_scan_matrix_4
CCa 0x805201e fill out a GPIO_InitTypeDef for GPIO_Init..
CCa 0x8052022 [sp+5] GPIO_Speed: 2 = high speed
CCa 0x8052028 [sp+6] GPIO_OType: 0 = push/pull
CCa 0x805202e [sp+4] GPIO_Mode : 1 = general purpose OUTPUT
CCa 0x8052034 [sp+7] GPIO_PuPd : 0 = no pull-up/down
CCa 0x8052038 [sp+0] pins to be configured: PD3,PD2="K3","K2"
CCa 0x8052046 [sp+0] pins to be configured: PA6="K1"
CCa 0x805204c the above pins are "keyboard matrix drivers" now

af+ 0x8052078 (0x158-0x078) func_52078
af+ 0x8052158 (0x18c-0x158) func_52158
af+ 0x8052194 (0x1aa-0x194) func_52194
af+ 0x80521c8 (0x20a-0x1c8) func_521c8
af+ 0x805220e (0x282-0x20e) func_5220e
af+ 0x8052284 (0x2b6-0x284) func_52284
af+ 0x80522b6 (0x2c8-0x2b6) clear_16_bytes_from_R0
af+ 0x80522c8 (0x2f4-0x2c8) func_522c8
af+ 0x80522f4 (0x310-0x2F4) TimerIRQ_Sub7_writes_DAC # accesses the DAC-registers
af+ 0x8052310 (0x32C-0x310) SomethingElseWritingDAC
af+ 0x8052330 (0x352-0x330) func_52330
af+ 0x80523a8 (0x3c8-0x3a8) func_523a8
af+ 0x80523c8 (0x3d8-0x3c8) func_523c8
af+ 0x80523d8 (0x3fa-0x3d8) func_523d8
af+ 0x80523fa (0x42c-0x3fa) func_523fa
af+ 0x805242c (0x45c-0x42c) func_5242c
af+ 0x805245c (0x4cc-0x45c) func_5245c
af+ 0x80524cc (0x4e2-0x4cc) func_524cc
af+ 0x80524e2 (0x58c-0x4e2) func_524e2
af+ 0x805258c (0x596-0x58c) func_5258c
af+ 0x8052596 (0x5f0-0x596) func_52596
af+ 0x80525f4 (0x61c-0x5f4) func_525f4
af+ 0x805266c (0x672-0x66c) func_5266c
af+ 0x8052672 (0x678-0x672) func_52672
af+ 0x805267c (0x766-0x67c) func_5267c
af+ 0x8052774 (0x790-0x774) func_52774
af+ 0x8052790 (0x7ac-0x790) func_52790
af+ 0x80527ac (0x7c8-0x7ac) func_527ac
af+ 0x80527c8 (0x7de-0x7c8) func_527c8
af+ 0x80527de (0x7e4-0x7de) func_527de
af+ 0x80527e4 (0x7ea-0x7e4) func_527e4
af+ 0x80527ea (0x81e-0x7ea) func_527ea
af+ 0x805281e (0x860-0x81e) func_5281e
af+ 0x8052860 (0x934-0x860) func_52860
af+ 0x8052940 (0x9a8-0x940) func_52940
af+ 0x80529a8 (0x9f4-0x9a8) func_529a8
af+ 0x80529f4 (0xa62-0x9f4) func_529f4
af+ 0x8052a62 (0xaa0-0xa62) func_52a62
af+ 0x8052aa0 (0xaf4-0xaa0) func_52aa0 # strange stack frame, possibly no code at all
af+ 0x8052d5e (0xdfe-0xd5e) func_52d5e
af+ 0x8052dfe (0x3022-0x2dfe) func_52dfe
af+ 0x8053030 (0x096-0x030) func_53030
af+ 0x80530a4 (0x0a6-0x0a4) func_530a4_endless_loop
af+ 0x80530a8 (0x1c6-0x0a8) func_530a8 
af+ 0x80531d8 124 ambe_encode_thing__size_not_correct
af+ 0x8053680 140 ambe_decode_wav

af+ 0x8052c94 (0xd5e-0xc94) func_52c94
af+ 0x8053268 (0x296-0x268) func_53268
af+ 0x8053298 (0x2a8-0x298) func_53298
af+ 0x80532a8 (0x302-0x2a8) func_532a8
af+ 0x805332c (0x346-0x32c) func_5332c
af+ 0x8053574 (0x58a-0x574) func_53574
af+ 0x8053590 (0x5a8-0x590) func_53590
af+ 0x8053720 (0x72e-0x720) func_53720
af+ 0x8053730 (0x75a-0x730) func_53730
af+ 0x805375c (0x76e-0x75c) func_5375c
af+ 0x8053778 (0x7e8-0x778) func_53778
af+ 0x80537ec (0x88c-0x7ec) func_537ec
af+ 0x80538f0 (0x978-0x8f0) func_538f0
af+ 0x8053978 (0x9f0-0x978) func_53978
af+ 0x80539f0 (0xa72-0x9f0) func_539f0
af+ 0x8053a74 (0xa88-0xa74) func_53a74
af+ 0x8053a88 (0xa96-0xa88) func_53a88
af+ 0x8053a98 (0xb78-0xa98) func_53a98
af+ 0x8053b7c (0xbac-0xb7c) func_53b7c
af+ 0x8053bac (0xbf6-0xbac) func_53bac
af+ 0x8053c20 (0xd24-0xc20) func_53c20
af+ 0x8054110 (0x14a-0x110) func_54110
af+ 0x805414c (0x188-0x14c) func_5414c
af+ 0x8054188 (0x1ae-0x188) func_54188
af+ 0x80541ae (0x290-0x1ae) func_541ae
af+ 0x8054290 (0x2d4-0x290) func_54290 
af+ 0x80542d8 (0x308-0x2d8) func_542d8
af+ 0x8054308 (0x324-0x308) func_54308
af+ 0x8054324 (0x4c6-0x324) func_54324_lots_of_arithmetics
af+ 0x80544c8 (0x70e-0x4c8) func_544c8_even_more_arithmetics
af+ 0x8054710 (0x744-0x710) func_54710
af+ 0x80547a0 (0x838-0x7a0) func_547a0
af+ 0x8054850 (0x88a-0x850) func_54850
af+ 0x8054f52 (0x505c-0x4f52) func_54f52_floating_point_stuff
af+ 0x805505c (0x100-0x05c) func_5505c_more_floating_point
af+ 0x8055100 68 usb_setcallbacks
af+ 0x8055144 (0x148-0x144) func_55144_return_zero
af+ 0x8055148 (0x19a-0x148) func_55148
af+ 0x805519a (0x22e-0x19a) func_5519a
af+ 0x805522e (0x2fa-0x22e) func_5522e
af+ 0x80552fa (0x306-0x2fa) func_552fa
af+ 0x805530c (0x33c-0x30c) func_5530c
af+ 0x805533c (0x35a-0x33c) func_5533c
af+ 0x805535a (0x376-0x35a) func_5535a
af+ 0x8055376 (0x38e-0x376) func_55376
af+ 0x805538e (0x3aa-0x38e) func_5538e
af+ 0x80553aa (0x3ba-0x3aa) func_553aa
af+ 0x80553ba (0x3c8-0x3ba) func_553ba
af+ 0x80553c8 (0x3d6-0x3c8) func_553c8
af+ 0x80553dc (0x3fa-0x3dc) func_553dc_gfx
af+ 0x8055408 (0x424-0x408) func_55408_gfx
af+ 0x8055428 (0x42a-0x428) func_55428_dummy
af+ 0x8055706 (0x9b0-0x706) func_55706
af+ 0x80559c8 (0x9e6-0x9c8) func_559c8
af+ 0x8055a2c (0xa92-0xa2c) func_55a2c
af+ 0x8055a94 (0xad0-0xa94) ambe_55a94
af+ 0x8055ad8 (0xb9e-0xad8) func_55ad8
af+ 0x8055ba0 (0xbee-0xba0) func_55ba0
af+ 0x8055bf0 (0xc6c-0xbf0) func_55bf0
af+ 0x8055c78 (0xcc6-0xc78) func_55c78
af+ 0x8055cc8 (0xd18-0xcc8) func_55cc8
af+ 0x8055d18 (0xda6-0xd18) func_55d18
af+ 0x8055dac (0xdea-0xdac) func_55dac
af+ 0x8055df0 (0xe26-0xdf0) func_55df0_unknown_end
af+ 0x8056b4c (0xf3a-0xb4c) func_56b4c

af+ 0x805709c (0x0bc-0x09c) func_5709c
af+ 0x805715c (0x2d2-0x15c) func_5715c
af+ 0x80573ac (0x3b6-0x3ac) func_573ac
af+ 0x80573b6 (0x410-0x3b6) func_573b6
af+ 0x805742c (0x4b2-0x42c) func_5742c
af+ 0x80574b4 (0x4ba-0x4b4) func_574b4
af+ 0x80574bc (0x4c2-0x4bc) func_574bc
af+ 0x80574cc (0x53c-0x4cc) func_574cc
af+ 0x805753c (0x638-0x53c) func_5753c
af+ 0x805763c (0x678-0x63c) func_5763c
af+ 0x805767c (0x69e-0x67c) func_5767c
af+ 0x8057850 (0x86a-0x850) func_57850
af+ 0x80579cc (0x9ce-0x9cc) func_579cc
af+ 0x80579ce (0xa56-0x9ce) func_579ce
af+ 0x8057a5c (0xa8c-0xa5c) func_57a5c
af+ 0x8057a8c (0xacc-0xa8c) func_57a8c
af+ 0x8057ad0 (0xba0-0xad0) func_57ad0
af+ 0x8057ba8 (0xd9a-0xba8) func_57ba8
af+ 0x8057dac (0xdd8-0xdac) func_57dac
af+ 0x8057e04 (0xe84-0xe04) func_57e04
af+ 0x8057e8c (0xece-0xe8c) func_57e8c
af+ 0x8057f10 (0xf36-0xf10) func_57f10
af+ 0x8057f38 (0xf5e-0xf38) func_57f38
af+ 0x8057f62 (0xf90-0xf62) func_57f62

af+ 0x8058018 (0x02c-0x018) func_58018
af+ 0x8058094 (0x0d2-0x094) func_58094
af+ 0x80580d8 (0x110-0x0d8) func_580d8
af+ 0x8058110 (0x26a-0x110) ambe_58110
af+ 0x8058554 (0x628-0x554) ambe_58554
af+ 0x80587f4 (0x832-0x7f4) func_587f4
af+ 0x8058880 (0x8be-0x880) func_58880
af+ 0x8058940 (0x980-0x940) func_58940
af+ 0x8058980 (0x99a-0x980) func_58980
af+ 0x8058a00 (0xa1a-0xa00) func_58a00
af+ 0x8058b00 (0xb78-0xb00) func_58b00
af+ 0x8058c00 (0xc80-0xc00) func_58c00
af+ 0x8058c80 (0xcc0-0xc80) func_58c80
af+ 0x8058cc0 (0xcc8-0xcc0) func_58cc0
af+ 0x8058d80 (0xdb6-0xd80) func_58d80
af+ 0x8058dc0 (0xe34-0xdc0) func_58dc0

af+ 0x8059080 (0x0b2-0x080) func_59080



af+ 0x80591a0 (0x1bc-0x1a0) func_591a0
af+ 0x80591bc (0x224-0x1bc) func_591bc
af+ 0x8059228 (0x252-0x228) func_59228
af+ 0x8059252 (0x268-0x252) func_59252
af+ 0x8059268 (0x276-0x268) func_59268
af+ 0x8059276 (0x30c-0x276) func_59276
af+ 0x805930c (0x366-0x30c) func_5930c
af+ 0x8059366 (0x3ac-0x366) func_59366
af+ 0x80593ac (0x3ea-0x3ac) func_593ac
af+ 0x80593ea (0x430-0x3ea) func_593ea
af+ 0x8059430 (0x476-0x430) func_59430
af+ 0x8059476 (0x48a-0x476) func_59476
af+ 0x805948a (0x4a0-0x48a) func_5948a
af+ 0x80594a0 (0x4b6-0x4a0) func_594a0
af+ 0x80594b8 (0x510-0x4b8) func_594b8
af+ 0x8059510 (0x560-0x510) func_59510
af+ 0x8059560 (0x6c8-0x560) func_59560
af+ 0x80596c8 (0x7f0-0x6c8) func_596c8
af+ 0x80597f0 (0x848-0x7f0) func_597f0
af+ 0x8059848 (0x908-0x848) func_59848
af+ 0x8059908 (0x940-0x908) func_59908
af+ 0x8059940 (0x976-0x940) func_59940
af+ 0x8059976 (0x9FE-0x976) func_59976
af+ 0x8059a14 (0xa48-0xa14) func_59a14
af+ 0x8059a48 (0xa8c-0xa48) func_59a48
af+ 0x8059a8c (0xaa8-0xa8c) func_59a8c
af+ 0x8059aa8 (0xaee-0xaa8) func_59aa8
af+ 0x8059aee (0xb02-0xaee) func_59aee
af+ 0x8059b02 40 usb_send_packet
af+ 0x8059b2a (0xb40-0xb2a) func_59b2a
af+ 0x8059b40 (0xb68-0xb40) func_59b40
af+ 0x8059b68 (0xb7e-0xb68) func_59b68
af+ 0x8059b7e (0xba2-0xb7e) func_59b7e
af+ 0x8059ba2 (0xbc6-0xba2) func_59ba2
af+ 0x8059c00 (0xc2e-0xc00) func_59c00
af+ 0x8059c40 (0xc8e-0xc40) func_59c40
af+ 0x8059cc0 (0xcc8-0xcc0) func_59cc0
af+ 0x8059cc8 (0xcf2-0xcc8) func_59cc8
af+ 0x8059d40 (0xe0c-0xd40) func_59d40
af+ 0x8059ec0 (0xf62-0xec0) func_59ec0

af+ 0x805a080 (0x0d2-0x080) func_5a080
af+ 0x805a0dc (0x190-0x0dc) func_5a0dc
af+ 0x805a190 (0x1b4-0x190) func_5a190
af+ 0x805a1b4 (0x1de-0x1b4) func_5a1b4
#af+ 0x805a1e0 (0x1de-0x1e0) func_5a1e0
af+ 0x805a224 (0x246-0x224) func_5a224
af+ 0x805a260 (0x282-0x260) func_5a260
af+ 0x805a298 (0x2e8-0x298) func_5a298
af+ 0x805a3b8 (0x3de-0x3b8) func_5a3b8
af+ 0x805a418 (0x4b0-0x418) func_5a418
af+ 0x805a4b0 (0x4c4-0x4b0) func_5a4b0
af+ 0x805a4c4 (0x530-0x4c4) func_5a4c4
af+ 0x805a530 (0x570-0x530) func_5a530
af+ 0x805a570 (0x5a4-0x570) func_5a570
af+ 0x805a5d8 (0x652-0x5d8) func_5a5d8

af+ 0x805b6c0 (0x6dc-0x6c0) func_5b6c0
af+ 0x805b6dc (0x794-0x6dc) func_5b6dc
af+ 0x805b794 (0x82c-0x794) func_5b794
af+ 0x805b82c (0x912-0x82c) func_5b82c
af+ 0x805b914 (0x968-0x914) func_5b914
af+ 0x805b968 (0xc38a-0xb968) func_5b968
af+ 0x805c38c (0x3cc-0x38c) func_5c38c
af+ 0x805c3d8 (0x5ce-0x3d8) func_5c3d8
af+ 0x805c62c (0x8d4-0x62c) func_5c62c
af+ 0x805c8d4 (0xcde-0x8d4) func_5c8d4
af+ 0x805cd94 (0xd26e-0xcd94) func_5cd94
af+ 0x805d2d0 (0x336-0x2d0) func_5d2d0
af+ 0x805d378 (0x442-0x378) func_5d378
af+ 0x805d444 (0x486-0x444) func_5d444
af+ 0x805d488 (0x4f8-0x488) func_5d488
af+ 0x805d4f8 (0x578-0x4f8) func_5d4f8
af+ 0x805d578 (0xa0c-0x578) func_5d578
af+ 0x805dc40 (0xcb2-0xc40) func_5dc40
af+ 0x805dcb8 (0xeac-0xcb8) func_5dcb8
af+ 0x805deb0 (0xfc0-0xeb0) func_5deb0
af+ 0x805dfc0 (0xfc4-0xfc0) func_5dfc0
af+ 0x805dfc4 (0xe1ca-0xdfc4) func_5dfc4
af+ 0x805e1d0 (0x1e0-0x1d0) func_5e1d0 >> listing.txt
af+ 0x805e2b8 (0x3e4-0x2b8) func_5e2b8
af+ 0x805e44c (0x460-0x44c) func_5e44c
af+ 0x805e460 (0x510-0x460) func_5e460
af+ 0x805e520 (0x57c-0x520) func_5e520
af+ 0x805e5b2 (0x5d8-0x5b2) func_5e5b2
af+ 0x805e618 (0x62a-0x618) func_5e618
af+ 0x805e62c (0x94a-0x62c) func_5e62c
af+ 0x805ea58 (0xaac-0xa58) func_5ea58
af+ 0x805eaac (0xe24-0xaac) func_5eaac 

af+ 0x805f844 (0x8ba-0x844) func_5f844
af+ 0x805f950 (0x990-0x950) func_5f950
af+ 0x805f994 (0xebc-0x994) func_5f994
af+ 0x805ff60 (0x60056-0x5ff60) func_5ff60
af+ 0x806005c (0x198-0x05c) func_6005c
af+ 0x80601c4 (0x33a-0x1c4) func_601c4
af+ 0x8060374 (0x54a-0x374) func_60374
af+ 0x806054c (0xa9e-0x54c) func_6054c
af+ 0x8060bec (0xcea-0xbec) func_60bec
af+ 0x8060cf4 (0x105e-0x0cf4) func_60cf4
af+ 0x80610f4 (0x100-0x0f4) func_610f4
af+ 0x8061100 (0x120-0x100) func_61100
af+ 0x8061120 (0x182-0x120) func_61120
af+ 0x8061182 (0x1c2-0x182) func_61182
af+ 0x80611c2 (0x1ec-0x1c2) func_611c2
af+ 0x80611ec (0x2c6-0x1ec) func_611ec
af+ 0x80612c6 (0x37c-0x2c6) func_612c6
af+ 0x806137c (0x394-0x37c) func_6137c
af+ 0x8061394 (0x3ae-0x394) func_61394
af+ 0x80613ae (0x3f4-0x3ae) func_613ae
af+ 0x80613f4 (0x432-0x3f4) func_613f4
af+ 0x806143c (0x472-0x43c) func_6143c
af+ 0x8061472 (0x47c-0x472) func_61472
af+ 0x806147c (0x490-0x47c) func_6147c
af+ 0x8061490 (0x4a2-0x490) func_61490
af+ 0x80614a2 (0x4b2-0x4a2) func_614a2
af+ 0x80614b2 (0x622-0x4b2) func_614b2
af+ 0x8061622 (0x67a-0x622) func_61622
af+ 0x806167a (0x6a6-0x67a) func_6167a
af+ 0x80616a6 (0x6f0-0x6a6) func_616a6
af+ 0x80616f0 (0x762-0x6f0) func_616f0
af+ 0x8061762 (0x8c8-0x762) func_61762
af+ 0x80618c8 (0x9ee-0x8c8) func_618c8
af+ 0x80619ee (0xa2c-0x9ee) func_619ee
af+ 0x8061a2c (0xa6a-0xa2c) func_61a2c
af+ 0x8061a6a (0xa78-0xa6a) func_61a6a
af+ 0x8061a78 (0xa8c-0xa78) func_61a78
af+ 0x8061a8c (0xa9a-0xa8c) func_61a8c
af+ 0x8061a9a (0xaea-0xa9a) func_61a9a
af+ 0x8061aea 40 WakeUp_Sub1 # called from the wakeup-IRQ-handler, *after* SystemInit()

af+ 0x8061f54 (0x2054-0x1f54) func_61f54
af+ 0x8062054 (0x142-0x054) func_62054
af+ 0x8062148 (0x200-0x148) func_62148
af+ 0x8062204 (0x32e-0x204) func_62204
af+ 0x8062334 (0x378-0x334) func_62334
af+ 0x8062378 (0x3c0-0x378) func_62378
af+ 0x80623c0 (0x416-0x3c0) func_623c0
af+ 0x8062416 (0x490-0x416) func_62416
af+ 0x8062490 (0x4e2-0x490) func_62490
af+ 0x80624e2 (0x50c-0x4e2) func_624e2
af+ 0x806250c (0x536-0x50c) func_6250c
af+ 0x8062536 (0x67c-0x536) func_62536
af+ 0x806267c (0x752-0x67c) func_6267c
af+ 0x806285c (0xa76-0x85c) func_6285c
af+ 0x8062b28 (0xb6e-0xb28) func_62b28
af+ 0x8062d84 (0xe8a-0xd84) func_62d84
af+ 0x8062e94 (0xee6-0xe94) func_62e94
af+ 0x8062ee8 (0xf0a-0xee8) func_62ee8
af+ 0x8062f2c (0xfb4-0xf2c) func_62f2c
af+ 0x8062fb4 (0x3140-0x2fb4) func_62fb4
af+ 0x80631e0 (0x26c-0x1e0) func_631e0
af+ 0x8063274 (0x36e-0x274) func_63274 
af+ 0x80633b0 (0x3be-0x3b0) func_633b0
af+ 0x80633d4 (0x3e2-0x3d4) func_633d4


af+ 0x808eab4 (0xab8-0xab4) func_8eab4
af+ 0x808eb30 190 usb_do_setup
af+ 0x808ebee 1444 usb_dnld_handle
af+ 0x808f192 (0x196-0x192) func_8f192
af+ 0x808f196 (0x21a-0x196) func_8f196
af+ 0x808f21a (0x2a0-0x21a) func_8f21a
af+ 0x808f308 3036 usb_upld_handle
af+ 0x808ff00 (0x90108-0x8ff00) func_8ff00
af+ 0x809010c (0x170-0x10c) func_9010c
af+ 0x8090174 (0x180-0x174) func_90174
af+ 0x8090184 (0x1e6-0x184) func_90184
af+ 0x80901ec (0x24c-0x1ec) func_901ec
af+ 0x8090258 (0x27c-0x258) func_90258
af+ 0x80902d0 (0x2fa-0x2d0) func_902d0
af+ 0x80902fa (0x324-0x2fa) func_902fa
af+ 0x8090324 (0x370-0x324) func_90324
af+ 0x8090370 80 usb_dfu_write
af+ 0x80903c0 54 usb_dfu_read
af+ 0x80903f6 (0x456-0x3f6) func_903f6
af+ 0x8090456 (0x482-0x456) func_90456

# ... lots of data, no code, around 0x8091XXX...

af+ 0x80938c8 210 CalledFromUSB_IRQ
af+ 0x809399a 72 func_9399a # right after USB IRQ subroutine
af+ 0x80939e2 136 func_939e2
af+ 0x8093a6a (0xb5e-0xa6a) func_93a6a
af+ 0x8093b5e (0xc28-0xb5e) func_93b5e
af+ 0x8093c28 (0xc44-0xc28) func_93c28
af+ 0x8093c44 (0xce2-0xc44) func_93c44
af+ 0x8093ce2 (0xd6a-0xce2) func_93ce2
af+ 0x8093d6a (0xe24-0xd6a) func_93d6a
af+ 0x8093e24 (0xe62-0xe24) func_93e24
af+ 0x8093e6e (0xe8a-0xe6e) func_93e6e
af+ 0x8093e8a (0xea6-0xe8a) func_93e8a
#af+ 0x8093eb0 (0xeb2-0xeb0) func_93eb0

af+ 0x8093eb0 (0xeb0-0xeb0) func_93eb0


f DummyForUnusedIRQs 32 @ 0x08093ed0 # called as subroutine from BusFault_Handler and others
af+ (DummyForUnusedIRQs) 32 DummyForUnusedIRQs # required to see the SYMBOL as operand for 'bl'
# Because we're not analysing an EXE or ELF, Radare2 didn't
# automatically find out the size of functions (in bytes).
# So look at the raw disassembly (in r2's "Visual" mode) to determine the sizes.
# Making the size (in "af+") too large made r2 run wild.

af+ 0x809662e 34 usb_serialnumber

f menu_entry_back_1 @ 0x800fc85

f menugreen.Messages.8023858 0 0x8023858
f menugreen.Call_Log.8034274 0 0x8034274
f menugreen.Utilities.80134a0 0 0x80134a0
f menugreen.Radio_Set.8017cbc 0 0x8017cbc
f menugreen.Radio_Inf.80165b8 0 0x80165b8
f menugreen.MD380Tool.809c3b0 0 0x809c3b0
f menugreen.GPS_BeiDo.8016688 0 0x8016688
f menugreen.RX_GPSInf.8013638 0 0x8013638
f menugreen.Talkaroun.8019170 0 0x8019170
f menugreen.Tone_Ale.8019798 0 0x8019798
f menugreen.Power.8019c7c 0 0x8019c7c
f menugreen.Squelch.801a1e0 0 0x801a1e0
f menugreen.Intro_Scr.801a4c6 0 0x801a4c6
f menugreen.Keypad_Lo.801a6c8 0 0x801a6c8
f menugreen.Language.801ab84 0 0x801ab84
f menugreen.LED_Indic.801ad56 0 0x801ad56
f menugreen.VOX.80185d8 0 0x80185d8
f menugreen.SiteRoam1.801ae5c 0 0x801ae5c
f menugreen.Passwd_Lo.801af7c 0 0x801af7c
f menugreen.SiteRoam2.800fc84 0 0x800fc84
f menugreen.Record.8018f04 0 0x8018f04
f menugreen.Clock.8018868 0 0x8018868
f menugreen.GPS.8018248 0 0x8018248

f menugreen.prog.80136c0 0 0x80136c0
f menugreen.prog.rxf.80156a4 0 0x80156a4
f menugreen.prog.rxf.show.8015720 0 0x8015720
f menugreen.prog.rxf.edit.801587a 0 0x801587a

f menugreen.prog.txf.8015b74 0 0x8015b74
f menugreen.prog.txf.show.8015be8 0 0x8015be8
f menugreen.prog.txf.edit.8015d58 0 0x8015d58

f menugreen.prog.Channel_N.8016024 0 0x8016024
f menugreen.prog.Time_Out_.8016320 0 0x8016320
f md380_menu_entry_back 0 0x800fc84
f menugreen.prog.Color_Cod.8015540 0 0x8015540
f menugreen.prog.Repeater_.80153dc 0 0x80153dc
f menugreen.prog.TxContact.8013e78 0 0x8013e78
f menugreen.prog.GroupList.8013fbc 0 0x8013fbc

f menugreen.Talk_Perm.8019998 0 0x8019998
f menugreen.Keypad_To.8019b40 0 0x8019b40

f menugreen.All_Tones.80198b0 0 0x80198b0
f menugreen.All_Tones.TurnOn.8019290 0 0x8019290
f menugreen.All_Tones.TurnOff.80194f4 0 0x80194f4

f menugreen.talkaround.TurnOn.8019290 0 0x8019290
f menugreen.talkaround.TurnOff.80194f4 0 0x80194f4

f menugreen.Mode.801840c 0 0x801840c
f menugreen.CH_Mode.80184e8 0 0x80184e8
f menugreen.MR_Mode.801855c 0 0x801855c

f menugreen.Backlight.8019eb0 0 0x8019eb0
f menugreen.backlight.Always.801a440 0 0x801a440
f menugreen.backlight.5S.801a03e 0 0x801a03e
f menugreen.backlight.10S.801a0c8 0 0x801a0c8
f menugreen.backlight.15S.801a154 0 0x801a154

f menugreen.Repeater_Slot.80153dc 0 0x80153dc
f menugreen.Repeater_Slot_1_2.80154a4 0 0x80154a4

f menugreen.msg.Inbox.80264fc 0 0x80264fc
f menugreen.msg.Write.8023cfe 0 0x8023cfe
f menugreen.msg.Quick_Tex.80239ec 0 0x80239ec
f menugreen.msg.Drafts.8024a80 0 0x8024a80
f menugreen.msg.unk.8023c34 0 0x8023c34
f menugreen.msg.quicktext.8023de2 0 0x8023de2
f menugreen.msg.Send.802409c 0 0x802409c
f menugreen.msg.Save.80249a8 0 0x80249a8
f menugreen.msg.Clear.8023e24 0 0x8023e24
f menugreen.msg.Contacts.802417e 0 0x802417e
f menugreen.msg.Manual_Di.8024220 0 0x8024220
f menugreen.msg.enter_id.802430c 0 0x802430c
f menugreen.msg.enter_id_ok.8024740 0 0x8024740

af+ 0x8024740 608 menugreen.msg.enter_id_ok


f menucall.Contacts 0 0x800c278
f menucall.Scan 0 0x800c2f4
f menucall.Zone 0 0x800c326
f menucall.Messages 0 0x800c358
f menucall.Call_Log 0 0x800c38a
f menucall.Utilities 0 0x800c3bc

f menucall.Radio_Set 0 0x8013528
f menucall.Radio_Inf 0 0x801355c
f menucall.Program_R 0 0x080135a8
f menucall.Program_R_patched 0 0x809d818
f menucall.MD380Tool 0 0x809d834
f menucall.GPS_BeiDo 0 0x80135dc
f menucall.RX_GPSInf 0 0x8013610

f f_4225 0 0x0801fe5c

f call_F_4225_1 0 0x0802db42

f update_scr_16 0 0x0802015e
f update_scr_17 0 0x08020236
f update_scr_18 0 0x08020376
f update_scr_19 0 0x0802046c
f update_scr_20 0 0x08020052
f update_scr_21 0 0x0801fee0
f update_scr_22 0 0x0801ff3e

f update_scr_27 0 0x08020612
f update_scr_28 0 0x080206b2
f update_scr_29 0 0x080206ee
f update_scr_30 0 0x0801ff8e
f update_scr_31 0 0x08020018
f update_scr_32 0 0x080207b4
f update_scr_33 0 0x0802080e

f update_scr_35 0 0x080201bc
f update_scr_36 0 0x0802020e
f update_scr_other 0 0x0802082c

f after_update_scr 0 0x080213aa


f scr_1 0 0x0802daf8

f md380_f_4520 0 0x802c83c
af+ 0x802c83c 2370 md380_f_4520


# Entries in gfx_font_small at offset 0x18 .
#    Doesn't look like executable code .
#    This address is passed via R0 to find_char_in_font_table :
f font_small_table_at_offset_0x18 @ 0x080faa48

f three_font_methods @ 0x080f9284 # referenced from the font-headers
af+ 0x8096858 (0x8a4-0x858) font_method_1_of_3
af+ 0x80968A4 (0x8d6-0x8A4) font_method_2_of_3
af+ 0x80968D6 (0x90e-0x8d6) font_method_3_of_3
af+ 0x809684c (0x858-0x84c) combine_H_and_L_byte
CCa 0x809684c [in] R1 maybe a LOW-byte (?)
CCa 0x809684e [in] R0 maybe a HIGH-byte (?)
CCa 0x8096850 combine R1 (lo) and R0 (hi) into UINT16 ?



# comments for gfx_info, followed by ", 0x18]" :
CCa 0x0803b634 [r0+24] = gfx_info.font_pointer
CCa 0x0803b642 [r2+24] = gfx_info.font_pointer
CCa 0x0803b65c [r0+24] = gfx_info.font_pointer
CCa 0x0801dcd2 [r0+24] = gfx_info.font_pointer
CCa 0x08033ad0 [r0+24] = gfx_info.font_pointer
CCa 0x08033ad8 [r0+24] = gfx_info.font_pointer
CCa 0x08033af8 [r0+24] = gfx_info.font_pointer
CCa 0x08033ad8 [r0+24] = gfx_info.font_pointer
CCa 0x08033afe [r0+24] = gfx_info.font_pointer
CCa 0x08033b6e [r0+24] = gfx_info.font_pointer
CCa 0x0803b6cc [r0+24] = gfx_info.font_pointer
CCa 0x080333f2 [r4+24] = gfx_info.font_pointer
CCa 0x0803b634 [r0+24] = gfx_info.font_pointer
CCa 0x0803b65c [r0+24] = gfx_info.font_pointer

# comments for gfx_info, followed by ", 0x22]" :
CCa 0x0802188a [r0+34] = gfx_info.xpos
CCa 0x08021944 [r3+34] = gfx_info.xpos
CCa 0x080218c0 [r0+34] = gfx_info.xpos
CCa 0x08021916 [r1+34] = gfx_info.xpos
CCa 0x08021924 [r1+34] = gfx_info.xpos
CCa 0x0801dcde [r0+34] = gfx_info.xpos
CCa 0x08037036 [r1+34] = gfx_info.xpos
CCa 0x080370ae [r0+34] = gfx_info.xpos
CCa 0x080370ec [r0+34] = gfx_info.xpos
CCa 0x080370f6 [r0+34] = gfx_info.xpos
CCa 0x08037116 [r1+34] = gfx_info.xpos
CCa 0x08033aee [r0+34] = gfx_info.xpos
CCa 0x08033b3c [r0+34] = gfx_info.xpos
CCa 0x08033b66 [r0+34] = gfx_info.xpos
CCa 0x08033b78 [r1+34] = gfx_info.xpos
CCa 0x08033cc6 [r1+34] = gfx_info.xpos
CCa 0x0803b77c [r0+34] = gfx_info.xpos
CCa 0x0803b79a [r0+34] = gfx_info.xpos
CCa 0x0803b7a4 [r1+34] = gfx_info.xpos

# comments for gfx_info, followed by ", 0x24]" :
CCa 0x08021948 [r1+36] = gfx_info.ypos
CCa 0x080218da [r0+36] = gfx_info.ypos
CCa 0x08021928 [r0+36] = gfx_info.ypos
CCa 0x08021932 [r0+36] = gfx_info.ypos
CCa 0x0801dcca [r0+36] = gfx_info.ypos
CCa 0x08036fea set [r1+36] = gfx_info.ypos
CCa 0x08037052 get [r0+36] = gfx_info.ypos
CCa 0x08037074 set [r0+36] = gfx_info.ypos
CCa 0x0803709e get [r0+36] = gfx_info.ypos
CCa 0x080370c4 [r0+36] = gfx_info.ypos
CCa 0x08037100 [r0+36] = gfx_info.ypos
CCa 0x08037108 set [r1+36] = gfx_info.ypos
CCa 0x08037122 [r0+36] = gfx_info.ypos
CCa 0x08033ae8 [r0+36] = gfx_info.ypos
CCa 0x08033b34 [r0+36] = gfx_info.ypos
CCa 0x08033cbe set [r1+36] = gfx_info.ypos
CCa 0x0803b784 set [r0+36] = gfx_info.ypos
CCa 0x0803b7a8 get [r0+36] = gfx_info.ypos
CCa 0x0803b7b2 set [r1+36] = gfx_info.ypos
CCa 0x08021892 set [r0+36] = gfx_info.ypos

# comments for gfx_info, followed by ", 0x40]" :
CCa 0x0803343e [r0+64] = gfx_info.bmp_w
CCa 0x0803344a [r0+64] = gfx_info.bmp_w
CCa 0x0803ac5a [r0+64] = gfx_info.bmp_w
CCa 0x0803ac76 [r0+64] = gfx_info.bmp_w
CCa 0x0802191e [r1+64] = gfx_info.bmp_w
CCa 0x0803b73a [r1+64] = gfx_info.bmp_w
CCa 0x0803b756 [r1+64] = gfx_info.bmp_w
CCa 0x0803b756 [r1+64] = gfx_info.bmp_w
CCa 0x0803b79e [r1+64] = gfx_info.bmp_w

# comments for gfx_info, followed by ", 0x44]" :
CCa 0x08033444 [r0+68] = gfx_info.bmp_h
CCa 0x08033450 [r0+68] = gfx_info.bmp_h
CCa 0x0803ac68 [r1+68] = gfx_info.bmp_h
CCa 0x0803ac84 [r0+68] = gfx_info.bmp_h
CCa 0x0802192c [r1+68] = gfx_info.bmp_h
CCa 0x0803b748 [r1+68] = gfx_info.bmp_h
CCa 0x0803b764 [r0+68] = gfx_info.bmp_h
CCa 0x0803b7ac [r1+68] = gfx_info.bmp_h

f gfx_drawtext3 @ 0x0802b142
af+ 0x0802b142 148 gfx_drawtext3

af+ 0x08033c96 (0xCA6-0xC96) gfx_get_font_height
CCa 0x08033c98 [r0+0x18] = gfx_info.font_pointer
CCa 0x08033c9a [0x15] = height in pixels ? (gfx_font_small:12, norm:16)
CCa 0x08033ca0 [0x17] = unknown factor (gfx_font_small:1, norm:1)
CCa 0x08033ca2 returns R0 = height in pixels ?
# see 'annotated hexdump' of gfx_font_small in the listing...

f gfx_drawtext9 0 0x0802b0d4
af+ 0x0802b0d4 110 gfx_drawtext9

CCa 0x08037118 check_for_0_term_and_loop

f scr_mode_stable 0 0x08020830


f F_4315 0 0x08025ae4

f promisc_audio_frame @ 0x08040cce
f normal_audio_frame @ 0x08040cc4
f audio_for_me_or_not @ 0x08040c7a
f re_create_event_8 @ 0x08040c02
f event_36 @ 0x08041616
f event_4 @ 0x08041e44

f keypress_max_time_reached @ 0x0804face

f check_for_ptt_switch @ 0x0804ebfc
af+ 0x0804ebfc 106 check_for_ptt_switch

f kb_enter_alpha @ 0x0802e0b8

f get_keycode_from_table @ 0x804f8e4
f get_keycode_from_table_2 @ 0x804f8ea

f store_keycode @ 0x0804fb24

af+ 0x805261c (0x632-0x61c) gfx_jmptbl_entry0_sub
CCa 0x805261c 'Unsigned Bit Field Extract' - real code or data ?
af+ 0x8052632 (0x638-0x632) gfx_jmptbl_entry2_sub
af+ 0x8052638 (0x66c-0x638) gfx_jmptbl_entry1_sub

f dispatch_keyboard_2 @ 0x0802c83c

#####
# GUI

f gui_control @ 0x0802d1b2
af+ 0x0802d1b2 4 gui_control

# GUI
#####


af+ 0x801eb00 1436 handle_keycode_F_4171


# radioevents

f handle_inter_request_deny @ 0x08040690
f handle_inter_sendstart @ 0x080406a2
f handle_inter_sendstop @ 0x080406b4
f handle_inter_lateentry @ 0x080406c6
f handle_inter_recvdata @ 0x0804077a
f handle_inter_recvmessage @ 0x080409ac
f handle_inter_quit @ 0x080409be
f handle_inter_phy @ 0x080409d0

f jump_if_b7_0 @ 0x080406ce

f re_test_for_04 @ 0x08041da8

f re_wait_for_event @ 0x0803c7fc

f re_handle_1 @ 0x0803c85c
f re_handle_2 @ 0x0803ca2c
f re_handle_3 @ 0x0803c8cc
f re_handle_4 @ 0x0803c956
f re_handle_5 @ 0x0803c984
f re_handle_7 @ 0x0803c9fc
f re_handle_8 @ 0x0803ca08
f re_handle_9 @ 0x0803ca14
f re_handle_a @ 0x0803ca20
f re_handle_e @ 0x0803ca3a


f phone_ringing @ 0x0804df0e

# c5000
f c5000_pll_init @ 0x0803f95c
f c5000_strange_init @ 0x0803f982
f c5000_iffreq_init @ 0x0803f9c6

f c5000_handle_0 @ 0x080408a4
f c5000_handle_1 @ 0x080408ba
f c5000_handle_2 @ 0x080408d0
f c5000_handle_3 @ 0x080408e6
f c5000_handle_4 @ 0x08040912
f c5000_handle_5 @ 0x08040914
f c5000_handle_6 @ 0x08040916
f c5000_handle_7 @ 0x0804092c
f c5000_handle_8 @ 0x08040944
f c5000_handle_9 @ 0x0804095c
f c5000_handle_A @ 0x0804098a
f c5000_handle_B_F @ 0x080409a2

f c5000_handle_Voice_LC @ 0x080408ba
f c5000_handle_Terminator_LC @ 0x080408d0
f c5000_handle_CSBK @ 0x080408e6
f c5000_handle_DataHeader @ 0x08040916
f c5000_handle_DataRate1_2 @ 0x0804092c
f c5000_handle_DataRate3_4 @ 0x08040944
f c5000_handle_DataRate1 @ 0x0804098a
f c5000_handle_PI @ 0x080408a4
f c5000_handle_idle @ 0x0804095c

f c5000_init_lowregs @ 0x0803fed4
f c5000_enable_audio @ 0x08040226

f c5000_wr_60_1 @ 0x0803ff16
f c5000_wr_60_2 @ 0x08040230
f c5000_wr_60_3 @ 0x08040382
f c5000_wr_60_4 @ 0x08046b32
f c5000_wr_60_5 @ 0x0805055a



af+ 0x080402f8 218 c5000_some2
af+ 0x08040290 86 c5000_some3

af+ 0x0803ff84 38 c5000_spi0_writereg
af+ 0x0803ffd0 42 c5000_spi0_readreg
af+ 0x0803ffaa 38 c5000_spi0_writereg_1

f c5000_spi0_readreg_maybe @ 0x0803fffa
af+ 0x0803fffa 46 c5000_spi0_readreg_maybe

f c5000_maybe_read_packet @ 0x08040028
af+ 0x08040028 52 c5000_maybe_read_packet

f c5000_read_inter @ 0x08040680
f c5000_read_dll_cc @ 0x080406ec
f c5000_read_dll_datatype @ 0x080407a8

f c5000_dispatch_dll_datatype @ 0x0804087e
f c5000_check_for_lcss_continue @ 0x08040858
f c5000_jump_if_vod @ 0x0804087a

f dmr_pi_dummy @ 0x8040a00

f is_this_the_check_for_group_rx_list @ 0x08040b94

f msg_send_maybe @ 0x08024fb0
af+ 0x08024fb0 212 msg_send_maybe

f msg_send_maybe2 @ 0x08024dbc
af+ 0x08024dbc 166 msg_send_maybe2

f msg_create_menu_item_something @ 0x08024448
af+ 0x08024448 2 msg_create_menu_item_something

af+ 0x08024658 190 msg_sms_post_showack
f msg_sms_post_showack @ 0x08024658

f msg_bdy_prep_to_editbuf @ 0x08024402
f msg_editbuf_to_hdr_prep @ 0x080243d6
f msg_stack_to_hdr_prep_options @ 0x080243b0

af+ 0x803b8d8 (0xc304-0xb8d8) SomeLongDispatcher
CCa 0x803b8f0 entry point or giant endless loop ?
f dispatch_event5_mbox @ 0x0803b8f4
# mbox events; still inside 'SomeLongDispatcher'..
# event5 events
f ev5_1 @ 0x803b958
f ev5_2 @ 0x803b980
f ev5_3 @ 0x803b986
f ev5_4_8 @ 0x803b9a4
f ev5_12 @ 0x803ba14
f ev5_14 @ 0x803bf2a
f ev5_15 @ 0x803ba5e
f ev5_16 @ 0x803bad8
f ev5_17 @ 0x803baec
f ev5_18 @ 0x803bc86
f ev5_19 @ 0x803bd46
f ev5_20 @ 0x803be8e
f ev5_21 @ 0x803b9c2
f ev5_22 @ 0x803b9fa
f ev5_rest @ 0x803bf5a
f task_state_change @ 0x0803c330
f dispatch_event @ 0x0803c39c

af+ 0x803cfb4 (0xd2ec-0xcfb4) CalledFromLongDispatcher
af+ 0x803d2f0 (0x53e-0x2f0) func_3d2f0
af+ 0x803d53e (0x57a-0x53e) func_3d53e
af+ 0x803d57a (0x5a0-0x57a) func_3d57a
af+ 0x803d5a0 (0x5ce-0x5a0) func_3d5a0

af+ 0x803d5e4 (0x76E-0x5E4) SomethingWithGPIOC_and_Backlight_Timer

f msg_process_sms2 @ 0x0803dd8c
af+ 0x0803dd0c 260 msg_process_sms


# msg )))


f msg_f1 @ 0x08024ec4
af+ 0x08024ec4 162 msg_f1
f msg_f2 @ 0x08024f66
af+ 0x08024f66 64 msg_f2

f c5000_master_handler @ 0x08041cfc

#

f c5000_set_local_addr @ 0x0803cae0
af+ 0x0803cae0 84 c5000_set_local_addr

f c5000_set_local_addr2 @ 0x0803cb34
af+ 0x0803cb34 96 c5000_set_local_addr2

f flash_write_50_at_40000 @ 0x08022e76
af+ 0x08022e76 18 flash_write_50_at_40000

f flash_read_50_at_40000 @ 0x08022e64
af+ 0x08022e64 18 flash_read_50_at_40000

f unprogrammed_str @ 0x80cfb78

f ambe_decode_wav @ 0x08053680
f ambe_encode_thing @ 0x080531d8


f md380_RTC_GetDate @ 0x0802b50c

f md380_f_4137 @ 0x0802dfbc
f bp_tone_off @ 0x08030b58
f OS_EXIT_CRITICAL @ 0x08043dec
f usb_dnld_handle @ 0x0808ebee
f dmr_before_squelch @ 0x08040ce6
f usb_do_setup @ 0x0808eb30
f aes_startup_check @ 0x0802256a

af+ 0x080f8510 4 welcomebmp
f welcomebmp @ 0x080f8510
f Start_2_more_tasks__init_vocoder_tasks @ 0x08049e14
f OSTaskNameSet @ 0x0804e64c
f OSSemPend @ 0x0803f754
f md380_f_4102 @ 0x0804ec66
f OS_ENTER_CRITICAL @ 0x08043de4
f usb_serialnumber @ 0x0809662e
f OSSemCreate @ 0x0803f708
af+ 0x080cff30 4 md380_wt_programradio
f md380_wt_programradio @ 0x080cff30
f dmr_call_end @ 0x08041430
f Get_Welcome_Line1_from_spi_flash @ 0x080226c0
f c5000_spi0_readreg @ 0x0803ffd0
af+ 0x080cf780 4 gfx_font_norm
f gfx_font_norm @ 0x080cf780
f OSTimeDly @ 0x08033eb4
f usb_upld_handle @ 0x0808f308
f dmr_call_start @ 0x08040a02
f md380_spiflash_read @ 0x08031476

f md380_spiflash_disable @ 0x08031546
f md380_RTC_GetTime @ 0x0802b3f6
af+ 0x0804b234 4 ambe_unpack
f ambe_unpack @ 0x0804b234
f md380_spiflash_block_erase64k @ 0x080312aa
f c5000_spi0_writereg @ 0x0803ff84
f usb_dfu_write @ 0x08090370
f md380_spiflash_enable @ 0x0803152a
#f Edit_Message_Menu_Entry @ 0x08023ee4
f md380_spi_sendrecv @ 0x080314bc

af+ 0x804b2fe (0x302-0x2fe) func_4b2fe
af+ 0x804b356 (0x35a-0x356) func_4b356
af+ 0x804b9a0 (0x9a4-0x9a0) func_4b9a0
af+ 0x804b9e0 (0x9e4-0x9e0) func_4b9e0


f usb_setcallbacks @ 0x08055100
af+ 0x0809a4c0 4 gfx_font_small
f gfx_font_small @ 0x0809a4c0

f Get_Welcome_Line2_from_spi_flash @ 0x080226d2
f md380_spiflash_wait @ 0x08031508
f md380_spiflash_sektor_erase4k @ 0x08031276
f OSSemPost @ 0x0803f844
f md380_OSMboxPost @ 0x0803119c
f usb_dfu_read @ 0x080903c0
f dmr_handle_data @ 0x0804dd70
f md380_spiflash_write @ 0x0803155e
f md380_spiflash_security_registers_read @ 0x080318b0

f Create_Menu_Entry_RX_QRG_2 @ 0x080157fc
f md380_itow @ 0x08018b28

# Functions called from Reset_Handler.
#  Note the odd addresses in the caller, but the callee (THUMB) is at an even address.
s 0x8094358  # bet this is "SystemInit()", first function called from Reset_Handler
af+ $$ (0x80943aa-$$) SystemInit # af+ <current_address> <size in bytes> <name>
# ex: f SystemInit # with this, the disassembly didn't show SystemInit being called from Reset_Handler !
f SystemInit 2 @ ($$+1) # addr+1, because the CALLER'S dest-addr has the LSBit set for Thumb mode
# (ignore the tilde in the disassembled function..)
s 0x80943aa # subroutine called from SystemInit()..
af+ $$ 202 RCC_Init
f RCC_Init @ ($$)
CCa 0x080943b8 Set RCC_CR bit 16 = HSEON
CCa 0x080943c4 Isolate RCC_CR bit 17 = HSE clock ready ?
CCa 0x080943f8 Read RCC_APB1ENR
CCa 0x080943fa Set bit 24 = PWREN for APB1
CCa 0x08094400 What a waste of code memory. Could have set R1 before.
CCa 0x08094406 PWR_CR bit 14 = voltage regulator control
CCa 0x08094412 Copy RCC clock config register to itself ?
CCa 0x08094434 RCC_CR bit 24 = 'PLL ON'
CCa 0x08094440 Check 'PLL Ready'-bit
CCa 0x0809444a Set FLASH_ACR (waitstates, etc)
CCa 0x08094452 clear RCC_CFGR bits 31+30 to select SYSCLK for MCO2
CCa 0x0809445c select PLL as system clock (?)

af+ 0x8095518 (0x686-0x518) LED_Process # an extra task just to drive two LEDs

# 2nd subroutine, called from Reset_Handler, and never returns:
s 0x80FAFDC  # if 'they' used Keil's ecosystem, this is __main which calls the scatterload-thingy
af+ $$ 12 __main
f __main 12 @ ($$+1) # similar as above, to see the called function name in disassembly
CCa 0x80fafdc 'jumped into' (no call) from Reset_Handler

af+ 0x80F7EB4 (0xeba-0xeb4) read_byte_ptr_R0
af+ 0x80F7EBA (0xec0-0xeba) dummy1_ignore_r0_return_one
af+ 0x80F7EC0 (0xec6-0xec0) dummy2_ignore_r0_return_one
af+ 0x80F7EC6 (0xecc-0xec6) write_R1_to_byte_ptr_R0
af+ 0x80F7ECC (0xee2-0xecc) _main2 # 2nd subroutine called from __main()
af+ 0x80f7ee2 (0xee6-0xee2) Return_ONE # looks like a part of _main2 but CALLED (bl) from there !
af+ 0x80f7ee6 (0xef6-0xee6) _main3

af+ 0x8099A3C 32 _main2_init_sub2
af+ 0x8099F08 34 _main2_init_sub3


af+ 0x8043ed0 (0xFC-0xD0) InitGlobalsAndStartRealTimeKernel

af+ 0x804b534 (0x5ac-0x534) func_4b534
af+ 0x804b5ac (0x62e-0x5ac) func_4b5ac
af+ 0x804b62e (0x6e6-0x62e) func_4b62e
af+ 0x804b6e6 (0x6f4-0x6e6) func_4b6e6_posts_something
af+ 0x804b6f4 (0x728-0x6f4) func_4b6f4
af+ 0x804b728 (0x7D6-0x728) CreateTwoSemasAndTimerTask
af+ 0x804b7d6 (0x810-0x7D6) Create_uCOS_Timer_Task
af+ 0x804b810 (0x87e-0x810) func_4b810
af+ 0x804b87e (0x8c8-0x87e) func_4b87e
af+ 0x804b8c8 (0x96a-0x8c8) func_4b8c8

af+ 0x804b980 (0x990-0x980) gfx__GetFontSizeY # name inspired by uC/GUI .. just guesswork
CCa 0x804b982 [r0+0x18] = gfx_info.font_pointer
CCa 0x804b984 [r0+0x14] = matrix height in pixels (see gfx.h:gfx_font_t)
CCa 0x804b988 [r1+0x18] = gfx_info.font_pointer (why read again?)
CCa 0x804b98a [r1+0x17] may be a 'magnifier' (see gfx.h)
CCa 0x804b98c returns the 'real' height in pixels
af+ 0x804b994 (0x99e-0x994) gfx_4b994
af+ 0x804bac4 (0xae8-0xac4) gfx_4bac4
af+ 0x804bae8 (0xB02-0xAE8) menu_draw_sub_4bae8
af+ 0x804bb04 (0xb26-0xb04) func_4bb04
af+ 0x804bb2c (0xc7e-0xb2c) func_4bb2c
af+ 0x804bc80 (0xc9c-0xC80) func_4bc80
af+ 0x804bc9c (0xCC2-0xC9C) func_4bc9c
af+ 0x804bccc (0xcd2-0xccc) func_4bccc
af+ 0x804bcd8 (0xcf4-0xcd8) func_4bcd8
af+ 0x804bcf4 (0xd0c-0xcf4) func_4bcf4
af+ 0x804bd40 (0xd5e-0xd40) gfx_4bd40
af+ 0x804bd5e (0xd76-0xd5e) gfx_4bd5e
af+ 0x804bd76 (0xdbe-0xd76) gfx_4bd76
af+ 0x804bdbe (0xe14-0xdbe) gfx_4bdbe
af+ 0x804be14 (0xe2e-0xe14) gfx_4be14
af+ 0x804be2e (0xe40-0xe2e) gfx_4be2e
af+ 0x804be40 (0xe74-0xe40) gfx_4be40
af+ 0x804be74 (0xc030-0xbe74) draw_some_bitmap_and_text
af+ 0x804c030 (0x0a8-0x030) func_4c030
af+ 0x804c0a8 (0x0ea-0x0a8) func_4c0a8
af+ 0x804c0ea (0x148-0x0ea) func_4c0ea
af+ 0x804c148 (0x1fa-0x148) func_4c148
af+ 0x804c220 (0x272-0x220) func_4c220
af+ 0x804c278 (0x2c6-0x278) func_4c278
af+ 0x804c2cc (0x2fa-0x2cc) func_4c2cc
af+ 0x804c2fa (0x304-0x2fa) func_4c2fa
af+ 0x804c304 (0x344-0x304) func_4c304
af+ 0x804c344 (0x382-0x344) func_4c344
af+ 0x804c38c (0x3ea-0x38c) func_4c38c
af+ 0x804c3ec (0x446-0x3ec) func_4c3ec
af+ 0x804c446 (0x64e-0x446) func_4c446
af+ 0x804c64e (0x782-0x64e) func_4c64e
af+ 0x804c782 (0x7b6-0x782) func_4c782
af+ 0x804c7b6 (0x858-0x7b6) func_4c7b6
af+ 0x804c858 (0xa3c-0x858) msg_handle_types
f msg_handle_type_21 @ 0x804c888
af+ 0x804ca3c (0xb00-0xa3c) msg_handle_type_11
#f+ ?? msg_handle_type_31
af+ 0x804cb00 (0xc56-0xb00) msg_handle_type_other 
af+ 0x804ccbc (0xd82-0xcbc) func_4ccbc
af+ 0x804cdc6 (0xe2a-0xdc6) func_4cdc6
af+ 0x804ce2c (0xe88-0xe2c) init_Tone_fft_task
af+ 0x804ce88 (0xf06-0xe88) func_4ce88
af+ 0x804cf06 (0xf7e-0xf06) func_4cf06_uses_ADC2_and_TIM3
af+ 0x804cf80 (0xd1b8-0xcf80) func_4cf80
af+ 0x804d1b8 (0x49E-0x1B8) SomethingWithRadioStatus_4d1b8
af+ 0x804d52c (0x578-0x52c) adc_related_4d52c
CCa 0x804d532 [in] R0=ADC base addr, R0+4= ADC_CR1
CCa 0x804d546 R0+8 = ADC control register 2
CCa 0x804d560 R0+0x2c = ADC regular channel seq reg #1
af+ 0x804d578 (0x59a-0x578) adc_related_4d578
af+ 0x804d59a (0x5b4-0x59a) adc_enable_disable
CCa 0x804d5a0 [in] R0=base address of an ADC(!), but sometimes a TIMER (???)
CCa 0x804d5a2 R0+8 = ADC_CR2, bit0 = "enable conversion"
CCa 0x804d5ae funny way to clear bit 0, i.e. "disable conversion"
CCa 0x804cf6e wtf.. address of a TIMER passed in R0 (???)
af+ 0x804d5b4 (0x688-0x5b4) adc_related_4d5b4
CCa 0x804d5b4 [in] R0=ADC base addr
CCa 0x804d5c0 R0+0xC = ADC sample time register #1
CCa 0x804d5e8 R0+0x10 = ADC sample time register #2 
CCa 0x804d60c R0+0x34 = ADC regular channel seq reg #3 
CCa 0x804d638 R0+0x30 = ADC regular channel seq reg #2 
CCa 0x804d65e R0+0x2c = ADC regular channel seq reg #1
# Radare2 had a couple of bugs, for example names beginning with ADC_ didn't work. WTF ???
af+ 0x804d688 (0x692-0x688) adc_StartConv # in D3.032 : 0x8049e9c
af+ 0x804d692 (0x698-0x692) adc_ReadDataRegister
af+ 0x804d6de (0x6f2-0x6de) func_4d6de
af+ 0x804d6f4 (0x908-0x6f4) func_4d6f4
af+ 0x804d908 (0x96a-0x908) func_4d908
af+ 0x804d96a (0x97a-0x96a) func_4d96a
af+ 0x804d97a (0xb0c-0x97a) func_4d97a
af+ 0x804dc0c (0xc84-0xc0c) func_4dc0c_more_bitbang_io
CCa 0x804dc64 clear PC13 = 'B_SHIFT' ?
CCa 0x804dc76 set PE2 = 'DMR_CS' ?
CCa 0x804dc7e clear PE5 = 'DMR_SDI' or 'PLL_DAT' ?
af+ 0x804dc84 (0xF6-0x84) some_bitband_io
CCa 0x804dcba set PE5 = 'DMR_SDI' or 'PLL_DAT' ?
CCa 0x804dcde clear PC13 = 'B_SHIFT' ?
CCa 0x804dce6 test PE3 ??

af+ 0x804dcf6 28 some_bitband_io_range
af+ 0x804dd36 24 some_func_pend
CCa 0x804dd48 clear PE2 = 'DMR_CS' ?
af+ 0x804dd4e 20 some_func_post
CCa 0x804dd54 set PE2 = 'DMR_CS' ?
af+ 0x804dd70 430 dmr_handle_data
af+ 0x804df68 (0xfbe-0xf68) func_4df68
af+ 0x804dfbe (0xe014-0xdfbe) func_4dfbe
af+ 0x804e014 (0x0d4-0x014) func_4e014
af+ 0x804e014 (0x0d4-0x014) func_4e014
af+ 0x804e0e0 (0x102-0x0e0) func_4e0e0
af+ 0x804e102 (0x132-0x102) func_4e102
af+ 0x804e132 (0x13A-0x132) ClearSomeHalfWordInRAM
af+ 0x804e13c (0x144-0x13c) func_4e13c
af+ 0x804e144 (0x14C-0x144) OSIdleTaskHook
af+ 0x804e2e0 (0x2FC-0x2E0) func_4e2e0
af+ 0x804e2fc (0x2fe-0x2fc) func_4e2fc_BX_LR_only
af+ 0x804e2fe (0x300-0x2fe) func_4e2fe_BX_LR_only
af+ 0x804e300 (0x302-0x300) func_4e300_BX_LR_only
af+ 0x804e302 (0x304-0x302) func_4e302_BX_LR_only
af+ 0x804e4cc (0x580-0x4cc) func_4e4cc
af+ 0x804e580 (0x64c-0x580) OSTaskCreateExt
af+ 0x804e64c (0x6a6-0x64c) OSTaskNameSet
af+ 0x804e6b8 (0x70e-0x6b8) func_4e6b8
af+ 0x804e70e (0x728-0x70e) func_4e70e
af+ 0x804e728 (0x768-0x728) func_4e728
af+ 0x804e768 (0xba-0x68) DMA_Stream_Sub1
af+ 0x804e7ba (0xda-0xba) DMA_Stream_Sub2
af+ 0x804e7f4 (0x802-0x7f4) func_4e7f4
af+ 0x804e808 (0x81C-0x808) func_4e808
af+ 0x804e82c (0x956-0x82c) func_4e82c_uses_SPI2_3_DMA_and_I2C
af+ 0x804e9b0 (0x9d0-0x9b0) func_4e9b0
af+ 0x804e9d0 (0x9e2-0x9d0) func_4e9d0
af+ 0x804e9e2 (0xa92-0x9e2) func_4e9e2
af+ 0x804ea92 (0xae4-0xa92) func_4ea92
af+ 0x804eae4 (0xaea-0xae4) func_4eae4
af+ 0x804eaea (0xb24-0xaea) func_4eaea
af+ 0x804eb3c (0xb64-0xb3c) func_4eb3c
f md380_f_4098 @ 0x804eb64
f biglist_pollsubsys_maybe @ 0x804eb64
af+ 0x804eb64 152 biglist_pollsubsys_maybe


af+ 0x80323E6 (0x416-0x3E6) WaitForInterruptInIdle
CCa 0x80323ee don't sleep
CCa 0x8032406 don't sleep ...
CCa 0x8032412 sleep until interrupt to save power


# some strings in Flash, passed to OSTaskCreateExt etc
f s_uCOS2_Start_Task 4 @ 0x80fbda8
f s_uCOS2_Idle_Task 13 @ 0x80f8f54
f s_uCOS2_Tmr_Task 12 @ 0x80f8f64
f s_Call_Process 12 @ 0x80F8F74
f s_FMTx_Process 12 @ 0x80F8F84
f s_Beep_Process 12 @ 0x80F8F94
f s_TimeSlot_Inter 14 @ 0x80F8F84
f s_State_Change 12 @ 0x80F8FB4
f s_DFU_in_HS_mode 14 @ 0x80F8FD4
f s_000000000010B 12 @ 0x80F8FE4
f s_000000000010C 12 @ 0x80F8FF4
f s_DFU_Interface 13 @ 0x80F9004

s 0x804e13a # called from InitGlobalsAndStartRealTimeKernel
af+ $$ (0x13C-0x13A) DoNothing_only_BX_LR
s 0x804e304 # called from InitGlobalsAndStartRealTimeKernel
af+ $$ (0x3E8-0x304) ManyStrangeSimpleMoves
CCa 0x0804e308 maybe just a dummy to suppress linker warnings

af+ 0x8043e98 (0xED0-0xE98) func_43e98 # called from CreateTwoSemasAndTimerTask

s 0x8095810 # endlessly called from 0x80f7ef0 ?
af+ $$ 16 CalledForever
CCa $$ Possibly for 'unexpected return from main()'
f CalledForever 16 @ $$

af+ 0x8044024 (0x66-0x24) func_44024
af+ 0x80443c6 (0x3d8-0x3c6) func_443c6
af+ 0x80443d8 (0x434-0x3d8) func_443d8
af+ 0x8044434 (0x452-0x434) func_44434
af+ 0x8043df2 (0xE0E-0xDF2) func_43df2
CCa 0x8043df6 R0 = 0xE000ED22 = SCB.SysHdlrPrio3, bits 31..16
CCa 0x8043e08 R0 = 0xE000ED04 = SCB.ICSR
af+ 0x8043e0e (0xE16-0xE0E) func_43e0e
CCa 0x8043e0e R0 = 0xE000ED04 = SCB.ICSR
af+ 0x8043e16 (0xE1E-0xE16) func_43e16

af+ 0x8044066 182 SysTick_Sub1
af+ 0x8043efc 148 SysTick_Sub3

af+ 0x804411c 122 func_4411c
af+ 0x8043f90 58 func_43f90
af+ 0x8043fca 90 func_43fca


f gfx_jmptbl 0x30 @ 0x8098280 # table with 12 gfx functions
# From STM32Cube_../Middlewares/ST/STemWin/inc/GUI.h :
#  DrawBitmap,  DrawHLine, DrawVLine,  FillRect,   GetPixelIndex,  SetPixelIndex,
#  XorPixel,    SetOrg,    GetDevFunc, GetDevProp, GetDevData,     GetRect .


af+ 0x8044196 (0x222-0x196) func_44196
af+ 0x8044222 (0x254-0x222) func_44222
af+ 0x8044254 (0x26e-0x254) func_44254
# 8044472..0x8044477 looks like a literal pool. End of another sourcecode module ?
af+ 0x8044478 (0x5b6-0x478) func_44478

af+ 0x804dd12 (0x36-0x12) SPI0_ReadReg_Sub1

af+ 0x804e14c (0x290-0x14c) func_4e14c
af+ 0x804e290 (0x298-0x290) func_4e290
af+ 0x804e298 (0x2a0-0x298) func_4e298
af+ 0x804e2a0 (0x2c4-0x2a0) SysTick_Sub2

af+ 0x8095824 10 func_95824
af+ 0x809582e 10 func_9582e
af+ 0x8095838 20 func_95838



# more stuff seen when "panning around" in r2's Visual mode...
s 0x08094800 # Look at this whatever-it-is in 'V'isual mode / pXA ..
# with 64 bytes per line, it looks like a bitmap graphic
CC Font or pixel graphic with 64 bytes per line
Cd (0x80952D0-0x8094800) # data, no executable code. Exact length unknown.

af+ 0x80D0010 26 FPU_Init # called from __main() [not main()]

s 0x080f81b4 # 'wide' strings, 16 bit where 8 bits per character would be sufficient
f Wide_Strings @ $$
CC Wide strings, 'USB Mode' etc
Cs (0x80f8510-$$) # guesstimated length by address difference

# next : welcomebmp @ 80f8510, already annotated

s 0x080f86a0 # 8-bit strings ..
f ASCII_Strings @ $$
CC ASCII strings, 'uC/OS-II TmrLock' etc
Cs (0x80f86da-$$) # guesstimated length by address difference


#----------------------------------------------------------
# RAM .... sorted by address to spot module dependencies
#----------------------------------------------------------
  # .. from symbols_d13.020 (later merged with others, sorted by address)
f md380_menu_ptr_to_80d032c @ 0x20001704
f address_of_gfx_jumptbl @ 0x200049e4
f mn_editbuffer_poi @ 0x200049fc
f md380_dfu_target_adr @ 0x20004a14
f baseaddr_SPI3_for_SPI3_Handler 4 @ 0x20004a48
f bitmask_GPIOA_for_SPI3_Handler 4 @ 0x20004abc
f baseaddr_GPIOA_for_SPI3_Handler 4 @ 0x20004a54
f md380_menu_depth @ 0x20004acc
f currently_selected_menu_entry @ 0x20004cba # actually the FOCUSED ITEM INDEX (not "confirmed" selection)
f ambe_mystery @ 0x20013594
f ambe_outbuffer0 @ 0x20013f28
f ambe_outbuffer1 @ 0x20013fc8
f ambe_inbuffer @ 0x2001410e

f Stack_for_Start_Task 512 @ 0x20014ab4 # passed to OSTaskCreateExt

f msg_buff_complete @ 0x20018490

f Stack_for_Idle_Task 256 @ 0x20018E70 # passed to OSTaskCreateExt

f md380_packet @ 0x2001ae74
f md380_menu_somthing @ 0x2001b246
f md380_menu_mem_base @ 0x2001b274

f msg_sms_hdr_prep @ 0x2001cb54
f selected_contact_name_wstring 12 @ 0x2001cb58 # only valid in MENU 'Contact' !
f md380_menu_edit_buf @ 0x2001cb9a
f msg_sms_bdy_prep @ 0x2001ccbc
f zone_name 32 @ 0x2001cddc
f msg_sms_bdy @ 0x2001cefc
f md380_usbstring @ 0x2001d504
f md380_menu_memory @ 0x2001d5cc
f gfx_info @ 0x2001da1c
f gfx_info.off4 @ 0x2001da20
f md380_radio_config @ 0x2001dadc
f msg_buffer @ 0x2001db2c
f struct_channel_info2 @ 0x2001de78
f current_channel_info @ 0x2001deb8 # Why is this also used inside md380_create_menu_entry() ? 
f ConfigData @ 0x2001ded8 # name from D02.032 annotation
f menu_pointer_maybe_channel_data @ 0x2001def8

f top_side_button_pressed_function @ 0x2001defa
f top_side_button_held_function @ 0x2001defb
f bottom_side_button_pressed_function @ 0x2001defc
f bottom_side_button_held_function @ 0x2001defd
f print_buffer @ 0x2001e0d0
f contact @ 0x2001e1ac
f msg_sms_hdr @ 0x2001e1d0
f channel_name @ 0x2001e1f4
f zone_data_64byte @ 0x2001e218 # first part often had the same content as zone_name at 0x2001cddc .
   # zone_data_64byte is the destination buffer when reading *64* bytes from SPI-flash,  see 0x08022d74.
   # The first 32 bytes in this structure are the name (16 'wide' chars), the rest is still unknown.
f menu_title_cstring 12 @ 0x2001e3c0 # not ALWAYS the menu title ! sometimes contained "Back"
f toplinetext @ 0x2001e3fc
f botlinetext @ 0x2001e410
f adc1_6channel_dma_buffer @ 0x2001E51C # buffer for 6 channels, target for DMA-transfer
f smeter_rssi @ 0x2001e534
f md380_program_radio_unprohibited @ 0x2001e574
f zone_number_in_byte_3 4 @ 0x2001e57c # only byte[3] seems to contain meaningful data, 1 = FIRST zone in the list ?
f msg_timer_500 @ 0x2001e5d0 # counts down from 0x200 to almost zero, then starts DMR power-save ?
f msg_dest_addr @ 0x2001e5dc

f base_for_longpress_struct @ 0x2001e5ec
f radio_status_1 @ 0x2001e5f0
f keypressed_duringmenu @ 0x2001e5f3
f kb_keypressed @ 0x2001e5f8  # ex: "keypressed_struct", "keypress_flag"
f keylocked_flags @ 0x2001e5f9
f q_struct_1 @ 0x2001e600
f q_status_4 @ 0x2001e604

f idle_control_struct 0x112 @ 0x2001e640 # used in WaitForInterruptInIdle
f sema_1e648 @ 0x2001e648
f sema_1e64c @ 0x2001e64c
f sema1_poi @ 0x2001e650
f event5_mbox_poi @ 0x2001e658
f event1_mbox_poi_radio @ 0x2001e65c
f event4_mbox_poi @ 0x2001e660
f event3_mbox_poi @ 0x2001e664
f sema2_poi @ 0x2001e670
f event2_mbox_poi_beep @ 0x2001e67c
f bp_freq @ 0x2001e6c0
f bp_freq2 @ 0x2001e6c4
f menu_memory_poi @ 0x2001e700
f OSIdleTaskCtr 4 @ 0x2001e710
f md380_blockadr @ 0x2001e754
f md380_packetlen @ 0x2001e758
f keypress_time_some_button @ 0x2001e7ac
f kb_top_side_key_press_time @ 0x2001e7b0
f kb_bot_side_key_press_time @ 0x2001e7b2
f kb_side_key_max_time @ 0x2001e7b8
f kb_row_col_pressed @ 0x2001e7ba
f kb_row_col_pressed_last @ 0x2001e7bc
f kb_key_press_time @ 0x2001e7be # ex: keypress_time_all
f kbscan_matrix_temp @ 0x2001e7c0
f backlight_timer @ 0x2001e7f8
f not_the_volume_knob @ 0x2001e81c
f selected_channel @ 0x2001e850
f menu_flag_something @ 0x2001e87f
f kb_keydown_debounce @ 0x2001e889 # aka "keyup_keydown"
f kb_poll_temp @ 0x2001e88a # sometimes contains GPIO base address for kb_handler_sub1, sometimes not
f kb_keycode @ 0x2001e890
f keycode_old @ 0x2001e891
f gui_opmode3 @ 0x2001e892

f msg_sms_flags_shifted @ 0x2001e895
f tim_control_byte 1 @ 0x2001e896 # used in many timer interrupt services
f simplex_or_repeater_flagword @ 0x2001e898

f re_last_radio_event @ 0x2001e8a1
f bp_2001e8a7 @ 0x2001e8a7
f beep_code_send @ 0x2001e8a8
f event5_buffer @ 0x2001e8a9
f event1_buffer @ 0x2001e8aa
f some_radio_state_prev @ 0x2001e8af
f some_radio_state @ 0x2001e8b0
f some_state_var @ 0x2001e8b8
f channel_num @ 0x2001e8c1

f msg_0x2001e8f3 @ 0x2001e8f3
f msg_last_event @ 0x2001e8f4
f msg_status_flag1 @ 0x2001e8f5

f md380_menu_entry_selected @ 0x2001e903
f md380_menu_0x2001d3c1 @ 0x2001e914
f md380_menu_id @ 0x2001e915
f md380_menu_max_chars @ 0x2001e943 # ex: _0x2001d3ed
f md380_menu_cursor_pos_1 @ 0x2001e944 # ex: _0x2001d3ee
f md380_menu_cursor_pos_2 @ 0x2001e945 # ex: _0x2001d3ef
f md380_menu_field_type @ 0x2001e946 # ex: _0x2001d3f0, 3=numeric
f md380_menu_0x2001d3f1 @ 0x2001e947 # purpose ? cleared before numeric edit
f md380_menu_0x2001d3f4 @ 0x2001e94a # purpose ? also cleared before editing
f gui_opmode2 @ 0x2001e94b
f gui_opmode1_prev @ 0x2001e94c
f gui_opmode1 @ 0x2001e94d
f md380_dfu_state @ 0x2001e962
f md380_thingy2 @ 0x2001e963
f channel_number_too @ 0x2001e978



# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# BELOW: None-application-specific stuff from cpu.r
#       (modified by DL4YHF to see a few more ON-CHIP PERIPHERAL REGISTERS)
#    Note: We use the hardware register names as in "RM0090" (STM32F40x Reference Manual) where applicable,
#          not the bulky junk from ST's "STM32cube-MX" or whatever they call it now.
#          'f name 12 @ 33' sets flag 'name' with length 12 at offset 33
#          'f' lists them, possibly sorted by order of definition (not address).
#    Here, flags are also used for special function registers ("on-chip peripherals").

f io_TIM2 @ 0x40000000
f io_TIM3 @ 0x40000400
f io_TIM4 @ 0x40000800
f io_TIM5 @ 0x40000c00
f io_TIM6 @ 0x40001000
f io_TIM7 @ 0x40001400
f io_TIM12 @ 0x40001800
f io_TIM13 @ 0x40001C00
f io_TIM14 @ 0x40002000

f io_RTC @ 0x40002800 # offset 0 : "RTC_TR" (see RM0090)

f io_RTC_DR @ 0x40002804
f io_RTC_CR @ 0x40002808
f io_RTC_ISR @ 0x4000280c
f io_RTC_PRER @ 0x40002810
f io_RTC_WUTR @ 0x40002814
f io_RTC_CALIBR @ 0x40002818
f io_RTC_ALARMAR @ 0x4000281C
f io_RTC_ALARMBR @ 0x40002820
f io_RTC_WPR @ 0x40002824
f io_RTC_TAFCR @ 0x40002840
f io_RTC_BKP0R @ 0x40002850

f io_IWDG @ 0x40003000
f io_IWDG_PR @ 0x40003004
f io_IWDG_RLR @ 0x40003008
f io_IWDG_SR @ 0x40003008

f io_I2S2ext @ 0x40003400
f io_SPI2 @ 0x40003800
f io_SPI2_CR2 @ 0x40003804
f io_SPI2_SR @ 0x40003808
f io_SPI2_DR @ 0x4000380c
f io_SPI2_CRCPR @ 0x40003810
f io_SPI2_RXRCR @ 0x40003814
f io_SPI2_TXRCR @ 0x40003818
f io_SPI2_I2SCFGR @ 0x4000381c
f io_SPI2_I2SPR @ 0x40003820

f io_SPI3 @ 0x40003c00
f io_SPI3_CR2 @ 0x40003c04
f io_SPI3_SR @ 0x40003c08
f io_SPI3_DR @ 0x40003c0c
f io_SPI3_CRCPR @ 0x40003c10
f io_SPI3_RXRCR @ 0x40003c14
f io_SPI3_TXRCR @ 0x40003c18
f io_SPI3_I2SCFGR @ 0x40003c1c
f io_SPI3_I2SPR @ 0x40003c20

f io_I2S3ext @ 0x40004000 # I2S is another SPI port, usable as I2S (digital audio). RM0090 Rev7 page 884.
f io_I2S3_CR2 @ 0x40004004
f io_I2S3_SR @ 0x40004008
f io_I2S3_DR @ 0x4000400c
f io_I2S3_CRCPR @ 0x40004010
f io_I2S3_RXRCR @ 0x40004014
f io_I2S3_TXRCR @ 0x40004018
f io_I2S3_I2SCFGR @ 0x4000401c
f io_I2S3_I2SPR @ 0x40004020


f io_USART3 @ 0x40004800

f io_I2C1 @ 0x40005400

f io_PWR @ 0x40007000 # RM0090 Rev7 page 146.
f io_PWR_CSR @ 0x40007004

f io_DAC @ 0x40007400 # RM0090 Rev7 page 450.
f io_DAC_SWTRIG @ 0x40007404
f io_DAC_DHR12R1 @ 0x40007408
f io_DAC_DHR12L1 @ 0x4000740c
f io_DAC_DHR8R1 @ 0x40007410
f io_DAC_DHR8R2 @ 0x40007414
f io_DAC_DHR12L2 @ 0x40007418
f io_DAC_DHR8R2 @ 0x4000741c
f io_DAC_DHR12RD @ 0x40007420
f io_DAC_DHR12LD @ 0x40007424
f io_DAC_DHR8RD @ 0x40007428
f io_DAC_DOR1 @ 0x4000742c
f io_DAC_DOR2 @ 0x40007430
f io_DAC_SR @ 0x40007434


f io_0x4000f88d @ 0x4000f88d # wtf.. ?

f io_TIM1 @ 0x40010000

f io_TIM8 @ 0x40010400

f io_USART1 @ 0x40011000

f io_USART6 @ 0x40011400

f io_ADC1 @ 0x40012000
f io_ADC1_DATA @ 0x4001204c # RM0090 Rev7 page 427
f io_ADC2 @ 0x40012100
f io_ADC2_DATA @ 0x4001214c
f io_ADC3 @ 0x40012200
f io_ADC_COMMON_SR @ 0x40012300
f io_ADC_COMMON_CR @ 0x40012304
f io_ADC_COMMON_DR @ 0x40012308


f io_SPI1 @ 0x40013000

f io_SYSCFG @ 0x40013800 # RM0090 Rev7 page 291
f io_SYSCFG_PMC @ 0x40013804
f io_SYSCFG_EXTICR1 @ 0x40013808
f io_SYSCFG_EXTICR2 @ 0x4001380C
f io_SYSCFG_EXTICR3 @ 0x40013810
f io_SYSCFG_EXTICR4 @ 0x40013814
f io_SYSCFG_CMPCR @ 0x40013820

f io_EXTI @ 0x40013c00 # RM0090 Rev7 page 384
f io_EXTI_EMR @ 0x40013c04
f io_EXTI_RTSR @ 0x40013c08
f io_EXTI_FTSR @ 0x40013c0c
f io_EXTI_SWIER @ 0x40013c10
f io_EXTI_PR @ 0x40013c14

f io_TIM9 @ 0x40014000
f io_TIM10 @ 0x40014400
f io_TIM11 @ 0x40014800

f io_GPIOA @ 0x40020000

f io_GPIOB @ 0x40020400

f io_GPIOC @ 0x40020800

f io_GPIOD @ 0x40020c00

f io_GPIOE @ 0x40021000
f io_CRC @ 0x40023000 # RM0090 Rev7 page 114
f io_CRC_CTRL @ 0x40023008

f io_RCC @ 0x40023800 # RM0090 Rev7 page 263
f io_RCC_PLLCFG @ 0x40023804
f io_RCC_CFGR @ 0x40023808
f io_RCC_CIR @ 0x4002380c
f io_RCC_AHB1 @ 0x40023830 # dl4yhf took some liberty here..
f io_RCC_AHB2 @ 0x40023834
f io_RCC_AHB3 @ 0x40023838
f io_RCC_APB1 @ 0x40023840 # used but not found when referenced @ 0x080943F6 ?!
f io_RCC_APB2 @ 0x40023844
f io_RCC_APB1 @ 0x40023870
f io_RCC_CSR @ 0x40023874
f io_RCC_PLL_I2S @ 0x40023884

f io_FLASH @ 0x40023c00
f io_FLASH_KEY @ 0x40023c04
f io_FLASH_OPT_KEY @ 0x40023c08
f io_FLASH_STATUS @ 0x40023c0c # RM0090 Rev7 page 100
f io_FLASH_CTRL @ 0x40023c10 # RM0090 Rev7 page 102

f io_DMA1 @ 0x40026000 # RM0090 Rev7 page 332 (offset0 = "LISR", whatever that means)
f io_DMA1_HISR @ 0x40026004
f io_DMA1_LIFCR @ 0x40026008
f io_DMA1_HIFCR @ 0x4002600C
f io_DMA1_S0CR @ 0x40026010
f io_DMA1_S0NDTR @ 0x40026014
f io_DMA1_S0PAR @ 0x40026018
f io_DMA1_S0M0AR @ 0x4002601C
f io_DMA1_S0M1AR @ 0x40026020
f io_DMA1_S0FCR @ 0x40026024
f io_DMA1_S1CR @ 0x40026028
f io_DMA1_S1NDTR @ 0x4002602c
f io_DMA1_S1PAR @ 0x40026030
f io_DMA1_S1M0AR @ 0x40026034
f io_DMA1_S1M1AR @ 0x40026038
f io_DMA1_S1FCR @ 0x4002603c
f io_DMA1_S2CR @ 0x40026040
f io_DMA1_S2NDTR @ 0x40026044
f io_DMA1_S2PAR @ 0x40026048
f io_DMA1_S2M0AR @ 0x4002604c
f io_DMA1_S2M1AR @ 0x40026050
f io_DMA1_S2FCR @ 0x40026054
f io_DMA1_S5CR @ 0x40026088
f io_DMA1_S5NDTR @ 0x4002608c
f io_DMA1_S5PAR @ 0x40026090
f io_DMA1_S5M0AR @ 0x40026094
f io_DMA1_S5M1AR @ 0x40026098
f io_DMA1_S5FCR @ 0x4002609c


f io_DMA2 @ 0x40026400
f io_DMA2_HISR @ 0x40026404
f io_DMA2_LIFCR @ 0x40026408
f io_DMA2_HIFCR @ 0x4002640C
f io_DMA2_S0CR @ 0x40026410
f io_DMA2_S0NDTR @ 0x40026414
f io_DMA2_S0PAR @ 0x40026418
f io_DMA2_S0M0AR @ 0x4002641C
f io_DMA2_S0M1AR @ 0x40026420
f io_DMA2_S0FCR @ 0x40026424
f io_DMA2_S1CR @ 0x40026428
f io_DMA2_S1NDTR @ 0x4002642c
f io_DMA2_S1PAR @ 0x40026430
f io_DMA2_S1M0AR @ 0x40026434
f io_DMA2_S1M1AR @ 0x40026438
f io_DMA2_S1FCR @ 0x4002643c
f io_DMA2_S2CR @ 0x40026440
f io_DMA2_S2NDTR @ 0x40026444
f io_DMA2_S2PAR @ 0x40026448
f io_DMA2_S2M0AR @ 0x4002644c
f io_DMA2_S2M1AR @ 0x40026450
f io_DMA2_S2FCR @ 0x40026454
f io_DMA2_S3CR @ 0x40026458
f io_DMA2_S3NDTR @ 0x4002645c
f io_DMA2_S3PAR @ 0x40026460
f io_DMA2_S3M0AR @ 0x40026464
f io_DMA2_S3M1AR @ 0x40026468
f io_DMA2_S3FCR @ 0x4002646c
f io_DMA2_S5CR @ 0x40026488
f io_DMA2_S5NDTR @ 0x4002648c
f io_DMA2_S5PAR @ 0x40026490
f io_DMA2_S5M0AR @ 0x40026494
f io_DMA2_S5M1AR @ 0x40026498
f io_DMA2_S5FCR @ 0x4002649c

f io_USB_OTG_HS @ 0x40040000 # RM0090 Rev7 page 1450 (offset0 = "GOTGCTL")
f io_USB_OTG_HS_GOTGINT @ 0x40040004 # omitted a bunch of these 'intuitive' register names..

f io_0x400a6666 @ 0x400a6666 # don't think this is a valid "I/O"-address

# ABOVE: stuff formerly in cpu.r, last edited by DL4YHF 2016-01-03
# BELOW: Special addresses inside the CPU, not in RM0090 but in PM0214 :

f scb_ACTLR @ 0xE000E008 # Auxiliary Control Register, etc..
f SysTick_CTRL @ 0xe000e010 # SysTick control and status register, PM2014 Rev5 page 245
f SysTick_LOAD @ 0xe000e014 # SysTick reload register
f SysTick_VAL @ 0xe000e018 # SysTick current value register
f SysTick_CAL @ 0xe000e01C # SysTick calibration register
f nvic_ISER0 @ 0xE000E100 # Nested Vectored Interrupt Controller...
f nvic_ISER1 @ 0xE000E104
f nvic_ISER2 @ 0xE000E108
f nvic_ICER0 @ 0xE000E180
f nvic_ICER1 @ 0xE000E184
f nvic_ICER2 @ 0xE000E188 # etc, ..
f nvic_ISPR0 @ 0xE000E200 # etc, ...
f nvic_STIR @ 0xE000EF00
f mpu_TYPER @ 0xE000ED90 # Memory Protection Unit - Type Register
f mpu_CTRL @ 0xE000ED90 # Memory Protection Unit - Control Register, etc...
f scb_CPUID @ 0xE000ed00 # CPU-ID base register
f scb_ICSR @ 0xe000ed04
f scb_VTOR @ 0xe000ed08 # Vector Table Offset Register, PM0214 Rev5 page 220
f scb_AIRCR @ 0xe000ed0C # Air Conditioning Control Register ? :)
f scb_SCR @ 0xe000ed10 # System Control Register (what a name..)
f scb_CCR @ 0xe000ed14
f scb_SHPR1 @ 0xe000ed18
f scb_SHPR2 @ 0xe000ed1C
f scb_SHPR3 @ 0xe000ed20
f scb_SHCRS @ 0xe000ed24
f scb_CFSR @ 0xE000ed28
f fpu_CPACR @ 0xe000ed88 # Coprocessor access control register
f fpu_FPCCR @ 0xE000EF34 # Floating-point context control register
f fpu_FPCAR @ 0xE000EF38 # Floating-point context address register
f fpu_FPDSC @ 0xE000EF38 # Floating-point default status control...
# WB finished here. The other SCB-and-Co registers appeared too exotic.
# Even worse, this didn't work because R2 expanded bit 31 into NEGATIVE
# values, so the disassembler didn't recognise any address above 0x7FFFFFFF !
# Accesses to these system registers are now manually
# annotated (via 'CCa', or maybe in a post-processing script) - yucc.
# Below are just SOME of the locations where those registers are accessed:
CCa 0x0809435c read E000ED88 = FPU.CPACR
CCa 0x0809435e allow full coprocessor access
CCa 0x08094364 write E000ED88 = FPU.CPACR
CCa 0x080943a0 E000ED08 = SCB.VTOR
CCa 0x080d0014 R1 = 0xE000ED88 = FPU.CPACR
CCa 0x08051d86 R1 = 0xE000ED88 = FPU.CPACR
CCa 0x08093f44 E000ED1A = SCB.SHPR3, UsageFault prio ?
CCa 0x08093f5e E000ED10 = SCB.SysCtrlReg
CCa 0x08093f72 E000ED10 = SCB.SysCtrlReg
CCa 0x08093f72 E000ED10 = SCB.SysCtrlReg


# BELOW: Radare2 instructions to "produce" a nicer disassembly listing, with hex-dumps where applicable .
#    Output redirected to a plain old text file .
#    A '> listing.txt' after a command creates a new file and writes the output to it.
#    A '>> listing.txt' after the command APPENDS the output to a file.
#    But due to some super-stupid bug somewhere (radare2.exe ? cmd.exe ?),
#    lines in files created this way were terminated with 0x0A 0x0D instead of 0x0D 0x0A !
#    This stupidity can be 'undone' with a good text editor (like Notepad++) or Python :
#    Replacing the bizarre "\n\r" with "\r\n" (or, if you prefer "\n"). Everything else is insane.
#
#    Some of the "listable elements" where checked interactively, using commands like these:
#      'pxw' = "print hex word" (a word has 32 bits here).
#      'pdf @FuncName' = "print disassemble function" (only for functions with an already known length)
#
# "Your orders please" .. Outcomment all for testing, or those parts of the listing that you don't need :


# Show current working directory in the first line, so we know the original firmware version (e.g. d13.020) later
pwd > listing.txt # only ONE '>' here to create a fresh (empty) output file

# Vector Table as a 32-bit hex dump:
pxa 0x10 @VectorTable >> listing.txt
pxw 0x188 @VectorTable >> listing.txt

# Reset_Handler, SystemInit() and __main() next, because
# this is the first code executed after quitting the bootloader .
# List these functions by order of execution, not by memory address :
pdf @Reset_Handler >> listing.txt
pdf @SystemInit >> listing.txt
pdf @RCC_Init >> listing.txt # called from SystemInit() so list it here
pdf @__main >> listing.txt # called after SystemInit() so list it here
pdf @FPU_Init >> listing.txt # contains an esoteric "vmsr fpscr, r0" (FPU-related, PM0214 page 169)
pdf @_main2 >> listing.txt # 2nd function called from __main() [not main()]
pdf @_main2_init_sub2 >> listing.txt # almost as bizarre as Keil's "scatterload" !
pdf @_main2_init_sub3 >> listing.txt # still none of the already annotated 'upper level' functions in sight !
pdf @_main3 >> listing.txt
pdf @Return_ONE >> listing.txt
pdf @CalledForever >> listing.txt
pdf @InitGlobalsAndStartRealTimeKernel >> listing.txt
pdf @WaitForInterruptInIdle >> listing.txt
pdf @CreateTwoSemasAndTimerTask >> listing.txt
pdf @Create_uCOS_Timer_Task >> listing.txt

pdf @something_polling_kb_keypressed >> listing.txt
pdf @dummy_4edd0 >> listing.txt
pdf @keypress_time_related_1 >> listing.txt
pdf @something_setting_keypress_lower_button >> listing.txt
pdf @more_setting_keypress_lower_button >> listing.txt


pdf @check_for_ptt_switch >> listing.txt # called from the above
pdf @aes_startup_check >> listing.txt
pdf @func_36c1c >> listing.txt
pdf @aes_36c30 >> listing.txt
pdf @aes_cipher >> listing.txt 
pdf @Get_Welcome_Line1_from_spi_flash >> listing.txt
pdf @Get_Welcome_Line2_from_spi_flash >> listing.txt
pdf @rc_write_radio_config_to_flash >> listing.txt # 0x80226f6
pdf @channel_info_read_spi_init >> listing.txt
pdf @write_current_channel_info_to_spi >> listing.txt
pdf @write_current_channel_info_to_spi_long >> listing.txt
pdf @spiflash_read_3ff30_288 >> listing.txt
pdf @spiflash_write_3ff30_288 >> listing.txt
pdf @msg_process_sms >> listing.txt
pdf @func_2318e >> listing.txt

pdf @md380_spiflash_read >> listing.txt
pdf @md380_spiflash_write >> listing.txt
pdf @md380_spiflash_sektor_erase4k >> listing.txt
pdf @md380_spiflash_block_erase64k >> listing.txt
pdf @F_1069_spiflash_multiple_spiflash_program_page >> listing.txt
pdf @md380_spi_sendrecv >> listing.txt
pdf @md380_spiflash_wait >> listing.txt
pdf @md380_spiflash_enable >> listing.txt
pdf @md380_spiflash_disable >> listing.txt
pdf @md380_spiflash_security_registers_read >> listing.txt
pdf @spiflash_program_page >> listing.txt
pdf @spiflash_write_enable >> listing.txt
pdf @spiflash_Erase_Security_Registers_44h >> listing.txt
pdf @spiflash_Program_Security_Registers_42h >> listing.txt

pdf @dummy_4fc28 >> listing.txt
pdf @dummy_4fc2c >> listing.txt
pdf @biglist_pollsubsys_maybe >> listing.txt
pdf @SomeLongDispatcher >> listing.txt
pdf @CalledFromLongDispatcher >> listing.txt

pdf @CallsReadChannelSwitch >> listing.txt
#pdf @md380_f_4520 >> listing.txt # this is a monster !
pdf @md380_f_4137 >> listing.txt # this is a monster !
pdf @bp_sempost >> listing.txt
pdf @bp_sempost2 >> listing.txt
pdf @Beep_Process >> listing.txt # 0x802f9dc
pdf @Timer8ToneGenerator >> listing.txt # 0x80309b8
pdf @F_293 >> listing.txt
pdf @bp_set_freq >> listing.txt
pdf @bp_tone_off >> listing.txt
pdf @bp_tone_on >> listing.txt
pdf @bp_glisando >> listing.txt # 0x8030ae8 

pdf @disp_something >> listing.txt
pdf @do_nothing_2 >> listing.txt
pdf @f_4225 >> listing.txt # harmless name but another monster function
pdf @draw_statusline >> listing.txt
pdf @do_nothing_1 >> listing.txt # excessively called from draw_statusline, why ?
pdf @draw_statusline_more >> listing.txt
pdf @gui_control >> listing.txt
pdf @SomethingWithGPIOC_and_Backlight_Timer >> listing.txt
pdf @FuncWithAwfulLongSwitch >> listing.txt
pdf @SomethingWithLongpressSettingRadioStatus1 >> listing.txt
pdf @SomethingWithGPIOC_and_Backlight_Timer >> listing.txt
pdf @SomethingWithRadioStatus_4d1b8 >> listing.txt
pdf @adc_related_4d52c >> listing.txt
pdf @adc_related_4d578 >> listing.txt
pdf @adc_enable_disable >> listing.txt
pdf @adc_related_4d5b4 >> listing.txt
pdf @adc_StartConv >> listing.txt # in D3.032 : 0x8049e9c
pdf @adc_ReadDataRegister >> listing.txt
pdf @func_4d6de >> listing.txt
pdf @func_4d6f4 >> listing.txt
pdf @func_4d908 >> listing.txt
pdf @func_4d96a >> listing.txt
pdf @func_4d97a >> listing.txt
pdf @func_4dc0c_more_bitbang_io >> listing.txt
pdf @some_bitband_io >> listing.txt #       0x804dc84
pdf @some_bitband_io_range >> listing.txt # 0x804dcf6
pdf @SPI0_ReadReg_Sub1 >> listing.txt #     0x804dd12
pdf @some_func_pend >> listing.txt # called from c5000_spi0_write/readreg
pdf @some_func_post >> listing.txt # called from c5000_spi0_write/readreg
pdf @dmr_handle_data >> listing.txt #       0x804dd70
pdf @func_4df68 >> listing.txt
pdf @func_4dfbe >> listing.txt
pdf @func_4e014 >> listing.txt
pdf @func_4e014 >> listing.txt
pdf @func_4e0e0 >> listing.txt
pdf @func_4e102 >> listing.txt
pdf @ClearSomeHalfWordInRAM >> listing.txt # 0x804e132
pdf @DoNothing_only_BX_LR >> listing.txt
pdf @func_4e13c >> listing.txt
pdf @OSIdleTaskHook >> listing.txt
pdf @func_4e14c >> listing.txt
pdf @func_4e290 >> listing.txt
pdf @func_4e298 >> listing.txt
pdf @SysTick_Sub2 >> listing.txt
pdf @func_4e2e0 >> listing.txt
pdf @func_4e2fc_BX_LR_only >> listing.txt
pdf @func_4e2fe_BX_LR_only >> listing.txt
pdf @func_4e300_BX_LR_only >> listing.txt
pdf @func_4e302_BX_LR_only >> listing.txt
pdf @ManyStrangeSimpleMoves >> listing.txt
pdf @func_4e4cc >> listing.txt
pdf @func_4e6b8 >> listing.txt
pdf @func_4e70e >> listing.txt
pdf @func_4e728 >> listing.txt
pdf @func_4e7f4 >> listing.txt
pdf @func_4e808 >> listing.txt
pdf @func_4e82c_uses_SPI2_3_DMA_and_I2C >> listing.txt
pdf @func_4e9b0 >> listing.txt
pdf @func_4e9d0 >> listing.txt
pdf @func_4e9e2 >> listing.txt
pdf @func_4ea92 >> listing.txt 
pdf @func_4eae4 >> listing.txt
pdf @func_4eaea >> listing.txt
pdf @func_4eb3c >> listing.txt





pdf @gfx_write_pixel_2 >> listing.txt
pdf @SomethingWithGPIOC_TIM7_Status >> listing.txt
pdf @CalledFromLongpressThing >> listing.txt

pdf @func_44618 >> listing.txt
pdf @SomethingWith_RCC_and_PLL_I2C >> listing.txt
pdf @func_4476c >> listing.txt
pdf @func_447fa >> listing.txt
pdf @func_447fe >> listing.txt
pdf @func_44802 >> listing.txt
pdf @func_4481a >> listing.txt
pdf @func_44846 >> listing.txt 
pdf @func_44912 >> listing.txt
pdf @func_44930 >> listing.txt
pdf @adc1_adc2_and_dma2s3_init >> listing.txt # 0x8044950
pdf @func_44b68 >> listing.txt
pdf @func_44cb4 >> listing.txt # 0x8044cb4
pdf @LongSwitchWithRadioStatus1 >> listing.txt # 0x8044e00
pdf @SomethingWithGuiOpmode2 >> listing.txt # 0x80450c8
pdf @func_45156 >> listing.txt
pdf @func_451ce >> listing.txt
pdf @func_4520c >> listing.txt
pdf @func_45398 >> listing.txt
pdf @func_45414 >> listing.txt
pdf @SomethingWithChannelsRadioConfigAndBeeps >> listing.txt # 0x8045484
pdf @func_45830 >> listing.txt
pdf @func_458f8 >> listing.txt
pdf @func_45d18 >> listing.txt
pdf @func_46050 >> listing.txt
pdf @func_460a8 >> listing.txt
pdf @Calls_46050 >> listing.txt #                0x80460f0
pdf @DrawSomethingThenBitBangIO >> listing.txt # 0x80460f8 
pdf @Create_Start_Task >> listing.txt #          0x8046280
pdf @Start >> listing.txt #                      0x80462bc
pdf @create_many_semas >> listing.txt #          0x80463f6
pdf @Start_multiple_tasks >> listing.txt #       0x8046520
pdf @task_rtc_timer >> listing.txt
pdf @task_468f8 >> listing.txt
pdf @init_a_lot_gfx_and_lcd >> listing.txt #     0x8046c04
pdf @init_more_and_start_watchdog >> listing.txt
pdf @func_46dc0 >> listing.txt
pdf @func_46f48 >> listing.txt
pdf @func_46f8e >> listing.txt
pdf @func_4729c >> listing.txt
pdf @func_47312 >> listing.txt
pdf @func_474a0_heavy_bitbanging >> listing.txt
pdf @adc3_init >> listing.txt #                  0x8047518
pdf @func_475b8 >> listing.txt
pdf @func_477a4 >> listing.txt
pdf @func_47802 >> listing.txt
pdf @func_4788a >> listing.txt
pdf @func_478d0 >> listing.txt
pdf @func_4796a >> listing.txt
pdf @func_479e6_channel_related >> listing.txt
pdf @func_47a52 >> listing.txt
pdf @func_47a84 >> listing.txt
pdf @func_47ab6 >> listing.txt
pdf @TimerIRQ_Sub1 >> listing.txt
pdf @TimerIRQ_Sub4 >> listing.txt
pdf @TimerIRQ_Sub8 >> listing.txt
pdf @WaitAndDoSomethingWithGPIOC >> listing.txt
pdf @SomethingWithChannelInfo2 >> listing.txt
pdf @func_47cec >> listing.txt
pdf @func_47d5c >> listing.txt
pdf @func_47e54 >> listing.txt
pdf @func_47eb4 >> listing.txt 
pdf @RTCAndTimerIRQ_Sub2 >> listing.txt
pdf @func_4823a >> listing.txt
pdf @func_482c4 >> listing.txt
pdf @func_48312 >> listing.txt
pdf @func_4838c >> listing.txt
pdf @func_483c0 >> listing.txt
pdf @func_4841e >> listing.txt
pdf @func_4845c >> listing.txt
pdf @gfx_set_i16_in_GfxInfoPlus0x2C >> listing.txt
pdf @gfx_set_u8_in_GfxInfoPlus0x16 >> listing.txt
pdf @func_48498 >> listing.txt
pdf @return_0x80 >> listing.txt
pdf @return_0x10000 >> listing.txt
pdf @func_484a8 >> listing.txt
pdf @func_484d6 >> listing.txt
pdf @func_484f0 >> listing.txt
pdf @func_4850a >> listing.txt
pdf @func_4851e >> listing.txt
pdf @func_4855c >> listing.txt
pdf @func_48654 >> listing.txt
pdf @func_486be >> listing.txt
pdf @func_4870c >> listing.txt
pdf @func_48832 >> listing.txt
pdf @func_488b6 >> listing.txt
pdf @func_488dc >> listing.txt
pdf @func_48908 >> listing.txt
pdf @func_48934 >> listing.txt
pdf @func_48990 >> listing.txt
pdf @func_489c8 >> listing.txt
pdf @gfx_jmptbl_entry0 >> listing.txt
pdf @gfx_jmptbl_entry1 >> listing.txt
pdf @gfx_jmptbl_entry2 >> listing.txt
pdf @gfx_48a14 >> listing.txt
pdf @gfx_48a28 >> listing.txt
pdf @gfx_48a34_nop >> listing.txt
pdf @gfx_48a36 >> listing.txt
pdf @gfx_48a42 >> listing.txt
pdf @func_48a84 >> listing.txt
pdf @func_48a92 >> listing.txt
pdf @func_48ab8 >> listing.txt
pdf @func_48ade >> listing.txt
pdf @func_48b98 >> listing.txt
pdf @func_48cca >> listing.txt
pdf @func_48e08 >> listing.txt
pdf @func_48e10 >> listing.txt
pdf @func_48e26_uses_io_PWR >> listing.txt
pdf @func_48f28 >> listing.txt
pdf @func_48f32_uses_io_RTC >> listing.txt
pdf @func_48f70 >> listing.txt
pdf @func_48f92 >> listing.txt
pdf @func_49048 >> listing.txt
pdf @func_49050 >> listing.txt
pdf @func_49058 >> listing.txt
pdf @func_49060 >> listing.txt
pdf @func_49074 >> listing.txt
pdf @func_4909a >> listing.txt
pdf @func_490c0 >> listing.txt
pdf @func_490e6 >> listing.txt
pdf @func_4910c >> listing.txt
pdf @func_49114 >> listing.txt
pdf @func_49122 >> listing.txt
pdf @func_49130 >> listing.txt
pdf @func_49138 >> listing.txt
pdf @func_49140 >> listing.txt
pdf @func_4914e >> listing.txt
pdf @func_4915c >> listing.txt
pdf @DMA1_Stream5_Sub >> listing.txt # 0x8049428
pdf @DMA1_Stream2_Sub >> listing.txt # 0x804966a
pdf @SPI3_Handler >> listing.txt     # 0x8049756
pdf @func_497d2 >> listing.txt
pdf @func_49810 >> listing.txt
pdf @func_49970 >> listing.txt
pdf @func_4997a >> listing.txt 
pdf @func_49988 >> listing.txt
pdf @func_499a4 >> listing.txt
pdf @func_499c0 >> listing.txt
pdf @func_499dc >> listing.txt
pdf @func_499e2 >> listing.txt
pdf @func_49b30 >> listing.txt
pdf @func_49b40 >> listing.txt
pdf @func_49b50 >> listing.txt
pdf @func_49b68 >> listing.txt
pdf @func_49b82 >> listing.txt
pdf @func_49ba8_Creates_Sema >> listing.txt
pdf @func_49bbe_Uses_Sema >> listing.txt
pdf @func_49c04_Uses_Sema >> listing.txt
pdf @func_49ca8 >> listing.txt 
pdf @TIM2_IRQHandler >> listing.txt # 0x8049d52, still "gapless coverage"
pdf @func_49e00 >> listing.txt
pdf @Start_2_more_tasks__init_vocoder_tasks__Q >> listing.txt # 0x8049e14
pdf @long_AMBE_something >> listing.txt # 0x8049134
pdf @ambe_4a88e_calls_encode >> listing.txt
pdf @ambe_4a9f8 >> listing.txt
pdf @ambe_4aa78 >> listing.txt

pdf @ambe_decode_wav >> listing.txt
pdf @func_4b534 >> listing.txt
pdf @func_4b5ac >> listing.txt
pdf @func_4b62e >> listing.txt
pdf @func_4b6e6_posts_something >> listing.txt

# EXCEPTION- and INTERRUPT vectors (can be told from each other by the _IRQ in the names)
s DummyForUnusedIRQs  # ex: s NMI_Handler
pD (NextAfterHandlers-DummyForUnusedIRQs) >> listing.txt # this disassembles MOST (but not all)
# Many interrupt- and exception handlers were in a contiguous block.
# "pd N" disassembles N opcodes, "pD" diassembes N bytes.
# Both are aware of constant DATA blocks, and shows 'data' in hex.
# Interrupt handlers NOT contained in the above 'pD'-block
# must be annotated with 'af+' (including their length),
# so we can list them below, one by one, before commenting out
# the stuff that is not required, or turned out to be a dummy.
# Initially, ALL handlers were disassembled, because ALL of them
# had individual addresses (instead of using one common "do-nothing"-handler.
#pdf @PendSV_Handler >> listing.txt # invalid address in the VT !
pdf @WWDG_IRQHandler >> listing.txt
pdf @PVD_IRQHandler >> listing.txt
pdf @TAMP_STAMP_IRQHandler >> listing.txt
#pdf @RTC_WKUP_IRQHandler >> listing.txt # already contained in the 'pD'-block
pdf @FLASH_IRQHandler >> listing.txt
pdf @RCC_IRQHandler >> listing.txt
#pdf @EXTI0_IRQHandler >> listing.txt # already contained in the 'pD'-block
#pdf @EXTI1_IRQHandler >> listing.txt
#pdf @EXTI2_IRQHandler >> listing.txt
#pdf @EXTI3_IRQHandler >> listing.txt
pdf @EXTI4_IRQHandler >> listing.txt
#pdf @DMA1_Stream0_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @DMA1_Stream1_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
pdf @DMA1_Stream2_IRQHandler >> listing.txt
#pdf @DMA1_Stream3_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @DMA1_Stream4_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
pdf @DMA1_Stream5_IRQHandler >> listing.txt
#pdf @DMA1_Stream6_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
pdf @DMA2_Stream0_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @DMA2_Stream1_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @DMA2_Stream2_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @DMA2_Stream3_IRQHandler >> listing.txt # already contained in the 'pD'-block
pdf @DMA_Stream_Sub1 >> listing.txt
pdf @DMA_Stream_Sub2 >> listing.txt
#pdf @DMA2_Stream4_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @DMA2_Stream5_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @DMA2_Stream6_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @DMA2_Stream7_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @ADC_IRQHandler >> listing.txt # had an invalid address so don't try to disassemble
#pdf @CAN1_TX_IRQHandler >> listing.txt # don't think the radio has a CAN bus
#pdf @CAN1_RX0_IRQHandler >> listing.txt # even though it would be nice
#pdf @CAN1_RX1_IRQHandler >> listing.txt # if it did :)
#pdf @CAN1_SCE_IRQHandler >> listing.txt
pdf @EXTI9_5_IRQHandler >> listing.txt
pdf @TIM1_BRK_TIM9_IRQHandler >> listing.txt # leave this in even if it's a dummy.. someone may be looking for unused timers
pdf @TIM1_UP_TIM10_IRQHandler >> listing.txt
pdf @TIM1_TRG_COM_TIM11_IRQHandler >> listing.txt
pdf @TIM1_CC_IRQHandler >> listing.txt

#pdf @TIM3_IRQHandler >> listing.txt # already contained in the 'pD'-block
#pdf @TIM4_IRQHandler >> listing.txt # already contained in the 'pD'-block
pdf @I2C1_EV_IRQHandler >> listing.txt
pdf @I2C1_ER_IRQHandler >> listing.txt
pdf @I2C2_EV_IRQHandler >> listing.txt
pdf @I2C2_ER_IRQHandler >> listing.txt
pdf @SPI1_IRQHandler >> listing.txt
pdf @SPI2_IRQHandler >> listing.txt
pdf @USART1_IRQHandler >> listing.txt
pdf @USART2_IRQHandler >> listing.txt
pdf @USART3_IRQHandler >> listing.txt
pdf @EXTI15_10_IRQHandler >> listing.txt
pdf @RTC_Alarm_IRQHandler >> listing.txt
#pdf @OTG_FS_WKUP_IRQHandler >> listing.txt # already contained in the 'pD'-block
pdf @TIM8_BRK_TIM12_IRQHandler >> listing.txt
#pdf @TIM8_UP_TIM13_IRQHandler >> listing.txt # already contained in the 'pD'-block
pdf @TIM8_TRG_COM_TIM14_IRQHandler >> listing.txt
pdf @TIM8_CC_IRQHandler >> listing.txt
#pdf @DMA1_Stream7_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @FSMC_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @SDIO_IRQHandler >> listing.txt # unused, deliberately gets stuck in a loop
#pdf @TIM5_IRQHandler >> listing.txt # already contained in the 'pD'-block
pdf @SPI3_IRQHandler >> listing.txt
pdf @USART4_IRQHandler >> listing.txt
pdf @USART5_IRQHandler >> listing.txt
#pdf @TIM6_DAC_IRQHandler >> listing.txt # already contained in the 'pD'-block
#pdf @TIM7_DAC_IRQHandler >> listing.txt # already contained in the 'pD'-block
pdf @OTG_FS_IRQHandler >> listing.txt
pdf @USART6_IRQHandler >> listing.txt
pdf @I2C3_EV_IRQHandler >> listing.txt
pdf @I2C3_ER_IRQHandler >> listing.txt
pdf @OTG_HS_EP1_OUT_IRQHandler >> listing.txt
pdf @OTG_HS_EP1_IN_IRQHandler >> listing.txt
pdf @OTG_HS_WKUP_IRQHandler >> listing.txt
pdf @OTG_HS_IRQHandler >> listing.txt
pdf @DCMI_IRQHandler >> listing.txt
pdf @CRYP_IRQHandler >> listing.txt
pdf @HASH_RNG_IRQHandler >> listing.txt
pdf @FPU_IRQHandler >> listing.txt

# Functions called from various INTERRUPT SERVICE HANDLERS and Reset_Handler:
pdf @StoreR1_in_PtrR0plus0x3C >> listing.txt
pdf @SysTick_Sub3 >> listing.txt


pdf @WakeUp_Sub1 >> listing.txt
pdf @RTCWakeupIRQ_Sub1 >> listing.txt
pdf @CalledFromUSB_IRQ >> listing.txt
pdf @func_95824 >> listing.txt
pdf @func_9582e >> listing.txt
pdf @func_95838 >> listing.txt
pdf @SPI3_Handler >> listing.txt
pdf @SPI_I2S_GetITStatus >> listing.txt
pdf @SPI_I2S_EnableOrDisable >> listing.txt
pdf @SPI_I2S_ClearITPendingBit >> listing.txt
pdf @TIM_EnableOrDisableCounter >> listing.txt
pdf @TIM_43ae4 >> listing.txt
pdf @SomethingTestingTIM1_TIM8 >> listing.txt
pdf @SomethingElseWithTIM1_TIM8 >> listing.txt
pdf @TIM_ITConfig >> listing.txt

pdf @TimerIRQ_Sub5 >> listing.txt
pdf @TimerIRQ_Sub9 >> listing.txt
pdf @SomethingWithRadioStatus1 >> listing.txt
pdf @SomeBitFiddling >> listing.txt
pdf @SomethingWithGPIOC_TIM8_TIM7 >> listing.txt
pdf @SomethingWithTIM7_RadioStatus1 >> listing.txt
pdf @SomethingWithTIM7_ChannelInfo2 >> listing.txt
pdf @Something2_TIM7_RadioStatus1 >> listing.txt
pdf @SomethingWithGPIOC_TIM7_Status >> listing.txt
#pdf @SomethingWithGFX_Info >> listing.txt

                               #           D13.020:  - D3.032:    Delta:
pdf @func_0db88 >> listing.txt #           0x800db88
pdf @func_0dcec >> listing.txt #           0x800dcec
pdf @func_0dda6_dummy >> listing.txt #     0x800dda6
pdf @func_0dda8 >> listing.txt #           0x800dda8
pdf @func_0de64 >> listing.txt #           0x800de64
pdf @gfx_drawtext >> listing.txt #         0x800def6  0x800D88A   1644 (decimal)
pdf @draw_datetime_row >> listing.txt #    0x800df1a
pdf @F_4220 >> listing.txt #               0x800e02a
pdf @F_786 >> listing.txt #                0x800e0ac
pdf @F_4154 >> listing.txt #               0x800e128
pdf @F_4284 >> listing.txt #               0x800e298 
pdf @convert_freq_to_str >> listing.txt #  0x800e398
pdf @something_with_radio_config_and_channel_info >> listing.txt # 0x800e4b4
pdf @draw_zone_channel >> listing.txt #    0x800e538
pdf @func_0e6e8 >> listing.txt #           0x800e6e8
pdf @menu_RX_QRG_to_str >> listing.txt #   0x800e6f6
pdf @Volume_Menu >> listing.txt #          0x800e728
pdf @menu_dispatcher >> listing.txt #      0x800eb98
pdf @menu_F_4144 >> listing.txt #          0x800f2f8
pdf @menu_func_0f4ac >> listing.txt #      0x800f4ac
pdf @menu_func_0f6a8 >> listing.txt #      0x800f6a8
pdf @menu_add_number_of_menuentries_counts >> listing.txt # 0x800fc54
pdf @md380_menu_entry_back >> listing.txt #      0x800fc84
pdf @return_to_mode_1_from10 >> listing.txt #    0x800fc96
pdf @menugreen.Contacts.800fcbc >> listing.txt # 0x800fcbc
pdf @menu_func_0fde8 >> listing.txt #      0x800fde8
pdf @menu_func_0fe74 >> listing.txt #      0x800fe74
pdf @menu_func_0ff62 >> listing.txt #      0x800ff62
pdf @menu_func_1002c >> listing.txt #      0x801002c
pdf @func_1044e >> listing.txt
pdf @menu_func_10120 >> listing.txt #      0x8010120

pdf @func_101b8_yet_another_menu >> listing.txt
pdf @func_10606 >> listing.txt
pdf @func_10674 >> listing.txt
pdf @func_1072c >> listing.txt
pdf @func_10798 >> listing.txt
pdf @func_10844 >> listing.txt
pdf @func_1091c >> listing.txt
pdf @func_109ca >> listing.txt
pdf @func_10a5e >> listing.txt
pdf @func_10ae0 >> listing.txt
pdf @func_10ba0 >> listing.txt
pdf @func_10c08_sms_menu_maybe >> listing.txt
pdf @func_11108 >> listing.txt

pdf @func_115ec >> listing.txt
pdf @func_116f4 >> listing.txt
pdf @func_11790 >> listing.txt
pdf @func_1182c >> listing.txt
pdf @func_11938 >> listing.txt

pdf @func_16a96_copy_version_nr_to_print_buffer >> listing.txt
pdf @func_16ad4 >> listing.txt
pdf @func_16b34 >> listing.txt
pdf @func_16c00 >> listing.txt
pdf @func_16ca4 >> listing.txt
pdf @func_16fe4 >> listing.txt
pdf @func_170c4 >> listing.txt

pdf @Create_Menu_Entry_RadioSettings >> listing.txt # 0x8017cbc

pdf @func_18a40 >> listing.txt
pdf @func_18aa4_GetDateAndConv2String >> listing.txt
pdf @func_1bf56 >> listing.txt

pdf @func_1cff2 >> listing.txt
pdf @func_1d074 >> listing.txt
pdf @func_1d118 >> listing.txt
pdf @func_1d174 >> listing.txt
pdf @func_1f0f0_menu_something >> listing.txt
pdf @func_1fe54 >> listing.txt

pdf @md380_menu_12670 >> listing.txt
pdf @md380_menu_12900 >> listing.txt
pdf @md380_menu_12964_uses_event5_buffer >> listing.txt
pdf @md380_menu_12a08 >> listing.txt
pdf @md380_menu_12ada >> listing.txt
pdf @md380_menu_12b78 >> listing.txt
pdf @md380_menu_12c4c >> listing.txt
pdf @md380_menu_12d08 >> listing.txt
pdf @md380_menu_12ddc >> listing.txt
pdf @md380_menu_12e70 >> listing.txt
pdf @md380_menu_12f30 >> listing.txt
pdf @md380_menu_12fcc >> listing.txt
pdf @md380_menu_13082 >> listing.txt
pdf @md380_menu_13114 >> listing.txt
pdf @md380_menu_zone >> listing.txt
pdf @md380_menu_13270 >> listing.txt
pdf @md380_menu_channel_related_13314 >> listing.txt
pdf @md380_menu_curr_chn_related_133b0 >> listing.txt
pdf @md380_menu_apply_new_zone_maybe >> listing.txt
pdf @Create_Menu_Utilities >> listing.txt
pdf @md380_menu_entry_programradio >> listing.txt
pdf @Create_Menu_Entry_RX_QRG_shown >> listing.txt
pdf @Create_Menu_Entry_RX_QRG_1 >> listing.txt
pdf @Create_Menu_Entry_RX_QRG_2 >> listing.txt
pdf @Create_Menu_Entry_RX_QRG_3 >> listing.txt
pdf @Create_Menu_Entry_RX_QRG_4 >> listing.txt
pdf @md380_itow >> listing.txt
pdf @Create_Menu_Entry_LEDIndicator >> listing.txt
pdf @md380_menu_numerical_input >> listing.txt

pdf @md380_create_main_menu_entry >> listing.txt
pdf @md380_create_menu_entry >> listing.txt
pdf @md380_menu_entry_back >> listing.txt
pdf @menu_draw_something >> listing.txt
pdf @menu_draw_something2 >> listing.txt
pdf @menu_set_something >> listing.txt
pdf @menu_draw_something3 >> listing.txt
pdf @menu_draw_something4 >> listing.txt
pdf @menu_draw_something5 >> listing.txt
pdf @menu_328ec >> listing.txt
pdf @gfx_draw_sub_32a64 >> listing.txt
pdf @menu_32a7c >> listing.txt
pdf @menu_draw_sub_27ff0 >> listing.txt
pdf @menu_draw_sub_27ffa >> listing.txt

pdf @handle_keycode_F_4171 >> listing.txt
pdf @F_4315 >> listing.txt
pdf @menu_cursor_related_1bb9c >> listing.txt
pdf @menu_func_1aa60 >> listing.txt
pdf @menu_using_sms_and_edit_buf_1be2c >> listing.txt

pdf @gfx_get_xpos >> listing.txt # 0x8021888
pdf @gfx_get_ypos >> listing.txt # 0x8021890

pdf @func_22a8c >> listing.txt

pdf @func_36672 >> listing.txt
pdf @func_36736 >> listing.txt
pdf @func_369bc >> listing.txt
pdf @func_369c6 >> listing.txt
pdf @func_36ade >> listing.txt
pdf @func_36ae6 >> listing.txt
pdf @func_36b06 >> listing.txt
pdf @func_36b26 >> listing.txt
pdf @func_36b46 >> listing.txt
pdf @func_36b66 >> listing.txt
pdf @func_36b86 >> listing.txt
pdf @func_36dac >> listing.txt
pdf @func_36e08 >> listing.txt
pdf @func_36e32 >> listing.txt
pdf @func_36e76 >> listing.txt
pdf @func_36f0a >> listing.txt 
pdf @func_36f90 >> listing.txt
pdf @func_36f9a >> listing.txt

pdf @func_37886 >> listing.txt
pdf @func_37892 >> listing.txt
pdf @func_379b0 >> listing.txt
pdf @func_379f0 >> listing.txt 
pdf @func_37a74 >> listing.txt
pdf @func_37a8a >> listing.txt
pdf @MultiplySomethingFromStruct >> listing.txt
pdf @func_37a9e >> listing.txt
pdf @func_37ab8 >> listing.txt
pdf @func_37b00 >> listing.txt
pdf @func_37b74 >> listing.txt
pdf @func_37bb8 >> listing.txt
pdf @menu_draw_sub_37d02 >> listing.txt
pdf @menu_draw_sub_37d2a >> listing.txt
pdf @menu_37d44 >> listing.txt
pdf @menu_37e0a >> listing.txt
pdf @func_37b6c >> listing.txt
pdf @func_37c60 >> listing.txt
pdf @func_382ca >> listing.txt
pdf @func_383b8 >> listing.txt
pdf @func_383f8 >> listing.txt
pdf @func_384d4 >> listing.txt
pdf @func_393dc >> listing.txt
pdf @func_3951c >> listing.txt
pdf @func_3955c >> listing.txt
pdf @func_3960c >> listing.txt 
pdf @func_397d0 >> listing.txt
pdf @menu_39de2 >> listing.txt
pdf @menu_39e3e >> listing.txt
pdf @func_39f50 >> listing.txt
pdf @menu_draw_sub_3aba8 >> listing.txt
pdf @menu_draw_sub_3abbc >> listing.txt
pdf @menu_draw_sub_3abce >> listing.txt
pdf @menu_draw_sub_3abce >> listing.txt
pdf @menu_draw_sub_3abe4 >> listing.txt
pdf @menu_draw_sub_3abf8 >> listing.txt
pdf @menu_draw_sub_3ac46 >> listing.txt
pdf @func_3acec >> listing.txt
pdf @func_3ad3c >> listing.txt
pdf @gfx_3add4 >> listing.txt
pdf @gfx_3adec >> listing.txt
pdf @gfx_3ae04 >> listing.txt
pdf @gfx_3ae10 >> listing.txt
pdf @gfx_3ae1c >> listing.txt
pdf @gfx_3ae30 >> listing.txt
pdf @func_3ae68 >> listing.txt
pdf @func_3d2f0 >> listing.txt
pdf @func_3d53e >> listing.txt
pdf @func_3d57a >> listing.txt
pdf @func_3d5a0 >> listing.txt
pdf @TimerIRQ_Sub11 >> listing.txt
pdf @func_3da68 >> listing.txt
pdf @func_3dbf0 >> listing.txt
pdf @func_3dc90 >> listing.txt
pdf @func_3e372 >> listing.txt

pdf @func_3d924 >> listing.txt
pdf @func_3d99a >> listing.txt
pdf @func_3da3c >> listing.txt
pdf @func_3de1c >> listing.txt
pdf @func_3df70 >> listing.txt
pdf @func_3e058 >> listing.txt
pdf @func_3e1d6 >> listing.txt
pdf @func_3e318 >> listing.txt
pdf @func_3e3f6 >> listing.txt
pdf @func_3e47e >> listing.txt
pdf @func_3eb2a >> listing.txt
pdf @func_3f128 >> listing.txt
pdf @func_3f190 >> listing.txt
pdf @func_3f1fc >> listing.txt
pdf @func_3f314 >> listing.txt
pdf @func_3f32e >> listing.txt
pdf @func_3f5cc >> listing.txt
pdf @func_3f6c8 >> listing.txt
pdf @func_3f6dc >> listing.txt
pdf @func_3f8f2_init_PLL_and_C5000 >> listing.txt
pdf @func_3fda8 >> listing.txt

pdf @func_4005c >> listing.txt
pdf @func_401dc >> listing.txt
pdf @func_40224 >> listing.txt
pdf @func_403dc >> listing.txt
pdf @func_404dc >> listing.txt


pdf @func_43490_wr_C5000 >> listing.txt
pdf @func_43a18 >> listing.txt
pdf @func_43a82 >> listing.txt
pdf @func_43a9a >> listing.txt
pdf @func_43aac >> listing.txt
pdf @func_43b62 >> listing.txt 
pdf @func_43d00 >> listing.txt
pdf @func_43d22 >> listing.txt
pdf @func_43d2a >> listing.txt
pdf @func_43d3c >> listing.txt
pdf @func_43d50 >> listing.txt
pdf @func_43d62 >> listing.txt
pdf @func_43dd2 >> listing.txt

pdf @func_43df2 >> listing.txt
pdf @func_43e0e >> listing.txt
pdf @func_43e16 >> listing.txt
pdf @func_434e4_wr_C5000 >> listing.txt
pdf @func_43824_wr_C5000 >> listing.txt
pdf @func_43e98 >> listing.txt # called from CreateTwoSemasAndTimerTask
pdf @func_43f90 >> listing.txt
pdf @func_43fca >> listing.txt
pdf @func_44024 >> listing.txt # still in the initialisation, but 'Start' task already running
pdf @SysTick_Sub1 >> listing.txt
pdf @func_4411c >> listing.txt
pdf @func_44196 >> listing.txt
pdf @func_44222 >> listing.txt
pdf @func_44254 >> listing.txt
pdf @Func5_of_10 >> listing.txt
pdf @ClearSomeVariables >> listing.txt
pdf @ClearSomeBlocksInRAM >> listing.txt
pdf @Create_uCOS_Idle_Task >> listing.txt
pdf @Func4_of_10 >> listing.txt
pdf @func_443c6 >> listing.txt # called from CreateTwoSemasAndTimerTask
pdf @func_443d8 >> listing.txt
pdf @func_44434 >> listing.txt
pdf @OS_IdleTask >> listing.txt
pdf @func_44478 >> listing.txt
pdf @func_447a4 >> listing.txt

pdf @menu_draw_sub_4bae8 >> listing.txt

pdf @menu_28010 >> listing.txt

pdf @F_858 >> listing.txt
pdf @kb_handler >> listing.txt # an awful lot missing in the output beginning here ..... ?!
pdf @kb_handler_sub1 >> listing.txt

# gfx 'jump table', copied to gfx_info.jmptbl on init:
pxa 0x10 @gfx_jmptbl >> listing.txt
pxw 0x30 @gfx_jmptbl >> listing.txt
# list functions contained in the above 'gfx jump table':
pdf @gfx_jmptbl_entry0 >> listing.txt # gfx_jmptbl[0]
pdf @gfx_jmptbl_entry1 >> listing.txt # gfx_jmptbl[1]
pdf @gfx_jmptbl_entry2 >> listing.txt # gfx_jmptbl[2]
pdf @gfx_jmptbl_entry3 >> listing.txt # gfx_jmptbl[3]
pdf @gfx_linefill >> listing.txt # gfx_jmptbl[4] ?
pdf @gfx_linefill2 >> listing.txt # gfx_jmptbl[5] ?
pdf @gfx_blockfill >> listing.txt # gfx_jmptbl[6] ?
pdf @gfx_read_pixel_wrapper >> listing.txt # gfx_jmptbl[7] ?
pdf @gfx_48a14 >> listing.txt # gfx_jmptbl[8] ?
pdf @gfx_put_pixel >> listing.txt # gfx_jmptbl[9] ?
pdf @gfx_linefill_sub >> listing.txt # gfx_jmptbl[10] ?
#pdf @gfx_1d95e_does_nothing >> listing.txt # gfx_jmptbl[11] ?

pdf @gfx_jmptbl_entry0_sub >> listing.txt
pdf @gfx_jmptbl_entry1_sub >> listing.txt
pdf @gfx_jmptbl_entry2_sub >> listing.txt

pdf @do_nothing_30fde >> listing.txt

# Graphic functions (some, not all, seem to be taken from uc/GUI or STemWin)

pdf @gfx_1c1c8 >> listing.txt
pdf @gfx_1c1e6 >> listing.txt
pdf @gfx_1c1fe >> listing.txt
pdf @gfx_1c274 >> listing.txt
pdf @gfx_1c27e >> listing.txt
pdf @gfx_1c2a0 >> listing.txt
pdf @gfx_bmp_s1_5 >> listing.txt
pdf @gfx_bmp_s1_1 >> listing.txt
pdf @gfx_1c378 >> listing.txt
pdf @gfx_1c406 >> listing.txt
pdf @gfx_1c45e >> listing.txt
pdf @gfx_1c48a >> listing.txt
pdf @gfx_bmp_s1_4 >> listing.txt
pdf @gfx_1c4c2 >> listing.txt
pdf @gfx_1c4f0 >> listing.txt
pdf @gfx_1c4fa >> listing.txt
pdf @gfx_1c530 >> listing.txt
pdf @gfx_1c566 >> listing.txt
pdf @gfx_1c58a >> listing.txt
pdf @gfx_1c63c >> listing.txt
pdf @gfx_1c6d4 >> listing.txt
pdf @gfx_1c758 >> listing.txt
pdf @gfx_1c77e >> listing.txt
pdf @gfx_1c792 >> listing.txt
pdf @gfx_copy_8byte_thing >> listing.txt # 0x801c7aa
pdf @gfx_1c7bc >> listing.txt
pdf @gfx_1c834 >> listing.txt
pdf @gfx_1c840 >> listing.txt
pdf @gfx_1c86c >> listing.txt
pdf @gfx_1c9b8 >> listing.txt
pdf @gfx_1c9d4 >> listing.txt
pdf @gfx_1caa4 >> listing.txt
pdf @gfx_1caf2 >> listing.txt
pdf @gfx_bmp_sub3 >> listing.txt # 0x801cc94
pdf @gfx_bmp_sub1 >> listing.txt # 0x801ccf0
pdf @gfx_1d1c2 >> listing.txt
pdf @gfx_1d21c >> listing.txt
pdf @gfx_1d224 >> listing.txt
pdf @gfx_1d238 >> listing.txt
pdf @gfx_1d296 >> listing.txt
pdf @gfx_set_bg_color >> listing.txt # 0x801d368
pdf @gfx_set_fg_color >> listing.txt # 0x801d370
pdf @gfx_1d378 >> listing.txt
pdf @gfx_1d44e >> listing.txt
pdf @gfx_1d598 >> listing.txt
pdf @gfx_1d6e0 >> listing.txt
pdf @gfx_1d784 >> listing.txt
pdf @gfx_1d952_does_nothing >> listing.txt
pdf @gfx_1d988 >> listing.txt
pdf @gfx_1dd3c >> listing.txt


pdf @gfx_select_font >> listing.txt

# font headers were important to find out how text output works.
#   outcomment the following when not needed anymore !
pxa 0x80 @gfx_font_small >> listing.txt
pxw 0x20 @gfx_font_small >> listing.txt
pxa 0x04 @font_small_table_at_offset_0x18 >> listing.txt
pxa 0x80 @gfx_font_norm >> listing.txt
pxw 0x20 @gfx_font_norm >> listing.txt
pxa 16 @three_font_methods >> listing.txt
pxw 12 @three_font_methods >> listing.txt
pdf @font_method_1_of_3 >> listing.txt
pdf @font_method_2_of_3 >> listing.txt
pdf @font_method_3_of_3 >> listing.txt
pdf @combine_H_and_L_byte >> listing.txt

pdf @gfx_get_font_height >> listing.txt
pdf @gfx_newline >> listing.txt
pdf @gfx_drawchar_pos >> listing.txt
pdf @gfx_drawchar >> listing.txt
pdf @gfx_clear3 >> listing.txt
pdf @gfx_drawtext2 >> listing.txt
pdf @gfx_drawtext3 >> listing.txt
pdf @gfx_drawtext4 >> listing.txt
pdf @gfx_drawtext5 >> listing.txt
pdf @msg_convert >> listing.txt
pdf @gfx_drawtext6 >> listing.txt
pdf @gfx_drawtext7 >> listing.txt
pdf @gfx_drawtext8 >> listing.txt
pdf @gfx_drawtext9 >> listing.txt
pdf @gfx_drawtext10 >> listing.txt
pdf @gfx_drawchar_unk >> listing.txt
pdf @gfx_GetFontSizeY >> listing.txt
pdf @gfx_drawchar_sub3 >> listing.txt
pdf @font_method_called_via_hdr_offset0 >> listing.txt
pdf @find_char_in_font_table >> listing.txt
pdf @font_method_called_via_hdr_offset4 >> listing.txt
pdf @gfx_drawchar_sub4 >> listing.txt
pdf @draw_zone_channel >> listing.txt
pdf @gfx_call_font_method_via_hdr_offset4 >> listing.txt
pdf @gfx_set_ypos >> listing.txt
pdf @gfx_set_xpos >> listing.txt

pdf @gfx_setcolor_sub1 >> listing.txt
pdf @gfx_drawtext_sub2 >> listing.txt
pdf @gfx_drawtext_sub3 >> listing.txt
pdf @gfx_drawtext_sub1 >> listing.txt
pdf @gfx_drawtext_sub4 >> listing.txt
pdf @gfx_get_current_font_height >> listing.txt
pdf @gfx_font_count_something >> listing.txt
pdf @gfx_drawtext_sub7 >> listing.txt
pdf @gfx_drawtext_sub8 >> listing.txt
pdf @gfx_drawtext_sub9 >> listing.txt

# 'low level' graphic I/O and auxiliary functions:
pdf @gfx_write_pixel_to_framebuffer >> listing.txt
pdf @gfx_read_pixel_from_framebuffer >> listing.txt
pdf @WriteLCDCommand >> listing.txt
pdf @WriteLCDData >> listing.txt
pdf @ReadLCDData >> listing.txt
pdf @InitLCDisplay >> listing.txt
pdf @DeAssertLCDReset >> listing.txt
pdf @Delay_R0 >> listing.txt
pdf @InitLCD_wrapper >> listing.txt

# remaining functions, roughly ordered by address:

pdf @func_0c7e8 >> listing.txt

pdf @func_213d0 >> listing.txt
pdf @func_214ea >> listing.txt
pdf @func_214fe >> listing.txt
pdf @func_21596_draw_something >> listing.txt
pdf @func_215c2 >> listing.txt
pdf @func_215fc >> listing.txt
pdf @func_21646 >> listing.txt
pdf @func_21936 >> listing.txt
pdf @func_21958_spiflash_something >> listing.txt
pdf @func_22502_spiflash_security >> listing.txt
pdf @func_22532_spiflash_security_2 >> listing.txt
pdf @func_22550_spiflash_security_3 >> listing.txt
pdf @func_226ae_spiflash_rd_2 >> listing.txt
pdf @func_226e4_spiflash_rd_3 >> listing.txt
pdf @init_radioconfig_2_from_spi >> listing.txt
pdf @func_2293e_spiflash_wr_2 >> listing.txt
pdf @func_22950_spiflash_rd_4 >> listing.txt
pdf @func_22962_spiflash_rd_5 >> listing.txt
pdf @load_contact_spiflash >> listing.txt # 0x802297c
pdf @load_contact >> listing.txt # 0x8022992
pdf @func_229b6 >> listing.txt
pdf @func_229da >> listing.txt
pdf @func_229fe >> listing.txt
pdf @func_22b42 >> listing.txt
pdf @func_22cc6_spiflash_rd_6 >> listing.txt
pdf @func_22d5e_spiflash_wr_3 >> listing.txt
pdf @spiflash_rd_zone_name_2__64byte >> listing.txt
pdf @spiflash_rd_something_zone_depending >> listing.txt
pdf @func_22e1a_spiflash_rd_8 >> listing.txt
pdf @func_22e32_spiflash_rd_9 >> listing.txt
pdf @func_22e4a_spiflash_rd_10 >> listing.txt
pdf @md380_spiflash_read_zone_struct_with_number_in_byte3_maybe >> listing.txt
pdf @md380_spiflash_write_zone_struct_with_number_in_byte3_maybe >> listing.txt
pdf @func_22ee0_spiflash_rd_12 >> listing.txt
pdf @func_22ef2_spiflash_wr_12 >> listing.txt
pdf @func_22f04_spiflash_rd_sms_hdr >> listing.txt
pdf @func_22f24_spiflash_wr_sms_hdr >> listing.txt
pdf @func_22f50_spiflash_rd_13 >> listing.txt
pdf @func_22fa4_spiflash_rd_14 >> listing.txt
pdf @func_22fb6_spiflash_wr_14 >> listing.txt
pdf @func_22fc8_spiflash_rd_sms_bdy >> listing.txt
pdf @msg_flash_write >> listing.txt
pdf @func_23018_spiflash_rd_15 >> listing.txt
pdf @func_23096_spiflash_rd_16 >> listing.txt
pdf @func_230b0_spiflash_rd_17 >> listing.txt
pdf @func_230ca_spiflash_rd_18 >> listing.txt
pdf @func_230e8_spiflash_rd_19 >> listing.txt
pdf @func_23102 >> listing.txt
pdf @func_23126_spiflash_rd_curr_chnl >> listing.txt
pdf @func_2314c >> listing.txt
pdf @func_23162_spiflash_wr_20 >> listing.txt
pdf @func_23178_spiflash_wr_21 >> listing.txt
pdf @func_2318e >> listing.txt
pdf @func_231c2_spiflash_rd_22 >> listing.txt
pdf @func_23220 >> listing.txt
pdf @func_23294 >> listing.txt
pdf @func_232e4 >> listing.txt
pdf @func_23358_spiflash_rd_d11c >> listing.txt
pdf @func_2336a >> listing.txt
pdf @func_23380 >> listing.txt
pdf @func_2339c >> listing.txt
pdf @func_233b4 >> listing.txt
pdf @func_233cc >> listing.txt
pdf @func_233e8 >> listing.txt
pdf @func_23414 >> listing.txt
pdf @func_23464 >> listing.txt
pdf @func_234d4 >> listing.txt
pdf @func_234e6 >> listing.txt
pdf @func_234f8 >> listing.txt
pdf @func_23514 >> listing.txt
pdf @func_23526 >> listing.txt
pdf @func_2354c >> listing.txt
pdf @func_2361c >> listing.txt
pdf @func_23634 >> listing.txt
pdf @func_23644 >> listing.txt
pdf @func_23656 >> listing.txt
pdf @func_2366c >> listing.txt
pdf @func_2367e >> listing.txt
pdf @func_23690 >> listing.txt
  # 0x80236a6: end of the boring spiflash-read/write stuff, next: gfx_bmp_sub2

pdf @gfx_drawbmp >> listing.txt #  0x80237fe
pdf @gfx_bmp_sub2 >> listing.txt # 0x8023760

pdf @func_25790_menu_create_something >> listing.txt
pdf @func_25e60 >> listing.txt
pdf @func_25e8e >> listing.txt
pdf @func_25ff4 >> listing.txt
pdf @func_26230 >> listing.txt
pdf @func_26298 >> listing.txt

pdf @func_26f46 >> listing.txt
pdf @func_26f64 >> listing.txt

pdf @func_27270 >> listing.txt
pdf @func_273b0 >> listing.txt
pdf @func_275dc >> listing.txt
pdf @func_27e3e >> listing.txt
pdf @func_27e6c >> listing.txt
pdf @func_27ed0 >> listing.txt
pdf @func_27ef0 >> listing.txt
pdf @func_2aac0 >> listing.txt
pdf @func_2aba8 >> listing.txt
pdf @func_2abba >> listing.txt
pdf @func_2abce >> listing.txt
pdf @func_2ac0c >> listing.txt
pdf @func_2ac2e >> listing.txt

pdf @gfx_2b088 >> listing.txt

pdf @func_2b726 >> listing.txt
pdf @func_2b874 >> listing.txt
pdf @func_2bad0 >> listing.txt
pdf @func_2bfcc >> listing.txt
pdf @func_2c4e0 >> listing.txt
pdf @func_2c6fc >> listing.txt
pdf @func_2c7a6 >> listing.txt
pdf @some_init >> listing.txt #           0x802d368
pdf @display_unprog_screen >> listing.txt
pdf @display_idle_screen >> listing.txt # 0x802d7f8
pdf @func_2daf8 >> listing.txt
pdf @func_2dd12 >> listing.txt
pdf @func_2dd34 >> listing.txt
pdf @func_2dd36_beeps_and_sets_kb_keycode >> listing.txt
pdf @func_2de84 >> listing.txt

pdf @func_2e73c_uses_menu_cursor_pos_1 >> listing.txt
pdf @func_2e7bc >> listing.txt
pdf @func_2e860 >> listing.txt
pdf @func_2e918 >> listing.txt
pdf @func_2e984_beeps_and_uses_msg_timer_500 >> listing.txt
pdf @func_2ea0c_beeps_and_uses_struct_channel_info2 >> listing.txt
pdf @func_2ea9e >> listing.txt



pdf @func_2f118 >> listing.txt
pdf @func_2f268 >> listing.txt
pdf @func_2f302 >> listing.txt
pdf @func_2f378 >> listing.txt
pdf @func_2f418 >> listing.txt
pdf @func_2f478 >> listing.txt
pdf @func_2f520 >> listing.txt
pdf @func_2f58e >> listing.txt
pdf @func_2f706 >> listing.txt
pdf @func_2f8a0_erases_and_writes_flash >> listing.txt
pdf @func_2f8f8 >> listing.txt
pdf @func_30e74 >> listing.txt
pdf @func_311f4 >> listing.txt
pdf @func_31900 >> listing.txt
pdf @func_31da6 >> listing.txt

pdf @func_31e10 >> listing.txt
pdf @func_31e68 >> listing.txt
pdf @func_31e8e >> listing.txt
pdf @func_31f1c >> listing.txt
pdf @func_31fe2 >> listing.txt


pdf @func_320fe >> listing.txt
pdf @func_32130 >> listing.txt
pdf @func_321f8 >> listing.txt
pdf @func_3223e >> listing.txt
pdf @func_3228e >> listing.txt
pdf @func_322d2 >> listing.txt
pdf @func_32416 >> listing.txt 
pdf @func_32536 >> listing.txt
pdf @func_32712 >> listing.txt
pdf @func_32722 >> listing.txt
pdf @func_32a10 >> listing.txt
pdf @func_32a4e >> listing.txt

# 0x8032af0 contains stuff possibly originating from uc/GUI or 'STemWin'...
pdf @gfx_32af0 >> listing.txt
pdf @gfx_32b04 >> listing.txt
pdf @gfx_32b04 >> listing.txt
pdf @gfx_32b14 >> listing.txt
pdf @gfx_ThreeRectSomething >> listing.txt # 0x8032b26
pdf @gfx_32bae >> listing.txt
pdf @gfx_memcpy >> listing.txt
pdf @gfx_32ca4 >> listing.txt
pdf @some_long_adding >> listing.txt
pdf @func_32d28 >> listing.txt
pdf @gfx_32d60 >> listing.txt
pdf @gfx_32d8c >> listing.txt
pdf @gfx_32dda >> listing.txt
pdf @gfx_setcolor_sub4 >> listing.txt
pdf @gfx_setcolor_sub2 >> listing.txt
pdf @gfx_setcolor_sub3 >> listing.txt
pdf @gfx_32e24 >> listing.txt
pdf @gfx_32e5c >> listing.txt
pdf @gfx_32eb6 >> listing.txt
pdf @gfx_clipped_blockfill_maybe >> listing.txt
pdf @gfx_32f50 >> listing.txt



pdf @gfx_IntersectRect >> listing.txt # 0x8032cc8

pdf @gfx_3316c >> listing.txt
pdf @gfx_init_lcd >> listing.txt
pdf @gfx_331bc >> listing.txt
pdf @gfx_set_bg_color2 >> listing.txt # 0x80331c8
pdf @gfx_set_fg_color2 >> listing.txt # 0x80331e0
pdf @gfx_33204 >> listing.txt
pdf @gfx_3323a >> listing.txt
pdf @gfx_3324c >> listing.txt
pdf @gfx_33244 >> listing.txt
pdf @gfx_33368 >> listing.txt
pdf @gfx_33374 >> listing.txt
pdf @gfx_33382 >> listing.txt
pdf @gfx_33396 >> listing.txt
pdf @gfx_before_lcd_init >> listing.txt
pdf @gfx_33428 >> listing.txt
pdf @gfx_33496 >> listing.txt
pdf @gfx_init_lcd_and_others >> listing.txt # 0x80334B2
pdf @gfx_334f8 >> listing.txt
pdf @gfx_3351c >> listing.txt
pdf @gfx_33966 >> listing.txt
pdf @func_33cd0 >> listing.txt
pdf @func_33ce8 >> listing.txt
pdf @func_33d42 >> listing.txt
pdf @func_33f30 >> listing.txt
pdf @func_3409a >> listing.txt
pdf @func_340ec >> listing.txt
pdf @func_34164 >> listing.txt
pdf @func_341a2 >> listing.txt
pdf @func_34208 >> listing.txt
pdf @func_3423a >> listing.txt
pdf @func_35524 >> listing.txt
pdf @func_35a12 >> listing.txt
pdf @func_35be4 >> listing.txt
pdf @func_36574 >> listing.txt
pdf @gfx_36980 >> listing.txt
pdf @func_369b2 >> listing.txt
pdf @func_36aa8 >> listing.txt
pdf @func_36ad6 >> listing.txt
pdf @func_36c14 >> listing.txt
pdf @func_36f44 >> listing.txt
pdf @func_36f4c >> listing.txt
pdf @func_36f98 >> listing.txt
pdf @func_37144 >> listing.txt
pdf @func_376b0 >> listing.txt
pdf @func_376ca >> listing.txt
pdf @func_37736 >> listing.txt
pdf @func_37a6a >> listing.txt
pdf @func_37b0a >> listing.txt
pdf @func_37792 >> listing.txt
pdf @func_39000 >> listing.txt
pdf @func_391e4 >> listing.txt
pdf @func_39d3c >> listing.txt

pdf @func_3b376 >> listing.txt
pdf @func_3b42a >> listing.txt
pdf @func_3b5a0 >> listing.txt
pdf @func_3b5d6 >> listing.txt
pdf @func_3b618 >> listing.txt

pdf @gfx_3b7c4 >> listing.txt
pdf @gfx_3b850 >> listing.txt
pdf @gfx_3b86c >> listing.txt

pdf @func_3ccd8 >> listing.txt

pdf @func_48e40 >> listing.txt
pdf @func_4b2fe >> listing.txt
pdf @func_4b356 >> listing.txt

pdf @func_4b6f4 >> listing.txt
pdf @func_4b810 >> listing.txt
pdf @func_4b87e >> listing.txt
pdf @func_4b8c8 >> listing.txt
pdf @gfx__GetFontSizeY >> listing.txt # 0x804b980
pdf @gfx_4b994 >> listing.txt
pdf @func_4b9a0 >> listing.txt
pdf @func_4b9e0 >> listing.txt 
pdf @gfx_4bac4 >> listing.txt
pdf @func_4bb2c >> listing.txt
pdf @func_4bccc >> listing.txt
pdf @func_4bc9c >> listing.txt
pdf @func_4bc80 >> listing.txt
pdf @gfx_4bd40 >> listing.txt
pdf @gfx_4bd5e >> listing.txt
pdf @gfx_4be14 >> listing.txt
pdf @gfx_4be2e >> listing.txt
pdf @gfx_4be40 >> listing.txt
pdf @draw_some_bitmap_and_text >> listing.txt # 0x804be74
pdf @func_4c030 >> listing.txt
pdf @func_4c0a8 >> listing.txt
pdf @func_4c0ea >> listing.txt
pdf @func_4c148 >> listing.txt
pdf @func_4c220 >> listing.txt
pdf @func_4c278 >> listing.txt
pdf @func_4c2cc >> listing.txt
pdf @func_4c2fa >> listing.txt
pdf @func_4c304 >> listing.txt
pdf @func_4c344 >> listing.txt
pdf @func_4c38c >> listing.txt
pdf @func_4c38c >> listing.txt
pdf @func_4c3ec >> listing.txt
pdf @func_4c446 >> listing.txt
pdf @func_4c64e >> listing.txt
pdf @func_4c782 >> listing.txt
pdf @func_4c7b6 >> listing.txt
pdf @msg_handle_types >> listing.txt
pdf @msg_handle_type_11 >> listing.txt
pdf @msg_handle_type_other >> listing.txt
pdf @func_4ccbc >> listing.txt
pdf @func_4cdc6 >> listing.txt
pdf @init_Tone_fft_task >> listing.txt # 0x804ce2c
pdf @func_4ce88 >> listing.txt
pdf @func_4cf06_uses_ADC2_and_TIM3 >> listing.txt
pdf @func_4cf80 >> listing.txt

pdf @func_4dc0c_more_bitbang_io >> listing.txt

pdf @func_4f070 >> listing.txt
pdf @func_4f29c >> listing.txt
pdf @something_using_menu_depth >> listing.txt # 0x804f482
pdf @func_4f4d0 >> listing.txt
pdf @dummy_4f686 >> listing.txt
pdf @dummy_4f688 >> listing.txt
pdf @func_4f68a_polls_EXT_PTT >> listing.txt
pdf @func_4f6de >> listing.txt 
pdf @func_4f8e4 >> listing.txt

pdf @dummy_4fc26 >> listing.txt
pdf @dummy_4fc2a >> listing.txt
pdf @dummy_4fc2e >> listing.txt
pdf @dummy_4fc32 >> listing.txt
pdf @func_4fc24_dummy >> listing.txt
pdf @func_4fc30_dummy >> listing.txt
pdf @Read_Channel_Switch_maybe >> listing.txt #      0x804fc34
pdf @CallsReadChannelSwitch >> listing.txt #         0x804fd04
pdf @Something_using_Channel_Number >> listing.txt # 0x804fd8c
pdf @func_4fddc >> listing.txt
pdf @func_4fde4 >> listing.txt
pdf @func_4fdec >> listing.txt
pdf @FeedTheWatchdog >> listing.txt
pdf @StartTheWatchdog >> listing.txt
pdf @func_4fe14_monster_accessing_C5000 >> listing.txt # 0x804fe14 .. 0x8051b88

pdf @func_51b8c >> listing.txt
pdf @func_51c58 >> listing.txt
pdf @func_51c6a >> listing.txt
pdf @dummy_51d08 >> listing.txt
pdf @func_51d0c >> listing.txt
pdf @func_51d16 >> listing.txt
pdf @func_51d7e >> listing.txt
pdf @func_51da8_uses_EXTI_RTSR >> listing.txt
pdf @func_51e30 >> listing.txt
pdf @CalledFromPinChangeIRQ >> listing.txt #  0x8051e42
pdf @ClearEXTIPendingBits_R0 >> listing.txt # 0x8051e66
pdf @func_51e80 >> listing.txt
pdf @kbscan_set_LCD_data_LOW >> listing.txt # 0x8051ed4
pdf @ConfigureLCDPort >> listing.txt # 0x8051f22
pdf @kb_scan_matrix_3 >> listing.txt # 0x8051fac
pdf @kbscan_cfg_K1K2K3_as_inputs_with_pull_up >> listing.txt # 0x8051fe6




pdf @kb_scan_matrix_4 >> listing.txt # 0x805201c
pdf @func_52078 >> listing.txt
pdf @func_52158 >> listing.txt
pdf @func_52194 >> listing.txt
pdf @func_521c8 >> listing.txt
pdf @func_5220e >> listing.txt
pdf @func_52284 >> listing.txt
pdf @clear_16_bytes_from_R0 >> listing.txt
pdf @func_522c8 >> listing.txt
pdf @TimerIRQ_Sub7_writes_DAC >> listing.txt # 0x80522f4
pdf @SomethingElseWritingDAC >> listing.txt  # 0x8052310
pdf @func_52330 >> listing.txt
pdf @func_523a8 >> listing.txt
pdf @func_523c8 >> listing.txt
pdf @func_523d8 >> listing.txt
pdf @func_523fa >> listing.txt
pdf @func_5242c >> listing.txt
pdf @func_5245c >> listing.txt
pdf @func_524cc >> listing.txt
pdf @func_524e2 >> listing.txt
pdf @func_5258c >> listing.txt
pdf @func_52596 >> listing.txt
pdf @func_525f4 >> listing.txt
pdf @func_5266c >> listing.txt
pdf @func_52672 >> listing.txt
pdf @func_5267c >> listing.txt
pdf @func_52774 >> listing.txt
pdf @func_52790 >> listing.txt
pdf @func_527ac >> listing.txt
pdf @func_527c8 >> listing.txt
pdf @func_527de >> listing.txt
pdf @func_527e4 >> listing.txt
pdf @func_527ea >> listing.txt
pdf @func_5281e >> listing.txt
pdf @func_52860 >> listing.txt
pdf @func_52940 >> listing.txt
pdf @func_529a8 >> listing.txt
pdf @func_529f4 >> listing.txt
pdf @func_52a62 >> listing.txt
pdf @func_52aa0 >> listing.txt
pdf @func_52d5e >> listing.txt
pdf @func_52dfe >> listing.txt
pdf @func_53030 >> listing.txt
pdf @func_530a4_endless_loop >> listing.txt
pdf @func_530a8 >> listing.txt 
pdf @ambe_encode_thing__size_not_correct >> listing.txt


# "something that paints" but definitely no low-level 'gfx':
pdf @often_called_something_keycode_menu >> listing.txt
pdf @paint_a_lot >> listing.txt


# RTOS kernel and related functions
pdf @OSSemCreate >> listing.txt
pdf @OSSemPend >> listing.txt
pdf @OSSemPost >> listing.txt
pdf @OSTaskCreateExt >> listing.txt
pdf @OSTaskNameSet >> listing.txt
pdf @OSTimeDly >> listing.txt
pdf @md380_f_4102 >> listing.txt
pdf @md380_f_4137 >> listing.txt
pdf @md380_f_4520 >> listing.txt
pdf @func_31038 >> listing.txt
pdf @md380_OSMboxPost >> listing.txt
pdf @md380_OSMboxPend >> listing.txt
pdf @OS_ENTER_CRITICAL >> listing.txt
pdf @OS_EXIT_CRITICAL >> listing.txt
#pdf @_enable_irq >> listing.txt # ?

pdf @func_52c94 >> listing.txt
pdf @func_53268 >> listing.txt
pdf @func_53298 >> listing.txt
pdf @func_532a8 >> listing.txt
pdf @func_5332c >> listing.txt
pdf @func_53574 >> listing.txt
pdf @func_53590 >> listing.txt
pdf @func_53720 >> listing.txt
pdf @func_53730 >> listing.txt
pdf @func_5375c >> listing.txt
pdf @func_53778 >> listing.txt
pdf @func_537ec >> listing.txt
pdf @func_538f0 >> listing.txt
pdf @func_53978 >> listing.txt
pdf @func_539f0 >> listing.txt
pdf @func_53a74 >> listing.txt
pdf @func_53a88 >> listing.txt
pdf @func_53a98 >> listing.txt
pdf @func_53b7c >> listing.txt
pdf @func_53bac >> listing.txt
pdf @func_53c20 >> listing.txt
pdf @func_54110 >> listing.txt
pdf @func_5414c >> listing.txt
pdf @func_54188 >> listing.txt
pdf @func_541ae >> listing.txt
pdf @func_54290 >> listing.txt 
pdf @func_542d8 >> listing.txt
pdf @func_54308 >> listing.txt
pdf @func_54324_lots_of_arithmetics >> listing.txt
pdf @func_544c8_even_more_arithmetics >> listing.txt
pdf @func_54710 >> listing.txt
pdf @func_547a0 >> listing.txt
pdf @func_54850 >> listing.txt
pdf @func_54f52_floating_point_stuff >> listing.txt
pdf @func_5505c_more_floating_point >> listing.txt
pdf @func_55144_return_zero >> listing.txt
pdf @func_55148 >> listing.txt
pdf @func_5519a >> listing.txt
pdf @func_5522e >> listing.txt
pdf @func_552fa >> listing.txt
pdf @func_5530c >> listing.txt
pdf @func_5533c >> listing.txt
pdf @func_5535a >> listing.txt
pdf @func_55376 >> listing.txt
pdf @func_5538e >> listing.txt
pdf @func_553aa >> listing.txt
pdf @func_553ba >> listing.txt
pdf @func_553c8 >> listing.txt
pdf @func_553dc_gfx >> listing.txt
pdf @func_55408_gfx >> listing.txt
pdf @func_55428_dummy >> listing.txt
pdf @func_55706 >> listing.txt
pdf @func_559c8 >> listing.txt
pdf @func_55a2c >> listing.txt
pdf @ambe_55a94 >> listing.txt
pdf @func_55ad8 >> listing.txt
pdf @func_55ba0 >> listing.txt
pdf @func_55bf0 >> listing.txt
pdf @func_55c78 >> listing.txt
pdf @func_55cc8 >> listing.txt
pdf @func_55d18 >> listing.txt
pdf @func_55dac >> listing.txt
pdf @func_55df0_unknown_end >> listing.txt
pdf @func_56b4c >> listing.txt

pdf @func_5709c >> listing.txt
pdf @func_5715c >> listing.txt
pdf @func_573ac >> listing.txt
pdf @func_573b6 >> listing.txt
pdf @func_5742c >> listing.txt
pdf @func_574b4 >> listing.txt
pdf @func_574bc >> listing.txt
pdf @func_574cc >> listing.txt
pdf @func_5753c >> listing.txt
pdf @func_5763c >> listing.txt
pdf @func_5767c >> listing.txt
pdf @func_57850 >> listing.txt
pdf @func_579cc >> listing.txt
pdf @func_579ce >> listing.txt
pdf @func_57a5c >> listing.txt
pdf @func_57a8c >> listing.txt
pdf @func_57ad0 >> listing.txt
pdf @func_57ba8 >> listing.txt
pdf @func_57dac >> listing.txt
pdf @func_57e04 >> listing.txt
pdf @func_57e8c >> listing.txt
pdf @func_57f10 >> listing.txt
pdf @func_57f38 >> listing.txt
pdf @func_57f62 >> listing.txt

pdf @func_58018 >> listing.txt
pdf @func_58094 >> listing.txt
pdf @func_580d8 >> listing.txt
pdf @ambe_58110 >> listing.txt
pdf @ambe_58554 >> listing.txt
pdf @func_587f4 >> listing.txt
pdf @func_58880 >> listing.txt
pdf @func_58940 >> listing.txt
pdf @func_58980 >> listing.txt
pdf @func_58a00 >> listing.txt
pdf @func_58b00 >> listing.txt
pdf @func_58c00 >> listing.txt
pdf @func_58c80 >> listing.txt
pdf @func_58cc0 >> listing.txt
pdf @func_58d80 >> listing.txt
pdf @func_58dc0 >> listing.txt

pdf @func_59080 >> listing.txt
pdf @func_591a0 >> listing.txt
pdf @func_59a48 >> listing.txt
pdf @func_59aee >> listing.txt
pdf @func_59c40 >> listing.txt
pdf @func_59cc0 >> listing.txt


# USB ("API" layer)
pdf @usb_setcallbacks >> listing.txt
pdf @usb_send_packet >> listing.txt
pdf @usb_do_setup >> listing.txt
pdf @usb_dnld_handle >> listing.txt
pdf @usb_upld_handle >> listing.txt # another ugly monster
pdf @usb_dfu_write >> listing.txt
pdf @usb_dfu_read >> listing.txt
pdf @usb_serialnumber >> listing.txt

# Low-level I/O stuff
pdf @GPIO_Init >> listing.txt # compiled from stm32f4xx_gpio.c ?
pdf @GPIO_ReadInputDataBit >> listing.txt
pdf @GPIO_SetBits >> listing.txt
pdf @GPIO_ResetBits >> listing.txt
pdf @GPIO_WriteBit >> listing.txt
pdf @GPIO_ReadInputData >> listing.txt
pdf @GPIO_PinAFConfig >> listing.txt

pdf @TIM_GetCounter >> listing.txt
pdf @TIM_SetCounter >> listing.txt
pdf @TIM_SetAutoreload >> listing.txt
pdf @TIM_ClearFlag >> listing.txt

# C5000 'baseband chip', functions roughly ordered by address
pdf @c5000_spi0_writereg >> listing.txt
pdf @c5000_spi0_readreg >> listing.txt
pdf @c5000_spi0_writereg_1 >> listing.txt
pdf @c5000_spi0_readreg_maybe >> listing.txt
pdf @c5000_set_local_addr >> listing.txt
pdf @c5000_set_local_addr2 >> listing.txt
pdf @c5000_some2 >> listing.txt
pdf @c5000_some3 >> listing.txt

pdf @dmr_call_start >> listing.txt
pdf @dmr_before_squelch >> listing.txt
#pdf @dmr_sms_arrive >> listing.txt # too long, and not very interesting
pdf @dmr_call_end >> listing.txt
pdf @dmr_CSBK_handler >> listing.txt

# Real Time Clock
pdf @md380_RTC_GetDate >> listing.txt
pdf @md380_RTC_GetTime >> listing.txt
pdf @rtc_sub1 >> listing.txt # 0x802b70e

pdf @func_591bc >> listing.txt
pdf @func_59228 >> listing.txt
pdf @func_59252 >> listing.txt
pdf @func_59268 >> listing.txt
pdf @func_59276 >> listing.txt
pdf @func_5930c >> listing.txt
pdf @func_59366 >> listing.txt
pdf @func_593ac >> listing.txt
pdf @func_593ea >> listing.txt
pdf @func_59430 >> listing.txt
pdf @func_59476 >> listing.txt
pdf @func_5948a >> listing.txt
pdf @func_594a0 >> listing.txt
pdf @func_594b8 >> listing.txt
pdf @func_59510 >> listing.txt
pdf @func_59560 >> listing.txt
pdf @func_596c8 >> listing.txt
pdf @func_597f0 >> listing.txt
pdf @func_59848 >> listing.txt
pdf @func_59908 >> listing.txt
pdf @func_59940 >> listing.txt
pdf @func_59976 >> listing.txt
pdf @func_59a14 >> listing.txt
pdf @func_59a8c >> listing.txt
pdf @func_59aa8 >> listing.txt
#0x8059b02 40 usb_send_packet
pdf @func_59b2a >> listing.txt
pdf @func_59b40 >> listing.txt
pdf @func_59b68 >> listing.txt
pdf @func_59b7e >> listing.txt
pdf @func_59ba2 >> listing.txt
pdf @func_59c00 >> listing.txt
pdf @func_59c40 >> listing.txt
pdf @func_59cc8 >> listing.txt
pdf @func_59d40 >> listing.txt
pdf @func_59ec0 >> listing.txt

pdf @func_5a080 >> listing.txt
pdf @func_5a0dc >> listing.txt
pdf @func_5a190 >> listing.txt
pdf @func_5a1b4 >> listing.txt
pdf @func_5a298 >> listing.txt
pdf @func_5a3b8 >> listing.txt
pdf @func_5a418 >> listing.txt
pdf @func_5a4b0 >> listing.txt
pdf @func_5a4c4 >> listing.txt
pdf @func_5a530 >> listing.txt
pdf @func_5a570 >> listing.txt
pdf @func_5a5d8 >> listing.txt

pdf @func_5b6c0 >> listing.txt

pdf @func_5c8d4 >> listing.txt
pdf @func_5cd94 >> listing.txt
pdf @func_5dc40 >> listing.txt
pdf @func_5dcb8 >> listing.txt
pdf @func_5deb0 >> listing.txt
pdf @func_5dfc0 >> listing.txt
pdf @func_5dfc4 >> listing.txt
pdf @func_5e1d0 >> listing.txt
pdf @func_5e2b8 >> listing.txt
pdf @func_5e44c >> listing.txt
pdf @func_5e460 >> listing.txt
pdf @func_5e520 >> listing.txt
pdf @func_5e618 >> listing.txt
pdf @func_5e62c >> listing.txt
pdf @func_5ea58 >> listing.txt
pdf @func_5eaac >> listing.txt 

pdf @func_5f844 >> listing.txt
pdf @func_5f994 >> listing.txt
pdf @func_5ff60 >> listing.txt
pdf @func_6005c >> listing.txt
pdf @func_601c4 >> listing.txt
pdf @func_60374 >> listing.txt 
pdf @func_6054c >> listing.txt
pdf @func_61100 >> listing.txt
pdf @func_61120 >> listing.txt
pdf @func_61182 >> listing.txt
pdf @func_611c2 >> listing.txt
pdf @func_611ec >> listing.txt
pdf @func_612c6 >> listing.txt
pdf @func_6137c >> listing.txt
pdf @func_61394 >> listing.txt 
pdf @func_613ae >> listing.txt
pdf @func_613f4 >> listing.txt
pdf @func_6143c >> listing.txt
pdf @func_61472 >> listing.txt
pdf @func_6147c >> listing.txt
pdf @func_61490 >> listing.txt
pdf @func_614a2 >> listing.txt
pdf @func_614b2 >> listing.txt
pdf @func_61622 >> listing.txt
pdf @func_6167a >> listing.txt
pdf @func_616a6 >> listing.txt
pdf @func_616f0 >> listing.txt
pdf @func_61762 >> listing.txt
pdf @func_618c8 >> listing.txt
pdf @func_619ee >> listing.txt
pdf @func_61a2c >> listing.txt
pdf @func_61a6a >> listing.txt
pdf @func_61a78 >> listing.txt
pdf @func_61a8c >> listing.txt
pdf @func_61a9a >> listing.txt

pdf @func_62054 >> listing.txt
pdf @func_62148 >> listing.txt
pdf @func_62204 >> listing.txt
pdf @func_62334 >> listing.txt
pdf @func_62378 >> listing.txt
pdf @func_623c0 >> listing.txt
pdf @func_62416 >> listing.txt
pdf @func_62490 >> listing.txt
pdf @func_624e2 >> listing.txt
pdf @func_6250c >> listing.txt
pdf @func_62536 >> listing.txt
pdf @func_6267c >> listing.txt
pdf @func_62b28 >> listing.txt
pdf @func_62d84 >> listing.txt
pdf @func_62e94 >> listing.txt
pdf @func_62ee8 >> listing.txt
pdf @func_62f2c >> listing.txt
pdf @func_62fb4 >> listing.txt

pdf @func_631e0 >> listing.txt
pdf @func_63274 >> listing.txt 
pdf @func_633b0 >> listing.txt
pdf @func_633d4 >> listing.txt

pdf @func_8eab4 >> listing.txt
pdf @func_8f196 >> listing.txt
pdf @func_8f21a >> listing.txt
pdf @func_8ff00 >> listing.txt 

pdf @func_9010c >> listing.txt
pdf @func_90174 >> listing.txt
pdf @func_90184 >> listing.txt
pdf @func_901ec >> listing.txt
pdf @func_90258 >> listing.txt
pdf @func_902d0 >> listing.txt
pdf @func_902fa >> listing.txt
pdf @func_90324 >> listing.txt
pdf @func_903f6 >> listing.txt
pdf @func_90456 >> listing.txt

pdf @func_9399a >> listing.txt
pdf @func_939e2 >> listing.txt
pdf @func_93a6a >> listing.txt
pdf @func_93b5e >> listing.txt
pdf @func_93c28 >> listing.txt
pdf @func_93c44 >> listing.txt
pdf @func_93ce2 >> listing.txt
pdf @func_93d6a >> listing.txt
pdf @func_93e24 >> listing.txt
pdf @func_93e6e >> listing.txt
pdf @func_93e8a >> listing.txt
#pdf @func_93eb0 >> listing.txt # no valid code, bogus call somewhere

pdf @LED_Process >> listing.txt # 0x08095518

# Finally append a complete list of all 'known' symbols (outcomment if not needed) :
f >> listing.txt # 'f' (without args) lists all "flags". Kind of our symbol table... but too long