/*------------------------------------------------------------------*/
/*  File: C:\cbproj\YHF_Tools||SoundUtl\yhf_type.h                  */
/*  Purpose:   Data type definitions like DATA_TYPE_INT16 .         */
/*                                                                  */
/*  Used in various parts of DL4YHF's Spectrum Lab, but also in...  */
/*    * The "Sound Input" utilities,                                */
/*    * The "Curve Editor" (e.g. in module LoadSaveRawBinary.c)     */
/*    * ? ...                                                       */
/*                                                                  */
/*  Author:   Wolfgang Buescher,  DL4YHF .                          */
/*  Original: C:\CBproj\YHF_Tools\yhf_type.h (various copies exist) */
/*  Copies in C:\cbproj\SoundUtl\yhf_type.h                         */
/*                                                                  */
/* Revision History:                                                */
/*  June 2002:  first usage in DL4YHF's Spectrum Laboratory .       */
/*  Oct. 2002:  This header also used in various "sound utilities". */
/*  Jan. 2006:  Added DATA_TYPE_BOOL                                */
/*  Mar. 2006:  Added an empty trailing line for GNU-C (Dev-C++) .  */
/*                                                                  */
/*------------------------------------------------------------------*/


#ifndef _DATA_TYPES_H_
 #define _DATA_TYPES_H_ 1 /* revision code!*/

 #define DATA_TYPE_UNKNOWN  0  /* in some projects, used as dummy for "not set yet", */
                               /* or "try to guess the type" (in parameter iDataType)*/
 #define DATA_TYPE_INT8     1   /* signed 8-bit integer, range -128 .. +127 */
 #define DATA_TYPE_INT16    2   /* signed 16-bit integer, range -32768 .. +32767*/
 #define DATA_TYPE_INT32    3   /* signed 32-bit integer,  -2147483648 .. +2147483648 */
 #define DATA_TYPE_INT64    4   /* signed 64-bit, -9223372036854775808 .. +9223372036854775807 */
 #define DATA_TYPE_FLOAT32  5   /* same as "float" in C */
 #define DATA_TYPE_FLOAT64  6   /* same as "double" in C */
 #define DATA_TYPE_CSTRING  7   /* zero-terminated string of characters, as in C */
 #define DATA_TYPE_UINT8    8   /* unsigned 8 bit formerly known as "BYTE" */
 #define DATA_TYPE_BOOL     9   /* "BOOL" (not Borland's "boolean" ! )     */
 #define DATA_TYPE_USER1    10

 // Machine dependent and "compatibility" defs:
 #define DATA_TYPE_INT      DATA_TYPE_INT32
 #define DATA_TYPE_LONG     DATA_TYPE_INT32
 #define DATA_TYPE_DOUBLE   DATA_TYPE_FLOAT64



 // Unions for byte-wise accessable 16-, 32-, and 64-bit quantities.
 //  Borrowed from DL4YHF's pic\dsPIC33_Drivers\LowLevelTypes.h in 2022-10 :
#ifndef _WB_UNIONS
 #define _WB_UNIONS

#ifdef __BORLANDC__
# ifndef __STDINT_H   // don't waste compilation time if already included...
#  include <stdint.h> // farewell, good old 'WORD'; hello, ugly new 'uint16_t' .
# endif
#endif

// If XC16 complains "error: expected '=', ',', ';', 'asm' or '__attribute__' before 'typedef'" below,
//         the root cause may be in the "C" module, or another header file,
//         which INCLUDED this header. You can spend hours to find the REAL error location.
//   Other compilers (like the stoneage Borland C) were MUCH smarter than XC16 !
typedef union {  // Alternative to a 16-bit WORD or 'short' integer :
    uint8_t  b[2]; // as indices, use BW_LO or BW_HI (to avoid trouble with endianness)
    int8_t  sb[2]; // .. similar as above, but two SIGNED 8-bit members
    int16_t  i16;  // 16 bit signed
    uint16_t u16;  // 16 bit unsigned (alternative name for 'WORD')
    uint16_t w;    // 16 bit unsigned (formerly known as WORD, until NXP hijacked it)
 } BWORD;    // BWORD = a byte-wise accessable 'WORD' (16 Bit)

typedef union {  // Alternative to a 32-bit 'DWORD' or 'long' integer :
    uint8_t b[4]; // as indices, use BL_LO, BL_ML, BL_MH or BL_HI !
    BWORD   w[2]; // .. similar as TWO 16-bit-wise accessable WORDs [BL_LW] [BL_HW]
    int32_t i32;  // access the entire 32-bit thing as a SIGNED 32-bit integer
    uint32_t dw;  // commonly used under windoze : "DWORD" (added 2004-10)
    uint32_t u32; // preferred by some other folks (added 2009-04)
    float flt;    // added 2004-04-01, use this to combine 4 bytes
                  //  into a 32-bit-FLOAT value a la IEE 754-1985 .
 } BLONG;

#if( !defined __XC8 ) // not for "XC8" (8-bit PICs) :
// 64-bit union to rip 'double' into EIGHT BYTES (don't try this on PIC10/12/16!)
typedef union {     // byte- and word- wise accessable type "double" (64 Bit)
    uint8_t  b[8];  // byte-wise access (e.g. for mapping into and from CAN-messages)
                    // Use IEEE754_DBL_MANTISSA_LO ... IEEE754_DBL_EXPONENT_HI as index,
                    // or (if the 8-byte-quantity is a 64-bit INTEGER)
                    // use BDOUBLE_I64_LO .. BDOUBLE_I64_HI as index.
    BWORD    w[4];   // 16-bit '[B]WORD'-wise access. Use BL_LO, BL_ML, BL_MH, BL_HI as index.
    BLONG    bl[2];  // 32-bit '[B]LONG'-wise access. Use BDOUBLE_LO or BDOUBLE_HI as index.
    int32_t  i32[2]; // 32-bit 'signed integer'-wise access. Use BDOUBLE_LO or BDOUBLE_HI as index.
    uint32_t u32[2]; // 32-bit 'DWORD'-wise access. Use BDOUBLE_LO or BDOUBLE_HI as index.
#     define BDOUBLE_LO 0 // index into BDOUBLE.i32 or u32 for the LOWER 32 bits of a 64-bit integer
#     define BDOUBLE_HI 1 // index into BDOUBLE.i32 or u32 for the UPPER 32 bits of a 64-bit integer
    double  dbl;     // <- use this to combine 8 bytes into a 64-bit-DOUBLE value a la IEE 754-1985 .
    int64_t i64;     // <- for 64-bit-INTEGER-bit-fiddling .. DON'T TRY THIS ON A PIC !

    // This UNION could also be used for SINGLE-precision COMPLEX numbers.
    // Let's reserve flt[0] for the real, and flt[1] for the imaginary part:
    float flt[2];
 } BDOUBLE; // <- 64-bit union to rip 'double' into EIGHT BYTES . Don't try this on a PIC16 !
#endif // not "XC8" (8-bit PICs) ?

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Definitions for the BYTE ORDER within types BWORD (16 bit) and BLONG (32 bit)
#if (defined __WIN32__) || (defined  __CA__) || (defined __ARMCC_VERSION) // Win32 or some ARM compiler ? 'int' is 32 bit !

// 8086, Intel : little-endian format, least significant byte first ..
# define BW_LO 0     // Byte-Offsets zur Adressierung eines 16-bit WORDS
# define BW_HI 1

# define BL_LO 0     // Byte-Offsets for 32-bit integer types
# define BL_ML 1     // middle low
# define BL_MH 2     // middle high
# define BL_HI 3     // high 

# define BL_LW 0     // two 16-bit halves of a 32-bit integer type
# define BL_HW 1     // ( BLONG.w[BL_HW] = "high word", etc )

#elif ( defined __C51__ ) // knnte der Keil-Compiler fuer 8051 sein ... :
  // 8051 etc : big-endian format, most significant byte first .. PFUI DEIBEL !
# define BW_LO 1    // Byte-Offsets zur Adressierung eines 16-bit WORDS
# define BW_HI 0    // (dient als Index beim Byte-Weisen Zugriff auf BWORD)

# define BL_LO 3    // Byte-Offsets for 32-bit integer types
# define BL_ML 2    // middle low
# define BL_MH 1    // middle high
# define BL_HI 0    // high

# define BL_LW 1     // two 16-bit halves of a 32-bit integer type
# define BL_HW 0     // ( BLONG.w[BL_HW] = "high word", etc )

#elif( defined __XC8 ) // > "Always Indicates MPLAB XC compiler for Microchip 8-bit devices in use."..
       
  // PIC10/12/16 : At least for XC8-managed integer types, little-endian .
# define BW_LO 0     // Byte-Offsets within a 16-bit WORD (PIC, Variables in RAM)
# define BW_HI 1

# define BL_LO 0     // Byte-Offsets for 32-bit integer types
# define BL_ML 1     // middle low
# define BL_MH 2     // middle high
# define BL_HI 3     // high 

# define BL_LW 0     // two 16-bit halves of a 32-bit integer type
# define BL_HW 1     // ( BLONG.w[BL_HW] = "high word", etc )

#elif( defined __XC16 ) // > "Always Indicates MPLAB XC compiler for Microchip 16-bit devices in use."..

  // dsPIC33 / PIC24 : Keep fingers crossed that Microchip hasn't re-invented the wheel again..
# define BW_LO 0     // Byte-Offsets within a 16-bit WORD (dsPIC, Variables in RAM)
# define BW_HI 1

# define BL_LO 0     // Byte-Offsets for 32-bit integer types
# define BL_ML 1     // middle low
# define BL_MH 2     // middle high
# define BL_HI 3     // high 

# define BL_LW 0     // two 16-bit halves of a 32-bit integer type
# define BL_HW 1     // ( BLONG.w[BL_HW] = "high word", etc )

#else  // neither compiling for a windows-PC, ARM/Cortex, nor 8051, nor PIC ...
# error "Please add support for yet another C compiler (or target) HERE !"
#endif

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Definitions for the BYTE ORDER when placing 64-bit INTEGERS in memory :
#define BDOUBLE_I64_LO 0  /* least significant byte in a 64-bit integer (bits 7..0) */
#define BDOUBLE_I64_M1 1  /* bits 15..8 in a 64-bit integer */
#define BDOUBLE_I64_M2 2  /* bits 23..16 in a 64-bit integer */
#define BDOUBLE_I64_M3 3  /* bits 31..24 in a 64-bit integer */
#define BDOUBLE_I64_M4 4  /* bits 39..32 in a 64-bit integer */
#define BDOUBLE_I64_M5 5  /* bits 47..40 in a 64-bit integer */
#define BDOUBLE_I64_M6 6  /* bits 55..48 in a 64-bit integer */
#define BDOUBLE_I64_HI 7  /* bits 63..56 in a 64-bit integer */


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Definitions for the BYTE ORDER when placing FLOATS in memory :
#ifdef __BORLANDC__  // Borland: Couldn't find a detailed description of a 'float' in memory,
  //   but it seems to follow INTELs little-endian way ('low-byte first').
# define IEEE754_MANTISSA_LO         0
# define IEEE754_MANTISSA_MID        1
# define IEEE754_MANTISSA_HI         2
# define IEEE754_EXPONENT            3
  // Byte-offsets for a DOUBLE PRECISION float a la IEEE 754 :
# define IEEE754_DBL_MANTISSA_LO     0  /* least significant bits of the 52-bit mantissa, aka "fraction" */
# define IEEE754_DBL_MANTISSA_MID_1  1
# define IEEE754_DBL_MANTISSA_MID_2  2
# define IEEE754_DBL_MANTISSA_MID_3  3
# define IEEE754_DBL_MANTISSA_MID_4  4
# define IEEE754_DBL_MANTISSA_HI     5
# define IEEE754_DBL_EXPONENT_LO     6  /* lower parts of the exponent, and a few UPPER bits of the mantissa */
# define IEEE754_DBL_EXPONENT_HI     7  /* eight UPPER bits of the 11-bit exponent */
#endif // Borland C++ ,  INTEL CPU,  and a few non-brain-damaged C compilers for ARM/Cortex ?


#endif // _WB_UNIONS



#endif
/* EOF <yhf_type.h> . Note: GNU C needs an empty line after this ! */


