//---------------------------------------------------------------------------
//
// File  : C:\cbproj\YHF_Tools\wsock.h
// Author: Wolfgang Buescher (DL4YHF)
// Date  : 2006-03-16
// Compiler: Borland C++Builder V4
//
// Description:  see WSOCK.C !
//  Wrapper between application and SOCKET SERVICES to communicate via IP
//    ( UDP, or maybe TCP ) .
//
// Revision History:
//  2005-06-10 : Created as an experiment (in ..\Winsock_Experiments )
//  2006-03-16 : Moved from ..\Winsock_Experiments to ..\YHF_Tools ,
//               now used to send audio messages via UDP in Spectrum Lab .
//             + Found an excellent "Winsock" tutorial at www.c-worker.ch .
//               Locally saved as \Literat1\Network_Programming\*.txt .
//  2006-11-06 : Now used in SpecLab's tiny built-in web server too .
//---------------------------------------------------------------------------

#ifndef CPROT
// Note on "extern": do not trust the lousy example from Borland !!
//   >extern "c" = nonsense (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif

//---------------------------------------------------------------------------
// Defines
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//  Some defines which MAY be missing in winsock.h,
//              others may be missing in winsock2.h :
//---------------------------------------------------------------------------

#ifndef  SD_RECEIVE       /* from WinSock2: constants for shutdown() ... */
 #define SD_RECEIVE 0x00
#endif
#ifndef  SD_SEND
 #define SD_SEND    0x01
#endif
#ifndef  SD_BOTH
 #define SD_BOTH    0x02
#endif



#define WSOCK_MAX_SERVERS 10
#define WSOCK_MAX_CLIENTS 10

#ifdef __WIN32__
 #define WM_WINSOCK_SRV ( WM_USER + 123) /* special message for SERVER indicating a socket is ready */
 #define WM_WINSOCK_CLI ( WM_USER + 124) /* special message for SERVER indicating a socket is ready */
 #define WM_WINSOCK_HTTP_ASYNC  (WM_USER+125) /* used in HTTP SERVER for WSAAsyncSelect()      */
 #define WM_WINSOCK_HTTP_APPMSG (WM_USER+126) /* message sent from HTTP SERVER to application  */
 #define WM_WINSOCK_AVTCP_SRV   (WM_USER+127) /* msg from winsock for AudioViaTCP, SERVER-side */
 #define WM_WINSOCK_AVTCP_CLI   (WM_USER+128) /* msg from winsock for AudioViaTCP, CLIENT-side */
 #define WM_WINSOCK_VORBIS_SRV  (WM_USER+129) /* msg from winsock for VorbisStreamServer.cpp   */
#endif // __WIN32__

#ifdef __WIN32__
 #define WSOCKET unsigned int       // for windows socket services
 // In this case, WSOCKET_INVALID must be the same as INVALID_SOCKET from winsock.h
 #define WSOCKET_INVALID (WSOCKET)(~0) /* instead of -1, since the SOCKET type is unsigned */
 #define WSOCK_ERROR       (-1)        /* same as SOCKET_ERROR from winsock.h */
#else
 #define WSOCKET WORD               // for microcontroller firmware
 #define WSOCKET_INVALID 0xFFFF
 #define WSOCK_ERROR     (-1)
#endif
#define WSOCK_BUFFER_FULL  (-2)    /* proprietary result code for "buffer too full" */
#define WSOCK_BUFFER_EMPTY (-3)    /* proprietary result code for "buffer too full" */

// Timeout stuff
#define WSOCK_TIMER_ID   42
#define WSOCK_TIMEOUT_MS 3000       // milliseconds

// Connection states...
#define WSOCK_CS_UNUSED_ENTRY  0
#define WSOCK_CS_DISCONNECTED  1
#define WSOCK_CS_CONNECTING    2
#define WSOCK_CS_CONNECTED     3
#define WSOCK_CS_DISCONNECTING 4

// Data types
typedef struct
{
  WSOCKET peer_socket;
  int     iConnState;              // WSOCK_CS_ xxx
} T_WSOCK_Server;


typedef struct
{
  WSOCKET socket;
  int     iConnState;
} T_WSOCK_Client;



//---------------------------------------------------------------------------
// Global variables for the WSOCK-routines (implemented in WSOCK.C)
//---------------------------------------------------------------------------
extern BOOLEAN WSOCK_fLogEvents ;  // log communication events (connect, disconnect,...) ?
extern BOOLEAN WSOCK_fLogWinMsgs;  // log windows messages (sent by WINSOCK) ?
extern BOOLEAN WSOCK_fLogErrors ;  // log error messages ? (TRUE by default)
extern int     WSOCK_iLastWSError;
extern WSOCKET WSOCK_ServerListenerSocket;
extern T_WSOCK_Client WSOCK_Clients[WSOCK_MAX_CLIENTS];
extern T_WSOCK_Server WSOCK_Servers[WSOCK_MAX_SERVERS];

//---------------------------------------------------------------------------
// Prototypes for WSOCK-routines implemented in WSOCK.C
//---------------------------------------------------------------------------

CPROT BOOLEAN WSOCK_Init( HWND hwndMainWindow );
CPROT void    WSOCK_Exit(void);   // cleans up. Call once on exit
CPROT char  * WSOCK_ErrorCodeToString( int iWSAErrorCode );
CPROT BOOLEAN WSOCK_GetOwnName( char *pszMyName, int iMaxLen );
CPROT BOOLEAN WSOCK_GetOwnIPaddress(char *psz20MyIPaddressAsString );
CPROT BOOLEAN WSOCK_GetIPaddressByName(char *pszHisName,char *psz20HisIPaddressAsString );

CPROT BOOLEAN WSOCK_SRV_EstablishListener(WSOCKET *pSocket, unsigned short portnum);

CPROT T_WSOCK_Client * WSOCK_AddClient( void );
CPROT void    WSOCK_DeleteClient( T_WSOCK_Client *pClient );
CPROT void    WSOCK_DisconnectClient( T_WSOCK_Client *pClient );
CPROT BOOLEAN WSOCK_CLI_BeginConnect( T_WSOCK_Client *pClient, char *hostname_or_addr, unsigned short wHisPortNumber);
CPROT int     WSOCK_CLI_BeginToSend( T_WSOCK_Client *pClient, BYTE *pbSrc, int iLen );

//CPROT int     WSOCK_BeginToSend( WSOCKET socket, BYTE *pbSrc, int iLen );
CPROT int     WSOCK_Receive( WSOCKET socket, BYTE *pbDestSrc, int iMaxLen );
CPROT BOOLEAN WSOCK_Disconnect( WSOCKET *pSocket );

#ifdef __WIN32__
 // Message handlers for WM_WINSOCK_SRV  and  WM_WINSOCK_CLI :
 CPROT void WSOCK_SRV_HandleMessage(HWND hwnd, WPARAM wParam, LPARAM lParam);
 CPROT void WSOCK_CLI_HandleMessage(HWND hwnd, WPARAM wParam, LPARAM lParam);
#endif // __WIN32__

//---------------------------------------------------------------------------
// Prototypes for WSOCK-routines ("fixed callbacks") in the user application
//---------------------------------------------------------------------------
      // Error- and event log...
CPROT void WSOCK_LogError( char * pszText, int nErrorCode);
CPROT void WSOCK_LogEvent( char * pszFormat, ... );

      // Client...
CPROT void WSOCK_CLI_OnConnect( T_WSOCK_Client *pClient );
CPROT void WSOCK_CLI_OnDisconnect( T_WSOCK_Client *pClient, int iErrorCode );
CPROT void WSOCK_CLI_OnWrite( T_WSOCK_Client *pClient ); // notification of readiness for writing ("may send now")
CPROT void WSOCK_CLI_OnRead ( T_WSOCK_Client *pClient );

      // Server...
CPROT BOOLEAN WSOCK_SRV_OnConnect( T_WSOCK_Server *pServer );
CPROT void WSOCK_SRV_OnDisconnect( T_WSOCK_Server *pServer, int iErrorCode );
CPROT void WSOCK_SRV_OnWrite( T_WSOCK_Server *pServer );
CPROT void WSOCK_SRV_OnRead ( T_WSOCK_Server *pServer );


