/***************************************************************************/
/*  c:\CBproj\SoundUtl\utility2.cpp :                                      */
/*  - Small variant of "utility1", without "housekeeping" for malloc+free  */
/*  - MODULE PREFIX "UTL" ..   for historic reasons                        */
/* Used in the small AUDIO UTILITIES instead of "utility1" .               */
/***************************************************************************/

#include <stdlib.h>

 // > SoundUtl/utility2.cpp is the small brother of utility1; both use THE SAME header file:
#include "utility1.h"


/***************************************************************************/
void *UTL_malloc(DWORD size)
   // Replacement for malloc(),
   //  with additional housekeeping for debugging purposes .
   // Caution: not 100% thread-safe, but no big issue.. !
{
  return malloc(size);
}


/***************************************************************************/
void *UTL_NamedMalloc( char *pszMemoryBlockName, DWORD size)
{
  pszMemoryBlockName = pszMemoryBlockName; // unused in this miniature variant
  return UTL_malloc(size);
}


/***************************************************************************/
void UTL_free(void * block)
   // Replacement for malloc(),
   //  with additional housekeeping for debugging purposes
{
  if( block!=NULL )
   {
     free(block);
   }
}

/* EOF <utility2.cpp> */

