//
// File:  \cbproj\DLL_with_Classes\dllimpex.h
// Copy:  \cbproj\YHF_Tools\dllimpex.h , \cbproj\paintlib\dllimpex.h 
// Date:  2009-11-23
// Author: Wolfgang Buescher (DL4YHF)
// Purpose: Helper macros to BUILD and IMPORT functions and classes in a DLL .
//       BUILDING_THE_DLL must be defined (somewhere under Options..Compiler)
//       when BUILDING THE DLL; otherwise undefined .
#ifdef BUILDING_THE_DLL
# define DLLIMPEX __declspec(dllexport)  /* here: DLLIMPEX = DLL EXPORT */
#else
# define DLLIMPEX __declspec(dllimport)  /* here: DLLIMPEX = DLL IMPORT */
#endif

// How to use this DLLIMPEX thing, taken from a document by Microsoft (!) :
// > Zum Exportieren von Funktionen muss das __declspec(dllexport)-Schlsselwort
// > links neben dem Schlsselwort fr die Aufrufkonvention stehen,
// > sofern ein Schlsselwort angegeben wird. Beispiel:
// >
// > __declspec(dllexport) void __cdecl Function1(void);
// Forget about __cdecl (it doesn't defeat C++ name mangling anyway);
// so, in this case: DLLIMPEX void Function1(void) ;
//
// > Um alle ffentlichen Datenmember und Memberfunktionen einer Klasse
// > zu exportieren, muss das Schlsselwort, wie im nachfolgenden Beispiel
// > dargestellt, links vom Klassennamen erscheinen:
// > class __declspec(dllexport) CExampleExport : public CObject
// > { ... class definition ... };
//
// Glcklicherweise funktioniert das, was oben von Microsoft beschrieben wurde,
// auch mit Borland C++ Builder. Allerdings ist es nicht (ohne weiteres)
// mglich, eine mit Borland erzeugte DLL (mit C++-Klassen) in einem
// Microsoft-Visual-Irgendwas - Projekt zu verwenden, und umgekehrt.
//    (das funktioniert wegen des ekelhaften, Compiler-Hersteller-spezifischen
//     C++-"Name Mangling" nur mit C-Funktionen, wre da nicht die grauenhafte,
//     unterschiedliche Behandlung von _cdecl durch Borland und Microsoft .. )
//  Egal, wir ERZEUGEN die DLL mit Borland, und VERWENDEN sie mit Borland,
//        also kein Problem, oder wie, oder was ?
//
// Um die Funktionen in der DLL ohne 'LoadLibrary' / 'GetProcAddress'-Klamauk
// nutzen zu knnen, muss die vom C++Builder erzeugte 'Import Library',
// z.B. DLL_Building_Project.lib,  mit in das Projekt aufgenommen werden,
// welches die Klassen (und, eventuell, "normalen" C-Funktionen) in der DLL
// verwendet.  Beispiel fr ein derartiges (Borland-)Projekt:
//  c:\cbproj\DLL_with_Classes\DLL_Testing_Project.bpr .
//
//

/* EOF < dllimpex.h > */


