/***************************************************************************/
/* File:   ..\SoundUtl\crosscorr.c                                         */
/* Purpose: header for the "cross-correlator" in SpecLab .                 */
/* Date:   2004-10-17  (ISO 8601, YYYY-MM-DD)                              */
/* Author: Wolfgang Buescher (DL4YHF)                                      */
/* Module prefix: "CORR" = CORRelation routines                            */
/*   - C implementation by DL4YHF October 2004                             */
/*   - Started as an experiment, usefullness to be proved yet ..           */
/*   - Using as little BORLAND-specific stuff as possible in here !        */
/***************************************************************************/

#ifndef _CROSSCORR_H_
#define _CROSSCORR_H_

#undef EXTERN
#ifdef _I_AM_CROSSCORR_  /* for single-source-variables in this header */
  #define EXTERN
#else
  #define EXTERN extern
#endif


/*----------- constants & defines ----------------------------------------*/


#ifndef  C_PI
 #define C_PI  (3.1415926535897932384626)
#endif


/*----------- data types -------------------------------------------------*/

#ifndef T_Float   // prefer single- or double-precision floats ?
#if SWI_FLOAT_PRECISION==1
 #define T_Float float
#else
 #define T_Float double
#endif
#endif // ndef T_Float



/*----------- imports from unknown external modules ----------------------*/



/*----------- variables --------------------------------------------------*/



/*----------- function prototypes ----------------------------------------*/

/***************************************************************************/
void CORR_Init(void);

/***************************************************************************/
BOOL CORR_ProcessFFTResult(  // Calculates CORRELATION COEFFICIENTS using the FFT method
         T_SPECTRUM *pDestSpectrum,  // destination structure
         int   iNrOfFftBins, // count of FFT bins in each of the two INPUT CHANNELS
         float *pfltFftBins, // input from first FFT channel (usually "L" = E-field-antenna)
         float *pfltInput2,  // input from second FFT channel (usually "R"= H-field-pair)
         double dblSampleRate,  // parameters....
         double dblTimeOfRecording );


#endif // _CROSSCORR_H_
