/***************************************************************************/
/* File:   ..\SoundUtl\crosscorr.c                                         */
/* Purpose: header for the "cross-correlator" in SpecLab .                 */
/* Date:   2004-10-17  (ISO 8601, YYYY-MM-DD)                              */
/* Author: Wolfgang Buescher (DL4YHF)                                      */
/* Module prefix: "CORR" = CORRelation routines                            */
/*   - C implementation by DL4YHF October 2004                             */
/*   - Started as an experiment, usefullness to be proved yet ..           */
/*   - Using as little BORLAND-specific stuff as possible in here !        */
/***************************************************************************/

#include "SWITCHES.H"
#include <windows.h>     // stuff like WORD, DWORD, etc

#pragma hdrstop
#pragma warn -8004       // <blabla is a assigned a value that is never used> - no thanks

#include "SpecBuff.h"    // definition of type T_SPECTRUM (for buffering)
#include "Sound.h"       // some data types used in DigiMode.h
#include "SoundThd.h"    // requires T_FILTER_DATA and other goodies
#include "SoundMaths.h"  // some frequently used math subroutines
#include "SoundTab.h"    // SoundTab_fltCosTable[] etc

#define _I_AM_CROSSCORR_ 1  // for single-source-variables in this header :
#include "crosscorr.h"   // Cross Correlation module (using the FFT method)

/***************************************************************************/
void CORR_Init(void)
{

} // end CORR_Init()



/***************************************************************************/
BOOL CORR_ProcessFFTResult(
         T_SPECTRUM *pDestSpectrum,  // destination structure
         int   iNrOfUsableFftBins,   // how many FFT bins can really be used ?
         float *pfltFftCh1, // input from first FFT channel (usually "L" = E-field-antenna)
         float *pfltFftCh2, // input from second FFT channel (usually "R"= H-field-pair)
                // Note: both input channels are NORMALIZED VOLTAGES to +/-1.0 for full ADC swing
         double dblSampleRate,       // parameters....
         double dblTimeOfRecording,
         double dblAmplitudeOffset,
    T_CFG_FFT_PROCESSOR *pFftParams  // source info: all relevant FFT processor settings
          )
 /* Similar to CLI_MakeTCliSpectrum() in Spectrum Lab .. actually called from there .
  * Fills all components of a T_SPECTRUM(!) - structure which is abused here
  * to return the cross correlation coeffs to the caller.
  *
  *
  * Note: The forward FFT for both channels with COMPLEX OUTPUT
  *       has alreday been done when calling this routine !
  *  Detailed information about how to calculate the correlation factors
  *  between two signals (-> crosscorrelation) or the similarity between
  *  a signal with a delayed copy of itself (-> autocorrelation)
  *  can be found in the book "Numerical Recipes in C",
  *  locally saved as C:\Literat1\Numerical_Recipes_in_C\*.pdf .
  *
  *
  *  Inputs: pfltFftCh1[] = FFT bins, channel 1, contains a COMPLEX SPECTRUM !
  *          pfltFftCh1[] = FFT bins, channel 2, contains a COMPLEX SPECTRUM !
  *          dblTimeOfRecording = current time of recording/sampling
  *                                (MILLISECONDS since Jan 1970)
  *          dblSampleRate      = current sampling rate of the audio source
  *                                (may be 'calibrated' for high precision)
  *          pFftParams         = many other "internal" parameters for
  *                               FFT calculation (part of configuration)
  *  Output: pDestSpectrum->xyz (header + data for result buffer)
  */
{


} // end CORR_ProcessFFTResult()
