/****************************************************************************/
/* YHF_OpenDlg.cpp: File Open Dialog     by  Wolfgang Buescher (DL4YHF) .   */
/*               NO APPLICATION-SPECIFIC STUFF, AND NO VCL IN HERE !        */
/*               This unit is used in a number of projects (see history).   */
/*                                                                          */
/* Author and Copyright by:                                                 */
/*   Wolfgang Buescher (DL4YHF)                                             */
/* Original file location: <Penti4>C:\CBproj\YHF_Tools\YHF_OpenDlg.cpp      */
/*                                                                          */
/* Revision History:                                                        */
/*  V1.0, 2002-03-13:  Created for DL4YHF's "Spectrum Lab".                 */
/****************************************************************************/

#include <windows.h>
#include <ShlObj.h>

#pragma hdrstop   // Borland Stuff. No precompiled headers after this.

#include "YHF_OpenDlg.h"   // header file for this module



//---------------- Internal and initialized variables -----------------------
char YHF_OpenDlg_szLastError[256]= "--"; // only valid if last call failed !

//---------------- Implementation of routines -------------------------------


/****************************************************************************/
BOOL YHF_FILE_OpenDlg( HWND hwndParentWindow, // [in]
                       char *pszDefaultExt,  // [in] default extension
                       char *pszzFilter,     // [in]
                       char *pszInitialDir,  // [in]
                       char *pszTitle,       // [in]
        char *pszFileName, int iMaxLength )  // [in,out]
  // Runs the windows "Open File" dialog . From Win32 programmer's reference:
  // pszzFilter:
  //   Pointer to a buffer containing pairs of null-terminated filter strings.
  //   The last string in the buffer must be terminated by two NULL characters.
  //   The first string in each pair is a display string that describes the filter
  //   (for example, "Text Files"), and the second string specifies the filter pattern
  //   (for example, "*.TXT"). To specify multiple filter patterns for a single
  //   display string, use a semicolon to separate the patterns
  //   (for example, "*.TXT;*.DOC;*.BAK"). A pattern string can be a combination
  //   of valid filename characters and the asterisk (*) wildcard character.
  //   Do not include spaces in the pattern string.
  //   The operating system does not change the order of the filters.
  //   It displays them in the File Types combo box in the order specified in lpstrFilter.
  //   If lpstrFilter is NULL, the dialog box does not display any filters.
{
 OPENFILENAME ofn;
 char szFile[MAX_PATH+4];
 BOOL fResult = FALSE;
 int n;

  memset( &ofn, 0, sizeof(OPENFILENAME) );
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner   = hwndParentWindow;
  ofn.hInstance   = NULL;
  ofn.lpstrFilter = pszzFilter;
  ofn.lpstrCustomFilter = NULL;
  ofn.nMaxCustFilter = 0;
  ofn.nFilterIndex   = 0;
  n = iMaxLength;
  if( n>MAX_PATH ) n=MAX_PATH;
  strncpy( szFile, pszFileName, n );
  szFile[MAX_PATH] = '\0';
  ofn.lpstrFile = szFile;
  // About ofn.lpstrFile :
  //   Pointer to a buffer that contains a filename used to initialize the
  //   File Name edit control. The first character of this buffer must be
  //   NULL if initialization is not necessary. When the GetOpenFileName
  //   or GetSaveFileName function returns successfully, this buffer contains
  //   the drive designator, path, filename, and extension of the selected file.
  // If the OFN_ALLOWMULTISELECT flag is set and the user selects multiple files,
  //   the buffer contains the current directory followed by the filenames
  //   of the selected files. For Explorer-style dialog boxes, the directory
  //   and filename strings are NULL separated, with an extra NULL character
  //   after the last filename. For old-style dialog boxes, the strings
  //   are space separated and the function uses short filenames for filenames
  //   with spaces. You can use the FindFirstFile
  //   function to convert between long and short filenames.
  //   If the buffer is too small, the function returns FALSE
  //   and the CommDlgExtendedError function returns FNERR_BUFFERTOOSMALL.
  //   In this case, the first two bytes of the lpstrFile buffer contain
  //   the required size, in bytes or characters.
  ofn.nMaxFile = MAX_PATH;
  // ofn.nMaxFile specifies the size, in bytes (ANSI version) or characters
  //   (Unicode version), of the buffer pointed to by lpstrFile.
  //   The GetOpenFileName and GetSaveFileName functions return FALSE
  //   if the buffer is too small to contain the file information.
  //   The buffer should be at least 256 characters long.
  ofn.lpstrFileTitle = NULL;
  // ofn.lpstrTileTile hasn't got anything to do with the FILESELECTOR TITLE !!
  // Instead:
  // > Pointer to a buffer that receives the filename and extension
  // > (without path information) of the selected file. This member can be NULL.
  ofn.nMaxFileTitle = 0;
  ofn.lpstrInitialDir = pszInitialDir;
  ofn.lpstrTitle = pszTitle; // string to be placed in the title bar of the dialog box
  ofn.Flags = OFN_FILEMUSTEXIST;
  // ofn.nFileOffset = ??;
  // ofn.nFileExtension = ??;
  ofn.lpstrDefExt = pszDefaultExt;
  // ofn.lCustData = ?;
  // ofn.lpfnHook;
  // ofn.lpTemplateName;

  if( GetOpenFileName(&ofn) )
   { fResult = TRUE;
     strncpy( pszFileName, szFile, iMaxLength );
   }

  return fResult; 

} // end YHF_FILE_OpenDlg()

/* EOF <YHF_OpenDlg.cpp> */
