/*========================================================================*/
/*                                                                        */
/* YHF_MultiLang.cpp  =  Hilfsroutinen fuer die Internationalisierung     */
/*                   einer BORLAND-C++Builder-Applikation .               */
/*  - verzichtet auf Borland's fehlerbehafteten Resourcen-DLL-Experten    */
/*  - verwendet stattdessem einen einfachen(?)                            */
/*      "tabellengesttzen bersetzer",                                   */
/*      um Anzeige- und Meldungstexte mehrsprachig halten zu koennen .    */
/*                                                                        */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
/*                                                                        */
/* YHF_MultiLang.cpp =  mother's little helper for internationalization   */
/*                   of a windoze application written in C++Builder .     */
/*  - does NOT require Borland's bugged Resource-DLL-Wizard               */
/*  - uses a simple(?) table-based "translator",                          */
/*      to hold two or more language alternatives .                       */
/*                                                                        */
/*                                                                        */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
/*                                                                        */
/*  Written by Wolfgang Buescher (DL4YHF) .                               */
/*                                                                        */
/*========================================================================*/



//---------------------------------------------------------------------------

#ifndef YHFMultiLangH
#define YHFMultiLangH
//---------------------------------------------------------------------------


#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* nicht "cplusplus" */


//---------------------------------------------------------------------------
// External references ..

CPROT void APPL_ShowMsg( int caller, int options, char *pszFormat, ... );
     // Works like 'printf'.  Appends to global error list.
     // Usually implemented somewhere in the 'main' module.
     // The "options"-parameter is called "error_level" in other programs .




//---------------------------------------------------------------------------
// Implemented in this module ..

//extern char YHF_scISO639_TranslateFrom[4]; // ISO639-1 code of previous language used in all forms
//extern char YHF_scISO639_TranslateTo[4];   // ISO639-1 code of current language

extern int YHF_iLanguageTestMode;  // 0=normal,  1=highlight translated controls
extern int YHF_iTranslationOk;     // additional result from YHF_TranslateString()

BOOL YHF_FindTranslationFiles( char *pszTranslationFilePattern );

int  YHF_SetLanguage(char *pszISO639Language,  // "en","de","fr","it","es"...
                     char *pszTranslationFile, // name of OPTIONAL translation file
                     BOOL fMayTranslateForms); // TRUE = may translate the application's forms now

const char * YHF_GetLanguage( void );
#ifdef StdCtrlsHPP
 BOOL YHF_UpdateLanguageCombo( TComboBox *pCombo );
#endif
void YHF_TranslateAllForms(void);

CPROT char *YHF_TranslateString( const char *pszString2Translate );
 // Called via macro    TE(x) = TranslateFromEnglish(x).
 // If the string-identifer is not found, the identifier itself is returned,
 // because in that case it's most likely that no "translation" is avaliable.

#define TE(s) YHF_TranslateString(s)
 // Translates a string from the "english reference" into the current language.
 // Used for string literals built inside the "C"-code,
 // which is usually written in english language.

CPROT BOOL YHF_DumpTranslatorFile( char *pszDestFileName );
 // Dumps the currently used 'translation table' into a text file.
 //  Used for testing purposes only !

CPROT void YHF_CloseTranslator(void);
 // Cleans up before termination.
 // Frees dynamically allocated memory if required.
 // Must be called upon termination of the main application.


#endif //
