//---------------------------------------------------------------------------
// YHF_Jpeg.h  =  a small wrapper for the Independent Jpeg Group's Code.
//
//  A result of WoBu's very first experiments to decompress JPEG files.
//
//  Using:
//     the IJG's JPEG library   Copyright (C) 1994-1997, Thomas G. Lane
//
// Some trivial modifications were made in the IJPEG code
// to reduce the number of warnings detected by Borland's C++Builder V4 .
// (I did not want to turn the warnings off in the compiler options).
//
// To WoBu's big surprise, decoding a JPEG image worked immediately
// on the very first attempt.  Well done guys ... though there are a few
// 'design flaws' which required slight modifications to make it work STABLE
// under Windoze XP. (uninitialized properties of some classes, which lead
// to the removal of the PAINTLIB stuff).
//
// The IJG code was then compiled (with BCB 4) into a LIBRARY (JPEGLIB1.LIB)
// which is located somewhere on WoBu's harddrive... making it much easier
// to use in other projects (instead of adding many dozens of modules).
//
//---------------------------------------------------------------------------


extern char YHF_Jpeg_ErrorMessage[256];

/***************************************************************************/
BOOL YHF_ReadJpegFile(char * filename,
           Graphics::TBitmap *bmp);
/*
 * Routine for JPEG decompression.  We assume that the source file name
 * is passed in.
 * Return TRUE on success,   FALSE on error.
 * If there was an error, a description can be found in
 *  YHF_Jpeg_ErrorMessage .
 */


/***************************************************************************/
BOOL YHF_WriteJpegFile(char * filename, int iQuality, Graphics::TBitmap *bmp);
/*
 * Routine for JPEG compression.  We assume that the target file name,
 * a compression quality factor, and a pointer to the source bitmap
 * are passed in.
 * Return TRUE on success,   FALSE on error.
 * If there was an error, a description can be found in
 *  YHF_Jpeg_ErrorMessage .
 */


/***************************************************************************/
BOOL YHF_SaveBmpAsFile(char *sFName,  int iQuality,  Graphics::TBitmap *bmp );
  // Saves a (VCL-)TBitmap as a file.
  // The following target formats are possible
  //  (detected by the file extension) :  JPG and BMP .
  // Return TRUE on success,   FALSE on error.
  // If there was an error, a description can be found in
  //  YHF_Jpeg_ErrorMessage .


/***************************************************************************/
BOOL YHF_LoadBmpFromFile(char *sFName, Graphics::TBitmap *bmp );
  // Loads a (VCL-)TBitmap as a file.
  // The following target formats are possible
  //  (detected by the file extension) :  JPG and BMP .
  // Return TRUE on success,   FALSE on error.
  // If there was an error, a description can be found in
  //  YHF_Jpeg_ErrorMessage .



/* EOF */  