/*------------------------------------------------------------------*/
/* File: C:\cbproj\YHF_Tools\YHF_Inet.h                             */
/*       (everything else is just a COPY)                           */
/*                                                                  */
/* DL4YHF's 'internet' utilities based on the socket services .     */
/*       (c) 2011 by Wolfgang Buescher                              */
/*                                                                  */
/*                                                                  */
/* Autor: Wolfgang Buescher (DL4YHF)                                */
/*                                                                  */
/*                                                                  */
/* Revision history (YYYY-MM-DD):      See *.c  !                   */
/*                                                                  */
/*------------------------------------------------------------------*/

#ifndef  _AUDIO_FILE_DEFS_H_
 #include "AudioFileDefs.h" //  contains AUDIO_FILE_FORMAT_... 
#endif

#define INET_MAX_URL_LENGTH 511 /* characters */

// Possible values for XYZ.iProtocol :
#define INET_PROTOCOL_UNKNOWN 0
#define INET_PROTOCOL_HTTP    1
#define INET_PROTOCOL_HTTPS   2
#define INET_PROTOCOL_FTP     3
#define INET_PROTOCOL_MAILTO  4
#define INET_PROTOCOL_FILE    5  /* dummy for "local files" */
#define INET_PROTOCOL_RAW_TCP 6  /* dummy for "rawtcp://ip:port" (used for pseudo audio stream addresses) */

#ifndef CPROT  // For peaceful co-existence of "C" and "C++" ....
// Note on "extern": do not trust the lousy example from Borland !
//   >extern "c" = wrong    (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif

//---------------------------------------------------------------------------
// Data types and structures
//---------------------------------------------------------------------------

typedef int(*T_InetCallback)(void *pvUserCallbackData, struct tInetClient *pClient, int iEventType, char *pszInfo, int iProgressPercent);
  #define INET_EVENT_TYPE_INFO  0
  #define INET_EVENT_TYPE_ERROR 1          /* with pszInfo = detailed error text */
  #define INET_EVENT_TYPE_PARSE_RESPONSE 2 /* opportunity for the application to parse the received HTTP GET RESPONSE */

typedef struct tInetClient
{
  DWORD  dwMagic17724538;     // magic number, indicating "this struct is ALREADY initialised" (sqrt(pi))
  int    is_internet_resource; // 0=FALSE=no (it's a local file),  1=TRUE=yes (it's an INTERNET resource)
  SOCKET sock;     // "socket" = kind of handle identifying an IP connection. NOT A FILE HANDLE !
  char   c1kRxBuffer[1024];   // buffer for the received HTTP response (or similar)
  int    nBytesInRxBuffer;    // number of bytes still 'waiting' in c1kRxBuffer[]
  char   cTxBuffer[16384];    // buffer to send data in larger chunks
  int    nBytesInTxBuffer;    // number of bytes already 'waiting' in c4kTxBuffer[]

  BOOL   fConnectionLost;     // flag for the application; SET when unexpected disconnect
                              // (in that case, *the application* must decide what to do,
                              //  and WHEN.)

  int    iProtocol; // may contain INET_PROTOCOL_HTTP, etc etc .
  unsigned long ulTotalBytesReceived, ulTotalBytesSent;
  int    iState;    // internal client state, contains one of the following:
  #define INET_CLIENT_STATE_PASSIVE         0
  #define INET_CLIENT_STATE_SENDING_REQUEST 1
  #define INET_CLIENT_STATE_WAIT_HTTP_RESP  2  /* waiting for reception of the (HTTP-?) response */
  #define INET_CLIENT_STATE_WAIT_FILE_DATA  3  /* waiting for reception of the "file data"       */
  int    iHttpStatusCode;  // something like 200 = "OK", 404 = "Not Found", etc etc etc etc etc etc
  int    iHttpMajorVersion, iHttpMinorVersion; // parsed from HTTP "GET" response
  char   sz80ContentType[84]; // content type from the HTTP GET response,
         // hopefully this will be something meaningful like
         //  text/html, image/jpeg, audio/mpeg, audio/ogg, audio/vorbis ;
         //  but be prepared for stuff like audio/x-mpegurl !

  T_InetCallback pPICallback; // optional progress indicator callback (may be NULL)
  void *pvUserCallbackData;   // user callback data (typically a "this"-pointer for pPICallback)
  DWORD  dwMagic98696044;     // magic number, indicating "this struct is ALREADY initialised" (pi^2)
} T_INET_Client;


typedef struct tInetUrlParts
{
  char *pszAccess; // usually the NETWORK PROTOCOL, now known as "scheme", W3C calls it "access".
                 // (heck, why do geeks have to use so many different names for the SAME THING ?)
  char *pszHost;   // Something like "qsl.net", but may also be something like "192.168.0.222" !
  char *pszAbsolute;  // "absolute" part of URL.  Mutually exclusive with "relative".
  char *pszRelative;  // "relative" part of URL.  Mutually exclusive with "absolute".
  char *pszFragment;

  // Derived info (also set in INET_SplitURL, but not in the original code) :
  int    iProtocol; // may contain 0=unknown, or INET_PROTOCOL_HTTP, etc .
  int    iPort;     // port NUMBER (0=not explicitly set in INET_SplitURL)

} T_INET_UrlParts;


// Bits in the iOptions parameter in INET_OpenAndReadFromServer(),
//                                   INET_WriteDataToServer(), etc .
#define INET_RD_OPTION_NORMAL                0x0000
#define INET_RD_OPTION_RETURN_AFTER_RESPONSE 0x0001
#define INET_RD_OPTION_WAIT_FOR_ALL_DATA     0x0002
#define INET_WR_OPTION_DONT_FLUSH            0x0010
#define INET_WR_OPTION_FLUSH_NOW             0x0020



//---------------------------------------------------------------------------
// Function prototypes   (more details in the implementation; *.c)
//---------------------------------------------------------------------------



/****************************************************************************/
CPROT BOOL INET_IsInternetStream( char *pszFilenameOrURL );

/****************************************************************************/
CPROT int INET_GuessAudioFileTypeFromName(char *pszFilename,  int iAudioFileType);
CPROT int INET_GuessAudioFileTypeFromData(BYTE *pbFileData, int nBytes, int iDefaultAudioFileType );


/****************************************************************************/
CPROT int INET_ContentTypeToAudioFileFormat( char *pszContentType, int iDefaultAudioFileType );
CPROT char * INET_AudioFileFormatToContentType( int iAudioFileType );

/****************************************************************************/
CPROT int INET_InitClient(
              T_INET_Client *pInetClient,    // [out] client data struct
              T_InetCallback pPICallback,    // [in, optional] progress indicator callback
              void *pvUserCallbackData);     // [in, optional] user callback data

/****************************************************************************/
CPROT void INET_CloseClient(
              T_INET_Client *pInetClient );  // [in,out] web client data

/****************************************************************************/
CPROT int INET_OpenAndReadFromServer(
              T_INET_Client *pInetClient,    // [in,out] web client data
              char *pszFilenameOrURL,        // [in] filename or URL
              int  iTimeout_ms,              // [in] max. timeout in milliseconds
              int  iOptions,                 // [in] bitwise combination INET_RD_OPTION_...
              BYTE *pbDest, int iMaxLength); // [in,out] destination buffer for the "contents"

/****************************************************************************/
CPROT int INET_ReadDataFromServer(  // "continues" reading/receiving if necessary
              T_INET_Client *pInetClient,    // [in,out] web client data
              int  iTimeout_ms,              // [in] max. timeout in milliseconds
              int  iOptions,                 // [in] bitwise combination as for ..OpenAndRead..
              BYTE *pbDest, int iMaxLength); // [in,out] destination buffer for the "contents"

/****************************************************************************/
CPROT int INET_WriteDataToServer(  // "continues" writing/sending if necessary
              T_INET_Client *pInetClient,    // [in,out] web client data
              int  iTimeout_ms,              // [in] max. timeout in milliseconds
              int  iOptions,                 // [in] bitwise combination as for ..OpenAndRead..
              BYTE *pbSource, int iLength);  // [in] source data, and number of bytes to send


/* EOF < YHF_Inet.h > */
