/****************************************************************************/
/* YHF_Help.h :  Translates calls to the old lousy WinHelp system           */
/*               into calls of an HTML browser.                             */
/*               NO APPLICATION-SPECIFIC STUFF IN HERE !                    */
/*               This unit is used in a number of projects (see history).   */
/*                                                                          */
/* Author:                                                                  */
/*   Wolfgang Buescher (DL4YHF)                                             */
/*                                                                          */
/* Revision History (not complete in the *.h, look into *.cpp !) :          */
/*  V1.0, xx.xx.2000:  Created for DL4YHF's "Spectrum Lab".                 */
/*                     Started as a wrapper for WinHelp.                    */
/*  V1.1, 09.09.2001:  Modified the whole thing to get rid of WinHelp       */
/*                     and Microsoft's LOUSY HELP COMPILER.                 */
/*                     From now on, an HTML browser is required to view the */
/*                     help pages.                                          */
/*        19.09.2001:  Now also used at the QRL - keep it compatible !      */
/*  V1.2, 2001-11-30:  Modified to make jumps to ANCHORS possible.          */
/*                     Requires analysis of the REGISTRY to find the full   */
/*                     path name of the standard HTML browser - yucc...     */
/*  V1.3, 2002-05-27:  Multi-Language support added.                        */
/*  V1.4, 2002-08-20:  On some f***** new system the command line for the   */
/*                     HTML browser didn't work.  Added debugging aids...   */
/*   ..                                                                     */
/*  V1.7, 2007-04-28: Trying to use OPERA or FIREFOX before IE, because IE7 */
/*     doesn't jump to the named anchor passed in the URI via command line. */
/****************************************************************************/

#ifndef _YHF_HELP_  // avoid multiple inclusion, and let others know...
 #define _YHF_HELP_ 1



//---------------- Data Types -----------------------------------------------
typedef struct
{ int  iHelpContext;
  char html_file_name[81];
  char html_anchor_name[81];
} T_YHF_HelpMapEntry;


//---------------- global variables ("yucc".. i know) -----------------------
extern char YHF_HELP_szLastError[256];  // only valid if last call failed !
extern BOOL YHF_HELP_fUseIexplore;      // published in the header since 2004-01-29

extern char YHF_HELP_sz511HtmlBrowserPath[512]; // path+file+options for html browser
      // May be overwritten by the application before initializing the module.
      //   If not, the program will attempt to use the standard browser,
      //   which -too often- will be an ugly product from a big company !

extern char YHF_HELP_sz1023LastBrowserCommandLine[1024];  // used for debugging

extern int YHF_HELP_iLanguageCode;    // 01=english, 49=german, etc (int'l dialing code)

//---------------- Prototypes -----------------------------------------------

/****************************************************************************/
BOOL YHF_HELP_QueryRegistryValue(
                 HKEY hKey,   // handle (or identifier) of key to query
           char *pszSubKey,   // address of name of subkey to query
           char *pszResult, int iMaxResultLength );
  // Registry Query to detect the standard HTML browser of this system.
  // Called from YHF_HELP_ShowHtml() because we had to call IEXPLORE.EXE
  //    (or whatever) with a full path, to be able to jump to a certain
  //    ANCHOR in the HTML document !!
  // To query the path+filename of the standard HTML browser, use..
  //    hkey      = HKEY_CLASSES_ROOT
  //    pszSubKey = \htmlfile\shell\open\command
  // The result should be something like..
  //    "c:\Programme\Internet Explorer\iexplore.exe"
  // This routine MAY be called before the "Init"-routine of this module,
  // because we may need the htlm browser path as a default value before
  // loading some kind of 'configuration data' from an INI-file !



/****************************************************************************/
int YHF_HELP_Init(
            HWND hwndParentWindow,  // handle of the application's main window
            char *html_file_path ,  // base path to the html files
     T_YHF_HelpMapEntry *pHelpMap,  // pointer to list of translation table
            int  iLanguageCode ) ;  // usually the international dialing code
  // Initialises the HTML-based help system.
  //   Requires the window handle of the calling application,
  //   a path to the directory where the help files are located,
  //   and a pointer to a conversion table from WinHelp 'context number'
  //   to an HTML reference (filename and -optionally- anchor name).
  // On Closure, the user should call YHF_HELP_Exit .


/****************************************************************************/
void YHF_HELP_Exit(void);
  // De-Initializes the HTML-based help system.
  // One fine day, this will be used to close the explorer window
  //  if it has been opened by the help-system.

/****************************************************************************/
BOOL YHF_HELP_MakeLanguageSpecificHelpFileName(
             char *pszTemplateHelpFileName,  // like "index_NN.htm"
             int  iLanguageCode,             // like 49 for germany
             char *psz255LanguageFileName ); // result: "index_49.htm"

/****************************************************************************/
BOOL HELP_ShowAnyFileOrURL(char * filename_or_url, char * anchor_name,
                           BOOL fTranslateFilenameToURL );
  // Opens any HTML file or URL, outside the html-help-directory .

BOOL YHF_HELP_ShowHtml(char *html_file_name, char *anchor_name);
  // Opens a help screen, using an HTML browser.
  //     (switching the browser to the anchor_name does not work yet.. shit)
  // Parameters:
  //     html_file_name = just the file with extension,
  //                      NO PATH (will automatically be added,
  //                      usually depending on the installed LANGUAGE)
  //
  //     anchor_name = Used to jump to a certain position INSIDE the
  //                      HTML document.
  //                      Sometimes called "Marker" by strange programs.
  //
  // Return value:
  //     TRUE  = ok
  //     FALSE = error (look at YHF_HELP_szLastError in this case !)
  //
  // Example:  HELP_ShowHtml("index.htm", NULL)
  //
  //  If the parameter 'iLanguageCode' when calling YHF_HELP_Init
  //  was non-zero, the suffix "_NN" in the html file name
  //  will be replaced with a two-letter code, like
  //    "index_NN.htm" ->  "index_49.htm"  if we are running on a german PC,
  //                    or "index_01.htm"  if the language is (US-) English.
  //



/****************************************************************************/
bool YHF_HELP_ShowHelpContext(int iHelpContext);
  // A replacement for HelpContext, using HTML files and an index file
  // which "translates" the help context numbers into the HTML file name
  // and the Anchor name (like "index.htm#overview" for example).
  //
  // return: TRUE=ok,  FALSE=error


/****************************************************************************/
bool YHF_HELP_ShowHelpKey(char *pszHelpKey);
  // A replacement for Application->HelpCommand(HELP_KEY, (int)pszHelpKey) .
  // Uses HTML files and an index table which "translates" the help keyword
  // into the HTML file name (like "index.htm#info" for example).
  // Note that the help keywords must be anchor names in the HTML files
  //  **AND** listed in the help keyword table !
  // The keyword search is not case-sensitive.
  //
  // return: TRUE=ok,  FALSE=error



#endif // _YHF_HELP_

// EOF <HelpMap.h>
