/****************************************************************************/
/* YHF_File.h:  File helper routines    by  Wolfgang Buescher (DL4YHF) .    */
/*               NO APPLICATION-SPECIFIC STUFF IN HERE !                    */
/*               This unit is used in a number of projects (see history).   */
/*                                                                          */
/* Author and Copyright by:                                                 */
/*   Wolfgang Buescher (DL4YHF)                                             */
/* Original file location: <Penti4>C:\CBproj\YHF_Tools\YHF_File.h           */
/*                                                                          */
/* Revision History (YYYY-MM-DD, latest modification first )                */
/*  V1.1, 2004-10-18:  Added YHF_FILE_DoesDirectoryExist() .                */
/*  V1.0, 2002-03-13:  Created for DL4YHF's "Spectrum Lab" .                */
/****************************************************************************/

#ifndef YHF_File_H  // avoid multiple inclusion (and tell other modules i'm there)
#define YHF_File_H


 // Result codes for YHF_FILE_DoesDirectoryOrFileExist() :
#define YHF_F_NEITHER_DIR_NOR_FILE_EXISTS   0  /* neither DIRECTORY nor FILE found */
#define YHF_F_DIRECTORY_EXISTS_BUT_NOT_FILE 1  /* the DIRECTORY does exist, but not the FILE */
#define YHF_F_BOTH_DIRECTORY_AND_FILE_EXIST 2  /* both DIRECTORY and FILE found    */


//---------------- Variables ------------------------------------------------
extern char YHF_FILE_szLastError[256]; // only valid if last call failed !


//---------------- Implementation of routines -------------------------------


/****************************************************************************/
int YHF_FILE_DoesDirectoryExist(char *szDirectoryPath);
int YHF_FILE_DoesDirectoryOrFileExist(char *szDirectoryPath);

/****************************************************************************/
int YHF_FILE_RemovePathFromFileName(char *szPathAndFileName);

#if(0)
/****************************************************************************/
int YHF_FILE_MakeRelativePath(
         char *pszSourcePathAndFile,
         char *pszRelRefPath,
         char *pszDestPathAndFile,
         int   iMaxDestLength );
  // Turns an "absolute" path+filename into a "relative" path+filename
  //  for a given reference path.
#endif // (0)


#endif // ! defined YHF_File_H
