/****************************************************************************/
/* YHF_File.cpp: File helper routines    by  Wolfgang Buescher (DL4YHF) .   */
/*               NO APPLICATION-SPECIFIC STUFF IN HERE !                    */
/*               This unit is used in a number of projects (see history).   */
/*                                                                          */
/* Author and Copyright by:                                                 */
/*   Wolfgang Buescher (DL4YHF)                                             */
/* Original file location: <Penti4>C:\CBproj\YHF_Tools\YHF_File.cpp         */
/*                                                                          */
/* Revision History:                                                        */
/*  V1.1, 2004-10-18:  Added YHF_FILE_DoesDirectoryExist() .                */
/*  V1.0, 2002-03-13:  Created for DL4YHF's "Spectrum Lab".                 */
/****************************************************************************/

#include <windows.h>    // here: YHF_File.cpp for *WINDOWS*, uses Win API .

#pragma hdrstop   // Borland Stuff. No precompiled headers after this.

#include "YHF_File.h"   // header file for this module



//---------------- Internal and initialized variables -----------------------
char YHF_FILE_szLastError[256]= "--"; // only valid if last call failed !

//---------------- Implementation of routines -------------------------------


/****************************************************************************/
int YHF_FILE_DoesDirectoryExist(char *szDirectoryPath)
  // Checks if a SUBDIRECTORY or a FILE IN A SUBDIRECTORY exists.
  // Parameters:
  //
  // Return value:
  //      0  = neither DIRECTORY nor FILE found
  //      1  = the DIRECTORY does exist, and it's NOT A FILE
  //      2  = the name is not a DIRECTORY- but a FILENAME
  //
  // Example:  YHF_FILE_DoesDirectoryExist("C:\\Windows\Temp")
  //
{
  HANDLE hSearchHandle;
  WIN32_FIND_DATA wfdFindData;

   hSearchHandle = FindFirstFile(
            szDirectoryPath,  // pointer to name of file to search for
             &wfdFindData );  // pointer to returned information
   if( hSearchHandle != INVALID_HANDLE_VALUE)
    {
      FindClose(hSearchHandle);
      if(wfdFindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
              return 1;  // there is a DIRECTORY but not a FILE.
        else  return 2;  // found a FILE in the directory
    }
   return 0;
} // end YHF_FILE_DoesDirectoryExist()



/****************************************************************************/
int YHF_FILE_DoesDirectoryOrFileExist(char *szDirectoryPath)
  // Checks if a SUBDIRECTORY or a FILE IN A SUBDIRECTORY exists.
  // Parameters:
  //
  // Return value:
  // 0 = YHF_F_NEITHER_DIR_NOR_FILE_EXISTS   = neither DIRECTORY nor FILE found
  // 1 = YHF_F_DIRECTORY_EXISTS_BUT_NOT_FILE = the DIRECTORY does exist, but not the FILE
  // 2 = YHF_F_BOTH_DIRECTORY_AND_FILE_EXIST = both DIRECTORY and FILE found
  //
  // Example:  YHF_FILE_DoesDirectoryOrFileExist("C:\\Windows\Temp")
  //
{
  HANDLE hSearchHandle;
  WIN32_FIND_DATA wfdFindData;
  char  sz255TempPath[256];
  char  *psz;

   hSearchHandle = FindFirstFile(
            szDirectoryPath,  // pointer to name of file to search for
             &wfdFindData );  // pointer to returned information
   if( hSearchHandle != INVALID_HANDLE_VALUE)
    {
      FindClose(hSearchHandle);
      if(wfdFindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
              return YHF_F_DIRECTORY_EXISTS_BUT_NOT_FILE; // there is a DIRECTORY but not a FILE.
        else  return YHF_F_BOTH_DIRECTORY_AND_FILE_EXIST; // found a FILE in the directory, so "both" exist
    }

   // Arrived here: the FILE does not exist. Check if the DIRECTORY is ok.
   strncpy(sz255TempPath,szDirectoryPath, 255); sz255TempPath[254]=0;
   psz=strrchr(sz255TempPath, '\\');
   if(psz)
    { *psz='\0';  // truncate full path at last backslash
      hSearchHandle = FindFirstFile(
              sz255TempPath,  // pointer to name of file to search for
             &wfdFindData );  // pointer to returned information
      if( hSearchHandle != INVALID_HANDLE_VALUE)
       {
         FindClose(hSearchHandle);
         if(wfdFindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
             return 1;  // there is a DIRECTORY (not a FILE, path already truncated !)
       }
    } // end if <backslash detected>

   return YHF_F_NEITHER_DIR_NOR_FILE_EXISTS; /* == 0, neither DIRECTORY nor FILE found */
} // end YHF_FILE_DoesDirectoryOrFileExist()

/****************************************************************************/
BOOL YHF_FILE_RemovePathFromFileName(char *szPathAndFileName)
{
  char  *psz;
   psz=strrchr(szPathAndFileName, '\\');
   if(psz)
    { if(*psz) ++psz; // never skip the zero byte !
    
      if((*psz>32) && (psz != szPathAndFileName))
       {
         strcpy(szPathAndFileName, psz);
         return TRUE;
       }
    }
   return FALSE;   // couldn't remove anything
} // end YHF_FILE_RemovePathFromFileName()


#if(0)
/****************************************************************************/
BOOL YHF_FILE_MakeRelativePath(
         char *pszSourcePathAndFile,
         char *pszRelRefPath,
         char *pszDestPathAndFile,
         int   iMaxDestLength )
  // Turns an "absolute" path+filename
  //                  like  C:\CBproj\SpecLab\Export\EDF_1.edf
  //  into a "relative" path+filename
  //                  like  Export\EDF_1.edf
  //  for a given "reference" path,
  //                  like  "C:\CBproj\SpecLab\"
  //        in this *very simple* example .
{
  // From SysUtils.h:
  //  ExtractFileName  (unfortunately, requires AnsiString which is VCL stuff)..
  // > Returns a relative path name, relative to a specific base directory.
  // > extern PACKAGE AnsiString __fastcall ExtractRelativePath(
  // >      const AnsiString BaseName, const AnsiString DestName);
  // >
  // > Description
  // >  Call ExtractRelativePath to convert a fully qualified path name
  // > into a relative path name.  The DestName parameter specifies
  // > file name (including path) to be converted.
  // > BaseName is the fully qualified name of the base directory
  // > to which the returned path name should be relative.
  // >
  // > ExtractRelativePath strips out common path directories
  // > and inserts "..\" for each level up from the BaseName.
  AnsiString s = ExtractRelativePath(
     pszRelRefPath,         // const AnsiString BaseName
     pszSourcePathAndFile); // const AnsiString DestName .. actually a SOURCE
  strncpy( pszDestPathAndFile, s.c_str(), iMaxDestLength );
  return TRUE;
} // end YHF_FILE_MakeRelativePath()
#endif // (0,1)
