/****************************************************************************/
/* YHF_Dialogs.h:  File helper routines    by  Wolfgang Buescher (DL4YHF) . */
/*               NO APPLICATION-SPECIFIC STUFF IN HERE !                    */
/*               This unit is used in a number of projects (see history).   */
/*                                                                          */
/* Author and Copyright by:                                                 */
/*   Wolfgang Buescher (DL4YHF)                                             */
/*                                                                          */
/* Revision History:                                                        */
/*  V1.0, 2004-07-13:  Created for DL4YHF's "Spectrum Lab".                 */
/*                     Also used -the same day- for DL4YHF's "WinPic".      */
/*  V1.1, 2005-10-24:  Added "YHF_BrowseForFolder" (for WinPic) .           */
/*                                                                          */
/****************************************************************************/

#ifndef _YHF_DIALOGS_H_
#define _YHF_DIALOGS_H_


//---------------- Constants ------------------------------------------------
// Dialog button codes (not button IDs, but return codes for the modal dialogs)
#define YHF_DLG_BTN_NONE   0
#define YHF_DLG_BTN_OK     1
#define YHF_DLG_BTN_CANCEL 2
#define YHF_DLG_BTN_HELP   3
#define YHF_DLG_BTN_USER1  11
#define YHF_DLG_BTN_USER2  12

#define YHF_DLG_ID_EDIT1   21 /* control ID for the edit field in the dialog */

// Edit field options (used in some simple dialogs)
#define  YHF_EDIT_NORMAL       0
#define  YHF_EDIT_DECIMAL_ONLY 0x0010
#define  YHF_EDIT_HEXADECIMAL  0x0020


//---------------- Variables ------------------------------------------------
extern HINSTANCE APPL_hInstance; // must be set somewhere in the application,
                // so we don't have to pass this in all those subroutines .
                // Unlike other stuff, this "HINSTANCE"-thingy won't change
                // while a "normal, small windoze app" is running .

//---------------- Prototypes -----------------------------------------------

  // For peaceful coexistence between "C" and "C++" :
#ifndef CPROT
// Note on "extern": do not trust the lousy example from Borland !!
//   >extern "c" = bullshit (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif

//--------------------------------------------------------------------------
CPROT BOOL YHF_ChooseColor( HWND hwndOwner, char *pszCaption, DWORD *pdwRGBColor );
  // Color Selection Dialog.
  // Works a bit like Borland's TColorDialog but allows defining the CAPTION.

//--------------------------------------------------------------------------
CPROT BOOL YHF_BrowseFolder(HWND hwndOwner, char *pszCaption, char *pszFolder, int iMaxLen );
  // Folder Selection Dialog.
  //  The current folder (pszFolder) will be selected in the dialog,
  //  so it must be VALID (or contain an empty string) before the call .

//--------------------------------------------------------------------------
CPROT int YHF_RunIntegerInputDialog( // MODAL dialog; returns YHF_DLG_BTN_...
  HWND hwndOwner,  // handle to the window which will be blocked by the dialog
  char *pszTitle, char *pszLabel1,  char *pszLabel2,
  int  *piValue,  int iEditOptions, int  iHelpContext );
CPROT int YHF_RunStringEditDialog(  // MODAL dialog; returns YHF_DLG_BTN_...
  HWND hwndOwner,  // handle to the window which will be blocked by the dialog
  char *pszTitle, char *pszLabel1, char *pszLabel2,
  char *pszDefaultValue, int iEditOptions,
  char *pszDestination,  int iMaxLength, int  iHelpContext );


//--------------------------------------------------------------------------
CPROT BOOL YHF_GetMouseCursorPos( int *piScreenX, int *piScreenY );
  // Not really "dialog-related", but see YHF_Dialogs.cpp .....


#endif // _YHF_DIALOGS_H_

// EOF < YHF_Dialogs.h >
