/*------------------------------------------------------------------*/
/*  YHF_CmdLine.h                                                   */
/*                                                                  */
/* DL4YHF's command-line parsing utility .                          */
/*                                                                  */
/*       Replaces the bugged ParamCount + ParamStr functions        */
/*       from Borland's VCL .                                       */
/*                                                                  */
/*       (c) 2008 by Wolfgang Buescher                              */
/*                                                                  */
/* Autor: Wolfgang Buescher (DL4YHF)                                */
/*                                                                  */
/*                                                                  */
/* Revision history :  see  *.cpp                                   */
/*                                                                  */
/*------------------------------------------------------------------*/

#ifndef CPROT  // For peaceful co-existence of "C" and "C++" ....
// Note on "extern": do not trust the lousy example from Borland !!
//   >extern "c" = wrong    (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif


CPROT int  YHF_GetCmdLineParamCount( void );
CPROT int  YHF_GetCmdLineParamStr( int iParamIndex, char *pszDest, int iMaxDestLength );
CPROT void YHF_RemoveOuterDoubleQuotes( char *pszString );

/* EOF < YHF_CmdLine.h > */
