/*------------------------------------------------------------------*/
/*  YHF_CmdLine.cpp                                                 */
/*                                                                  */
/* DL4YHF's command-line parsing utility .                          */
/*       (c) 2008 by Wolfgang Buescher                              */
/*                                                                  */
/*       Replaces the bugged ParamCount + ParamStr functions        */
/*       from Borland's VCL .                                       */
/*       Can also be used to retried the complete path+name         */
/*       of the executable file : YHF_GetCmdLineParamStr(0,..)      */
/*       (but caution.. windows sucks.. it may NOT contain a path.. */
/*        use Win32 API GetModuleFileName() instead of ParamStr(0)) */
/*                                                                  */
/* Autor: Wolfgang Buescher (DL4YHF)                                */
/*                                                                  */
/*                                                                  */
/* Revision history (YYYY-MM-DD):                                   */
/*  2008-09-13 :                                                    */
/*        Wrote YHF_CmdLine after discovering that ParamStr sucks:  */
/*        ParamStr() turned   /sp.print("hello")                    */
/*                     into   /sp.print(hello)                      */
/*        ...which is a COMPLETE mess, at least for Spectrum Lab .  */
/*     ( "hello" is a STRING, hello may be the name of a variable ) */
/*                                                                  */
/*------------------------------------------------------------------*/


/* NO VCL IN THIS UNIT !!!!! (or other BORing stuff) */
#include <string.h>
#include <windows.h>

#pragma hdrstop

#include "YHF_CmdLine.h"  // DL4YHF's command-line-parser utility

//------------ internal data types ------------------------------------------



//------------ Functions ----------------------------------------------------

//---------------------------------------------------------------------------
int YHF_GetNextArgument(
      char **ppszCmdLine, // [in,out] pointer into the command line, zero-terminated
      char **ppcStart,    // [out] pointer to the first character of the argument
      int  *piLength)     // [out] number of characters
  // Return value : 1 = ok,  0 = no further arguments
{
  char *cp, *cpStart;   // use local variables for speed
  char c, cPrev;
  BOOLEAN fQuoted, fCont;
  if( piLength != NULL )
   { *piLength = 0;
   }
  if( ppszCmdLine==NULL )
   {  return 0;
   }
  if( *ppszCmdLine==NULL )
   { return 0;
   }
  cp = *ppszCmdLine;
  if( *cp == 0 )
   { return 0;    // no further arguments found (end of the string, NO SPACE)
   }
  while( *cp==' ' )
   { ++cp;        // skip the space between two cmd-line-arguments
   }
  cpStart = cp;

  // Look at the first character.
  // (ONLY) If it's a double quote, and there is a matching double quote later
  //  (before the next argument-separator), skip over the spaces in between.
  // Example (1) :
  //  SpecLab.exe "Ugly Filename With Spaces.wav"
  //  will give TWO arguments :
  //   [0]   SpecLab.exe
  //   [1]   "Ugly Filename With Spaces.wav"
  // The end of the command line argument is a space, or a zero byte:
  cPrev = 0;  // no "previous character" yet ...
  fCont = TRUE;
  fQuoted = FALSE;
  while( (c=(*cp))!=0 )
   {
     switch(c)
      { case '"':
           // looks like a double-quoted string in argument.
           // IN THIS SPECIAL CASE, spaces between the double quotes are NO ARGUMENT-SEPARATORS.
           // Note: Unlike ParamStr(),  we do NOT remove the double quotes here !
           // The caller may do that himself. It all depends on the application.
           // Maybe it's important for the application to know wheter the string
           // was embedded in double quotes. Think about this :
           // Example (2) :
           //  SpecLab.exe "Hello"   [may be something different than]
           //  SpecLab.exe Hello     [you see the importance of NOT removing the quotes]
           // C-syntax-specific details :
           //   -  a double quote character prefixed with a single backslash
           //      is usually *NOT* the end of a quoted string, but inserts
           //      a double quote character into the output .
           //      Since we don't want to ALTER the command line parameter here,
           //      we don't remove that backslash, but continue searching
           //      for the "real" end of the quoted string .
           if( cPrev!='\\' )
            { // Arrived here, we found a double-quote-char not prefixed with a backslash.
              fQuoted = !fQuoted;   // toggle the "quoted-flag"
            }
           break;  // end case < double quote character >

        case ' ':  // SPACE : may be a separator, but only if NOT WITHIN QUOTES
           if( ! fQuoted )
            { fCont = FALSE;  // space outside double quotes: END OF AN ARGUMENT
            }
           break;
      } // end switch
     if( fCont )
      { ++cp;  // no separator found, skip the character and continue loop
      }
     else      // found the separator; DO NOT SKIP IT YET (!)
      { break;
      }
   } // end while

  // Arrived here,  cp  points to the next character *AFTER* the argument .
  *ppszCmdLine = cp; // ... which is where we continue in the next call

  if( ppcStart != NULL )
   { *ppcStart = cpStart; // [out] pointer to the first character of the argument
   }
  if( piLength != NULL )
   { *piLength = (cp - cpStart); // [out] number of characters in the argument
   }
  return 1;

} // end YHF_GetNextArgument()

//---------------------------------------------------------------------------
int YHF_ParseCmdLine(
       char * pszEntireCommandLine, // [in] entire command line, usually retrieved
                                    // by the Win32 API function GetCommandLine()
       int  iArgumentIndex,         // [in]  argument index to be copied into pszArgument
       int  iMaxArgumentLength,     // [in]  maximum length of pszArgument
       char * pszArgument )         // [out] argument[iArgumentIndex] as string
  // Return value = total number of arguments found .
  // Note: If there are FOUR arguments in the entire command line
  //       (usually including the name of the executable),
  //       the result is FOUR .
  //       To retrieve those strings, use indices ZERO to THREE (!!!!!!),
  //       because we are using "C", not "Pascal", and not the VCL !
{
  char *pcCurr, *pcStart;
  int  iNumArgsFound = 0;
  int  iLengthOfArg;
  if( pszEntireCommandLine==NULL )

  if( (pszArgument!=NULL) && (iMaxArgumentLength>0) )
   {  *pszArgument = '\0';  // return a string of length zero (if nothing found)
   }
  pcCurr = pcStart = pszEntireCommandLine;
  while( YHF_GetNextArgument( &pcCurr, &pcStart, &iLengthOfArg )
     &&  ( iNumArgsFound<100 )  // emergency brake , added 2008-10-06
       )
   { if( iArgumentIndex==iNumArgsFound )
      { // this is the string which the caller wants to retrieve :
        if( (iMaxArgumentLength>iLengthOfArg) && (pszArgument!=NULL ) )
         { strncpy( pszArgument, pcStart, iLengthOfArg );
           // Make sure the resulting string is ALWAYS zero-terminated:
           pszArgument[iLengthOfArg] = '\0';
         }
      }
     ++iNumArgsFound;
   }
  return iNumArgsFound;
} // end YHF_ParseCmdLine()

//---------------------------------------------------------------------------
extern "C" int YHF_GetCmdLineParamCount(void)
  // Replaces the VCL-function "ParamCount()" .
  // We don't want to use any VCL-stuff in here, so WB rolled his own...
  //
  // Return value:   Number of command line arguments.
  //                 Note:  the first argument (index zero)
  //                        usually contains the name of the executable,
  //                        so be prepared for return value = 1  (ONE)
  //                        even if no "parameter" was specified .
{
  int iNumArgumentsFound = YHF_ParseCmdLine(
       GetCommandLine(),   // [in] entire command line, usually retrieved
                           // by the Win32 API function GetCommandLine()
       -1,                 // [in]  argument index to be copied into pszArgument
       0,                  // [in]  maximum length of pszArgument
       NULL );             // [out] argument[iArgumentIndex] as string
  return iNumArgumentsFound;
} // end YHF_GetCmdLineParamCount()

//---------------------------------------------------------------------------
extern "C" int YHF_GetCmdLineParamStr(
        int iParamIndex,      // [in] index, ZERO to <N minus one> (see notes)
        char *pszDest,        // [out] standard C-string (no dynamic stuff)
        int iMaxDestLength )  // [in]  maximum length, in characters, of pszDest
  // Replaces the VCL-function "ParamStr(iParamIndex)" .
  // We don't want to use any VCL-stuff in here, so WB rolled his own.
  // Unlike the bugged ParamStr(  which removes double quotes in a poor fashion ),
  // YHF_GetCmdLineParamStr() leaves the argument intact, and only removes
  // the double quotes if the ENTIRE ARGUMENT is double-quoted
  //  (like one of the dreadful "long filenames with spaces") .
  //
  // Return value:
  //   On success:  >=0 (total number of arguments)
  //   On error  :  negative error code .
  //
  // Note: If there are FOUR arguments in the entire command line
  //       (usually including the name of the executable at index zero),
  //       the result is FOUR .
  //    To retrieve those strings, use indices ZERO to THREE (!!!!!!),
  //       because we are using "C", not "Pascal", and not the VCL !
{
  int iNumArgumentsFound;
  pszDest[0] = '\0';   // return an empty string if there's "nothing" 
  iNumArgumentsFound = YHF_ParseCmdLine(
       GetCommandLine(),   // [in] entire command line, usually retrieved
                           // by the Win32 API function GetCommandLine()
       iParamIndex,        // [in]  argument index to be copied into pszArgument
       iMaxDestLength,     // [in]  maximum length of pszArgument
       pszDest );          // [out] argument[iArgumentIndex] as string
  if( iNumArgumentsFound >= 0 )  // no error...
   {  if( iParamIndex < iNumArgumentsFound )
          return iNumArgumentsFound;
      else
          return -1;
   }
  else
   {  return -1;
   }
} // end YHF_GetCmdLineParamStr()

//---------------------------------------------------------------------------
extern "C" void YHF_RemoveOuterDoubleQuotes( char * pszString )
  // Removes the double-quote character at the BEGIN and the END of the string.
  // If the string doesn't begin and end with double-quote characters,
  // nothing happens.
{
  char *cp1,*cp2;
  int iEmgcyBrake = 2000;
  if( pszString!=NULL )
   { if( *pszString=='"' )
      { // The string has BEGUN with a double-quote character .
        // Does it also END with this character ?
        cp2 = pszString+1;
        while( *cp2!=0 )  // skip until the end of the string...
         { ++cp2;
           if( (iEmgcyBrake--) < 0 )
             break;
         }
        --cp2;  // this is safe because cp2 > pszString
        if( cp2[0]=='"' ) // last character of the string..
         { cp1 = pszString;
           *cp2 = '\0';
           while( cp1 < cp2 )
            { cp1[0] = cp1[1];
              ++cp1;
            }
         } // end if < string also ENDS with a double-quote character >
      } // end if < string BEGINS with a double-quote character >
   }
} // end YHF_RemoveOuterDoubleQuotes()

/* EOF < YHF_CmdLine.cpp > */

