//---------------------------------------------------------------------------
//
// File:    c:\cbproj\SoundUtl\VorbisStreamServer.h
// Date:    2012-02-26
// Author:  Wolfgang Buescher (DL4YHF)
// Purpose: Server for 'raw TCP'  Vorbis audio streams,
//          compatible with Paul Nicholson's VLF RX Toolchain .
//
//---------------------------------------------------------------------------


#ifndef CPROT   /* To call this "C" module from C++ ... */
// Note on "extern": do not trust the lousy example from Borland !!
//   >extern "c" = wrong    (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif

/*----------- Constant Definitions ----------------------------------------*/
    // .. moved to c:\cbproj\SoundUtl\AudioFileDefs.h !
#ifndef  _AUDIO_FILE_DEFS_H_
 #include "AudioFileDefs.h" //  contains AUDIO_FILE_FORMAT_UNKNOWN,
             // and type definitions like T_AudioFileInfoCallback .
#endif


// Configuration of the audio-via-TCP client side :
extern BOOL VSS_receive_UDP;  // FALSE=off,  TRUE=enabled
extern BOOL VSS_receive_TCP;
extern BOOL VSS_send_UDP;
extern BOOL VSS_send_TCP;
extern char VSS_sz20RcvFromIP[22];
extern WORD VSS_wRcvFromPort;
extern char VSS_sz20SendToIP[22];
extern WORD VSS_wSendToPort;


//===========================================================================
//  Common functions (for both SERVER- and CLIENT functions)
//===========================================================================

//---------------------------------------------------------------------------
CPROT void VSS_Init(void); // should be called ONCE to initialize this module


//---------------------------------------------------------------------------
CPROT void VSS_DoNetworkStuff(void); // periodically called from main thread/task

//---------------------------------------------------------------------------
CPROT BOOL VSS_Start( int iAudioServerPort, T_AudioFileInfoCallback pInfoCallback);

//---------------------------------------------------------------------------
CPROT void VSS_HandleAsyncMsg( WPARAM wParam, LPARAM lParam);
  // Must be called by the application (from the windows message loop)
  // when winsock sends a notification for the Audio-via-TCP port, SERVER side.
  // The message ID must be passed to VSS_StartServer( .. iWindowsMsgId .. ),
  // to configure winsock to send such messages (which geeks call "async") .
  // (Update 2020-10: Similar as in the HTTP SERVER, try to reduce the use of
  //         Windows-messages for networking because, well ..  it sucks.
  //         Better keep the interface to the TCP/IP protocol services
  //         as similar to the Berkeley socket API as possible ! )

//---------------------------------------------------------------------------
CPROT void VSS_Stop(void);

//---------------------------------------------------------------------------
CPROT BOOL VSS_IsRunning(void);



/* EOF < VorbisStreamServer.h > */
