/***************************************************************************/
/* [c:\cbproj\SoundUtl\] VorbisFileIO.h :                                  */
/*   Unit to import and export *.ogg files (ogg container, vorbis codec).  */
/*   - by DL4YHF May 2010                                                  */
/*   - extended to process INTERNET STREAMS (besides local files) 2011-12  */
/*   - details only in *.cpp                                               */
/*-------------------------------------------------------------------------*/

#define VORBIS_USE_QFILE 1

#ifndef _VORBIS_FILE_IO_H_
#define _VORBIS_FILE_IO_H_

#ifdef BUILDING_THE_DLL
// To convince the stupid linker that we want to have public symbols
// in the IMPORT LIBRARY (*.LIB, not *.DLL), use this 'DLLIMPEX' thing
// in all function prototypes which shall be imported.
// A list of the functions which were initially MISSING in the *.LIB
// can be found in C:\cbproj\SoundUtl\VorbisFileIO.cpp  .
# define OV_DLLIMPEX __declspec(dllexport)  /* here: OV_DLLIMPEX = Ogg/Vorbis DLL EXPORT */
#else
# define OV_DLLIMPEX __declspec(dllimport)  /* here: OV_DLLIMPEX = Ogg/Vorbis DLL IMPORT */
#endif
// How to use this DLLIMPEX thing, taken from a document by Microsoft (!) :
// > Zum Exportieren von Funktionen muss das __declspec(dllexport)-Schlsselwort
// > links neben dem Schlsselwort fr die Aufrufkonvention stehen,
// > sofern ein Schlsselwort angegeben wird. Beispiel:
// >
// > __declspec(dllexport) void __cdecl Function1(void);
// Forget about __cdecl (it doesn't defeat C++ name mangling anyway);
// so, in this case: DLLIMPEX void Function1(void) ;
//
// > Um alle ffentlichen Datenmember und Memberfunktionen einer Klasse
// > zu exportieren, muss das Schlsselwort, wie im nachfolgenden Beispiel
// > dargestellt, links vom Klassennamen erscheinen:
// > class __declspec(dllexport) CExampleExport : public CObject
// > { ... class definition ... };
//
// Glcklicherweise funktioniert das, was oben von Microsoft beschrieben wurde,
// auch mit Borland C++ Builder. Allerdings ist es nicht (ohne weiteres)
// mglich, eine mit Borland erzeugte DLL (mit C++-Klassen) in einem
// Microsoft-Visual-Irgendwas - Projekt zu verwenden, und umgekehrt.
//    (das funktioniert wegen des ekelhaften, Compiler-Hersteller-spezifischen
//     C++-"Name Mangling" nur mit C-Funktionen, wre da nicht die grauenhafte,
//     unterschiedliche Behandlung von _cdecl durch Borland und Microsoft .. )
//  Egal, wir ERZEUGEN die DLL mit Borland, und VERWENDEN sie mit Borland,
//        also kein Problem, oder wie, oder was ?
//
// Um die Funktionen in der DLL ohne den 'LoadLibrary'/'GetProcAddress'-Klamauk
// nutzen zu knnen, muss die vom C++Builder erzeugte 'Import Library',
// z.B. DLL_Building_Project.lib,  mit in das Projekt aufgenommen werden,
// welches die Klassen (und, eventuell, "normalen" C-Funktionen) in der DLL
// verwendet.  Beispiel fr ein derartiges (Borland-)Projekt:
//           c:\cbproj\DLL_with_Classes\DLL_Testing_Project.bpr .
//   bzw in diesem Fall (zum Compilieren der Ogg- & Vorbis-Library fr SpecLab):
//           C:\cbproj\SpecLab\OggVorbis4SL.cpp / .bpr          .


// Note: it is NOT necessary to include the Vorbis headers here, because
//       the 'user' of VorbisFileIO.h should not need to know the details.
//       All Vorbis (vorbisfile,  vorbisenc) specific structs are hidden
//       in ::m_pVorbisFileHelper

#ifndef  _AUDIO_FILE_DEFS_H_
# include "AudioFileDefs.h"
#endif

#ifndef  _CHUNK_INFO_H_
# include "ChunkInfo.h" // originally located at c:\cbproj\SoundUtl\ChunkInfo.h
#endif


/*----------- Constant Definitions ----------------------------------------*/

// Possible values for the parameter 'file_mode' in OutOpen() :
#define WAVE_FILE_MODE_OVERWRITE 0
#define WAVE_FILE_MODE_APPEND    1



/*----------- Data Types --------------------------------------------------*/


#ifndef  SWI_FLOAT_PRECISION   // should be defined under Project..Options..Conditionals
 #define SWI_FLOAT_PRECISION 1 /* 1=single precision, 2=double precision */
#endif

#ifndef T_Float /* T_Float defined in SoundTab.h, SoundMaths.h, Sound.h, WaveIO.h, ... */
#if SWI_FLOAT_PRECISION==1
 #define T_Float float
 // "float" instead of "double" saves CPU power on stoneage notebooks .
 // Details about float versus double in c:\cbproj\SpecLab\SWI_V01\SWITCHES.H !
#else
 #define T_Float double
#endif
#endif // ndef T_Float

// Structures embedded in audio streams, added 2014-04-21 to support
// UNCOMPRESSED (!) streams besides the compressed Ogg/Vorbis audio .
//   The very same format is also used when streaming UNCOMPRESSED audio
//   over a serial port (known as "COM" port under windoze), which may
//   actually be a cable, virtual COM port, or even a unidirectional RADIO LINK.
//   A RECEIVER for streaming audio via serial port is implemented
//   in Spectrum Lab since 2014, module C:\cbproj\SoundUtl\Sound.cpp .

#ifndef  int32_t
# define int32_t long
#endif

#ifndef  uint32_t
# define uint32_t unsigned long
#endif

typedef struct VT_BLOCK  // compatible with VT_BLOCK defined in vlfrx-tools-0.7c/vtlib.h
{                        // DON'T MODIFY - keep compatible with Paul's VLF Tools !
   int32_t  magic;     // should contain VT_MAGIC_BLK = 27859 = Data block header
#   define VT_MAGIC_BLK 27859
   uint32_t flags;     // See VT_FLAG_* below
   uint32_t bsize;     // Number of frames per block
   uint32_t chans;     // Number of channels per frame;
   uint32_t sample_rate;   // Nominal sample rate
   uint32_t secs;      // Timestamp, seconds part
   uint32_t nsec;      // Timestamp, nanoseconds part
   int32_t  valid;     // Set to one if block is valid
   int32_t  frames;    // Number of frames actually contained  .
                       // Sometimes titled 'final frame count' .
   int32_t  spare;
   double   srcal;     // Actual rate is sample_rate * srcal (8 byte IEEE double precision float) .
                       // Thus srcal is often 1.0 plus a very small number.
} T_VT_Block; // in vtlib.h, for GCC : __attribute__((packed)); of course not Borland-C-compatible

// Bit definitions for VT_BLOCK and VT_BUFFER flags field. Copied from vlfrx-tools/vtlib.h :
#ifndef VTFLAG_RELT
# define VTFLAG_RELT    (1<<0)   // Timestamps are relative, not absolute
# define VTFLAG_FLOAT4  (1<<1)   // 4 byte floats  (8 byte default)
# define VTFLAG_FLOAT8  0
# define VTFLAG_INT1    (2<<1)   // 1 byte signed integers
# define VTFLAG_INT2    (3<<1)   // 2 byte signed integers
# define VTFLAG_INT4    (4<<1)   // 4 byte signed integers
# define VTFLAG_FMTMASK  (VTFLAG_FLOAT4 | VTFLAG_INT1 | VTFLAG_INT2 | VTFLAG_INT4)   // Mask for format bits

#endif

typedef struct tStreamHeader  // .. alias struct STREAM_HDR_1 in Paul's vtsl.c ..
{
   uint32_t dwPattern8000; // pattern 0x80008000 (0x00 0x80 0x00 0x80, little endian order),
                           // never appears in the 16-bit signed integer samples because
                           // THEIR range is limited to -32767 ... +32767 .
                           // Also very unlikely to appear in a stream of 32-bit floats.
#  define STREAM_HDR_PATTERN 0x80008000
   uint32_t nBytes;        // total size of any header, required for stream reader
                           // to skip unknown headers up to the next raw sample .
                           // Must always be a multiple of FOUR, to keep things aligned.
      // Example: nBytes = 4*4 + sizeof(VT_BLOCK) = 16 + 10*4+8 = 64 bytes .
      // (assuming that 'int' in struct VT_BLOCK is, and will always be, 32 bit)
   uint32_t dwReserve;     // 'reserved for future use' (and for 8-byte alignment)
   uint32_t dwStructID;    // 0=dummy,
                           // 1=the rest is a VT_BLOCK as defined in vlfrx-tools-0.7c/vtlib.h
                           // (etc... more, especially headers with GPS lat/lon/masl will follow)
#  define STREAM_STRUCT_ID_NONE     0
#  define STREAM_STRUCT_ID_VT_BLOCK 1
} T_StreamHeader;

typedef struct tStreamHdrUnion
{ T_StreamHeader header;
  union
   { T_VT_Block  vtblock;  // used when header.dwStructID == STREAM_STRUCT_ID_VT_BLOCK
   }u;
} T_StreamHdrUnion; // not suited for AUDIO_FILE_FORMAT_STREAM_WITH_VLF_RX_BLOCKS/STREAM_FORMAT_VLF_RX_BLOCKS !

typedef union tStreamPtrUnion
{
  unsigned char  *pU8;
  unsigned short *pU16;
  unsigned long  *pU32;
  signed char    *pI8;
  short int      *pI16;
  long           *pI32;
  float          *pF32;
  double         *pF64;
  DWORD           u32;   // access pointer as a 32-bit "DWORD" to check alignment
} T_StreamPtrUnion;

BOOL VFIO_StringToAudioFileFormatAndVTFlags( // Used to parse some configuration files
        char **ppcSource,             // [in,incremented] : "Ogg", "OggVorbis", "Uncompressed" [,"int8" / "int16" / .. ]
        int *piAudioFileFormat,       // [in,out]: AUDIO_FILE_FORMAT_.. (preset with the default by caller)
        int *piVTFlags );             // [in,out]: VTFLAG_INT2_.. (also preset by caller)


int CheckBufferForUncompressedStreamHeader(
        BYTE *pbRxBuffer, DWORD nBytes ); // [in] initially received data
  // Analyses pbRxBuffer[0...nBytes-1]
  // for a possible T_StreamHeader (as defined in VorbisFileIO.h) .
  // Called internally from VorbisFileIO.cpp,
  // but also from SL to examine the initial bytes received from a remote server !
  // Details in VorbisFileIO.cpp .
int CheckBufferForVlfRxToolsBlock( // .. similar for a T_VT_Block *without* a T_StreamHeader
        BYTE *pbRxBuffer, DWORD nBytes );  // [in] received data



/*----------- Definition of the C_VorbisFileIO  class ---------------------------*/
class OV_DLLIMPEX C_VorbisFileIO  // .. does NOT build upon C_AnyAudioFileIO .. !
{
public:
   C_VorbisFileIO();
   virtual ~C_VorbisFileIO();

   // Public member functions :
   void Exit(void);  // semi-destructor, call *before* UTL_ExitFunction() !


   /************************************************************************/
   BOOL SetInfoCallback(
     T_AudioFileInfoCallback pInfoCallback, // [in, optional] user callback function
     void *pvUserCallbackData);             // [in, optional] user callback data
    /* Only used for debugging, and for display in SL's web stream control panel.
     * Type and parameters of the user's "info callback" are defined
     *      in c:\cbproj\SoundUtl\AudioFileDefs.h .
     */

   /************************************************************************/
   BOOL SetStreamLogfile(char *pszLogfileName);
    /* Prepares writing an optional logfile with compressed audio data.
     * Must be called BEFORE opening a webstream, otherwise the logfile
     *     would be unusable in most cases, without the initial headers.
     * [in] : pszLogfileName = filename of an optional (audio-)logfile,
     *                         or NULL when *no* logfile shall be written.
     */
   BOOL CloseLogfile( void );
    /* Closes the *LOGFILE* (without closing the *STREAM* itself).
     */
   BOOL GetLogfileInfo(T_StreamLogInfo *pStreamLogInfo);
    /* Retrieves info about the current STREAM LOGFILE (not the stream itself).
     * Type T_StreamLogInfo is defined in AudioFileDefs.h .
     */


   /************************************************************************/
   BOOL SetServerPassword(char *pszPassword);
     /* For certain web streams; must be called BEFORE opening a stream .
      */

   /************************************************************************/
   BOOL InOpen( char *pszFileName,
                int  options );   // AUDIO_FILE_OPTION_TIMESTAMPS , ... (bitflags)
     /* Opens a wave file (or web stream) for READING.
      * Returns TRUE on success and FALSE on any error.
      */

   /************************************************************************/
   int   GetState(void);  // returns one of the values defined as
                          // AUDIO_FILE_IO_STATE_... in AudioFileDefs.h


   /************************************************************************/
   LONG ReadSampleBlocks(
         int channel_nr,    // channel_nr for 1st destination block
         int nSamplesWanted, // number of samples 'wanted' (per destination block, length of destination arrays)
         T_Float *pFltDest1, // 1st destination block (~"LEFT")
         T_Float *pFltDest2, // 2nd destination block (~"RIGHT"), may be NULL
         T_ChunkInfo *pChunkInfo); // additional results, see ChunkInfo.h, may be NULL
     /* Reads some samples from an audio file which has been opened for READING
      * and converts them to floating point values .
      */



   /************************************************************************/
   BOOL WriteHeader( T_ChunkInfo *pChunkInfo );
   BOOL OutOpen( // Opens an output file, or audio stream .
                char *file_name,
                int  options,         // AUDIO_FILE_OPTION_TIMESTAMPS , ... (bitflags)
                int channels,
                int nominal_sample_rate, // [in] 'nominal' sample rate (44100, 48000, etc)
                float base_quality,   // Desired quality level, currently from -0.1 to 1.0 (lo to hi).
                double dblStartTime );
     /*  Detailed description of arguments in VorbisFileIO.cpp only.
      */



   /***************************************************************************/
   LONG WriteSamples_Float(  // app-layer output, using NORMALIZED floats
       T_Float *pfltSrc,     // points to the caller's source buffer, 32-bit floats
       T_ChunkInfo *pChunkInfo, // number of samples, channels, precise sample rate, 'radio frequency', date and time, etc
          // btw, T_ChunkInfo is defined in c:\cbproj\SoundUtl\ChunkInfo.h .
       char * pszExtraInfo); // extra 'info' (usually 'data') added to info chunk
     /* Writes some samples in the 'normalized' floating point format (-1.0 ... +1.0)
      *       to an audio file which has been opened for WRITING.
      * Returns the number of SAMPLE POINTS written,
      *       or a NEGATIVE value if there was an error.
      */

   LONGLONG GetNumSamplesWritten(void);
   long GetCurrentBitrate(void);  // measures the compressed bitrate [bit/sec]
   int  GetTxBufferUsage_kByte(void);
   int  GetInetPeakWaitTime_ms(BOOL fReset);
   int  GetInetCurrWaitTime_ms(void);

   /************************************************************************/
   BOOL IsOpenedForReading(void);
   BOOL IsOpenedForWriting(void);
   BOOL IsStreamButNoFile(void); // -> TRUE=stream, FALSE=local file

   /************************************************************************/
   // Added 2014-04 to support MULTIPLE STREAM CLIENTS ('receivers')
   //               fed by a SINGLE STREAM SERVER ('transmitter')
   //               which only holds the latest few seconds (actually, Ogg pages)
   //               in memory, and a buffer with the three mandatory headers
   //               which will be sent first when a client connects
   //               to SL's built-in HTTP server.
   //   For details, see VorbisFileIO.cpp .
   int GetInitialHeadersForStreamOutputServer( // returns the number of bytes actually placed in pbDest
           BYTE *pbDest,  int iMaxDestLength,  // Called by the HTTP server for each new client which attaches to the outbound stream.
           DWORD *pdwPageIndex); // [out] indicator for the next call of GetNextPagesForStreamOutputServer()

   int GetNextPagesForStreamOutputServer( // returns the number of bytes actually placed in pbDest
           BYTE *pbDest, int iMaxDestLength, // Periodically called by the HTTP server to send more samples to a remote client.
           DWORD *pdwPageIndex); // [in,out] indicator for the next call of GetNextPagesForStreamOutputServer()
   int GetNumPagesAvailableForStreamOutput(
           DWORD dwPageIndex);   // [in] indicator for the next call of GetNextPagesForStreamOutputServer()


   /************************************************************************/
   // Some more 'Get' - and 'Set' - functions for the AUDIO FILE class ..
   int    GetFileFormat(void);  // -> AUDIO_FILE_FORMAT_OGG, AUDIO_FILE_FORMAT_STREAM_WITH_HEADERS, and maybe more
   void   GetFileName(char *pszDest, int iMaxLen);

   char  *GetLastErrorAsString(void);           // for diagnostic purposes

   double GetSampleRate(void);
   void   SetSampleRate(double dblSampleRate);

   int    GetNrChannels(void);
   void   SetNrChannels(int iNrChannels);       // important to read headerless RAW files

   void   GetDataType(int *piSizeOfDataType, int *piDataTypeFlags);  // deprecated
   int    GetBitsPerSample(void); // ex: 16 (fixed value)

   double GetFrequencyOffset(void); // difference between "radio-" minus "baseband-" frequency (internal NCO + other internal frequency shift + external VFO )
   BOOL   SetFrequencyOffset(double dblFrequencyOffset);

   double GetCurrentRecordingTime(void); // see specification in c:\cbproj\SoundUtl\AudioFileIO.h (t=0 is the RECORDING START TIME, aka "track time")
   double GetRecordingStartTime(void);   // seconds elapsed since 00:00:00 GMT, January 1, 1970.
   void   SetRecordingStartTime(double dblStartTime);

   bool   AllParamsIncluded(void);

   long   GetParameterByID( int iAudioFileParam ); // Replaces several older GET-functions.
            // iAudioFileParam: one of the AUDIO_FILE_PARAM_..values from AudioFileDefs.h .
            // Replaces a bundle of older, rarely used, "Set"-functions since 02/2015,
            // for example GetVTFlags() -> GetParameterByID(AUDIO_FILE_PARAM__VLF_TOOL_FLAGS) .
   BOOL   SetParameterByID( int iAudioFileParam, long i32NewValue ); // Replaces several older SET-functions.
            // Returns TRUE if the new value could be set, otherwise FALSE.
            // Replaces a bundle of older, rarely used, "Set"-functions since 02/2015,
            // for example SetVTFlags(iVTFlags) -> SetParameterByID(AUDIO_FILE_PARAM__VLF_TOOL_FLAGS,..) .
   double GetParameterByID_Double(int iAudioFileParam); // similar as above, for 64-bit "double" ..
   BOOL   SetParameterByID_Double(int iAudioFileParam, double dblNewValue);



   /************************************************************************/
   BOOL CloseFile( char *pszWhy );
     /* Closes the WAV-file (if opened for READING exor WRITING.
      * Returns TRUE on success and FALSE on any error.
      * pszWhy may be NULL, if no 'reason' shall be emitted into the log
      *                     why a file / stream was closed .
      */

public:  // should be private, but must be public to access the following stuff from internal non-C++-functions:
   // Properties for reading RAW FILES . Should be set before opening such files for reading.
   // Automatically set when opening a NON-COMPRESSED file with 'headers'.
   int   m_iSizeOfDataType, m_iDataTypeFlags;
   int   m_nChannelsPerSampleInFile;
   DWORD m_dwCurrFilePos;     // current file access position
   DWORD m_dwFileSizeInBytes; // contains what the name says (even after closing a file)


private:
   //  Because VorbisFileIO.H shall be 'includeable' WITHOUT
   //  including all those zillion headers from libogg and libvorbis,
   //  all Vorbis-specific data structures are hidden here :
   void *m_pVorbisFileHelper; // actually a pointer to a T_VorbisFileHelper struct
     // (type is only known & defined in the IMPLEMENTATION, not in the HEADER)
     // pVorbisFileHelper is NULL as long as no T_VorbisFileHelper has been
     // allocated from an internal pool of such objects; see VorbisFileIO.cpp .
   BOOL   m_EndOfOutput;     // nothing more to be expected from vorbisfile::ov_read()
   double m_dbl_SampleRate;     // will be private sooner or later..
   double m_dblFrequencyOffset; // "radio-" minus "baseband"-frequency
   long double m_ldblPrevCheckedTimestamp; // only for debugging, to check timestamps for plausibility

   char  m_sz255FileName[256];  // ... or URL ! !
   DWORD m_dwCurrentSampleIndex;
   DWORD m_dwFileLengthInSamples;


   // Note: the OGG/VORBIS specific stuff is NOT HERE ANYMORE,
   //       but in VorbisFileIO.cpp !
   char   m_cErrorString[256]; // contains last error description as a string

   BOOL InOpenInternal( char *pszFileName, int options, BOOL fReOpenForWriting );
   // BOOL WriteOggPage( void ); // not required as a class member
   BOOL CloseAndReturnWithError( char *pszErrorMessage, ... );


}; /* end class C_VorbisFileIO */


#endif // _VORBIS_FILE_IO_H_

/* EOF <VorbisFileIO.h> */